/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid.gtk;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface2;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListenerList;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.text.SASFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class BaseGridAxis
extends JComponent
implements GridAxisInterface,
GridAxisInterface2 {
    private Insets prefInner = new Insets(0, 0, 0, 0);
    private Insets prefOuter = new Insets(0, 0, 0, 0);
    protected Insets innerMargin = new Insets(0, 0, 0, 0);
    protected Insets outerMargin = new Insets(0, 0, 0, 0);
    private double xOrig = 0.0;
    private double yOrig = 0.0;
    private Rectangle innerRegion = new Rectangle(0, 0, 0, 0);
    private Rectangle outerRegion = new Rectangle(0, 0, 0, 0);
    private boolean mpcEnabled = true;
    private int mpcLevel = 0;
    protected MarginListenerList mlList = new MarginListenerList();
    protected VRectAxis ra;
    protected Channel channel = new Channel((Component)this, 2);
    private boolean antiAliased = true;
    private boolean subpixelRendering = false;
    protected boolean ignoreOffset = false;
    private boolean innerMarginHasBeenSet = false;
    private boolean mirror;
    private String fitStrategy;
    private boolean weightedByCategories = false;

    public BaseGridAxis() {
        this(1);
    }

    public BaseGridAxis(byte dim) {
        this.channel.glDisable(3);
        this.channel.glDisable(4);
        this.channel.glEnable(1);
        this.ra = new VRectAxis(dim);
        this.ra.setChannel2(this.channel);
        this.setOpaque(false);
    }

    public void setAntiAliased(boolean b) {
        this.antiAliased = b;
    }

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public Insets getPreferredInnerMargin() {
        return this.prefInner;
    }

    public Insets getPreferredOuterMargin() {
        if (this.ra != null) {
            this.fitStrategy = this.ra.getFitStrategy();
        }
        return this.prefOuter;
    }

    public void setInnerMargin(Insets margin) {
        this.innerMargin = margin;
        this.updateRegions();
        this.updateEncoder();
        this.offsets();
        this.position();
        this.innerMarginHasBeenSet = true;
    }

    public void setOuterMargin(Insets margin) {
        this.outerMargin = margin;
        this.updateRegions();
        this.updateEncoder();
        this.offsets();
        this.position();
    }

    public void addMarginListener(MarginListener listener) {
        this.mlList.add(listener);
    }

    public void removeMarginListener(MarginListener listener) {
        this.mlList.remove(listener);
    }

    private void updateEncoder() {
        byte dim = this.ra.getDimension();
        double outMax = dim == 2 ? (double)this.innerRegion.height : (double)this.innerRegion.width;
        double lowerLim = dim == 2 ? (double)(0 - this.innerMargin.bottom) : (double)(0 - this.innerMargin.left);
        double upperLim = dim == 2 ? outMax + (double)this.innerMargin.top : outMax + (double)this.innerMargin.right;
        PositionEncoder pe = (PositionEncoder)this.ra.getEncoder(dim);
        DataRange range = this.ra.getDataRange(dim);
        if (pe == null) {
            pe = new PositionEncoder(range);
        } else {
            pe.setRange(range);
        }
        pe.setReversed(this.ra.isReverse());
        switch (this.ra.getType()) {
            case 1: {
                pe.setType(1);
                break;
            }
            case 5: {
                pe.setType(2);
                break;
            }
            case 6: {
                String[] ticks = this.ra.getDiscreteTicks();
                if (ticks != null && range != null && ((DiscreteRange)range).getValuesSize() != 0) {
                    String label = range.getLabel();
                    SASFormat fmt = range.getColumnFormat();
                    if (fmt == null && range instanceof OrdinalRange) {
                        fmt = DataModel.defaultFormat;
                    }
                    String[] formattedTicks = ticks;
                    if (fmt != null) {
                        String formattedMiss = StatGraph.missingOption;
                        if (range instanceof OrdinalRange) {
                            formattedMiss = fmt.format((Object)new Double(Double.NaN)).trim();
                            if (formattedMiss == null || formattedMiss.equals(".")) {
                                formattedMiss = StatGraph.missingOption;
                            }
                        } else {
                            formattedMiss = fmt.format((Object)" ").trim();
                            if (formattedMiss == null || formattedMiss.length() == 0) {
                                formattedMiss = StatGraph.missingCharacter;
                            }
                        }
                        formattedTicks = new String[ticks.length];
                        for (int j = 0; j < ticks.length; ++j) {
                            if (range instanceof OrdinalRange) {
                                if (ticks[j].equals(".")) {
                                    formattedTicks[j] = formattedMiss;
                                    continue;
                                }
                                if (StatGraph.isNumber(ticks[j])) {
                                    Double dv = new Double(ticks[j]);
                                    formattedTicks[j] = fmt.format((Object)dv).trim();
                                    continue;
                                }
                                formattedTicks[j] = ticks[j];
                                continue;
                            }
                            formattedTicks[j] = ticks[j].trim().length() == 0 ? formattedMiss : fmt.format((Object)ticks[j]);
                        }
                    }
                    DataRange dr = Simple2DOverlayComposite.getModifiedDataRange(range, formattedTicks, this.ra.getTickValueListPolicy());
                    dr.setLabel(label);
                    pe.setRange(dr);
                    break;
                }
                if (this.ra.getTickValueOrder() == 1) {
                    pe.setOrder(1);
                    break;
                }
                if (this.ra.getTickValueOrder() == 2) {
                    pe.setOrder(2);
                    break;
                }
                if (this.ra.getTickValueOrder() == 3) {
                    if (this.ra.isSortTickValueByOverlay()) {
                        pe.setOrder(0);
                        break;
                    }
                    if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                        pe.setOrder(1);
                        break;
                    }
                    pe.setOrder(0);
                    break;
                }
                if (this.ra.getTickValueOrder() == 4) {
                    if (this.ra.isSortTickValueByOverlay()) break;
                    if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                        pe.setOrder(1);
                        break;
                    }
                    pe.setOrder(1);
                    break;
                }
                if (this.ra.getTickValueOrder() == 5) {
                    if (this.ra.isSortTickValueByOverlay()) {
                        pe.setOrder(0);
                        break;
                    }
                    if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                        pe.setOrder(1);
                        break;
                    }
                    pe.setOrder(0);
                    break;
                }
                if (this.ra.getTickValueOrder() == 6) {
                    if (this.ra.isSortTickValueByOverlay()) break;
                    if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                        pe.setOrder(1);
                        break;
                    }
                    pe.setOrder(2);
                    break;
                }
                if (this.ra.getTickValueOrder() == 0) {
                    pe.setOrder(0);
                    break;
                }
                if (this.ra.getTickValueOrder() != -1) break;
                if (this.ra.isSortTickValueByOverlay()) {
                    pe.setOrder(0);
                    break;
                }
                if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                    pe.setOrder(1);
                    break;
                }
                pe.setOrder(0);
                break;
            }
        }
        pe.setOutputMin(0.0);
        pe.setOutputMax(outMax);
        pe.setLowerLimit(lowerLim);
        pe.setUpperLimit(upperLim);
        this.ra.setEncoder(dim, pe);
        if (pe.isReversed() && pe.getValueMap() != null) {
            pe.getValueMap().init((AInitAction)new InitAction(null));
        }
    }

    private void updatePOM() {
        if (!this.mpcEnabled) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            this.setBounds(0, 0, 200, 200);
        }
        if (!this.innerMarginHasBeenSet) {
            this.offsets();
        }
        this.updateEncoder();
        this.ra.draw(null);
        Insets oldPOM = this.prefOuter;
        Insets oldPIM = this.prefInner;
        boolean inner = false;
        boolean textAntialiased = this.channel.glIsEnabled(14);
        if (this.antiAliased) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
        Insets ext = this.ra.getExtent();
        Insets labelExt = this.ra.getLabelExtent();
        if (textAntialiased) {
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(14);
        }
        this.prefInner = new Insets(0, 0, 0, 0);
        if (ext == null) {
            this.prefOuter = new Insets(0, 0, 0, 0);
        } else {
            this.prefOuter = ext;
            if (this.getDimension() == 1) {
                if (this.ra.getMinOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                    this.prefInner.left = this.prefOuter.left + (this.weightedByCategories ? 0 : VRectAxis.OFFSET_MARGIN);
                    this.prefOuter.left = labelExt.left;
                    inner = true;
                } else {
                    this.prefOuter.left += labelExt.left;
                }
                if (this.ra.getMaxOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                    this.prefInner.right = this.prefOuter.right + (this.weightedByCategories ? 0 : VRectAxis.OFFSET_MARGIN);
                    this.prefOuter.right = labelExt.right;
                    inner = true;
                } else {
                    this.prefOuter.right += labelExt.right;
                }
            } else {
                if (this.ra.getMinOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                    this.prefInner.bottom = this.prefOuter.bottom + (this.weightedByCategories ? 0 : VRectAxis.OFFSET_MARGIN);
                    this.prefOuter.bottom = labelExt.bottom;
                    inner = true;
                } else {
                    this.prefOuter.bottom += labelExt.bottom;
                }
                if (this.ra.getMaxOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                    this.prefInner.top = this.prefOuter.top + (this.weightedByCategories ? 0 : VRectAxis.OFFSET_MARGIN);
                    this.prefOuter.top = labelExt.top;
                    inner = true;
                } else {
                    this.prefOuter.top += labelExt.top;
                }
            }
        }
        if (!this.prefOuter.equals(oldPOM)) {
            if (this.mlList.count() != 0) {
                MarginChangeEvent mce = new MarginChangeEvent((Object)this);
                mce.setInnerChanged(inner);
                this.mlList.marginChanged(mce);
                this.invalidate();
            }
        } else if (!this.prefInner.equals(oldPIM) && this.mlList.count() != 0) {
            MarginChangeEvent mce = new MarginChangeEvent((Object)this);
            mce.setInnerChanged(true);
            this.mlList.marginChanged(mce);
            this.invalidate();
        }
    }

    private void offsets() {
        if (this.ignoreOffset) {
            return;
        }
        if (this.ra.getDimension() == 1) {
            this.ra.setStartOffset(this.innerMargin.left);
            this.ra.setEndOffset(this.innerMargin.right);
        } else if (this.ra.getDimension() == 2) {
            this.ra.setStartOffset(this.innerMargin.bottom);
            this.ra.setEndOffset(this.innerMargin.top);
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.channel == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.antiAliased) {
            if (this.subpixelRendering) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.channel.glEnable(13);
            this.channel.glEnable(14);
        } else {
            this.channel.glDisable(13);
            this.channel.glDisable(14);
        }
        this.channel.setSingleBufferGraphics(g);
        this.draw(g);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (!this.innerMarginHasBeenSet) {
            if (this.ra.getDimension() == 1) {
                if (this.ra.getUserStartOffset() >= 0.0) {
                    this.innerMargin.left = (int)((double)width * this.ra.getUserStartOffset());
                }
                if (this.ra.getUserEndOffset() >= 0.0) {
                    this.innerMargin.right = (int)((double)width * this.ra.getUserEndOffset());
                }
            } else if (this.ra.getDimension() == 2) {
                if (this.ra.getUserStartOffset() >= 0.0) {
                    this.innerMargin.top = (int)((double)height * this.ra.getUserStartOffset());
                }
                if (this.ra.getUserEndOffset() >= 0.0) {
                    this.innerMargin.bottom = (int)((double)height * this.ra.getUserEndOffset());
                }
            }
        }
        this.updateRegions();
        this.updateAxisSize();
        this.resize();
        this.repaint();
    }

    private void resize() {
        if (this.channel == null) {
            return;
        }
        double wo2 = (double)this.getWidth() / 2.0;
        double ho2 = (double)this.getHeight() / 2.0;
        this.channel.gluLookAt(wo2, ho2, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.channel.glViewport(0, 0, this.getWidth(), this.getHeight());
        this.channel.glOrtho(-wo2, wo2 + 1.0, -ho2 - 1.0, ho2, -1000.0, 1000.0);
        this.ra.setInitialFitting(true);
        this.updatePOM();
        this.ra.setInitialFitting(false);
        this.updatePOM();
    }

    private void draw(Graphics g) {
        if (this.channel == null) {
            return;
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        this.channel.setSubpixelRendering(this.subpixelRendering);
        if (StatGraph.VGF) {
            this.channel.setSVGRendering(true);
        }
        this.channel.glPushMatrix();
        this.channel.glTranslate(this.xOrig, this.yOrig, 0.0);
        if (this.fitStrategy != null && (this.fitStrategy.equals("truncatedrop") || this.fitStrategy.equals("nolabels") || this.fitStrategy.endsWith("undoforcefit"))) {
            this.ra.setFitStrategy(this.fitStrategy);
        }
        this.ra.draw(g);
        this.channel.glPopMatrix();
        this.channel.setSubpixelRendering(subpixel);
        if (StatGraph.VGF) {
            this.channel.setSVGRendering(false);
        }
    }

    private void position() {
        int xi1 = this.innerRegion.x;
        int yi1 = this.getHeight() - (this.innerRegion.y + this.innerRegion.height);
        int xo1 = this.outerRegion.x;
        int xo2 = this.outerRegion.x + this.outerRegion.width;
        int yo1 = this.getHeight() - (this.outerRegion.y + this.outerRegion.height);
        int yo2 = this.getHeight() - this.outerRegion.y;
        byte dim = this.ra.getDimension();
        boolean primary = this.ra.getPrimary();
        if (dim == 2) {
            this.xOrig = primary ? (double)xo2 : (double)xo1;
            this.yOrig = yi1;
            if (this.subpixelRendering && primary) {
                this.xOrig += 1.0;
            }
        } else if (dim == 1) {
            this.xOrig = xi1;
            double d = this.yOrig = primary ? (double)yo2 : (double)yo1;
            if (this.subpixelRendering && !primary) {
                this.yOrig -= 1.0;
            }
        }
    }

    public Insets getInnerMargin() {
        return this.innerMargin;
    }

    public Insets getOuterMargin() {
        return this.outerMargin;
    }

    private void updateRegions() {
        this.outerRegion.x = this.outerMargin.left;
        this.outerRegion.y = this.outerMargin.top;
        int x2 = this.getWidth() - this.outerMargin.right;
        this.outerRegion.width = x2 - this.outerRegion.x;
        int y2 = this.getHeight() - this.outerMargin.bottom;
        this.outerRegion.height = y2 - this.outerRegion.y;
        if (this.innerMargin.left + this.innerMargin.right > this.outerRegion.width) {
            int left = (int)((double)this.outerRegion.width * (double)this.innerMargin.left / (double)(this.innerMargin.left + this.innerMargin.right));
            int right = (int)((double)this.outerRegion.width * (double)this.innerMargin.right / (double)(this.innerMargin.left + this.innerMargin.right));
            this.innerMargin.left = left;
            this.innerMargin.right = right;
        }
        if (this.innerMargin.top + this.innerMargin.bottom > this.outerRegion.height) {
            int top = (int)((double)this.outerRegion.height * (double)this.innerMargin.top / (double)(this.innerMargin.top + this.innerMargin.bottom));
            int bottom = (int)((double)this.outerRegion.height * (double)this.innerMargin.bottom / (double)(this.innerMargin.top + this.innerMargin.bottom));
            this.innerMargin.top = top;
            this.innerMargin.bottom = bottom;
        }
        this.innerRegion.x = this.outerRegion.x + this.innerMargin.left;
        this.innerRegion.y = this.outerRegion.y + this.innerMargin.top;
        x2 = this.outerRegion.x + this.outerRegion.width - this.innerMargin.right;
        this.innerRegion.width = Math.max(0, x2 - this.innerRegion.x);
        y2 = this.outerRegion.y + this.outerRegion.height - this.innerMargin.bottom;
        this.innerRegion.height = Math.max(0, y2 - this.innerRegion.y);
    }

    private void updateAxisSize() {
        if (this.ra.getVTKAxis() != null) {
            if (!this.ra.getVTKAxis().getStyle().isTitleOn() && !this.ra.getVTKAxis().getStyle().isLabelsOn()) {
                return;
            }
            if (this.getDimension() == 1) {
                this.ra.getVTKAxis().setMaximumSize(new Vec3d((double)this.getBounds().width * 1.25, (double)(this.getBounds().height - 1), 1.0));
            } else {
                this.ra.getVTKAxis().setMaximumSize(new Vec3d((double)(this.getBounds().width - 1), (double)this.getBounds().height * 1.25, 1.0));
            }
        }
    }

    public void enableMarginPrefCalc() {
        if (this.mpcLevel > 0) {
            --this.mpcLevel;
        }
        if (this.mpcLevel == 0) {
            this.mpcEnabled = true;
            this.updatePOM();
        }
    }

    public void disableMarginPrefCalc() {
        this.mpcEnabled = false;
        ++this.mpcLevel;
    }

    public VRectAxis getAxis() {
        return this.ra;
    }

    public boolean isPrimary() {
        return this.ra.getPrimary();
    }

    public void setPrimary(boolean primary) {
        this.ra.setPrimary(primary);
    }

    public byte getDimension() {
        return this.ra.getDimension();
    }

    public void setDimension(byte dim) {
        this.ra.setDimension(dim);
    }

    public void setRange(DataRange range) {
        this.ra.setInputDataRange(range);
        this.updatePOM();
        this.repaint();
    }

    public DataRange getOutputRange() {
        return this.ra.getDataRange(this.ra.getDimension());
    }

    public void setIgnoreOffset(boolean b) {
        this.ignoreOffset = b;
    }

    public void setMirror(boolean b) {
        this.mirror = b;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        if (this.getDimension() == 1) {
            this.ra.setAllocatedSize(maximumSize.getHeight());
        } else if (this.getDimension() == 2) {
            this.ra.setAllocatedSize(maximumSize.getWidth());
        }
        super.setMaximumSize(maximumSize);
    }

    public boolean isWeightedByCategories() {
        return this.weightedByCategories;
    }

    public void setWeightedByCategories(boolean weightedByCategories) {
        this.weightedByCategories = weightedByCategories;
    }
}

