/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JComponent;

public class GridPanel
extends AbstractSGComponent {
    private int _order = 0;
    private int _rows = 0;
    private int _columns = 0;
    private int[] _row = null;
    private int[] _column = null;
    private int[] _rowSpan = null;
    private int[] _columnSpan = null;
    private int[] _rowGutter = null;
    private int[] _columnGutter = null;
    private int[] _rowGrid = null;
    private int[] _columnGrid = null;
    private Color[] _cellBackground = null;
    protected int _cellComponentCount = 0;
    private boolean _changed = false;
    public static final int ROW_MAJOR = 0;
    public static final int COLUMN_MAJOR = 1;

    public GridPanel() {
        super(new GridBagLayout(), false);
    }

    public GridPanel(boolean isDoubleBuffered) {
        super(new GridBagLayout(), isDoubleBuffered);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._cellBackground != null) {
            GridBagLayout l = (GridBagLayout)this.getLayout();
            int[][] dim = l.getLayoutDimensions();
            int[] width = dim[0];
            int[] height = dim[1];
            for (int i = 0; i < this._cellComponentCount; ++i) {
                int row;
                int column;
                if (this.getCellBackground(i).equals(this.getBackground())) continue;
                int column0 = this.getColumn(i);
                int column1 = this.getColumn(i) + this.getColumnSpan(i) - 1;
                int row0 = this.getRow(i);
                int row1 = this.getRow(i) + this.getRowSpan(i) - 1;
                int x = 0;
                int y = 0;
                int w = 0;
                int h = 0;
                for (column = 0; column < 2 * column0 + 1; ++column) {
                    x += width[column];
                }
                while (column <= 2 * column1 + 1) {
                    w += width[column];
                    ++column;
                }
                for (row = 0; row < 2 * row0 + 1; ++row) {
                    y += height[row];
                }
                while (row <= 2 * row1 + 1) {
                    h += height[row];
                    ++row;
                }
                g.setColor(this.getCellBackground(i));
                g.fillRect(x, y, w, h);
            }
        }
    }

    @Override
    public void setLayout(LayoutManager layout) {
        if (layout == null || !(layout instanceof GridBagLayout)) {
            throw new Error("Layout of GridPanel must be a GridBagLayout.");
        }
        super.setLayout(layout);
        this._changed = true;
    }

    public int getOrder() {
        return this._order;
    }

    public void setOrder(int order) {
        if (order == 0 || order == 1) {
            this._order = order;
        }
        this._changed = true;
    }

    public int getRows() {
        if (this._rows == 0 && this.getOrder() == 1) {
            return 1;
        }
        return this._rows;
    }

    public void setRows(int rows) {
        if (rows >= 0) {
            this._rows = rows;
        }
        this._changed = true;
    }

    public int getColumns() {
        if (this._columns == 0 && this.getOrder() == 0) {
            return 1;
        }
        return this._columns;
    }

    public void setColumns(int columns) {
        if (columns >= 0) {
            this._columns = columns;
        }
        this._changed = true;
    }

    public int[] getRow() {
        if (this._row != null) {
            return this._row;
        }
        int[] row = new int[this._cellComponentCount];
        for (int i = 0; i < this._cellComponentCount; ++i) {
            row[i] = this.getRow(i);
        }
        return row;
    }

    public void setRow(int[] row) {
        this._row = row;
        this._changed = true;
    }

    public int getRow(int i) {
        if (this._row != null) {
            return 0 <= i && i < this._row.length ? this._row[i] : 0;
        }
        if (this.getOrder() == 0) {
            int numCols = this.getColumns();
            return numCols > 0 ? i / numCols : 0;
        }
        int numRows = this.getRows();
        return numRows > 0 ? i % numRows : i;
    }

    public void setRow(int i, int row) {
        if (this._row == null || this._row.length <= i) {
            int[] newArray = new int[i + 1];
            if (this._row != null) {
                System.arraycopy(this._row, 0, newArray, 0, this._row.length);
            }
            this._row = newArray;
        }
        this._row[i] = row;
        this._changed = true;
    }

    public int[] getColumn() {
        if (this._column != null) {
            return this._column;
        }
        int[] column = new int[this._cellComponentCount];
        for (int i = 0; i < this._cellComponentCount; ++i) {
            column[i] = this.getColumn(i);
        }
        return column;
    }

    public void setColumn(int[] column) {
        this._column = column;
        this._changed = true;
    }

    public int getColumn(int i) {
        if (this._column != null) {
            return 0 <= i && i < this._column.length ? this._column[i] : 0;
        }
        if (this.getOrder() == 0) {
            int numCols = this.getColumns();
            return numCols > 0 ? i % numCols : i;
        }
        int numRows = this.getRows();
        return numRows > 0 ? i / numRows : 0;
    }

    public void setColumn(int i, int column) {
        if (this._column == null || this._column.length <= i) {
            int[] newArray = new int[i + 1];
            if (this._column != null) {
                System.arraycopy(this._column, 0, newArray, 0, this._column.length);
            }
            this._column = newArray;
        }
        this._column[i] = column;
        this._changed = true;
    }

    public int[] getRowSpan() {
        if (this._rowSpan != null) {
            return this._rowSpan;
        }
        int[] rowSpan = new int[this._cellComponentCount];
        for (int i = 0; i < this._cellComponentCount; ++i) {
            rowSpan[i] = this.getRowSpan(i);
        }
        return rowSpan;
    }

    public void setRowSpan(int[] rowSpan) {
        this._rowSpan = rowSpan;
        this._changed = true;
    }

    public int getRowSpan(int i) {
        if (this._rowSpan != null && i < this._rowSpan.length) {
            return this._rowSpan[i];
        }
        return 1;
    }

    public void setRowSpan(int i, int rowSpan) {
        if (this._rowSpan == null || this._rowSpan.length <= i) {
            int[] newArray = new int[i + 1];
            for (int j = 0; j < i + 1; ++j) {
                newArray[j] = 1;
            }
            if (this._rowSpan != null) {
                System.arraycopy(this._rowSpan, 0, newArray, 0, this._rowSpan.length);
            }
            this._rowSpan = newArray;
        }
        this._rowSpan[i] = rowSpan;
        this._changed = true;
    }

    public int[] getColumnSpan() {
        if (this._columnSpan != null) {
            return this._columnSpan;
        }
        int[] columnSpan = new int[this._cellComponentCount];
        for (int i = 0; i < this._cellComponentCount; ++i) {
            columnSpan[i] = this.getColumnSpan(i);
        }
        return columnSpan;
    }

    public void setColumnSpan(int[] columnSpan) {
        this._columnSpan = columnSpan;
        this._changed = true;
    }

    public int getColumnSpan(int i) {
        if (this._columnSpan != null && i < this._columnSpan.length) {
            return this._columnSpan[i];
        }
        return 1;
    }

    public void setColumnSpan(int i, int columnSpan) {
        if (this._columnSpan == null || this._columnSpan.length <= i) {
            int[] newArray = new int[i + 1];
            for (int j = 0; j < i + 1; ++j) {
                newArray[j] = 1;
            }
            if (this._columnSpan != null) {
                System.arraycopy(this._columnSpan, 0, newArray, 0, this._columnSpan.length);
            }
            this._columnSpan = newArray;
        }
        this._columnSpan[i] = columnSpan;
        this._changed = true;
    }

    public int[] getRowGutter() {
        return this._rowGutter;
    }

    public void setRowGutter(int[] rowGutter) {
        this._rowGutter = rowGutter;
        this._changed = true;
    }

    public void setRowGutters(int rowGutter) {
        int nRows;
        if (this._cellComponentCount == 0) {
            return;
        }
        if (this.getOrder() == 1) {
            nRows = this.getRows();
            if (nRows > this._cellComponentCount) {
                nRows = this._cellComponentCount;
            }
        } else {
            int nCols = this.getColumns();
            if (nCols > this._cellComponentCount) {
                nCols = this._cellComponentCount;
            }
            nRows = (this._cellComponentCount + nCols - 1) / nCols;
        }
        int[] gutters = new int[nRows + 1];
        gutters[nRows] = 0;
        gutters[0] = 0;
        for (int i = 1; i < nRows; ++i) {
            gutters[i] = rowGutter;
        }
        this.setRowGutter(gutters);
    }

    public int getRowGutter(int i) {
        if (this._rowGutter != null && i < this._rowGutter.length) {
            return this._rowGutter[i];
        }
        return 0;
    }

    public void setRowGutter(int i, int rowGutter) {
        if (this._rowGutter == null || this._rowGutter.length <= i) {
            int[] newArray = new int[i + 1];
            if (this._rowGutter != null) {
                System.arraycopy(this._rowGutter, 0, newArray, 0, this._rowGutter.length);
            }
            this._rowGutter = newArray;
        }
        this._rowGutter[i] = rowGutter;
        this._changed = true;
    }

    public int[] getColumnGutter() {
        return this._columnGutter;
    }

    public void setColumnGutter(int[] columnGutter) {
        this._columnGutter = columnGutter;
        this._changed = true;
    }

    public void setColumnGutters(int colGutter) {
        int nCols;
        if (this._cellComponentCount == 0) {
            return;
        }
        if (this.getOrder() == 0) {
            nCols = this.getColumns();
            if (nCols > this._cellComponentCount) {
                nCols = this._cellComponentCount;
            }
        } else {
            int nRows = this.getRows();
            if (nRows > this._cellComponentCount) {
                nRows = this._cellComponentCount;
            }
            nCols = (this._cellComponentCount + nRows - 1) / nRows;
        }
        int[] gutters = new int[nCols + 1];
        gutters[nCols] = 0;
        gutters[0] = 0;
        for (int i = 1; i < nCols; ++i) {
            gutters[i] = colGutter;
        }
        this.setColumnGutter(gutters);
    }

    public int getColumnGutter(int i) {
        if (this._columnGutter != null && i < this._columnGutter.length) {
            return this._columnGutter[i];
        }
        return 0;
    }

    public void setColumnGutter(int i, int columnGutter) {
        if (this._columnGutter == null || this._columnGutter.length <= i) {
            int[] newArray = new int[i + 1];
            if (this._columnGutter != null) {
                System.arraycopy(this._columnGutter, 0, newArray, 0, this._columnGutter.length);
            }
            this._columnGutter = newArray;
        }
        this._columnGutter[i] = columnGutter;
        this._changed = true;
    }

    public int[] getRowGrid() {
        return this._rowGrid;
    }

    public void setRowGrid(int[] rowGrid) {
        this._rowGrid = rowGrid;
        this._changed = true;
    }

    public int getRowGrid(int i) {
        if (this._rowGrid != null && i < this._rowGrid.length) {
            return this._rowGrid[i];
        }
        return 0;
    }

    public void setRowGrid(int i, int rowGrid) {
        if (this._rowGrid == null || this._rowGrid.length <= i) {
            int[] newArray = new int[i + 1];
            if (this._rowGrid != null) {
                System.arraycopy(this._rowGrid, 0, newArray, 0, this._rowGrid.length);
            }
            this._rowGrid = newArray;
        }
        this._rowGrid[i] = rowGrid;
        this._changed = true;
    }

    public int[] getColumnGrid() {
        return this._columnGrid;
    }

    public void setColumnGrid(int[] columnGrid) {
        this._columnGrid = columnGrid;
        this._changed = true;
    }

    public int getColumnGrid(int i) {
        if (this._columnGrid != null && i < this._columnGrid.length) {
            return this._columnGrid[i];
        }
        return 0;
    }

    public void setColumnGrid(int i, int columnGrid) {
        if (this._columnGrid == null || this._columnGrid.length <= i) {
            int[] newArray = new int[i + 1];
            if (this._columnGrid != null) {
                System.arraycopy(this._columnGrid, 0, newArray, 0, this._columnGrid.length);
            }
            this._columnGrid = newArray;
        }
        this._columnGrid[i] = columnGrid;
        this._changed = true;
    }

    public Color[] getCellBackground() {
        if (this._cellBackground != null) {
            return this._cellBackground;
        }
        Color[] cellBackground = new Color[this._cellComponentCount];
        for (int i = 0; i < this._cellComponentCount; ++i) {
            cellBackground[i] = this.getCellBackground(i);
        }
        return cellBackground;
    }

    public void setCellBackground(Color[] cellBackground) {
        this.setOpaque(true);
        this._cellBackground = cellBackground;
        this._changed = true;
    }

    public Color getCellBackground(int i) {
        if (this._cellBackground != null && i < this._cellBackground.length) {
            return this._cellBackground[i];
        }
        return this.getBackground();
    }

    public void setCellBackground(int i, Color cellBackground) {
        this.setOpaque(true);
        if (this._cellBackground == null || this._cellBackground.length <= i) {
            Color[] newArray = new Color[i + 1];
            for (int j = 0; j < i + 1; ++j) {
                newArray[j] = this.getBackground();
            }
            if (this._cellBackground != null) {
                System.arraycopy(this._cellBackground, 0, newArray, 0, this._cellBackground.length);
            }
            this._cellBackground = newArray;
        }
        this._cellBackground[i] = cellBackground;
        this._changed = true;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof Gutter)) {
            ++this._cellComponentCount;
        }
        super.addImpl(comp, constraints, index);
        this._changed = true;
    }

    @Override
    public void remove(int index) {
        if (index < this._cellComponentCount) {
            --this._cellComponentCount;
        }
        super.remove(index);
        this._changed = true;
    }

    @Override
    public void removeAll() {
        this._cellComponentCount = 0;
        super.removeAll();
        this._changed = true;
    }

    @Override
    public Dimension getMaximumSize() {
        if (this._changed) {
            this.doLayout();
        }
        return super.getMaximumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._changed) {
            this.doLayout();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._changed) {
            this.doLayout();
        }
        return super.getPreferredSize();
    }

    @Override
    public void doLayout() {
        if (this._changed) {
            GridBagConstraints c;
            int i;
            for (int i2 = this.getComponentCount() - 1; i2 >= 0; --i2) {
                if (!(this.getComponent(i2) instanceof Gutter)) continue;
                super.remove(i2);
            }
            GridBagLayout l = (GridBagLayout)this.getLayout();
            for (int i3 = 0; i3 < this._cellComponentCount; ++i3) {
                if (i3 >= this.getComponentCount()) continue;
                Component comp = this.getComponent(i3);
                GridBagConstraints c2 = l.getConstraints(comp);
                c2.gridx = this.getColumn(i3);
                c2.gridy = this.getRow(i3);
                c2.gridwidth = this.getColumnSpan(i3);
                c2.gridheight = this.getRowSpan(i3);
                l.setConstraints(comp, c2);
            }
            int rows = 0;
            int columns = 0;
            boolean spanning = false;
            boolean gutters = this._rowGutter != null || this._columnGutter != null || this._rowGrid != null || this._columnGrid != null || this._cellBackground != null;
            for (int i4 = 0; i4 < this._cellComponentCount; ++i4) {
                if (i4 >= this.getComponentCount()) continue;
                Component comp = this.getComponent(i4);
                GridBagConstraints c3 = l.getConstraints(comp);
                if (rows < c3.gridy + c3.gridheight) {
                    rows = c3.gridy + c3.gridheight;
                }
                if (columns < c3.gridx + c3.gridwidth) {
                    columns = c3.gridx + c3.gridwidth;
                }
                if (c3.gridwidth > 1 || c3.gridheight > 1) {
                    spanning = true;
                }
                if (!gutters) continue;
                c3.gridx = c3.gridx * 2 + 1;
                c3.gridy = c3.gridy * 2 + 1;
                c3.gridwidth = c3.gridwidth * 2 - 1;
                c3.gridheight = c3.gridheight * 2 - 1;
                l.setConstraints(comp, c3);
            }
            int componentCount = this._cellComponentCount;
            if (gutters) {
                componentCount += (2 * rows + 1) * (2 * columns + 1) - rows * columns;
            }
            while (this.getComponentCount() < componentCount) {
                Gutter g = new Gutter();
                g.setForeground(this.getForeground());
                if (this.isComponentOpaque()) {
                    g.setBackground(this.getBackground());
                }
                this.add(g);
            }
            int x = 0;
            int y = 0;
            for (i = this._cellComponentCount; i < componentCount; ++i) {
                Gutter gutter = (Gutter)this.getComponent(i);
                c = l.getConstraints(gutter);
                int xmod2 = x % 2;
                int ymod2 = y % 2;
                int xdiv2 = x / 2;
                int ydiv2 = y / 2;
                c.gridx = x;
                c.gridy = y;
                if (xmod2 == 1) {
                    c.fill = 2;
                }
                if (ymod2 == 1) {
                    c.fill = 3;
                }
                l.setConstraints(gutter, c);
                int columnGrid = 0;
                if (xmod2 == 0) {
                    columnGrid = this.getColumnGrid(xdiv2);
                }
                int rowGrid = 0;
                if (ymod2 == 0) {
                    rowGrid = this.getRowGrid(ydiv2);
                }
                int columnGutter = 0;
                if (xmod2 == 0) {
                    columnGutter = this.getColumnGutter(xdiv2);
                }
                columnGutter = Math.max(columnGutter, columnGrid);
                int rowGutter = 0;
                if (ymod2 == 0) {
                    rowGutter = this.getRowGutter(ydiv2);
                }
                rowGutter = Math.max(rowGutter, rowGrid);
                gutter.setPreferredSize(new Dimension(columnGutter, rowGutter));
                if (columnGrid > 0 && rowGrid > 0) {
                    int line = 3;
                    if (x == 0 && y == 0) {
                        line = 16;
                    } else if (x == 0 && y == 2 * rows) {
                        line = 17;
                    } else if (x == 2 * columns && y == 0) {
                        line = 18;
                    } else if (x == 2 * columns && y == 2 * rows) {
                        line = 19;
                    } else if (x == 0) {
                        line = 10;
                    } else if (x == 2 * columns) {
                        line = 11;
                    } else if (y == 0) {
                        line = 8;
                    } else if (y == 2 * rows) {
                        line = 9;
                    }
                    gutter.setLine(line);
                    gutter.setVerticalThickness(columnGrid);
                    gutter.setHorizontalThickness(rowGrid);
                } else if (columnGrid > 0) {
                    if (x == 0) {
                        gutter.setLine(6);
                    } else if (x == 2 * columns) {
                        gutter.setLine(7);
                    } else {
                        gutter.setLine(1);
                    }
                    gutter.setVerticalThickness(columnGrid);
                } else if (rowGrid > 0) {
                    if (y == 0) {
                        gutter.setLine(4);
                    } else if (y == 2 * rows) {
                        gutter.setLine(5);
                    } else {
                        gutter.setLine(2);
                    }
                    gutter.setHorizontalThickness(rowGrid);
                }
                if (this.isComponentOpaque() && this.getCellBackground() != null) {
                    int x0 = xdiv2;
                    int x1 = xdiv2;
                    if (x % 2 == 0) {
                        x0 = Math.max(x0 - 1, 0);
                        x1 = Math.min(x1, columns - 1);
                    }
                    int y0 = ydiv2;
                    int y1 = ydiv2;
                    if (y % 2 == 0) {
                        y0 = Math.max(y0 - 1, 0);
                        y1 = Math.min(y1, rows - 1);
                    }
                    Color[] quadBack = new Color[]{null, null, null, null};
                    for (int j = 0; j < this._cellComponentCount; ++j) {
                        int row0 = this.getRow(j);
                        int row1 = row0 + this.getRowSpan(j) - 1;
                        int column0 = this.getColumn(j);
                        int column1 = column0 + this.getColumnSpan(j) - 1;
                        Color back = this.getCellBackground(j);
                        if (row0 <= y0 && y0 <= row1) {
                            if (column0 <= x0 && x0 <= column1) {
                                quadBack[0] = back;
                            }
                            if (column0 <= x1 && x1 <= column1) {
                                quadBack[1] = back;
                            }
                        }
                        if (row0 > y1 || y1 > row1) continue;
                        if (column0 <= x0 && x0 <= column1) {
                            quadBack[2] = back;
                        }
                        if (column0 > x1 || x1 > column1) continue;
                        quadBack[3] = back;
                    }
                    gutter.setQuadBack(quadBack);
                }
                if (++x == 2 * columns + 1) {
                    x = 0;
                    ++y;
                    continue;
                }
                if (x % 2 != 1 || y % 2 != 1) continue;
                ++x;
            }
            if (gutters && spanning) {
                for (i = 0; i < this._cellComponentCount; ++i) {
                    Component comp = this.getComponent(i);
                    c = l.getConstraints(comp);
                    if (c.gridwidth <= 1 && c.gridheight <= 1) continue;
                    for (int j = this.getComponentCount() - 1; j >= this._cellComponentCount; --j) {
                        Gutter gutter = (Gutter)this.getComponent(j);
                        GridBagConstraints cg = l.getConstraints(gutter);
                        if (c.gridx > cg.gridx || cg.gridx >= c.gridx + c.gridwidth || c.gridy > cg.gridy || cg.gridy >= c.gridy + c.gridheight) continue;
                        if (gutter.getLine() != 0) {
                            GridBagConstraints ca;
                            int k;
                            if (cg.gridy % 2 == 0 && cg.gridx > 0) {
                                Gutter left = (Gutter)this.getComponent(j - 1);
                                if (left.getLine() == 3) {
                                    left.setLine(15);
                                } else if (left.getLine() == 14) {
                                    left.setLine(1);
                                } else if (left.getLine() == 10) {
                                    left.setLine(6);
                                }
                            }
                            if (cg.gridy % 2 == 0 && cg.gridx < 2 * columns) {
                                Gutter right = (Gutter)this.getComponent(j + 1);
                                if (right.getLine() == 3) {
                                    right.setLine(14);
                                } else if (right.getLine() == 15) {
                                    right.setLine(1);
                                } else if (right.getLine() == 11) {
                                    right.setLine(7);
                                }
                            }
                            if (cg.gridx % 2 == 0 && cg.gridy > 0) {
                                Gutter above = null;
                                for (k = j - 1; k >= this._cellComponentCount && above == null; --k) {
                                    above = (Gutter)this.getComponent(k);
                                    ca = l.getConstraints(above);
                                    if (ca.gridx == cg.gridx) continue;
                                    above = null;
                                }
                                if (above != null) {
                                    if (above.getLine() == 3) {
                                        above.setLine(13);
                                    } else if (above.getLine() == 12) {
                                        above.setLine(2);
                                    } else if (above.getLine() == 8) {
                                        above.setLine(4);
                                    }
                                }
                            }
                            if (cg.gridx % 2 == 0 && cg.gridy < 2 * rows) {
                                Gutter below = null;
                                for (k = j + 1; k < this.getComponentCount() && below == null; ++k) {
                                    below = (Gutter)this.getComponent(k);
                                    ca = l.getConstraints(below);
                                    if (ca.gridx == cg.gridx) continue;
                                    below = null;
                                }
                                if (below != null) {
                                    if (below.getLine() == 3) {
                                        below.setLine(12);
                                    } else if (below.getLine() == 13) {
                                        below.setLine(2);
                                    } else if (below.getLine() == 9) {
                                        below.setLine(5);
                                    }
                                }
                            }
                        }
                        this.remove(gutter);
                    }
                }
            }
        }
        super.doLayout();
        this._changed = false;
    }

    class Gutter
    extends JComponent {
        private int _line = 0;
        private int _verticalThickness = 0;
        private int _horizontalThickness = 0;
        private Color[] _quadBack = null;
        public static final int NONE = 0;
        public static final int VERTICAL = 1;
        public static final int HORIZONTAL = 2;
        public static final int CENTER = 3;
        public static final int TOP = 4;
        public static final int BOTTOM = 5;
        public static final int LEFT = 6;
        public static final int RIGHT = 7;
        public static final int TOP_T = 8;
        public static final int BOTTOM_T = 9;
        public static final int LEFT_T = 10;
        public static final int RIGHT_T = 11;
        public static final int TOP_HALF_T = 12;
        public static final int BOTTOM_HALF_T = 13;
        public static final int LEFT_HALF_T = 14;
        public static final int RIGHT_HALF_T = 15;
        public static final int UPPER_LEFT = 16;
        public static final int LOWER_LEFT = 17;
        public static final int UPPER_RIGHT = 18;
        public static final int LOWER_RIGHT = 19;

        public Gutter() {
            this.setOpaque(true);
        }

        public int getLine() {
            return this._line;
        }

        public void setLine(int line) {
            this._line = line;
        }

        public int getVerticalThickness() {
            return this._verticalThickness;
        }

        public void setVerticalThickness(int verticalThickness) {
            this._verticalThickness = verticalThickness;
        }

        public int getHorizontalThickness() {
            return this._horizontalThickness;
        }

        public void setHorizontalThickness(int horizontalThickness) {
            this._horizontalThickness = horizontalThickness;
        }

        public Color[] getQuadBack() {
            return this._quadBack;
        }

        public void setQuadBack(Color[] quadBack) {
            this._quadBack = quadBack;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x0 = this.getSize().width / 2;
            int y0 = this.getSize().height / 2;
            int x1 = (this.getSize().width + 1) / 2;
            int y1 = (this.getSize().height + 1) / 2;
            if (this._quadBack != null && this._quadBack.length == 4) {
                if (this._quadBack[0] != null && this._quadBack[0] != this.getBackground()) {
                    g.setColor(this._quadBack[0]);
                    g.fillRect(0, 0, x1, y1);
                }
                if (this._quadBack[1] != null && this._quadBack[1] != this.getBackground()) {
                    g.setColor(this._quadBack[1]);
                    g.fillRect(x0, 0, x1, y1);
                }
                if (this._quadBack[2] != null && this._quadBack[2] != this.getBackground()) {
                    g.setColor(this._quadBack[2]);
                    g.fillRect(0, y0, x1, y1);
                }
                if (this._quadBack[3] != null && this._quadBack[3] != this.getBackground()) {
                    g.setColor(this._quadBack[3]);
                    g.fillRect(x0, y0, x1, y1);
                }
            }
            x1 = this.getSize().width - 1;
            y1 = this.getSize().height - 1;
            g.setColor(this.getForeground());
            switch (this._line) {
                case 1: {
                    g.drawLine(x0, 0, x0, y1);
                    break;
                }
                case 2: {
                    g.drawLine(0, y0, x1, y0);
                    break;
                }
                case 3: {
                    g.drawLine(x0, 0, x0, y1);
                    g.drawLine(0, y0, x1, y0);
                    break;
                }
                case 4: {
                    g.drawLine(0, 0, x1, 0);
                    break;
                }
                case 5: {
                    g.drawLine(0, y1, x1, y1);
                    break;
                }
                case 6: {
                    g.drawLine(0, 0, 0, y1);
                    break;
                }
                case 7: {
                    g.drawLine(x1, 0, x1, y1);
                    break;
                }
                case 8: {
                    g.drawLine(0, 0, x1, 0);
                    g.drawLine(x0, 0, x0, y1);
                    break;
                }
                case 9: {
                    g.drawLine(0, y1, x1, y1);
                    g.drawLine(x0, 0, x0, y1);
                    break;
                }
                case 10: {
                    g.drawLine(0, 0, 0, y1);
                    g.drawLine(0, y0, x1, y0);
                    break;
                }
                case 11: {
                    g.drawLine(x1, 0, x1, y1);
                    g.drawLine(0, y0, x1, y0);
                    break;
                }
                case 12: {
                    g.drawLine(0, y0, x1, y0);
                    g.drawLine(x0, y0, x0, y1);
                    break;
                }
                case 13: {
                    g.drawLine(0, y0, x1, y0);
                    g.drawLine(x0, y0, x0, 0);
                    break;
                }
                case 14: {
                    g.drawLine(x0, 0, x0, y1);
                    g.drawLine(x0, y0, x1, y0);
                    break;
                }
                case 15: {
                    g.drawLine(x0, 0, x0, y1);
                    g.drawLine(0, y0, x0, y0);
                    break;
                }
                case 16: {
                    g.drawLine(0, 0, 0, y1);
                    g.drawLine(0, 0, x1, 0);
                    break;
                }
                case 17: {
                    g.drawLine(0, 0, 0, y1);
                    g.drawLine(0, y1, x1, y1);
                    break;
                }
                case 18: {
                    g.drawLine(x1, 0, x1, y1);
                    g.drawLine(0, 0, x1, 0);
                    break;
                }
                case 19: {
                    g.drawLine(x1, 0, x1, y1);
                    g.drawLine(0, y1, x1, y1);
                    break;
                }
            }
        }
    }
}

