/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.LinkedHashMap;

public class GridLabelEntry
extends Entry {
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    private int position = 2;
    private LinkedHashMap labels = new LinkedHashMap();
    private LinkedHashMap titles;
    private Channel channel = new Channel((Component)this, 2);
    private NetworkRoot networkRoot;
    private boolean setup = false;

    public GridLabelEntry(int position) {
        this();
        this.position = position;
    }

    public GridLabelEntry() {
        this.channel.glEnable(29);
        this.channel.glDisable(3);
        this.channel.glDisable(4);
        this.channel.glEnable(1);
        this.channel.setMinScaleValue(Double.MIN_VALUE);
        this.networkRoot = new NetworkRoot(this.channel);
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (w == 0 || h == 0) {
            return;
        }
        super.setBounds(x, y, w, h);
        this.channel.glViewport(0, 0, w, h);
        double w2 = (double)w * 0.5;
        double h2 = (double)h * 0.5;
        int depth = Math.max(w, h);
        this.channel.gluLookAt(w2, h2, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.channel.glOrtho(-w2, w2, -h2, h2, -1000.0 * (double)depth, 1000.0 * (double)depth);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g);
        if (this.isTextAntiAliased()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.channel.glEnable(14);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.channel.glDisable(14);
        }
        this.channel.setSingleBufferGraphics(g);
        this.channel.setTransparentBackground(true);
        if (this.setup) {
            this.networkRoot.removeAllElements();
            Object[] labObj = this.labels.values().toArray();
            for (int i = 0; i < labObj.length; ++i) {
                RasterLabel[] rasterlabels = (RasterLabel[])labObj[i];
                for (int r = 0; r < rasterlabels.length; ++r) {
                    RasterLabel l = rasterlabels[r];
                    this.networkRoot.addElement((Element)l);
                }
            }
            if (this.titles != null) {
                Object[] titObj = this.titles.values().toArray();
                for (int i = 0; i < titObj.length; ++i) {
                    RasterLabel[] rasterlabels = (RasterLabel[])titObj[i];
                    for (int r = 0; r < rasterlabels.length; ++r) {
                        RasterLabel l = rasterlabels[r];
                        this.networkRoot.addElement((Element)l);
                    }
                }
            }
            this.setup = false;
        }
        this.networkRoot.draw();
    }

    public void addLabel(RasterLabel[] lab, Object id) {
        this.labels.put(id, lab);
        this.setup = true;
    }

    public void addTitle(RasterLabel[] tit, Object id) {
        if (this.titles == null) {
            this.titles = new LinkedHashMap();
        }
        this.titles.put(id, tit);
        this.setup = true;
    }
}

