/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.image.BevelFilter;
import com.sas.graphics.image.BlendFilter;
import com.sas.graphics.image.GlowFilter;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.UserDefinedCharacterMarker;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import com.sas.graphics.vgf.VGFGraphics2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.BreakIterator;
import java.util.ArrayList;
import javax.swing.text.DefaultStyledDocument;

public class Entry
extends AbstractSGComponent
implements Cloneable {
    private boolean _dataAntiAliased = false;
    private boolean _textAntiAliased = false;
    private String _text = null;
    private String _shortText = null;
    private boolean _isWrap = false;
    private int _wrapWidth = 0;
    private double _theta = 0.0;
    private int _marker = -1;
    private int _markerWidth = -1;
    private int _markerWeight = 0;
    private float[] _linePattern = null;
    private int _lineWidth = -1;
    private Color _lineColor = null;
    private Color _color = null;
    private FillPatternAttrs _fillPattern;
    private Image _skinImage = null;
    private boolean skinnedLine = false;
    private int skinType = 0;
    private Image[] pixelBenderImages = null;
    private int swatchType = 1;
    private boolean swatchOutlineOn = true;
    private LineAttrs _markerOutline;
    private static final int _MARGIN = 3;
    public static int LEGEND_LINE_LENGTH = 48;
    private int itemLineLength = LEGEND_LINE_LENGTH;
    private String graphID = null;
    private DefaultStyledDocument richText = null;
    private double lineLengthMultiplier = 1.0;
    private boolean scaleSymbolWithFont = false;
    public static int TEXT_FIT_NONE = -1;
    public static int TEXT_FIT_TRUNCATE = 0;
    public static int TEXT_FIT_SPLITALWAYS = 1;
    private int textFitPolicy = TEXT_FIT_NONE;
    private char[] textSplitChar = new char[]{' '};
    private boolean textSplitCharDrop = true;
    private float textSplitJustify = 0.5f;
    private String[] splitText;
    private boolean hotelText = false;
    private boolean noMargin = false;
    private boolean subpixelRendering = false;
    private double customHeightScale = Double.NaN;
    private double customChickletHeight = Double.NaN;
    private double customChickletAspect = Double.NaN;
    int MARGIN = 3;

    public Entry() {
    }

    public Entry(String text) {
        this();
        this.setText(text);
    }

    public Entry(String text, double theta) {
        this();
        this.setText(text);
        this.setTheta(theta);
    }

    public void setSubpixelRendering(boolean b) {
        this.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.subpixelRendering;
    }

    public String getGraphID() {
        return this.graphID;
    }

    public void setGraphID(String id) {
        this.graphID = id;
    }

    public static int getDefaultMargin() {
        return (int)Math.ceil(3.0 * StatGraph.getGapScaleFactor());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isTextAntiAliased() {
        return this._textAntiAliased;
    }

    public void setTextAntiAliased(boolean textAntiAliased) {
        this._textAntiAliased = textAntiAliased;
    }

    public boolean isDataAntiAliased() {
        return this._dataAntiAliased;
    }

    public void setDataAntiAliased(boolean dataAntiAliased) {
        this._dataAntiAliased = dataAntiAliased;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public double getTheta() {
        return this._theta;
    }

    public void setTheta(double theta) {
        this._theta = theta == 270.0 ? 270.0 : (theta == 180.0 ? 180.0 : (theta == 90.0 ? 90.0 : 0.0));
    }

    public int getMarker() {
        return this._marker;
    }

    public void setMarker(int marker) {
        this._marker = marker;
    }

    public int getMarkerWidth() {
        return this._markerWidth;
    }

    public void setMarkerWidth(int width) {
        this._markerWidth = width;
    }

    public int getMarkerWeight() {
        return this._markerWeight;
    }

    public void setMarkerWeight(int weight) {
        this._markerWeight = weight;
    }

    public float[] getLinePattern() {
        return this._linePattern;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setLine(float[] pattern, int width) {
        this._linePattern = pattern;
        this._lineWidth = width;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public void setLineColor(Color color) {
        this._lineColor = color;
    }

    public void setMarkerLine(int marker, int markerWidth, float[] pattern, int lineWidth) {
        this._marker = marker;
        this._markerWidth = markerWidth;
        this._linePattern = pattern;
        this._lineWidth = lineWidth;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public String getShortText() {
        return this._shortText;
    }

    public void setShortText(String text) {
        this._shortText = text;
    }

    public boolean isWrap() {
        return this._isWrap;
    }

    public void setWrap(boolean isWrap) {
        this._isWrap = isWrap;
    }

    public int getWrapWidth() {
        return this._wrapWidth;
    }

    public void setWrapWidth(int wrapWidth) {
        this._wrapWidth = wrapWidth;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        float savedAlignX = this.getAlignmentX();
        this.adjustClippedText();
        super.paintComponent(g);
        g2.setColor(this.getForeground());
        g2.setFont(this.getFont());
        FontMetrics fm = g2.getFontMetrics();
        int fontAscent = fm.getAscent();
        int fontDescent = fm.getDescent();
        int fontHeight = fm.getHeight();
        int width = this.getSize().width;
        int height = this.getSize().height;
        int top = this.getInsets().top;
        int left = this.getInsets().left;
        int bottom = this.getInsets().bottom;
        int right = this.getInsets().right;
        Dimension d = this.getEntrySize();
        int xOff = left + (width - d.width) / 2;
        int yOff = top + (height - d.height) / 2;
        Stroke oldStroke = g2.getStroke();
        AffineTransform oldTransform = g2.getTransform();
        if (this._text != null) {
            boolean fit;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isTextAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            String[] text = new String[]{this.getText()};
            if (this.isWrap()) {
                ArrayList split = this.getSplits(g2, fm, width - left - right);
                text = new String[split.size() + 1];
                String s = this.getText();
                int prevpos = 0;
                for (int i = 0; i < split.size(); ++i) {
                    int pos = (Integer)split.get(i);
                    text[i] = s.substring(prevpos, pos).trim();
                    prevpos = pos;
                }
                text[text.length - 1] = s.substring(prevpos, s.length());
            }
            if (this.textFitPolicy == TEXT_FIT_SPLITALWAYS) {
                if (this.splitText == null) {
                    this.splitText = this.hotelText ? this.splitLabelToHotelText(this._text) : Overlay.splitLabel(this._text, true, -1.0, this.textSplitCharDrop, this.textSplitChar, fm);
                }
                text = this.splitText;
            }
            GlyphVector gv = g2.getFont().createGlyphVector(g2.getFontRenderContext(), text[0]);
            Rectangle r = gv.getLogicalBounds().getBounds();
            int maxHeight = text.length * (int)Math.ceil(gv.getLogicalBounds().getHeight());
            int maxWidth = 0;
            for (int i = 0; i < text.length; ++i) {
                gv = g2.getFont().createGlyphVector(g2.getFontRenderContext(), text[i]);
                r = gv.getLogicalBounds().getBounds();
                if (maxWidth >= r.width) continue;
                maxWidth = r.width;
            }
            boolean bl = fit = maxWidth <= width && maxHeight <= height;
            if (this._theta == 90.0 || this._theta == 270.0) {
                boolean bl2 = fit = maxWidth <= height && maxHeight <= width;
            }
            if (!fit && this.textFitPolicy != TEXT_FIT_SPLITALWAYS) {
                if (this.getShortText() != null && !this.getShortText().equals("")) {
                    text = new String[]{this.getShortText()};
                    gv = g2.getFont().createGlyphVector(g2.getFontRenderContext(), text[0]);
                    r = gv.getLogicalBounds().getBounds();
                    maxWidth = r.width;
                    maxHeight = r.height;
                } else {
                    text[0] = this.getTruncatedText(text[0], g2);
                }
            }
            if (this.getTheta() != 0.0) {
                AffineTransform at = new AffineTransform();
                at.rotate(Math.toRadians(-this.getTheta()), width / 2, height / 2);
                g2.transform(at);
            }
            int y = top + (height - top - bottom - maxHeight) / 2 + fontAscent;
            if (this.getAlignmentY() == 0.0f) {
                if (this._theta == 0.0) {
                    y = top + fontAscent;
                } else if (this._theta == 90.0) {
                    y = (height - width) / 2 + fontAscent;
                } else if (this._theta == 180.0) {
                    y = height - bottom - fontDescent;
                } else if (this._theta == 270.0) {
                    y = (width + height) / 2 - fontDescent - fontHeight * (text.length - 1);
                }
            } else if (this.getAlignmentY() == 1.0f) {
                if (this._theta == 0.0) {
                    y = height - bottom - fontDescent;
                } else if (this._theta == 90.0) {
                    y = (width + height) / 2 - fontDescent - fontHeight * (text.length - 1);
                } else if (this._theta == 180.0) {
                    y = top + fontAscent;
                } else if (this._theta == 270.0) {
                    y = (height - width) / 2 + fontAscent;
                }
            }
            if (this.hotelText) {
                fontHeight = (int)Math.ceil(gv.getLogicalBounds().getHeight());
            }
            if (StatGraph.VGF && StatGraph.SVG) {
                ((VGFGraphics2D)g2).textClip(false);
            }
            for (int i = 0; i < text.length; ++i) {
                gv = g2.getFont().createGlyphVector(g2.getFontRenderContext(), text[i]);
                r = gv.getLogicalBounds().getBounds();
                int x = left + (width - right - left - r.width) / 2;
                if (this.textFitPolicy == TEXT_FIT_SPLITALWAYS && (double)this.getAlignmentX() == 0.5) {
                    if (this.textSplitJustify == 0.0f) {
                        x -= (maxWidth - r.width) / 2;
                    } else if (this.textSplitJustify == 1.0f) {
                        x += (maxWidth - r.width) / 2;
                    }
                }
                if (this.getAlignmentX() == 0.0f) {
                    if (this._theta == 0.0) {
                        x = left;
                    } else if (this._theta == 90.0) {
                        x = (width + height) / 2 - right - r.width;
                    } else if (this._theta == 180.0) {
                        x = width - right - r.width;
                    } else if (this._theta == 270.0) {
                        x = (width - height) / 2 + left;
                    }
                } else if (this.getAlignmentX() == 1.0f) {
                    if (this._theta == 0.0) {
                        x = width - right - r.width;
                    } else if (this._theta == 90.0) {
                        x = (width - height) / 2 + left;
                    } else if (this._theta == 180.0) {
                        x = left;
                    } else if (this._theta == 270.0) {
                        x = (width + height) / 2 - right - r.width;
                    }
                }
                g2.drawString(text[i], x, y);
                y += fontHeight;
            }
            if (StatGraph.VGF && StatGraph.SVG) {
                ((VGFGraphics2D)g2).textClip(false);
            }
        }
        int y = -2147483647;
        if (this._lineWidth > 0 && this._color == null && this._fillPattern == null) {
            int w = 3 * height / 5;
            int x = xOff;
            if (this._markerWidth >= 0 && this._marker != -1) {
                if (this.isScaleSymbolWithFont()) {
                    y = this._markerWidth < fontAscent ? yOff + fontAscent - 1 - (this._markerWidth - 1) / 2 : height / 2;
                } else {
                    int n = y = this._markerWidth < fontAscent ? yOff + fontAscent - 1 - w / 2 : height / 2;
                }
            }
            if (y == -2147483647) {
                y = yOff + fontAscent - 1 - w / 2;
            }
            if (this._linePattern == null) {
                g2.setStroke(new BasicStroke(this._lineWidth));
            } else {
                g2.setStroke(new BasicStroke(this._lineWidth, 0, 0, 10.0f, this._linePattern, 0.0f));
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            if (this.getLineColor() != null) {
                g2.setColor(this.getLineColor());
            }
            if (this.skinType == 0) {
                g2.drawLine(x, y, width - 1 - right, y);
            } else {
                this.drawSkin(g2, x, y, width - 1 - right, y, this.getLineColor() != null ? this.getLineColor() : this.getForeground(), this._lineWidth, this._linePattern, this.skinType);
            }
            g2.setColor(this.getForeground());
            g2.setStroke(oldStroke);
        }
        if (this._markerWidth >= 0 && this._marker != -1) {
            UserDefinedMarkerInterface udm;
            int w = 3 * height / 5;
            int x = width / 2;
            y = this.isScaleSymbolWithFont() ? (this._markerWidth < fontAscent ? yOff + fontAscent - 1 - (this._markerWidth - 1) / 2 : height / 2) : (this._markerWidth < fontAscent ? yOff + fontAscent - 1 - w / 2 : height / 2);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            int shape = StatGraph.VGF ? Markers.getSVGShape((int)this._marker) : this._marker;
            int edgeWidth = StatGraph.getMarkerEdgeWidth(this._markerWidth, this._markerWeight);
            int markerSize = this._markerWidth;
            Color edgeColor = null;
            if (Markers.isFilled((int)shape) && this._markerOutline != null) {
                edgeColor = this._markerOutline.getColor();
                int ew = this._markerOutline.getWidth();
                if (ew == 0) {
                    edgeColor = this.getForeground();
                }
                if (!edgeColor.equals(this.getForeground()) && !this.isScaleSymbolWithFont()) {
                    if (edgeWidth > 1) {
                        markerSize = this._markerWidth + edgeWidth;
                    }
                    if (ew > 0) {
                        edgeWidth = ew;
                    }
                }
            } else if (edgeWidth > 1 && Markers.isFilled((int)shape) && this.skinType != 0) {
                markerSize = this._markerWidth + edgeWidth;
                edgeWidth = 1;
            }
            if (Markers.isUserDefinedMarker((int)shape) && (udm = Markers.getUserDefinedMarker((int)shape)) instanceof UserDefinedCharacterMarker) {
                x = (int)((double)x + udm.getMarkerOffsetY() * (double)markerSize);
                y = (int)((double)y - udm.getMarkerOffsetY() * (double)markerSize);
            }
            if (this.skinType == 0) {
                if (this.subpixelRendering) {
                    Markers.draw((Graphics)g2, null, (Color)edgeColor, (int)shape, (double)markerSize, (double)x, (double)y, (boolean)false, (int)this._markerWeight, (int)edgeWidth, (boolean)this.isDataAntiAliased(), (Image)this._skinImage);
                } else {
                    Markers.draw((Graphics)g2, null, (Color)edgeColor, (int)shape, (int)markerSize, (int)x, (int)y, (boolean)false, (int)this._markerWeight, (int)edgeWidth, (boolean)this.isDataAntiAliased(), (Image)this._skinImage);
                }
            } else {
                this.drawSkin(g, x, y, markerSize, this.getForeground(), edgeColor, edgeWidth, this._markerWeight, shape, this.skinType);
            }
        }
        if (this._color != null || this._fillPattern != null) {
            int w = 3 * height / 5;
            int x = xOff;
            if (y == -2147483647) {
                y = yOff + fontAscent - 1 - w;
            }
            if (StatGraph.isScaledUp()) {
                w = d.height;
                x = left + (width - d.width) / 2;
                y = top + (height - d.height) / 2;
            }
            int h = w;
            if (this._fillPattern != null) {
                w = width - 2 * x;
                h = 4 * d.height / 5;
                h = Math.min(h, w);
                y = top + (height - h) / 2;
                if (this.swatchType == 2) {
                    w = h;
                }
            }
            if (this._color != null) {
                if (this.isCustomChickletHeight() || this.isCustomHeightScale() || this.isCustomChickletAspect()) {
                    h = this.isCustomChickletHeight() || this.isCustomHeightScale() || this._fillPattern != null ? d.height - StatGraph.getExtraPadding() : d.height;
                    w = this.isCustomChickletAspect() && this.swatchType == 1 ? (int)Math.ceil(this.customChickletAspect * (double)h) : (this._fillPattern == null ? h : 2 * h);
                    x = left + (width - left - right - w) / 2;
                    y = top + (height - h) / 2;
                }
                g2.setColor(this._color);
                if (this.swatchType == 1) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (StatGraph.VGF) {
                        if (this.skinType == 0) {
                            g2.fillRect(x, y, w, h);
                        } else {
                            this.drawSkin(g, x, y, w, h, this._color, this._fillPattern, this.skinType, this._skinImage);
                        }
                    } else if (this.skinType == 0) {
                        if (this.swatchOutlineOn) {
                            g2.fillRect(x + 1, y + 1, w - 2, h - 2);
                        } else {
                            g2.fillRect(x, y, w, h);
                        }
                    } else {
                        this.drawSkin(g, x, y, w, h, this._color, this._fillPattern, this.skinType, this._skinImage);
                    }
                } else if (this.swatchType == 2) {
                    int shape;
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (this._lineWidth > 1) {
                        w -= this._lineWidth;
                    }
                    w = w % 2 == 0 ? w - 1 : w;
                    int n = shape = StatGraph.VGF ? 174 : 16;
                    if (this.skinType == 0) {
                        if (this.subpixelRendering) {
                            Markers.draw((Graphics)g2, null, null, (int)shape, (double)w, (double)(x + 1 + w / 2), (double)(y + 1 + w / 2), (boolean)false, (int)1, (int)1, (boolean)this.isDataAntiAliased(), (Image)this._skinImage);
                        } else {
                            Markers.draw((Graphics)g2, null, null, (int)shape, (int)w, (int)(x + 1 + w / 2), (int)(y + 1 + w / 2), (boolean)false, (int)1, (int)1, (boolean)this.isDataAntiAliased(), (Image)this._skinImage);
                        }
                    } else {
                        this.drawSkin(g, x + 1 + w / 2, y + 1 + w / 2, w, this._color, null, 1, 1, shape, this.skinType);
                    }
                }
            }
            if (this.swatchType == 1 && this.skinType == 0) {
                if (this._fillPattern != null) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                    Rectangle bbox = new Rectangle(x, y, w, h);
                    this.drawPattern(g2, bbox, this._fillPattern);
                }
                if (this._skinImage != null) {
                    this.drawSkin((Graphics)g2, x, y, w, h, this._skinImage);
                }
            } else if (this.swatchType == 2 && this._fillPattern != null) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                Rectangle bbox = new Rectangle(x, y, w, h);
                Ellipse2D.Double clipShape = new Ellipse2D.Double(x + 1, y + 1, w, w);
                this.drawPattern(g2, bbox, this._fillPattern, clipShape);
            }
            if (this.swatchOutlineOn && this.skinType == 0) {
                Color outline = this.getForeground();
                if (this._lineWidth >= 0) {
                    if (this._linePattern == null) {
                        g2.setStroke(new BasicStroke(this._lineWidth));
                    } else {
                        g2.setStroke(new BasicStroke(this._lineWidth, 0, 0, 10.0f, this._linePattern, 0.0f));
                    }
                }
                g2.setColor(outline);
                if (this.swatchType == 1) {
                    if (StatGraph.isScaledUp()) {
                        g2.drawRect(x, y + this._lineWidth / 2, w - 1, h - this._lineWidth);
                    } else {
                        g2.drawRect(x, y, w - 1, h - 1);
                    }
                } else if (this.swatchType == 2) {
                    int shape;
                    int n = shape = StatGraph.VGF ? 173 : 0;
                    if (this.subpixelRendering) {
                        Markers.draw((Graphics)g2, null, null, (int)shape, (double)w, (double)(x + 1 + w / 2), (double)(y + 1 + w / 2), (boolean)false, (int)1, (int)1, (boolean)this.isDataAntiAliased(), (Image)this._skinImage);
                    } else {
                        Markers.draw((Graphics)g2, null, null, (int)shape, (int)w, (int)(x + 1 + w / 2), (int)(y + 1 + w / 2), (boolean)false, (int)1, (int)1);
                    }
                }
            }
        }
        g2.setStroke(oldStroke);
        g2.setTransform(oldTransform);
        this.setAlignmentX(savedAlignX);
    }

    public BufferedImage blendImages(BufferedImage src, BufferedImage[] blendingImages, int type, int offsetX, int offsetY) {
        BufferedImage dst = src;
        switch (type) {
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (blendingImages == null || blendingImages.length < 2) break;
                BlendFilter f = new BlendFilter();
                f.setOffsets(offsetX, offsetY);
                f.setMode(BlendFilter.Mode.MULTIPLY);
                f.setImage(blendingImages[0]);
                dst = f.filter(src, null);
                f.setMode(BlendFilter.Mode.COLOR_DODGE);
                f.setImage(blendingImages[1]);
                dst = f.filter(dst, null);
                break;
            }
        }
        return dst;
    }

    private void drawSkin(Graphics g, int x, int y, int width, int height, Color color, FillPatternAttrs fillPattern, int skinType, Image skinImage) {
        Rectangle bbox;
        BufferedImage[] actualSizeImages = null;
        if (this.pixelBenderImages != null) {
            actualSizeImages = new BufferedImage[this.pixelBenderImages.length];
            for (int i = 0; i < this.pixelBenderImages.length; ++i) {
                actualSizeImages[i] = new BufferedImage(width, height, 2);
                Graphics2D g2 = actualSizeImages[i].createGraphics();
                g2.drawImage(this.pixelBenderImages[i], 0, 0, width, height, null);
                g2.dispose();
            }
        }
        int img_width = width + 2 * this.MARGIN;
        int img_height = height + 2 * this.MARGIN;
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        float alpha = (float)color.getAlpha() / 255.0f;
        color = new Color(red, green, blue, 255);
        BufferedImage src = new BufferedImage(img_width, img_height, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setColor(color);
        g2.fillRect(this.MARGIN, this.MARGIN, width, height);
        g2.dispose();
        int dx = x - this.MARGIN;
        int dy = y - this.MARGIN;
        Composite saveComposite = ((Graphics2D)g).getComposite();
        Graphics gc = g;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (alpha < 1.0f) {
            combined = new BufferedImage(img_width, img_height, 2);
            g = combined.getGraphics();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        if (actualSizeImages != null) {
            src = this.blendImages(src, actualSizeImages, skinType, this.MARGIN, this.MARGIN);
        }
        float facX = (float)width / 50.0f;
        float facY = (float)height / 50.0f;
        if (alpha == 1.0f || fillPattern == null) {
            g.drawImage(src, dx, dy, null);
            if (fillPattern != null) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                bbox = new Rectangle(x, y, width, height);
                this.drawPattern((Graphics2D)g, bbox, fillPattern);
            }
        }
        switch (skinType) {
            case 5: {
                BufferedImage b_img = src;
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setAngle(45.0f);
                bevel.setBlurX(0.0f);
                bevel.setBlurY(0.0f);
                bevel.setDistance(3.0f * (float)StatGraph.dataDPIScaleFactor);
                bevel.setHighlightAlpha(0.3f);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowAlpha(0.2f);
                bevel.setShadowColor(Color.black);
                bevel.setQuality(0);
                bevel.setStrength(1.0f);
                b_img = bevel.filter(b_img, null);
                g.drawImage(b_img, dx, dy, null);
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(1.0f);
                glow.setColor(Color.black);
                glow.setQuality(3);
                glow.setStrength(15.0f);
                glow.setInner(true);
                g_img = glow.filter(g_img, null);
                g.drawImage(g_img, dx, dy, null);
                break;
            }
            case 6: {
                BufferedImage gi_img = src;
                GlowFilter glowInner = new GlowFilter();
                glowInner.setKnockout(true);
                glowInner.setBlurX(3.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setBlurY(3.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setAlpha(0.45f);
                glowInner.setColor(Color.black);
                glowInner.setQuality(3);
                glowInner.setStrength(2.0f);
                glowInner.setInner(true);
                gi_img = glowInner.filter(gi_img, null);
                g.drawImage(gi_img, dx, dy, null);
                BufferedImage b1_img = src;
                BevelFilter bevel1 = new BevelFilter();
                bevel1.setKnockout(true);
                bevel1.setAngle(45.0f);
                bevel1.setBlurX(20.0f * facX * (float)StatGraph.dataDPIScaleFactor);
                bevel1.setBlurY(0.0f);
                bevel1.setDistance(5.0f * (facX + 1.0f) / 2.0f * (float)StatGraph.dataDPIScaleFactor);
                bevel1.setHighlightAlpha(0.5f);
                bevel1.setHighlightColor(Color.white);
                bevel1.setShadowAlpha(0.0f);
                bevel1.setShadowColor(Color.black);
                bevel1.setQuality(2);
                bevel1.setStrength(2.0f);
                b1_img = bevel1.filter(b1_img, null);
                g.drawImage(b1_img, dx, dy, null);
                BufferedImage b2_img = src;
                BevelFilter bevel2 = new BevelFilter();
                bevel2.setKnockout(true);
                bevel2.setAngle(45.0f);
                bevel2.setBlurX(10.0f * facX * (float)StatGraph.dataDPIScaleFactor);
                bevel2.setBlurY(0.0f);
                bevel2.setDistance(4.0f * (facX + 1.0f) / 2.0f * (float)StatGraph.dataDPIScaleFactor);
                bevel2.setHighlightAlpha(0.5f);
                bevel2.setHighlightColor(Color.white);
                bevel2.setShadowAlpha(0.0f);
                bevel2.setShadowColor(Color.black);
                bevel2.setQuality(2);
                bevel2.setStrength(2.0f);
                b2_img = bevel2.filter(b2_img, null);
                g.drawImage(b2_img, dx, dy, null);
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(0.6f);
                glow.setColor(Color.black);
                glow.setQuality(3);
                glow.setStrength(8.0f);
                glow.setInner(true);
                g_img = glow.filter(g_img, null);
                g.drawImage(g_img, dx, dy, null);
                break;
            }
            case 7: {
                BufferedImage b_img = src;
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setAngle(45.0f);
                float blurX = 6.0f;
                float blurY = 6.0f;
                if ((float)width < blurX * 2.0f || (float)height < blurY * 2.0f) {
                    float deltaHeight;
                    float deltaWidth = Math.abs((float)width - blurX * 2.0f);
                    if (deltaWidth >= (deltaHeight = Math.abs((float)height - blurY * 2.0f))) {
                        blurX *= facX;
                        blurY *= facX;
                    } else {
                        blurX *= facY;
                        blurY *= facY;
                    }
                }
                bevel.setBlurX(blurX * (float)StatGraph.dataDPIScaleFactor);
                bevel.setBlurY(blurY * (float)StatGraph.dataDPIScaleFactor);
                bevel.setDistance(3.0f * (float)StatGraph.dataDPIScaleFactor);
                bevel.setHighlightAlpha(0.5f);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowAlpha(0.3f);
                bevel.setShadowColor(Color.black);
                bevel.setQuality(3);
                bevel.setStrength(1.0f);
                b_img = bevel.filter(b_img, null);
                g.drawImage(b_img, dx, dy, null);
                BufferedImage gi_img = src;
                GlowFilter glowInner = new GlowFilter();
                glowInner.setKnockout(true);
                glowInner.setBlurX(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setBlurY(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setAlpha(0.6f);
                glowInner.setColor(Color.black);
                glowInner.setQuality(3);
                glowInner.setStrength(3.0f);
                glowInner.setInner(true);
                gi_img = glowInner.filter(gi_img, null);
                g.drawImage(gi_img, dx, dy, null);
                break;
            }
            case 3: {
                if (skinImage != null) {
                    if (alpha < 1.0f) {
                        this.drawSkin(g, this.MARGIN, this.MARGIN, width, height, skinImage);
                    } else {
                        this.drawSkin(g, x, y, width, height, skinImage);
                    }
                }
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.25f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.25f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(0.6f);
                glow.setColor(Color.black);
                glow.setQuality(3);
                glow.setStrength(3.0f);
                glow.setInner(true);
                g_img = glow.filter(g_img, null);
                g.drawImage(g_img, dx, dy, null);
                break;
            }
            case 4: {
                BufferedImage b_img;
                if (actualSizeImages == null) {
                    b_img = src;
                    BevelFilter bevel = new BevelFilter();
                    bevel.setKnockout(true);
                    bevel.setAngle(45.0f);
                    float blurX = 4.0f;
                    float blurY = 4.0f;
                    if ((float)width < blurX * 2.0f || (float)height < blurY * 2.0f) {
                        float deltaHeight;
                        float deltaWidth = Math.abs((float)width - blurX * 2.0f);
                        if (deltaWidth >= (deltaHeight = Math.abs((float)height - blurY * 2.0f))) {
                            blurX *= facX;
                            blurY *= facX;
                        } else {
                            blurX *= facY;
                            blurY *= facY;
                        }
                    }
                    bevel.setBlurX(blurX * (float)StatGraph.dataDPIScaleFactor);
                    bevel.setBlurY(blurY * (float)StatGraph.dataDPIScaleFactor);
                    bevel.setDistance(2.0f * (float)StatGraph.dataDPIScaleFactor);
                    bevel.setHighlightAlpha(0.5f);
                    bevel.setHighlightColor(Color.white);
                    bevel.setShadowAlpha(0.3f);
                    bevel.setShadowColor(Color.black);
                    bevel.setQuality(3);
                    bevel.setStrength(2.0f);
                    b_img = bevel.filter(b_img, null);
                    g.drawImage(b_img, dx, dy, null);
                }
                BufferedImage gi_img = src;
                GlowFilter glowInner = new GlowFilter();
                glowInner.setKnockout(true);
                glowInner.setBlurX(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setBlurY(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setAlpha(0.5f);
                glowInner.setColor(Color.black);
                glowInner.setQuality(3);
                glowInner.setStrength(3.0f);
                glowInner.setInner(true);
                gi_img = glowInner.filter(gi_img, null);
                g.drawImage(gi_img, dx, dy, null);
            }
        }
        if (alpha < 1.0f) {
            g.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, alpha));
            if (fillPattern != null) {
                gc.drawImage(src, DX, DY, null);
                ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, 1.0f));
                ((Graphics2D)gc).setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isDataAntiAliased() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                bbox = new Rectangle(x, y, width, height);
                this.drawPattern((Graphics2D)gc, bbox, fillPattern);
                ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, alpha));
            }
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    private void drawSkin(Graphics g, int x, int y, int markerSize, Color markerColor, Color edgeColor, int edgeWidth, int markerWeight, int markerType, int skinType) {
        int xo;
        if (markerSize <= 0) {
            return;
        }
        boolean filled = Markers.isFilled((int)markerType);
        int adjustedMS = Markers.getAdjustedSize((int)markerType, (int)markerSize, (boolean)true);
        BufferedImage[] actualSizeImages = null;
        if (filled && this.pixelBenderImages != null) {
            actualSizeImages = new BufferedImage[this.pixelBenderImages.length];
            for (int i = 0; i < this.pixelBenderImages.length; ++i) {
                actualSizeImages[i] = new BufferedImage(adjustedMS, adjustedMS, 2);
                Graphics2D g2 = actualSizeImages[i].createGraphics();
                g2.drawImage(this.pixelBenderImages[i], 0, 0, adjustedMS, adjustedMS, null);
                g2.dispose();
            }
        }
        int size = adjustedMS + this.MARGIN * 2;
        int yo = xo = (int)((double)size * 0.5);
        int red = markerColor.getRed();
        int green = markerColor.getGreen();
        int blue = markerColor.getBlue();
        float alpha = (float)markerColor.getAlpha() / 255.0f;
        markerColor = new Color(red, green, blue, 255);
        BufferedImage src = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (this.subpixelRendering) {
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            Markers.draw((Graphics)g2, (Color)markerColor, (Color)edgeColor, (int)markerType, (double)markerSize, (double)xo, (double)yo, (boolean)false, (int)markerWeight, (int)edgeWidth, (boolean)this.isDataAntiAliased(), null);
        } else {
            Markers.draw((Graphics)g2, (Color)markerColor, (Color)edgeColor, (int)markerType, (int)markerSize, (int)xo, (int)yo, (boolean)false, (int)markerWeight, (int)edgeWidth, (boolean)this.isDataAntiAliased(), null);
        }
        g2.dispose();
        int dx = x - xo;
        int dy = y - yo;
        Composite saveComposite = ((Graphics2D)g).getComposite();
        Graphics gc = g;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (alpha < 1.0f) {
            combined = new BufferedImage(size, size, 2);
            g = combined.getGraphics();
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        if (filled && actualSizeImages != null) {
            src = this.blendImages(src, actualSizeImages, skinType, this.MARGIN, this.MARGIN);
        }
        g.drawImage(src, dx, dy, null);
        float fac = (float)adjustedMS / 50.0f;
        Color borderColor = edgeColor != null && !edgeColor.equals(markerColor) ? edgeColor : Color.black;
        switch (skinType) {
            case 5: {
                if (!filled) break;
                BufferedImage b_img = src;
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setAngle(45.0f);
                bevel.setBlurX(0.0f);
                bevel.setBlurY(0.0f);
                bevel.setDistance(3.0f * (float)StatGraph.dataDPIScaleFactor);
                bevel.setHighlightAlpha(0.3f);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowAlpha(0.2f);
                bevel.setShadowColor(Color.black);
                bevel.setQuality(0);
                bevel.setStrength(1.0f);
                bevel.setExtendEdge(true);
                b_img = bevel.filter(b_img, null);
                g.drawImage(b_img, dx, dy, null);
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(0.8f);
                glow.setColor(borderColor);
                glow.setQuality(3);
                glow.setStrength(15.0f);
                glow.setInner(true);
                g_img = glow.filter(g_img, null);
                g.drawImage(g_img, dx, dy, null);
                break;
            }
            case 6: {
                if (!filled) break;
                if (filled) {
                    BufferedImage gi_img = src;
                    GlowFilter glowInner = new GlowFilter();
                    glowInner.setKnockout(true);
                    glowInner.setBlurX(3.5f * (float)StatGraph.dataDPIScaleFactor);
                    glowInner.setBlurY(3.5f * (float)StatGraph.dataDPIScaleFactor);
                    glowInner.setAlpha(0.45f);
                    glowInner.setColor(Color.black);
                    glowInner.setQuality(3);
                    glowInner.setStrength(2.0f);
                    glowInner.setInner(true);
                    gi_img = glowInner.filter(gi_img, null);
                    g.drawImage(gi_img, dx, dy, null);
                    BufferedImage b1_img = src;
                    BevelFilter bevel1 = new BevelFilter();
                    bevel1.setKnockout(true);
                    bevel1.setAngle(0.0f);
                    bevel1.setBlurX(20.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                    bevel1.setBlurY(0.0f);
                    bevel1.setDistance(4.0f * (fac + 1.0f) / 2.0f * (float)StatGraph.dataDPIScaleFactor);
                    bevel1.setHighlightAlpha(0.5f);
                    bevel1.setHighlightColor(Color.white);
                    bevel1.setShadowAlpha(0.0f);
                    bevel1.setShadowColor(Color.black);
                    bevel1.setQuality(2);
                    bevel1.setStrength(2.0f);
                    bevel1.setExtendEdge(true);
                    b1_img = bevel1.filter(b1_img, null);
                    g.drawImage(b1_img, dx, dy, null);
                }
                BufferedImage b2_img = src;
                BevelFilter bevel2 = new BevelFilter();
                bevel2.setKnockout(true);
                bevel2.setAngle(0.0f);
                bevel2.setBlurX(10.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                bevel2.setBlurY(0.0f);
                bevel2.setDistance(3.0f * (fac + 1.0f) / 2.0f * (float)StatGraph.dataDPIScaleFactor);
                bevel2.setHighlightAlpha(0.5f);
                bevel2.setHighlightColor(Color.white);
                bevel2.setShadowAlpha(0.0f);
                bevel2.setShadowColor(Color.black);
                bevel2.setQuality(2);
                bevel2.setStrength(2.0f);
                bevel2.setExtendEdge(true);
                b2_img = bevel2.filter(b2_img, null);
                g.drawImage(b2_img, dx, dy, null);
                if (!filled) break;
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(0.6f);
                glow.setColor(borderColor);
                glow.setQuality(3);
                glow.setStrength(8.0f);
                glow.setInner(true);
                g_img = glow.filter(g_img, null);
                g.drawImage(g_img, dx, dy, null);
                break;
            }
            case 7: {
                if (!filled) break;
                BufferedImage b_img = src;
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setAngle(45.0f);
                bevel.setBlurX(25.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                bevel.setBlurY(25.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                bevel.setDistance(20.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                bevel.setHighlightAlpha(0.4f);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowAlpha(0.3f);
                bevel.setShadowColor(Color.black);
                bevel.setQuality(3);
                bevel.setStrength(1.0f);
                bevel.setExtendEdge(true);
                b_img = bevel.filter(b_img, null);
                g.drawImage(b_img, dx, dy, null);
                BufferedImage gi_img = src;
                GlowFilter glowInner = new GlowFilter();
                glowInner.setKnockout(true);
                glowInner.setBlurX(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setBlurY(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setAlpha(0.6f);
                glowInner.setColor(borderColor);
                glowInner.setQuality(3);
                glowInner.setStrength(3.0f);
                glowInner.setInner(true);
                gi_img = glowInner.filter(gi_img, null);
                g.drawImage(gi_img, dx, dy, null);
                break;
            }
            case 3: {
                if (filled) {
                    BufferedImage gi_img = src;
                    GlowFilter glowInner = new GlowFilter();
                    glowInner.setKnockout(true);
                    glowInner.setBlurX(20.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                    glowInner.setBlurY(20.0f * fac * (float)StatGraph.dataDPIScaleFactor);
                    glowInner.setAlpha(0.4f);
                    glowInner.setColor(Color.black);
                    glowInner.setQuality(2);
                    glowInner.setStrength(1.0f);
                    glowInner.setInner(true);
                    gi_img = glowInner.filter(gi_img, null);
                    g.drawImage(gi_img, dx, dy, null);
                    BufferedImage g_img = src;
                    GlowFilter glow = new GlowFilter();
                    glow.setKnockout(true);
                    glow.setBlurX(1.5f * (float)StatGraph.dataDPIScaleFactor);
                    glow.setBlurY(1.5f * (float)StatGraph.dataDPIScaleFactor);
                    glow.setAlpha(0.6f);
                    glow.setColor(borderColor);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    glow.setInner(true);
                    g_img = glow.filter(g_img, null);
                    g.drawImage(g_img, dx, dy, null);
                    break;
                }
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(0.3f);
                glow.setColor(Color.black);
                glow.setQuality(3);
                glow.setStrength(5.0f);
                glow.setInner(false);
                g_img = glow.filter(g_img, null);
                g.drawImage(g_img, dx, dy, null);
                break;
            }
            case 4: {
                if (!filled) break;
                BufferedImage gi_img = src;
                GlowFilter glowInner = new GlowFilter();
                glowInner.setKnockout(true);
                glowInner.setBlurX(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setBlurY(1.5f * (float)StatGraph.dataDPIScaleFactor);
                glowInner.setAlpha(0.5f);
                glowInner.setColor(borderColor);
                glowInner.setQuality(3);
                glowInner.setStrength(3.0f);
                glowInner.setInner(true);
                gi_img = glowInner.filter(gi_img, null);
                g.drawImage(gi_img, dx, dy, null);
            }
        }
        if (alpha < 1.0f) {
            g.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, alpha));
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    private void drawSkin(Graphics2D g, int x, int y, int x2, int y2, Color lineColor, int lineWidth, float[] linePattern, int skinType) {
        int size = x2 - x + 1 + this.MARGIN * 2;
        BufferedImage src = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (linePattern == null) {
            g2.setStroke(new BasicStroke(lineWidth));
        } else {
            g2.setStroke(new BasicStroke(lineWidth, 0, 0, 10.0f, linePattern, 0.0f));
        }
        float alpha = 1.0f;
        if (lineColor != null) {
            int red = lineColor.getRed();
            int green = lineColor.getGreen();
            int blue = lineColor.getBlue();
            alpha = (float)lineColor.getAlpha() / 255.0f;
            lineColor = new Color(red, green, blue, 255);
            g2.setColor(lineColor);
        }
        int yo = (int)((double)size * 0.5);
        g2.drawLine(this.MARGIN, yo, x2 - x + this.MARGIN, yo);
        g2.dispose();
        int dx = x - this.MARGIN;
        int dy = y - yo;
        Composite saveComposite = g.getComposite();
        Graphics2D gc = g;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (alpha < 1.0f) {
            combined = new BufferedImage(size, size, 2);
            g = (Graphics2D)combined.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        g.drawImage((Image)src, dx, dy, null);
        switch (skinType) {
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 3: {
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setBlurX(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setBlurY(1.1f * (float)StatGraph.dataDPIScaleFactor);
                glow.setAlpha(0.3f);
                glow.setColor(Color.black);
                glow.setQuality(3);
                glow.setStrength(5.0f);
                glow.setInner(false);
                g_img = glow.filter(g_img, null);
                g.drawImage((Image)g_img, dx, dy, null);
                break;
            }
        }
        if (alpha < 1.0f) {
            g.dispose();
            gc.setComposite(AlphaComposite.getInstance(3, alpha));
            gc.drawImage((Image)combined, DX, DY, null);
            gc.setComposite(saveComposite);
        }
    }

    private void drawSkin(Graphics2D g, int x, int y, int x2, int y2, int width) {
        double alpha_inc;
        double alpha = alpha_inc = 0.5 / (double)width;
        double prev_alpha = 0.0;
        for (int w = width - 1; w > 0; --w) {
            g.setStroke(new BasicStroke(w));
            double a = (alpha - prev_alpha) / (1.0 - prev_alpha);
            g.setColor(new Color(1.0f, 1.0f, 1.0f, (float)a));
            g.drawLine(x, y, x2, y2);
            prev_alpha = alpha;
            alpha += alpha_inc;
        }
    }

    private void drawSkin(Graphics g, int x, int y, int width, int height, Image skin) {
        if (skin == null) {
            return;
        }
        if (height < 1 || width < 1) {
            return;
        }
        BufferedImage image = null;
        image = new BufferedImage(width, height, 3);
        Graphics2D imageGraphics = image.createGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        imageGraphics.drawImage(skin, 0, 0, width, height, null);
        g.drawImage(image, x, y, null);
    }

    private void drawPattern(Graphics2D g2, Rectangle bbox, FillPatternAttrs _fillPattern) {
        this.drawPattern(g2, bbox, _fillPattern, null);
    }

    private void drawPattern(Graphics2D g2, Rectangle bbox, FillPatternAttrs _fillPattern, Shape clipShape) {
        boolean doubleLine;
        int type = FillPatternAttrs.getPatternType((int)_fillPattern.getPattern());
        int width = FillPatternAttrs.getPatternWidth((int)_fillPattern.getPattern());
        int gap = 0;
        int step = 0;
        int thickness = width;
        boolean bl = doubleLine = width == 4 || width == 5;
        if (doubleLine) {
            gap = width == 4 ? 3 : 5;
            thickness = width == 4 ? 1 : 2;
            step = gap + thickness;
        }
        int stride = 5 + width * 3;
        double DPIScale = StatGraph.dataDPIScaleFactor;
        thickness = (int)Math.round((double)thickness * DPIScale);
        gap = (int)Math.round((double)gap * DPIScale);
        step = (int)Math.round((double)step * DPIScale);
        stride = (int)Math.round((double)stride * DPIScale);
        Stroke save = g2.getStroke();
        Rectangle clip = g2.getClipBounds();
        g2.setStroke(new BasicStroke(thickness));
        if (clipShape != null) {
            g2.setClip(clipShape);
        } else {
            g2.setClip(bbox.x, bbox.y, bbox.width, bbox.height);
        }
        g2.setColor(_fillPattern.getColor());
        int w = bbox.width - 1;
        int x2 = bbox.x + w;
        int y2 = bbox.y + bbox.height - 1;
        switch (type) {
            case 1: {
                for (int y = bbox.y; y < y2; y += stride) {
                    g2.drawLine(bbox.x, y, x2, y + w);
                    if (!doubleLine) continue;
                    g2.drawLine(bbox.x, y + step, x2, y + step + w);
                }
                int x = bbox.x;
                for (int y = bbox.y + w - stride; y >= bbox.y; y -= stride) {
                    g2.drawLine(x += stride, bbox.y, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(x - step, bbox.y, x2, y + step);
                }
                break;
            }
            case 2: {
                int y;
                for (y = bbox.y; y < y2; y += stride) {
                    g2.drawLine(bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(bbox.x, y + step + w, x2, y + step);
                }
                int x = x2;
                for (y = bbox.y + w - stride; y >= bbox.y; y -= stride) {
                    g2.drawLine(bbox.x, y, x -= stride, bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(bbox.x, y + step, x + step, bbox.y);
                }
                break;
            }
            case 3: {
                for (int y = bbox.y; y < y2; y += stride) {
                    g2.drawLine(bbox.x, y, x2, y + w);
                    if (doubleLine) {
                        g2.drawLine(bbox.x, y + step, x2, y + step + w);
                    }
                    g2.drawLine(bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(bbox.x, y + step + w, x2, y + step);
                }
                int xl = bbox.x;
                int xr = x2;
                for (int y = bbox.y + w - stride; y >= bbox.y; y -= stride) {
                    g2.drawLine(xl += stride, bbox.y, x2, y);
                    if (doubleLine) {
                        g2.drawLine(xl - step, bbox.y, x2, y + step);
                    }
                    g2.drawLine(bbox.x, y, xr -= stride, bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(bbox.x, y + step, xr + step, bbox.y);
                }
                break;
            }
            case 4: {
                g2.fillRect(bbox.x, bbox.y, bbox.width, bbox.height);
                break;
            }
        }
        g2.setClip(clip);
        g2.setStroke(save);
    }

    private ArrayList getSplits(Graphics2D g2, FontMetrics fm, int wrapWidth) {
        ArrayList<Integer> splits = new ArrayList<Integer>(10);
        BreakIterator wordIterator = BreakIterator.getWordInstance();
        wordIterator.setText(this.getText());
        Font f = g2.getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        int prev = 0;
        int next = wordIterator.first();
        while (next != -1) {
            int first = prev;
            int width = 0;
            while (next != -1 && width < wrapWidth) {
                String s = this._text.substring(first, next).trim();
                GlyphVector gv = f.createGlyphVector(frc, s);
                Rectangle r = gv.getLogicalBounds().getBounds();
                width = r.width;
                if (width > wrapWidth && prev > first) {
                    splits.add(new Integer(prev));
                    continue;
                }
                prev = next;
                next = wordIterator.next();
            }
        }
        return splits;
    }

    private Dimension getEntrySize() {
        Dimension d = new Dimension();
        Graphics g = StatGraph.getGraphics();
        if (g != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(this.getFont());
            FontMetrics fm = g2.getFontMetrics();
            d.height = fm.getHeight();
            if (this._text != null) {
                if (this.textFitPolicy == TEXT_FIT_SPLITALWAYS) {
                    return this.getSplitEntrySize();
                }
                d.width = (int)fm.getStringBounds(this._text, g2).getWidth();
                if (d.width > this.getWrapWidth() - this.getInsets().left - this.getInsets().right) {
                    if (this.isWrap()) {
                        d.width = this.getWrapWidth() - this.getInsets().left - this.getInsets().right;
                        ArrayList split = this.getSplits(g2, fm, d.width);
                        d.height *= split.size() + 1;
                    } else if (this.getShortText() != null && !this.getShortText().equals("")) {
                        d.width = (int)fm.getStringBounds(this.getShortText(), g2).getWidth();
                    }
                }
                if (this._theta != 0.0 && this._theta != 180.0) {
                    int tmp = d.height;
                    d.height = d.width;
                    d.width = tmp;
                }
            }
            if (this._marker != -1) {
                int adjustedSize = Markers.getMaximumMarkerSize((int)this._markerWidth, (boolean)true, (int)this._markerWeight);
                d.width = Math.max(adjustedSize, 3 * d.height / 5) - 2;
                d.height = Math.max(adjustedSize + 2, d.height);
            }
            if (this._lineWidth >= 0) {
                d.width = StatGraph.scaleLegendLineLength((int)(this.lineLengthMultiplier * (double)this.itemLineLength));
            }
            if (this._color != null || this._fillPattern != null) {
                if (this.isCustomHeightScale() || this.isCustomChickletAspect() || this.isCustomChickletHeight()) {
                    if (this.isCustomChickletHeight()) {
                        d.height = (int)this.customChickletHeight;
                    } else {
                        if (StatGraph.isScaledUp()) {
                            d.height = StatGraph.scaleLegendLineLength(d.height);
                        }
                        if (this._fillPattern == null) {
                            d.height = 3 * d.height / 5;
                        }
                        if (this.swatchType == 2) {
                            d.height += d.height % 2;
                        }
                    }
                    if (this.isCustomHeightScale()) {
                        d.height = (int)((double)d.height * this.customHeightScale);
                    }
                    d.width = this.customChickletAspect == this.customChickletAspect && this.swatchType != 2 ? (int)Math.ceil(this.customChickletAspect * (double)d.height) : (this._fillPattern != null ? 2 * d.height : d.height);
                } else {
                    if (StatGraph.isScaledUp()) {
                        int n = d.height = this.scaleSymbolWithFont ? d.height : StatGraph.scaleLegendLineLength(d.height);
                        if (this._fillPattern == null) {
                            d.height = 3 * d.height / 5;
                        }
                        if (this.swatchType == 2) {
                            d.height += d.height % 2;
                        }
                        d.width = d.height;
                    } else {
                        d.width = 3 * d.height / 5;
                    }
                    if (this._fillPattern != null) {
                        d.width = StatGraph.scaleLegendLineLength((int)(this.lineLengthMultiplier * (double)this.itemLineLength * 0.65));
                        if (this.swatchType == 2) {
                            d.height = d.width;
                        }
                    }
                }
            }
            g.dispose();
        }
        Insets in = this.getInsets();
        d.width += in.left + in.right;
        d.height += in.top + in.bottom;
        if ((this.isCustomHeightScale() || this.isCustomChickletHeight()) && (this._color != null || this._fillPattern != null)) {
            d.height += StatGraph.getExtraPadding();
        }
        return d;
    }

    private Dimension getSplitEntrySize() {
        Dimension d = new Dimension();
        Graphics g = StatGraph.getGraphics();
        if (g != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setFont(this.getFont());
            FontMetrics fm = g2.getFontMetrics();
            if (this._text != null && this.splitText == null) {
                this.splitText = this.hotelText ? this.splitLabelToHotelText(this._text) : Overlay.splitLabel(this._text, true, -1.0, this.textSplitCharDrop, this.textSplitChar, fm);
            }
            d.width = 0;
            for (int i = 0; i < this.splitText.length; ++i) {
                d.width = Math.max(d.width, fm.stringWidth(this.splitText[i]));
            }
            d.height = fm.getHeight() * this.splitText.length;
            if (this._theta != 0.0 && this._theta != 180.0) {
                int tmp = d.height;
                d.height = d.width;
                d.width = tmp;
            }
            g.dispose();
        }
        Insets in = this.getInsets();
        d.width += in.left + in.right;
        d.height += in.top + in.bottom;
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.getEntrySize();
        if (0 <= this.getUserWidth()) {
            d.width = this.getUserWidth();
        }
        if (0 <= this.getUserHeight()) {
            d.height = this.getUserHeight();
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public String toString() {
        return "Entry: " + this.getText();
    }

    private void adjustClippedText() {
        if (this._theta == 0.0) {
            if (this.getWidth() < this.getPreferredSize().width) {
                this.setAlignmentX(0.0f);
            }
        } else if (this._theta == 90.0) {
            if (this.getHeight() < this.getPreferredSize().height) {
                this.setAlignmentX(1.0f);
            }
        } else if (this._theta == 270.0) {
            if (this.getHeight() < this.getPreferredSize().height) {
                this.setAlignmentX(0.0f);
            }
        } else if (this.getWidth() < this.getPreferredSize().width) {
            this.setAlignmentX(1.0f);
        }
    }

    private String getTruncatedText(String text, Graphics2D g2) {
        int maxSize = this._theta == 90.0 || this._theta == 270.0 ? this.getSize().height : this.getSize().width;
        String newText = text;
        if (text.length() > 3) {
            Rectangle r;
            StringBuffer sb = new StringBuffer(text);
            sb.append("...");
            int newSize = 0;
            do {
                sb.delete(sb.length() - 4, sb.length());
                sb.append("...");
                newText = sb.toString();
                GlyphVector gv = g2.getFont().createGlyphVector(g2.getFontRenderContext(), newText);
                r = gv.getLogicalBounds().getBounds();
            } while ((newSize = r.width) > maxSize && newText.length() > 3);
        }
        return newText;
    }

    public void setRichText(DefaultStyledDocument text) {
        this.richText = text;
    }

    public DefaultStyledDocument getRichText() {
        return this.richText;
    }

    protected void setSwatchType(int type) {
        this.swatchType = type;
    }

    protected void setSwatchOutlineOn(boolean on) {
        this.swatchOutlineOn = on;
    }

    public void setFillPattern(FillPatternAttrs attr) {
        this._fillPattern = attr;
    }

    public FillPatternAttrs getFillPattern() {
        return this._fillPattern;
    }

    public void setMarkerOutline(LineAttrs attr) {
        this._markerOutline = attr;
    }

    public LineAttrs getMarkerOutline() {
        return this._markerOutline;
    }

    public void setSkinImage(Image skin) {
        this._skinImage = skin;
    }

    public Image getSkinImage() {
        return this._skinImage;
    }

    public void setSkinnedLine(boolean skin) {
        this.skinnedLine = skin;
    }

    public boolean isSkinnedLine() {
        return this.skinnedLine;
    }

    public void setSkinType(int type) {
        this.skinType = type;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setPixelBenderImages(Image[] imgs) {
        this.pixelBenderImages = imgs;
    }

    public Image[] getPixelBenderImage() {
        return this.pixelBenderImages;
    }

    public double getLineLengthMultiplier() {
        return this.lineLengthMultiplier;
    }

    public void setLineLengthMultiplier(double lineLengthMultiplier) {
        this.lineLengthMultiplier = lineLengthMultiplier;
    }

    public boolean isScaleSymbolWithFont() {
        return this.scaleSymbolWithFont;
    }

    public void setScaleSymbolWithFont(boolean scaleSymbolWithFont) {
        this.scaleSymbolWithFont = scaleSymbolWithFont;
    }

    private boolean isFillPatternOn() {
        return this._fillPattern != null && this._fillPattern.getPattern() < 15;
    }

    public void setTextFitPolicy(int policy) {
        this.textFitPolicy = policy;
    }

    public int getTextFitPolicy() {
        return this.textFitPolicy;
    }

    public void setTextSplitChar(char[] schars) {
        this.textSplitChar = schars;
    }

    public char[] getTextSplitChar() {
        return this.textSplitChar;
    }

    public void setTextSplitCharDrop(boolean b) {
        this.textSplitCharDrop = b;
    }

    public boolean isTextSplitCharDrop() {
        return this.textSplitCharDrop;
    }

    public void setTextSplitJustify(float justify) {
        this.textSplitJustify = justify;
    }

    public float getTextSplitJustify() {
        return this.textSplitJustify;
    }

    public void setHotelText(boolean b) {
        this.hotelText = b;
        if (this.hotelText) {
            this.setTheta(0.0);
            this.setAlignmentY(0.5f);
        }
    }

    public boolean isHotelText() {
        return this.hotelText;
    }

    public boolean isNoMargin() {
        return this.noMargin;
    }

    public void setNoMargin(boolean noMargin) {
        this.noMargin = noMargin;
    }

    public int getItemLineLength() {
        return this.itemLineLength;
    }

    public void setItemLineLength(int itemLineLength) {
        this.itemLineLength = itemLineLength;
    }

    public double getCustomHeightScale() {
        return this.customHeightScale;
    }

    public void setCustomHeightScale(double customHeightScale) {
        this.customHeightScale = customHeightScale;
    }

    public double getCustomChickletAspect() {
        return this.customChickletAspect;
    }

    public void setCustomChickletAspect(double customChickletAspect) {
        this.customChickletAspect = customChickletAspect;
    }

    public boolean isCustomHeightScale() {
        return this.customHeightScale == this.customHeightScale;
    }

    public boolean isCustomChickletAspect() {
        return this.customChickletAspect == this.customChickletAspect;
    }

    public boolean isSwatchOutlineOn() {
        return this.swatchOutlineOn;
    }

    public double getCustomChickletHeight() {
        return this.customChickletHeight;
    }

    public void setCustomChickletHeight(double customChickletHeight) {
        this.customChickletHeight = customChickletHeight;
    }

    public boolean isCustomChickletHeight() {
        return this.customChickletHeight == this.customChickletHeight;
    }

    private String[] splitLabelToHotelText(String label) {
        if (label == null || label.length() < 2) {
            return new String[]{label};
        }
        int length = label.length();
        String[] hotelText = new String[length];
        for (int i = 0; i < length; ++i) {
            hotelText[i] = label.substring(i, i + 1);
        }
        return hotelText;
    }
}

