/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.entry;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.RB;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;

public class AxisLegend
extends GridPanel {
    public static final String RB_KEY = "AxisLegend.";
    private int idx = 1;
    private String base = null;
    private TextStyle titleStyle = new TextStyle();
    private String title = null;
    private TextStyle valueStyle = new TextStyle();
    private Vector values;
    private boolean antialiased = false;
    private int _across = -1;
    private int _down = -1;
    private boolean clippingAllowed = false;
    private ArrayList axes = new ArrayList();
    private int defaultPadding = 5;

    public boolean isClippingAllowed() {
        return this.clippingAllowed;
    }

    public void setClippingAllowed(boolean b) {
        this.clippingAllowed = b;
    }

    public void addAxis(VRectAxis axis) {
        DataRange range = axis.getDataRange(axis.getDimension());
        if (!(range instanceof DiscreteRange)) {
            return;
        }
        DiscreteRange dr = (DiscreteRange)range;
        this.axes.add(axis);
        int order = axis.getTickValueOrder();
        if (order != 0 && dr instanceof OrdinalRange && !((OrdinalRange)dr).isChangedToDiscrete()) {
            ((OrdinalRange)dr).sortValues();
            this.values = (Vector)dr.getValues().clone();
        } else {
            if (this.values == null) {
                this.values = (Vector)dr.getValues().clone();
            }
            if (order == 4 || order == 6) {
                int sortOrder = order == 4 ? 1 : 2;
                Sort.StringComparator myComparator = new Sort.StringComparator(sortOrder, Locale.getDefault(), StatGraph.collation);
                Collections.sort(this.values, myComparator);
            }
        }
        String[] useLabels = new String[this.values.size()];
        for (int i = 0; i < useLabels.length; ++i) {
            useLabels[i] = this.base == null ? Integer.toString(i + 1) : this.base + Integer.toString(i + 1);
        }
        axis.clearFitStrategy();
        axis.setTickLabeling("THIN");
        axis.setTickLabels(useLabels);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(TextStyle style) {
        this.titleStyle = style;
    }

    public TextStyle getValueStyle() {
        return this.valueStyle;
    }

    public void setValueStyle(TextStyle style) {
        this.valueStyle = style;
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean b) {
        this.antialiased = b;
    }

    public int getAcross() {
        return this._across;
    }

    public void setAcross(int across) {
        this._across = across;
    }

    public int getDown() {
        return this._down;
    }

    public void setDown(int down) {
        this._down = down;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    private int getColumnSpacing() {
        FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
        return fm.stringWidth("XXX");
    }

    private int getItemSpacing() {
        FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
        return fm.stringWidth("XX");
    }

    private int getDefaultPadding() {
        return (int)((double)this.defaultPadding * StatGraph.getGapScaleFactor());
    }

    protected int getContainerWidth() {
        int width = 0;
        Container container = this.getParent();
        if (container instanceof OverlayContainer) {
            width = ((OverlayContainer)container).getPreferredDataAreaSize().width;
        } else if (container instanceof GridPanel) {
            int index = -1;
            int maxColumn = -1;
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i].equals(this)) {
                    index = i;
                }
                if (maxColumn >= ((GridPanel)container).getColumn(i)) continue;
                maxColumn = ((GridPanel)container).getColumn(i);
            }
            if (maxColumn == 0 && ((GridPanel)container).getColumn(index) == 0) {
                Insets inParent = container.getParent().getInsets();
                Insets inContainer = container.getInsets();
                width = container.getParent().getSize().width - inParent.left - inParent.right - inContainer.left - inContainer.right;
            }
        } else if (container instanceof TrellisPlot) {
            Insets in = container.getParent().getInsets();
            width = ((TrellisPlot)container).getParent().getSize().width - in.left - in.right;
            width = (int)((double)width * 0.875);
        }
        if (width == 0) {
            width = (int)(0.875 * (double)this.getStatGraphPanel().getSize().width);
        }
        return width;
    }

    private StatGraphPanel getStatGraphPanel() {
        Container comp;
        for (comp = this.getParent(); comp != null && !(comp instanceof StatGraphPanel); comp = comp.getParent()) {
        }
        return (StatGraphPanel)comp;
    }

    private boolean isClipped(int x, int y, int w, int h) {
        if (this._across < 0 && this._down < 0) {
            return false;
        }
        Container parent = this.getParent();
        Insets pi = parent.getInsets();
        Rectangle parentBounds = new Rectangle(pi.left, pi.top, parent.getWidth() - pi.left - pi.right, parent.getHeight() - pi.top - pi.bottom);
        Dimension ps = this.getPreferredSize();
        return !parentBounds.contains(x, y, w, h) || w < ps.width - 1 || h < ps.height - 1;
    }

    public void build() {
        if (this.axes.size() == 0) {
            return;
        }
        this.removeAll();
        this.idx = 1;
        int columnSpacing = this.getColumnSpacing();
        int itemSpacing = this.getItemSpacing();
        int pad = this.getDefaultPadding();
        if (this.getOrder() == 0) {
            int across = this._across;
            if (across <= 0) {
                across = this.computeAcross(columnSpacing, itemSpacing, pad);
            }
            if (across == 0) {
                return;
            }
            if (this.title == null) {
                this.setColumns(2 * across);
            } else {
                this.setColumns(2 * across + 1);
            }
            for (int i = 0; i < this.values.size(); ++i) {
                if (this.title != null && i % across == 0) {
                    this.addTitleColumnItem(i);
                }
                this.addNewKey();
                this.addNewValue(i);
            }
        } else {
            int across;
            int down = this._down;
            if (down <= 0) {
                across = this.computeAcross(columnSpacing, itemSpacing, pad);
                down = (int)Math.ceil((double)this.values.size() / (double)across);
            }
            this.setRows(down);
            for (int i = 0; i < down; ++i) {
                this.addTitleColumnItem(i);
            }
            across = (int)Math.ceil((double)this.values.size() / (double)down);
            int nextVal = 0;
            for (int i = 0; i < 2 * across; ++i) {
                int j;
                if (i % 2 == 0) {
                    for (j = 0; j < down; ++j) {
                        this.addNewKey();
                    }
                    continue;
                }
                for (j = 0; j < down; ++j) {
                    this.addNewValue(nextVal++);
                }
            }
        }
        this._setColumnGutters(columnSpacing, itemSpacing, pad);
    }

    public void _setColumnGutters(int colSpacing, int itemSpacing, int pad) {
        int nCols;
        if (this.getOrder() == 0) {
            nCols = this.getColumns();
            if (nCols > this._cellComponentCount) {
                nCols = this._cellComponentCount;
            }
        } else {
            int nRows = this.getRows();
            if (nRows > this._cellComponentCount) {
                nRows = this._cellComponentCount;
            }
            nCols = (this._cellComponentCount + nRows - 1) / nRows;
        }
        int[] gutters = new int[nCols + 1];
        gutters[0] = gutters[nCols] = pad;
        for (int i = 1; i < nCols; ++i) {
            gutters[i] = this.title == null ? (i % 2 != 0 ? itemSpacing : colSpacing) : (i == 0 ? colSpacing : (i % 2 == 0 ? itemSpacing : colSpacing));
        }
        this.setColumnGutter(gutters);
    }

    private int computeAcross(int columnSpacing, int itemSpacing, int pad) {
        int width = this.getContainerWidth() + 2 * pad;
        String maxString = "";
        for (int i = 0; i < this.values.size(); ++i) {
            if (((String)this.values.get(i)).length() <= maxString.length()) continue;
            maxString = (String)this.values.get(i);
        }
        FontMetrics fm = StatGraph.getFontMetrics(this.valueStyle.getFont());
        int vw = fm.stringWidth(maxString);
        int kw = fm.stringWidth(Integer.toString(this.values.size()));
        int unit = vw + kw + columnSpacing + itemSpacing;
        fm = StatGraph.getFontMetrics(this.titleStyle.getFont());
        int titleLen = this.title == null ? 0 : fm.stringWidth(this.title) + columnSpacing;
        int a = (width - titleLen) / unit;
        return a > 0 ? a : 1;
    }

    private void addTitleColumnItem(int idx) {
        Entry t = idx == 0 ? new Entry(this.title) : new Entry();
        t.setAlignmentX(0.0f);
        t.setFont(this.titleStyle.getFont());
        t.setForeground(this.titleStyle.getColor());
        t.setTextAntiAliased(this.antialiased);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.add((Component)t, c);
    }

    private String getNextKey() {
        if (this.idx > this.values.size()) {
            return " ";
        }
        if (this.base != null) {
            return this.base + Integer.toString(this.idx++);
        }
        return Integer.toString(this.idx++);
    }

    private void addNewKey() {
        Entry key = new Entry(this.getNextKey());
        key.setAlignmentX(1.0f);
        key.setFont(this.valueStyle.getFont());
        key.setForeground(this.valueStyle.getColor());
        key.setTextAntiAliased(this.antialiased);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.add((Component)key, c);
    }

    private void addNewValue(int idx) {
        if (idx >= this.values.size()) {
            return;
        }
        Entry value = new Entry((String)this.values.get(idx));
        value.setAlignmentX(0.0f);
        value.setFont(this.valueStyle.getFont());
        value.setForeground(this.valueStyle.getColor());
        value.setTextAntiAliased(this.antialiased);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        this.add((Component)value, c);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (!this.isVisible() || this.clippingAllowed) {
            super.setBounds(x, y, w, h);
            return;
        }
        if (this._across > 0 || this._down > 0) {
            Container parent = this.getParent();
            if (parent.getWidth() == 0 || parent.getHeight() == 0) {
                super.setBounds(x, y, w, h);
                return;
            }
            Insets pi = parent.getInsets();
            Rectangle parentBounds = new Rectangle(pi.left, pi.top, parent.getWidth() - pi.left - pi.right, parent.getHeight() - pi.top - pi.bottom);
            Dimension ps = this.getPreferredSize();
            if (!parentBounds.contains(x, y, w, h) || w < ps.width - 1 || h < ps.height - 1) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "clipping.txt"));
                StatGraphPanel root = this.getStatGraphPanel();
                parent.remove(this);
                this.setVisible(false);
                if (root != null) {
                    root.invalidate();
                    root.validate();
                }
                return;
            }
        }
        super.setBounds(x, y, w, h);
    }
}

