/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.encoder;

import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringVectorVariable;
import java.util.HashMap;
import java.util.Iterator;

public class ShapeEncoder
extends Encoder {
    public HashMap shapeList;
    public int[] shapeArray;

    public ShapeEncoder(DiscreteRange range, HashMap shapeList) {
        this.input = range;
        this.shapeList = shapeList;
        this.updateValueMap();
    }

    @Override
    public DataRange getInput() {
        return this.input;
    }

    @Override
    protected void updateValueMap() {
        this.outputMap = null;
        if (this.input instanceof DiscreteRange) {
            Iterator eKeys = this.shapeList.keySet().iterator();
            StringToNumberMap map = new StringToNumberMap();
            String[] vec = new String[this.shapeList.keySet().size()];
            int cnt = 0;
            while (eKeys.hasNext()) {
                Object keyObject = eKeys.next();
                Number shapeId = (Number)this.shapeList.get(keyObject);
                if (shapeId == null) continue;
                map.add((String)keyObject, shapeId);
                vec[cnt++] = (String)keyObject;
            }
            StringVectorVariable sv = new StringVectorVariable();
            sv.setBlankMissing(false);
            sv.connectFrom(vec);
            map.addStringPipe(sv.value);
            this.outputMap = map;
        }
    }
}

