/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.encoder;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.gtk.BrokenContinuousRangeToNumericMap;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousTimeToNumericMap;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;

public class BrokenPositionEncoder
extends PositionEncoder {
    public static int BROKEN_GAP = StatGraph.getExtraPadding();
    public static double RESERVED_OFFSET = 2.5 * StatGraph.dataDPIScaleFactor;
    private ContinuousRange[] inputRanges;
    private ContinuousRangeToNumericMap[] rangeOutputMaps;
    public static double DATA_MIN = -1.7976931348623157E308;
    public static double DATA_MAX = Double.MAX_VALUE;

    public BrokenPositionEncoder(ContinuousRange[] ranges) {
        this.inputRanges = ranges;
        RESERVED_OFFSET = 2.5 * StatGraph.dataDPIScaleFactor;
    }

    public void setInputRanges(ContinuousRange[] ranges) {
        this.inputRanges = ranges;
    }

    public ContinuousRange[] getInputRanges() {
        if (this.inputRanges != null) {
            if (this.inputRanges[0].getMin() == DATA_MIN) {
                this.inputRanges[0].setMin(((ContinuousRange)this.input).getMin());
            }
            if (this.inputRanges[this.inputRanges.length - 1].getMax() == DATA_MAX) {
                this.inputRanges[this.inputRanges.length - 1].setMax(((ContinuousRange)this.input).getMax());
            }
        }
        return this.inputRanges;
    }

    public ContinuousRangeToNumericMap[] getRangeOutputMaps() {
        return this.rangeOutputMaps;
    }

    @Override
    protected void updateValueMap() {
        int i;
        ContinuousRangeToNumericMap map;
        if (this.input == null || this.inputRanges == null) {
            this.outputMap = null;
            return;
        }
        if (this.outputMin == this.outputMax) {
            if (this.outputMin != 0.0) {
                this.outputMin -= 1.0E-8 * Math.abs(this.outputMin);
                this.outputMax += 1.0E-8 * Math.abs(this.outputMax);
            } else {
                this.outputMin = -1.0E-8;
                this.outputMax = 1.0E-8;
            }
        }
        ContinuousRange[] inputRanges = this.getInputRanges();
        int numRan = inputRanges.length;
        double rangeInTotal = 0.0;
        ContinuousRange cr = (ContinuousRange)this.input;
        SASFormat fmt = cr.getFormat();
        if (this.type == 2 && fmt != null && fmt instanceof SASDateTimeFormat) {
            if (this.outputMap instanceof ContinuousTimeToNumericMap) {
                this.outputMap.setOwner(null);
                map = (ContinuousTimeToNumericMap)this.outputMap;
            } else {
                map = new ContinuousTimeToNumericMap();
            }
            this.rangeOutputMaps = new ContinuousTimeToNumericMap[numRan];
            for (i = 0; i < numRan; ++i) {
                this.rangeOutputMaps[i] = new ContinuousTimeToNumericMap();
            }
        } else {
            if (this.outputMap instanceof ContinuousRangeToNumericMap && !(this.outputMap instanceof ContinuousTimeToNumericMap)) {
                this.outputMap.setOwner(null);
                map = (ContinuousRangeToNumericMap)this.outputMap;
            } else {
                map = new ContinuousRangeToNumericMap();
            }
            this.rangeOutputMaps = new ContinuousRangeToNumericMap[numRan];
            for (i = 0; i < numRan; ++i) {
                this.rangeOutputMaps[i] = new ContinuousRangeToNumericMap();
            }
        }
        if (this.reversed) {
            map.setInputMin(cr.getMax());
            map.setInputMax(cr.getMin());
            for (i = 0; i < numRan; ++i) {
                int idx = numRan - 1 - i;
                this.rangeOutputMaps[i].setInputMin(inputRanges[idx].getMax());
                this.rangeOutputMaps[i].setInputMax(inputRanges[idx].getMin());
                rangeInTotal += inputRanges[idx].getMax() - inputRanges[idx].getMin();
            }
        } else {
            map.setInputMin(cr.getMin());
            map.setInputMax(cr.getMax());
            for (i = 0; i < numRan; ++i) {
                this.rangeOutputMaps[i].setInputMin(inputRanges[i].getMin());
                this.rangeOutputMaps[i].setInputMax(inputRanges[i].getMax());
                rangeInTotal += inputRanges[i].getMax() - inputRanges[i].getMin();
            }
        }
        map.setOutputMin(this.outputMin);
        map.setOutputMax(this.outputMax);
        double gap = (double)BROKEN_GAP + 2.0 * RESERVED_OFFSET;
        double lengthForData = this.outputMax - this.outputMin - (double)(numRan - 1) * gap;
        double start = this.outputMin;
        for (int i2 = 0; i2 < numRan; ++i2) {
            int idx = this.reversed ? numRan - 1 - i2 : i2;
            double len = rangeInTotal == 0.0 ? lengthForData / (double)numRan : lengthForData * (inputRanges[idx].getMax() - inputRanges[idx].getMin()) / rangeInTotal;
            double end = start + len;
            this.rangeOutputMaps[i2].setOutputMin(start);
            this.rangeOutputMaps[i2].setOutputMax(end);
            start = end + gap;
        }
        this.outputMap = map;
    }

    public void setValueMap(ValueMap map) {
        this.outputMap = map;
    }

    public BrokenContinuousRangeToNumericMap getBrokenValueMap() {
        int idx = -1;
        for (int i = 0; i < this.rangeOutputMaps.length; ++i) {
            if (this.outputMap != this.rangeOutputMaps[i]) continue;
            idx = i;
        }
        BrokenContinuousRangeToNumericMap map = new BrokenContinuousRangeToNumericMap((ContinuousRangeToNumericMap)this.outputMap);
        if (idx >= 0) {
            map.setInputMinExclude(this.inputRanges[idx].isMinExclude());
            map.setInputMaxExclude(this.inputRanges[idx].isMaxExclude());
        }
        return map;
    }
}

