/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.decisiontree.util;

import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.regions.DecisionTreeRegion;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class NodeLinkDiagramItem {
    protected DecisionTreeRegion decisionTree;
    protected String id;
    protected int obsIndex = -1;
    protected Vector<NodeLinkDiagramItem> parent = null;
    boolean dirty = true;

    public NodeLinkDiagramItem(String id) {
        this.id = id;
    }

    public NodeLinkDiagramItem(DecisionTreeRegion tree, int index) {
        this.decisionTree = tree;
        this.obsIndex = index;
        this.id = "NodeLinkDiagram" + Integer.toString(this.obsIndex);
    }

    public String getId() {
        return this.id;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public void setObsIndex(int index) {
        this.obsIndex = index;
        this.id = this.decisionTree.getStringValue((short)2001, this.obsIndex);
    }

    public int getObsIndex() {
        return this.obsIndex;
    }

    public Vector<NodeLinkDiagramItem> getParent() {
        return this.parent;
    }

    public void setParent(Vector<NodeLinkDiagramItem> parent) {
        this.parent = parent;
    }

    public DecisionTreeRegion getDecisionTree() {
        return this.decisionTree;
    }

    public void setDecisionTree(DecisionTreeRegion decisionTree) {
        this.decisionTree = decisionTree;
    }

    boolean hasData() {
        CRD crd = this.decisionTree.getCRD();
        if (crd == null) {
            return false;
        }
        DataModel data = crd.getSrcModel();
        return data != null && data.getRowCount() > 0;
    }

    double getNumericValue(short role) {
        return this.decisionTree.getNumericValue(role, this.obsIndex);
    }

    String getStringValue(short role) {
        return this.decisionTree.getStringValue(role, this.obsIndex);
    }

    String getFormattedValue(short role) {
        return this.decisionTree.getFormattedValue(role, this.obsIndex);
    }

    String getLabelValue(short role) {
        return this.decisionTree.getLabelValue(role);
    }

    void postConstructionInit() {
    }

    void dispose() {
    }

    Rectangle2D measure() {
        return null;
    }

    public Rectangle2D getBoundsAtOrigin(Point2D origin) {
        return null;
    }

    void updateDisplayListNode(Graphics g) {
    }

    void createOverviewDisplayListNode(Graphics editor, Rectangle2D overrideBounds, Color blendColor) {
    }

    public Rectangle2D getBounds() {
        return null;
    }
}

