/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.decisiontree.util;

import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeLinkDiagramItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.Port;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LinkItem
extends NodeLinkDiagramItem {
    public static final int NLD_LINK_DIRECT = 0;
    public static final int NLD_LINK_ORTHOGONAL = 1;
    public static final int NLD_LINK_SPLINE = 2;
    public static final int NLD_LINK_SPLINE_JAVA = 3;
    private int linkType = 2;
    private Port fromPort;
    private Port toPort;
    private static Line2D temp1 = new Line2D.Double();
    private static Line2D temp2 = new Line2D.Double();
    private NodeItem fromNode = null;
    private NodeItem toNode = null;
    private Color fillColor = new Color(127, 127, 127);
    private Color lineColor = new Color(32, 32, 32);
    private double lineThickness = 1.0;
    private int lineStyle = 0;
    private double lineFactorMultiplier = 1.0;
    private Dimension arrowSize = new Dimension(22, 17);
    private boolean fromArrowVisible = false;
    private boolean toArrowVisible = false;
    private boolean outlineVisible = false;
    private double transparency = 0.0;
    private double fromOffset = 0.0;
    private double toOffset = 0.0;
    private Point2D fromPoint;
    private Point2D toPoint;
    private boolean antialias = true;
    private boolean antialiasText = true;
    private double dataDPIScaleFactor = 1.0;
    private double linearScaleFactor = 1.0;
    private GeneralPath fromArrow = null;
    private GeneralPath toArrow = null;
    private GeneralPath polylines = null;
    private boolean modifiedFlag = true;
    private boolean flowDirectionHorizontal = false;
    private boolean drawPolygon = false;

    public LinkItem(String id) {
        super(id);
    }

    public LinkItem(String id, int linkType) {
        super(id);
        this.linkType = linkType;
    }

    Port getFromPort() {
        return this.fromPort;
    }

    Port getToPort() {
        return this.toPort;
    }

    public NodeItem getFromNode() {
        return this.fromPort == null ? null : this.fromPort.getNode();
    }

    public NodeItem getToNode() {
        return this.toPort == null ? null : this.toPort.getNode();
    }

    public void setFromPort(Port port) {
        if (this.fromPort == port) {
            return;
        }
        if (this.fromPort != null) {
            this.fromPort.removeLink(this);
        }
        this.fromPort = port;
        if (this.fromPort != null) {
            this.fromPort.addLink(this);
        }
    }

    public void setToPort(Port port) {
        if (this.toPort == port) {
            return;
        }
        if (this.toPort != null) {
            this.toPort.removeLink(this);
        }
        this.toPort = port;
        if (this.toPort != null) {
            this.toPort.addLink(this);
        }
    }

    @Override
    public void dispose() {
        if (this.fromPort != null) {
            this.fromPort.removeLink(this);
        }
        if (this.toPort != null) {
            this.toPort.removeLink(this);
        }
    }

    static LinkItem getLink(NodeItem fromNode, NodeItem toNode) {
        LinkItem link;
        block4: {
            int toLinkCount;
            Port fromPort = fromNode == null ? null : fromNode.getOutputPort();
            Port toPort = toNode == null ? null : toNode.getInputPort();
            link = null;
            if (fromPort == null || toPort == null) break block4;
            int fromLinkCount = fromPort.getNumLinks();
            if (fromLinkCount < (toLinkCount = toPort.getNumLinks())) {
                for (int i = 0; i < fromLinkCount; ++i) {
                    LinkItem l = fromPort.getLinkAt(i);
                    if (l.getToPort() != toPort) continue;
                    link = l;
                    break;
                }
            } else {
                for (int i = 0; i < toLinkCount; ++i) {
                    LinkItem l = toPort.getLinkAt(i);
                    if (l.getFromPort() != fromPort) continue;
                    link = l;
                    break;
                }
            }
        }
        return link;
    }

    public boolean isModified() {
        return this.modifiedFlag;
    }

    public double getTransparency() {
        return this.transparency;
    }

    public void setTransparency(double transparency) {
        this.transparency = transparency;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public double getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(double lineThickness) {
        this.lineThickness = lineThickness;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }

    public int getLinkType() {
        return this.linkType;
    }

    public void setLinkType(int linkType) {
        this.linkType = linkType;
    }

    public boolean isFromArrowVisible() {
        return this.fromArrowVisible;
    }

    public void setFromArrowVisible(boolean fromArrowVisible) {
        this.fromArrowVisible = fromArrowVisible;
    }

    public boolean isToArrowVisible() {
        return this.toArrowVisible;
    }

    public void setToArrowVisible(boolean toArrowVisible) {
        this.toArrowVisible = toArrowVisible;
    }

    public boolean isOutlineVisible() {
        return this.outlineVisible;
    }

    public void setOutlineVisible(boolean outlineVisible) {
        this.outlineVisible = outlineVisible;
    }

    public double getFromOffset() {
        return this.fromOffset;
    }

    public void setFromOffset(double fromOffset) {
        this.fromOffset = fromOffset;
    }

    public double getToOffset() {
        return this.toOffset;
    }

    public void setToOffset(double toOffset) {
        this.toOffset = toOffset;
    }

    public Point2D getFromPoint() {
        return this.fromPoint;
    }

    public void setFromPoint(Point2D fromPoint) {
        this.fromPoint = fromPoint;
    }

    public Point2D getToPoint() {
        return this.toPoint;
    }

    public void setToPoint(Point2D toPoint) {
        this.toPoint = toPoint;
    }

    public void setLineNodes(NodeItem from, NodeItem to) {
        this.fromNode = from;
        this.toNode = to;
        this.modifiedFlag = true;
    }

    public void setThickSpline(NodeItem pFromNLDNode, NodeItem pToNLDNode, double fromOffset, double toOffset, double thickness) {
        this.toNode = pToNLDNode;
        this.fromNode = pFromNLDNode;
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        this.lineThickness = thickness;
        this.linkType = 2;
        this.modifiedFlag = true;
    }

    public void initLink(Graphics2D gc) {
        if (this.fromNode == null || this.toNode == null) {
            return;
        }
        switch (this.linkType) {
            case 0: {
                this.initDirectLink(gc);
                break;
            }
            case 1: {
                this.initOrthogonalLink(gc);
                break;
            }
            case 2: 
            case 3: {
                this.initSplineLink(gc);
                break;
            }
        }
        this.modifiedFlag = false;
    }

    private GeneralPath createArrow(Point2D p, double angle) {
        double arrowBase = (double)this.arrowSize.width * this.linearScaleFactor;
        double arrowLength = (double)this.arrowSize.height * this.linearScaleFactor;
        double x = p.getX();
        double y = p.getY();
        double aw = arrowBase;
        double al = arrowLength;
        GeneralPath ar = new GeneralPath(0, 3);
        ar.moveTo(x + al, y - aw / 2.0);
        ar.lineTo(x, y);
        ar.lineTo(x + al, y + aw / 2.0);
        AffineTransform r = AffineTransform.getRotateInstance(angle, x, y);
        ar.transform(r);
        return ar;
    }

    public static Point2D getIntersectionPoint(Line2D lineA, Line2D lineB) {
        double x1 = lineA.getX1();
        double y1 = lineA.getY1();
        double x2 = lineA.getX2();
        double y2 = lineA.getY2();
        double x3 = lineB.getX1();
        double y3 = lineB.getY1();
        double x4 = lineB.getX2();
        double y4 = lineB.getY2();
        Point2D.Double p = null;
        double d = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        if (d != 0.0) {
            double xi = ((x3 - x4) * (x1 * y2 - y1 * x2) - (x1 - x2) * (x3 * y4 - y3 * x4)) / d;
            double yi = ((y3 - y4) * (x1 * y2 - y1 * x2) - (y1 - y2) * (x3 * y4 - y3 * x4)) / d;
            p = new Point2D.Double(xi, yi);
        }
        return p;
    }

    static double calculateDir(Point2D from, Point2D to) {
        double dx = to.getX() - from.getX();
        double dy = to.getY() - from.getY();
        double ang = 0.0;
        if (dx == 0.0) {
            if (dy > 0.0) {
                ang = 1.5707963267948966;
            } else if (dy < 0.0) {
                ang = -1.5707963267948966;
            }
        } else if (dy == 0.0) {
            if (dx > 0.0) {
                ang = 0.0;
            } else if (dx < 0.0) {
                ang = Math.PI;
            }
        } else {
            ang = dx > 0.0 && dy > 0.0 || dx > 0.0 && dy < 0.0 ? Math.atan(dy / dx) : (dx < 0.0 && dy > 0.0 ? Math.PI - Math.atan(-dy / dx) : Math.PI + Math.atan(dy / dx));
        }
        return ang;
    }

    private void initDirectLink(Graphics2D gc) {
        Rectangle2D fromBox = this.fromNode.getBounds();
        Rectangle2D toBox = this.toNode.getBounds();
        if (fromBox.getY() > toBox.getY()) {
            fromBox = this.toNode.getBounds();
            toBox = this.fromNode.getBounds();
        }
        double offset = 0.0;
        Point2D.Double fromIntersect = new Point2D.Double(fromBox.getCenterX(), fromBox.getMaxY());
        Point2D.Double toIntersect = new Point2D.Double(toBox.getCenterX(), toBox.getMinY());
        this.polylines = new GeneralPath();
        this.polylines.moveTo(fromBox.getCenterX(), fromBox.getCenterY());
        this.polylines.lineTo(fromBox.getCenterX(), fromBox.getMaxY() + offset);
        this.polylines.lineTo(toBox.getCenterX(), toBox.getMinY() - offset);
        this.polylines.lineTo(toBox.getCenterX(), toBox.getCenterY());
    }

    private void initOrthogonalLink(Graphics2D gc) {
        Rectangle2D fromBox = this.fromNode.getBounds();
        Rectangle2D toBox = this.toNode.getBounds();
        this.polylines = new GeneralPath();
        if (fromBox.getX() == toBox.getX()) {
            this.polylines.moveTo(fromBox.getCenterX(), fromBox.getCenterY());
            this.polylines.lineTo(toBox.getCenterX(), toBox.getCenterY());
        } else {
            Point2D.Double center = new Point2D.Double((fromBox.getCenterX() + toBox.getCenterX()) / 2.0, (fromBox.getCenterY() + toBox.getCenterY()) / 2.0);
            this.polylines.moveTo(fromBox.getCenterX(), fromBox.getCenterY());
            this.polylines.lineTo(fromBox.getCenterX(), ((Point2D)center).getY());
            this.polylines.lineTo(toBox.getCenterX(), ((Point2D)center).getY());
            this.polylines.lineTo(toBox.getCenterX(), toBox.getCenterY());
        }
    }

    private void initSplineLink(Graphics2D gc) {
        Point2D fromCenter = this.fromNode.getCenter();
        Point2D toCenter = this.toNode.getCenter();
        double startStemLength = this.fromNode.getHeight() / 2.0;
        double endStemLength = this.toNode.getHeight() / 2.0;
        if (fromCenter.getY() > toCenter.getY()) {
            fromCenter = this.toNode.getCenter();
            toCenter = this.fromNode.getCenter();
            startStemLength = this.toNode.getHeight() / 2.0;
            endStemLength = this.fromNode.getHeight() / 2.0;
        }
        if (this.fromOffset != 0.0) {
            fromCenter.setLocation(fromCenter.getX() + this.fromOffset, fromCenter.getY());
        }
        if (this.toOffset != 0.0) {
            toCenter.setLocation(toCenter.getX() + this.toOffset, toCenter.getY());
        }
        Point2D.Double fromIntersect = new Point2D.Double(fromCenter.getX(), fromCenter.getY() + startStemLength);
        Point2D.Double toIntersect = new Point2D.Double(toCenter.getX(), toCenter.getY() - endStemLength);
        Point2D.Double center = new Point2D.Double((((Point2D)fromIntersect).getX() + ((Point2D)toIntersect).getX()) / 2.0, (((Point2D)fromIntersect).getY() + ((Point2D)toIntersect).getY()) / 2.0);
        double distY = ((Point2D)toIntersect).getY() - ((Point2D)fromIntersect).getY();
        double halfWidth = Math.max(this.lineThickness / 2.0, 0.5);
        Point2D.Double controlPnt1 = new Point2D.Double(((Point2D)fromIntersect).getX(), ((Point2D)center).getY());
        Point2D.Double controlPnt2 = new Point2D.Double(((Point2D)toIntersect).getX(), ((Point2D)center).getY());
        this.polylines = new GeneralPath();
        this.polylines.setWindingRule(0);
        if (this.drawPolygon) {
            if (((Point2D)fromIntersect).getX() == ((Point2D)toIntersect).getX()) {
                this.polylines.moveTo(fromCenter.getX() - halfWidth, fromCenter.getY());
                this.polylines.lineTo(toCenter.getX() - halfWidth, toCenter.getY());
                this.polylines.lineTo(toCenter.getX() + halfWidth, toCenter.getY());
                this.polylines.lineTo(fromCenter.getX() + halfWidth, fromCenter.getY());
                this.polylines.lineTo(fromCenter.getX() - halfWidth, fromCenter.getY());
            } else if (this.linkType == 3) {
                if (startStemLength > 0.0) {
                    this.polylines.moveTo(fromCenter.getX() - halfWidth, fromCenter.getY());
                    this.polylines.lineTo(((Point2D)fromIntersect).getX() - halfWidth, ((Point2D)fromIntersect).getY());
                }
                this.polylines.curveTo(((Point2D)controlPnt1).getX() - halfWidth, ((Point2D)controlPnt1).getY(), ((Point2D)controlPnt2).getX() - halfWidth, ((Point2D)controlPnt2).getY(), ((Point2D)toIntersect).getX() - halfWidth, ((Point2D)toIntersect).getY());
                if (endStemLength > 0.0) {
                    this.polylines.lineTo(toCenter.getX() - halfWidth, toCenter.getY());
                    this.polylines.lineTo(toCenter.getX() + halfWidth, toCenter.getY());
                }
                this.polylines.lineTo(((Point2D)toIntersect).getX() + halfWidth, ((Point2D)toIntersect).getY());
                this.polylines.curveTo(((Point2D)controlPnt2).getX() + halfWidth, ((Point2D)controlPnt2).getY(), ((Point2D)controlPnt1).getX() + halfWidth, ((Point2D)controlPnt1).getY(), ((Point2D)fromIntersect).getX() + halfWidth, ((Point2D)fromIntersect).getY());
                if (startStemLength > 0.0) {
                    this.polylines.lineTo(fromCenter.getX() + halfWidth, fromCenter.getY());
                    this.polylines.lineTo(fromCenter.getX() - halfWidth, fromCenter.getY());
                }
            } else {
                Point2D.Double p1 = fromIntersect;
                Point2D.Double p2 = new Point2D.Double(((Point2D)fromIntersect).getX(), ((Point2D)center).getY());
                Point2D.Double p3 = new Point2D.Double(((Point2D)toIntersect).getX(), ((Point2D)center).getY());
                Point2D.Double p4 = toIntersect;
                Point2D.Double[] offset1 = LinkItem.generateOffsetBezier2(p1, p2, p3, p4, halfWidth);
                Point2D.Double[] offset2 = LinkItem.generateOffsetBezier2(p4, p3, p2, p1, halfWidth);
                this.polylines.moveTo(offset1[0].x, offset1[0].y);
                this.polylines.curveTo(offset1[1].x, offset1[1].y, offset1[2].x, offset1[2].y, offset1[3].x, offset1[3].y);
                this.polylines.curveTo(offset1[4].x, offset1[4].y, offset1[5].x, offset1[5].y, offset1[6].x, offset1[6].y);
                if (endStemLength > 0.0) {
                    Point2D.Double endStemVec = LinkItem.subtract(p4, p3);
                    LinkItem.normalize(endStemVec, endStemLength);
                    Point2D.Double endStemPt1 = LinkItem.add(offset1[6], endStemVec);
                    Point2D.Double endStemPt2 = LinkItem.add(offset2[0], endStemVec);
                    this.polylines.lineTo(endStemPt1.x, endStemPt1.y);
                    this.polylines.lineTo(endStemPt2.x, endStemPt2.y);
                }
                this.polylines.lineTo(offset2[0].x, offset2[0].y);
                this.polylines.curveTo(offset2[1].x, offset2[1].y, offset2[2].x, offset2[2].y, offset2[3].x, offset2[3].y);
                this.polylines.curveTo(offset2[4].x, offset2[4].y, offset2[5].x, offset2[5].y, offset2[6].x, offset2[6].y);
                if (startStemLength > 0.0) {
                    Point2D.Double startStemVec = LinkItem.subtract(p1, p2);
                    LinkItem.normalize(startStemVec, startStemLength);
                    Point2D.Double startStemPt1 = LinkItem.add(offset2[6], startStemVec);
                    Point2D.Double startStemPt2 = LinkItem.add(offset1[0], startStemVec);
                    this.polylines.lineTo(startStemPt1.x, startStemPt1.y);
                    this.polylines.lineTo(startStemPt2.x, startStemPt2.y);
                }
                this.polylines.lineTo(offset1[0].x, offset1[0].y);
            }
        } else if (((Point2D)fromIntersect).getX() == ((Point2D)toIntersect).getX()) {
            this.polylines.moveTo(fromCenter.getX(), fromCenter.getY());
            this.polylines.lineTo(toCenter.getX(), toCenter.getY());
        } else {
            if (startStemLength > 0.0) {
                this.polylines.moveTo(fromCenter.getX(), fromCenter.getY());
                this.polylines.lineTo(((Point2D)fromIntersect).getX(), ((Point2D)fromIntersect).getY());
            }
            this.polylines.curveTo(((Point2D)controlPnt1).getX(), ((Point2D)controlPnt1).getY(), ((Point2D)controlPnt2).getX(), ((Point2D)controlPnt2).getY(), ((Point2D)toIntersect).getX(), ((Point2D)toIntersect).getY());
            if (endStemLength > 0.0) {
                this.polylines.lineTo(toCenter.getX(), toCenter.getY());
            }
        }
    }

    private boolean shouldSkipRender(Rectangle renderArea) {
        return this.fromNode == null || this.toNode == null;
    }

    public void render(Graphics g, Rectangle renderArea) {
        this.fromNode = this.getFromNode();
        this.toNode = this.getToNode();
        if (this.shouldSkipRender(renderArea)) {
            return;
        }
        this.fromPoint = this.fromNode.getCenter();
        this.toPoint = this.toNode.getCenter();
        if (this.fromPoint.getX() != this.fromNode.getX() || this.fromPoint.getY() != this.fromNode.getY() || this.toPoint.getY() != this.toNode.getY() || this.toPoint.getX() != this.toPoint.getX()) {
            this.modifiedFlag = true;
        }
        Graphics2D gc = (Graphics2D)g;
        if (this.modifiedFlag) {
            this.initLink(gc);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.polylines != null) {
            if ((this.linkType == 2 || this.linkType == 3) && this.drawPolygon) {
                gc.setColor(this.fillColor);
                gc.fill(this.polylines);
            } else {
                Stroke savedStroke = gc.getStroke();
                BasicStroke stroke = LinkItem.getStroke(this.lineStyle, (float)this.lineThickness, (float)this.lineFactorMultiplier);
                gc.setStroke(stroke);
                gc.setColor(this.lineColor);
                gc.draw(this.polylines);
                gc.setStroke(savedStroke);
            }
        }
    }

    public static BasicStroke getStroke(int lineStyle, float lineWidth, float factorMultiplier) {
        BasicStroke bs;
        int mask = SASLinePatterns.getStipplePattern((int)lineStyle);
        int factor = SASLinePatterns.getStippleFactor((int)lineStyle);
        factor = Math.round((float)factor * factorMultiplier);
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] glPattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            glPattern[i] = dashes[index];
            ++i;
            --index;
        }
        float dashPhase = 0.0f;
        float[] dashArray = null;
        float lw = lineWidth;
        int stippleIndex = 0;
        if (lineWidth < 1.0f) {
            lw = 0.5f;
        }
        if (glPattern.length == 1) {
            bs = glPattern[0] < 0 ? null : new BasicStroke(lw, 1, 1);
        } else {
            if (glPattern[0] < 0 && glPattern[glPattern.length - 1] > 0) {
                ++stippleIndex;
                dashPhase = glPattern[1];
                dashArray = new float[glPattern.length];
                dashArray[glPattern.length - 1] = Math.abs(glPattern[0]);
            } else if (glPattern[0] < 0 && glPattern[glPattern.length - 1] < 0) {
                int n = glPattern.length - 1;
                glPattern[n] = glPattern[n] + glPattern[0];
                int[] newStipplePattern = new int[glPattern.length - 1];
                System.arraycopy(glPattern, 1, newStipplePattern, 0, glPattern.length - 1);
                glPattern = newStipplePattern;
                dashArray = new float[glPattern.length];
            } else {
                dashArray = new float[glPattern.length];
            }
            int dashIndex = 0;
            while (stippleIndex < glPattern.length) {
                dashArray[dashIndex] = Math.abs(glPattern[stippleIndex]);
                ++stippleIndex;
                ++dashIndex;
            }
            bs = new BasicStroke(lw, 1, 1, (int)Math.max(lineWidth, 1.0f), dashArray, dashPhase);
        }
        return bs;
    }

    public double getLineFactorMultiplier() {
        return this.lineFactorMultiplier;
    }

    public void setLineFactorMultiplier(double lineFactorMultiplier) {
        this.lineFactorMultiplier = lineFactorMultiplier;
    }

    public boolean isDrawPolygon() {
        return this.drawPolygon;
    }

    public void setDrawPolygon(boolean drawPolygon) {
        this.drawPolygon = drawPolygon;
    }

    private static Point2D.Double[] generateOffsetBezier2(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Point2D.Double p4, double offset) {
        Point2D.Double[] split1 = LinkItem.splitBezier(p1, p2, p3, p4, 0.5);
        Point2D.Double[] split2 = LinkItem.splitBezier(p4, p3, p2, p1, 0.5);
        Point2D.Double[] offset1 = LinkItem.generateOffsetBezierSegment(split1[0], split1[1], split1[2], split1[3], offset);
        Point2D.Double[] offset2 = LinkItem.generateOffsetBezierSegment(split2[3], split2[2], split2[1], split2[0], offset);
        return new Point2D.Double[]{offset1[0], offset1[1], offset1[2], offset1[3], offset2[1], offset2[2], offset2[3]};
    }

    private static Point2D.Double[] generateOffsetBezierSegment(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Point2D.Double p4, double offset) {
        Point2D.Double p3Offset;
        Point2D.Double p2Offset;
        Point2D.Double vec12 = LinkItem.subtract(p2, p1);
        Point2D.Double vec12Perp = LinkItem.getPerpendicular(vec12);
        LinkItem.normalize(vec12Perp, offset);
        Point2D.Double vec34 = LinkItem.subtract(p4, p3);
        Point2D.Double vec34Perp = LinkItem.getPerpendicular(vec34);
        LinkItem.normalize(vec34Perp, offset);
        Point2D.Double p1Offset = LinkItem.add(p1, vec12Perp);
        Point2D.Double p4Offset = LinkItem.add(p4, vec34Perp);
        Point2D.Double refPoint = LinkItem.getLineInt(p1, p2, p3, p4, null, false);
        if (refPoint == null) {
            p2Offset = LinkItem.add(p2, vec12Perp);
            p3Offset = LinkItem.add(p3, vec34Perp);
        } else {
            Point2D.Double vec1Ref = LinkItem.subtract(refPoint, p1);
            double vec12Ratio = LinkItem.length(vec12) / LinkItem.length(vec1Ref);
            Point2D.Double vec4Ref = LinkItem.subtract(refPoint, p4);
            double vec34Ratio = LinkItem.length(vec34) / LinkItem.length(vec4Ref);
            Point2D.Double refPointOffset = LinkItem.getLineInt(p1Offset, LinkItem.add(p1Offset, vec12), p4Offset, LinkItem.add(p4Offset, vec34), null, false);
            Point2D.Double vec1RefOffset = refPointOffset != null ? LinkItem.subtract(refPointOffset, p1Offset) : p1Offset;
            LinkItem.normalize(vec1RefOffset, LinkItem.length(vec1RefOffset) * vec12Ratio);
            p2Offset = LinkItem.add(p1Offset, vec1RefOffset);
            Point2D.Double vec4RefOffset = refPointOffset != null ? LinkItem.subtract(refPointOffset, p4Offset) : p4Offset;
            LinkItem.normalize(vec4RefOffset, LinkItem.length(vec4RefOffset) * vec34Ratio);
            p3Offset = LinkItem.add(p4Offset, vec4RefOffset);
        }
        return new Point2D.Double[]{p1Offset, p2Offset, p3Offset, p4Offset};
    }

    private static Point2D.Double[] splitBezier(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Point2D.Double p4, double t) {
        double x12 = (p2.x - p1.x) * t + p1.x;
        double y12 = (p2.y - p1.y) * t + p1.y;
        double x23 = (p3.x - p2.x) * t + p2.x;
        double y23 = (p3.y - p2.y) * t + p2.y;
        double x34 = (p4.x - p3.x) * t + p3.x;
        double y34 = (p4.y - p3.y) * t + p3.y;
        double x123 = (x23 - x12) * t + x12;
        double y123 = (y23 - y12) * t + y12;
        double x234 = (x34 - x23) * t + x23;
        double y234 = (y34 - y23) * t + y23;
        double x1234 = (x234 - x123) * t + x123;
        double y1234 = (y234 - y123) * t + y123;
        return new Point2D.Double[]{p1, new Point2D.Double(x12, y12), new Point2D.Double(x123, y123), new Point2D.Double(x1234, y1234)};
    }

    private static Point2D.Double getPerpendicular(Point2D.Double vec) {
        return new Point2D.Double(vec.y, -vec.x);
    }

    private static double length(Point2D.Double vec) {
        return Math.sqrt(vec.x * vec.x + vec.y * vec.y);
    }

    private static void normalize(Point2D.Double vec, double len) {
        double scale = len / LinkItem.length(vec);
        vec.x *= scale;
        vec.y *= scale;
    }

    private static Point2D.Double add(Point2D.Double vec1, Point2D.Double vec2) {
        return new Point2D.Double(vec1.x + vec2.x, vec1.y + vec2.y);
    }

    private static Point2D.Double subtract(Point2D.Double vec1, Point2D.Double vec2) {
        return new Point2D.Double(vec1.x - vec2.x, vec1.y - vec2.y);
    }

    private static Point2D.Double getLineInt(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, Point2D.Double p4, Point2D.Double result, boolean segment) {
        double nA = (p4.x - p3.x) * (p1.y - p3.y) - (p4.y - p3.y) * (p1.x - p3.x);
        double nB = (p2.x - p1.x) * (p1.y - p3.y) - (p2.y - p1.y) * (p1.x - p3.x);
        double d = (p4.y - p3.y) * (p2.x - p1.x) - (p4.x - p3.x) * (p2.y - p1.y);
        double uA = nA / d;
        double uB = nB / d;
        if (d == 0.0) {
            return null;
        }
        if (segment && (uA < 0.0 || uA > 1.0 || uB < 0.0 || uB > 1.0)) {
            return null;
        }
        if (result == null) {
            result = new Point2D.Double();
        }
        result.x = p1.x + uA * (p2.x - p1.x);
        result.y = p1.y + uA * (p2.y - p1.y);
        return result;
    }
}

