/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.decisiontree.util;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.LinkItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeItem;
import com.sas.graphics.applets.statgraph.sgchart.decisiontree.util.NodeLinkDiagramItem;
import com.sas.graphics.applets.statgraph.sgchart.regions.DecisionTreeRegion;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Vector;

public class DecisionTreeArrangement {
    private DecisionTreeRegion target;
    private NodeItem targetRoot = null;
    private int targetDepth = -1;
    private int targetDisplayDepth = -1;
    private double siblingSeperationSpace = 50.0;
    private double parentSeperationSpace = 150.0;
    private boolean spaceLevelBySubtreeWidth = true;
    HashMap<NodeItem, NodeItem> leftNeighbors = new HashMap();
    HashMap<NodeItem, NodeItem> rightNeighbors = new HashMap();
    private Vector<Double> levelSpacing = new Vector();
    private Dimension graphSize = new Dimension(0, 0);
    private boolean scaleToFit = true;

    public DecisionTreeArrangement(DecisionTreeRegion target) {
        this.target = target;
    }

    public void setRoot(NodeItem root) {
        this.targetRoot = root;
    }

    public void setDisplayDepth(int displayDepth) {
        this.targetDisplayDepth = displayDepth;
    }

    public void setGraphSize(int w, int h) {
        this.graphSize.width = w;
        this.graphSize.height = h;
    }

    public void setScaleToFit(boolean fit) {
        this.scaleToFit = fit;
    }

    public double getSiblingSeperationSpace() {
        return this.siblingSeperationSpace;
    }

    public void setSiblingSeperationSpace(double siblingSeperationSpace) {
        this.siblingSeperationSpace = siblingSeperationSpace;
    }

    public double getScaledSiblingSeperationSpace() {
        return this.siblingSeperationSpace * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor;
    }

    public double getParentSeperationSpace() {
        return this.parentSeperationSpace;
    }

    public void setParentSeperationSpace(double parentSeperationSpace) {
        this.parentSeperationSpace = parentSeperationSpace;
    }

    public double getScaledParentSeperationSpace() {
        return this.parentSeperationSpace * StatGraph.dataDPIScaleFactor * StatGraph.dataSizeScaleFactor;
    }

    public boolean isSpaceLevelBySubtreeWidth() {
        return this.spaceLevelBySubtreeWidth;
    }

    public void setSpaceLevelBySubtreeWidth(boolean spaceLevelBySubtreeWidth) {
        this.spaceLevelBySubtreeWidth = spaceLevelBySubtreeWidth;
    }

    public Vector<Double> getLevelSpacing() {
        return this.levelSpacing;
    }

    public void initialize(Vector<NodeLinkDiagramItem> items) {
        this.leftNeighbors.clear();
        this.rightNeighbors.clear();
    }

    public boolean arrange(boolean forceComplete) {
        if (this.target != null) {
            this.levelSpacing.clear();
            NodeItem rootNode = this.targetRoot;
            if (rootNode != null) {
                double graphRatio;
                double ideaHt;
                HashMap<NodeItem, Double> offset = new HashMap<NodeItem, Double>();
                HashMap<NodeItem, Vector<Double>> leftBounds = new HashMap<NodeItem, Vector<Double>>();
                HashMap<NodeItem, Vector<Double>> rightBounds = new HashMap<NodeItem, Vector<Double>>();
                Vector<Double> levelHeight = new Vector<Double>();
                for (int i = 0; i < this.target.getTreeDepth() + 1; ++i) {
                    this.levelSpacing.add(new Double(this.getScaledParentSeperationSpace()));
                }
                int displayDepth = this.targetDisplayDepth - 1;
                if (displayDepth < 0) {
                    displayDepth = this.target.getTreeDepth();
                }
                this.calculateChildOffsets(rootNode, offset, leftBounds, rightBounds, levelHeight, this.levelSpacing, 0, this.getScaledSiblingSeperationSpace(), this.getScaledParentSeperationSpace(), displayDepth);
                HashMap<NodeItem, Double> subtreeWidth = new HashMap<NodeItem, Double>();
                for (NodeItem subtree : leftBounds.keySet()) {
                    Vector<Double> left = leftBounds.get(subtree);
                    Vector<Double> right = rightBounds.get(subtree);
                    double leftMin = Double.MAX_VALUE;
                    for (int i = 0; i < left.size(); ++i) {
                        double v = left.get(i);
                        leftMin = Math.min(leftMin, v);
                    }
                    double rightMax = -1.7976931348623157E308;
                    for (int i = 0; i < right.size(); ++i) {
                        double v = right.get(i);
                        rightMax = Math.max(rightMax, v);
                    }
                    subtreeWidth.put(subtree, new Double(rightMax - leftMin));
                }
                double wt = (Double)subtreeWidth.get(rootNode);
                double totalSpace = 0.0;
                double ht = levelHeight.elementAt(0);
                for (int i = 1; i < levelHeight.size(); ++i) {
                    double sp = this.spaceLevelBySubtreeWidth ? this.levelSpacing.elementAt(i - 1) : this.parentSeperationSpace;
                    totalSpace += sp;
                    ht += sp + levelHeight.elementAt(i);
                }
                double parentSeperationSpace_sav = this.parentSeperationSpace;
                if (this.scaleToFit && this.graphSize.getHeight() > 0.0 && this.graphSize.getWidth() > 0.0 && (ideaHt = wt * (graphRatio = this.graphSize.getHeight() / this.graphSize.getWidth())) > ht) {
                    double extraSP = ideaHt - ht;
                    int actualDepth = Math.min(displayDepth, this.target.getTreeDepth());
                    if (this.spaceLevelBySubtreeWidth) {
                        for (int i = 0; i < actualDepth; ++i) {
                            double sp = this.levelSpacing.elementAt(i);
                            double newSP = sp + extraSP * sp / totalSpace;
                            this.levelSpacing.setElementAt(new Double(newSP), i);
                        }
                    } else {
                        this.parentSeperationSpace += extraSP / (double)actualDepth;
                    }
                }
                rootNode.move(0.0, 0.0);
                this.positionSubtree(rootNode, offset, levelHeight, this.levelSpacing, 0, displayDepth);
                this.updateControlInfo(rootNode, displayDepth);
                this.updateNeighbors(rootNode, displayDepth);
                this.parentSeperationSpace = parentSeperationSpace_sav;
            }
        }
        return true;
    }

    void calculateChildOffsets(NodeItem subtreeRoot, HashMap<NodeItem, Double> offset, HashMap<NodeItem, Vector<Double>> leftBounds, HashMap<NodeItem, Vector<Double>> rightBounds, Vector<Double> levelHeight, Vector<Double> levelSpacing, int level, double spacing, double minLevelSpacing, int displayDepth) {
        Vector<NodeItem> children;
        int numChildren;
        Rectangle2D size = subtreeRoot.getBounds();
        double halfWidth = size.getWidth() / 2.0;
        Vector<Double> subtreeLeftBounds = new Vector<Double>();
        subtreeLeftBounds.add(new Double(-halfWidth));
        Vector<Double> subtreeRightBounds = new Vector<Double>();
        subtreeRightBounds.add(new Double(halfWidth));
        if (level < levelHeight.size()) {
            levelHeight.setElementAt(Math.max(size.getHeight(), levelHeight.elementAt(level)), level);
        } else {
            for (int i = levelHeight.size(); i <= level; ++i) {
                levelHeight.add(new Double(0.0));
            }
            levelHeight.setElementAt(new Double(size.getHeight()), level);
        }
        if (level < displayDepth && (numChildren = (children = subtreeRoot.getChildNodes()).size()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                int j;
                int k;
                int depth;
                NodeItem child = children.elementAt(i);
                if (child == null) continue;
                this.calculateChildOffsets(child, offset, leftBounds, rightBounds, levelHeight, levelSpacing, level + 1, spacing, minLevelSpacing, displayDepth);
                Vector<Double> childLeftBounds = leftBounds.get(child);
                Vector<Double> childRightBounds = rightBounds.get(child);
                if (i == 0) {
                    int j2;
                    offset.put(child, 0.0);
                    depth = childRightBounds.size();
                    if (subtreeLeftBounds.size() <= depth) {
                        for (j2 = subtreeLeftBounds.size(); j2 <= depth; ++j2) {
                            subtreeLeftBounds.add(0.0);
                        }
                    }
                    if (subtreeRightBounds.size() <= depth) {
                        for (j2 = subtreeRightBounds.size(); j2 <= depth; ++j2) {
                            subtreeRightBounds.add(0.0);
                        }
                    }
                    for (int k2 = 0; k2 < depth; ++k2) {
                        subtreeLeftBounds.set(k2 + 1, childLeftBounds.elementAt(k2));
                        subtreeRightBounds.set(k2 + 1, childRightBounds.elementAt(k2));
                    }
                    continue;
                }
                depth = Math.min(subtreeRightBounds.size() - 1, childLeftBounds.size());
                double distance = 0.0;
                for (int k3 = 0; k3 < depth; ++k3) {
                    distance = Math.max(distance, (Double)subtreeRightBounds.elementAt(k3 + 1) - childLeftBounds.elementAt(k3));
                }
                double childOffset = distance + spacing;
                offset.put(child, childOffset);
                for (k = 0; k < depth; ++k) {
                    subtreeRightBounds.set(k + 1, new Double(childRightBounds.elementAt(k) + childOffset));
                }
                depth = childRightBounds.size();
                if (subtreeLeftBounds.size() <= depth) {
                    for (j = subtreeLeftBounds.size(); j <= depth; ++j) {
                        subtreeLeftBounds.add(0.0);
                    }
                }
                if (subtreeRightBounds.size() <= depth) {
                    for (j = subtreeRightBounds.size(); j <= depth; ++j) {
                        subtreeRightBounds.add(0.0);
                    }
                }
                while (k < depth) {
                    subtreeRightBounds.set(k + 1, new Double(childRightBounds.elementAt(k) + childOffset));
                    subtreeLeftBounds.set(k + 1, new Double(childLeftBounds.elementAt(k) + childOffset));
                    ++k;
                }
            }
            NodeItem child = children.elementAt(numChildren - 1);
            double shift = -offset.get(child).doubleValue() / 2.0;
            for (int i = 0; i < numChildren; ++i) {
                child = children.elementAt(i);
                offset.put(child, new Double(offset.get(child) + shift));
            }
            int depth = subtreeLeftBounds.size();
            for (int i = 1; i < depth; ++i) {
                double val = (Double)subtreeLeftBounds.elementAt(i);
                subtreeLeftBounds.set(i, new Double(val + shift));
                val = (Double)subtreeRightBounds.elementAt(i);
                subtreeRightBounds.set(i, new Double(val + shift));
            }
        }
        leftBounds.put(subtreeRoot, subtreeLeftBounds);
        rightBounds.put(subtreeRoot, subtreeRightBounds);
        if (subtreeLeftBounds.size() > 1 && subtreeRightBounds.size() > 1) {
            double spaceNeeded = Math.max(((Double)subtreeRightBounds.elementAt(1) - (Double)subtreeLeftBounds.elementAt(1)) / 2.0, minLevelSpacing);
            levelSpacing.set(level, new Double(Math.max(spaceNeeded, levelSpacing.elementAt(level))));
        }
    }

    void positionSubtree(NodeItem subtreeRoot, HashMap<NodeItem, Double> offset, Vector<Double> levelHeight, Vector<Double> levelSpacing, int level, int displayDepth) {
        if (level < displayDepth) {
            Vector<NodeItem> children = subtreeRoot.getChildNodes();
            int numChildren = children.size();
            double subtreeX = subtreeRoot.getX();
            double levelSpace = this.spaceLevelBySubtreeWidth ? levelSpacing.elementAt(level).doubleValue() : this.getParentSeperationSpace();
            double childY = subtreeRoot.getBounds().getMaxY() - levelHeight.elementAt(level) - levelSpace;
            for (int i = 0; i < numChildren; ++i) {
                NodeItem child = children.elementAt(i);
                Point2D childOriginOffset = child.getOriginOffset();
                double childOffset = offset.get(child);
                Rectangle2D childSize = child.getBounds();
                child.move(subtreeX + childOffset - childSize.getWidth() / 2.0 - childOriginOffset.getX(), childY - childSize.getHeight() - childOriginOffset.getY());
                this.positionSubtree(child, offset, levelHeight, levelSpacing, level + 1, displayDepth);
            }
        }
    }

    void updateControlInfo(NodeItem node, int displayDepth) {
        Vector<NodeItem> children;
        int numChildren;
        if (displayDepth > 0 && (numChildren = (children = node.getChildNodes()).size()) > 0) {
            Vector<LinkItem> links = new Vector<LinkItem>(numChildren);
            Vector<Double> linkWidths = new Vector<Double>(numChildren);
            links.setSize(numChildren);
            linkWidths.setSize(numChildren);
            double totalLinkWidth = 0.0;
            for (int i = 0; i < numChildren; ++i) {
                NodeItem childNode = children.elementAt(i);
                this.updateControlInfo(childNode, displayDepth - 1);
                LinkItem link = LinkItem.getLink(node, childNode);
                double linkWidth = this.target.getLinkWidth(link);
                totalLinkWidth += linkWidth;
                links.set(i, link);
                linkWidths.set(i, linkWidth);
            }
            Rectangle2D nodeBounds = node.getBounds();
            double center = nodeBounds.getCenterX();
            double left = center - totalLinkWidth / 2.0;
            for (int i = 0; i < numChildren; ++i) {
                LinkItem link = (LinkItem)links.elementAt(i);
                double linkWidth = (Double)linkWidths.elementAt(i);
                link.setFromOffset(left + linkWidth / 2.0 - center);
                left += linkWidth;
            }
        }
    }

    void updateNeighbors(NodeItem root, int displayDepth) {
        Vector<Vector<NodeItem>> levels = new Vector<Vector<NodeItem>>();
        this.populateLevels(levels, root, 0, displayDepth);
        for (Vector<NodeItem> level : levels) {
            int len;
            if (level == null || (len = level.size()) < 2) continue;
            NodeItem prev = level.elementAt(0);
            for (int i = 1; i < len; ++i) {
                NodeItem node = level.elementAt(i);
                this.rightNeighbors.put(prev, node);
                this.leftNeighbors.put(node, prev);
                prev = node;
            }
        }
    }

    void populateLevels(Vector<Vector<NodeItem>> levels, NodeItem parent, int level, int displayDepth) {
        Vector<Object> levelList;
        for (int numLevels = levels.size(); numLevels <= level; ++numLevels) {
            levelList = new Vector();
            levels.add(levelList);
        }
        levelList = levels.elementAt(level);
        levelList.add(parent);
        if (++level <= displayDepth) {
            Vector<NodeItem> children = parent.getChildNodes();
            int numChildren = children.size();
            for (int i = 0; i < numChildren; ++i) {
                this.populateLevels(levels, children.elementAt(i), level, displayDepth);
            }
        }
    }

    public NodeItem getLeftNeighbor(NodeItem node) {
        return this.leftNeighbors.get(node);
    }

    public NodeItem getRightNeighbor(NodeItem node) {
        return this.rightNeighbors.get(node);
    }
}

