/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.data;

import java.util.HashMap;
import java.util.Vector;

public final class RoleColumnMap {
    private Vector columnList = new Vector();
    private Vector roleList = new Vector();
    private HashMap olapRoles = new HashMap();

    public int getColumn(int role) {
        if (role < 0) {
            throw new Error("RoleColumnMap : role=" + role + " must be positive");
        }
        if (role >= this.columnList.size()) {
            return -1;
        }
        Object iobj = this.columnList.elementAt(role);
        if (iobj == null) {
            return -1;
        }
        if (!(iobj instanceof Integer)) {
            throw new Error("RoleColumnMap: non Integer value in roleList.");
        }
        return (Integer)iobj;
    }

    public int getRole(int column) {
        if (column < 0) {
            throw new Error("RoleColumnMap : column=" + column + " must be positive");
        }
        if (column >= this.roleList.size()) {
            return -1;
        }
        Object iobj = this.roleList.elementAt(column);
        if (iobj == null) {
            return -1;
        }
        if (!(iobj instanceof Integer)) {
            throw new Error("RoleColumnMap: non Integer value in columnList.");
        }
        return (Integer)iobj;
    }

    public void map(int role, int column) {
        Integer robj = new Integer(role);
        int rsize = this.roleList.size();
        if (column >= rsize) {
            this.roleList.setSize(column + 1);
        }
        this.roleList.setElementAt(robj, column);
        Integer cobj = new Integer(column);
        int csize = this.columnList.size();
        if (role >= csize) {
            this.columnList.setSize(role + 1);
        }
        this.columnList.setElementAt(cobj, role);
    }

    public void map(int role, String olapVarName) {
        this.olapRoles.put(new Integer(role), olapVarName);
    }

    public String getOLAPRole(int role) {
        return this.olapRoles.size() > 0 ? (String)this.olapRoles.get(new Integer(role)) : null;
    }

    public void clear() {
        this.columnList.removeAllElements();
        this.roleList.removeAllElements();
        this.olapRoles.clear();
    }

    public void unmapRole(int role) {
        if (this.olapRoles.size() > 0) {
            this.olapRoles.remove(new Integer(role));
            return;
        }
        int column = this.getColumn(role);
        this.columnList.setElementAt(null, role);
        this.roleList.setElementAt(null, column);
    }

    public void unmapCol(int column) {
        int role = this.getRole(column);
        this.columnList.setElementAt(null, role);
        this.roleList.setElementAt(null, column);
    }

    public boolean isColumnMapped(int column) {
        return this.getRole(column) != -1;
    }

    public boolean isRoleMapped(int role) {
        if (this.olapRoles.size() > 0) {
            return this.olapRoles.containsKey(new Integer(role));
        }
        return this.getColumn(role) != -1;
    }

    public Vector getColumnList() {
        return this.columnList;
    }
}

