/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.data;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.ui.CHTagLoader;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPMeasureVariable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.rpf.Context;
import com.sas.rpf.ContextInterface;
import com.sas.rpf.RuleInterface;
import com.sas.rpf.data.DataVector;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.NumericValue;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.Variable;
import com.sas.rpf.expr.EvaluateException;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.ChainedException;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RPFUtil {
    private static int calloutTagWidth = 24;
    private static int calloutTagHeight = 24;

    public static BooleanVector applyConditionalHiliting(DataModel model, VariableProcessor vp, int statistic) {
        if (model == null) {
            return null;
        }
        Context rulesContext = model.getRPFContext();
        if (rulesContext == null || rulesContext.isEmpty()) {
            return null;
        }
        List chVars = RPFUtil.addCHVariables(model, vp, statistic);
        if (chVars == null || chVars.isEmpty()) {
            return null;
        }
        BooleanVector bv = new BooleanVector();
        if (model.isOLAP()) {
            RPFUtil.applyExceptionHighlighting(model.getOLAPData(), chVars, (ContextInterface)rulesContext, bv);
        } else {
            RPFUtil.applyExceptionHighlighting(chVars, (ContextInterface)rulesContext, bv);
        }
        return bv;
    }

    private static void applyExceptionHighlighting(List vars, ContextInterface rulesContext, BooleanVector bv) {
        Collection rules = rulesContext.getRules();
        for (RuleInterface curRule : rules) {
            if (curRule == null) continue;
            int obs = ((NumericVariable)vars.get(0)).getValueCount();
            bv.setSize(obs);
            int numVars = vars.size();
            for (int i = 0; i < obs; ++i) {
                DataVector dataVec = new DataVector();
                for (int j = 0; j < numVars; ++j) {
                    NumericVariable nv = (NumericVariable)vars.get(j);
                    String name = nv.getName();
                    MissingValue value = null;
                    try {
                        value = new NumericValue(nv.value.getValue(i));
                    }
                    catch (MissingValueException e2) {
                        value = new MissingValue();
                    }
                    dataVec.setValue(name, (ValueInterface)value);
                }
                try {
                    if (!curRule.execute((DataVectorInterface)dataVec)) continue;
                    bv.setValueAt(true, i);
                    continue;
                }
                catch (ChainedException chainedException) {
                    // empty catch block
                }
            }
        }
    }

    private static void applyExceptionHighlighting(OLAPDataSetInterface data, List vars, ContextInterface rulesContext, BooleanVector bv) {
        Collection rules = rulesContext.getRules();
        for (RuleInterface curRule : rules) {
            Set ruleVars = null;
            try {
                ruleVars = curRule.extractVariables();
            }
            catch (EvaluateException e1) {
                e1.printStackTrace();
            }
            int obs = ((NumericVariable)vars.get(0)).getValueCount();
            bv.setSize(obs);
            int numVars = vars.size();
            for (int i = 0; i < obs; ++i) {
                NumericVariable nv;
                int j;
                DataVector dataVec = new DataVector();
                for (j = 0; j < numVars; ++j) {
                    nv = (NumericVariable)vars.get(j);
                    String name = nv.getName();
                    MissingValue value = null;
                    try {
                        value = new NumericValue(nv.value.getValue(i));
                    }
                    catch (MissingValueException e4) {
                        value = new MissingValue();
                    }
                    dataVec.setValue(name, (ValueInterface)value);
                }
                for (j = 0; j < numVars; ++j) {
                    nv = (OLAPMeasureVariable)vars.get(j);
                    int cellIndex = nv.getCellIndex(i);
                    try {
                        ResultSetMetadataInterface rsMeta = data.getResultSetMetadata();
                        int[] tupleCoords = OLAPUtil.calculateTupleCoordinates((ResultSetMetadataInterface)rsMeta, (int)cellIndex);
                        AxisInterface[] axes = rsMeta.getAxes(0, -1);
                        for (int axisIndex = 0; axisIndex < tupleCoords.length; ++axisIndex) {
                            AxisInterface axis = axes[axisIndex];
                            TupleInterface t = axis.getTuple(tupleCoords[axisIndex]);
                            TupleElementInterface[] tes = t.getElements(0, -1);
                            RPFUtil.addLevels(dataVec, tes);
                        }
                    }
                    catch (OLAPException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (!curRule.execute((DataVectorInterface)dataVec)) continue;
                        bv.setValueAt(true, cellIndex);
                        continue;
                    }
                    catch (ChainedException chainedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void addLevels(DataVector dataVector, TupleElementInterface[] tuples) throws OLAPException {
        for (int i = 0; i < tuples.length; ++i) {
            TupleElementInterface tuple = tuples[i];
            if (tuple.getType() == TupleElementType.MEASURE) continue;
            String uLevelName = tuple.getUniqueLevelName();
            int index1 = uLevelName.indexOf(93, 1);
            String dim = uLevelName.substring(1, index1);
            int index2 = uLevelName.indexOf(93, index1 + 1);
            String hierarchy = uLevelName.substring(index1 + 3, index2);
            int index3 = uLevelName.indexOf(93, index2 + 1);
            String level = null;
            if (index3 < 0) {
                level = hierarchy;
                hierarchy = "*";
                String startingDim = uLevelName.substring(0, index1 + 1);
                hierarchy = RPFUtil.findHierarchyForDimension(tuple, startingDim);
            } else {
                level = uLevelName.substring(index2 + 3, index3);
            }
            dataVector.setDrillLevel(dim, hierarchy, level);
        }
    }

    private static String findHierarchyForDimension(TupleElementInterface tuple, String startingDim) throws OLAPException {
        String[] hiers = tuple.getTuple().getAxis().getHierarchyNames();
        for (int j = 0; j < hiers.length; ++j) {
            String hier = hiers[j];
            if (!hier.startsWith(startingDim)) continue;
            return hier.substring(startingDim.length() + 2, hier.length() - 1);
        }
        return null;
    }

    private static List addCHVariables(DataModel model, VariableProcessor vp, int statistic) {
        if (model.getRPFContext() == null) {
            return null;
        }
        ArrayList<NumericVariable> vars = new ArrayList<NumericVariable>();
        Context rulesContext = model.getRPFContext();
        Collection rules = rulesContext.getRules();
        for (RuleInterface curRule : rules) {
            if (curRule == null) continue;
            Set ruleVars = null;
            try {
                ruleVars = curRule.extractVariables();
            }
            catch (EvaluateException e1) {
                e1.printStackTrace();
            }
            for (Variable curRPFVar : ruleVars) {
                NumericVariable gtkVar = null;
                String varName = curRPFVar.getName();
                if (model.isOLAP()) {
                    gtkVar = StatGraph.getOLAPMeasureVar(model, varName);
                    if (gtkVar == null) {
                        rulesContext.remove(curRule);
                        return null;
                    }
                    gtkVar.setName(varName);
                } else {
                    gtkVar = new NumericVectorVariable();
                    gtkVar.setName(varName);
                    if (!model.hasColumn(varName)) {
                        rulesContext.remove(curRule);
                        return null;
                    }
                    ((NumericVectorVariable)gtkVar).connectFrom(model.getDoubleColumn(model.getColumn(varName)));
                }
                vars.add(gtkVar);
                if (vp == null) continue;
                vp.addVariable((com.sas.graphics.util.gtk.Variable)gtkVar, statistic);
            }
        }
        return vars.isEmpty() ? null : vars;
    }

    public static com.sas.graphics.util.gtk.gl.Image newTagElement(int idx, boolean callout, Component c) {
        com.sas.graphics.util.gtk.gl.Image tag = new com.sas.graphics.util.gtk.gl.Image();
        Image tagImg = CHTagLoader.get(idx + 1, callout, c);
        tag.addImage(tagImg);
        tag.height.setValue((double)tagImg.getHeight(c));
        tag.width.setValue((double)tagImg.getWidth(c));
        return tag;
    }

    public static int getCalloutTagWidth() {
        return calloutTagWidth;
    }

    public static int getCalloutTagHeight() {
        return calloutTagHeight;
    }
}

