/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.data;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.RB;
import com.sas.text.Message;
import com.sas.text.SASFormat;

public final class ColumnMetadata {
    public static final String RB_KEY = "ColumnMetadata.";
    public static final byte NUMERIC = 1;
    public static final byte CHARACTER = 2;
    private String name;
    private String label;
    private byte type;
    protected SASFormat sasFormat = null;
    protected String format;
    private double min = Double.MAX_VALUE;
    private double max = -1.7976931348623157E308;
    private int missings = 0;
    private int nobs = 0;
    private int length = Integer.MAX_VALUE;
    public int lastAddedObs = 0;

    public String toString() {
        return this.name;
    }

    public ColumnMetadata(String name, byte type) {
        this.setName(name);
        this.setLabel(name);
        this.setType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte aType) {
        this.type = aType;
    }

    public SASFormat getFormat() {
        if (this.format == null || this.format.trim().length() <= 0) {
            return null;
        }
        if (this.sasFormat == null) {
            SASFormat newFormat = SASFormat.getInstance((String)this.format);
            if (newFormat == null) {
                this.format = null;
                return null;
            }
            if (this.type == 1 && newFormat.isCharacterFormat()) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "format.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)this.format, (Object)this.name));
                this.format = null;
                return null;
            }
            if (this.type == 2 && !newFormat.isCharacterFormat()) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "format2.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)this.format, (Object)this.name));
                this.format = null;
                return null;
            }
            this.sasFormat = newFormat;
        }
        return this.sasFormat;
    }

    public void setFormat(String aFormat) {
        this.format = aFormat;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double aDouble) {
        this.min = aDouble;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double aDouble) {
        this.max = aDouble;
    }

    public int getNobs() {
        return this.nobs;
    }

    public void setNobs(int aInt) {
        this.nobs = aInt;
    }

    public int getMissings() {
        return this.missings;
    }

    public void setMissings(int aInt) {
        this.missings = aInt;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int aInt) {
        this.length = aInt;
    }
}

