/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayDimension;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayInnerMargin;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverviewAxisComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple3DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.SimpleExtrudedOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.encoder.BrokenPositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridLabelEntry;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListenerList;
import com.sas.graphics.applets.statgraph.sgchart.grid.OneDPlotInterface;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.CurveLabelLayoutManager;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayout;
import com.sas.graphics.applets.statgraph.sgchart.gtk.gl.PointLabelLayoutManager;
import com.sas.graphics.applets.statgraph.sgchart.ler.LargestEmptyRectangle;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BandOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.CarpetOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ESRIMapLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineChartOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.OContour;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PolygonOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RangeAttrMapViewOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.TimeSeriesOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.WaterfallChartOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeMerger;
import com.sas.graphics.applets.statgraph.sgchart.range.StubRange;
import com.sas.graphics.applets.statgraph.sgchart.ui.ImageMap;
import com.sas.graphics.applets.statgraph.sgchart.ui.ProbeResult;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKPieSelectDetail;
import com.sas.graphics.util.gtk.LineConnectorDetail;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.LineConnector;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.PolylineSegment;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import com.sas.graphics.vgf.VGFGraphics2D;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JLayeredPane;

public class Simple2DOverlayComposite
implements RangeChangeListener,
MarginInterface,
MarginChangeInterface,
OneDPlotInterface,
UserDefinedMarkerInterface {
    public boolean dataDisplayAntialiased = true;
    public boolean axisDisplayAntialiased = true;
    public boolean subpixelRendering = false;
    protected int x;
    protected int y;
    protected int width = -1;
    protected int height = -1;
    protected int ymax;
    protected boolean visible = true;
    protected Channel channel;
    protected Insets overlayMargin = new Insets(0, 0, 0, 0);
    protected Insets innerMargin = new Insets(0, 0, 0, 0);
    protected Insets outerMargin = new Insets(0, 0, 0, 0);
    protected boolean axesVisible = true;
    protected boolean marginChangeListened = false;
    protected ArrayList overlays = new ArrayList();
    protected ArrayList axes = new ArrayList();
    protected ArrayList gridLines = new ArrayList();
    protected Wall wall;
    protected HashMap A2GLV = new HashMap();
    protected HashMap GL2A = new HashMap();
    protected HashMap OD2A = new HashMap();
    protected HashMap A2ODV = new HashMap();
    protected HashMap A2RM = new HashMap();
    protected Insets prefInner = new Insets(0, 0, 0, 0);
    protected Insets prefOuter = new Insets(0, 0, 0, 0);
    protected Rectangle innerRegion = new Rectangle(0, 0, 0, 0);
    protected Rectangle outerRegion = new Rectangle(0, 0, 0, 0);
    private Insets prefInner2 = new Insets(0, 0, 0, 0);
    protected Insets innerMargin2 = new Insets(0, 0, 0, 0);
    protected Rectangle innerRegion2 = new Rectangle(0, 0, 0, 0);
    protected Insets prefPlotInner = new Insets(0, 0, 0, 0);
    protected PointLabelLayoutManager pmgr = null;
    protected int maxHLabelShift = 80;
    protected int maxVLabelShift = 72;
    protected int hLabelShiftDelta = 4;
    protected int vLabelShiftDelta = 3;
    protected CurveLabelLayoutManager cmgr = null;
    protected PointLabelLayoutManager pcmgr = null;
    protected boolean curveLabelsOn = true;
    public static int EQUATED_NONE = 0;
    public static int EQUATED_MAXAREA = 1;
    public static int EQUATED_SQUARE = 2;
    public static int EQUATED_CENTER = 3;
    public static int EQUATED_SQUAREDATA = 4;
    private int squareFormat = EQUATED_NONE;
    private boolean squareFormatPrimary = true;
    private boolean equateRanges = true;
    private double[] userTicks = null;
    private Insets originalInnerMargin = null;
    protected boolean dynamic = false;
    protected double[] userOffsetMin = null;
    protected double[] userOffsetMax = null;
    private boolean origin_px;
    private boolean origin_py;
    private boolean origin_sx;
    private boolean origin_sy;
    private boolean initialFitting;
    private double aspectRatio = -1.0;
    private boolean ignoreMinorMarginIncrease = true;
    public static final int LABELS_DEFAULT = 0;
    public static final int LABELS_ALL = 1;
    public static final int LABELS_NONE = 2;
    public static final int LABELS_CUSTOM = 3;
    protected int showPointLabels = 0;
    private double xAxisMaxHeightPercentage = 0.45;
    private double yAxisMaxWidthPercentage = 0.25;
    private double y2AxisMaxWidthPercentage = 0.25;
    private double leftGridLabelMaxWidth = Double.MAX_VALUE;
    private double rightGridLabelMaxWidth = Double.MAX_VALUE;
    private boolean includeXAxisRange = false;
    private boolean includeX2AxisRange = false;
    private boolean includeYAxisRange = false;
    private boolean includeY2AxisRange = false;
    private boolean labelVerbose = false;
    private boolean saLabeling = false;
    private boolean labelDisplaceable = true;
    private HashMap saWeightMap = null;
    private Insets innerMarginBorder;
    private ArrayList overlayInnerMargins;
    private int saMaxIterations = 100;
    private int saSeed = 1234567;
    private static int MAX_CURVE_POINTS = 20;
    private Color brokenGapColor = Color.white;
    private boolean brokenAxis = false;
    private int brokenAxisHash = 0;
    private MarginListenerList mlList = new MarginListenerList();
    private Overlay primaryPlotX = null;
    private Overlay primaryPlotX2 = null;
    private Overlay primaryPlotY = null;
    private Overlay primaryPlotY2 = null;
    boolean CLOverlappingChecked = false;
    boolean xCLOverlapped = false;
    boolean x2CLOverlapped = false;
    boolean curveLabelSplit = false;
    public boolean labelingInited = false;
    Stack probeNameStack = new Stack();
    Stack selectNameStack = new Stack();
    private static final Dimension selArea = new Dimension(3, 3);
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;
    protected double xScale = 1.0;
    protected double yScale = 1.0;
    protected double rotation = 0.0;
    boolean paintingMarker = false;

    public void addMarginListener(MarginListener listener) {
        this.mlList.add(listener);
    }

    public void removeMarginListener(MarginListener listener) {
        this.mlList.remove(listener);
    }

    public void resetPointLabelManager() {
        this.pmgr = null;
        this.labelingInited = false;
    }

    public void resetCurveLabelManager() {
        this.cmgr = null;
        this.labelingInited = false;
    }

    public void resetPointCurveLabelManager() {
        this.pcmgr = null;
        this.labelingInited = false;
    }

    public void setBrokenGapColor(Color c) {
        this.brokenGapColor = c;
    }

    public Color getBrokenGapColor() {
        return this.brokenGapColor;
    }

    public void draw(Graphics g) {
        this.drawParts(g);
    }

    public void drawSelection(Graphics g) {
        Shape save = g.getClip();
        this.setClip(g);
        this.channel.setSingleBufferGraphics(g);
        int onum = this.overlays.size();
        for (int i = 0; i < onum; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (o.getSelection() == null || o.getSelection().length <= 0) continue;
            this.channel.glPushMatrix();
            this.translateOverlay(o);
            if (o instanceof EllipseParmOverlay) {
                Shape oldClip = g.getClip();
                Rectangle r = this.getOverlayDataRegion(o);
                Rectangle r2 = save == null ? r : r.intersection(save.getBounds());
                g.setClip(r2);
                o.drawSelection(g);
                g.setClip(oldClip);
            } else {
                o.drawSelection(g);
            }
            this.channel.glPopMatrix();
        }
        if (this.channel.getBackbufferId() == -1) {
            this.channel.resetClip();
        } else {
            g.setClip(save);
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setMarginChangeListened(boolean b) {
        this.marginChangeListened = b;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setBounds(int x, int y, int width, int height, int bym) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.ymax = bym;
        this.resize();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setYAxisMaxWidthPercentage(double w) {
        this.yAxisMaxWidthPercentage = w;
    }

    public double getYAxisMaxWidthPercentage() {
        return this.yAxisMaxWidthPercentage;
    }

    public void setY2AxisMaxWidthPercentage(double w) {
        this.y2AxisMaxWidthPercentage = w;
    }

    public double getY2AxisMaxWidthPercentage() {
        return this.y2AxisMaxWidthPercentage;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setAspectRatio(double aspect) {
        this.aspectRatio = aspect;
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public void setSquareFormatPrimary(boolean b) {
        this.squareFormatPrimary = b;
    }

    public int getSquareFormat() {
        return this.squareFormat;
    }

    public void setSquareFormat(int f) {
        this.squareFormat = f;
    }

    public void clearA2ODV() {
        this.A2ODV.clear();
    }

    public Overlay[] getConnectedOverlays(AbstractAxis axis) {
        if (!this.A2ODV.containsKey(axis)) {
            return null;
        }
        Vector ov = (Vector)this.A2ODV.get(axis);
        Overlay[] overlays = null;
        if (ov != null) {
            overlays = new Overlay[ov.size()];
            for (int i = 0; i < ov.size(); ++i) {
                OverlayDimension od = (OverlayDimension)ov.elementAt(i);
                overlays[i] = od.getOverlay();
            }
        }
        return overlays;
    }

    public ArrayList getOverlays() {
        return this.overlays;
    }

    public int getNumOverlays() {
        return this.overlays.size();
    }

    public void removeAllOverlays() {
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay overlay = (Overlay)this.overlays.get(i);
            for (byte dim = 1; dim <= 3; dim = (byte)(dim + 1)) {
                OverlayDimension od = new OverlayDimension(overlay, dim);
                AbstractAxis axis = (AbstractAxis)this.OD2A.get(od);
                if (axis == null) continue;
                this.disconnect(overlay, axis, dim);
            }
        }
        this.overlays.clear();
    }

    public void setOverlay(Overlay overlay, int index) {
        this.overlays.set(index, overlay);
        if (this.channel != null) {
            overlay.setChannel(this.channel);
        }
    }

    public boolean addOverlay(Overlay overlay) {
        if (this.overlays.contains(overlay)) {
            return true;
        }
        this.overlays.add(overlay);
        if (this.channel != null) {
            overlay.setChannel(this.channel);
        }
        overlay.setSubpixelRendering(this.subpixelRendering);
        return true;
    }

    public boolean addOverlay(Overlay overlay, int index) {
        if (this.overlays.contains(overlay)) {
            return true;
        }
        this.overlays.add(index, overlay);
        if (this.channel != null) {
            overlay.setChannel(this.channel);
        }
        overlay.setSubpixelRendering(this.subpixelRendering);
        return true;
    }

    public boolean addAxis(AbstractAxis axis) {
        this.axes.add(axis);
        if (this.channel != null) {
            axis.setChannel(this.channel);
        }
        RangeMerger rm = new RangeMerger();
        rm.setDimension(axis.getDimension());
        axis.setInputDataRange(null);
        rm.addRangeChangeListener((RangeChangeListener)axis);
        this.A2RM.put(axis, rm);
        return true;
    }

    public void removeAllAxes() {
        this.axes.clear();
    }

    public boolean addGridLines(VRectGridLines rgl) {
        this.gridLines.add(rgl);
        if (this.channel != null) {
            rgl.setChannel(this.channel);
        }
        return true;
    }

    public void removeOverlay(Overlay overlay) {
        this.overlays.remove(overlay);
        for (byte dim = 1; dim <= 3; dim = (byte)(dim + 1)) {
            OverlayDimension od = new OverlayDimension(overlay, dim);
            AbstractAxis axis = (AbstractAxis)this.OD2A.get(od);
            if (axis == null) continue;
            this.disconnect(overlay, axis, dim);
        }
    }

    public void removeOverlay(Overlay overlay, boolean disconnect) {
        this.overlays.remove(overlay);
        if (!disconnect) {
            return;
        }
        for (byte dim = 1; dim <= 3; dim = (byte)(dim + 1)) {
            OverlayDimension od = new OverlayDimension(overlay, dim);
            AbstractAxis axis = (AbstractAxis)this.OD2A.get(od);
            if (axis == null) continue;
            this.disconnect(overlay, axis, dim);
        }
    }

    public void removeOverlay(int index, boolean disconnect) {
        Overlay overlay = (Overlay)this.overlays.remove(index);
        if (!disconnect) {
            return;
        }
        for (byte dim = 1; dim <= 3; dim = (byte)(dim + 1)) {
            OverlayDimension od = new OverlayDimension(overlay, dim);
            AbstractAxis axis = (AbstractAxis)this.OD2A.get(od);
            if (axis == null) continue;
            this.disconnect(overlay, axis, dim);
        }
    }

    public void removeAxis(AbstractAxis axis) {
        this.axes.remove(axis);
        Vector ov = (Vector)this.A2ODV.get(axis);
        if (ov != null) {
            for (int i = 0; i < ov.size(); ++i) {
                OverlayDimension od = (OverlayDimension)ov.elementAt(i);
                Overlay overlay = od.getOverlay();
                this.disconnect(overlay, axis, axis.getDimension());
            }
        }
    }

    public void removeGridLines(VRectGridLines rgl) {
        this.gridLines.remove(rgl);
        AbstractAxis axis = (AbstractAxis)this.GL2A.get(rgl);
        if (axis != null) {
            this.disconnect(rgl, axis);
        }
    }

    public void removeGreenBar(VRectGridLines rgl) {
        this.removeGridLines(rgl);
    }

    private boolean isPrimariablePlot(Overlay overlay) {
        return !(overlay instanceof BandOverlay) && !(overlay instanceof CarpetOverlay) && !(overlay instanceof LineParmOverlay) && !(overlay instanceof ReferenceLineOverlay) && !(overlay instanceof DropLineOverlay) && !(overlay instanceof EllipseParmOverlay) && !(overlay instanceof RangeAttrMapViewOverlay);
    }

    public void clearPrimaryPlot() {
        this.primaryPlotX = null;
        this.primaryPlotX2 = null;
        this.primaryPlotY = null;
        this.primaryPlotY2 = null;
    }

    public void addAxesToRangeMerger(boolean addXAxis, boolean addX2Axis, boolean addYAxis, boolean addY2Axis) {
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis va = (VRectAxis)this.axes.get(i);
            if (va.getDimension() == 1 && va.getPrimary() && !addXAxis || va.getDimension() == 1 && !va.getPrimary() && !addX2Axis || va.getDimension() == 2 && va.getPrimary() && !addYAxis || va.getDimension() == 2 && !va.getPrimary() && !addY2Axis) continue;
            RangeMerger rm = (RangeMerger)this.A2RM.get(va);
            DataRange dr = va.getDataRange(va.getDimension());
            if (!(dr instanceof ContinuousRange)) continue;
            rm.replaceInputRange(dr, dr);
        }
        this.includeXAxisRange = addXAxis;
        this.includeX2AxisRange = addX2Axis;
        this.includeYAxisRange = addYAxis;
        this.includeY2AxisRange = addY2Axis;
    }

    public boolean connect(Overlay overlay, AbstractAxis axis, byte dimension) {
        RangeMerger rm;
        Vector<OverlayDimension> odv;
        DataRange dr;
        if (!this.overlays.contains(overlay)) {
            this.addOverlay(overlay);
        }
        if (!this.axes.contains(axis)) {
            this.addAxis(axis);
        }
        if (!axis.isSortTickValueByOverlay() && axis.getTickValueOrder() == -1 && (dr = overlay.getDataRange(dimension)) instanceof OrdinalRange) {
            ((OrdinalRange)dr).setDataOrder(false);
        }
        if (((VRectAxis)axis).getTicks() != null && this.userTicks == null) {
            this.userTicks = ((VRectAxis)axis).getTicks();
        }
        OverlayDimension od = new OverlayDimension(overlay, dimension);
        this.OD2A.put(od, axis);
        Object obj = this.A2ODV.get(axis);
        if (obj == null) {
            odv = new Vector<OverlayDimension>();
            this.A2ODV.put(axis, odv);
        } else {
            odv = (Vector<OverlayDimension>)obj;
        }
        odv.addElement(od);
        if (overlay instanceof WaterfallChartOverlay) {
            ((WaterfallChartOverlay)overlay).setSort(dimension, axis.getTickValueOrder());
        }
        if (overlay instanceof HistogramOverlay) {
            HistogramOverlay hist = (HistogramOverlay)overlay;
            if (axis.getType() == 1 && hist.isBinAxis() && (dimension == 1 && hist.getOrientation() == 0 || dimension == 2 && hist.getOrientation() == 1)) {
                hist.setBinAxis(false);
            }
        }
        if ((rm = (RangeMerger)this.A2RM.get(axis)) == null) {
            return false;
        }
        DataRange dr2 = overlay.getDataRange(dimension);
        if (!DataRange.isCompatible((DataRange)rm.getOutputRange(), (DataRange)dr2)) {
            return false;
        }
        VRectAxis va = (VRectAxis)axis;
        DataRange axis_dr = va.getDataRange(va.getDimension());
        boolean addAxisRange = false;
        if (va.getDimension() == 1) {
            if (va.getPrimary()) {
                if (overlay.isPrimary()) {
                    this.primaryPlotX = overlay;
                    rm.addInputRangeToFirst(dr2);
                } else if (this.primaryPlotX != null && overlay != this.primaryPlotX) {
                    rm.addInputRange(dr2);
                } else if (this.isPrimariablePlot(overlay)) {
                    this.primaryPlotX = overlay;
                    rm.addInputRangeToFirst(dr2);
                } else {
                    rm.addInputRange(dr2);
                }
                addAxisRange = this.includeXAxisRange;
            } else {
                if (overlay.isPrimary()) {
                    this.primaryPlotX2 = overlay;
                    rm.addInputRangeToFirst(dr2);
                } else if (this.primaryPlotX2 != null && overlay != this.primaryPlotX2) {
                    rm.addInputRange(dr2);
                } else if (this.isPrimariablePlot(overlay)) {
                    this.primaryPlotX2 = overlay;
                    rm.addInputRangeToFirst(dr2);
                } else {
                    rm.addInputRange(dr2);
                }
                addAxisRange = this.includeX2AxisRange;
            }
        } else if (va.getPrimary()) {
            if (overlay.isPrimary()) {
                this.primaryPlotY = overlay;
                rm.addInputRangeToFirst(dr2);
            } else if (this.primaryPlotY != null && overlay != this.primaryPlotY) {
                rm.addInputRange(dr2);
            } else if (this.isPrimariablePlot(overlay)) {
                this.primaryPlotY = overlay;
                rm.addInputRangeToFirst(dr2);
            } else {
                rm.addInputRange(dr2);
            }
            addAxisRange = this.includeYAxisRange;
        } else {
            if (overlay.isPrimary()) {
                this.primaryPlotY2 = overlay;
                rm.addInputRangeToFirst(dr2);
            } else if (this.primaryPlotY2 != null && overlay != this.primaryPlotY2) {
                rm.addInputRange(dr2);
            } else if (this.isPrimariablePlot(overlay)) {
                this.primaryPlotY2 = overlay;
                rm.addInputRangeToFirst(dr2);
            } else {
                rm.addInputRange(dr2);
            }
            addAxisRange = this.includeY2AxisRange;
        }
        if (addAxisRange && va.getDataRange(va.getDimension()) instanceof ContinuousRange) {
            rm.replaceInputRange(axis_dr, va.getDataRange(va.getDimension()));
        }
        overlay.addRangeChangeListener((RangeChangeListener)rm);
        if (axis.isSortTickValueByOverlay()) {
            axis.copySortedTickValues();
        }
        return true;
    }

    public void disconnect(Overlay overlay, AbstractAxis axis, byte dimension) {
        if (!this.isConnected(overlay, axis, dimension)) {
            return;
        }
        OverlayDimension od = new OverlayDimension(overlay, dimension);
        this.OD2A.remove(od);
        Vector odv = (Vector)this.A2ODV.get(axis);
        odv.removeElement(od);
        RangeMerger rm = (RangeMerger)this.A2RM.get(axis);
        rm.removeInputRange(overlay.getDataRange(dimension));
        overlay.removeRangeChangeListener((RangeChangeListener)rm);
    }

    public boolean isConnected(Overlay overlay, AbstractAxis axis, byte dimension) {
        AbstractAxis a = this.getAxis(overlay, dimension);
        if (a == null) {
            return false;
        }
        return a.equals(axis);
    }

    public VRectGridLines getGridLines(AbstractAxis axis) {
        return this.getGridLines(axis, false);
    }

    public VRectGridLines getGridLines(AbstractAxis axis, boolean greenBar) {
        Vector v;
        Object obj = this.A2GLV.get(axis);
        if (obj != null && (v = (Vector)obj).size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                VRectGridLines grid = (VRectGridLines)((Vector)obj).elementAt(i);
                if ((!greenBar || !grid.isGreenBarOn()) && (greenBar || grid.isGreenBarOn())) continue;
                return grid;
            }
        }
        return null;
    }

    public VRectGridLines getGreenBar(AbstractAxis axis) {
        return this.getGridLines(axis, true);
    }

    public void connect(VRectGridLines rgl, AbstractAxis axis) {
        this.connect(rgl, axis, false);
    }

    public void connect(VRectGridLines rgl, AbstractAxis axis, boolean greenBar) {
        Vector<VRectGridLines> glv;
        this.addGridLines(rgl);
        if (!this.axes.contains(axis)) {
            this.addAxis(axis);
        }
        rgl.setShownAtMidpoint(((VRectAxis)axis).isTicksShownAtMidpoint());
        if (greenBar) {
            rgl.setGreenBarOn(((VRectAxis)axis).isGreenBarOn());
            rgl.setGreenBarColor(((VRectAxis)axis).getGreenBarColor());
        }
        byte dim = axis.getDimension();
        rgl.setDimension(dim);
        byte dir = rgl.getDirection();
        if (dir == dim) {
            switch (dim) {
                case 1: {
                    dir = 2;
                    break;
                }
                case 2: {
                    dir = 1;
                }
            }
            rgl.setDirection(dir);
        }
        this.GL2A.put(rgl, axis);
        Object obj = this.A2GLV.get(axis);
        if (obj == null) {
            glv = new Vector<VRectGridLines>();
            this.A2GLV.put(axis, glv);
        } else {
            glv = (Vector<VRectGridLines>)obj;
        }
        glv.addElement(rgl);
    }

    public void connectGreenBar(VRectGridLines rgl, AbstractAxis axis) {
        this.connect(rgl, axis, true);
    }

    public void disconnect(VRectGridLines rgl, AbstractAxis axis) {
        if (!this.isConnected(rgl, axis)) {
            return;
        }
        this.GL2A.remove(rgl);
        Vector glv = (Vector)this.A2GLV.get(axis);
        glv.removeElement(rgl);
    }

    public boolean isConnected(VRectGridLines rgl, AbstractAxis axis) {
        Object val = this.GL2A.get(rgl);
        if (val == null) {
            return false;
        }
        AbstractAxis ai = (AbstractAxis)val;
        return ai.equals(axis);
    }

    public boolean contains(Overlay overlay) {
        return this.overlays.contains(overlay);
    }

    public boolean contains(AbstractAxis axis) {
        return this.axes.contains(axis);
    }

    public void rangeChanged(RangeChangedEvent e) {
    }

    private void checkCurveLabelCollisions() {
        Rectangle curr;
        int i;
        Rectangle prev;
        Overlay o;
        this.CLOverlappingChecked = true;
        ArrayList xb = new ArrayList();
        ArrayList x2b = new ArrayList();
        for (int i2 = 0; i2 < this.overlays.size(); ++i2) {
            Overlay line;
            o = (Overlay)this.overlays.get(i2);
            if (o instanceof ScatterOverlay) {
                ScatterOverlay plot = (ScatterOverlay)o;
                if (plot.isCurveLabeled()) {
                    plot.addXBBoxes(xb, x2b);
                }
            } else if (o instanceof BandOverlay) {
                BandOverlay band = (BandOverlay)o;
                if (band.isCurveLabeled()) {
                    band.addXBBoxes(xb, x2b);
                }
            } else if (o instanceof LineParmOverlay) {
                line = (LineParmOverlay)o;
                if (((LineParmOverlay)line).isCurveLabeled()) {
                    ((LineParmOverlay)line).addXBBoxes(xb, x2b);
                }
            } else if (o instanceof ReferenceLineOverlay && ((ReferenceLineOverlay)(line = (ReferenceLineOverlay)o)).isCurveLabeled()) {
                ((ReferenceLineOverlay)line).addXBBoxes(xb, x2b);
            }
            if (this.curveLabelSplit) continue;
            this.curveLabelSplit = o.isCurveLabelSplit();
        }
        if (xb.size() == 0 && x2b.size() == 0) {
            return;
        }
        Comparator cm = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Rectangle)o1).x - ((Rectangle)o2).x;
            }
        };
        if (xb.size() > 0) {
            Collections.sort(xb, cm);
            prev = (Rectangle)xb.get(0);
            for (i = 1; i < xb.size(); ++i) {
                curr = (Rectangle)xb.get(i);
                if (prev.intersects(curr) && !this.curveLabelSplit) {
                    this.xCLOverlapped = true;
                    break;
                }
                prev = curr;
            }
        }
        if (x2b.size() > 0) {
            Collections.sort(x2b, cm);
            prev = (Rectangle)x2b.get(0);
            for (i = 1; i < x2b.size(); ++i) {
                curr = (Rectangle)x2b.get(i);
                if (prev.intersects(curr) && !this.curveLabelSplit) {
                    this.x2CLOverlapped = true;
                    break;
                }
                prev = curr;
            }
        }
        for (int i3 = 0; i3 < this.overlays.size(); ++i3) {
            ReferenceLineOverlay line;
            o = (Overlay)this.overlays.get(i3);
            if (o instanceof ScatterOverlay) {
                ScatterOverlay plot = (ScatterOverlay)o;
                if (!plot.isCurveLabeled()) continue;
                plot.setRotateXCurveLabels(this.xCLOverlapped);
                plot.setRotateX2CurveLabels(this.x2CLOverlapped);
                continue;
            }
            if (o instanceof BandOverlay) {
                BandOverlay band = (BandOverlay)o;
                if (!band.isCurveLabeled()) continue;
                band.setRotateXCurveLabels(this.xCLOverlapped);
                band.setRotateX2CurveLabels(this.x2CLOverlapped);
                continue;
            }
            if (o instanceof LineParmOverlay) {
                LineParmOverlay line2 = (LineParmOverlay)o;
                if (!line2.isCurveLabeled()) continue;
                line2.setRotateXCurveLabels(this.xCLOverlapped);
                line2.setRotateX2CurveLabels(this.x2CLOverlapped);
                continue;
            }
            if (!(o instanceof ReferenceLineOverlay) || !(line = (ReferenceLineOverlay)o).isCurveLabeled()) continue;
            line.setRotateXCurveLabels(this.xCLOverlapped);
            line.setRotateX2CurveLabels(this.x2CLOverlapped);
        }
        if (this.xCLOverlapped || this.x2CLOverlapped) {
            this.updatePrefs();
            this.updateEncoders();
        }
    }

    public void resize() {
        if (this.channel == null) {
            return;
        }
        this.allocateAxisSize();
        if (this.squareFormat != EQUATED_NONE) {
            this.resetMargins();
            if (this.squareFormat == EQUATED_SQUARE) {
                this.equateAxesRange();
            } else if (this.squareFormat == EQUATED_MAXAREA || this.squareFormat == EQUATED_CENTER || this.squareFormat == EQUATED_SQUAREDATA) {
                this.resetAxesRange();
            }
        }
        this.updateRegions();
        this.setEncoders();
        this.updateEncoders();
        this.initialFitting = true;
        this.updatePrefs();
        this.updateEncoders();
        this.initialFitting = false;
        this.updatePrefs();
        this.updateEncoders();
        if (!this.CLOverlappingChecked) {
            this.checkCurveLabelCollisions();
        }
        this.updateAxisSize();
        this.esriAdjustBounds();
    }

    private void allocateAxisSize() {
        VRectAxis va;
        int i;
        if (this instanceof Simple3DOverlayComposite || this instanceof SimpleExtrudedOverlayComposite) {
            return;
        }
        if (this.yAxisMaxWidthPercentage + this.y2AxisMaxWidthPercentage > 1.0) {
            this.yAxisMaxWidthPercentage = 0.25;
            this.y2AxisMaxWidthPercentage = 0.25;
        }
        int numX = 0;
        int numY = 0;
        double alignmentOffsetY = 0.0;
        double alignmentOffsetY2 = 0.0;
        for (i = 0; i < this.axes.size(); ++i) {
            va = (VRectAxis)this.axes.get(i);
            if (va.getDimension() == 1) {
                ++numX;
                continue;
            }
            if (va.getDimension() != 2) continue;
            ++numY;
            if (va.getPrimary()) {
                alignmentOffsetY = this.getAlignmentOffset(va);
                continue;
            }
            alignmentOffsetY2 = this.getAlignmentOffset(va);
        }
        for (i = 0; i < this.axes.size(); ++i) {
            va = (VRectAxis)this.axes.get(i);
            if (!va.isVisible()) continue;
            boolean primary = va.getPrimary();
            if (va.getDimension() == 1) {
                if (primary && !this.origin_py) {
                    va.setAllocatedSize(this.xAxisMaxHeightPercentage / (double)numX * (double)this.height);
                    continue;
                }
                if (primary || this.origin_sy) continue;
                va.setAllocatedSize(this.xAxisMaxHeightPercentage / (double)numX * (double)this.height);
                continue;
            }
            if (primary && !this.origin_px) {
                va.setAllocatedSize(this.yAxisMaxWidthPercentage * (double)this.width);
                continue;
            }
            if (primary || this.origin_sx) continue;
            va.setAllocatedSize(this.y2AxisMaxWidthPercentage * (double)this.width);
        }
        for (i = 0; i < this.overlays.size(); ++i) {
            Object o = this.overlays.get(i);
            if (!(o instanceof AxisTable) || !((AxisTable)o).isDataOnHorizontalSide()) continue;
            AxisTable at = (AxisTable)o;
            if (at.getLabelPositionInUse() == 1) {
                if (at.isLabelToGridLabel()) {
                    at.setLabelMaxWidth(this.leftGridLabelMaxWidth - alignmentOffsetY);
                    continue;
                }
                at.setLabelMaxWidth(this.yAxisMaxWidthPercentage * (double)this.width - alignmentOffsetY);
                continue;
            }
            if (at.isLabelToGridLabel()) {
                at.setLabelMaxWidth(this.rightGridLabelMaxWidth - alignmentOffsetY2);
                continue;
            }
            at.setLabelMaxWidth(this.y2AxisMaxWidthPercentage * (double)this.width - alignmentOffsetY2);
        }
    }

    private void esriAdjustBounds() {
        int numOverlays = this.overlays.size();
        ESRIMapLayerOverlay esriOverlay = null;
        for (int i = 0; i < numOverlays; ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!(o instanceof ESRIMapLayerOverlay)) continue;
            esriOverlay = (ESRIMapLayerOverlay)o;
            break;
        }
        if (esriOverlay == null) {
            return;
        }
        Object[] axes = this.getAxes();
        AbstractAxis xAxis = (AbstractAxis)axes[0];
        ContinuousRange xr = (ContinuousRange)xAxis.getInputDataRange();
        AbstractAxis yAxis = (AbstractAxis)axes[1];
        ContinuousRange yr = (ContinuousRange)yAxis.getInputDataRange();
        PositionEncoder xEncoder = (PositionEncoder)xAxis.getEncoder((byte)1);
        PositionEncoder yEncoder = (PositionEncoder)yAxis.getEncoder((byte)2);
        Rectangle2D.Double oldBounds = new Rectangle2D.Double(xr.getMin(), yr.getMin(), xr.getMax() - xr.getMin(), yr.getMax() - yr.getMin());
        Rectangle2D.Double newBounds = esriOverlay.getMapBounds(oldBounds, (int)xEncoder.getOutputMax(), (int)yEncoder.getOutputMax());
        if (newBounds == null) {
            return;
        }
        ContinuousRange newXRange = new ContinuousRange(newBounds.x, newBounds.x + newBounds.width);
        ContinuousRange newYRange = new ContinuousRange(newBounds.y, newBounds.y + newBounds.height);
        xEncoder.setInput((DataRange)newXRange);
        yEncoder.setInput((DataRange)newYRange);
    }

    public synchronized void setEncoders() {
        int anum = this.axes.size();
        if (anum < 1) {
            return;
        }
        for (int i = 0; i < anum; ++i) {
            Vector glv;
            int j;
            PositionEncoder pe;
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            DataRange range = a.getDataRange(dim);
            Encoder currEncoder = a.getEncoder(a.getDimension());
            if (((VRectAxis)a).isBrokenAxis()) {
                if (currEncoder instanceof BrokenPositionEncoder) {
                    pe = (BrokenPositionEncoder)currEncoder;
                    ((BrokenPositionEncoder)pe).setInputRanges(((VRectAxis)a).getOutputRanges());
                } else {
                    pe = new BrokenPositionEncoder(((VRectAxis)a).getOutputRanges());
                }
                pe.setRange(range);
                this.brokenAxis = true;
                this.brokenAxisHash = ((VRectAxis)a).getBrokenAxisHash();
            } else if (currEncoder instanceof PositionEncoder) {
                pe = (PositionEncoder)currEncoder;
                pe.setRange(range);
            } else {
                pe = new PositionEncoder(range);
            }
            pe.setReversed(a.isReverse());
            switch (a.getType()) {
                case 1: {
                    pe.setType(1);
                    break;
                }
                case 5: {
                    pe.setType(2);
                    break;
                }
                case 6: {
                    DataRange dr;
                    String[] ticks = ((VRectAxis)a).getDiscreteTicks();
                    if (ticks != null && range != null && !(range instanceof StubRange) && ((DiscreteRange)range).getValuesSize() != 0) {
                        String label = range.getLabel();
                        SASFormat fmt = range.getColumnFormat();
                        if (fmt == null && range instanceof OrdinalRange) {
                            fmt = DataModel.defaultFormat;
                        }
                        String[] formattedTicks = ticks;
                        if (fmt != null) {
                            String formattedMiss = StatGraph.missingOption;
                            if (range instanceof OrdinalRange) {
                                formattedMiss = fmt.format((Object)new Double(Double.NaN)).trim();
                                if (formattedMiss == null || formattedMiss.equals(".")) {
                                    formattedMiss = StatGraph.missingOption;
                                }
                            } else {
                                formattedMiss = fmt.format((Object)" ").trim();
                                if (formattedMiss == null || formattedMiss.length() == 0) {
                                    formattedMiss = StatGraph.missingCharacter;
                                }
                            }
                            formattedTicks = new String[ticks.length];
                            for (j = 0; j < ticks.length; ++j) {
                                if (range instanceof OrdinalRange) {
                                    if (ticks[j].equals(".")) {
                                        formattedTicks[j] = formattedMiss;
                                        continue;
                                    }
                                    if (StatGraph.isNumber(ticks[j])) {
                                        Double dv = new Double(ticks[j]);
                                        formattedTicks[j] = fmt.format((Object)dv).trim();
                                        continue;
                                    }
                                    formattedTicks[j] = ticks[j];
                                    continue;
                                }
                                formattedTicks[j] = ticks[j].trim().length() == 0 ? formattedMiss : fmt.format((Object)ticks[j]);
                            }
                        }
                        DataRange dr2 = Simple2DOverlayComposite.getModifiedDataRange(range, formattedTicks, ((VRectAxis)a).getTickValueListPolicy());
                        dr2.setLabel(label);
                        pe.setRange(dr2);
                        break;
                    }
                    if (a.getTickValueOrder() == 1) {
                        pe.setOrder(1);
                        break;
                    }
                    if (a.getTickValueOrder() == 2) {
                        pe.setOrder(2);
                        break;
                    }
                    if (a.getTickValueOrder() == 3) {
                        if (a.isSortTickValueByOverlay()) {
                            pe.setOrder(0);
                            dr = Simple2DOverlayComposite.getModifiedDataRange(range, a.getSortedTickValues(), 1);
                            dr.setLabel(range.getLabel());
                            pe.setRange(dr);
                            break;
                        }
                        if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                            pe.setOrder(1);
                            break;
                        }
                        pe.setOrder(0);
                        break;
                    }
                    if (a.getTickValueOrder() == 4) {
                        if (a.isSortTickValueByOverlay()) break;
                        if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                            pe.setOrder(1);
                            break;
                        }
                        pe.setOrder(1);
                        break;
                    }
                    if (a.getTickValueOrder() == 5) {
                        if (a.isSortTickValueByOverlay()) {
                            pe.setOrder(0);
                            dr = Simple2DOverlayComposite.getModifiedDataRange(range, a.getSortedTickValues(), 1);
                            dr.setLabel(range.getLabel());
                            pe.setRange(dr);
                            break;
                        }
                        if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                            pe.setOrder(1);
                            break;
                        }
                        pe.setOrder(0);
                        break;
                    }
                    if (a.getTickValueOrder() == 6) {
                        if (a.isSortTickValueByOverlay()) break;
                        if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                            pe.setOrder(1);
                            break;
                        }
                        pe.setOrder(2);
                        break;
                    }
                    if (a.getTickValueOrder() == 0) {
                        pe.setOrder(0);
                        break;
                    }
                    if (a.getTickValueOrder() != -1) break;
                    if (a.isSortTickValueByOverlay()) {
                        pe.setOrder(0);
                        break;
                    }
                    if (range instanceof OrdinalRange && !((OrdinalRange)range).isChangedToDiscrete()) {
                        pe.setOrder(1);
                        break;
                    }
                    pe.setOrder(0);
                    break;
                }
            }
            boolean reduceTitleSpace = false;
            if (dim == 1) {
                AbstractAxis ya = this.getAxis((byte)2, ((VRectAxis)a).getPrimary());
                reduceTitleSpace = ya != null ? !Double.isNaN(ya.getOrigin()) : false;
            } else if (dim == 2) {
                AbstractAxis xa = this.getAxis((byte)1, ((VRectAxis)a).getPrimary());
                reduceTitleSpace = xa != null ? !Double.isNaN(xa.getOrigin()) : false;
            }
            ((VRectAxis)a).setReducedTitleSpace(reduceTitleSpace);
            a.setEncoder(a.getDimension(), pe);
            String[] labels = null;
            Vector odv = (Vector)this.A2ODV.get(a);
            if (odv != null) {
                ArrayList<String> llist = new ArrayList<String>();
                byte d = 0;
                for (int j2 = 0; j2 < odv.size(); ++j2) {
                    OverlayDimension od = (OverlayDimension)odv.elementAt(j2);
                    Overlay o = od.getOverlay();
                    d = od.getDimension();
                    o.setEncoder(d, pe);
                    String[] lab = o.getLabels(d);
                    if (lab == null) continue;
                    for (int l = 0; l < lab.length; ++l) {
                        llist.add(lab[l]);
                    }
                }
                labels = new String[llist.size()];
                for (int l = 0; l < llist.size(); ++l) {
                    labels[l] = (String)llist.get(l);
                }
            }
            if (a.getDimension() == 2) {
                ((VRectAxis)a).setStackedLabels(labels);
            }
            if ((glv = (Vector)this.A2GLV.get(a)) == null) continue;
            ((VRectAxis)a).setGridlines(glv);
            for (j = 0; j < glv.size(); ++j) {
                VRectGridLines rgl = (VRectGridLines)glv.elementAt(j);
                rgl.setEncoder(pe);
                rgl.setMinorGridOn(((VRectAxis)a).getRectAxisParams().getMinorNum() > 0 && ((VRectAxis)a).isMinorGridOn());
                rgl.setMinorTickCount(((VRectAxis)a).getRectAxisParams().getMinorNum());
                rgl.setMinorLineStyle(((VRectAxis)a).getMinorGridStyle());
            }
        }
    }

    public static DataRange getModifiedDataRange(DataRange dr, String[] formattedTicks, int policy) {
        switch (policy) {
            case 0: {
                dr = new DiscreteRange((Object[])formattedTicks);
                break;
            }
            case 2: {
                Vector newValues = Simple2DOverlayComposite.getIntersection(formattedTicks, ((DiscreteRange)dr).getValues());
                dr = new DiscreteRange(newValues.toArray());
                break;
            }
            case 1: {
                Vector newValues = new Vector();
                for (int i = 0; i < formattedTicks.length; ++i) {
                    if (newValues.contains(formattedTicks[i])) continue;
                    newValues.addElement(formattedTicks[i]);
                }
                newValues = Simple2DOverlayComposite.appendData(newValues, ((DiscreteRange)dr).getValues());
                dr = new DiscreteRange(newValues.toArray());
                break;
            }
            case 3: {
                Vector values = ((DiscreteRange)dr).getValues();
                Vector newValues = Simple2DOverlayComposite.getIntersection(formattedTicks, values);
                newValues = Simple2DOverlayComposite.appendData(newValues, values);
                dr = new DiscreteRange(newValues.toArray());
            }
        }
        return dr;
    }

    private static Vector getIntersection(String[] list, Vector data) {
        Vector<String> newValues = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            if (!data.contains(list[i]) || newValues.contains(list[i])) continue;
            newValues.addElement(list[i]);
        }
        return newValues;
    }

    private static Vector appendData(Vector newValues, Vector data) {
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            Object v = data.get(i);
            if (newValues.contains(v)) continue;
            newValues.addElement(v);
        }
        return newValues;
    }

    private double getAlignmentOffset(AbstractAxis axis) {
        AxisStyle as;
        if (!axis.isVisible()) {
            as = new AxisStyle(axis.getAxisStyle());
            as.getMajorTickStyle().setLength(0.4);
            as.setHorizontalLabelSpace(0.25);
            as.setVerticalLabelSpace(0.25);
            if (((VRectAxis)axis).isTickBoxOn()) {
                as.setMajorTickMarksOn(false);
            }
        } else {
            as = axis.getAxisStyle();
        }
        this.channel.glSelect2DFont(as.getLabelStyle().getFont());
        double labelHeight = this.channel.glGetTextHeight();
        double offset = 0.0;
        if (as.isMajorTickMarksOn()) {
            switch (as.getMajorTickStyle().getTickMarkJustification()) {
                case 0: {
                    offset = 0.0;
                    break;
                }
                case 1: {
                    offset = as.getMajorTickStyle().getLength() * labelHeight;
                    break;
                }
                case 2: {
                    offset = as.getMajorTickStyle().getLength() * labelHeight / 2.0;
                }
            }
        } else {
            offset = 0.15 * labelHeight;
        }
        offset = axis.getDimension() == 1 ? (offset += as.getVerticalLabelSpace() * labelHeight) : (offset += as.getHorizontalLabelSpace() * labelHeight);
        return offset;
    }

    protected synchronized void updateEncoders() {
        int i;
        int anum = this.axes.size();
        double outMin = 0.0;
        double outMax = 0.0;
        double lowerLim = 0.0;
        double upperLim = 0.0;
        boolean calcTitleSize = false;
        if (this.squareFormat != EQUATED_NONE && anum > 1 && !this.innerRegion.isEmpty()) {
            if (this.squareFormat == EQUATED_SQUARE) {
                this.adjustAspect();
                calcTitleSize = true;
            } else if (this.squareFormat == EQUATED_MAXAREA) {
                this.equateAxesInterval(true);
            } else if (this.squareFormat == EQUATED_CENTER) {
                this.equateAxesInterval(false);
                this.adjustAspect();
                calcTitleSize = true;
            } else if (this.squareFormat == EQUATED_SQUAREDATA) {
                this.equateAxesRangeAndInterval();
                this.adjustAspect();
                calcTitleSize = true;
            }
        }
        if (this.aspectRatio > 0.0) {
            this.honorUserAspectRatio(this.aspectRatio);
        }
        for (int i2 = 0; i2 < anum; ++i2) {
            Vector odv;
            Vector glv;
            AbstractAxis a = (AbstractAxis)this.axes.get(i2);
            byte dim = a.getDimension();
            if (dim == 1) {
                if (((VRectAxis)a).getPrimary()) {
                    outMin = 0.0;
                    outMax = this.innerRegion.width;
                    lowerLim = 0 - this.innerMargin.left;
                    upperLim = outMax + (double)this.innerMargin.right;
                } else {
                    outMin = 0.0;
                    outMax = this.innerRegion2.width;
                    lowerLim = 0 - this.innerMargin2.left;
                    upperLim = outMax + (double)this.innerMargin2.right;
                }
                ((VRectAxis)a).setSpaceForInnerMargin(this.overlayMargin.left + this.overlayMargin.right);
            } else if (dim == 2) {
                if (((VRectAxis)a).getPrimary()) {
                    outMin = 0.0;
                    outMax = this.innerRegion.height;
                    lowerLim = 0 - this.innerMargin.bottom;
                    upperLim = outMax + (double)this.innerMargin.top;
                } else {
                    outMin = 0.0;
                    outMax = this.innerRegion2.height;
                    lowerLim = 0 - this.innerMargin2.bottom;
                    upperLim = outMax + (double)this.innerMargin2.top;
                }
                ((VRectAxis)a).setSpaceForInnerMargin(this.overlayMargin.top + this.overlayMargin.bottom);
            }
            PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
            if (pe == null) continue;
            if (outMin != pe.getOutputMin() || outMax != pe.getOutputMax() || lowerLim != pe.getLowerLimit() || upperLim != pe.getUpperLimit()) {
                if (upperLim - lowerLim != pe.getUpperLimit() - pe.getLowerLimit()) {
                    calcTitleSize = true;
                }
                pe.setOutputMin(outMin);
                pe.setOutputMax(outMax);
                pe.setLowerLimit(lowerLim);
                pe.setUpperLimit(upperLim);
                a.setEncoder(a.getDimension(), pe);
                pe.getValueMap().init((AInitAction)new InitAction(null));
                ((VRectAxis)a).recomputeTitleSize(calcTitleSize);
            }
            if ((glv = (Vector)this.A2GLV.get(a)) != null) {
                VRectAxis vra = (VRectAxis)a;
                for (int j = 0; j < glv.size(); ++j) {
                    VRectGridLines rgl = (VRectGridLines)glv.elementAt(j);
                    if (rgl.getDirection() == 1) {
                        if (vra.getPrimary()) {
                            rgl.setStart(-this.innerMargin.left);
                            rgl.setEnd(this.innerRegion.width + this.innerMargin.right - 1);
                        } else {
                            rgl.setStart(-this.innerMargin2.left);
                            rgl.setEnd(this.innerRegion2.width + this.innerMargin2.right - 1);
                        }
                    } else if (rgl.getDirection() == 2) {
                        if (vra.getPrimary()) {
                            rgl.setStart(-this.innerMargin.bottom);
                            rgl.setEnd(this.innerRegion.height + this.innerMargin.top - 1);
                        } else {
                            rgl.setStart(-this.innerMargin2.bottom);
                            rgl.setEnd(this.innerRegion2.height + this.innerMargin2.top - 1);
                        }
                    }
                    if (vra.getTicks() != null && !vra.isBrokenAxis()) {
                        rgl.setTicks(vra.getTicks());
                        rgl.setTickValuePriority(vra.getTickValuePriority());
                        if (!(pe.getValueMap() instanceof ContinuousRangeToNumericMap)) continue;
                        rgl.setMinimum((DataPoint)new ContinuousPoint(((ContinuousRangeToNumericMap)pe.getValueMap()).getOutputMin()));
                        rgl.setMaximum((DataPoint)new ContinuousPoint(((ContinuousRangeToNumericMap)pe.getValueMap()).getOutputMax()));
                        continue;
                    }
                    DataRange dr = vra.getDataRange(vra.getDimension());
                    if (dr instanceof ContinuousRange) {
                        ContinuousRange cr = (ContinuousRange)dr;
                        if (vra.getAxisLabelMap() != null) {
                            PositionEncoder peg = new PositionEncoder(dr);
                            peg.setReversed(pe.isReversed());
                            if (peg.getValueMap() instanceof ContinuousRangeToNumericMap) {
                                ContinuousRangeToNumericMap pegMap = (ContinuousRangeToNumericMap)peg.getValueMap();
                                pegMap.setLabelCount(vra.getAxisLabelMap().getLabelCount());
                                peg.setLowerLimit(lowerLim);
                                peg.setUpperLimit(upperLim);
                                peg.setOutputMin(vra.getAxisLabelMap().getOutputMin());
                                peg.setOutputMax(vra.getAxisLabelMap().getOutputMax());
                                rgl.setEncoder(peg);
                            }
                            rgl.setMinimum((DataPoint)new ContinuousPoint(((ContinuousRangeToNumericMap)pe.getValueMap()).getOutputMin()));
                            rgl.setMaximum((DataPoint)new ContinuousPoint(((ContinuousRangeToNumericMap)pe.getValueMap()).getOutputMax()));
                        } else {
                            rgl.setMinimum((DataPoint)new ContinuousPoint(((ContinuousRangeToNumericMap)pe.getValueMap()).getOutputMin()));
                            rgl.setMaximum((DataPoint)new ContinuousPoint(((ContinuousRangeToNumericMap)pe.getValueMap()).getOutputMax()));
                            rgl.setInterval(vra.getMajorInterval());
                        }
                    }
                    if (!((VRectAxis)a).isBrokenAxis()) continue;
                    NumericVector tickPos = new NumericVector();
                    ContinuousRangeToNumericMap[] outputMaps = ((BrokenPositionEncoder)pe).getRangeOutputMaps();
                    double[][] tickValues = ((VRectAxis)a).getTickValuesOnBrokenAxis();
                    for (int ii = 0; ii < outputMaps.length; ++ii) {
                        int idx = pe.isReversed() ? outputMaps.length - 1 - ii : ii;
                        for (int jj = 0; jj < tickValues[idx].length; ++jj) {
                            int idx2 = pe.isReversed() ? tickValues[idx].length - 1 - jj : jj;
                            tickPos.addValue(outputMaps[ii].getValue(tickValues[idx][idx2]));
                        }
                    }
                    rgl.setPositionOffset((NumericPipe)tickPos);
                    if (!rgl.isMinorGridOn()) continue;
                    NumericVector minorTickPos = new NumericVector();
                    double[][] minorTickValues = ((VRectAxis)a).getMinorTickValuesOnBrokenAxis();
                    for (int ii = 0; ii < outputMaps.length; ++ii) {
                        int idx = pe.isReversed() ? outputMaps.length - 1 - ii : ii;
                        for (int jj = 0; jj < minorTickValues[idx].length; ++jj) {
                            int idx2 = pe.isReversed() ? minorTickValues[idx].length - 1 - jj : jj;
                            minorTickPos.addValue(outputMaps[ii].getValue(minorTickValues[idx][idx2]));
                        }
                    }
                    rgl.setMinorPositionOffset((NumericPipe)minorTickPos);
                }
            }
            if (((VRectAxis)a).getComposite() != null) {
                ((VRectAxis)a).getComposite().updateOuterMargin(this.outerMargin, glv);
            }
            if ((odv = (Vector)this.A2ODV.get(a)) == null) continue;
            byte d = 0;
            for (int j = 0; j < odv.size(); ++j) {
                OverlayDimension od = (OverlayDimension)odv.elementAt(j);
                Overlay o = od.getOverlay();
                if (o.isComputedOverlay()) {
                    d = od.getDimension();
                    o.setEncoder(d, pe);
                }
                if (this.wall == null || o.getGradientEndColor() != null) continue;
                o.setGradientEndColor(this.wall.getFillStyle().getColor());
            }
        }
        double alignmentOffsetX = 0.0;
        double alignmentOffsetX2 = 0.0;
        double alignmentOffsetY = 0.0;
        double alignmentOffsetY2 = 0.0;
        for (i = 0; i < anum; ++i) {
            VRectAxis ra = (VRectAxis)this.axes.get(i);
            if (ra.getDimension() == 1) {
                if (ra.getPrimary()) {
                    ra.setStartOffset(this.innerMargin.left - this.overlayMargin.left);
                    double offset = 0.0;
                    if (ra.getAxisStyle().getLineWidth() > 1) {
                        offset = 1.0;
                    }
                    ra.setEndOffset((double)(this.innerMargin.right - this.overlayMargin.right) + offset);
                    alignmentOffsetX = this.getAlignmentOffset(ra);
                    continue;
                }
                ra.setStartOffset(this.innerMargin2.left - this.overlayMargin.left);
                ra.setEndOffset(this.innerMargin2.right - this.overlayMargin.right);
                alignmentOffsetX2 = this.getAlignmentOffset(ra);
                continue;
            }
            if (ra.getDimension() != 2) continue;
            if (ra.getLabelPosition() == 1) {
                if (ra.getPrimary()) {
                    ra.setStartOffset(this.innerMargin.bottom - this.overlayMargin.bottom);
                    ra.setEndOffset(this.innerMargin.top - this.overlayMargin.top);
                    alignmentOffsetY = this.getAlignmentOffset(ra);
                    continue;
                }
                ra.setStartOffset(this.innerMargin2.bottom - this.overlayMargin.bottom);
                ra.setEndOffset(this.innerMargin2.top - this.overlayMargin.top);
                alignmentOffsetY2 = this.getAlignmentOffset(ra);
                continue;
            }
            if (ra.getPrimary()) {
                ra.setStartOffset(this.innerMargin.bottom);
                ra.setEndOffset(this.innerMargin.top);
                alignmentOffsetY = this.getAlignmentOffset(ra);
                continue;
            }
            ra.setStartOffset(this.innerMargin2.bottom);
            ra.setEndOffset(this.innerMargin2.top);
            alignmentOffsetY2 = this.getAlignmentOffset(ra);
        }
        for (i = 0; i < this.overlays.size(); ++i) {
            Object ovly = this.overlays.get(i);
            if (ovly instanceof AxisTable) {
                AxisTable at = (AxisTable)this.overlays.get(i);
                if (at.getAxis() == 1 || at.getAxis() == 2) {
                    if (at.getLabelPositionInUse() == 1) {
                        at.setAlignmentOffset(alignmentOffsetY, "y");
                        continue;
                    }
                    at.setAlignmentOffset(alignmentOffsetY2, "y2");
                    continue;
                }
                if (at.getLabelPositionInUse() == 1) {
                    at.setAlignmentOffset(alignmentOffsetX, "x");
                    continue;
                }
                at.setAlignmentOffset(alignmentOffsetX2, "x2");
                continue;
            }
            if (!(ovly instanceof PolygonOverlay)) continue;
            PolygonOverlay poly = (PolygonOverlay)ovly;
            if (poly.getXAxis().equalsIgnoreCase("x")) {
                poly.setAlignmentOffset(alignmentOffsetX, "x");
                poly.setAlignmentOffset(alignmentOffsetX, "x2");
            } else {
                poly.setAlignmentOffset(alignmentOffsetX2, "x");
                poly.setAlignmentOffset(alignmentOffsetX2, "x2");
            }
            if (poly.getYAxis().equalsIgnoreCase("y")) {
                poly.setAlignmentOffset(alignmentOffsetY, "y");
                poly.setAlignmentOffset(alignmentOffsetY, "y2");
                continue;
            }
            poly.setAlignmentOffset(alignmentOffsetY2, "y");
            poly.setAlignmentOffset(alignmentOffsetY2, "y2");
        }
        if (this.wall != null) {
            this.wall.setBounds(0, 0, this.outerRegion.width, this.outerRegion.height);
        }
        int gap = (int)Math.round(5.0 * StatGraph.getGapScaleFactor());
        gap = 0;
        if (this.overlayInnerMargins != null) {
            this.innerMarginBorder = new Insets(0, 0, 0, 0);
            if (this.overlayMargin.top > 0) {
                this.innerMarginBorder.top = this.overlayMargin.top - gap;
            }
            if (this.overlayMargin.bottom > 0) {
                this.innerMarginBorder.bottom = this.overlayMargin.bottom - gap;
            }
            if (this.overlayMargin.left > 0) {
                this.innerMarginBorder.left = this.overlayMargin.left - gap;
            }
            if (this.overlayMargin.right > 0) {
                this.innerMarginBorder.right = this.overlayMargin.right - gap;
            }
        }
    }

    public Insets getPreferredInnerMargin() {
        return this.prefInner;
    }

    public Insets getPreferredInnerMargin2() {
        return this.prefInner2;
    }

    public DataRangeInterface getInputRange(AbstractAxis axis) {
        RangeMerger rm = (RangeMerger)this.A2RM.get(axis);
        return rm;
    }

    public Insets getPreferredOuterMargin() {
        return this.prefOuter;
    }

    public void updatePrefs() {
        int ls;
        double len;
        int ls2;
        VRectAxis oa;
        int i;
        boolean innerMarginOverlayOnly;
        OverlayInnerMargin oim;
        Overlay o;
        int i2;
        Insets ext;
        Insets XP = new Insets(0, 0, 0, 0);
        Insets YP = new Insets(0, 0, 0, 0);
        Insets XS = new Insets(0, 0, 0, 0);
        Insets YS = new Insets(0, 0, 0, 0);
        Insets XP2 = new Insets(0, 0, 0, 0);
        Insets YP2 = new Insets(0, 0, 0, 0);
        Insets XS2 = new Insets(0, 0, 0, 0);
        Insets YS2 = new Insets(0, 0, 0, 0);
        int[] XPOffsets = new int[]{0, 0};
        int[] YPOffsets = new int[]{0, 0};
        int[] XSOffsets = new int[]{0, 0};
        int[] YSOffsets = new int[]{0, 0};
        boolean mirrorX = false;
        boolean mirrorX2 = false;
        boolean mirrorY = false;
        boolean mirrorY2 = false;
        int xLineWidth = 1;
        int x2LineWidth = 1;
        int yLineWidth = 1;
        int y2LineWidth = 1;
        AbstractAxis axis_px = this.getAxis((byte)1, true);
        AbstractAxis axis_py = this.getAxis((byte)2, true);
        AbstractAxis axis_sx = this.getAxis((byte)1, false);
        AbstractAxis axis_sy = this.getAxis((byte)2, false);
        this.origin_px = axis_px instanceof VRectAxis && ((VRectAxis)axis_px).isOriginOn();
        this.origin_py = axis_py instanceof VRectAxis && ((VRectAxis)axis_py).isOriginOn();
        this.origin_sx = axis_sx instanceof VRectAxis && ((VRectAxis)axis_sx).isOriginOn();
        this.origin_sy = axis_sy instanceof VRectAxis && ((VRectAxis)axis_sy).isOriginOn();
        int YPTopLabelHeight = 0;
        int YPBottomLabelHeight = 0;
        int YSTopLabelHeight = 0;
        int YSBottomLabelHeight = 0;
        int anum = this.axes.size();
        if (this.axesVisible) {
            for (int i3 = 0; i3 < anum; ++i3) {
                AbstractAxis a = (AbstractAxis)this.axes.get(i3);
                VRectAxis ra = (VRectAxis)a;
                if (ra.getVTKAxis() == null) continue;
                ra.setInitialFitting(this.initialFitting);
                if (ra.getDimension() == 1) {
                    if (ra.getPrimary() && ra.isSecondary()) {
                        mirrorX = true;
                    }
                    if (!ra.getPrimary() && ra.isSecondary()) {
                        mirrorX2 = true;
                    }
                    if (ra.getPrimary() && this.origin_py || !ra.getPrimary() && this.origin_sy) {
                        ra.setStartOffset(0.0);
                        ra.setEndOffset(0.0);
                        ra.getVTKAxis().setFitAlgorithm(new String[]{"thin"});
                    }
                } else if (ra.getDimension() == 2) {
                    if (ra.getPrimary() && ra.isSecondary()) {
                        mirrorY = true;
                    }
                    if (!ra.getPrimary() && ra.isSecondary()) {
                        mirrorY2 = true;
                    }
                    if (ra.getPrimary() && this.origin_px || !ra.getPrimary() && this.origin_sx) {
                        ra.setStartOffset(0.0);
                        ra.setEndOffset(0.0);
                        ra.getVTKAxis().setFitAlgorithm(new String[]{"thin"});
                    }
                }
                boolean textAntialiased = this.channel.glIsEnabled(14);
                if (this.axisDisplayAntialiased) {
                    this.channel.glEnable(14);
                } else {
                    this.channel.glDisable(14);
                }
                ext = a.getExtent();
                Insets labelExt = ((VRectAxis)a).getLabelExtent();
                if (textAntialiased) {
                    this.channel.glEnable(14);
                } else {
                    this.channel.glDisable(14);
                }
                if (ext == null) continue;
                if (a.getDimension() == 1) {
                    if (ra.getPrimary()) {
                        XP = ext;
                        if (ra.getMinOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                            XPOffsets[0] = XP.left + VRectAxis.OFFSET_MARGIN;
                            XP.left = labelExt.left;
                        } else {
                            XP.left += labelExt.left;
                        }
                        if (ra.getMaxOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                            XPOffsets[1] = XP.right + VRectAxis.OFFSET_MARGIN;
                            XP.right = labelExt.right;
                        } else {
                            XP.right += labelExt.right;
                        }
                        if (ra.getComposite() != null) {
                            Insets in = ra.getComposite().getInnerMargin();
                            XPOffsets[0] = Math.max(XPOffsets[0], in.left);
                            XPOffsets[1] = Math.max(XPOffsets[1], in.right);
                        }
                        if (this.origin_py) {
                            int th = (int)ra.getTitleHeight(this.channel);
                            XP2.bottom = XP.bottom - th;
                            XP2.left = XP.left;
                            XP2.right = XP.right;
                            XP.bottom = th;
                            XP.left = 0;
                            XP.right = 0;
                            continue;
                        }
                        xLineWidth = ra.getAxisStyle().getLineWidth();
                        continue;
                    }
                    XS = ext;
                    if (ra.getMinOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                        XSOffsets[0] = XS.left + VRectAxis.OFFSET_MARGIN;
                        XS.left = labelExt.left;
                    } else {
                        XS.left += labelExt.left;
                    }
                    if (ra.getMaxOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                        XSOffsets[1] = XS.right + VRectAxis.OFFSET_MARGIN;
                        XS.right = labelExt.right;
                    } else {
                        XS.right += labelExt.right;
                    }
                    if (this.origin_sy) {
                        int th = (int)ra.getTitleHeight(this.channel);
                        XS2.top = XS.top - th;
                        XS2.left = XS.left;
                        XS2.right = XS.right;
                        XS.top = th;
                        XS.left = 0;
                        XS.right = 0;
                        continue;
                    }
                    x2LineWidth = ra.getAxisStyle().getLineWidth();
                    continue;
                }
                if (a.getDimension() != 2) continue;
                if (ra.getPrimary()) {
                    YP = ext;
                    if (ra.getMinOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                        YPOffsets[0] = YP.bottom + VRectAxis.OFFSET_MARGIN;
                        YP.bottom = labelExt.bottom;
                    } else {
                        YP.bottom += labelExt.bottom;
                    }
                    if (ra.getMaxOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                        YPOffsets[1] = YP.top + VRectAxis.OFFSET_MARGIN;
                        YP.top = labelExt.top;
                    } else {
                        YP.top += labelExt.top;
                    }
                    if (this.origin_px) {
                        int tw = (int)ra.getTitleWidth(this.channel);
                        YP2.left = YP.left - tw;
                        YP2.top = YP.top;
                        YP2.bottom = YP.bottom;
                        YP.left = tw;
                        YP.top = 0;
                        YP.bottom = 0;
                    } else {
                        yLineWidth = ra.getAxisStyle().getLineWidth();
                    }
                    if (ra.getLabelPosition() == 2) {
                        YPTopLabelHeight = labelExt.top;
                        continue;
                    }
                    if (ra.getLabelPosition() != 0) continue;
                    YPBottomLabelHeight = labelExt.bottom;
                    continue;
                }
                YS = ext;
                if (ra.getMinOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                    YSOffsets[0] = YS.bottom + VRectAxis.OFFSET_MARGIN;
                    YS.bottom = labelExt.bottom;
                } else {
                    YS.bottom += labelExt.bottom;
                }
                if (ra.getMaxOffsetBy() == VRectAxis.OFFSET_BY_TICKVALUES) {
                    YSOffsets[1] = YS.top + VRectAxis.OFFSET_MARGIN;
                    YS.top = labelExt.top;
                } else {
                    YS.top += labelExt.top;
                }
                if (this.origin_sx) {
                    int tw = (int)ra.getTitleWidth(this.channel);
                    YS2.right = YS.right - tw;
                    YS2.top = YS.top;
                    YS2.bottom = YS.bottom;
                    YS.right = tw;
                    YS.top = 0;
                    YS.bottom = 0;
                } else {
                    y2LineWidth = ra.getAxisStyle().getLineWidth();
                }
                if (ra.getLabelPosition() == 2) {
                    YSTopLabelHeight = labelExt.top;
                    continue;
                }
                if (ra.getLabelPosition() != 0) continue;
                YSBottomLabelHeight = labelExt.bottom;
            }
        }
        int topbase = 0;
        int bottombase = 0;
        int leftbase = 0;
        int rightbase = 0;
        int h = 0;
        boolean hasTop = false;
        boolean hasBottom = false;
        boolean hasLeft = false;
        boolean hasRight = false;
        this.overlayMargin.left = 0;
        this.overlayMargin.right = 0;
        this.overlayMargin.top = 0;
        this.overlayMargin.bottom = 0;
        OverlayInnerMargin prev_oim_L = null;
        OverlayInnerMargin prev_oim_R = null;
        OverlayInnerMargin prev_oim_T = null;
        OverlayInnerMargin prev_oim_B = null;
        ArrayList<Overlay> specialOverlays = null;
        int num = 0;
        for (i2 = 0; i2 < this.overlays.size(); ++i2) {
            o = (Overlay)this.overlays.get(i2);
            if (o.isInnerMarginOverlay()) {
                ++num;
                if (o.getOverlayJustification() == 1) {
                    oim = this.getOverlayInnerMargin(1, o);
                    if (oim == null) continue;
                    if (prev_oim_T == null) {
                        oim.setStartPosition(topbase);
                        topbase += oim.getPad().top;
                    } else if (oim == prev_oim_T) {
                        topbase += oim.getGutter();
                    } else if (oim != prev_oim_T) {
                        oim.setStartPosition(topbase += prev_oim_T.getPad().bottom);
                        topbase += oim.getPad().top;
                    }
                    h = o.getOverlayMargin();
                    o.setOverlayBase(topbase);
                    hasTop = true;
                    oim.setEndPosition((topbase += h) + oim.getPad().bottom);
                    this.overlayMargin.top = topbase + oim.getPad().bottom;
                    prev_oim_T = oim;
                } else if (o.getOverlayJustification() == 2) {
                    hasBottom = true;
                } else if (o.getOverlayJustification() == 3) {
                    oim = this.getOverlayInnerMargin(3, o);
                    if (oim == null) continue;
                    if (prev_oim_L == null) {
                        oim.setStartPosition(leftbase);
                        leftbase += oim.getPad().left;
                    } else if (oim == prev_oim_L) {
                        leftbase += oim.getGutter();
                    } else if (oim != prev_oim_L) {
                        oim.setStartPosition(leftbase += prev_oim_L.getPad().right);
                        leftbase += oim.getPad().left;
                    }
                    h = o.getOverlayMargin();
                    o.setOverlayBase(leftbase);
                    hasLeft = true;
                    oim.setEndPosition((leftbase += h) + oim.getPad().right);
                    this.overlayMargin.left = leftbase + oim.getPad().right;
                    prev_oim_L = oim;
                } else {
                    hasRight = true;
                }
            }
            if (!(o instanceof BarOverlay) && !(o instanceof HistogramOverlay) && (!(o instanceof ScatterOverlay) || ((ScatterOverlay)o).getPlotType() != 2)) continue;
            if (specialOverlays == null) {
                specialOverlays = new ArrayList<Overlay>();
            }
            specialOverlays.add(o);
        }
        if (hasBottom || hasRight) {
            for (i2 = this.overlays.size() - 1; i2 >= 0; --i2) {
                o = (Overlay)this.overlays.get(i2);
                if (!o.isInnerMarginOverlay()) continue;
                h = o.getOverlayMargin();
                if (o.getOverlayJustification() == 2) {
                    oim = this.getOverlayInnerMargin(2, o);
                    if (oim == null) continue;
                    if (prev_oim_B == null) {
                        oim.setStartPosition(bottombase);
                        bottombase += oim.getPad().bottom;
                    } else if (oim == prev_oim_B) {
                        bottombase += oim.getGutter();
                    } else if (oim != prev_oim_B) {
                        oim.setStartPosition(bottombase += prev_oim_B.getPad().top);
                        bottombase += oim.getPad().bottom;
                    }
                    o.setOverlayBase(bottombase);
                    oim.setEndPosition((bottombase += h) + oim.getPad().top);
                    this.overlayMargin.bottom = bottombase + oim.getPad().top;
                    prev_oim_B = oim;
                    continue;
                }
                if (o.getOverlayJustification() != 4 || (oim = this.getOverlayInnerMargin(4, o)) == null) continue;
                if (prev_oim_R == null) {
                    oim.setStartPosition(rightbase);
                    rightbase += oim.getPad().right;
                } else if (oim == prev_oim_R) {
                    rightbase += oim.getGutter();
                } else if (oim != prev_oim_R) {
                    oim.setStartPosition(rightbase += prev_oim_R.getPad().left);
                    rightbase += oim.getPad().right;
                }
                o.setOverlayBase(rightbase);
                oim.setEndPosition((rightbase += h) + oim.getPad().left);
                this.overlayMargin.right = rightbase + oim.getPad().left;
                prev_oim_R = oim;
            }
        }
        boolean bl = innerMarginOverlayOnly = num == this.overlays.size();
        if (!innerMarginOverlayOnly) {
            int pad = (int)Math.round(5.0 * StatGraph.getGapScaleFactor());
            if (prev_oim_T != null && prev_oim_T.isUseDefaultPad()) {
                prev_oim_T.setEndPosition(topbase + pad);
                this.overlayMargin.top = topbase + pad;
            }
            if (prev_oim_B != null && prev_oim_B.isUseDefaultPad()) {
                prev_oim_B.setEndPosition(bottombase + pad);
                this.overlayMargin.bottom = bottombase + pad;
            }
        }
        int gap = innerMarginOverlayOnly ? 0 : (int)Math.round(5.0 * StatGraph.getGapScaleFactor());
        gap = 0;
        if (hasTop) {
            this.overlayMargin.top += gap;
            YP.top = Math.max(0, YP.top - YPTopLabelHeight - this.overlayMargin.top) + YPTopLabelHeight;
            YS.top = Math.max(0, YS.top - YSTopLabelHeight - this.overlayMargin.top) + YSTopLabelHeight;
        }
        if (hasBottom) {
            this.overlayMargin.bottom += gap;
            YP.bottom = Math.max(0, YP.bottom - YPBottomLabelHeight - this.overlayMargin.bottom) + YPBottomLabelHeight;
            YS.bottom = Math.max(0, YS.bottom - YSBottomLabelHeight - this.overlayMargin.bottom) + YSBottomLabelHeight;
        }
        if (hasLeft) {
            this.overlayMargin.left += gap;
        }
        if (hasRight) {
            this.overlayMargin.right += gap;
        }
        for (i = 0; i < this.overlays.size(); ++i) {
            o = (Overlay)this.overlays.get(i);
            o.setTopReservedSpace(this.overlayMargin.top);
            o.setBottomReservedSpace(this.overlayMargin.bottom);
            o.setLeftReservedSpace(this.overlayMargin.left);
            o.setRightReservedSpace(this.overlayMargin.right);
        }
        for (i = 0; i < this.overlays.size(); ++i) {
            o = (Overlay)this.overlays.get(i);
            ext = o.getPreferredOuterMargin();
            XP.left = Math.max(XP.left, ext.left);
            XS.right = Math.max(XS.right, ext.right);
            YP.bottom = Math.max(YP.bottom, ext.bottom);
            YS.top = Math.max(YS.top, ext.top);
        }
        int top = Math.max(Math.max(XP.top, YP.top), Math.max(XS.top, YS.top));
        int left = Math.max(Math.max(XP.left, YP.left), Math.max(XS.left, YS.left));
        int bottom = Math.max(Math.max(XP.bottom, YP.bottom), Math.max(XS.bottom, YS.bottom));
        int right = Math.max(Math.max(XP.right, YP.right), Math.max(XS.right, YS.right));
        Insets oldOuter = this.prefOuter;
        Insets hashMargin = this.getBrokenAxisHashMargin();
        top = Math.max(top, hashMargin.top);
        left = Math.max(left, hashMargin.left);
        bottom = Math.max(bottom, hashMargin.bottom);
        right = Math.max(right, hashMargin.right);
        this.prefOuter = new Insets(top, left, bottom, right);
        if (this.initialFitting || this.isUpdateEncoderLimitsNeeded()) {
            this.updateEncoderLimits(this.prefOuter);
        }
        if (innerMarginOverlayOnly) {
            right = 0;
            left = 0;
            bottom = 0;
            top = 0;
        } else if (specialOverlays == null) {
            top = (int)Math.round(5.0 * StatGraph.getGapScaleFactor());
            bottom = 0;
            left = 0;
            right = top;
        } else {
            right = 0;
            left = 0;
            bottom = 0;
            top = 0;
            for (int i4 = 0; i4 < specialOverlays.size(); ++i4) {
                Insets I = ((Overlay)specialOverlays.get(i4)).getInitialInnerMargin();
                top = Math.max(top, I.top);
                bottom = Math.max(bottom, I.bottom);
                left = Math.max(left, I.left);
                right = Math.max(right, I.right);
            }
        }
        int top2 = top;
        int bottom2 = bottom;
        int left2 = left;
        int right2 = right;
        if (mirrorX || mirrorX2) {
            XPOffsets[0] = XSOffsets[0] = Math.max(XPOffsets[0], XSOffsets[0]);
            XPOffsets[1] = XSOffsets[1] = Math.max(XPOffsets[1], XSOffsets[1]);
        }
        if (mirrorY || mirrorY2) {
            YPOffsets[0] = YSOffsets[0] = Math.max(YPOffsets[0], YSOffsets[0]);
            YPOffsets[1] = YSOffsets[1] = Math.max(YPOffsets[1], YSOffsets[1]);
        }
        left = Math.max(left, XPOffsets[0]);
        right = Math.max(right, XPOffsets[1]);
        bottom = Math.max(bottom, YPOffsets[0]);
        top = Math.max(top, YPOffsets[1]);
        left2 = Math.max(left2, XSOffsets[0]);
        right2 = Math.max(right2, XSOffsets[1]);
        bottom2 = Math.max(bottom2, YSOffsets[0]);
        top2 = Math.max(top2, YSOffsets[1]);
        boolean hasX = false;
        boolean hasY = false;
        boolean hasX2 = false;
        boolean hasY2 = false;
        for (int i5 = 0; i5 < this.overlays.size(); ++i5) {
            boolean pxa;
            o = (Overlay)this.overlays.get(i5);
            VRectAxis xa = (VRectAxis)this.getAxis(o, (byte)1);
            VRectAxis ya = (VRectAxis)this.getAxis(o, (byte)2);
            boolean bl2 = xa.isSecondary() ? !xa.getPrimary() : (pxa = xa.getPrimary());
            boolean pya = ya.isSecondary() ? !ya.getPrimary() : ya.getPrimary();
            o.setInitialFitting(this.initialFitting);
            ext = o.getPreferredInnerMargin();
            if (pya) {
                top = Math.max(top, ext.top);
            } else {
                top2 = Math.max(top2, ext.top);
            }
            if (pya) {
                bottom = Math.max(bottom, ext.bottom);
            } else {
                bottom2 = Math.max(bottom2, ext.bottom);
            }
            if (pxa) {
                left = Math.max(left, ext.left);
            } else {
                left2 = Math.max(left2, ext.left);
            }
            if (pxa) {
                right = Math.max(right, ext.right);
            } else {
                right2 = Math.max(right2, ext.right);
            }
            if (pxa) {
                hasX = true;
            } else {
                hasX2 = true;
            }
            if (pya) {
                hasY = true;
                continue;
            }
            hasY2 = true;
        }
        this.prefPlotInner = new Insets(top, left, bottom, right);
        if (hasX && hasX2) {
            left = left2 = Math.max(left, left2);
            right = right2 = Math.max(right, right2);
        }
        if (hasY && hasY2) {
            top = top2 = Math.max(top, top2);
            bottom = bottom2 = Math.max(bottom, bottom2);
        }
        if ((oa = (VRectAxis)this.getAxis((byte)1, true)) != null && oa.getComposite() != null) {
            OverviewAxisComposite oac = oa.getComposite();
            oac.updateInnerMargin(new Insets(top, left, bottom, right));
        }
        double xStartOffset = Double.MAX_VALUE;
        double xEndOffset = Double.MAX_VALUE;
        double yStartOffset = Double.MAX_VALUE;
        double yEndOffset = Double.MAX_VALUE;
        double x2StartOffset = Double.MAX_VALUE;
        double x2EndOffset = Double.MAX_VALUE;
        double y2StartOffset = Double.MAX_VALUE;
        double y2EndOffset = Double.MAX_VALUE;
        for (int i6 = 0; i6 < anum; ++i6) {
            VRectAxis a = (VRectAxis)this.axes.get(i6);
            byte dim = a.getDimension();
            if (dim == 1) {
                if (a.getPrimary()) {
                    xStartOffset = Math.min(xStartOffset, a.getAbsStartOffset());
                    xEndOffset = Math.min(xEndOffset, a.getAbsEndOffset());
                    continue;
                }
                x2StartOffset = Math.min(x2StartOffset, a.getAbsStartOffset());
                x2EndOffset = Math.min(x2EndOffset, a.getAbsEndOffset());
                continue;
            }
            if (dim != 2) continue;
            if (a.getPrimary()) {
                yStartOffset = Math.min(yStartOffset, a.getAbsStartOffset());
                yEndOffset = Math.min(yEndOffset, a.getAbsEndOffset());
                continue;
            }
            y2StartOffset = Math.min(y2StartOffset, a.getAbsStartOffset());
            y2EndOffset = Math.min(y2EndOffset, a.getAbsEndOffset());
        }
        if (xStartOffset >= 0.0 && xStartOffset != Double.MAX_VALUE) {
            left = (int)xStartOffset;
        }
        if (xEndOffset >= 0.0 && xEndOffset != Double.MAX_VALUE) {
            right = (int)xEndOffset;
        }
        if (yStartOffset >= 0.0 && yStartOffset != Double.MAX_VALUE) {
            bottom = (int)yStartOffset;
        }
        if (yEndOffset >= 0.0 && yEndOffset != Double.MAX_VALUE) {
            top = (int)yEndOffset;
        }
        if (x2StartOffset >= 0.0 && x2StartOffset != Double.MAX_VALUE) {
            left2 = (int)x2StartOffset;
        }
        if (x2EndOffset >= 0.0 && x2EndOffset != Double.MAX_VALUE) {
            right2 = (int)x2EndOffset;
        }
        if (y2StartOffset >= 0.0 && y2StartOffset != Double.MAX_VALUE) {
            bottom2 = (int)y2StartOffset;
        }
        if (y2EndOffset >= 0.0 && y2EndOffset != Double.MAX_VALUE) {
            top2 = (int)y2EndOffset;
        }
        if (hasX && !hasX2 && mirrorX2) {
            left2 = left;
            right2 = right;
        }
        if (hasX2 && !hasX && mirrorX) {
            left = left2;
            right = right2;
        }
        if (hasY && !hasY2 && mirrorY2) {
            top2 = top;
            bottom2 = bottom;
        }
        if (hasY2 && !hasY && mirrorY) {
            top = top2;
            bottom = bottom2;
        }
        if (this.origin_py) {
            double ori_out = ((VRectAxis)axis_py).getOutputOrigin();
            ls2 = (int)Math.max((double)XP2.bottom - ori_out, 0.0);
            bottom = Math.max(bottom, ls2);
            left = Math.max(left, XP2.left);
            right = Math.max(right, XP2.right);
        }
        if (this.origin_px) {
            double ori_out = ((VRectAxis)axis_px).getOutputOrigin();
            ls2 = (int)Math.max((double)YP2.left - ori_out, 0.0);
            left = Math.max(left, ls2);
            top = Math.max(top, YP2.top);
            bottom = Math.max(bottom, YP2.bottom);
        }
        if (this.origin_sy) {
            double ori_out = ((VRectAxis)axis_sy).getOutputOrigin();
            PositionEncoder pe = (PositionEncoder)((VRectAxis)axis_sy).getEncoder((byte)2);
            len = pe.getOutputMax() - pe.getOutputMin();
            ls = (int)Math.max((double)XS2.top - (len - ori_out), 0.0);
            top2 = Math.max(top2, ls);
            left2 = Math.max(left2, XS2.left);
            right2 = Math.max(right2, XS2.right);
        }
        if (this.origin_sx) {
            double ori_out = ((VRectAxis)axis_sx).getOutputOrigin();
            PositionEncoder pe = (PositionEncoder)((VRectAxis)axis_sx).getEncoder((byte)1);
            len = pe.getOutputMax() - pe.getOutputMin();
            ls = (int)Math.max((double)YS2.right - (len - ori_out), 0.0);
            right2 = Math.max(right2, ls);
            top2 = Math.max(top2, YS2.top);
            bottom2 = Math.max(bottom2, YS2.bottom);
        }
        top += this.overlayMargin.top;
        bottom += this.overlayMargin.bottom;
        left += this.overlayMargin.left;
        right += this.overlayMargin.right;
        top2 += this.overlayMargin.top;
        bottom2 += this.overlayMargin.bottom;
        left2 += this.overlayMargin.left;
        right2 += this.overlayMargin.right;
        int widthW = 1;
        if (this.wall != null && this.wall.isEdgeOn()) {
            widthW = this.wall.getEdgeStyle().getWidth();
        }
        if (!innerMarginOverlayOnly) {
            top += Math.max(widthW, x2LineWidth) - 1;
            bottom += Math.max(widthW, xLineWidth) - 1;
            left += Math.max(widthW, yLineWidth) - 1;
            right += Math.max(widthW, y2LineWidth) - 1;
            top2 += Math.max(widthW, x2LineWidth) - 1;
            bottom2 += Math.max(widthW, xLineWidth) - 1;
            left2 += Math.max(widthW, yLineWidth) - 1;
            right2 += Math.max(widthW, y2LineWidth) - 1;
        }
        if (this.dynamic && this.userOffsetMin != null) {
            if (!Double.isNaN(this.userOffsetMin[0])) {
                left = (int)this.userOffsetMin[0];
            }
            if (!Double.isNaN(this.userOffsetMin[1])) {
                left2 = (int)this.userOffsetMin[1];
            }
            if (!Double.isNaN(this.userOffsetMin[2])) {
                bottom = (int)this.userOffsetMin[2];
            }
            if (!Double.isNaN(this.userOffsetMin[3])) {
                bottom2 = (int)this.userOffsetMin[3];
            }
        }
        if (this.dynamic && this.userOffsetMax != null) {
            if (!Double.isNaN(this.userOffsetMax[0])) {
                right = (int)this.userOffsetMax[0];
            }
            if (!Double.isNaN(this.userOffsetMax[1])) {
                right2 = (int)this.userOffsetMax[1];
            }
            if (!Double.isNaN(this.userOffsetMax[2])) {
                top = (int)this.userOffsetMax[2];
            }
            if (!Double.isNaN(this.userOffsetMax[3])) {
                top2 = (int)this.userOffsetMax[3];
            }
        }
        Insets oldInner = this.prefInner;
        this.prefInner = new Insets(top, left, bottom, right);
        Insets oldInner2 = this.prefInner2;
        this.prefInner2 = new Insets(top2, left2, bottom2, right2);
        if (this.ignoreMinorMarginIncrease) {
            int maxDec = 0;
            int diff = this.prefOuter.left - oldOuter.left;
            if (diff < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if ((diff = this.prefOuter.right - oldOuter.right) < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if ((diff = this.prefOuter.top - oldOuter.top) < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if ((diff = this.prefOuter.bottom - oldOuter.bottom) < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            int delta = 1;
            if (maxDec < 0 && maxDec >= -delta) {
                this.prefOuter = oldOuter;
            }
        } else {
            int maxDec = 0;
            int maxDec_p = 0;
            int diff = this.prefOuter.left - oldOuter.left;
            if (diff < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if (diff > 0) {
                maxDec_p = Math.max(maxDec_p, diff);
            }
            if ((diff = this.prefOuter.right - oldOuter.right) < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if (diff > 0) {
                maxDec_p = Math.max(maxDec_p, diff);
            }
            if ((diff = this.prefOuter.top - oldOuter.top) < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if (diff > 0) {
                maxDec_p = Math.max(maxDec_p, diff);
            }
            if ((diff = this.prefOuter.bottom - oldOuter.bottom) < 0) {
                maxDec = Math.min(maxDec, diff);
            }
            if (diff > 0) {
                maxDec_p = Math.max(maxDec_p, diff);
            }
            int delta = 1;
            if (maxDec < 0 && maxDec >= -delta && maxDec_p > 0 && maxDec_p <= delta) {
                this.prefOuter = oldOuter;
            }
        }
        if (!this.marginChangeListened || this.squareFormat == EQUATED_NONE) {
            if (!this.prefInner.equals(oldInner) || !this.prefInner2.equals(oldInner2)) {
                this.setInnerMargin(this.prefInner, this.prefInner2);
            }
            if (!this.prefOuter.equals(oldOuter)) {
                this.setOuterMargin(this.prefOuter);
            }
        }
    }

    private OverlayInnerMargin getOverlayInnerMargin(int align, Overlay o) {
        if (this.overlayInnerMargins == null) {
            return null;
        }
        OverlayInnerMargin oim = null;
        for (int i = 0; i < this.overlayInnerMargins.size(); ++i) {
            oim = (OverlayInnerMargin)this.overlayInnerMargins.get(i);
            if (oim.getAlignment() != align) continue;
            for (int j = 0; j < oim.getOverlays().size(); ++j) {
                if (oim.getOverlays().get(j) != o) continue;
                return oim;
            }
        }
        return oim;
    }

    private boolean isUpdateEncoderLimitsNeeded() {
        if (this.squareFormat != EQUATED_NONE || this.aspectRatio > 0.0) {
            return false;
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!(a.getUserStartOffset() >= 0.0) && !(a.getUserEndOffset() >= 0.0)) continue;
            return true;
        }
        return false;
    }

    private void updateEncoderLimits(Insets om) {
        int x0 = this.x + om.left;
        int y0 = this.y + om.top;
        int x2 = this.x + this.width - om.right;
        int y2 = this.y + this.height - om.bottom;
        x0 = Math.min(x0, x2);
        y0 = Math.min(y0, y2);
        int w = Math.max(0, x2 - x0);
        int h = Math.max(0, y2 - y0);
        int anum = this.axes.size();
        double lowerLim = 0.0;
        double upperLim = 0.0;
        for (int i = 0; i < anum; ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
            if (pe == null) continue;
            byte dim = a.getDimension();
            if (dim == 1) {
                if (a.getPrimary()) {
                    lowerLim = 0 - this.innerMargin.left;
                    upperLim = w - this.innerMargin.left;
                } else {
                    lowerLim = 0 - this.innerMargin2.left;
                    upperLim = w - this.innerMargin2.left;
                }
            } else if (dim == 2) {
                if (a.getPrimary()) {
                    lowerLim = 0 - this.innerMargin.bottom;
                    upperLim = h - this.innerMargin.bottom;
                } else {
                    lowerLim = 0 - this.innerMargin2.bottom;
                    upperLim = h - this.innerMargin2.bottom;
                }
            }
            pe.setLowerLimit(lowerLim);
            pe.setUpperLimit(upperLim);
        }
    }

    private void updateAxisSize() {
        if (this instanceof Simple3DOverlayComposite || this instanceof SimpleExtrudedOverlayComposite) {
            return;
        }
        if (!this.axesVisible) {
            return;
        }
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis va;
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            if (!a.isVisible() || !(a instanceof VRectAxis) || (va = (VRectAxis)a).getVTKAxis() == null || !va.getVTKAxis().getStyle().isTitleOn() && !va.getVTKAxis().getStyle().isLabelsOn()) continue;
            boolean primary = va.getPrimary();
            if (va.getDimension() == 1) {
                if (primary && !this.origin_py) {
                    va.getVTKAxis().setMaximumSize(new Vec3d((double)this.width * 1.25, (double)(this.outerMargin.bottom - 1), 1.0));
                    continue;
                }
                if (primary || this.origin_sy) continue;
                va.getVTKAxis().setMaximumSize(new Vec3d((double)this.width * 1.25, (double)(this.outerMargin.top - 1), 1.0));
                continue;
            }
            if (primary && !this.origin_px) {
                va.getVTKAxis().setMaximumSize(new Vec3d((double)(this.outerMargin.left - 1), (double)this.height * 1.25, 1.0));
                continue;
            }
            if (primary || this.origin_sx) continue;
            va.getVTKAxis().setMaximumSize(new Vec3d((double)(this.outerMargin.right - 1), (double)this.height * 1.25, 1.0));
        }
    }

    protected void updateRegions() {
        VRectAxis oa;
        if (this.width < 0 || this.height < 0) {
            return;
        }
        if (this.outerRegion == null) {
            this.outerRegion = new Rectangle();
        }
        this.outerRegion.x = this.x + this.outerMargin.left;
        this.outerRegion.y = this.y + this.outerMargin.top;
        int bx2 = this.x + this.width;
        int by2 = this.y + this.height;
        if (this.outerRegion.x > bx2) {
            this.outerRegion.x = bx2;
        }
        if (this.outerRegion.y > by2) {
            this.outerRegion.y = by2;
        }
        int x2 = bx2 - this.outerMargin.right;
        int y2 = by2 - this.outerMargin.bottom;
        this.outerRegion.width = x2 - this.outerRegion.x;
        this.outerRegion.height = y2 - this.outerRegion.y;
        if (this.outerRegion.width < 0) {
            this.outerRegion.width = 0;
        }
        if (this.outerRegion.height < 0) {
            this.outerRegion.height = 0;
        }
        if ((oa = (VRectAxis)this.getAxis((byte)1, true)) != null && oa.getComposite() != null) {
            OverviewAxisComposite oac = oa.getComposite();
            oac.setBounds(this.x, this.outerRegion.y + this.outerRegion.height, this.width, (int)((double)this.height * oac.getSizeFactor()));
        }
        if (this.innerRegion == null) {
            this.innerRegion = new Rectangle();
        }
        if (this.innerMargin.left + this.innerMargin.right > this.outerRegion.width) {
            int left = (int)((double)this.outerRegion.width * (double)this.innerMargin.left / (double)(this.innerMargin.left + this.innerMargin.right));
            int right = (int)((double)this.outerRegion.width * (double)this.innerMargin.right / (double)(this.innerMargin.left + this.innerMargin.right));
            this.innerMargin.left = left;
            this.innerMargin.right = right;
        }
        if (this.innerMargin.top + this.innerMargin.bottom > this.outerRegion.height) {
            int top = (int)((double)this.outerRegion.height * (double)this.innerMargin.top / (double)(this.innerMargin.top + this.innerMargin.bottom));
            int bottom = (int)((double)this.outerRegion.height * (double)this.innerMargin.bottom / (double)(this.innerMargin.top + this.innerMargin.bottom));
            this.innerMargin.top = top;
            this.innerMargin.bottom = bottom;
        }
        this.innerRegion.x = this.outerRegion.x + this.innerMargin.left;
        this.innerRegion.y = this.outerRegion.y + this.innerMargin.top;
        int ox2 = this.outerRegion.x + this.outerRegion.width;
        int oy2 = this.outerRegion.y + this.outerRegion.height;
        if (this.innerRegion.x > ox2) {
            this.innerRegion.x = ox2;
        }
        if (this.innerRegion.y > oy2) {
            this.innerRegion.y = oy2;
        }
        x2 = ox2 - this.innerMargin.right;
        y2 = oy2 - this.innerMargin.bottom;
        this.innerRegion.width = x2 - this.innerRegion.x;
        this.innerRegion.height = y2 - this.innerRegion.y;
        if (this.innerRegion.width < 0) {
            this.innerRegion.width = 0;
        }
        if (this.innerRegion.height < 0) {
            this.innerRegion.height = 0;
        }
        this.innerRegion2.x = this.outerRegion.x + this.innerMargin2.left;
        this.innerRegion2.y = this.outerRegion.y + this.innerMargin2.top;
        x2 = ox2 - this.innerMargin2.right;
        y2 = oy2 - this.innerMargin2.bottom;
        this.innerRegion2.width = x2 - this.innerRegion2.x;
        this.innerRegion2.height = y2 - this.innerRegion2.y;
        if (this.innerRegion2.width < 0) {
            this.innerRegion2.width = 0;
        }
        if (this.innerRegion2.height < 0) {
            this.innerRegion2.height = 0;
        }
    }

    private void equateAxesInterval(boolean expandRange) {
        if (!this.initialFitting) {
            return;
        }
        DataRange rangeX = null;
        DataRange rangeY = null;
        AbstractAxis axisX = null;
        AbstractAxis axisY = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1 && ((VRectAxis)a).getPrimary()) {
                rangeX = a.getDataRange(dim);
                axisX = a;
                continue;
            }
            if (dim != 2) continue;
            if (this.squareFormatPrimary && ((VRectAxis)a).getPrimary()) {
                rangeY = a.getDataRange(dim);
                axisY = a;
                continue;
            }
            if (this.squareFormatPrimary || ((VRectAxis)a).getPrimary()) continue;
            rangeY = a.getDataRange(dim);
            axisY = a;
        }
        if (axisX == null || axisY == null) {
            return;
        }
        if (((VRectAxis)axisX).getTicks() != null || ((VRectAxis)axisY).getTicks() != null) {
            return;
        }
        if (rangeX instanceof ContinuousRange && rangeY instanceof ContinuousRange) {
            int i;
            ContinuousRange crX = (ContinuousRange)rangeX;
            ContinuousRange crY = (ContinuousRange)rangeY;
            double spanX = crX.getMax() - crX.getMin();
            double spanY = crY.getMax() - crY.getMin();
            if (spanX == 0.0 || spanY == 0.0) {
                return;
            }
            double unitX = (double)this.innerRegion.width / spanX;
            double unitY = (double)this.innerRegion.height / spanY;
            double unit = Math.min(unitX, unitY);
            double xRan = expandRange ? (double)this.innerRegion.width / unit : spanX;
            double yRan = expandRange ? (double)this.innerRegion.height / unit : spanY;
            double intervalX = ((VRectAxis)axisX).getMajorInterval().getSize();
            double intervalY = ((VRectAxis)axisY).getMajorInterval().getSize();
            double interval = Math.max(intervalX, intervalY);
            double interval2 = Math.min(intervalX, intervalY);
            int minIntvls = 2;
            if (xRan / interval < (double)minIntvls || yRan / interval < (double)minIntvls) {
                double ratio = interval / interval2;
                if (ratio == (double)((int)ratio)) {
                    while (ratio > 1.0) {
                        double intvl = interval2 * (ratio - 1.0);
                        if (xRan / intvl > (double)minIntvls && yRan / intvl > (double)minIntvls) {
                            interval = intvl;
                            break;
                        }
                        ratio -= 1.0;
                    }
                } else {
                    interval = interval2;
                }
            }
            int count = 100;
            double v = crX.getMin();
            for (i = 0; i < count; ++i) {
                v += interval;
            }
            if (v < crX.getMax()) {
                return;
            }
            v = crY.getMin();
            for (i = 0; i < count; ++i) {
                v += interval;
            }
            if (v < crY.getMax()) {
                return;
            }
            ((VRectAxis)axisX).getMajorInterval().setSize(interval);
            ((VRectAxis)axisY).getMajorInterval().setSize(interval);
            if (xRan != spanX || interval != intervalX || this.userTicks != null) {
                this.adjustAxisRange((VRectAxis)axisX, crX, xRan, interval, expandRange);
            }
            if (yRan != spanY || interval != intervalY || this.userTicks != null) {
                this.adjustAxisRange((VRectAxis)axisY, crY, yRan, interval, expandRange);
            }
        }
    }

    private void equateAxesRangeAndInterval() {
        if (!this.initialFitting) {
            return;
        }
        DataRange rangeX = null;
        DataRange rangeY = null;
        VRectAxis axisX = null;
        VRectAxis axisY = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1 && ((VRectAxis)a).getPrimary()) {
                rangeX = a.getDataRange(dim);
                axisX = (VRectAxis)a;
                continue;
            }
            if (dim != 2) continue;
            if (this.squareFormatPrimary && ((VRectAxis)a).getPrimary()) {
                rangeY = a.getDataRange(dim);
                axisY = (VRectAxis)a;
                continue;
            }
            if (this.squareFormatPrimary || ((VRectAxis)a).getPrimary()) continue;
            rangeY = a.getDataRange(dim);
            axisY = (VRectAxis)a;
        }
        if (axisX == null || axisY == null) {
            return;
        }
        if (axisX.getTicks() != null || axisY.getTicks() != null) {
            return;
        }
        if (rangeX instanceof ContinuousRange && rangeY instanceof ContinuousRange) {
            ContinuousRange crX = (ContinuousRange)rangeX;
            ContinuousRange crY = (ContinuousRange)rangeY;
            double spanX = crX.getMax() - crX.getMin();
            double spanY = crY.getMax() - crY.getMin();
            if (spanX == 0.0 || spanY == 0.0) {
                return;
            }
            double intervalX = axisX.getMajorInterval().getSize();
            double intervalY = axisY.getMajorInterval().getSize();
            if (spanX >= spanY) {
                double diffRan = spanX - spanY;
                double minY = crY.getMin() - diffRan * 0.5;
                double maxY = crY.getMax() + diffRan * 0.5;
                crY.setMin(minY);
                crY.setMax(maxY);
                double yRan = crY.getMax() - crY.getMin();
                axisY.getMajorInterval().setSize(intervalX);
                this.adjustAxisRange(axisY, crY, yRan, intervalX, true);
            } else {
                double diffRan = spanY - spanX;
                double minX = crX.getMin() - diffRan * 0.5;
                double maxX = crX.getMax() + diffRan * 0.5;
                crX.setMin(minX);
                crX.setMax(maxX);
                double xRan = crX.getMax() - crX.getMin();
                axisX.getMajorInterval().setSize(intervalY);
                this.adjustAxisRange(axisX, crX, xRan, intervalY, true);
            }
        }
    }

    private void adjustAxisRange(VRectAxis ax, ContinuousRange cr, double newRan, double intvl, boolean fixedRange) {
        double[] ticks;
        double max;
        double min;
        if (fixedRange) {
            double oldRan = cr.getMax() - cr.getMin();
            double diffRan = newRan - oldRan;
            min = cr.getMin() - diffRan * 0.5;
            max = cr.getMax() + diffRan * 0.5;
        } else {
            ContinuousRange ir = (ContinuousRange)ax.getInputDataRange();
            min = ir.getMin();
            max = ir.getMax();
        }
        double err = intvl * 1.0E-6;
        if (this.userTicks != null) {
            ticks = this.getAdjustedUserTicks(min, max);
        } else {
            double tv;
            double maxFac;
            double minFac = Math.floor(min / intvl);
            if (minFac == (maxFac = Math.ceil(max / intvl))) {
                minFac -= 1.0;
                maxFac += 1.0;
            }
            double low = minFac * intvl;
            ArrayList<Double> tl = new ArrayList<Double>();
            if (fixedRange) {
                for (tv = low; tv < min - err || min - tv >= ax.getStartCoverage() * intvl; tv += intvl) {
                }
                while (tv <= max + err && tv - max < ax.getEndCoverage() * intvl) {
                    tl.add(new Double(tv));
                    tv += intvl;
                }
            } else {
                while (min - tv >= ax.getStartCoverage() * intvl) {
                    tv += intvl;
                }
                min = Math.min(tv, min);
                while (tv - max < ax.getEndCoverage() * intvl) {
                    tl.add(new Double(tv));
                    tv += intvl;
                }
                max = Math.max(tv - intvl, max);
            }
            if (tl.size() > 100) {
                ticks = new double[]{(Double)tl.get(0), (Double)tl.get(tl.size() - 1)};
            } else {
                ticks = new double[tl.size()];
                for (int i = 0; i < tl.size(); ++i) {
                    ticks[i] = (Double)tl.get(i);
                }
            }
            ticks = NumericFormat.processValues((double[])ticks, (double)intvl);
        }
        ax.setTicks(ticks);
        cr.setMin(min);
        cr.setMax(max);
        PositionEncoder pe = (PositionEncoder)ax.getEncoder(ax.getDimension());
        ax.setEncoder(ax.getDimension(), pe);
        Vector glv = (Vector)this.A2GLV.get(ax);
        if (glv != null) {
            for (int j = 0; j < glv.size(); ++j) {
                VRectGridLines rgl = (VRectGridLines)glv.elementAt(j);
                rgl.setEncoder(pe);
                rgl.setTicks(ticks);
                rgl.setTickValuePriority(ax.getTickValuePriority());
            }
        }
        if (ax.getMirrorAxis() == null || ax.getMirrorAxis().getDataRange(ax.getMirrorAxis().getDimension()) == null) {
            return;
        }
        VRectAxis ax2 = ax.getMirrorAxis();
        ContinuousRange cr2 = (ContinuousRange)ax2.getDataRange(ax2.getDimension());
        cr2.setMin(min);
        cr2.setMax(max);
        ax2.setTicks(ticks);
        pe = (PositionEncoder)ax2.getEncoder(ax2.getDimension());
        ax2.setEncoder(ax.getDimension(), pe);
        glv = (Vector)this.A2GLV.get(ax);
        if (glv != null) {
            for (int j = 0; j < glv.size(); ++j) {
                VRectGridLines rgl = (VRectGridLines)glv.elementAt(j);
                rgl.setEncoder(pe);
                rgl.setTicks(ticks);
            }
        }
    }

    private double[] getAdjustedUserTicks(double min, double max) {
        int n = 0;
        for (int i = 0; i < this.userTicks.length; ++i) {
            if (!(this.userTicks[i] >= min) || !(this.userTicks[i] <= max)) continue;
            ++n;
        }
        double[] newTicks = new double[n];
        int idx = 0;
        for (int i = 0; i < this.userTicks.length; ++i) {
            if (!(this.userTicks[i] >= min) || !(this.userTicks[i] <= max)) continue;
            newTicks[idx++] = this.userTicks[i];
        }
        return newTicks;
    }

    private void resetAxesRange() {
        if (this.axes.size() > 1) {
            for (int i = 0; i < this.axes.size(); ++i) {
                byte dim;
                AbstractAxis a = (AbstractAxis)this.axes.get(i);
                if (!(a.getDataRange(dim = a.getDimension()) instanceof ContinuousRange)) continue;
                boolean reset = false;
                if (dim == 1 && ((VRectAxis)a).getPrimary()) {
                    if (((VRectAxis)a).getTicks() != null) {
                        reset = true;
                    }
                } else if (dim == 2) {
                    if (this.squareFormatPrimary && ((VRectAxis)a).getPrimary()) {
                        if (((VRectAxis)a).getTicks() != null) {
                            reset = true;
                        }
                    } else if (!this.squareFormatPrimary && !((VRectAxis)a).getPrimary() && ((VRectAxis)a).getTicks() != null) {
                        reset = true;
                    }
                }
                if (!reset) continue;
                ((VRectAxis)a).setTicks(null);
                Vector glv = (Vector)this.A2GLV.get(a);
                if (glv != null) {
                    for (int j = 0; j < glv.size(); ++j) {
                        VRectGridLines rgl = (VRectGridLines)glv.elementAt(j);
                        rgl.setTicks(null);
                    }
                }
                ContinuousRange ir = new ContinuousRange(a.getInputDataRange());
                a.setInputDataRange((DataRange)ir);
            }
        }
    }

    private void equateAxesRange() {
        if (!this.equateRanges) {
            return;
        }
        DataRange rangeX = null;
        DataRange rangeY = null;
        AbstractAxis axisX = null;
        AbstractAxis axisY = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1 && ((VRectAxis)a).getPrimary()) {
                rangeX = a.getInputDataRange();
                axisX = a;
                continue;
            }
            if (dim != 2) continue;
            if (this.squareFormatPrimary && ((VRectAxis)a).getPrimary()) {
                rangeY = a.getInputDataRange();
                axisY = a;
                continue;
            }
            if (this.squareFormatPrimary || ((VRectAxis)a).getPrimary()) continue;
            rangeY = a.getInputDataRange();
            axisY = a;
        }
        if (axisX == null || axisY == null) {
            return;
        }
        if (rangeX instanceof ContinuousRange && rangeY instanceof ContinuousRange) {
            ContinuousRange crX = (ContinuousRange)rangeX;
            ContinuousRange crY = (ContinuousRange)rangeY;
            double min = Math.min(crX.getMin(), crY.getMin());
            double max = Math.max(crX.getMax(), crY.getMax());
            double thresX1 = ((VRectAxis)axisX).getStartCoverage();
            double thresX2 = ((VRectAxis)axisX).getEndCoverage();
            double thresY1 = ((VRectAxis)axisY).getStartCoverage();
            double thresY2 = ((VRectAxis)axisY).getEndCoverage();
            double thresh1 = Math.max(thresX1, thresY1);
            double thresh2 = Math.max(thresX2, thresY2);
            int nt = Math.max(((VRectAxis)axisX).getNTicks(), ((VRectAxis)axisY).getNTicks());
            boolean I = ((VRectAxis)axisX).isIntegerTicks() || ((VRectAxis)axisY).isIntegerTicks();
            crX = new ContinuousRange((DataRange)crX);
            crX.setMin(min);
            crX.setMax(max);
            crY = new ContinuousRange((DataRange)crY);
            crY.setMin(min);
            crY.setMax(max);
            ((VRectAxis)axisX).setStartCoverage(thresh1);
            ((VRectAxis)axisX).setEndCoverage(thresh2);
            ((VRectAxis)axisX).setNTicks(nt);
            ((VRectAxis)axisX).setIntegerTicks(I);
            axisX.setInputDataRange((DataRange)crX);
            VRectAxis ax2 = ((VRectAxis)axisX).getMirrorAxis();
            if (ax2 != null) {
                ax2.setStartCoverage(thresh1);
                ax2.setEndCoverage(thresh2);
                ax2.setNTicks(nt);
                ax2.setIntegerTicks(I);
                ax2.setInputDataRange((DataRange)crX);
            }
            ((VRectAxis)axisY).setStartCoverage(thresh1);
            ((VRectAxis)axisY).setEndCoverage(thresh2);
            ((VRectAxis)axisY).setNTicks(nt);
            ((VRectAxis)axisY).setIntegerTicks(I);
            ((VRectAxis)axisY).setTicks(((VRectAxis)axisX).getTicks());
            axisY.setInputDataRange((DataRange)crY);
            ax2 = ((VRectAxis)axisY).getMirrorAxis();
            if (ax2 != null) {
                ax2.setStartCoverage(thresh1);
                ax2.setEndCoverage(thresh2);
                ax2.setNTicks(nt);
                ax2.setIntegerTicks(I);
                ax2.setTicks(((VRectAxis)axisY).getTicks());
                ax2.setInputDataRange((DataRange)crY);
            }
        }
        this.equateRanges = false;
    }

    public void resetMargins() {
        this.prefInner.top = 0;
        this.prefInner.left = 0;
        this.prefInner.bottom = 0;
        this.prefInner.right = 0;
        this.innerMargin.top = 0;
        this.innerMargin.left = 0;
        this.innerMargin.bottom = 0;
        this.innerMargin.right = 0;
        this.prefOuter.top = 0;
        this.prefOuter.left = 0;
        this.prefOuter.bottom = 0;
        this.prefOuter.right = 0;
        this.outerMargin.top = 0;
        this.outerMargin.left = 0;
        this.outerMargin.bottom = 0;
        this.outerMargin.right = 0;
        this.prefInner2.top = 0;
        this.prefInner2.left = 0;
        this.prefInner2.bottom = 0;
        this.prefInner2.right = 0;
        this.innerMargin2.top = 0;
        this.innerMargin2.left = 0;
        this.innerMargin2.bottom = 0;
        this.innerMargin2.right = 0;
    }

    private void adjustAspect() {
        DataRange rangeX = null;
        DataRange rangeY = null;
        AbstractAxis axisX = null;
        AbstractAxis axisY = null;
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1) {
                rangeX = a.getDataRange(dim);
                axisX = a;
                continue;
            }
            if (dim != 2) continue;
            if (this.squareFormatPrimary && ((VRectAxis)a).getPrimary()) {
                rangeY = a.getDataRange(dim);
                axisY = a;
                continue;
            }
            if (this.squareFormatPrimary || ((VRectAxis)a).getPrimary()) continue;
            rangeY = a.getDataRange(dim);
            axisY = a;
        }
        if (axisX == null || axisY == null) {
            return;
        }
        if (rangeX instanceof ContinuousRange && rangeY instanceof ContinuousRange) {
            int deltaYSize;
            int deltaXSize;
            ContinuousRange crX = (ContinuousRange)rangeX;
            ContinuousRange crY = (ContinuousRange)rangeY;
            double spanX = crX.getMax() - crX.getMin();
            double spanY = crY.getMax() - crY.getMin();
            if (spanX != 0.0 && spanY != 0.0) {
                double unitX = (double)this.innerRegion.width / spanX;
                double unitY = (double)this.innerRegion.height / spanY;
                double unit = Math.min(unitX, unitY);
                deltaXSize = (int)(unit * spanX) - this.innerRegion.width;
                deltaYSize = (int)(unit * spanY) - this.innerRegion.height;
            } else if (this.innerRegion.width < this.innerRegion.height) {
                deltaXSize = 0;
                deltaYSize = this.innerRegion.width - this.innerRegion.height;
            } else {
                deltaXSize = this.innerRegion.height - this.innerRegion.width;
                deltaYSize = 0;
            }
            this.innerRegion.x += -deltaXSize / 2;
            this.innerRegion.y += -deltaYSize / 2;
            this.innerRegion.width += deltaXSize;
            this.innerRegion.height += deltaYSize;
            this.innerRegion2.x += -deltaXSize / 2;
            this.innerRegion2.y += -deltaYSize / 2;
            this.innerRegion2.width += deltaXSize;
            this.innerRegion2.height += deltaYSize;
            this.outerRegion.x += -deltaXSize / 2;
            this.outerRegion.y += -deltaYSize / 2;
            this.outerRegion.width += deltaXSize;
            this.outerRegion.height += deltaYSize;
            this.outerMargin.left += -deltaXSize / 2;
            this.outerMargin.right -= deltaXSize / 2;
            this.outerMargin.top += -deltaYSize / 2;
            this.outerMargin.bottom -= deltaYSize / 2;
        }
    }

    private void setLabelPlacementOptions(PointLabelLayoutManager mgr) {
        mgr.setLabelVerbose(this.labelVerbose);
        mgr.setLabelDisplaceable(this.labelDisplaceable);
        mgr.setSALabeling(this.saLabeling);
        mgr.setSAWeightMap(this.saWeightMap);
        mgr.setSAMaxIterations(this.saMaxIterations);
        mgr.setSASeed(this.saSeed);
    }

    protected void initLabeling(Graphics g) {
        Overlay ov;
        int i;
        int left = Math.max(this.innerMargin.left, this.innerMargin2.left);
        int top = Math.max(this.innerMargin.top, this.innerMargin2.top);
        int bottom = Math.max(this.innerMargin.bottom, this.innerMargin2.bottom);
        int iw = Math.min(this.innerRegion.width, this.innerRegion2.width);
        int ih = Math.min(this.innerRegion.height, this.innerRegion2.height);
        Rectangle clipBounds = new Rectangle(-left, -bottom, this.outerRegion.width, this.outerRegion.height);
        for (i = 0; i < this.overlays.size(); ++i) {
            TimeSeriesOverlay timeSeries;
            Overlay line;
            CurveLabelLayout cl;
            ov = (Overlay)this.overlays.get(i);
            if (ov instanceof ScatterOverlay) {
                ScatterOverlay scat = (ScatterOverlay)ov;
                boolean needConnect = false;
                if (scat.isLabelVisible() && scat.isLabelCollisionAvoidance() || scat.isObstacle() || scat.isVertexLabelOn()) {
                    if (this.pmgr == null) {
                        this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                        this.setLabelPlacementOptions(this.pmgr);
                    }
                    scat.setPointLabelLayout(new PointLabelLayout());
                    this.pmgr.addLayout(scat.getPointLabelLayout());
                    needConnect = true;
                }
                if (scat.isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    cl = new CurveLabelLayout();
                    cl.setLocation(scat.getCurveLabelLocation());
                    cl.setPosition(scat.getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(scat.getCurveLabelStyle().getFont()));
                    scat.setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                    needConnect = true;
                }
                if (scat.isPointCurveLabeled()) {
                    if (this.isSALabeling()) {
                        if (this.pmgr == null) {
                            this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                            this.setLabelPlacementOptions(this.pmgr);
                        }
                        this.pcmgr = this.pmgr;
                        if (scat.getPointLabelLayout() != null) {
                            boolean dataLabeled;
                            boolean bl = dataLabeled = scat.isLabelVisible() && scat.isLabelCollisionAvoidance();
                            if (!dataLabeled) {
                                scat.setPointCurveLabelLayout(scat.getPointLabelLayout());
                            } else {
                                scat.setPointCurveLabelLayout(new PointLabelLayout());
                                this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                                needConnect = true;
                            }
                        } else {
                            scat.setPointCurveLabelLayout(new PointLabelLayout());
                            this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                            needConnect = true;
                        }
                    } else {
                        if (this.pcmgr == null) {
                            this.pcmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih, true);
                            this.setLabelPlacementOptions(this.pcmgr);
                        }
                        scat.setPointCurveLabelLayout(new PointLabelLayout());
                        this.pcmgr.addLayout(scat.getPointCurveLabelLayout());
                        needConnect = true;
                    }
                }
                if (!needConnect) continue;
                scat.connectNetwork();
                continue;
            }
            if (ov instanceof LineParmOverlay) {
                line = (LineParmOverlay)ov;
                Rectangle clipRect = new Rectangle(this.outerRegion.x + this.overlayMargin.left, this.outerRegion.y + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom);
                ((LineParmOverlay)line).setClipRect(clipRect);
                if (((LineParmOverlay)line).isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    cl = new CurveLabelLayout();
                    cl.setLocation(((LineParmOverlay)line).getCurveLabelLocation());
                    cl.setPosition(((LineParmOverlay)line).getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(((LineParmOverlay)line).getLabelStyle().getFont()));
                    ((LineParmOverlay)line).setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                }
                if (!((LineParmOverlay)line).isProtectedLine()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                line.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(line.getPointLabelLayout());
                continue;
            }
            if (ov instanceof ReferenceLineOverlay) {
                line = (ReferenceLineOverlay)ov;
                Rectangle clipRect = new Rectangle(this.outerRegion.x + this.overlayMargin.left, this.outerRegion.y + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom);
                ((ReferenceLineOverlay)line).setClipRect(clipRect);
                if (((ReferenceLineOverlay)line).isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    cl = new CurveLabelLayout();
                    cl.setLocation(((ReferenceLineOverlay)line).getCurveLabelLocation());
                    cl.setPosition(((ReferenceLineOverlay)line).getCurveLabelPosition());
                    cl.setFontMetrics(g.getFontMetrics(((ReferenceLineOverlay)line).getLabelStyle().getFont()));
                    ((ReferenceLineOverlay)line).setCurveLabelLayout(cl);
                    this.cmgr.addLayout(cl);
                }
                if (!((ReferenceLineOverlay)line).isProtectedLine()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                line.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(line.getPointLabelLayout());
                continue;
            }
            if (ov instanceof DropLineOverlay) {
                line = (DropLineOverlay)ov;
                if (!((DropLineOverlay)line).isProtectedLine()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                line.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(line.getPointLabelLayout());
                continue;
            }
            if (ov instanceof BandOverlay) {
                BandOverlay band = (BandOverlay)ov;
                if (band.isCurveLabeled()) {
                    if (this.cmgr == null) {
                        this.cmgr = new CurveLabelLayoutManager(clipBounds, new Rectangle(0, 0, iw, ih));
                    }
                    CurveLabelLayout cl2 = new CurveLabelLayout();
                    cl2.setLocation(band.getCurveLabelLocation());
                    cl2.setPosition(band.getCurveLabelPosition());
                    cl2.setFontMetrics(g.getFontMetrics(band.getCurveLabelStyle().getFont()));
                    band.setCurveLabelLayout(cl2);
                    this.cmgr.addLayout(cl2);
                    band.connectNetwork();
                }
                if (band.isPointCurveLabeled()) {
                    if (this.isSALabeling()) {
                        if (this.pmgr == null) {
                            this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                            this.setLabelPlacementOptions(this.pmgr);
                        }
                        this.pcmgr = this.pmgr;
                    } else if (this.pcmgr == null) {
                        this.pcmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih, true);
                        this.setLabelPlacementOptions(this.pcmgr);
                    }
                    band.setPointCurveLabelLayout(new PointLabelLayout());
                    this.pcmgr.addLayout(band.getPointCurveLabelLayout());
                    band.connectNetwork();
                }
                if (!band.isProtectedLine()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                band.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(band.getPointLabelLayout());
                band.connectNetwork();
                continue;
            }
            if (ov instanceof EllipseParmOverlay) {
                EllipseParmOverlay ellipse = (EllipseParmOverlay)ov;
                if (!ellipse.isProtectedLine()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                ellipse.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(ellipse.getPointLabelLayout());
                continue;
            }
            if (ov instanceof BarOverlay) {
                BarOverlay bar = (BarOverlay)ov;
                if (!bar.isDataLabeled()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                bar.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(bar.getPointLabelLayout());
                continue;
            }
            if (ov instanceof LineChartOverlay) {
                LineChartOverlay lineChart = (LineChartOverlay)ov;
                if (!lineChart.isVertexLabelOn()) continue;
                if (this.pmgr == null) {
                    this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                    this.setLabelPlacementOptions(this.pmgr);
                }
                lineChart.setPointLabelLayout(new PointLabelLayout());
                this.pmgr.addLayout(lineChart.getPointLabelLayout());
                lineChart.connectNetwork();
                continue;
            }
            if (!(ov instanceof TimeSeriesOverlay) || !(timeSeries = (TimeSeriesOverlay)ov).isAutoPointLabel()) continue;
            if (this.pmgr == null) {
                this.pmgr = new PointLabelLayoutManager(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
                this.setLabelPlacementOptions(this.pmgr);
            }
            timeSeries.setPointLabelLayout(new PointLabelLayout());
            this.pmgr.addLayout(timeSeries.getPointLabelLayout());
            timeSeries.connectNetwork();
        }
        if (this.cmgr != null) {
            this.cmgr.xRotated = this.xCLOverlapped;
            this.cmgr.x2Rotated = this.x2CLOverlapped;
        }
        if (this.pcmgr != null && this.pcmgr != this.pmgr) {
            this.pcmgr.setMaxHLabelShift(this.maxHLabelShift);
            this.pcmgr.setMaxVLabelShift(this.maxVLabelShift);
            this.pcmgr.setHLabelShiftDelta(0);
            this.pcmgr.setVLabelShiftDelta(this.vLabelShiftDelta);
            this.pcmgr.layoutReady = true;
            this.pcmgr.setDiagonalOffset(true);
        }
        if (this.pmgr != null) {
            this.pmgr.setMaxHLabelShift(this.maxHLabelShift);
            this.pmgr.setMaxVLabelShift(this.maxVLabelShift);
            this.pmgr.setHLabelShiftDelta(this.hLabelShiftDelta);
            this.pmgr.setVLabelShiftDelta(this.vLabelShiftDelta);
            switch (this.showPointLabels) {
                default: {
                    break;
                }
                case 1: {
                    this.showAllPointLabels();
                    break;
                }
                case 2: {
                    this.hideAllPointLabels();
                    break;
                }
                case 3: {
                    for (i = 0; i < this.getOverlays().size(); ++i) {
                        Overlay plot = (Overlay)this.getOverlays().get(i);
                        if (plot.getInitialHideLabelObs() == null) continue;
                        plot.hidePointLabels(plot.getInitialHideLabelObs());
                    }
                }
            }
            this.pmgr.layoutReady = true;
            if (this.brokenAxis) {
                this.pmgr.setFixedFont(true);
            }
        }
        if (this.cmgr != null) {
            this.cmgr.setInnerMargin(this.overlayMargin);
        }
        this.labelingInited = true;
        for (i = 0; i < this.overlays.size(); ++i) {
            ov = (Overlay)this.overlays.get(i);
            if (!ov.isCurveLabelSplit() || ov.getCurveLabelSplitJustify() == Overlay.SPLIT_JUSTIFY_AUTO) continue;
            ov.reconnect();
        }
    }

    public void populateDataPoints(LargestEmptyRectangle ler) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay ov = (Overlay)this.overlays.get(i);
            if (!(ov instanceof ScatterOverlay)) continue;
            ScatterOverlay scat = (ScatterOverlay)ov;
            scat.populateDataPoints(ler);
        }
    }

    protected void updateLabelingBounds() {
        int left = Math.max(this.innerMargin.left, this.innerMargin2.left);
        int top = Math.max(this.innerMargin.top, this.innerMargin2.top);
        int bottom = Math.max(this.innerMargin.bottom, this.innerMargin2.bottom);
        int iw = Math.min(this.innerRegion.width, this.innerRegion2.width);
        int ih = Math.min(this.innerRegion.height, this.innerRegion2.height);
        if (this.pmgr != null) {
            this.pmgr.updateClipBounds(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
        }
        if (this.cmgr != null) {
            Rectangle clipBounds = new Rectangle(-left, -bottom, this.outerRegion.width, this.outerRegion.height);
            this.cmgr.updateLabelBounds(clipBounds, new Rectangle(0, 0, iw, ih));
            this.cmgr.setInnerMargin(this.overlayMargin);
        }
        if (this.pcmgr != null) {
            this.pcmgr.updateClipBounds(new Rectangle(-left + this.overlayMargin.left, -top + this.overlayMargin.top, this.outerRegion.width - this.overlayMargin.left - this.overlayMargin.right, this.outerRegion.height - this.overlayMargin.top - this.overlayMargin.bottom), ih);
        }
    }

    public synchronized void drawParts(Graphics g) {
        Overlay o;
        int i;
        VRectGridLines rgl;
        int i2;
        Vector glv;
        VRectAxis vra;
        int j;
        if (this.channel == null) {
            return;
        }
        if (this.width < 0 || this.height < 0) {
            return;
        }
        if (!this.visible) {
            return;
        }
        if (!this.labelingInited) {
            this.initLabeling(g);
        } else {
            this.updateLabelingBounds();
        }
        boolean subpixel = this.channel.isSubpixelRendering();
        this.channel.setSubpixelRendering(this.subpixelRendering);
        if (StatGraph.VGF) {
            this.channel.setSVGRendering(true);
        }
        int xi1 = this.innerRegion.x;
        int yi1 = this.ymax - (this.innerRegion.y + this.innerRegion.height);
        int xo1 = this.outerRegion.x;
        int xo2 = this.outerRegion.x + this.outerRegion.width;
        int yo1 = this.ymax - (this.outerRegion.y + this.outerRegion.height);
        int yo2 = this.ymax - this.outerRegion.y;
        int xi2 = this.innerRegion2.x;
        int yi2 = this.ymax - (this.innerRegion2.y + this.innerRegion2.height);
        if (this.wall != null) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xo1, (double)yo1, 0.0);
            this.wall.drawFill(g);
            this.channel.glPopMatrix();
        }
        for (j = 0; j < this.axes.size(); ++j) {
            vra = (VRectAxis)this.axes.get(j);
            if (!vra.isGreenBarOn() || (glv = (Vector)this.A2GLV.get(vra)) == null) continue;
            if (!vra.getAxisStyle().isShowThinnedTicks()) {
                vra.updateGridLines(glv);
            }
            this.channel.glPushMatrix();
            if (vra.getPrimary()) {
                this.channel.glTranslate((double)xi1, (double)yi1, 0.0);
            } else {
                this.channel.glTranslate((double)xi2, (double)yi2, 0.0);
            }
            for (i2 = 0; i2 < glv.size(); ++i2) {
                rgl = (VRectGridLines)glv.get(i2);
                if (!rgl.isGreenBarOn()) continue;
                rgl.draw(g);
            }
            this.channel.glPopMatrix();
        }
        for (j = 0; j < this.axes.size(); ++j) {
            vra = (VRectAxis)this.axes.get(j);
            glv = (Vector)this.A2GLV.get(vra);
            if (glv == null) continue;
            if (!vra.getAxisStyle().isShowThinnedTicks() || vra.postFitRequired()) {
                vra.updateGridLines(glv);
            }
            this.channel.glPushMatrix();
            if (vra.getPrimary()) {
                this.channel.glTranslate((double)xi1, (double)yi1, 0.0);
            } else {
                this.channel.glTranslate((double)xi2, (double)yi2, 0.0);
            }
            for (i2 = 0; i2 < glv.size(); ++i2) {
                rgl = (VRectGridLines)glv.get(i2);
                if (rgl.isGreenBarOn() || !rgl.isVisible()) continue;
                rgl.setDrawMajorGrid(false);
                rgl.draw(g);
                rgl.setDrawMajorGrid(true);
            }
            this.channel.glPopMatrix();
        }
        for (j = 0; j < this.axes.size(); ++j) {
            vra = (VRectAxis)this.axes.get(j);
            glv = (Vector)this.A2GLV.get(vra);
            if (glv == null) continue;
            if (!vra.getAxisStyle().isShowThinnedTicks() || vra.postFitRequired()) {
                vra.updateGridLines(glv);
            }
            this.channel.glPushMatrix();
            if (vra.getPrimary()) {
                this.channel.glTranslate((double)xi1, (double)yi1, 0.0);
            } else {
                this.channel.glTranslate((double)xi2, (double)yi2, 0.0);
            }
            for (i2 = 0; i2 < glv.size(); ++i2) {
                rgl = (VRectGridLines)glv.get(i2);
                if (rgl.isGreenBarOn() || !rgl.isVisible()) continue;
                rgl.setDrawMinorGrid(false);
                rgl.draw(g);
                rgl.setDrawMinorGrid(true);
            }
            this.channel.glPopMatrix();
        }
        Shape save = g.getClip();
        if (!this.paintingMarker) {
            this.setClip(g);
        }
        if (StatGraph.VGF) {
            ((VGFGraphics2D)g).applyRectClip(true);
        }
        int onum = this.overlays.size();
        if (this.isSVGSelectionMode()) {
            this.channel.glRenderMode(3);
        }
        for (i = 0; i < onum; ++i) {
            boolean clipDataRegion;
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || o.isInnerMarginOverlay()) continue;
            o.beginDisableAA(this.channel);
            this.channel.glPushMatrix();
            this.translateOverlay(o);
            boolean ramViewNoExtend = o instanceof RangeAttrMapViewOverlay && !((RangeAttrMapViewOverlay)o).isExtend();
            boolean bl = clipDataRegion = o instanceof EllipseParmOverlay || ramViewNoExtend;
            if (this.isOverlayOnBrokenAxis(o)) {
                this.drawBrokenOverlay(g, o, save);
            } else if (clipDataRegion) {
                Shape oldClip = g.getClip();
                Rectangle r = this.getOverlayDataRegion(o);
                Rectangle r2 = save == null ? r : r.intersection(save.getBounds());
                g.setClip(r2);
                if (this.isSVGSelectionMode()) {
                    if (o.isTooltipEnabled()) {
                        o.select();
                    }
                } else {
                    o.draw(g);
                }
                g.setClip(oldClip);
            } else if (this.isSVGSelectionMode()) {
                if (o.isTooltipEnabled()) {
                    o.select();
                }
            } else {
                o.draw(g);
            }
            this.channel.glPopMatrix();
            o.endDisableAA(this.channel);
        }
        if (this.isSVGSelectionMode()) {
            this.channel.glRenderMode(0);
        }
        if (this.overlayInnerMargins != null) {
            g.setClip(save);
            this.drawInnerMarginWall(this.channel, xo1, yo1);
        }
        for (i = 0; i < onum; ++i) {
            o = (Overlay)this.overlays.get(i);
            if (!o.isVisible() || !o.isInnerMarginOverlay()) continue;
            o.beginDisableAA(this.channel);
            this.channel.glPushMatrix();
            this.translateOverlay(o);
            if (this.isOverlayOnBrokenAxis(o)) {
                this.drawBrokenOverlay(g, o, save);
            } else {
                Shape oldClip = g.getClip();
                Rectangle r = new Rectangle(this.outerRegion.x, this.outerRegion.y, this.outerRegion.width, this.outerRegion.height);
                Rectangle r2 = save == null ? r : r.intersection(save.getBounds());
                g.setClip(r2);
                o.draw(g);
                g.setClip(oldClip);
            }
            this.channel.glPopMatrix();
            o.endDisableAA(this.channel);
        }
        if (StatGraph.VGF) {
            ((VGFGraphics2D)g).applyRectClip(false);
        }
        if (this.channel.getBackbufferId() == -1) {
            this.channel.resetClip();
        } else {
            g.setClip(save);
        }
        if (this.wall != null) {
            this.channel.glPushMatrix();
            this.channel.glTranslate((double)xo1, (double)yo1, 0.0);
            this.wall.drawOutline(g);
            this.channel.glPopMatrix();
        }
        if (this.overlayInnerMargins != null) {
            this.drawInnerMarginSeparator(this.channel, xo1, yo1);
        }
        if (this.axesVisible) {
            int i3;
            boolean textAntialiased = this.channel.glIsEnabled(14);
            if (this.axisDisplayAntialiased) {
                this.channel.glEnable(14);
            } else {
                this.channel.glDisable(14);
            }
            for (i3 = 0; i3 < this.axes.size(); ++i3) {
                AbstractAxis a = (AbstractAxis)this.axes.get(i3);
                if (!a.isVisible() || ((VRectAxis)a).getBackground() == null) continue;
                boolean primary = true;
                if (a instanceof VRectAxis) {
                    primary = ((VRectAxis)a).getPrimary();
                }
                this.channel.glPushMatrix();
                if (a.getDimension() == 2) {
                    if (primary) {
                        if (this.origin_px) {
                            this.channel.glTranslate((double)xi1 + ((VRectAxis)this.getAxis((byte)1, true)).getOutputOrigin(), (double)yi1, 0.0);
                        } else {
                            this.channel.glTranslate((double)xo1, (double)yi1, 0.0);
                        }
                    } else if (this.origin_sx) {
                        this.channel.glTranslate((double)xi2 + ((VRectAxis)this.getAxis((byte)1, false)).getOutputOrigin(), (double)yi2, 0.0);
                    } else {
                        this.channel.glTranslate((double)xo2, (double)yi2, 0.0);
                    }
                } else if (a.getDimension() == 1) {
                    if (primary) {
                        if (this.origin_py) {
                            this.channel.glTranslate((double)xi1, (double)yi1 + ((VRectAxis)this.getAxis((byte)2, true)).getOutputOrigin(), 0.0);
                        } else {
                            this.channel.glTranslate((double)xi1, (double)yo1, 0.0);
                        }
                    } else if (this.origin_sy) {
                        this.channel.glTranslate((double)xi2, (double)yi2 + ((VRectAxis)this.getAxis((byte)2, false)).getOutputOrigin(), 0.0);
                    } else {
                        this.channel.glTranslate((double)xi2, (double)yo2, 0.0);
                    }
                }
                ((VRectAxis)a).drawBackground(g);
                this.channel.glPopMatrix();
            }
            for (i3 = 0; i3 < this.axes.size(); ++i3) {
                AbstractAxis a = (AbstractAxis)this.axes.get(i3);
                if (!a.isVisible()) continue;
                boolean drawInnerMarginCorner = a.getAxisStyle().isAxisLineOn() && ((VRectAxis)a).getAxisLineOffsetCoverage() == 1.0;
                boolean drawLine = a.getAxisStyle().isAxisLineOn() && a.getAxisStyle().getLineWidth() > 1;
                boolean labelOnly = false;
                boolean primary = true;
                if (a instanceof VRectAxis) {
                    primary = ((VRectAxis)a).getPrimary();
                }
                this.channel.glPushMatrix();
                if (a.getDimension() == 2) {
                    if (primary) {
                        if (this.origin_px) {
                            this.channel.glTranslate((double)xi1 + ((VRectAxis)this.getAxis((byte)1, true)).getOutputOrigin(), (double)yi1, 0.0);
                            labelOnly = true;
                        } else {
                            this.channel.glTranslate((double)xo1, (double)yi1, 0.0);
                        }
                    } else if (this.origin_sx) {
                        this.channel.glTranslate((double)xi2 + ((VRectAxis)this.getAxis((byte)1, false)).getOutputOrigin(), (double)yi2, 0.0);
                        labelOnly = true;
                    } else {
                        this.channel.glTranslate((double)xo2, (double)yi2, 0.0);
                    }
                } else if (a.getDimension() == 1) {
                    if (primary) {
                        if (this.origin_py) {
                            this.channel.glTranslate((double)xi1, (double)yi1 + ((VRectAxis)this.getAxis((byte)2, true)).getOutputOrigin(), 0.0);
                            labelOnly = true;
                        } else {
                            this.channel.glTranslate((double)xi1, (double)yo1, 0.0);
                        }
                    } else if (this.origin_sy) {
                        this.channel.glTranslate((double)xi2, (double)yi2 + ((VRectAxis)this.getAxis((byte)2, false)).getOutputOrigin(), 0.0);
                        labelOnly = true;
                    } else {
                        this.channel.glTranslate((double)xi2, (double)yo2, 0.0);
                    }
                }
                if (drawLine) {
                    this.drawAxisLine(this.channel, a, labelOnly);
                    a.getAxisStyle().setAxisLineOn(false);
                }
                if (labelOnly) {
                    ((VRectAxis)a).drawLabels(g);
                } else {
                    a.draw(g);
                }
                if (drawInnerMarginCorner && !labelOnly) {
                    this.drawInnerMarginCorner(this.channel, a);
                }
                this.channel.glPopMatrix();
                if (((VRectAxis)a).getComposite() != null) {
                    ((VRectAxis)a).getComposite().draw(g);
                }
                if (labelOnly) {
                    this.channel.glPushMatrix();
                    if (a.getDimension() == 2) {
                        if (primary) {
                            this.channel.glTranslate((double)xo1, (double)yi1, 0.0);
                        } else {
                            this.channel.glTranslate((double)xo2, (double)yi2, 0.0);
                        }
                    } else if (a.getDimension() == 1) {
                        if (primary) {
                            this.channel.glTranslate((double)xi1, (double)yo1, 0.0);
                        } else {
                            this.channel.glTranslate((double)xi2, (double)yo2, 0.0);
                        }
                    }
                    ((VRectAxis)a).drawTitle(g);
                    this.channel.glPopMatrix();
                }
                if (!drawLine) continue;
                a.getAxisStyle().setAxisLineOn(true);
            }
            if (textAntialiased) {
                this.channel.glEnable(14);
            } else {
                this.channel.glDisable(14);
            }
        }
        if (this.brokenAxis) {
            this.drawBrokenAxisBand(g, xo1, yo1 - 1, this.outerRegion.width + 1, this.outerRegion.height + 1);
            if (this.brokenAxisHash != 0) {
                this.drawBrokenAxisHash(g, xo1, yo1 - 1, this.outerRegion.width + 1, this.outerRegion.height + 1);
            }
        }
        if (this.curveLabelsOn) {
            for (int i4 = 0; i4 < onum; ++i4) {
                Overlay o2 = (Overlay)this.overlays.get(i4);
                if (!o2.isVisible()) continue;
                if (this.isOverlayOnBrokenAxis(o2)) {
                    if (o2 instanceof ReferenceLineOverlay) continue;
                    if (o2 instanceof ScatterOverlay) {
                        ((ScatterOverlay)o2).connectNetwork();
                    } else if (o2 instanceof BandOverlay) {
                        ((BandOverlay)o2).connectNetwork();
                    } else if (o2 instanceof LineParmOverlay) {
                        ((LineParmOverlay)o2).connectNetwork();
                    }
                }
                o2.beginDisableAA(this.channel);
                this.channel.glPushMatrix();
                this.translateOverlay(o2);
                o2.drawNoneClipped(g);
                this.channel.glPopMatrix();
                o2.endDisableAA(this.channel);
            }
        }
        this.channel.setSubpixelRendering(subpixel);
        if (StatGraph.VGF) {
            this.channel.setSVGRendering(false);
        }
    }

    private boolean isSVGSelectionMode() {
        return StatGraph.VGF && StatGraph.SVGSelectionMode;
    }

    private void drawAxisLine(Channel channel, AbstractAxis axis, boolean inside) {
        int lineWidth = axis.getAxisStyle().getLineWidth();
        Color color = axis.getAxisStyle().getAxisLineColor();
        int pattern = axis.getAxisStyle().getLineStipplePattern();
        int factor = axis.getAxisStyle().getLineStippleFactor();
        double axisLength = ((VRectAxis)axis).getVTKAxis().getLength();
        double lineOffset = ((VRectAxis)axis).getVTKAxis().getLineOffset();
        double dataLength = ((VRectAxis)axis).getVTKAxis().getDataLength();
        double offsetCoverage = ((VRectAxis)axis).getAxisLineOffsetCoverage();
        double endOffset = axisLength - dataLength + lineOffset;
        double ext1 = -lineOffset - -lineOffset * offsetCoverage;
        double ext2 = endOffset * offsetCoverage;
        axisLength = -lineOffset + dataLength + ext2;
        boolean subpixel = channel.isSubpixelRendering();
        if (!StatGraph.VGF) {
            channel.setSubpixelRendering(false);
        }
        if (inside) {
            if (axis.getDimension() == 1) {
                LineSegment.drawLineSegment((Channel)channel, (double)(lineOffset + ext1), (double)0.0, (double)0.0, (double)(axisLength + lineOffset), (double)0.0, (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            } else {
                LineSegment.drawLineSegment((Channel)channel, (double)0.0, (double)(lineOffset + ext1), (double)0.0, (double)0.0, (double)(axisLength + lineOffset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
        } else if (axis.getDimension() == 1) {
            if (((VRectAxis)axis).getPrimary()) {
                int offset = (lineWidth - 1) / 2;
                LineSegment.drawLineSegment((Channel)channel, (double)(lineOffset + ext1), (double)offset, (double)0.0, (double)(axisLength + lineOffset), (double)offset, (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            } else {
                int offset = lineWidth / 2;
                LineSegment.drawLineSegment((Channel)channel, (double)(lineOffset + ext1), (double)(-offset), (double)0.0, (double)(axisLength + lineOffset), (double)(-offset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
        } else if (((VRectAxis)axis).getPrimary()) {
            int offset = lineWidth / 2;
            LineSegment.drawLineSegment((Channel)channel, (double)offset, (double)(lineOffset + ext1), (double)0.0, (double)offset, (double)(axisLength + lineOffset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
        } else {
            int offset = (lineWidth - 1) / 2;
            LineSegment.drawLineSegment((Channel)channel, (double)(-offset), (double)(lineOffset + ext1), (double)0.0, (double)(-offset), (double)(axisLength + lineOffset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
        }
        channel.setSubpixelRendering(subpixel);
    }

    private void drawInnerMarginWall(Channel channel, int xo1, int yo1) {
        boolean subpixel = channel.isSubpixelRendering();
        if (!StatGraph.VGF) {
            channel.setSubpixelRendering(false);
        }
        for (int i = 0; i < this.overlayInnerMargins.size(); ++i) {
            OverlayInnerMargin oim = (OverlayInnerMargin)this.overlayInnerMargins.get(i);
            if (!oim.isOpaque()) continue;
            channel.glPushMatrix();
            channel.glPolygonMode(3);
            channel.glColor(oim.getBackground() == null ? this.wall.getFillStyle().getColor() : oim.getBackground());
            double start = oim.getStartPosition();
            double end = oim.getEndPosition();
            double size = end - start - 1.0;
            switch (oim.getAlignment()) {
                case 1: {
                    channel.glTranslate((double)(xo1 + this.innerMarginBorder.left), (double)(yo1 + this.outerRegion.height) - end + 1.0, 0.0);
                    channel.glRect(0.0, 0.0, (double)(this.outerRegion.width - this.innerMarginBorder.left - this.innerMarginBorder.right), size);
                    break;
                }
                case 2: {
                    channel.glTranslate((double)(xo1 + this.innerMarginBorder.left), (double)yo1 + start, 0.0);
                    channel.glRect(0.0, 0.0, (double)(this.outerRegion.width - this.innerMarginBorder.left - this.innerMarginBorder.right), size);
                    break;
                }
                case 3: {
                    channel.glTranslate((double)xo1 + start, (double)(yo1 + this.innerMarginBorder.bottom), 0.0);
                    channel.glRect(0.0, 0.0, size, (double)(this.outerRegion.height - this.innerMarginBorder.top - this.innerMarginBorder.bottom));
                    break;
                }
                case 4: {
                    channel.glTranslate((double)(xo1 + this.outerRegion.width) - end + 1.0, (double)(yo1 + this.innerMarginBorder.bottom), 0.0);
                    channel.glRect(0.0, 0.0, size, (double)(this.outerRegion.height - this.innerMarginBorder.top - this.innerMarginBorder.bottom));
                }
            }
            channel.glPopMatrix();
        }
        channel.setSubpixelRendering(subpixel);
    }

    private void drawInnerMarginSeparator(Channel channel, int xo1, int yo1) {
        boolean subpixel = channel.isSubpixelRendering();
        if (!StatGraph.VGF) {
            channel.setSubpixelRendering(false);
        }
        channel.glPushMatrix();
        channel.glTranslate((double)xo1, (double)yo1, 0.0);
        block6: for (int i = 0; i < this.overlayInnerMargins.size(); ++i) {
            OverlayInnerMargin oim = (OverlayInnerMargin)this.overlayInnerMargins.get(i);
            if (!oim.isSeparatorOn()) continue;
            Color color = oim.getSeparatorAttrs().getColor();
            double lw = oim.getSeparatorAttrs().getWidth();
            int stipplePat = oim.getSeparatorAttrs().getStipplePattern();
            int stippleFac = oim.getSeparatorAttrs().getStippleFactor();
            double end = oim.getEndPosition();
            double[] offset = new double[2];
            switch (oim.getAlignment()) {
                case 1: {
                    offset = this.getSeparatorOffsets((VRectAxis)this.getAxis((byte)1, false));
                    LineSegment.drawLineSegment((Channel)channel, (double)((double)this.innerMarginBorder.left + offset[0]), (double)((double)this.outerRegion.height - end), (double)0.0, (double)((double)(this.outerRegion.width - this.innerMarginBorder.right) - offset[1]), (double)((double)this.outerRegion.height - end), (double)0.0, (Color)color, (double)lw, (int)stipplePat, (int)stippleFac);
                    continue block6;
                }
                case 2: {
                    offset = this.getSeparatorOffsets((VRectAxis)this.getAxis((byte)1, true));
                    LineSegment.drawLineSegment((Channel)channel, (double)((double)this.innerMarginBorder.left + offset[0]), (double)end, (double)0.0, (double)((double)(this.outerRegion.width - this.innerMarginBorder.right) - offset[1]), (double)end, (double)0.0, (Color)color, (double)lw, (int)stipplePat, (int)stippleFac);
                    continue block6;
                }
                case 3: {
                    offset = this.getSeparatorOffsets((VRectAxis)this.getAxis((byte)2, true));
                    LineSegment.drawLineSegment((Channel)channel, (double)end, (double)((double)this.innerMarginBorder.bottom + offset[0]), (double)0.0, (double)end, (double)((double)(this.outerRegion.height - this.innerMarginBorder.top) - offset[1]), (double)0.0, (Color)color, (double)lw, (int)stipplePat, (int)stippleFac);
                    continue block6;
                }
                case 4: {
                    offset = this.getSeparatorOffsets((VRectAxis)this.getAxis((byte)2, false));
                    LineSegment.drawLineSegment((Channel)channel, (double)((double)this.outerRegion.width - end), (double)((double)this.innerMarginBorder.bottom + offset[0]), (double)0.0, (double)((double)this.outerRegion.width - end), (double)((double)(this.outerRegion.height - this.innerMarginBorder.top) - offset[1]), (double)0.0, (Color)color, (double)lw, (int)stipplePat, (int)stippleFac);
                }
            }
        }
        channel.glPopMatrix();
        channel.setSubpixelRendering(subpixel);
    }

    private double[] getSeparatorOffsets(VRectAxis axis) {
        if (axis == null) {
            return new double[]{0.0, 0.0};
        }
        double axisLength = axis.getVTKAxis().getLength();
        double lineOffset = -axis.getVTKAxis().getLineOffset();
        double dataLength = axis.getVTKAxis().getDataLength();
        double offsetCoverage = axis.getAxisLineOffsetCoverage();
        double endOffset = axisLength - dataLength - lineOffset;
        double ext1 = lineOffset - lineOffset * offsetCoverage;
        double ext2 = endOffset - endOffset * offsetCoverage;
        return new double[]{ext1, ext2};
    }

    private void drawInnerMarginCorner(Channel channel, AbstractAxis axis) {
        int lineWidth = axis.getAxisStyle().getLineWidth();
        Color color = axis.getAxisStyle().getAxisLineColor();
        int pattern = axis.getAxisStyle().getLineStipplePattern();
        int factor = axis.getAxisStyle().getLineStippleFactor();
        double axisLength = ((VRectAxis)axis).getVTKAxis().getLength();
        double lineOffset = ((VRectAxis)axis).getVTKAxis().getLineOffset();
        boolean subpixel = channel.isSubpixelRendering();
        if (!StatGraph.VGF) {
            channel.setSubpixelRendering(false);
        }
        if (axis.getDimension() == 1) {
            if (((VRectAxis)axis).getPrimary()) {
                int offset = (lineWidth - 1) / 2;
                if (this.overlayMargin.left != 0) {
                    LineSegment.drawLineSegment((Channel)channel, (double)(lineOffset + 1.0), (double)offset, (double)0.0, (double)(lineOffset - (double)this.overlayMargin.left), (double)offset, (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
                }
                if (this.overlayMargin.right != 0) {
                    LineSegment.drawLineSegment((Channel)channel, (double)(axisLength + lineOffset + (double)this.overlayMargin.right), (double)offset, (double)0.0, (double)(axisLength + lineOffset - 1.0), (double)offset, (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
                }
            } else {
                int offset = lineWidth / 2;
                if (this.overlayMargin.left != 0) {
                    LineSegment.drawLineSegment((Channel)channel, (double)(lineOffset + 1.0), (double)(-offset), (double)0.0, (double)(lineOffset - (double)this.overlayMargin.left), (double)(-offset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
                }
                if (this.overlayMargin.right != 0) {
                    LineSegment.drawLineSegment((Channel)channel, (double)(axisLength + lineOffset + (double)this.overlayMargin.right), (double)(-offset), (double)0.0, (double)(axisLength + lineOffset - 1.0), (double)(-offset), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
                }
            }
        } else if (((VRectAxis)axis).getPrimary()) {
            int offset = lineWidth / 2;
            if (this.overlayMargin.bottom != 0) {
                LineSegment.drawLineSegment((Channel)channel, (double)offset, (double)(lineOffset + 1.0), (double)0.0, (double)offset, (double)(lineOffset - (double)this.overlayMargin.bottom), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
            if (this.overlayMargin.top != 0) {
                LineSegment.drawLineSegment((Channel)channel, (double)offset, (double)(axisLength + lineOffset + (double)this.overlayMargin.top), (double)0.0, (double)offset, (double)(axisLength + lineOffset - 1.0), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
        } else {
            int offset = (lineWidth - 1) / 2;
            if (this.overlayMargin.bottom != 0) {
                LineSegment.drawLineSegment((Channel)channel, (double)(-offset), (double)(lineOffset + 1.0), (double)0.0, (double)(-offset), (double)(lineOffset - (double)this.overlayMargin.bottom), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
            if (this.overlayMargin.top != 0) {
                LineSegment.drawLineSegment((Channel)channel, (double)(-offset), (double)(axisLength + lineOffset + (double)this.overlayMargin.top), (double)0.0, (double)(-offset), (double)(axisLength + lineOffset - 1.0), (double)0.0, (Color)color, (double)lineWidth, (int)pattern, (int)factor);
            }
        }
        channel.setSubpixelRendering(subpixel);
    }

    private void translateOverlay(Overlay o) {
        int xi = this.innerRegion.x;
        int yi = this.ymax - (this.innerRegion.y + this.innerRegion.height);
        int xi2 = this.innerRegion2.x;
        int yi2 = this.ymax - (this.innerRegion2.y + this.innerRegion2.height);
        boolean pxa = ((VRectAxis)this.getAxis(o, (byte)1)).getPrimary();
        boolean pya = ((VRectAxis)this.getAxis(o, (byte)2)).getPrimary();
        if (pxa && pya) {
            this.channel.glTranslate((double)xi, (double)yi, 0.0);
        } else if (pxa && !pya) {
            this.channel.glTranslate((double)xi, (double)yi2, 0.0);
        } else if (!pxa && pya) {
            this.channel.glTranslate((double)xi2, (double)yi, 0.0);
        } else {
            this.channel.glTranslate((double)xi2, (double)yi2, 0.0);
        }
    }

    private Rectangle getOverlayDataRegion(Overlay o) {
        boolean px = ((VRectAxis)this.getAxis(o, (byte)1)).getPrimary();
        boolean py = ((VRectAxis)this.getAxis(o, (byte)2)).getPrimary();
        Rectangle r = px && py ? new Rectangle(this.innerRegion.x, this.innerRegion.y, this.innerRegion.width, this.innerRegion.height) : (px && !py ? new Rectangle(this.innerRegion.x, this.innerRegion2.y, this.innerRegion.width, this.innerRegion2.height) : (!px && py ? new Rectangle(this.innerRegion2.x, this.innerRegion.y, this.innerRegion2.width, this.innerRegion.height) : new Rectangle(this.innerRegion2.x, this.innerRegion2.y, this.innerRegion2.width, this.innerRegion2.height)));
        if (!(o instanceof RangeAttrMapViewOverlay)) {
            --r.x;
            --r.y;
            r.width += 2;
            r.height += 2;
        }
        return r;
    }

    private void setClip(Graphics g) {
        Rectangle r2;
        Rectangle r = new Rectangle(this.outerRegion.x, this.outerRegion.y, this.outerRegion.width, this.outerRegion.height);
        Rectangle rectangle = r2 = g.getClipBounds() == null ? r : r.intersection(g.getClipBounds());
        if (this.channel.getBackbufferId() == -1) {
            this.channel.setClip(r2);
        } else {
            g.setClip(r2);
        }
    }

    private boolean isOverlayOnBrokenAxis(Overlay o) {
        VRectAxis ax = (VRectAxis)this.getAxis(o, (byte)1);
        VRectAxis ay = (VRectAxis)this.getAxis(o, (byte)2);
        return ax.isBrokenAxis() || ay.isBrokenAxis();
    }

    private void drawBrokenOverlay(Graphics g, Overlay o, Shape originalClip) {
        Shape newClip;
        int ii;
        GeneralPath path;
        int nPoints;
        int i;
        double[] s2;
        double[] s1;
        double[] d;
        int off;
        double[] yps;
        double[] xps;
        int np;
        ContinuousRangeToNumericMap[] maps;
        ValueMap map;
        BrokenPositionEncoder bpe;
        Shape oldClip = g.getClip();
        VRectAxis ax = (VRectAxis)this.getAxis(o, (byte)1);
        VRectAxis ay = (VRectAxis)this.getAxis(o, (byte)2);
        if (ay.isBrokenAxis()) {
            bpe = (BrokenPositionEncoder)ay.getEncoder((byte)2);
            map = bpe.getValueMap();
            maps = bpe.getRangeOutputMaps();
            np = this.brokenAxisHash == 0 ? MAX_CURVE_POINTS : 2;
            xps = new double[np];
            yps = new double[np];
            off = (int)(BrokenPositionEncoder.RESERVED_OFFSET + (double)BrokenPositionEncoder.BROKEN_GAP * 0.5);
            d = new double[3];
            s1 = new double[3];
            s2 = new double[3];
            for (i = 0; i < maps.length; ++i) {
                double ht;
                double y;
                boolean curveB = true;
                boolean curveT = true;
                d[2] = 0.0;
                d[0] = 0.0;
                if (maps.length == 1) {
                    y = this.outerRegion.y;
                    ht = this.outerRegion.height;
                    curveB = false;
                    curveT = false;
                } else if (i == 0) {
                    d[1] = maps[i].getOutputMax() + (double)off;
                    this.channel.gluProject(d, s1);
                    y = s1[1];
                    ht = (double)(this.outerRegion.y + this.outerRegion.height) - y;
                    curveB = false;
                } else if (i == maps.length - 1) {
                    d[1] = maps[i].getOutputMin() - (double)off;
                    this.channel.gluProject(d, s2);
                    y = this.outerRegion.y;
                    ht = s2[1] - y;
                    curveT = false;
                } else {
                    d[1] = maps[i].getOutputMax() + (double)off;
                    this.channel.gluProject(d, s1);
                    d[1] = maps[i].getOutputMin() - (double)off;
                    this.channel.gluProject(d, s2);
                    y = s1[1];
                    ht = s2[1] - s1[1];
                }
                if (curveT && curveB) {
                    nPoints = this.getCurvePoints(this.outerRegion.x, this.outerRegion.x + this.outerRegion.width, y, xps, yps, true, true);
                    path = new GeneralPath();
                    path.moveTo((double)this.outerRegion.x, y);
                    for (ii = 0; ii < nPoints; ++ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo((double)(this.outerRegion.x + this.outerRegion.width), y);
                    path.lineTo((double)(this.outerRegion.x + this.outerRegion.width), y + ht);
                    nPoints = this.getCurvePoints(this.outerRegion.x, this.outerRegion.x + this.outerRegion.width, y + ht, xps, yps, true, true);
                    for (ii = nPoints - 1; ii >= 0; --ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo((double)this.outerRegion.x, y + ht);
                    newClip = path;
                } else if (curveB) {
                    nPoints = this.getCurvePoints(this.outerRegion.x, this.outerRegion.x + this.outerRegion.width, y + ht, xps, yps, true, true);
                    path = new GeneralPath();
                    path.moveTo((double)this.outerRegion.x, y + ht);
                    for (ii = 0; ii < nPoints; ++ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo((double)(this.outerRegion.x + this.outerRegion.width), y + ht);
                    path.lineTo((double)(this.outerRegion.x + this.outerRegion.width), y);
                    path.lineTo((double)this.outerRegion.x, y);
                    newClip = path;
                } else if (curveT) {
                    nPoints = this.getCurvePoints(this.outerRegion.x, this.outerRegion.x + this.outerRegion.width, y, xps, yps, true, true);
                    path = new GeneralPath();
                    path.moveTo((double)this.outerRegion.x, y);
                    for (ii = 0; ii < nPoints; ++ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo((double)(this.outerRegion.x + this.outerRegion.width), y);
                    path.lineTo((double)(this.outerRegion.x + this.outerRegion.width), y + ht);
                    path.lineTo((double)this.outerRegion.x, y + ht);
                    newClip = path;
                } else {
                    newClip = new Rectangle2D.Double(this.outerRegion.x, y, this.outerRegion.width, ht);
                }
                g.setClip(newClip);
                bpe.setValueMap((ValueMap)maps[i]);
                bpe.setUpdateNeeded(false);
                o.reconnect();
                if (this.isSVGSelectionMode()) {
                    if (o.isTooltipEnabled()) {
                        o.select();
                    }
                } else {
                    o.draw(g);
                }
                if (!(o instanceof ReferenceLineOverlay) && !(o instanceof BarOverlay) || !this.curveLabelsOn) continue;
                g.setClip(originalClip);
                o.drawNoneClipped(g);
            }
            bpe.setValueMap(map);
            bpe.setUpdateNeeded(true);
        }
        if (ax.isBrokenAxis()) {
            bpe = (BrokenPositionEncoder)ax.getEncoder((byte)1);
            map = bpe.getValueMap();
            maps = bpe.getRangeOutputMaps();
            np = this.brokenAxisHash == 0 ? MAX_CURVE_POINTS : 2;
            xps = new double[np];
            yps = new double[np];
            off = (int)(BrokenPositionEncoder.RESERVED_OFFSET + (double)BrokenPositionEncoder.BROKEN_GAP * 0.5);
            d = new double[3];
            s1 = new double[3];
            s2 = new double[3];
            for (i = 0; i < maps.length; ++i) {
                double wt;
                double x;
                boolean curveR = true;
                boolean curveL = true;
                d[2] = 0.0;
                d[1] = 0.0;
                if (maps.length == 1) {
                    x = this.outerRegion.x;
                    wt = this.outerRegion.width;
                    curveL = false;
                    curveR = false;
                } else if (i == 0) {
                    d[0] = maps[i].getOutputMax() + (double)off;
                    this.channel.gluProject(d, s2);
                    x = this.outerRegion.x;
                    wt = s2[0] - x;
                    curveL = false;
                } else if (i == maps.length - 1) {
                    d[0] = maps[i].getOutputMin() - (double)off;
                    this.channel.gluProject(d, s1);
                    x = s1[0];
                    wt = (double)(this.outerRegion.x + this.outerRegion.width) - x;
                    curveR = false;
                } else {
                    d[0] = maps[i].getOutputMin() - (double)off;
                    this.channel.gluProject(d, s1);
                    d[0] = maps[i].getOutputMax() + (double)off;
                    this.channel.gluProject(d, s2);
                    x = s1[0];
                    wt = s2[0] - s1[0];
                }
                if (curveL && curveR) {
                    nPoints = this.getCurvePoints(this.outerRegion.y, this.outerRegion.y + this.outerRegion.height, x, xps, yps, false, true);
                    path = new GeneralPath();
                    path.moveTo(x, (double)this.outerRegion.y);
                    for (ii = 0; ii < nPoints; ++ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo(x, (double)(this.outerRegion.y + this.outerRegion.height));
                    path.lineTo(x + wt, (double)(this.outerRegion.y + this.outerRegion.height));
                    nPoints = this.getCurvePoints(this.outerRegion.y, this.outerRegion.y + this.outerRegion.height, x + wt, xps, yps, false, true);
                    for (ii = nPoints - 1; ii >= 0; --ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo(x + wt, (double)this.outerRegion.y);
                    newClip = path;
                } else if (curveR) {
                    nPoints = this.getCurvePoints(this.outerRegion.y, this.outerRegion.y + this.outerRegion.height, x + wt, xps, yps, false, true);
                    path = new GeneralPath();
                    path.moveTo(x + wt, (double)this.outerRegion.y);
                    for (ii = 0; ii < nPoints; ++ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo(x + wt, (double)(this.outerRegion.y + this.outerRegion.height));
                    path.lineTo(x, (double)(this.outerRegion.y + this.outerRegion.height));
                    path.lineTo(x, (double)this.outerRegion.y);
                    newClip = path;
                } else if (curveL) {
                    nPoints = this.getCurvePoints(this.outerRegion.y, this.outerRegion.y + this.outerRegion.height, x, xps, yps, false, true);
                    path = new GeneralPath();
                    path.moveTo(x, (double)this.outerRegion.y);
                    for (ii = 0; ii < nPoints; ++ii) {
                        path.lineTo(xps[ii], yps[ii]);
                    }
                    path.lineTo(x, (double)(this.outerRegion.y + this.outerRegion.height));
                    path.lineTo(x + wt, (double)(this.outerRegion.y + this.outerRegion.height));
                    path.lineTo(x + wt, (double)this.outerRegion.y);
                    newClip = path;
                } else {
                    newClip = new Rectangle2D.Double(x, this.outerRegion.y, wt, this.outerRegion.height);
                }
                g.setClip(newClip);
                bpe.setValueMap((ValueMap)maps[i]);
                bpe.setUpdateNeeded(false);
                o.reconnect();
                if (this.isSVGSelectionMode()) {
                    if (o.isTooltipEnabled()) {
                        o.select();
                    }
                } else {
                    o.draw(g);
                }
                if (!(o instanceof ReferenceLineOverlay) && !(o instanceof BarOverlay) || !this.curveLabelsOn) continue;
                g.setClip(originalClip);
                o.drawNoneClipped(g);
            }
            bpe.setValueMap(map);
            bpe.setUpdateNeeded(true);
        }
        g.setClip(oldClip);
    }

    private void drawBrokenAxisBand(Graphics g, double xo, double yo, double width, double height) {
        int edgeWidth = (int)Math.ceil(StatGraph.dataDPIScaleFactor);
        int edgePattern = SASLinePatterns.getStipplePattern((int)1);
        int edgeFactor = SASLinePatterns.getStippleFactor((int)1);
        int nPoints = this.brokenAxisHash == 0 ? MAX_CURVE_POINTS : 2;
        for (int i = 0; i < this.axes.size(); ++i) {
            boolean subpixel;
            int ii;
            double off;
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!a.isBrokenAxis()) continue;
            this.channel.glPushMatrix();
            Color edgeColor = a.getAxisStyle().getAxisLineColor();
            ContinuousRangeToNumericMap[] segmentMaps = ((BrokenPositionEncoder)a.getEncoder(a.getDimension())).getRangeOutputMaps();
            double startOffset = -a.getStartOffset();
            if (a.getDimension() == 2) {
                if (this.innerMarginBorder != null) {
                    this.channel.glTranslate(xo, yo + (double)this.innerMarginBorder.bottom, 0.0);
                } else {
                    this.channel.glTranslate(xo, yo, 0.0);
                }
                double[] xpsB = new double[nPoints];
                double[] ypsB = new double[nPoints];
                double[] xpsT = new double[nPoints];
                double[] ypsT = new double[nPoints];
                int nPointsB = 0;
                int nPointsT = 0;
                off = BrokenPositionEncoder.RESERVED_OFFSET;
                for (ii = 0; ii < segmentMaps.length; ++ii) {
                    double y1 = segmentMaps[ii].getOutputMin() - startOffset - off;
                    double y2 = segmentMaps[ii].getOutputMax() - startOffset + off;
                    boolean curveB = true;
                    boolean curveT = true;
                    if (ii == 0) {
                        curveB = false;
                    } else if (ii == segmentMaps.length - 1) {
                        curveT = false;
                    }
                    if (curveB) {
                        nPointsB = this.getCurvePoints(0.0, width, y1, xpsB, ypsB, true, false);
                        subpixel = this.channel.isSubpixelRendering();
                        this.channel.setSubpixelRendering(true);
                        PolylineSegment.drawPolylineBand((Channel)this.channel, (double[])xpsB, (double[])ypsB, (int)nPointsB, (double[])xpsT, (double[])ypsT, (int)nPointsT, (Color)this.brokenGapColor);
                        if (this.brokenAxisHash == 0) {
                            PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xpsB, (double[])ypsB, (int)nPointsB, (Color)edgeColor, (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xpsT, (double[])ypsT, (int)nPointsT, (Color)edgeColor, (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                        }
                        this.channel.setSubpixelRendering(subpixel);
                    }
                    if (!curveT) continue;
                    nPointsT = this.getCurvePoints(0.0, width, y2, xpsT, ypsT, true, false);
                }
            } else if (a.getDimension() == 1) {
                if (this.innerMarginBorder != null) {
                    this.channel.glTranslate(xo + (double)this.innerMarginBorder.left, yo, 0.0);
                } else {
                    this.channel.glTranslate(xo, yo, 0.0);
                }
                double[] xpsL = new double[nPoints];
                double[] ypsL = new double[nPoints];
                double[] xpsR = new double[nPoints];
                double[] ypsR = new double[nPoints];
                int nPointsL = 0;
                int nPointsR = 0;
                off = BrokenPositionEncoder.RESERVED_OFFSET;
                for (ii = 0; ii < segmentMaps.length; ++ii) {
                    double x1 = segmentMaps[ii].getOutputMin() - startOffset - off;
                    double x2 = segmentMaps[ii].getOutputMax() - startOffset + off;
                    boolean curveR = true;
                    boolean curveL = true;
                    if (ii == 0) {
                        curveL = false;
                    } else if (ii == segmentMaps.length - 1) {
                        curveR = false;
                    }
                    if (curveL) {
                        nPointsL = this.getCurvePoints(0.0, height, x1, xpsL, ypsL, false, false);
                        subpixel = this.channel.isSubpixelRendering();
                        this.channel.setSubpixelRendering(true);
                        ypsL[0] = ypsL[0] - 1.0;
                        ypsR[0] = ypsR[0] - 1.0;
                        PolylineSegment.drawPolylineBand((Channel)this.channel, (double[])xpsL, (double[])ypsL, (int)nPointsL, (double[])xpsR, (double[])ypsR, (int)nPointsR, (Color)this.brokenGapColor);
                        ypsL[0] = ypsL[0] + 1.0;
                        ypsR[0] = ypsR[0] + 1.0;
                        if (this.brokenAxisHash == 0) {
                            PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xpsL, (double[])ypsL, (int)nPointsL, (Color)edgeColor, (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xpsR, (double[])ypsR, (int)nPointsR, (Color)edgeColor, (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                        }
                        this.channel.setSubpixelRendering(subpixel);
                    }
                    if (!curveR) continue;
                    nPointsR = this.getCurvePoints(0.0, height, x2, xpsR, ypsR, false, false);
                }
            }
            this.channel.glPopMatrix();
        }
    }

    private Color[] getHashColors(ArrayList axes, VRectAxis theAxis) {
        Color edgeColor = null;
        Color secondaryEdgeColor = null;
        VRectAxis mirrorAxis = this.getMirror(axes, theAxis);
        if (theAxis.getPrimary()) {
            if (theAxis.getAxisStyle().isAxisLineOn()) {
                edgeColor = theAxis.getAxisStyle().getAxisLineColor();
            } else if (this.wall.isEdgeOn()) {
                edgeColor = this.wall.getEdgeStyle().getColor();
            }
            if (mirrorAxis != null && mirrorAxis.getAxisStyle().isAxisLineOn()) {
                secondaryEdgeColor = mirrorAxis.getAxisStyle().getAxisLineColor();
            } else if (this.wall.isEdgeOn()) {
                secondaryEdgeColor = this.wall.getEdgeStyle().getColor();
            }
        } else {
            if (theAxis.getAxisStyle().isAxisLineOn()) {
                secondaryEdgeColor = theAxis.getAxisStyle().getAxisLineColor();
            } else if (this.wall.isEdgeOn()) {
                secondaryEdgeColor = this.wall.getEdgeStyle().getColor();
            }
            if (mirrorAxis != null && mirrorAxis.getAxisStyle().isAxisLineOn()) {
                edgeColor = mirrorAxis.getAxisStyle().getAxisLineColor();
            } else if (this.wall.isEdgeOn()) {
                edgeColor = this.wall.getEdgeStyle().getColor();
            }
        }
        return new Color[]{edgeColor, secondaryEdgeColor};
    }

    private VRectAxis getMirror(ArrayList axes, VRectAxis theAxis) {
        for (int i = 0; i < axes.size(); ++i) {
            VRectAxis a = (VRectAxis)axes.get(i);
            if (a.getMirrorAxis() != theAxis) continue;
            return a;
        }
        return null;
    }

    private void drawBrokenAxisHash(Graphics g, double xo, double yo, double width, double height) {
        if (this.brokenAxisHash == 0) {
            return;
        }
        int edgeWidth = (int)Math.ceil(StatGraph.dataDPIScaleFactor);
        int edgePattern = SASLinePatterns.getStipplePattern((int)1);
        int edgeFactor = SASLinePatterns.getStippleFactor((int)1);
        double halfHash = this.getHalfHash();
        for (int i = 0; i < this.axes.size(); ++i) {
            int nPoints;
            double[] yps;
            double[] xps;
            int nCurvePoints;
            boolean drawEnd;
            boolean drawBegin;
            int ii;
            double off;
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!a.isBrokenAxis()) continue;
            this.channel.glPushMatrix();
            Color[] edgeColors = this.getHashColors(this.axes, a);
            ContinuousRangeToNumericMap[] segmentMaps = ((BrokenPositionEncoder)a.getEncoder(a.getDimension())).getRangeOutputMaps();
            double startOffset = -a.getStartOffset();
            if (a.getDimension() == 2) {
                if (this.innerMarginBorder != null) {
                    this.channel.glTranslate(xo, yo + (double)this.innerMarginBorder.bottom, 0.0);
                } else {
                    this.channel.glTranslate(xo, yo, 0.0);
                }
                off = BrokenPositionEncoder.RESERVED_OFFSET;
                block19: for (ii = 0; ii < segmentMaps.length; ++ii) {
                    double y1 = segmentMaps[ii].getOutputMin() - startOffset - off;
                    double y2 = segmentMaps[ii].getOutputMax() - startOffset + off;
                    drawBegin = true;
                    drawEnd = true;
                    if (ii == 0) {
                        drawBegin = false;
                    } else if (ii == segmentMaps.length - 1) {
                        drawEnd = false;
                    }
                    switch (this.brokenAxisHash) {
                        default: {
                            continue block19;
                        }
                        case 1: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(-halfHash), (double)y1, (double)0.0, (double)halfHash, (double)y1, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(width - halfHash), (double)y1, (double)0.0, (double)(width + halfHash), (double)y1, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block19;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(-halfHash), (double)y2, (double)0.0, (double)halfHash, (double)y2, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block19;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(width - halfHash), (double)y2, (double)0.0, (double)(width + halfHash), (double)y2, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block19;
                        }
                        case 2: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(-0.866 * halfHash), (double)(y1 - 0.5 * halfHash), (double)0.0, (double)(0.866 * halfHash), (double)(y1 + 0.5 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(width - 0.866 * halfHash), (double)(y1 - 0.5 * halfHash), (double)0.0, (double)(width + 0.866 * halfHash - 1.0), (double)(y1 + 0.5 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block19;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(-0.866 * halfHash), (double)(y2 - 0.5 * halfHash), (double)0.0, (double)(0.866 * halfHash), (double)(y2 + 0.5 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block19;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(width - 0.866 * halfHash), (double)(y2 - 0.5 * halfHash), (double)0.0, (double)(width + 0.866 * halfHash - 1.0), (double)(y2 + 0.5 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block19;
                        }
                        case 3: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(-0.866 * halfHash), (double)(y1 + 0.5 * halfHash), (double)0.0, (double)(0.866 * halfHash), (double)(y1 - 0.5 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(width - 0.866 * halfHash), (double)(y1 + 0.5 * halfHash), (double)0.0, (double)(width + 0.866 * halfHash - 1.0), (double)(y1 - 0.5 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block19;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(-0.866 * halfHash), (double)(y2 + 0.5 * halfHash), (double)0.0, (double)(0.866 * halfHash), (double)(y2 - 0.5 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block19;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(width - 0.866 * halfHash), (double)(y2 + 0.5 * halfHash), (double)0.0, (double)(width + 0.866 * halfHash - 1.0), (double)(y2 - 0.5 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block19;
                        }
                        case 4: {
                            nCurvePoints = MAX_CURVE_POINTS / 2;
                            xps = new double[nCurvePoints];
                            yps = new double[nCurvePoints];
                            nPoints = 0;
                            off = BrokenPositionEncoder.RESERVED_OFFSET;
                            BrokenPositionEncoder.RESERVED_OFFSET = off / 2.0;
                            if (drawBegin) {
                                this.channel.setSubpixelRendering(true);
                                if (edgeColors[0] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, -halfHash, halfHash, y1, nCurvePoints, xps, yps, true, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, width - halfHash, width + halfHash, y1, nCurvePoints, xps, yps, true, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                this.channel.setSubpixelRendering(false);
                            }
                            if (drawEnd) {
                                this.channel.setSubpixelRendering(true);
                                if (edgeColors[0] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, -halfHash, halfHash, y2, nCurvePoints, xps, yps, true, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, width - halfHash, width + halfHash, y2, nCurvePoints, xps, yps, true, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                this.channel.setSubpixelRendering(false);
                            }
                            BrokenPositionEncoder.RESERVED_OFFSET = off;
                            continue block19;
                        }
                        case 5: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)y1, (double)0.0, (double)(-0.707 * halfHash), (double)(y1 - 0.25 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(-0.707 * halfHash), (double)(y1 - 0.25 * halfHash), (double)0.0, (double)0.0, (double)(y1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)width, (double)y1, (double)0.0, (double)(width - 0.707 * halfHash), (double)(y1 - 0.25 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(width - 0.707 * halfHash), (double)(y1 - 0.25 * halfHash), (double)0.0, (double)width, (double)(y1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block19;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)y2, (double)0.0, (double)(0.707 * halfHash), (double)(y2 + 0.25 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(0.707 * halfHash), (double)(y2 + 0.25 * halfHash), (double)0.0, (double)0.0, (double)(y2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block19;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)width, (double)y2, (double)0.0, (double)(width + 0.707 * halfHash), (double)(y2 + 0.25 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(width + 0.707 * halfHash), (double)(y2 + 0.25 * halfHash), (double)0.0, (double)width, (double)(y2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block19;
                        }
                        case 6: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)y1, (double)0.0, (double)(0.707 * halfHash), (double)(y1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)width, (double)y1, (double)0.0, (double)(width - 0.707 * halfHash), (double)(y1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block19;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)y2, (double)0.0, (double)(0.707 * halfHash), (double)(y2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block19;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)width, (double)y2, (double)0.0, (double)(width - 0.707 * halfHash), (double)(y2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block19;
                        }
                        case 7: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)y1, (double)0.0, (double)(0.707 * halfHash), (double)y1, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(0.707 * halfHash), (double)y1, (double)0.0, (double)0.0, (double)(y1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)width, (double)y1, (double)0.0, (double)(width + 0.707 * halfHash), (double)y1, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(width + 0.707 * halfHash), (double)y1, (double)0.0, (double)width, (double)(y1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block19;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)0.0, (double)y2, (double)0.0, (double)(-0.707 * halfHash), (double)y2, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(-0.707 * halfHash), (double)y2, (double)0.0, (double)0.0, (double)(y2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block19;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)width, (double)y2, (double)0.0, (double)(width - 0.707 * halfHash), (double)y2, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(width - 0.707 * halfHash), (double)y2, (double)0.0, (double)width, (double)(y2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                        }
                    }
                }
            } else if (a.getDimension() == 1) {
                if (this.innerMarginBorder != null) {
                    this.channel.glTranslate(xo + (double)this.innerMarginBorder.left, yo, 0.0);
                } else {
                    this.channel.glTranslate(xo, yo, 0.0);
                }
                off = BrokenPositionEncoder.RESERVED_OFFSET;
                block20: for (ii = 0; ii < segmentMaps.length; ++ii) {
                    double x1 = segmentMaps[ii].getOutputMin() - startOffset - off;
                    double x2 = segmentMaps[ii].getOutputMax() - startOffset + off;
                    drawBegin = true;
                    drawEnd = true;
                    if (ii == 0) {
                        drawBegin = false;
                    } else if (ii == segmentMaps.length - 1) {
                        drawEnd = false;
                    }
                    switch (this.brokenAxisHash) {
                        default: {
                            continue block20;
                        }
                        case 1: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)(-halfHash), (double)0.0, (double)x1, (double)halfHash, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)(height + halfHash), (double)0.0, (double)x1, (double)(height - halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block20;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)halfHash, (double)0.0, (double)x2, (double)(-halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block20;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)(height - halfHash), (double)0.0, (double)x2, (double)(height + halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block20;
                        }
                        case 2: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(x1 - 0.5 * halfHash), (double)(-0.866 * halfHash), (double)0.0, (double)(x1 + 0.5 * halfHash), (double)(0.866 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(x1 - 0.5 * halfHash), (double)(height - 0.707 * halfHash), (double)0.0, (double)(x1 + 0.5 * halfHash - 1.0), (double)(height + 0.866 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block20;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(x2 - 0.5 * halfHash), (double)(-0.866 * halfHash), (double)0.0, (double)(x2 + 0.5 * halfHash), (double)(0.866 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block20;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(x2 - 0.5 * halfHash), (double)(height - 0.707 * halfHash), (double)0.0, (double)(x2 + 0.5 * halfHash - 1.0), (double)(height + 0.866 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block20;
                        }
                        case 3: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(x1 - 0.5 * halfHash), (double)(0.866 * halfHash), (double)0.0, (double)(x1 + 0.5 * halfHash), (double)(-0.866 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(x1 - 0.5 * halfHash), (double)(height + 0.707 * halfHash), (double)0.0, (double)(x1 + 0.5 * halfHash - 1.0), (double)(height - 0.866 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block20;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(x2 - 0.5 * halfHash), (double)(0.866 * halfHash), (double)0.0, (double)(x2 + 0.5 * halfHash), (double)(-0.866 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block20;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(x2 - 0.5 * halfHash), (double)(height + 0.707 * halfHash), (double)0.0, (double)(x2 + 0.5 * halfHash - 1.0), (double)(height - 0.866 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block20;
                        }
                        case 4: {
                            nCurvePoints = MAX_CURVE_POINTS / 2;
                            xps = new double[nCurvePoints];
                            yps = new double[nCurvePoints];
                            nPoints = 0;
                            off = BrokenPositionEncoder.RESERVED_OFFSET;
                            BrokenPositionEncoder.RESERVED_OFFSET = off / 2.0;
                            if (drawBegin) {
                                this.channel.setSubpixelRendering(true);
                                if (edgeColors[0] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, -halfHash, halfHash, x1, nCurvePoints, xps, yps, false, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, height - halfHash, height + halfHash, x1, nCurvePoints, xps, yps, false, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                this.channel.setSubpixelRendering(false);
                            }
                            if (drawEnd) {
                                this.channel.setSubpixelRendering(true);
                                if (edgeColors[0] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, -halfHash, halfHash, x2, nCurvePoints, xps, yps, false, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    nPoints = Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, height - halfHash, height + halfHash, x2, nCurvePoints, xps, yps, false, a.isReverse());
                                    PolylineSegment.drawPolylineSegment((Channel)this.channel, (double[])xps, (double[])yps, (int)nPoints, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                this.channel.setSubpixelRendering(false);
                            }
                            BrokenPositionEncoder.RESERVED_OFFSET = off;
                            continue block20;
                        }
                        case 5: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)0.0, (double)0.0, (double)(x1 - 0.25 * halfHash), (double)(0.707 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(x1 - 0.25 * halfHash), (double)(0.707 * halfHash), (double)0.0, (double)(x1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)height, (double)0.0, (double)(x1 - 0.25 * halfHash), (double)(height + 0.707 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)(x1 - 0.25 * halfHash), (double)(height + 0.707 * halfHash), (double)0.0, (double)(x1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)height, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block20;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)0.0, (double)0.0, (double)(x2 + 0.25 * halfHash), (double)(-0.707 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                LineSegment.drawLineSegment((Channel)this.channel, (double)(x2 + 0.25 * halfHash), (double)(-0.707 * halfHash), (double)0.0, (double)(x2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block20;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)height, (double)0.0, (double)(x2 + 0.25 * halfHash), (double)(height - 0.707 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            LineSegment.drawLineSegment((Channel)this.channel, (double)(x2 + 0.25 * halfHash), (double)(height - 0.707 * halfHash), (double)0.0, (double)(x2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)height, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block20;
                        }
                        case 6: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)0.0, (double)0.0, (double)(x1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)(0.707 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)height, (double)0.0, (double)(x1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)(height - 0.707 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block20;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)0.0, (double)0.0, (double)(x2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)(0.707 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block20;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)height, (double)0.0, (double)(x2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)(height - 0.707 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            continue block20;
                        }
                        case 7: {
                            if (drawBegin) {
                                if (edgeColors[0] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)0.0, (double)0.0, (double)x1, (double)(-0.707 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)(-0.707 * halfHash), (double)0.0, (double)(x1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                                if (edgeColors[1] != null) {
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)height, (double)0.0, (double)x1, (double)(height - 0.707 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                    LineSegment.drawLineSegment((Channel)this.channel, (double)x1, (double)(height - 0.707 * halfHash), (double)0.0, (double)(x1 - (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)height, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                }
                            }
                            if (!drawEnd) continue block20;
                            if (edgeColors[0] != null) {
                                LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)0.0, (double)0.0, (double)x2, (double)(0.707 * halfHash), (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                                LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)(0.707 * halfHash), (double)0.0, (double)(x2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)0.0, (double)0.0, (Color)edgeColors[0], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            }
                            if (edgeColors[1] == null) continue block20;
                            LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)height, (double)0.0, (double)x2, (double)(height + 0.707 * halfHash), (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                            LineSegment.drawLineSegment((Channel)this.channel, (double)x2, (double)(height + 0.707 * halfHash), (double)0.0, (double)(x2 + (double)(BrokenPositionEncoder.BROKEN_GAP / 2)), (double)height, (double)0.0, (Color)edgeColors[1], (double)edgeWidth, (int)edgePattern, (int)edgeFactor);
                        }
                    }
                }
            }
            this.channel.glPopMatrix();
        }
    }

    private int getCurvePoints(double start, double end, double base, double[] xps, double[] yps, boolean horizontal, boolean reverseY) {
        return Simple2DOverlayComposite.getCurvePoints(BrokenPositionEncoder.RESERVED_OFFSET, start, end, base, MAX_CURVE_POINTS, xps, yps, horizontal, reverseY);
    }

    public static int getCurvePoints(double amplitude, double start, double end, double base, int maxPoints, double[] xps, double[] yps, boolean horizontal, boolean reverseY) {
        if (xps == null || yps == null) {
            return 0;
        }
        if (xps.length == 2) {
            if (horizontal) {
                xps[0] = start;
                xps[1] = end;
                yps[0] = base;
                yps[1] = base;
            } else {
                xps[0] = base;
                xps[1] = base;
                yps[0] = start;
                yps[1] = end;
            }
            return 2;
        }
        int arrayLen = Math.min(xps.length, yps.length);
        maxPoints = Math.max(arrayLen, maxPoints);
        double A = amplitude;
        double cycle = Math.PI * 2 * Math.max(1.0, (end - start) / (300.0 * StatGraph.dataDPIScaleFactor));
        double W = cycle / (end - start);
        double incr = (end - start) / (double)(maxPoints - 1);
        incr = Math.max(incr, 5.0);
        end += 1.0E-6;
        int n = 0;
        if (horizontal) {
            if (reverseY) {
                A = -A;
            }
            for (double x = start; x <= end; x += incr) {
                xps[n] = x;
                yps[n] = base + A * Math.sin(W * (x - start));
                ++n;
            }
        } else {
            for (double y = start; y <= end; y += incr) {
                double alpha = W * (y - start);
                if (reverseY) {
                    alpha = cycle - alpha;
                }
                yps[n] = y;
                xps[n] = base + A * Math.sin(alpha);
                ++n;
            }
        }
        return n;
    }

    public void setInnerMargin(Insets margin, Insets margin2) {
        this.innerMargin = margin;
        this.innerMargin2 = margin2;
        this.updateRegions();
    }

    public void setInnerMargin(Insets margin) {
        this.setInnerMargin(margin, this.innerMargin2);
    }

    public void setInnerMargin2(Insets margin) {
        this.setInnerMargin(this.innerMargin, margin);
    }

    public void setOuterMargin(Insets margin) {
        this.outerMargin = margin;
        this.updateRegions();
        this.updateAxisSize();
    }

    public Insets getInnerMargin() {
        return this.innerMargin;
    }

    public Insets getInnerMargin2() {
        return this.innerMargin2;
    }

    public Insets getOuterMargin() {
        return this.outerMargin;
    }

    public Insets getFringeMargin() {
        return this.overlayMargin;
    }

    public ProbeResult probe(Point p, Dimension d) {
        if (!this.labelingInited) {
            this.initLabeling(this.channel.getGraphics());
        }
        for (int i = this.overlays.size() - 1; i >= 0; --i) {
            Overlay elem = (Overlay)this.overlays.get(i);
            if (elem instanceof OContour) {
                OContour ctr = (OContour)elem;
                int xi = this.innerRegion.x;
                int yi = this.ymax - (this.innerRegion.y + this.innerRegion.height);
                ProbeResult pr = ctr.probeValueAt(p.x, p.y, xi, yi);
                if (pr == null) continue;
                return pr;
            }
            this.tryProbe(elem, p, d, this.probeNameStack);
            NetworkRoot.NameStackIterator iter = new NetworkRoot.NameStackIterator();
            iter.setNameStack(this.probeNameStack);
            SelectResult sr = null;
            while (iter.hasNext()) {
                sr = iter.next();
            }
            if (sr == null) continue;
            ProbeResult pr = new ProbeResult();
            pr.setElement(elem);
            SelectDetail sd = sr.getDetail();
            int index = 0;
            index = sd instanceof GTKPieSelectDetail ? ((GTKPieSelectDetail)sd).getProcessedIndex() : sr.getValueIndex();
            pr.setRow(index);
            Element gtkElem = sr.getElement();
            if (gtkElem.getUserData() != null) {
                pr.setProbe((Probe)gtkElem.getUserData());
            }
            if (elem instanceof ScatterOverlay && ((ScatterOverlay)elem).isRegressionPlot()) {
                Probe probe = pr.getProbe();
                probe.setLineConnectorDetail((LineConnectorDetail)sd);
                if (((LineConnectorDetail)sd).isInterpolationAvailable()) {
                    pr.setRow(((LineConnectorDetail)sd).getGroupValueIndexAt(0));
                }
            }
            return pr;
        }
        return null;
    }

    protected void tryProbe(Overlay elem, Point p, Dimension d, Stack nameStack) {
        this.channel.glRenderMode(1);
        this.channel.gluPickMatrix(p.x, p.y, d.width, d.height);
        nameStack.removeAllElements();
        this.channel.glInitNames();
        this.channel.glSelectBuffer(nameStack);
        this.channel.glPushMatrix();
        this.translateOverlay(elem);
        elem.select();
        this.channel.glPopMatrix();
        this.channel.glRenderMode(0);
    }

    public ArrayList extendedProbe(Point p, Dimension d) {
        ArrayList<ProbeResult[]> probeList = new ArrayList<ProbeResult[]>();
        ArrayList<SelectResult> srlist = new ArrayList<SelectResult>();
        for (int i = this.overlays.size() - 1; i >= 0; --i) {
            SelectResult sr;
            Overlay o = (Overlay)this.overlays.get(i);
            if (o instanceof OContour) continue;
            Overlay elem = o;
            this.tryProbe(elem, p, d, this.probeNameStack);
            NetworkRoot.NameStackIterator iter = new NetworkRoot.NameStackIterator();
            iter.setNameStack(this.probeNameStack);
            srlist.clear();
            while (iter.hasNext()) {
                sr = iter.next();
                if (srlist.contains(new Integer(sr.getValueIndex()))) continue;
                srlist.add(sr);
            }
            if (srlist.size() <= 0) continue;
            ProbeResult[] pr = new ProbeResult[srlist.size()];
            for (int j = 0; j < srlist.size(); ++j) {
                pr[j] = new ProbeResult();
                pr[j].setElement(elem);
                sr = (SelectResult)srlist.get(j);
                SelectDetail sd = sr.getDetail();
                int index = 0;
                index = sd instanceof GTKPieSelectDetail ? ((GTKPieSelectDetail)sd).getProcessedIndex() : sr.getValueIndex();
                pr[j].setRow(index);
                Element gtkElem = sr.getElement();
                if (gtkElem.getUserData() == null) continue;
                pr[j].setProbe((Probe)gtkElem.getUserData());
            }
            probeList.add(pr);
        }
        return probeList;
    }

    public Object[] getAxes() {
        return this.axes.toArray();
    }

    public AbstractAxis getAxis(Overlay overlay, byte dimension) {
        OverlayDimension od = new OverlayDimension(overlay, dimension);
        Object val = this.OD2A.get(od);
        if (val == null) {
            return null;
        }
        AbstractAxis a = (AbstractAxis)val;
        return a;
    }

    private AbstractAxis getAxis(byte dimension, boolean primary) {
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            boolean prim = true;
            if (a instanceof VRectAxis) {
                prim = ((VRectAxis)a).getPrimary();
            }
            if (prim != primary || a.getDimension() != dimension) continue;
            return a;
        }
        return null;
    }

    public void disableAxisRangeCalc(AbstractAxis axis) {
        RangeMerger rm = (RangeMerger)this.A2RM.get(axis);
        rm.setEnabled(false);
    }

    public void enableAxisRangeCalc(AbstractAxis axis) {
        RangeMerger rm = (RangeMerger)this.A2RM.get(axis);
        rm.setEnabled(true);
    }

    public boolean getAxesVisible() {
        return this.axesVisible;
    }

    public void setAxesVisible(boolean aAxesVisible) {
        this.axesVisible = aAxesVisible;
    }

    public boolean isEquatedAxis(AbstractAxis axis) {
        if (!(axis instanceof VRectAxis)) {
            return false;
        }
        boolean equated = false;
        VRectAxis ra = (VRectAxis)axis;
        if (this.getSquareFormat() != EQUATED_NONE) {
            if (axis.getDimension() == 1) {
                equated = true;
            } else if (ra.getPrimary() && this.squareFormatPrimary) {
                equated = true;
            } else if (!ra.getPrimary() && !this.squareFormatPrimary) {
                equated = true;
            }
        }
        return equated;
    }

    public Wall getWall() {
        return this.wall;
    }

    public void setWall(Wall aWall) {
        this.wall = aWall;
        if (this.wall != null && this.channel != null) {
            this.wall.setChannel(this.channel);
        }
    }

    private Point getAbsLocation() {
        Component cc = this.channel.getComponent();
        Point location = cc.getLocation();
        for (Container parent = cc.getParent(); parent != null && !(parent instanceof StatGraphPanel) && !(parent instanceof JLayeredPane); parent = parent.getParent()) {
            location.x += parent.getX();
            location.y += parent.getY();
        }
        return location;
    }

    private void makeElementOutlineOnly(Overlay elem) {
        if (elem instanceof BarOverlay && ((BarOverlay)elem).getBarElement() != null) {
            ((BarOverlay)elem).getBarElement().fillOn.setValue(false);
            ((BarOverlay)elem).getBarElement().fillPatternOn.setValue(false);
            ((BarOverlay)elem).getBarElement().edgeOn.setValue(true);
        }
    }

    private void resetElement(Overlay elem, boolean fillOn, boolean fillPatternOn, boolean edgeOn) {
        if (elem instanceof BarOverlay && ((BarOverlay)elem).getBarElement() != null) {
            ((BarOverlay)elem).getBarElement().fillOn.setValue(fillOn);
            ((BarOverlay)elem).getBarElement().fillPatternOn.setValue(fillPatternOn);
            ((BarOverlay)elem).getBarElement().edgeOn.setValue(edgeOn);
        }
    }

    public ImageMap getImageMap() {
        if (this.brokenAxis) {
            return null;
        }
        ImageMap imageMap = null;
        Vector selectableShapes = new Vector();
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay elem = (Overlay)this.overlays.get(i);
            if (elem instanceof OContour || !elem.isTooltipEnabled()) continue;
            Vector feedback = new Vector();
            this.channel.glFeedbackBuffer(3, feedback);
            this.channel.glRenderMode(2);
            boolean fillOn = false;
            boolean edgeOn = false;
            boolean fillPatternOn = false;
            if (elem instanceof BarOverlay && ((BarOverlay)elem).getBarElement() != null) {
                fillOn = ((BarOverlay)elem).getBarElement().fillOn.getValue();
                fillPatternOn = ((BarOverlay)elem).getBarElement().fillPatternOn.getValue();
                edgeOn = ((BarOverlay)elem).getBarElement().edgeOn.getValue();
                if (fillOn || edgeOn || fillPatternOn) {
                    this.makeElementOutlineOnly(elem);
                }
            }
            this.channel.glPushMatrix();
            this.translateOverlay(elem);
            elem.select();
            this.channel.glPopMatrix();
            this.channel.glRenderMode(0);
            NetworkRoot.addFeedbackToSelectableShape(feedback, selectableShapes);
            this.resetElement(elem, fillOn, fillPatternOn, edgeOn);
        }
        if (selectableShapes.size() == 0) {
            return null;
        }
        Point location = this.getAbsLocation();
        SelectableShape.translate(selectableShapes, (int)location.x, (int)location.y);
        Rectangle clip = new Rectangle(this.outerRegion.x + location.x, this.outerRegion.y + location.y, this.outerRegion.width, this.outerRegion.height);
        if (selectableShapes.size() > 0) {
            String alt = null;
            String href = null;
            ArrayList<ImageMap.Region> rs = new ArrayList<ImageMap.Region>(selectableShapes.size());
            for (int i = selectableShapes.size() - 1; i >= 0; --i) {
                SelectableShape selectableShape = (SelectableShape)selectableShapes.elementAt(i);
                SelectResult sr = selectableShape.getSelectResult();
                Shape coords = selectableShape.getShape();
                Rectangle2D bounds = coords.getBounds2D();
                if (!clip.intersects(bounds)) continue;
                if (!clip.contains(bounds)) {
                    Polygon p = (Polygon)coords;
                    coords = new Polygon();
                    for (int n = 0; n < p.npoints; ++n) {
                        int x = p.xpoints[n];
                        int y = p.ypoints[n];
                        x = Math.max(clip.x, Math.min(x, clip.x + clip.width));
                        y = Math.max(clip.y, Math.min(y, clip.y + clip.height));
                        ((Polygon)coords).addPoint(x, y);
                    }
                }
                Probe probe = (Probe)sr.getElement().getUserData();
                href = null;
                if (probe == null) continue;
                String[] allLabels = probe.getLabels();
                int obs = sr.getValueIndex();
                String[] allValues = probe.getValues(obs);
                StringBuffer sb = new StringBuffer();
                boolean interpolation = false;
                if (sr.getElement() instanceof LineConnector && ((LineConnector)sr.getElement()).isSelectionInterpolationEnabled()) {
                    SelectDetail sd = sr.getDetail();
                    probe.setLineConnectorDetail((LineConnectorDetail)sd);
                    if (((LineConnectorDetail)sd).isInterpolationAvailable()) {
                        allValues = probe.getValues(((LineConnectorDetail)sd).getGroupValueIndexAt(0));
                    }
                    interpolation = true;
                }
                for (int j = 0; j < allLabels.length; ++j) {
                    if (allLabels[j].indexOf("_URL_") >= 0) {
                        if (allValues[j] == null || allValues[j].length() <= 0) continue;
                        href = allValues[j];
                        continue;
                    }
                    sb = sb.append(allLabels[j] + " = " + allValues[j] + " \n");
                }
                String string = alt = href != null ? sb.toString() : probe.getString(obs);
                if (href == null && interpolation) {
                    alt = sb.toString();
                }
                if (alt.lastIndexOf("\n") > 0) {
                    alt = alt.substring(0, alt.lastIndexOf("\n") - 1);
                }
                ImageMap.Region r = new ImageMap.Region(coords, href, alt);
                rs.add(r);
            }
            ImageMap.Region[] regions = new ImageMap.Region[rs.size()];
            for (int i = 0; i < rs.size(); ++i) {
                regions[i] = (ImageMap.Region)rs.get(i);
            }
            imageMap = new ImageMap(regions);
        }
        return imageMap;
    }

    public void enableMarginPrefCalc() {
    }

    public void disableMarginPrefCalc() {
    }

    public void updateInnerMargin() {
        int right;
        if (this.originalInnerMargin == null) {
            this.originalInnerMargin = new Insets(this.innerMargin.top, this.innerMargin.left, this.innerMargin.bottom, this.innerMargin.right);
        }
        int left = 0;
        int top = right = (int)Math.round(5.0 * StatGraph.getGapScaleFactor());
        int bottom = 0;
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            Insets ext = o.getPreferredInnerMargin();
            top = Math.max(top, ext.top);
            bottom = Math.max(bottom, ext.bottom);
            left = Math.max(left, ext.left);
            right = Math.max(right, ext.right);
        }
        Insets prefPlotInner2 = new Insets(top, left, bottom, right);
        double xStartOffset = Double.MAX_VALUE;
        double xEndOffset = Double.MAX_VALUE;
        double yStartOffset = Double.MAX_VALUE;
        double yEndOffset = Double.MAX_VALUE;
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            byte dim = a.getDimension();
            if (dim == 1) {
                xStartOffset = Math.min(xStartOffset, a.getAbsStartOffset());
                xEndOffset = Math.min(xEndOffset, a.getAbsEndOffset());
                continue;
            }
            if (dim != 2) continue;
            yStartOffset = Math.min(yStartOffset, a.getAbsStartOffset());
            yEndOffset = Math.min(yEndOffset, a.getAbsEndOffset());
        }
        if (xStartOffset >= 0.0 && xStartOffset != Double.MAX_VALUE) {
            left = (int)xStartOffset;
        }
        if (xEndOffset >= 0.0 && xEndOffset != Double.MAX_VALUE) {
            right = (int)xEndOffset;
        }
        if (yStartOffset >= 0.0 && yStartOffset != Double.MAX_VALUE) {
            bottom = (int)yStartOffset;
        }
        if (yEndOffset >= 0.0 && yEndOffset != Double.MAX_VALUE) {
            top = (int)yEndOffset;
        }
        left = Math.max(left, this.originalInnerMargin.left);
        right = Math.max(right, this.originalInnerMargin.right);
        bottom = Math.max(bottom, this.originalInnerMargin.bottom);
        top = Math.max(top, this.originalInnerMargin.top);
        this.prefInner = new Insets(top, left, bottom, right);
        if (!this.prefInner.equals(this.innerMargin)) {
            this.prefPlotInner = prefPlotInner2;
            this.setInnerMargin(this.prefInner);
            this.updateEncoders();
        }
    }

    public boolean hasMarginOverlay(byte dim) {
        int onum = this.overlays.size();
        for (int i = 0; i < onum; ++i) {
            if (!((Overlay)this.overlays.get(i)).isInnerMarginOverlay()) continue;
            return true;
        }
        return false;
    }

    public void addOverlayInnerMargin(OverlayInnerMargin oim) {
        if (this.overlayInnerMargins == null) {
            this.overlayInnerMargins = new ArrayList();
        }
        if (!this.overlayInnerMargins.contains(oim)) {
            this.overlayInnerMargins.add(oim);
        }
    }

    public void clearOverlayInnerMargins() {
        this.overlayInnerMargins = null;
    }

    public boolean hasOverlayOnAxis(VRectAxis axis) {
        byte dim = axis.getDimension();
        boolean primary = axis.getPrimary();
        if (dim == 2) {
            for (int o = 0; o < this.overlays.size(); ++o) {
                Overlay ov = (Overlay)this.overlays.get(o);
                if (ov.isOneDimensional() && ov.isDataOnHorizontalSide()) continue;
                String yaxis = ov.getYAxis();
                if (primary && yaxis.equalsIgnoreCase("y")) {
                    return true;
                }
                if (primary || !yaxis.equalsIgnoreCase("y2")) continue;
                return true;
            }
        } else {
            for (int o = 0; o < this.overlays.size(); ++o) {
                Overlay ov = (Overlay)this.overlays.get(o);
                if (ov.isOneDimensional() && !ov.isDataOnHorizontalSide()) continue;
                String xaxis = ov.getXAxis();
                if (primary && xaxis.equalsIgnoreCase("x")) {
                    return true;
                }
                if (primary || !xaxis.equalsIgnoreCase("x2")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasCurveLabels() {
        for (int i = 0; i < this.overlays.size(); ++i) {
            BandOverlay band;
            Overlay line;
            ScatterOverlay scat;
            Overlay ov = (Overlay)this.overlays.get(i);
            if (!(ov instanceof ScatterOverlay ? (scat = (ScatterOverlay)ov).isCurveLabeled() : (ov instanceof LineParmOverlay ? ((LineParmOverlay)(line = (LineParmOverlay)ov)).isCurveLabeled() : (ov instanceof ReferenceLineOverlay ? ((ReferenceLineOverlay)(line = (ReferenceLineOverlay)ov)).isCurveLabeled() : ov instanceof BandOverlay && (band = (BandOverlay)ov).isCurveLabeled())))) continue;
            return true;
        }
        return false;
    }

    protected void setCurveLabelsOn(boolean on) {
        this.curveLabelsOn = on;
    }

    public Rectangle getInnerRegion() {
        return this.innerRegion;
    }

    public Rectangle getInnerRegion2() {
        return this.innerRegion2;
    }

    public Rectangle getOuterRegion() {
        return this.outerRegion;
    }

    public Overlay getOverlayAt(Point loc) {
        if (!this.labelingInited) {
            this.initLabeling(this.channel.getGraphics());
        }
        for (int i = this.overlays.size() - 1; i >= 0; --i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (o instanceof OContour) {
                OContour ctr = (OContour)o;
                int xi = this.innerRegion.x;
                int yi = this.ymax - (this.innerRegion.y + this.innerRegion.height);
                ProbeResult pr = ctr.probeValueAt(this.x, this.y, xi, yi);
                if (pr == null) continue;
                return o;
            }
            Overlay elem = o;
            this.tryProbe(elem, loc, selArea, this.selectNameStack);
            if (this.selectNameStack.size() <= 0) continue;
            return o;
        }
        return null;
    }

    public int getHLabelShiftDelta() {
        return this.hLabelShiftDelta;
    }

    public void setHLabelShiftDelta(int labelShiftDelta) {
        this.hLabelShiftDelta = labelShiftDelta;
    }

    public int getMaxHLabelShift() {
        return this.maxHLabelShift;
    }

    public void setMaxHLabelShift(int maxHLabelShift) {
        this.maxHLabelShift = maxHLabelShift;
    }

    public int getMaxVLabelShift() {
        return this.maxVLabelShift;
    }

    public void setMaxVLabelShift(int maxVLabelShift) {
        this.maxVLabelShift = maxVLabelShift;
    }

    public int getVLabelShiftDelta() {
        return this.vLabelShiftDelta;
    }

    public void setVLabelShiftDelta(int labelShiftDelta) {
        this.vLabelShiftDelta = labelShiftDelta;
    }

    public PointLabelLayoutManager getPointLabelLayoutManager() {
        return this.pmgr;
    }

    public void hideAllPointLabels() {
        ArrayList overlays = this.getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            ((Overlay)overlays.get(i)).hideAllPointLabels();
        }
    }

    public void showAllPointLabels() {
        ArrayList overlays = this.getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            ((Overlay)overlays.get(i)).showAllPointLabels();
        }
    }

    public int getShowPointLabels() {
        return this.showPointLabels;
    }

    public void setShowPointLabels(int showPointLabels) {
        this.showPointLabels = showPointLabels;
    }

    private void honorUserAspectRatio(double ratio) {
        if (ratio <= 0.0 || this.outerRegion.isEmpty()) {
            return;
        }
        int h = (int)((double)this.outerRegion.width * ratio);
        if (h <= this.outerRegion.height) {
            int dh = this.outerRegion.height - h;
            int dh2 = (int)Math.ceil((double)dh * 0.5);
            this.outerRegion.y += dh2;
            this.outerRegion.height = h;
            this.innerRegion.y += dh2;
            this.innerRegion.height -= dh;
            this.innerRegion2.y += dh2;
            this.innerRegion2.height -= dh;
            this.outerMargin.top += dh2;
            this.outerMargin.bottom += dh2;
        } else {
            int w = (int)((double)this.outerRegion.height / ratio);
            int dw = this.outerRegion.width - w;
            int dw2 = (int)Math.ceil((double)dw * 0.5);
            this.outerRegion.x += dw2;
            this.outerRegion.width = w;
            this.innerRegion.x += dw2;
            this.innerRegion.width -= dw;
            this.innerRegion2.x += dw2;
            this.innerRegion2.width -= dw;
            this.outerMargin.left += dw2;
            this.outerMargin.right += dw2;
        }
    }

    public void setIgnoreMinorMarginIncrease(boolean b) {
        this.ignoreMinorMarginIncrease = b;
    }

    public boolean isOneDimensional() {
        if (this.overlays.size() == 0) {
            return false;
        }
        Overlay first = (Overlay)this.overlays.get(0);
        if (!first.isOneDimensional()) {
            return false;
        }
        boolean horizontal = first.isDataOnHorizontalSide();
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay ovly = (Overlay)this.overlays.get(i);
            if (ovly.isOneDimensional() && ovly.isDataOnHorizontalSide() == horizontal) continue;
            return false;
        }
        return true;
    }

    public boolean isDataOnHorizontalSide() {
        if (!this.isOneDimensional()) {
            return false;
        }
        return ((Overlay)this.overlays.get(0)).isDataOnHorizontalSide();
    }

    public int getPreferredSizeOnDataLessSide() {
        if (!this.isOneDimensional()) {
            return -1;
        }
        int centerSize = 0;
        int leftSize = 0;
        int rightSize = 0;
        int topSize = 0;
        int bottomSize = 0;
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay ovly = (Overlay)this.overlays.get(i);
            int ps = ovly.getPreferredSizeOnDataLessSide();
            if (ovly.getOverlayJustification() == 0) {
                centerSize = Math.max(centerSize, ps);
                continue;
            }
            if (ovly.getOverlayJustification() == 3) {
                leftSize += ps;
                continue;
            }
            if (ovly.getOverlayJustification() == 4) {
                rightSize += ps;
                continue;
            }
            if (ovly.getOverlayJustification() == 1) {
                topSize += ps;
                continue;
            }
            if (ovly.getOverlayJustification() != 2) continue;
            bottomSize += ps;
        }
        if (this.isDataOnHorizontalSide()) {
            return topSize + centerSize + bottomSize + this.outerMargin.top + this.outerMargin.bottom;
        }
        return leftSize + centerSize + rightSize + this.outerMargin.left + this.outerMargin.right;
    }

    public boolean isSALabeling() {
        return this.saLabeling;
    }

    public void setSALabeling(boolean saLabeling) {
        this.saLabeling = saLabeling;
    }

    public boolean isLabelDisplaceable() {
        return this.labelDisplaceable;
    }

    public void setLabelDisplaceable(boolean labelDisplaceable) {
        this.labelDisplaceable = labelDisplaceable;
    }

    public HashMap getSAWeightMap() {
        return this.saWeightMap;
    }

    public void setSAWeightMap(HashMap saWeightMap) {
        this.saWeightMap = saWeightMap;
    }

    public boolean isLabelVerbose() {
        return this.labelVerbose;
    }

    public void setLabelVerbose(boolean labelVerbose) {
        this.labelVerbose = labelVerbose;
    }

    public int getSAMaxIterations() {
        return this.saMaxIterations;
    }

    public void setSAMaxIterations(int saMaxIterations) {
        this.saMaxIterations = saMaxIterations;
    }

    public int getSASeed() {
        return this.saSeed;
    }

    public void setSASeed(int seed) {
        this.saSeed = seed;
    }

    public Insets getGridLabelMargin() {
        Insets glm = new Insets(0, 0, 0, 0);
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            Insets I = o.getGridLabelMargin();
            glm.left = Math.max(glm.left, I.left);
            glm.right = Math.max(glm.right, I.right);
            glm.top = Math.max(glm.top, I.top);
            glm.bottom = Math.max(glm.bottom, I.bottom);
        }
        return glm;
    }

    public boolean hasGridLabel() {
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isDisplayGridLabel()) continue;
            return true;
        }
        return false;
    }

    public void setLeftGridLabelMaxWidth(double w) {
        this.leftGridLabelMaxWidth = w;
    }

    public void setRightGridLabelMaxWidth(double w) {
        this.rightGridLabelMaxWidth = w;
    }

    public void setGridLabelOffsets(int top, int left, int bottom, int right) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isDisplayGridLabel()) continue;
            o.setGridLabelOffsets(top, left, bottom, right);
        }
    }

    public void addGridLabelEntry(Component entry) {
        for (int i = 0; i < this.overlays.size(); ++i) {
            Overlay o = (Overlay)this.overlays.get(i);
            if (!o.isDisplayGridLabel() || !(entry instanceof GridLabelEntry)) continue;
            o.addGridLabelEntry((GridLabelEntry)entry);
        }
    }

    public double getMarkerOffsetX() {
        return this.xOffset;
    }

    public void setMarkerOffsetX(double offset) {
        this.xOffset = offset;
    }

    public double getMarkerOffsetY() {
        return this.yOffset;
    }

    public void setMarkerOffsetY(double offset) {
        this.yOffset = offset;
    }

    public double getMarkerScaleX() {
        return this.xScale;
    }

    public void setMarkerScaleX(double scale) {
        this.xScale = scale;
    }

    public double getMarkerScaleY() {
        return this.yScale;
    }

    public void setMarkerScaleY(double scale) {
        this.yScale = scale;
    }

    public double getMarkerRotation() {
        return this.rotation;
    }

    public void setMarkerRotation(double angle) {
        this.rotation = angle;
    }

    public void paint(Graphics2D g2d, Color color, Color edgeColor, int x, int y, int w, int h) {
        int width = (int)(this.xScale * (double)w);
        int height = (int)(this.yScale * (double)h);
        Graphics2D gc = (Graphics2D)g2d.create();
        this.setBounds(0, 0, width, height, height);
        this.getChannel().setSingleBufferGraphics((Graphics)gc);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        gc.translate(x - width / 2, y + height / 2);
        this.paintingMarker = true;
        this.draw(gc);
        this.paintingMarker = false;
        gc.dispose();
    }

    public void paint(Graphics2D g2d, Color color, Color edgeColor, double x, double y, int w, int h) {
        int width = (int)(this.xScale * (double)w);
        int height = (int)(this.yScale * (double)h);
        Graphics2D gc = (Graphics2D)g2d.create();
        this.setBounds(0, 0, width, height, height);
        this.getChannel().setSingleBufferGraphics((Graphics)gc);
        if (this.rotation != 0.0) {
            gc.rotate(-this.rotation, x, y);
        }
        gc.translate(x - (double)width / 2.0, y + (double)height / 2.0);
        this.paintingMarker = true;
        this.draw(gc);
        this.paintingMarker = false;
        gc.dispose();
    }

    private int getHalfHash() {
        return (int)Math.ceil(BrokenPositionEncoder.BROKEN_GAP);
    }

    private Insets getBrokenAxisHashMargin() {
        if (!this.brokenAxis || this.brokenAxisHash == 0 || this.brokenAxisHash == 6) {
            return new Insets(0, 0, 0, 0);
        }
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int halfHash = this.getHalfHash();
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!a.isBrokenAxis()) continue;
            if (a.getDimension() == 2) {
                left = Math.max(left, halfHash);
                right = Math.max(right, halfHash);
                continue;
            }
            top = Math.max(top, halfHash);
            bottom = Math.max(bottom, halfHash);
        }
        return new Insets(top, left, bottom, right);
    }

    public int getBrokenAxisHash() {
        return this.brokenAxisHash;
    }

    public void setBrokenAxisHash(int brokenAxisHash) {
        this.brokenAxisHash = brokenAxisHash;
    }
}

