/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;

public class RegionLayout
implements LayoutManager2 {
    ArrayList plots = new ArrayList();
    ArrayList insetComponents = new ArrayList();
    ArrayList legends = new ArrayList();
    ArrayList sidebars = new ArrayList();

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals("Plot")) {
            this.plots.add(comp);
        } else if (name.equals("Sidebar")) {
            this.sidebars.add(comp);
        } else if (name.equals("Legend")) {
            this.legends.add(comp);
        } else if (name.equals("Inset")) {
            this.insetComponents.add(comp);
        }
    }

    public String getLayoutComponentName(Component comp) {
        if (this.plots.contains(comp)) {
            return "Plot";
        }
        if (this.sidebars.contains(comp)) {
            return "Sidebar";
        }
        if (this.insetComponents.contains(comp)) {
            return "Inset";
        }
        return "Legend";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int i;
            Dimension size = parent.getSize();
            if (size.width == 0 || size.height == 0) {
                return;
            }
            Insets bi = parent.getInsets();
            Insets si = this.getSurroundingInsets();
            Insets insets = new Insets(bi.top, bi.left, bi.bottom, bi.right);
            insets.left += si.left;
            insets.right += si.right;
            insets.top += si.top;
            insets.bottom += si.bottom;
            Rectangle ir = new Rectangle(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
            Component thePlot = null;
            for (int i2 = 0; i2 < this.plots.size(); ++i2) {
                Component plot = (Component)this.plots.get(i2);
                plot.setBounds(ir.x, ir.y, ir.width, ir.height);
                thePlot = plot;
            }
            boolean marginPlot = thePlot != null && thePlot instanceof MarginInterface;
            Insets pom = null;
            Insets om = null;
            int marginPlotCenterX = 0;
            int marginPlotCenterY = 0;
            if (marginPlot) {
                MarginInterface mi = (MarginInterface)thePlot;
                pom = mi.getPreferredOuterMargin();
                om = mi.getOuterMargin();
                marginPlotCenterX = ir.x + om.left + (ir.width - om.left - om.right) / 2;
                marginPlotCenterY = ir.y + om.top + (ir.height - om.top - om.bottom) / 2;
            }
            int topStart = bi.top + StatGraph.getExtraPadding();
            int biBottomAdjusted = bi.bottom + (bi.bottom > 0 ? StatGraph.getExtraPadding() : 0);
            int bottomStart = size.height - biBottomAdjusted;
            for (int i3 = 0; i3 < this.legends.size(); ++i3) {
                Component l = (Component)this.legends.get(i3);
                Dimension d = l.getPreferredSize();
                if (l instanceof LegendComponent || l instanceof SizeLegendComponent) {
                    if (ir != null) {
                        if (l.getAlignmentX() == 0.0f || l.getAlignmentX() == 1.0f) {
                            d.height = ir.height;
                            if (l instanceof LegendComponent && marginPlot) {
                                d.height -= om.top + om.bottom;
                            }
                        } else if (l.getAlignmentY() == 0.0f || l.getAlignmentY() == 1.0f) {
                            d.width = ir.width;
                            if (l instanceof LegendComponent && marginPlot) {
                                d.width -= om.left + om.right;
                            }
                        }
                    } else if (l.getAlignmentX() == 0.0f || l.getAlignmentX() == 1.0f) {
                        d.height = size.height;
                    } else if (l.getAlignmentY() == 0.0f || l.getAlignmentY() == 1.0f) {
                        d.width = size.width;
                    }
                }
                if (l.getAlignmentY() == 0.0f) {
                    if (ir != null) {
                        if (l.getAlignmentX() == 0.0f) {
                            l.setBounds(ir.x, topStart, d.width, d.height);
                            continue;
                        }
                        if (l.getAlignmentX() == 1.0f) {
                            l.setBounds(ir.x + ir.width - d.width, topStart, d.width, d.height);
                            continue;
                        }
                        if (marginPlot) {
                            if (l instanceof LegendComponent) {
                                l.setBounds(ir.x + om.left, topStart + (om.top - pom.top), d.width, d.height);
                                continue;
                            }
                            l.setBounds(marginPlotCenterX - d.width / 2, topStart + (om.top - pom.top), d.width, d.height);
                            continue;
                        }
                        l.setBounds(ir.x + ir.width / 2 - d.width / 2, topStart, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 0.0f) {
                        l.setBounds(bi.left, topStart, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 1.0f) {
                        l.setBounds(bi.left + size.width - d.width, topStart, d.width, d.height);
                        continue;
                    }
                    l.setBounds(bi.left + size.width / 2 - d.width / 2, topStart, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentY() == 1.0f) {
                    if (ir != null) {
                        if (l.getAlignmentX() == 0.0f) {
                            l.setBounds(ir.x, bottomStart - d.height, d.width, d.height);
                            continue;
                        }
                        if (l.getAlignmentX() == 1.0f) {
                            l.setBounds(ir.x + ir.width - d.width, bottomStart - d.height, d.width, d.height);
                            continue;
                        }
                        if (marginPlot) {
                            if (l instanceof LegendComponent) {
                                l.setBounds(ir.x + om.left, bottomStart - d.height - (om.bottom - pom.bottom), d.width, d.height);
                                continue;
                            }
                            l.setBounds(marginPlotCenterX - d.width / 2, bottomStart - d.height - (om.bottom - pom.bottom), d.width, d.height);
                            continue;
                        }
                        l.setBounds(ir.x + ir.width / 2 - d.width / 2, bottomStart - d.height, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 0.0f) {
                        l.setBounds(0, bottomStart - d.height, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentX() == 1.0f) {
                        l.setBounds(size.width - d.width, bottomStart - d.height, d.width, d.height);
                        continue;
                    }
                    l.setBounds(size.width / 2 - d.width / 2, bottomStart - d.height, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentX() == 0.0f) {
                    if (ir != null) {
                        if (l.getAlignmentY() == 0.0f) {
                            l.setBounds(bi.left, ir.y, d.width, d.height);
                            continue;
                        }
                        if (l.getAlignmentY() == 1.0f) {
                            l.setBounds(bi.left, ir.y + ir.height - d.height, d.width, d.height);
                            continue;
                        }
                        if (marginPlot) {
                            if (l instanceof LegendComponent) {
                                l.setBounds(bi.left + (om.left - pom.left), ir.y + om.top, d.width, d.height);
                                continue;
                            }
                            l.setBounds(bi.left + (om.left - pom.left), marginPlotCenterY - d.height / 2, d.width, d.height);
                            continue;
                        }
                        l.setBounds(bi.left, ir.y + ir.height / 2 - d.height / 2, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentY() == 0.0f) {
                        l.setBounds(bi.left, bi.top, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentY() == 1.0f) {
                        l.setBounds(bi.left, bi.top + size.height - d.height, d.width, d.height);
                        continue;
                    }
                    l.setBounds(bi.left, bi.top + size.height / 2 - d.height / 2, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentX() != 1.0f) continue;
                if (ir != null) {
                    if (l.getAlignmentY() == 0.0f) {
                        l.setBounds(size.width - bi.right - d.width, ir.y, d.width, d.height);
                        continue;
                    }
                    if (l.getAlignmentY() == 1.0f) {
                        l.setBounds(size.width - bi.right - d.width, ir.y + ir.height - d.height, d.width, d.height);
                        continue;
                    }
                    if (marginPlot) {
                        if (l instanceof LegendComponent) {
                            l.setBounds(size.width - bi.right - d.width - (om.right - pom.right), ir.y + om.top, d.width, d.height);
                            continue;
                        }
                        l.setBounds(size.width - bi.right - d.width - (om.right - pom.right), marginPlotCenterY - d.height / 2, d.width, d.height);
                        continue;
                    }
                    l.setBounds(size.width - bi.right - d.width, ir.y + ir.height / 2 - d.height / 2, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentY() == 0.0f) {
                    l.setBounds(size.width - bi.right - d.width, 0, d.width, d.height);
                    continue;
                }
                if (l.getAlignmentY() == 1.0f) {
                    l.setBounds(size.width - bi.right - d.width, size.height - d.height, d.width, d.height);
                    continue;
                }
                l.setBounds(size.width - bi.right - d.width, size.height / 2 - d.height / 2, d.width, d.height);
            }
            topStart = bi.top + si.top;
            bottomStart = size.height - bi.bottom - si.bottom;
            int leftStart = bi.left + si.left;
            int rightStart = size.width - bi.right - si.right;
            for (i = 0; i < this.sidebars.size(); ++i) {
                Component sb = (Component)this.sidebars.get(i);
                Dimension d = sb.getPreferredSize();
                if (sb instanceof EntryComposite) {
                    if (sb.getAlignmentY() == 0.0f) {
                        sb.setBounds(bi.left, topStart - d.height, size.width - bi.left - bi.right, d.height);
                        topStart -= d.height;
                        continue;
                    }
                    sb.setBounds(bi.left, bottomStart, size.width - bi.left - bi.right, d.height);
                    bottomStart += d.height;
                    continue;
                }
                if (sb.getAlignmentY() == 0.0f) {
                    sb.setBounds(bi.left + size.width / 2 - d.width / 2, topStart - d.height, d.width, d.height);
                    topStart -= d.height;
                    continue;
                }
                if (sb.getAlignmentY() == 1.0f) {
                    sb.setBounds(size.width / 2 - d.width / 2, bottomStart, d.width, d.height);
                    bottomStart += d.height;
                    continue;
                }
                if (sb.getAlignmentX() == 0.0f) {
                    sb.setBounds(leftStart - d.width, bi.top + size.height / 2 - d.height / 2, d.width, d.height);
                    leftStart -= d.width;
                    continue;
                }
                if (sb.getAlignmentX() != 1.0f) continue;
                sb.setBounds(rightStart, size.height / 2 - d.height / 2, d.width, d.height);
                rightStart += d.width;
            }
            for (i = 0; i < this.insetComponents.size(); ++i) {
                int y;
                int x;
                BaseOverlayContainer boc;
                Component c = (Component)this.insetComponents.get(i);
                if (ir == null && c instanceof BaseOverlayContainer && (boc = (BaseOverlayContainer)c).getComposite() != null) {
                    c.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
                    continue;
                }
                Dimension cp = c.getPreferredSize();
                int w = size.width - bi.left - bi.right;
                int h = size.height - bi.top - bi.bottom;
                if (w > 0 && h > 0) {
                    cp.width = Math.min(w, cp.width);
                    cp.height = Math.min(h, cp.height);
                }
                if (c instanceof EntryComposite && ((AbstractSGComponent)c).getAutoAlignStartegy() == 0) {
                    cp.width = ir != null ? ir.width : w;
                }
                if (ir != null) {
                    BaseOverlayContainer boc2;
                    if (c instanceof BaseOverlayContainer && (boc2 = (BaseOverlayContainer)c).getComposite() != null && boc2.getComposite().getOverlays().size() > 0) {
                        if (boc2.getUserHeight() < 0) {
                            cp.height = ir.height;
                        }
                        if (boc2.getUserWidth() < 0) {
                            cp.width = ir.width;
                        }
                    }
                    x = ir.x + cp.width / 2 + (int)((double)((float)(ir.width - cp.width) * c.getAlignmentX()) + 0.5) - cp.width / 2;
                    y = ir.y + cp.height / 2 + (int)((double)((float)(ir.height - cp.height) * c.getAlignmentY()) + 0.5) - cp.height / 2;
                } else {
                    x = (int)((double)((float)(w - cp.width) * c.getAlignmentX()) + 0.5) + bi.left;
                    y = (int)((double)((float)(h - cp.height) * c.getAlignmentY()) + 0.5) + bi.top;
                }
                c.setBounds(x, y, cp.width, cp.height);
            }
        }
    }

    protected Insets getSurroundingInsets() {
        Dimension d;
        Component c;
        int i;
        Insets insets = new Insets(0, 0, 0, 0);
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        for (i = 0; i < this.legends.size(); ++i) {
            c = (Component)this.legends.get(i);
            d = c.getPreferredSize();
            if (c.getAlignmentY() == 0.0f) {
                top = Math.max(top, d.height);
                continue;
            }
            if (c.getAlignmentY() == 1.0f) {
                bottom = Math.max(bottom, d.height);
                continue;
            }
            if (c.getAlignmentX() == 0.0f) {
                left = Math.max(left, d.width);
                continue;
            }
            if (c.getAlignmentX() != 1.0f) continue;
            right = Math.max(right, d.width);
        }
        for (i = 0; i < this.sidebars.size(); ++i) {
            c = (Component)this.sidebars.get(i);
            d = c.getPreferredSize();
            if (c.getAlignmentY() == 0.0f) {
                top += d.height;
                continue;
            }
            if (c.getAlignmentY() == 1.0f) {
                bottom += d.height;
                continue;
            }
            if (c.getAlignmentX() == 0.0f) {
                left += d.width;
                continue;
            }
            if (c.getAlignmentX() != 1.0f) continue;
            right += d.width;
        }
        insets.left += left;
        insets.right += right;
        insets.top += top;
        insets.bottom += bottom;
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            return new Dimension(1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d = new Dimension(0, 0);
            if (this.plots != null && this.plots.size() > 0) {
                for (int i = 0; i < this.plots.size(); ++i) {
                    Component plot = (Component)this.plots.get(i);
                    d.width = Math.max(d.width, plot.getPreferredSize().width);
                    d.height = Math.max(d.height, plot.getPreferredSize().height);
                }
            }
            return d;
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public void removeLayoutComponent(String name, Component comp) {
        if (name.equals("Plot")) {
            this.plots.remove(comp);
        } else if (name.equals("Sidebar")) {
            this.sidebars.remove(comp);
        } else if (name.equals("Legend")) {
            this.legends.remove(comp);
        } else if (name.equals("Inset")) {
            this.insetComponents.remove(comp);
        }
    }
}

