/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.composite;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.ValueMap;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;

public class OverviewAxisComposite
extends Simple2DOverlayComposite {
    private VRectAxis parentAxis;
    private double maxSize = Double.NaN;
    private double minSize = Double.NaN;
    private double sizeFactor = 0.35;
    private double size;
    private double parentAxisSize;
    private double overviewAxisSize;

    public OverviewAxisComposite(VRectAxis parent) {
        this.parentAxis = parent;
    }

    public double getSizeFactor() {
        return this.sizeFactor;
    }

    public double getSize() {
        return this.size;
    }

    public void setMaxSize(double size) {
        this.maxSize = size;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMinSize(double size) {
        this.minSize = size;
    }

    public double getMinSize() {
        return this.minSize;
    }

    public double getParentAxisSize() {
        return this.parentAxisSize;
    }

    public double getOverviewAxisSize() {
        return this.overviewAxisSize;
    }

    public Insets getExtent(Insets parentExtent) {
        Insets in = parentExtent;
        this.updatePrefs();
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            this.parentAxisSize = in.bottom;
            if ((double)in.bottom < this.getSize()) {
                this.overviewAxisSize = this.getSize() - this.parentAxisSize;
                in.bottom = (int)this.getSize();
            } else if ((double)in.bottom < this.getMaxSize()) {
                this.overviewAxisSize = this.getSize() - this.parentAxisSize;
                in.bottom = (int)this.getMaxSize();
            }
            in.left = Math.max(in.left, this.outerMargin.left);
            in.right = Math.max(in.right, this.outerMargin.right);
        }
        return in;
    }

    public void updateOuterMargin(Insets outer, Vector grids) {
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            this.outerMargin.left = outer.left;
            this.outerMargin.right = outer.right;
        }
        if (this.isUpdateEncoderLimitsNeeded()) {
            this.updateEncoderLimits(this.outerMargin);
        }
        VRectAxis theAxis = null;
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            theAxis = (VRectAxis)this.getAxis((byte)1, true);
            if (theAxis.getUserStartOffset() >= 0.0) {
                this.innerMargin.left = (int)theAxis.getAbsStartOffset();
            }
            if (theAxis.getUserEndOffset() >= 0.0) {
                this.innerMargin.right = (int)theAxis.getAbsEndOffset();
            }
        }
        this.updateRegions();
        this.updateEncoders();
        PositionEncoder pe = (PositionEncoder)theAxis.getEncoder(this.parentAxis.getDimension());
        ValueMap map = pe.getValueMap();
        if (map instanceof ContinuousRangeToNumericMap) {
            double min = ((ContinuousRangeToNumericMap)map).getInverseValue(pe.getLowerLimit());
            double max = ((ContinuousRangeToNumericMap)map).getInverseValue(pe.getUpperLimit());
            if (pe.isReversed()) {
                double temp = min;
                min = max;
                max = temp;
            }
            double viewportMin = this.parentAxis.getDisplayMin();
            double viewportMax = this.parentAxis.getDisplayMax();
            boolean update = false;
            if (!Double.isNaN(viewportMin) && viewportMin < min) {
                this.parentAxis.setViewportMin(min);
                update = true;
            }
            if (!Double.isNaN(viewportMax) && viewportMax > max) {
                this.parentAxis.setViewportMax(max);
                update = true;
            }
            if (update) {
                this.parentAxis.updateOutputRange();
                this.parentAxis.setCompressExtender(true);
            }
        } else if (map instanceof StringToNumericMap) {
            StringToNumericMap stnm = (StringToNumericMap)map;
            double stride = stnm.getStrideValue();
            DataRange allRange = theAxis.getDataRange(this.parentAxis.getDimension());
            Object dr = allRange instanceof OrdinalRange ? new OrdinalRange((OrdinalRange)allRange) : new DiscreteRange((DataRange)((DiscreteRange)allRange));
            Vector values = dr.getValues();
            if (!(dr instanceof OrdinalRange) && pe.isReversed()) {
                if (pe.getOrder() == 1) {
                    Collections.sort(values, new Sort.StringComparator(1, Locale.getDefault(), StatGraph.collation));
                } else if (pe.getOrder() == 2) {
                    Collections.sort(values, new Sort.StringComparator(2, Locale.getDefault(), StatGraph.collation));
                }
            }
            double min = 1.0 - (double)(this.innerRegion.x - this.outerRegion.x) / stride;
            double max = (double)values.size() + (double)(this.outerRegion.x + this.outerRegion.width - (this.innerRegion.x + this.innerRegion.width)) / stride;
            double viewportMin = this.parentAxis.getDisplayMin();
            double viewportMax = this.parentAxis.getDisplayMax();
            if (!Double.isNaN(viewportMin) || !Double.isNaN(viewportMax)) {
                int tickLast;
                this.parentAxis.setUserStartOffset(0.0);
                this.parentAxis.setUserEndOffset(0.0);
                if (Double.isNaN(viewportMin) || viewportMin < min) {
                    viewportMin = min;
                }
                if (Double.isNaN(viewportMax) || viewportMax > max) {
                    viewportMax = max;
                }
                int dmin = (int)Math.floor(viewportMin + 0.5);
                int dmax = (int)Math.ceil(viewportMax - 0.5);
                dmin = Math.max(dmin, 1);
                dmax = Math.min(dmax, values.size());
                Vector newValues = new Vector();
                for (int i = dmin; i <= dmax; ++i) {
                    newValues.add(values.get(i - 1));
                }
                dr.setValues(newValues);
                this.parentAxis.setInputDataRange((DataRange)dr);
                PositionEncoder e = (PositionEncoder)this.parentAxis.getEncoder(this.parentAxis.getDimension());
                double newStride = (double)this.outerRegion.width / (viewportMax - viewportMin);
                double start = ((double)dmin - viewportMin) * newStride;
                double end = ((double)dmax - viewportMax) * newStride;
                if (e.isReversed()) {
                    double temp = start;
                    start = -end;
                    end = -temp;
                }
                e.setOutputMin(start);
                e.setOutputMax((double)this.outerRegion.width + end);
                StringToNumericMap sm = (StringToNumericMap)e.getValueMap();
                sm.init(new AInitAction(null));
                this.parentAxis.setEncoder(this.parentAxis.getDimension(), e);
                this.parentAxis.getVTKAxis().setLength((double)this.outerRegion.width);
                this.parentAxis.setCompressExtender(true);
                int tickFirst = (double)dmin - viewportMin >= 0.0 ? dmin : dmin + 1;
                int n = tickLast = viewportMax - (double)dmax >= 0.0 ? dmax : dmax - 1;
                if (tickFirst != dmin || tickLast != dmax) {
                    StringPipe label = sm.label;
                    NumericPipe labelOffset = sm.uniqueValue;
                    StringVector tickLabels = new StringVector();
                    NumericVector ticks = new NumericVector();
                    int idx = 0;
                    if (!e.isReversed() && tickFirst != dmin || e.isReversed() && tickLast != dmax) {
                        tickLabels.addValue("");
                        ++idx;
                    }
                    try {
                        for (int i = tickFirst; i <= tickLast; ++i) {
                            tickLabels.addValue(label.getValue(idx));
                            ticks.addValue(labelOffset.getValue(idx));
                            ++idx;
                        }
                    }
                    catch (MissingValueException i) {
                        // empty catch block
                    }
                    if (!e.isReversed() && tickLast != dmax || e.isReversed() && tickFirst != dmin) {
                        tickLabels.addValue("");
                    }
                    this.parentAxis.getVTKAxis().labels.connectFrom((StringPipe)tickLabels);
                    if (this.parentAxis.isTicksShownAtMidpoint()) {
                        this.parentAxis.getVTKAxis().majorTickOffset.connectFrom((NumericPipe)ticks);
                    }
                    if (grids != null) {
                        for (int j = 0; j < grids.size(); ++j) {
                            VRectGridLines rgl = (VRectGridLines)grids.elementAt(j);
                            rgl.setPositionOffset((NumericPipe)ticks);
                        }
                    }
                }
            }
        }
    }

    public void updateInnerMargin(Insets inner) {
        if (this.parentAxis.getType() == 6) {
            return;
        }
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            this.innerMargin.left = inner.left;
            this.innerMargin.right = inner.right;
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            this.size = height;
        }
        if (!Double.isNaN(this.minSize)) {
            this.size = Math.max(this.minSize, this.size);
        }
        if (!Double.isNaN(this.maxSize)) {
            this.size = Math.min(this.maxSize, this.size);
        }
        super.setBounds(x, y + (int)this.getParentAxisSize(), width, (int)this.getOverviewAxisSize(), (int)this.getOverviewAxisSize());
    }

    @Override
    public void draw(Graphics g) {
        this.drawParts(g);
        double viewportMin = this.parentAxis.getViewportMin();
        double viewportMax = this.parentAxis.getViewportMax();
        int x = this.outerRegion.x;
        int y = this.outerRegion.y;
        int h = this.outerRegion.height;
        int w = this.outerRegion.width;
        g.setColor(new Color(255, 255, 255, 200));
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            VRectAxis axis = (VRectAxis)this.getAxis((byte)1, true);
            PositionEncoder pe = (PositionEncoder)axis.getEncoder((byte)1);
            ValueMap map = pe.getValueMap();
            int min = 0;
            int max = 0;
            if (map instanceof ContinuousRangeToNumericMap) {
                if (pe.isReversed()) {
                    max = Double.isNaN(viewportMin) ? x + w - 1 : (int)((ContinuousRangeToNumericMap)map).getValue(viewportMin) + this.innerRegion.x;
                    min = Double.isNaN(viewportMax) ? x : (int)((ContinuousRangeToNumericMap)map).getValue(viewportMax) + this.innerRegion.x;
                } else {
                    min = Double.isNaN(viewportMin) ? x : (int)((ContinuousRangeToNumericMap)map).getValue(viewportMin) + this.innerRegion.x;
                    max = Double.isNaN(viewportMax) ? x + w - 1 : (int)((ContinuousRangeToNumericMap)map).getValue(viewportMax) + this.innerRegion.x;
                }
            } else if (map instanceof StringToNumericMap) {
                double stride = ((StringToNumericMap)map).getStrideValue();
                if (pe.isReversed()) {
                    max = Double.isNaN(viewportMin) ? x + w - 1 : this.innerRegion.width - 1 - (int)(stride * (viewportMin - 1.0)) + this.innerRegion.x;
                    min = Double.isNaN(viewportMax) ? x : this.innerRegion.width - 1 - (int)(stride * (viewportMax - 1.0)) + this.innerRegion.x;
                } else {
                    min = Double.isNaN(viewportMin) ? x : (int)(stride * (viewportMin - 1.0)) + this.innerRegion.x;
                    max = Double.isNaN(viewportMax) ? x + w - 1 : (int)(stride * (viewportMax - 1.0)) + this.innerRegion.x;
                }
            }
            min = Math.max(min, x);
            max = Math.min(max, x + w - 1);
            g.fillRect(x, y, min - x, h);
            g.fillRect(max, y, x + w - max, h);
            g.setColor(this.parentAxis.getAxisStyle().getAxisLineColor());
            int[] px = new int[]{x, x, min, min, max, max, x + w - 1, x + w - 1};
            int[] py = new int[]{y - (int)this.parentAxisSize, y, y, y + h, y + h, y, y, y - (int)this.parentAxisSize};
            g.drawPolyline(px, py, px.length);
        }
    }

    @Override
    public synchronized void drawParts(Graphics g) {
        if (this.channel == null) {
            return;
        }
        if (this.width < 0 || this.height < 0) {
            return;
        }
        if (!this.visible) {
            return;
        }
        this.channel.glPushMatrix();
        if (this.parentAxis.getDimension() == 1 && this.parentAxis.getPrimary()) {
            this.channel.glTranslate(0.0, (double)this.y, 0.0);
        }
        super.drawParts(g);
        this.channel.glPopMatrix();
    }

    private AbstractAxis getAxis(byte dimension, boolean primary) {
        for (int i = 0; i < this.axes.size(); ++i) {
            AbstractAxis a = (AbstractAxis)this.axes.get(i);
            boolean prim = true;
            if (a instanceof VRectAxis) {
                prim = ((VRectAxis)a).getPrimary();
            }
            if (prim != primary || a.getDimension() != dimension) continue;
            return a;
        }
        return null;
    }

    private boolean isUpdateEncoderLimitsNeeded() {
        for (int i = 0; i < this.axes.size(); ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            if (!(a.getUserStartOffset() >= 0.0) && !(a.getUserEndOffset() >= 0.0)) continue;
            return true;
        }
        return false;
    }

    private void updateEncoderLimits(Insets om) {
        int x0 = this.x + om.left;
        int y0 = this.y + om.top;
        int x2 = this.x + this.width - om.right;
        int y2 = this.y + this.height - om.bottom;
        x0 = Math.min(x0, x2);
        y0 = Math.min(y0, y2);
        int w = Math.max(0, x2 - x0);
        int h = Math.max(0, y2 - y0);
        int anum = this.axes.size();
        double lowerLim = 0.0;
        double upperLim = 0.0;
        for (int i = 0; i < anum; ++i) {
            VRectAxis a = (VRectAxis)this.axes.get(i);
            PositionEncoder pe = (PositionEncoder)a.getEncoder(a.getDimension());
            if (pe == null) continue;
            byte dim = a.getDimension();
            if (dim == 1) {
                if (a.getPrimary()) {
                    lowerLim = 0 - this.innerMargin.left;
                    upperLim = w - this.innerMargin.left;
                } else {
                    lowerLim = 0 - this.innerMargin2.left;
                    upperLim = w - this.innerMargin2.left;
                }
            } else if (dim == 2) {
                if (a.getPrimary()) {
                    lowerLim = 0 - this.innerMargin.bottom;
                    upperLim = h - this.innerMargin.bottom;
                } else {
                    lowerLim = 0 - this.innerMargin2.bottom;
                    upperLim = h - this.innerMargin2.bottom;
                }
            }
            pe.setLowerLimit(lowerLim);
            pe.setUpperLimit(upperLim);
        }
    }
}

