/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.axis;

import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.axis.RB;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.range.BinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListenerList;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AxisStyle;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Vector;

public abstract class AbstractAxis
implements DataRangeInterface,
RangeChangeListener {
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final int NATURAL_LOG = 2;
    public static final int PI_LOG = 3;
    public static final int PARTIAL_LOG = 4;
    public static final int TIME = 5;
    public static final int DISCRETE = 6;
    public static final int AUTO = -1;
    public static final int DATA = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int ASCENDING_UNFORMATTED = 3;
    public static final int ASCENDING_FORMATTED = 4;
    public static final int DESCENDING_UNFORMATTED = 5;
    public static final int DESCENDING_FORMATTED = 6;
    protected boolean reverse = false;
    protected int tickValueOrder = -1;
    protected boolean sortTickValueByOverlay = false;
    protected int type = 0;
    protected byte dimension;
    protected RangeChangeListenerList rcList = new RangeChangeListenerList();
    protected AxisStyle axisStyle = new AxisStyle();
    protected boolean visible = true;
    protected DataRange inputRange;
    protected DataRange outputRange;
    protected DataRange useRange;
    protected String useTitle = "";
    protected String shortTitle = "";
    protected boolean tickValuePriority = false;
    protected boolean dynamic = false;
    protected double viewportMin = Double.NaN;
    protected double viewportMax = Double.NaN;
    protected double origin = Double.NaN;
    protected boolean labelOrigin = false;
    protected Vector sortedTickValues = null;

    public abstract void setChannel(Channel var1);

    public void rangeChanged(RangeChangedEvent e) {
        ContinuousRange cr;
        DataRange range = e.getRange();
        if (e.getDimension() != this.dimension) {
            return;
        }
        if (e.getType() == 1) {
            this.inputRange = range;
        } else if (e.getType() == 2) {
            this.inputRange = null;
        } else if (e.getType() == 3) {
            this.inputRange = e.getNewRange();
        }
        if (!Double.isNaN(this.origin) && this.inputRange != null) {
            cr = null;
            if (this.inputRange instanceof ContinuousRange) {
                cr = (ContinuousRange)this.inputRange;
            } else if (this.inputRange instanceof BinnedRange) {
                cr = (ContinuousRange)((BinnedRange)this.inputRange).getDual();
            }
            if (cr != null) {
                if (this.origin < cr.getMin()) {
                    cr.setMin(this.origin);
                }
                if (this.origin > cr.getMax()) {
                    cr.setMax(this.origin);
                }
            }
        }
        if (!this.dynamic && !this.tickValuePriority && this.inputRange != null) {
            cr = null;
            if (this.inputRange instanceof ContinuousRange) {
                cr = (ContinuousRange)this.inputRange;
            } else if (this.inputRange instanceof BinnedRange) {
                cr = (ContinuousRange)((BinnedRange)this.inputRange).getDual();
                cr.setLabel(this.inputRange.getLabel());
                cr.setFormat(((BinnedRange)this.inputRange).getFormat());
            }
            if (cr != null) {
                if (!Double.isNaN(this.viewportMin)) {
                    if (cr.getMin() <= 0.0 && this.getType() == 1) {
                        this.setType(0);
                        ((VRectAxis)this).setTicks(null);
                        ((VRectAxis)this).setTickLabeling("THIN");
                        StatGraph.printNote(RB.getStringResource("VRectAxis.", "logToLinear.txt"));
                        this.viewportMin = Double.NaN;
                        this.viewportMax = Double.NaN;
                    } else {
                        cr.setMin(this.viewportMin);
                        this.inputRange = cr;
                    }
                }
                if (!Double.isNaN(this.viewportMax)) {
                    if (cr.getMin() <= 0.0 && this.getType() == 1) {
                        this.setType(0);
                        ((VRectAxis)this).setTicks(null);
                        ((VRectAxis)this).setTickLabeling("THIN");
                        StatGraph.printNote(RB.getStringResource("VRectAxis.", "logToLinear.txt"));
                        this.viewportMin = Double.NaN;
                        this.viewportMax = Double.NaN;
                    } else {
                        cr.setMax(this.viewportMax);
                        this.inputRange = cr;
                    }
                }
            }
        }
        this.updateOutputRange();
    }

    public void removeRangeChangeListener(RangeChangeListener l) {
        this.rcList.remove(l);
    }

    public void addRangeChangeListener(RangeChangeListener l) {
        this.rcList.add(l);
    }

    public DataRange getDataRange(byte dimension) {
        if (dimension != this.dimension) {
            return null;
        }
        return this.outputRange;
    }

    public abstract Encoder getEncoder(byte var1);

    public abstract void setEncoder(byte var1, Encoder var2);

    public void setInputDataRange(DataRange range) {
        this.inputRange = range;
        this.updateOutputRange();
    }

    public DataRange getInputDataRange() {
        return this.inputRange;
    }

    public abstract void updateOutputRange();

    public abstract Insets getExtent();

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getTickValueOrder() {
        return this.tickValueOrder;
    }

    public void setTickValueOrder(int order) {
        this.tickValueOrder = order;
    }

    public boolean isSortTickValueByOverlay() {
        return this.sortTickValueByOverlay;
    }

    public void setSortTickValueByOverlay(boolean b) {
        this.sortTickValueByOverlay = b;
    }

    public void copySortedTickValues() {
        if (this.sortTickValueByOverlay && this.inputRange instanceof DiscreteRange) {
            this.sortedTickValues = ((DiscreteRange)this.inputRange).getValues();
        }
    }

    public String[] getSortedTickValues() {
        String[] v = new String[this.sortedTickValues.size()];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (String)this.sortedTickValues.get(i);
        }
        return v;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean b) {
        this.reverse = b;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public byte getDimension() {
        return this.dimension;
    }

    public void setDimension(byte aDimension) {
        this.dimension = aDimension;
    }

    public AxisStyle getAxisStyle() {
        return this.axisStyle;
    }

    public void setAxisStyle(AxisStyle aAxisStyle) {
        this.axisStyle = aAxisStyle;
    }

    public DataRange getUseRange() {
        return this.useRange;
    }

    public void setUseRange(DataRange aUseRange) {
        this.useRange = aUseRange;
        this.updateOutputRange();
    }

    public void setUseRange(DataRange aUseRange, boolean update) {
        this.useRange = aUseRange;
        if (update) {
            this.updateOutputRange();
        }
    }

    public String getUseTitle() {
        return this.useTitle;
    }

    public void setUseTitle(String title) {
        this.useTitle = title;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public void setShortTitle(String title) {
        this.shortTitle = title;
    }

    public double getOrigin() {
        return this.origin;
    }

    public void setOrigin(double o) {
        this.origin = o;
    }

    public boolean isLabelOrigin() {
        return this.labelOrigin;
    }

    public void setLabelOrigin(boolean b) {
        this.labelOrigin = b;
    }

    public abstract void draw(Graphics var1);

    public double getViewportMin() {
        return this.viewportMin;
    }

    public void setViewportMin(double vmin) {
        this.viewportMin = vmin;
    }

    public double getViewportMax() {
        return this.viewportMax;
    }

    public void setViewportMax(double vmax) {
        this.viewportMax = vmax;
    }

    public void setViewport(double min, double max) {
        if (this.inputRange == null) {
            return;
        }
        ContinuousRange cr = null;
        if (this.inputRange instanceof ContinuousRange) {
            cr = (ContinuousRange)this.inputRange;
        } else if (this.inputRange instanceof BinnedRange) {
            cr = (ContinuousRange)((BinnedRange)this.inputRange).getDual();
        }
        boolean update = false;
        if (cr != null) {
            if (!Double.isNaN(min)) {
                this.viewportMin = min;
                if (cr.getMin() <= 0.0 && this.getType() == 1) {
                    this.setType(0);
                    ((VRectAxis)this).setTicks(null);
                    ((VRectAxis)this).setTickLabeling("THIN");
                    StatGraph.printNote(RB.getStringResource("VRectAxis.", "logToLinear.txt"));
                }
                cr.setMin(this.viewportMin);
                update = true;
            }
            if (!Double.isNaN(max)) {
                this.viewportMax = max;
                cr.setMax(this.viewportMax);
                update = true;
            }
        }
        if (update) {
            this.setUseRange(null, false);
            this.updateOutputRange();
        }
    }
}

