/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.WaterfallChartOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WaterFallChartParser {
    protected static final String SHOW_BAR_LABELS = "barLabel";
    protected static final String BAR_LABEL_FORMAT = "barLabelFormat";
    protected static final String BAR_WIDTH_PERCENTAGE = "barWidth";
    protected static final String INITIAL_BAR_TICKVALUE = "initialBarTickValue";
    protected static final String INITIAL_BAR_VALUE = "initialBarValue";
    protected static final String FINAL_BAR_TICKVALUE = "finalBarTickValue";
    protected static final String BASELINE_INTERCEPT = "baselineIntercept";
    protected static final String DATA_TRANSPARENCY = "dataTransparency";
    protected static final String RESPONSE_STATISTIC = "stat";
    protected static final String RESPONSE_STATISTIC_SUM_STRING = "SUM";
    protected static final String RESPONSE_STATISTIC_MEAN_STRING = "MEAN";
    protected static final String COLOR_RESPONSE_STATISTIC = "colorStat";
    protected static final String TRENDLINE_POLICY = "connect";
    protected static final String TREND_TO_END_POLICY = "end";
    protected static final String TREND_TO_START_POLICY = "start";
    protected static final String BAR_COLOR_POLICY = "barColorPolicy";
    protected static final String STYLE_ELEMENT_BAR_INITIAL = "initialBarAttrs";
    protected static final String STYLE_ELEMENT_BAR_TRANSACTION = "fillAttrs";
    protected static final String STYLE_ELEMENT_BAR_FINAL = "finalBarAttrs";
    protected static final String STYLE_ELEMENT_BAR_LABEL = "barLabelAttrs";
    protected static final String STYLE_ELEMENT_BAR_OUTLINE = "outlineAttrs";
    protected static final String STYLE_ELEMENT_TRENDLINE = "connectAttrs";
    protected static final String STYLE_ELEMENT_TRENDLINE_INCREASING = "connectIncreasingAttrs";
    protected static final String STYLE_ELEMENT_TRENDLINE_DECREASING = "connectDecreasingAttrs";
    protected static final String STYLE_ELEMENT_COLOR_MODEL = "colorModel";
    protected static final String DISPLAY = "display";
    protected static final String CATEGORY_ROLE = "category";
    protected static final String RESPONSE_ROLE = "response";
    public static final String RB_KEY = "WaterfallParser.";

    public static WaterfallChartOverlay load(StatGraph graph, Element elem) {
        WaterfallChartOverlay plot = (WaterfallChartOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new WaterfallChartOverlay();
        }
        return WaterFallChartParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, WaterfallChartOverlay plot, Element element) {
        String attributeValue;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = WaterFallChartParser.setupDataModelAndRoles(plot, graph, element, map);
        if (m == null) {
            return false;
        }
        LayoutOverlayParser.parseGraphOpts(graph, element, plot);
        StatGraph.parseURLOpt(element, m, map, plot);
        String str = "";
        if (element.hasAttribute("colorResponse")) {
            str = element.getAttribute("colorResponse");
            String colorResponseVarID = StatGraph.getVarID(str);
            if (StatGraph.isOLAP()) {
                map.map(108, colorResponseVarID);
            } else {
                int colorResponseCol = m.getColumn(colorResponseVarID);
                if (!StatGraph.checkVariable("colorResponse", m.getColumnLabel(colorResponseCol), Double.class, 1, false)) {
                    return false;
                }
                map.map(108, colorResponseCol);
                plot.addRole("COLORRESPONSE", m.getColumnLabel(colorResponseCol));
            }
            str = element.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                plot.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
            }
        } else if (element.hasAttribute("colorGroup")) {
            str = element.getAttribute("colorGroup");
            String groupVarID = StatGraph.getVarID(str);
            int groupCol = m.getColumn(groupVarID);
            if (!StatGraph.checkVariable("colorGroup", m.getColumnLabel(groupCol), null, 1, false)) {
                return false;
            }
            map.map(107, groupCol);
            plot.addRole("COLORGROUP", m.getColumnLabel(groupCol));
            str = element.getAttribute("colorGroupAttrVar");
            if (str.length() > 0) {
                plot.addAttrVar("COLORGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                String originalGroup = element.hasAttribute("_originalColorGroup") ? element.getAttribute("_originalColorGroup") : groupVarID;
                DAMDatasetParser.addInternalAttrVar(graph, plot, "COLORGROUP", originalGroup);
            }
            if (graph.isCASData()) {
                plot.setGroupOrder(1);
            }
        }
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        if (element.hasAttribute("primary")) {
            attributeValue = element.getAttribute("primary");
            plot.setPrimary(attributeValue.equalsIgnoreCase("true"));
        }
        if (!(attributeValue = element.getAttribute(DATA_TRANSPARENCY)).equals("")) {
            double transparency = Double.parseDouble(attributeValue);
            plot.setInitialBarTransparency(transparency);
            plot.setTransactionBarTransparency(transparency);
            plot.setFinalBarTransparency(transparency);
            plot.setDataTransparency(transparency);
        }
        if (element.hasAttribute("fillType")) {
            attributeValue = element.getAttribute("fillType");
            if ("Gradient".equalsIgnoreCase(attributeValue)) {
                plot.setFillType(2);
            } else {
                if (!"Solid".equalsIgnoreCase(attributeValue)) {
                    Message msg = new Message(RB.getStringResource("StatGraph.option.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"FILLTYPE", (Object)attributeValue));
                }
                plot.setFillType(1);
            }
        }
        if (element.hasAttribute("connectBreak") && "TRUE".equalsIgnoreCase(attributeValue = element.getAttribute("connectBreak"))) {
            plot.setConnectSkipMiss(true);
        }
        Element barLabelStyleElement = null;
        String elementTag = "";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elementTag = ((Element)node).getTagName()).equals("BarLabelAttrs")) continue;
            barLabelStyleElement = (Element)node;
        }
        FillAttrs initialBarFillAttrs = plot.getInitialBarFillAttrs();
        WaterFallChartParser.parseFillAttrs(graph, element, STYLE_ELEMENT_BAR_INITIAL, "InitialBarAttrs", "Initial", initialBarFillAttrs);
        FillAttrs transactionBarFillAttrs = plot.getTransactionBarFillAttrs();
        WaterFallChartParser.parseFillAttrs(graph, element, STYLE_ELEMENT_BAR_TRANSACTION, "FillAttrs", contextName, transactionBarFillAttrs);
        Element fe = StatGraph.getOptionAttrsElement(element, "FillAttrs");
        if (element.hasAttribute(STYLE_ELEMENT_BAR_TRANSACTION) || fe != null && fe.hasAttribute("color")) {
            plot.setFillColorOverride(true);
        }
        plot.setUseFillTransparency(StatGraph.isTransparencyFixed(element, fe));
        FillAttrs finalBarFillAttrs = plot.getFinalBarFillAttrs();
        WaterFallChartParser.parseFillAttrs(graph, element, STYLE_ELEMENT_BAR_FINAL, "FinalBarAttrs", "Final", finalBarFillAttrs);
        FillAttrs barIncreasingFillAttrs = plot.getBarIncreasingFillAttrs();
        WaterFallChartParser.parseFillAttrs(graph, element, "barIncreasingAttrs", "BarIncreasingAttrs", "GraphDataStyle1", barIncreasingFillAttrs);
        FillAttrs barDecreasingFillAttrs = plot.getBarDecreasingFillAttrs();
        WaterFallChartParser.parseFillAttrs(graph, element, "barDecreasingAttrs", "BarDecreasingAttrs", "GraphDataStyle2", barDecreasingFillAttrs);
        if (element.hasAttribute("barIncreasingLegendLabel")) {
            plot.setBarIncreasingLegendLabel(element.getAttribute("barIncreasingLegendLabel"));
        }
        if (element.hasAttribute("barDecreasingLegendLabel")) {
            plot.setBarDecreasingLegendLabel(element.getAttribute("barDecreasingLegendLabel"));
        }
        if (element.hasAttribute("colorByResponseSign") && "true".equalsIgnoreCase(element.getAttribute("colorByResponseSign"))) {
            plot.setColorByResponseSign(true);
        }
        LineAttrs barOutlineAttrs = plot.getBarOutlineAttrs();
        Element le = StatGraph.getOptionAttrsElement(element, "OutlineAttrs");
        WaterFallChartParser.parseLineAttrs(graph, element, STYLE_ELEMENT_BAR_OUTLINE, "OutlineAttrs", "Outlines", barOutlineAttrs);
        if (element.hasAttribute(STYLE_ELEMENT_BAR_OUTLINE) || le != null && le.hasAttribute("color")) {
            plot.setOutlineColorOverride(true);
        }
        LineAttrs trendlineAttrs = plot.getTrendlineAttrs();
        WaterFallChartParser.parseLineAttrs(graph, element, STYLE_ELEMENT_TRENDLINE, "ConnectAttrs", "Outlines", trendlineAttrs);
        WaterFallChartParser.parseLineAttrs(graph, element, STYLE_ELEMENT_TRENDLINE, "ConnectAttrs", "Outlines", plot.getTrendlineIncreasingAttrs());
        Element tIA = StatGraph.getOptionAttrsElement(element, "ConnectIncreasingAttrs");
        if (element.hasAttribute(STYLE_ELEMENT_TRENDLINE_INCREASING) || tIA != null) {
            WaterFallChartParser.parseOverrideLineAttrs(graph, element, STYLE_ELEMENT_TRENDLINE_INCREASING, "ConnectIncreasingAttrs", "Outlines", plot.getTrendlineIncreasingAttrs());
        }
        WaterFallChartParser.parseLineAttrs(graph, element, STYLE_ELEMENT_TRENDLINE, "ConnectAttrs", "Outlines", plot.getTrendlineDecreasingAttrs());
        Element tDA = StatGraph.getOptionAttrsElement(element, "ConnectDecreasingAttrs");
        if (element.hasAttribute(STYLE_ELEMENT_TRENDLINE_INCREASING) || tDA != null) {
            WaterFallChartParser.parseOverrideLineAttrs(graph, element, STYLE_ELEMENT_TRENDLINE_DECREASING, "ConnectDecreasingAttrs", "Outlines", plot.getTrendlineDecreasingAttrs());
        }
        TextStyle barLabelStyle = plot.getBarLabelStyle();
        attributeValue = element.getAttribute(STYLE_ELEMENT_BAR_LABEL);
        GraphStyle.setDefaultTextStyle(graph, attributeValue, barLabelStyle, "DataText");
        if (barLabelStyleElement != null) {
            StatGraph.parseTextAttrs(graph, barLabelStyleElement, barLabelStyle);
        }
        LineAttrs baselineAttrs = plot.getBaseLineAttrs();
        WaterFallChartParser.parseLineAttrs(graph, element, "baselineAttrs", "BaselineAttrs", "AxisLines", baselineAttrs);
        attributeValue = element.getAttribute(BAR_WIDTH_PERCENTAGE);
        if (!attributeValue.equals("")) {
            plot.setBarThicknessAsPercentage(Double.parseDouble(attributeValue));
        }
        if (!(attributeValue = element.getAttribute(SHOW_BAR_LABELS)).equals("")) {
            plot.setShowBarLabels(Boolean.parseBoolean(attributeValue));
            str = element.getAttribute("barLabelFitPolicy");
            if (str.length() > 0 && str.equalsIgnoreCase("none")) {
                plot.setAutoRotateLabel(false);
            } else {
                plot.setAutoRotateLabel(true);
            }
        }
        if ((attributeValue = element.getAttribute(TRENDLINE_POLICY)).equalsIgnoreCase(TREND_TO_START_POLICY)) {
            plot.setTrendlineType(0);
        } else if (attributeValue.equalsIgnoreCase(TREND_TO_END_POLICY)) {
            plot.setTrendlineType(1);
        }
        attributeValue = element.getAttribute(INITIAL_BAR_VALUE);
        if (!attributeValue.equalsIgnoreCase("")) {
            plot.setInitialBarValue(Double.parseDouble(attributeValue));
        }
        if (!(attributeValue = element.getAttribute(INITIAL_BAR_TICKVALUE)).equalsIgnoreCase("")) {
            plot.setInitialBarTickmarkLabel(attributeValue);
        }
        if (!(attributeValue = element.getAttribute(FINAL_BAR_TICKVALUE)).equalsIgnoreCase("")) {
            plot.setFinalBarTickmarkLabel(attributeValue);
        }
        if (!(attributeValue = element.getAttribute(BASELINE_INTERCEPT)).equalsIgnoreCase("")) {
            try {
                double intercept = Double.parseDouble(attributeValue);
                plot.setBaselineIntercept(intercept);
            }
            catch (NumberFormatException e) {
                Message msg = new Message(RB.getStringResource("StatGraph.option.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"BASELINEINTERCEPT", (Object)attributeValue));
            }
        }
        if ((attributeValue = element.getAttribute(RESPONSE_STATISTIC)).equalsIgnoreCase(RESPONSE_STATISTIC_SUM_STRING)) {
            plot.setResponseStatistic(6);
        } else if (attributeValue.equalsIgnoreCase(RESPONSE_STATISTIC_MEAN_STRING)) {
            plot.setResponseStatistic(1);
        }
        attributeValue = element.getAttribute(COLOR_RESPONSE_STATISTIC);
        if (attributeValue.equalsIgnoreCase(RESPONSE_STATISTIC_SUM_STRING)) {
            plot.setColorResponseStatistic(6);
        } else if (attributeValue.equalsIgnoreCase(RESPONSE_STATISTIC_MEAN_STRING)) {
            plot.setColorResponseStatistic(1);
        }
        StatGraph.parseDataSkinOpt(graph, element, plot);
        attributeValue = element.getAttribute(DISPLAY);
        if (!attributeValue.equalsIgnoreCase("")) {
            plot.setDisplayMode(attributeValue);
        }
        if (!(attributeValue = element.getAttribute("initialBarCategoryValue")).equalsIgnoreCase("")) {
            plot.setInitialBarCategoryValue(attributeValue);
        }
        LayoutOverlayParser.parseRoleTipStuff(element, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        if (!StatGraph.isOLAP()) {
            SASFormat responseVarFormat = null;
            SASFormat fmt = null;
            ColumnMetadata cmd = (ColumnMetadata)crd.getColumnLabel(2);
            if (cmd.getFormat() != null) {
                responseVarFormat = cmd.getFormat();
            }
            if (element.hasAttribute(BAR_LABEL_FORMAT)) {
                attributeValue = element.getAttribute(BAR_LABEL_FORMAT);
                fmt = SASFormat.getInstance((String)attributeValue);
            }
            if (fmt != null) {
                plot.setBarLabelFormat(fmt);
            } else if (responseVarFormat != null) {
                if (responseVarFormat.getFormatDescription().isDecimalWidthSupported()) {
                    int w = responseVarFormat.getFormatDescription().getMaxWidth();
                    int d = responseVarFormat.getDecimalWidth();
                    SASFormat rfmt = SASFormat.getInstance((String)(responseVarFormat.getBaseFormatName() + Integer.toString(w).trim() + "." + Integer.toString(d).trim()));
                    rfmt.setInsertBlanks(false);
                    plot.setBarLabelFormat(rfmt);
                } else {
                    plot.setBarLabelFormat(responseVarFormat);
                }
            } else {
                plot.setBarLabelFormat(DataModel.defaultFormat);
            }
        }
        LayoutOverlayParser.parseWhere(graph, crd, plot);
        attributeValue = element.getAttribute("dataSelectable");
        if (attributeValue.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        String defaultRamp = "ThreeColorRamp";
        str = element.getAttribute(STYLE_ELEMENT_COLOR_MODEL);
        Color[] ramp = graph.style.getRampColors(str, defaultRamp);
        plot.setNeutralColor(ramp[1]);
        plot.setModel(crd);
        graph.style.recordCurrentCounters();
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(graph.style.getContextCount());
        }
        if (crd.isAvailable(108)) {
            ColorEncoder encoder = null;
            encoder = transactionBarFillAttrs != null && transactionBarFillAttrs.getTransparency() >= 0.0 ? StatGraph.parseColorModelOpt((byte)4, graph, element, plot, transactionBarFillAttrs.getTransparency()) : StatGraph.parseColorModelOpt((byte)4, graph, element, plot);
            if (encoder != null) {
                plot.setEncoder((byte)4, encoder);
                plot.setNeutralColor(encoder.mediumColor);
            }
        } else if (crd.isAvailable(107)) {
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)4, (short)107, false);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)17, (short)107, false);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    public static DataModel setupDataModelAndRoles(WaterfallChartOverlay plot, StatGraph graph, Element element, RoleColumnMap map) {
        String tempString = element.getAttribute(CATEGORY_ROLE);
        String dataName = StatGraph.getDataName(tempString);
        String categoryVariableID = StatGraph.getVarID(tempString);
        tempString = element.getAttribute(RESPONSE_ROLE);
        String responseVariableID = StatGraph.getVarID(tempString);
        DataModel model = graph.getOLAPModel(dataName);
        if (model != null) {
            map.map(1, categoryVariableID);
            map.map(2, responseVariableID);
            return model;
        }
        model = graph.getData(dataName);
        int categoryColumn = model.getColumn(categoryVariableID);
        int responseColumn = model.getColumn(responseVariableID);
        if (!StatGraph.checkVariable(CATEGORY_ROLE, model.getColumnLabel(categoryColumn), null, 1, true) || !StatGraph.checkVariable(RESPONSE_ROLE, model.getColumnLabel(responseColumn), Double.class, 1, true)) {
            return null;
        }
        map.map(1, categoryColumn);
        map.map(2, responseColumn);
        plot.addRole("CATEGORY", model.getColumnLabel(categoryColumn));
        plot.addRole("RESPONSE", model.getColumnLabel(responseColumn));
        LayoutOverlayParser.parseRoleTipStuff(element, model, map, plot);
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int type;
        int[] types = new int[3];
        String attributeValue = elem.getAttribute(RESPONSE_ROLE);
        String dataName = StatGraph.getDataName(attributeValue);
        DataModel model = graph.getData(dataName);
        if (model == null) {
            types[0] = 2;
            types[1] = 0;
            types[2] = 0;
            return types;
        }
        String responseVariableID = StatGraph.getVarID(attributeValue);
        if (responseVariableID.length() > 0) {
            int responseColumnIndex = model.getColumn(responseVariableID);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(responseColumnIndex);
            if (cmd.getType() == 2) {
                return null;
            }
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        } else {
            type = 0;
        }
        attributeValue = elem.getAttribute(CATEGORY_ROLE);
        String categoryVariableID = StatGraph.getVarID(attributeValue);
        if (LayoutOverlayParser.hasTooManyCategories(graph, model, categoryVariableID)) {
            return null;
        }
        attributeValue = elem.getAttribute("orient");
        if (attributeValue.equalsIgnoreCase("Horizontal")) {
            types[0] = type;
            types[1] = 2;
        } else {
            types[0] = 2;
            types[1] = type;
        }
        types[2] = 0;
        return types;
    }

    private static FillAttrs parseFillAttrs(StatGraph graph, Element elem, String attrName, String attrElemName, String defaultStyleElem, FillAttrs fa) {
        if (fa == null) {
            fa = new FillAttrs();
        }
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute(attrName), fa, defaultStyleElem);
        Element fe = StatGraph.getOptionAttrsElement(elem, attrElemName);
        if (fe != null) {
            StatGraph.parseFillAttrs(graph, fe, fa);
        }
        return fa;
    }

    private static LineAttrs parseLineAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, LineAttrs la) {
        if (la == null) {
            la = new LineAttrs();
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute(attrName), la, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseLineAttrs(graph, le, la);
        }
        return la;
    }

    private static LineAttrs parseOverrideLineAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, LineAttrs la) {
        Element le;
        if (elem.hasAttribute(attrName)) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute(attrName), la, defaultStyleElem);
        }
        if ((le = StatGraph.getOptionAttrsElement(elem, attrElem)) != null) {
            StatGraph.parseLineAttrs(graph, le, la);
        }
        return la;
    }
}

