/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class VectorParser {
    public static final String RB_KEY = "VectorParser.";

    public static ScatterOverlay load(StatGraph graph, Element elem) {
        ScatterOverlay plot = (ScatterOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new ScatterOverlay(4);
        }
        return VectorParser.load(graph, plot, elem) ? plot : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean load(StatGraph graph, ScatterOverlay plot, Element elem) {
        CRD crd;
        boolean labelingEnabled;
        boolean labelVisible;
        Element labelElem;
        boolean gradientVectorColor;
        String groupVarID;
        String str;
        block82: {
            block81: {
                block83: {
                    block84: {
                        String indexVarID;
                        int ii;
                        int crcol;
                        int col;
                        String thicknessVarID;
                        graph.addSupportedGraph();
                        RoleColumnMap map = new RoleColumnMap();
                        DataModel m = ScatterParser.parseXYVariables(plot, graph, elem, map);
                        if (m == null) {
                            return false;
                        }
                        str = elem.getAttribute("primary");
                        plot.setPrimary(str.equalsIgnoreCase("true"));
                        LayoutOverlayParser.parseGraphOpts(graph, elem, plot);
                        str = elem.getAttribute("group");
                        groupVarID = StatGraph.getVarID(str);
                        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID, plot.getStmt())) {
                            groupVarID = "";
                        }
                        if ((thicknessVarID = StatGraph.getVarID(str = elem.getAttribute("lineThicknessResponse"))).length() > 0 && StatGraph.checkVariable("LINETHICKNESSRESPONSE", m.getColumnLabel(col = m.getColumn(thicknessVarID)), Double.class, 1, false)) {
                            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(col);
                            if (cmd.getMax() > 0.0) {
                                double d;
                                map.map(119, col);
                                plot.addRole("THICKNESS", m.getColumnLabel(col));
                                LineAttrs la = new LineAttrs();
                                GraphStyle.setDefaultDataLineStyle(graph, "", la, "GraphDataStyleDefault");
                                double minThickness = la.getWidth();
                                double maxThickness = 10.0 * minThickness;
                                str = elem.getAttribute("lineThicknessMaxResponse");
                                if (StatGraph.isNumber(str)) {
                                    plot.setThicknessMaxResponse(Double.parseDouble(str));
                                }
                                if (StatGraph.isNumber(str = elem.getAttribute("lineThicknessMax")) && (d = (double)graph.unit2LineThickness(str)) >= 0.0) {
                                    maxThickness = d;
                                }
                                if (StatGraph.isNumber(str = elem.getAttribute("lineThicknessMin")) && (d = (double)graph.unit2LineThickness(str)) >= 0.0) {
                                    minThickness = d;
                                }
                                if (minThickness > maxThickness) {
                                    StatGraph.printNote(RB.getStringResource(RB_KEY, "thicknessminmax.txt"));
                                    minThickness = la.getWidth();
                                    maxThickness = 10.0 * minThickness;
                                }
                                plot.setMaxThickness(maxThickness);
                                plot.setMinThickness(minThickness);
                            } else {
                                StatGraph.printNote(RB.getStringResource(RB_KEY, "thicknessresponse.txt"));
                            }
                        }
                        gradientVectorColor = false;
                        str = elem.getAttribute("colorResponse");
                        String crVarID = StatGraph.getVarID(str);
                        if (crVarID.length() > 0 && StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
                            gradientVectorColor = true;
                            map.map(46, crcol);
                            plot.addRole("COLORRESPONSE", m.getColumnLabel(crcol));
                            str = elem.getAttribute("colorResponseAttrVar");
                            if (str.length() > 0) {
                                plot.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
                            }
                        }
                        plot.setGradientLineColor(gradientVectorColor);
                        labelElem = null;
                        Element lineElem = null;
                        String elemTag = "";
                        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                            if (!(node instanceof Element)) continue;
                            elemTag = ((Element)node).getTagName();
                            if (elemTag.equals("DataLabelAttrs")) {
                                labelElem = (Element)node;
                                continue;
                            }
                            if (!elemTag.equals("LineAttrs")) continue;
                            lineElem = (Element)node;
                        }
                        String lineAttr = elem.getAttribute("lineAttrs");
                        if (groupVarID.length() > 0) {
                            int gcol = m.getColumn(groupVarID);
                            if (!(gradientVectorColor || lineElem != null && lineElem.hasAttribute("color") || lineAttr.length() != 0)) {
                                map.map(46, gcol);
                            }
                            if (!(lineElem != null && lineElem.hasAttribute("pattern") || lineAttr.length() != 0)) {
                                map.map(36, gcol);
                            }
                            map.map(3, gcol);
                            plot.addRole("GROUP", m.getColumnLabel(gcol));
                            if (map.isRoleMapped(36) || map.isRoleMapped(46)) {
                                str = elem.getAttribute("groupAttrVar");
                                if (str.length() > 0) {
                                    plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                                } else {
                                    DAMDatasetParser.addInternalAttrVar(graph, plot, "GROUP", groupVarID);
                                }
                            }
                            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                                plot.setMissingGroupOn(false);
                            }
                            if (graph.isCASData()) {
                                plot.setGroupOrder(1);
                                plot.setDrawByGroupOrder(true);
                            }
                        }
                        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                            if (map.isRoleMapped(46)) {
                                map.map(41, ii);
                            }
                            if (map.isRoleMapped(36)) {
                                map.map(43, ii);
                            }
                            plot.addRole("INDEX", m.getColumnLabel(ii));
                        }
                        str = elem.getAttribute("dataLabel");
                        String labelVarID = StatGraph.getVarID(str);
                        labelVisible = false;
                        labelingEnabled = false;
                        if (labelVarID.length() > 0) {
                            int lcol = m.getColumn(labelVarID);
                            map.map(5, lcol);
                            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(lcol);
                            int nms = cmd.getNobs() - cmd.getMissings();
                            if (nms == 0) {
                                labelVisible = false;
                                labelingEnabled = false;
                            } else {
                                Message msg;
                                labelVisible = true;
                                boolean bl = labelingEnabled = nms <= graph.labelingThreshold;
                                if (!labelingEnabled) {
                                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(nms))), false);
                                } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                                    labelingEnabled = false;
                                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(cmd.getNobs()))), false);
                                }
                            }
                            plot.addRole("DATALABEL", m.getColumnLabel(lcol));
                        }
                        if (StatGraph.isNumber(str = elem.getAttribute("xOrigin"))) {
                            plot.setVectorXOrigin(Double.parseDouble(str));
                        } else if (str.length() > 0 && StatGraph.isValidVar(str)) {
                            String xOriginVarID = StatGraph.getVarID(str);
                            int xcol = m.getColumn(xOriginVarID);
                            if (!StatGraph.checkVariable("XORIGIN", m.getColumnLabel(xcol), Double.class, 1, true)) {
                                graph.removeNamedGraph(plot);
                                return false;
                            }
                            map.map(37, xcol);
                            plot.addRole("XORIGIN", m.getColumnLabel(xcol));
                        } else {
                            Message msg = new Message(RB.getStringResource(RB_KEY, "xorigin.fmt.txt"));
                            StatGraph.printWarning(msg.toString((Object)str));
                            graph.removeNamedGraph(plot);
                            return false;
                        }
                        str = elem.getAttribute("yOrigin");
                        if (StatGraph.isNumber(str)) {
                            plot.setVectorYOrigin(Double.parseDouble(str));
                        } else if (str.length() > 0 && StatGraph.isValidVar(str)) {
                            String yOriginVarID = StatGraph.getVarID(str);
                            int ycol = m.getColumn(yOriginVarID);
                            if (!StatGraph.checkVariable("YORIGIN", m.getColumnLabel(ycol), Double.class, 1, true)) {
                                graph.removeNamedGraph(plot);
                                return false;
                            }
                            map.map(38, ycol);
                            plot.addRole("YORIGIN", m.getColumnLabel(ycol));
                        } else {
                            Message msg = new Message(RB.getStringResource(RB_KEY, "yorigin.fmt.txt"));
                            StatGraph.printWarning(msg.toString((Object)str));
                            graph.removeNamedGraph(plot);
                            return false;
                        }
                        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
                        crd = new CRD();
                        crd.setSrcModel(m);
                        crd.setSrcMap(map);
                        LayoutOverlayParser.parseWhere(graph, crd, plot);
                        str = elem.getAttribute("clip");
                        if (str.equalsIgnoreCase("true")) {
                            plot.setVectorClipped(true);
                        }
                        if (StatGraph.isNumber(str = elem.getAttribute("scale"))) {
                            plot.setVectorScale(Float.parseFloat(str));
                        }
                        if ((str = elem.getAttribute("dataSelectable")).length() > 0 && str.equalsIgnoreCase("true")) {
                            plot.setDataSelectable(true);
                        }
                        StatGraph.parseDataSkinOpt(graph, elem, plot);
                        if (plot.getSkinType() == 3) {
                            plot.setSkinType(0);
                        }
                        if (!map.isRoleMapped(119) && (lineAttr.length() > 0 || lineElem != null && lineElem.hasAttribute("thickness"))) {
                            plot.setUseLineThickness(true);
                        } else {
                            plot.setUseLineThickness(false);
                        }
                        if (plot.isTooltipEnabled()) {
                            plot.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
                        }
                        plot.setModel(crd);
                        if (!plot.isDataValid()) {
                            graph.removeNamedGraph(plot);
                            StatGraph.printWarning(RB.getStringResource("SeriesParser.", "zerothickness.txt"));
                            return false;
                        }
                        String contextName = graph.style.getContextName();
                        plot.setContextName(contextName);
                        GraphStyle.setDefaultDataLineStyle(graph, lineAttr, plot.getLineStyle(), contextName);
                        if (lineElem != null) {
                            StatGraph.parseLineAttrs(graph, lineElem, plot.getLineStyle());
                        }
                        plot.setVectorVisible(true);
                        short noMarker = -1;
                        plot.setDefaultMarkerShape(noMarker);
                        boolean headOn = true;
                        str = elem.getAttribute("arrowHeads");
                        if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                            plot.setVectorArrowDirection((byte)3);
                            headOn = false;
                        }
                        if (!headOn) break block82;
                        str = elem.getAttribute("arrowDirection");
                        if (str.length() <= 0) break block83;
                        if (!str.equalsIgnoreCase("out")) break block84;
                        plot.setVectorArrowDirection((byte)1);
                        break block81;
                    }
                    if (str.equalsIgnoreCase("in")) {
                        plot.setVectorArrowDirection((byte)0);
                        break block81;
                    } else if (str.equalsIgnoreCase("both")) {
                        plot.setVectorArrowDirection((byte)2);
                        break block81;
                    } else {
                        plot.setVectorArrowDirection((byte)1);
                        StatGraph.printOptionError("ARROWDIRECTION", str);
                    }
                    break block81;
                }
                plot.setVectorArrowDirection((byte)1);
            }
            str = elem.getAttribute("arrowHeadShape");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("OPEN")) {
                    plot.setVectorArrowShape((byte)0);
                } else if (str.equalsIgnoreCase("CLOSED")) {
                    plot.setVectorArrowShape((byte)1);
                } else if (str.equalsIgnoreCase("FILLED")) {
                    plot.setVectorArrowShape((byte)2);
                } else if (str.equalsIgnoreCase("BARBED")) {
                    plot.setVectorArrowShape((byte)3);
                } else {
                    plot.setVectorArrowShape((byte)0);
                    StatGraph.printOptionError("ARROWHEADSHAPE", str);
                }
            }
        }
        if (labelVisible) {
            int position = ScatterParser.parseDataLabelPosition(elem);
            if (position != -1) {
                labelingEnabled = false;
                plot.setFixedDataLabelPosition(position);
                ScatterParser.parseDataLabelSplitting(plot, elem);
            }
            plot.setLabelVisible(true);
            plot.setLabelCollisionAvoidance(labelingEnabled);
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), plot.getLabelStyle(), "DataText");
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(plot.getLineStyle().getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs(graph, labelElem, plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if (graph.isSALabeling()) {
            plot.setProtectedShaft(SALabeling.getWeight(graph.getSAWeightMap(), "OBSTACLE") > 0.0);
        } else {
            str = elem.getAttribute("shaftProtected");
            if (str.equalsIgnoreCase("false")) {
                plot.setProtectedShaft(false);
            } else if (str.equalsIgnoreCase("true")) {
                plot.setProtectedShaft(true);
            } else {
                plot.setProtectedShaft(labelVisible);
            }
        }
        ScatterParser.parseSelectionColor(plot, graph);
        ScatterParser.parseLabelVisibles(plot, elem);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(46)) {
            if (gradientVectorColor) {
                ColorEncoder encoder = StatGraph.parseColorModelOpt((byte)17, graph, elem, plot);
                if (encoder != null) {
                    plot.setEncoder((byte)17, encoder);
                }
            } else {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)17);
            }
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)15);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }
}

