/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.TimeSeriesOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TimeSeriesParser {
    public static final String RB_KEY = "TimeSeriesParser.";

    public static TimeSeriesOverlay load(StatGraph graph, Element elem) {
        TimeSeriesOverlay timeSeries = (TimeSeriesOverlay)graph.getObjectFromElement(elem);
        if (timeSeries == null) {
            timeSeries = new TimeSeriesOverlay();
        }
        return TimeSeriesParser.load(graph, timeSeries, elem) ? timeSeries : null;
    }

    public static boolean load(StatGraph graph, TimeSeriesOverlay timeSeries, Element elem) {
        Node node;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, timeSeries);
        String str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                timeSeries.setLineOn(true);
                timeSeries.setFillOn(true);
                timeSeries.setMarkerOn(true);
            } else {
                timeSeries.setLineOn(false);
                timeSeries.setFillOn(false);
                timeSeries.setMarkerOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("line")) {
                        timeSeries.setLineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        timeSeries.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("markers")) {
                        timeSeries.setMarkerOn(true);
                        continue;
                    }
                    timeSeries.setLineOn(true);
                    timeSeries.setFillOn(false);
                    timeSeries.setMarkerOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            timeSeries.setLineOn(true);
            timeSeries.setFillOn(false);
            timeSeries.setMarkerOn(false);
        }
        String elemTag = "";
        boolean gotGroup = false;
        boolean gotColor = false;
        boolean gotLine = false;
        boolean gotLineColor = false;
        boolean gotShape = false;
        boolean gotShapeColor = false;
        boolean gotShapeFillColor = false;
        boolean gotShapeOutlineColor = false;
        boolean gotShapeOutlineThickness = false;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (timeSeries.isFillOn() && elemTag.equals("FillAttrs") && ((Element)node).hasAttribute("color")) {
                gotColor = true;
                continue;
            }
            if (timeSeries.isLineOn() && elemTag.equals("LineAttrs")) {
                if (((Element)node).hasAttribute("pattern")) {
                    gotLine = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotLineColor = true;
                continue;
            }
            if (!timeSeries.isMarkerOn()) continue;
            if (elemTag.equals("MarkerAttrs")) {
                if (((Element)node).hasAttribute("symbol")) {
                    gotShape = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotShapeColor = true;
                continue;
            }
            if (elemTag.equals("MarkerOutlineAttrs")) {
                if (((Element)node).hasAttribute("thickness")) {
                    gotShapeOutlineThickness = true;
                }
                if (!((Element)node).hasAttribute("color")) continue;
                gotShapeOutlineColor = true;
                continue;
            }
            if (!elemTag.equals("MarkerFillAttrs") || !((Element)node).hasAttribute("color")) continue;
            gotShapeFillColor = true;
        }
        String fillAttr = elem.getAttribute("fillAttrs");
        String lineAttr = elem.getAttribute("lineAttrs");
        String mrkAttr = elem.getAttribute("markerAttrs");
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        str = elem.getAttribute("filledOutlinedMarkers");
        if (str.equalsIgnoreCase("true")) {
            timeSeries.setFilledOutlinedMarker(true);
            if (mrkAttr.length() > 0 || gotShapeColor) {
                timeSeries.setUseMarkerAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || gotShapeOutlineColor) {
                timeSeries.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || gotShapeOutlineThickness) {
                timeSeries.setUseMarkerOutlineAttrsThickness(true);
            }
        }
        str = elem.getAttribute("primary");
        timeSeries.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("time");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        DataModel m = graph.getOLAPModel(dataName);
        if (m == null) {
            m = graph.getData(dataName);
        }
        RoleColumnMap map = new RoleColumnMap();
        if (StatGraph.isOLAP()) {
            map.map(113, xVarID);
        } else {
            int xcol = m.getColumn(xVarID);
            if (!StatGraph.checkVariable("TIME", m.getColumnLabel(xcol), Double.class, 1, true)) {
                graph.removeNamedGraph(timeSeries);
                return false;
            }
            SASFormat fmt = null;
            if (m.getColumnLabel(xcol) instanceof ColumnMetadata) {
                fmt = ((ColumnMetadata)m.getColumnLabel(xcol)).getFormat();
            }
            if (fmt == null || !(fmt instanceof SASDateTimeFormat)) {
                graph.removeNamedGraph(timeSeries);
                return false;
            }
            map.map(113, xcol);
            timeSeries.addRole("TIME", m.getColumnLabel(xcol));
        }
        Element rElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rElem == null || StatGraph.parseStringValueList(rElem, "Value").length == 1) {
            String indexVarID;
            int ii;
            str = rElem == null ? elem.getAttribute("response") : StatGraph.parseStringValueList(rElem, "Value")[0];
            String yVarID = StatGraph.getVarID(str);
            if (yVarID.length() > 0) {
                if (StatGraph.isOLAP()) {
                    map.map(2, yVarID);
                } else {
                    int ycol = m.getColumn(yVarID);
                    if (!StatGraph.checkVariable("RESPONSE", m.getColumnLabel(ycol), Double.class, 1, true)) {
                        graph.removeNamedGraph(timeSeries);
                        return false;
                    }
                    map.map(2, ycol);
                    timeSeries.addRole("RESPONSE", m.getColumnLabel(ycol));
                }
            }
            if ((str = elem.getAttribute("group")).length() > 0) {
                String gVarID = StatGraph.getVarID(str);
                if (StatGraph.isOLAP()) {
                    gotGroup = true;
                    map.map(3, gVarID);
                    map.map(6, gVarID);
                    map.map(36, gVarID);
                    map.map(46, gVarID);
                    map.map(111, gVarID);
                    map.map(112, gVarID);
                } else if (!LayoutOverlayParser.hasTooManyGroups(graph, m, StatGraph.getVarID(str), timeSeries.getStmt())) {
                    gotGroup = true;
                    int gcol = m.getColumn(gVarID);
                    map.map(3, gcol);
                    if (!gotColor && fillAttr.length() == 0) {
                        map.map(6, gcol);
                    }
                    if (!gotLine && lineAttr.length() == 0) {
                        map.map(36, gcol);
                    }
                    if (!gotLineColor && lineAttr.length() == 0) {
                        map.map(46, gcol);
                    }
                    if (!gotShape && mrkAttr.length() == 0) {
                        map.map(8, gcol);
                    }
                    if (!gotShapeColor && mrkAttr.length() == 0) {
                        map.map(45, gcol);
                    }
                    if (timeSeries.isFilledOutlinedMarker()) {
                        if (!map.isRoleMapped(45)) {
                            map.map(45, gcol);
                        }
                        if (!gotShapeFillColor && mrkFillAttr.length() == 0) {
                            map.map(69, gcol);
                        }
                    }
                    timeSeries.addRole("GROUP", m.getColumnLabel(gcol));
                    str = elem.getAttribute("includeMissingGroup");
                    if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                        timeSeries.setMissingGroupOn(false);
                    }
                    if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                        timeSeries.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                    } else {
                        DAMDatasetParser.addInternalAttrVar(graph, timeSeries, "GROUP", gVarID);
                    }
                }
            }
            if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                map.map(44, ii);
                timeSeries.addRole("INDEX", m.getColumnLabel(ii));
            }
        } else {
            String[] multiResponseVars = StatGraph.parseStringValueList(rElem, "Value");
            int cnt = 0;
            for (int i = 0; i < multiResponseVars.length; ++i) {
                str = multiResponseVars[i];
                String yVarID = StatGraph.getVarID(str);
                if (yVarID.length() <= 0) continue;
                if (StatGraph.isOLAP()) {
                    map.map(610 + cnt, yVarID);
                } else {
                    int ycol = m.getColumn(yVarID);
                    if (!StatGraph.checkVariable("RESPONSE", m.getColumnLabel(ycol), Double.class, 1, true)) continue;
                    map.map(610 + cnt, ycol);
                    timeSeries.addRole("MULTI_RESPONSE" + cnt, m.getColumnLabel(ycol));
                }
                ++cnt;
            }
            if (cnt == 0) {
                graph.removeNamedGraph(timeSeries);
                return false;
            }
            timeSeries.setResponseCount(cnt);
        }
        str = elem.getAttribute("groupDisplay");
        if (str.equalsIgnoreCase("Cluster")) {
            timeSeries.setGroupDisplay(0);
        } else if (str.equalsIgnoreCase("Stack")) {
            timeSeries.setGroupDisplay(2);
        } else {
            timeSeries.setGroupDisplay(1);
        }
        StatGraph.parseURLOpt(elem, m, map, timeSeries);
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, timeSeries);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, timeSeries);
        str = elem.getAttribute("clusterWidth");
        if (StatGraph.isNumber(str)) {
            double width = Double.parseDouble(str);
            timeSeries.setClusterWidth(width);
        }
        if (!gotGroup && !timeSeries.isMultiResponse() || timeSeries.getGroupDisplay() != 0) {
            timeSeries.setClusterWidth(1.0);
        }
        StatGraph.parseDataSkinOpt(graph, elem, timeSeries);
        str = elem.getAttribute("groupOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("Ascending")) {
                timeSeries.setGroupOrder(1);
            } else if (str.equalsIgnoreCase("Descending")) {
                timeSeries.setGroupOrder(2);
            } else if (str.equalsIgnoreCase("Data")) {
                timeSeries.setGroupOrder(0);
            } else if (str.equalsIgnoreCase("ReverseData")) {
                timeSeries.setGroupOrder(3);
            } else {
                timeSeries.setGroupOrder(0);
                StatGraph.printOptionError("GROUPORDER", str);
            }
        } else if (graph.isCASData()) {
            timeSeries.setGroupOrder(1);
        }
        if (graph.isCASData()) {
            timeSeries.setDrawByGroupOrder(true);
        }
        if ((str = elem.getAttribute("smoothConnect")).length() > 0 && str.equalsIgnoreCase("true")) {
            timeSeries.setSmooth(true);
        }
        if ((str = elem.getAttribute("vertexLabel")).length() > 0 && str.equalsIgnoreCase("true")) {
            timeSeries.setVertexLabelOn(true);
            str = elem.getAttribute("vertexLabelFormat");
            if (str.length() > 0) {
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "badfmt.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"VERTEXLABELFORMAT", (Object)str));
                } else if (fmt.isCharacterFormat()) {
                    Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "formattype.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)"VERTEXLABELFORMAT", (Object)str));
                } else {
                    timeSeries.setLabelFormat(fmt);
                }
            }
        }
        boolean dataLabelOn = false;
        str = elem.getAttribute("baselineIntercept");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("AUTO")) {
                timeSeries.setBaselineInterceptType(0);
            } else if (str.equalsIgnoreCase("AXISMIN")) {
                timeSeries.setBaselineInterceptType(2);
            } else if (str.equalsIgnoreCase("AXISMINEXTEND")) {
                timeSeries.setBaselineInterceptType(3);
            } else if (str.equalsIgnoreCase("AXISMAX")) {
                timeSeries.setBaselineInterceptType(4);
            } else if (str.equalsIgnoreCase("AXISMAXEXTEND")) {
                timeSeries.setBaselineInterceptType(5);
            } else if (StatGraph.isNumber(str)) {
                timeSeries.setBaselineInterceptType(1);
                timeSeries.setBaseline(Double.parseDouble(str));
            } else {
                StatGraph.printOptionError("BASELINEINTERCEPT", str);
            }
        }
        if (timeSeries.isTooltipEnabled()) {
            timeSeries.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        timeSeries.setModel(crd);
        if (!timeSeries.isDataValid()) {
            graph.removeNamedGraph(timeSeries);
            StatGraph.printWarning(RB.getStringResource("LineChartParser.", "baddata.txt"));
            return false;
        }
        str = elem.getAttribute("break");
        if (str.equalsIgnoreCase("true")) {
            timeSeries.setBreakMissing(true);
        }
        String contextName = graph.style.isCycleAttrs() ? graph.style.getContextName() : "GraphDataStyleDefault";
        timeSeries.setContextName(contextName);
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), timeSeries.getLineStyle(), contextName);
        if (timeSeries.isFillOn()) {
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), timeSeries.getFillStyle(), contextName);
        }
        if (timeSeries.isMarkerOn()) {
            GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("markerAttrs"), timeSeries.getMarkerStyle(), contextName);
        }
        if (dataLabelOn) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), timeSeries.getLabelStyle(), "DataText");
        } else if (timeSeries.isVertexLabelOn()) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("vertexLabelAttrs"), timeSeries.getLabelStyle(), "DataText");
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("baselineAttrs"), timeSeries.getBaselineStyle(), "AxisLines");
        if (timeSeries.isFilledOutlinedMarker()) {
            GraphStyle.setDefaultFillStyle(graph, mrkFillAttr, timeSeries.getMarkerFillStyle(), contextName);
            GraphStyle.setDefaultLineStyle(graph, mrkOutlineAttr, timeSeries.getMarkerOutlineStyle(), "Outlines");
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs") && timeSeries.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, timeSeries.getFillStyle());
                continue;
            }
            if (elemTag.equals("LineAttrs") && timeSeries.isLineOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, timeSeries.getLineStyle());
                continue;
            }
            if (elemTag.equals("MarkerAttrs") && timeSeries.isMarkerOn()) {
                StatGraph.parseMarkerAttrs(graph, (Element)node, timeSeries.getMarkerStyle());
                continue;
            }
            if (elemTag.equals("VertexLabelAttrs") && timeSeries.isVertexLabelOn() && !dataLabelOn) {
                StatGraph.parseTextAttrs(graph, (Element)node, timeSeries.getLabelStyle());
                if (!((Element)node).hasAttribute("color")) continue;
                timeSeries.setUseLabelColor(true);
                continue;
            }
            if (elemTag.equals("DataLabelAttrs") && dataLabelOn) {
                StatGraph.parseTextAttrs(graph, (Element)node, timeSeries.getLabelStyle());
                if (!((Element)node).hasAttribute("color")) continue;
                timeSeries.setUseLabelColor(true);
                continue;
            }
            if (elemTag.equals("BaselineAttrs")) {
                StatGraph.parseLineAttrs(graph, (Element)node, timeSeries.getBaselineStyle());
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs") && timeSeries.isFilledOutlinedMarker()) {
                StatGraph.parseFillAttrs(graph, (Element)node, timeSeries.getMarkerFillStyle());
                continue;
            }
            if (!elemTag.equals("MarkerOutlineAttrs") || !timeSeries.isFilledOutlinedMarker()) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, timeSeries.getMarkerOutlineStyle());
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        int startFillColorIndex = -1;
        if (!gotColor && (crd.isAvailable(6) || timeSeries.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            startFillColorIndex = graph.style.fillColorCnt;
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)timeSeries, (byte)4, timeSeries.getFillStyle().getTransparency());
        }
        if (!gotLine && (crd.isAvailable(36) || timeSeries.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, timeSeries, (byte)15);
        }
        if (!gotLineColor && (crd.isAvailable(46) || timeSeries.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            startContrastColorIndex = graph.style.contrastColorCnt;
            LayoutOverlayParser.setDiscreteEncoder(graph, timeSeries, (byte)17);
        }
        if ((!gotShapeColor || timeSeries.isFilledOutlinedMarker()) && (crd.isAvailable(45) || timeSeries.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            if (startContrastColorIndex >= 0) {
                graph.style.contrastColorCnt = startContrastColorIndex;
            }
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)timeSeries, (byte)16, timeSeries.getMarkerStyle().getTransparency());
        }
        if (!gotShapeFillColor && (crd.isAvailable(69) || timeSeries.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            if (startFillColorIndex >= 0) {
                graph.style.fillColorCnt = startFillColorIndex;
            }
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)timeSeries, (byte)24, timeSeries.getMarkerStyle().getTransparency());
        }
        if (!gotShape && (crd.isAvailable(8) || timeSeries.isMultiResponse())) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, timeSeries, (byte)6);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("time");
        String dataName = StatGraph.getDataName(str);
        DataModel model = graph.getData(dataName);
        Element rElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rElem == null) {
            str = elem.getAttribute("response");
            String yVarID = StatGraph.getVarID(str);
            int ycol = model.getColumn(yVarID);
            ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(ycol);
            if (cmd.getType() == 2) {
                if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                    return null;
                }
                int respType = 2;
            } else if (cmd.getFormat() instanceof SASDateTimeFormat) {
                boolean respType = true;
            } else {
                boolean respType = false;
            }
        } else {
            boolean respType = false;
        }
        str = elem.getAttribute("orient");
        if (str.equalsIgnoreCase("Horizontal")) {
            types[0] = 0;
            types[1] = 1;
        } else {
            types[0] = 1;
            types[1] = 0;
        }
        types[2] = 0;
        return types;
    }
}

