/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Table;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TableParser
extends GraphComponentParser {
    public static boolean load(StatGraph graph, Element element, JComponent component, JComponent container) {
        String[] newFormats;
        int[] columns;
        DataModel dataModel;
        graph.addSupportedGraph();
        Table table = (Table)component;
        int i = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            ++i;
        }
        String[] names = new String[i];
        String[] formats = new String[i];
        String[] displays = new String[i];
        String[] labels = new String[i];
        String sortColumn = null;
        boolean ascending = true;
        i = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            names[i] = child.getAttribute("name");
            formats[i] = child.getAttribute("format");
            displays[i] = child.getAttribute("display");
            labels[i] = child.getAttribute("label");
            if (!child.getAttribute("sort").equals("")) {
                sortColumn = names[i];
                ascending = child.getAttribute("sort").equalsIgnoreCase("ascending");
            }
            ++i;
        }
        String s = element.getAttribute("data");
        if (!s.equals("")) {
            dataModel = graph.getData(s);
            columns = new int[dataModel.getColumnCount()];
            for (i = 0; i < columns.length; ++i) {
                columns[i] = i;
            }
            table.setModel(dataModel, columns);
            if (sortColumn != null) {
                table.sortColumn(dataModel.getColumn(StatGraph.getVarID(sortColumn)), ascending);
            }
            if (names.length > 0) {
                newFormats = table.getFormats();
                for (i = 0; i < names.length; ++i) {
                    int j = dataModel.getColumn(StatGraph.getVarID(names[i]));
                    if (!formats[i].equals("")) {
                        newFormats[j] = formats[i];
                    }
                    if (!displays[i].equals("")) {
                        table.setDisplay(j, displays[i]);
                    }
                    if (labels[i].equals("")) continue;
                    table.setLabel(j, labels[i]);
                }
                table.setFormats(newFormats);
            }
        } else if (names.length > 0) {
            dataModel = graph.getData(StatGraph.getDataName(names[0]));
            columns = new int[names.length];
            for (i = 0; i < columns.length; ++i) {
                columns[i] = dataModel.getColumn(StatGraph.getVarID(names[i]));
            }
            table.setModel(dataModel, columns);
            if (sortColumn != null) {
                table.sortColumn(dataModel.getColumn(StatGraph.getVarID(sortColumn)), ascending);
            }
            newFormats = table.getFormats();
            for (i = 0; i < displays.length; ++i) {
                if (!formats[i].equals("")) {
                    newFormats[i] = formats[i];
                }
                if (!displays[i].equals("")) {
                    table.setDisplay(i, displays[i]);
                }
                if (labels[i].equals("")) continue;
                table.setLabel(i, labels[i]);
            }
            table.setFormats(newFormats);
        }
        boolean ok = GraphComponentParser.load(graph, element, component, container);
        StatGraph.parseBorderOpts(graph, component, element, null);
        Color headerBackground = Color.lightGray;
        Color headerForeground = Color.black;
        TextStyle ts = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, null, ts, "TableHeaderText");
        Font defaultFont = ts.getFont();
        headerForeground = ts.getColor();
        Element textAttrs = StatGraph.getOptionAttrsElement(element, "HeaderAttrs");
        if (textAttrs != null) {
            ts = new TextStyle();
            StatGraph.parseTextAttrs(graph, textAttrs, ts);
            table.setHeaderFont(ts.getFont());
        } else {
            table.setHeaderFont(defaultFont);
        }
        FillAttrs fs = new FillAttrs();
        GraphStyle.setDefaultFillStyle(graph, null, fs, "TableHeaderFill");
        headerBackground = fs.getColor();
        Color cellBackground = Color.white;
        Color cellForeground = Color.black;
        GraphStyle.setDefaultTextStyle(graph, null, ts, "TableDataText");
        defaultFont = ts.getFont();
        cellForeground = ts.getColor();
        textAttrs = StatGraph.getOptionAttrsElement(element, "DataAttrs");
        if (textAttrs != null) {
            ts = new TextStyle();
            StatGraph.parseTextAttrs(graph, textAttrs, ts);
            table.setHeaderFont(ts.getFont());
        } else {
            table.setFont(defaultFont);
        }
        GraphStyle.setDefaultFillStyle(graph, null, fs, "TableDataFill");
        cellBackground = fs.getColor();
        Color gridColor = Color.black;
        LineAttrs ls = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, null, ls, "TableGridLines");
        gridColor = ls.getColor();
        table.setColors(headerBackground, headerForeground, cellBackground, cellForeground, gridColor);
        s = element.getAttribute("columnGrid");
        table.setColumnGrid(!s.equalsIgnoreCase("false"));
        s = element.getAttribute("rowGrid");
        table.setRowGrid(!s.equalsIgnoreCase("false"));
        s = element.getAttribute("header");
        s = element.getAttribute("headerWrapping");
        table.setHeaderWrapping(s.equalsIgnoreCase("true"));
        s = element.getAttribute("dataWrapping");
        table.setDataWrapping(s.equalsIgnoreCase("true"));
        s = element.getAttribute("columnHeaders");
        table.setHeader(!s.equalsIgnoreCase("false"));
        table.calculateSize();
        return ok;
    }
}

