/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SurfaceOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.SASDateTimeFormat;
import org.w3c.dom.Element;

public final class SurfaceParser {
    public static final String RB_KEY = "SurfaceParser.";

    public static SurfaceOverlay load(StatGraph graph, Element elem) {
        SurfaceOverlay surface = (SurfaceOverlay)graph.getObjectFromElement(elem);
        if (surface == null) {
            surface = new SurfaceOverlay();
        }
        return SurfaceParser.load(graph, surface, elem) ? surface : null;
    }

    public static boolean load(StatGraph graph, SurfaceOverlay surface, Element elem) {
        ColorEncoder encoder;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, surface);
        String str = elem.getAttribute("primary");
        surface.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("z");
        String zVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("colorResponse");
        String colorResponseRole = "colorResponse";
        if (str.length() == 0) {
            str = elem.getAttribute("surfaceColorGradient");
            colorResponseRole = "surfaceColorGradient";
        }
        String colorVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        int ycol = m.getColumn(yVarID);
        int zcol = m.getColumn(zVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            graph.removeNamedGraph(surface);
            return false;
        }
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 1, true)) {
            graph.removeNamedGraph(surface);
            return false;
        }
        if (!StatGraph.checkVariable("Z", m.getColumnLabel(zcol), Double.class, 1, true)) {
            graph.removeNamedGraph(surface);
            return false;
        }
        map.map(10, xcol);
        map.map(11, zcol);
        map.map(12, ycol);
        if (colorVarID.length() > 0) {
            int ccol = m.getColumn(colorVarID);
            if (StatGraph.checkVariable(colorResponseRole.toUpperCase(), m.getColumnLabel(ccol), Double.class, 1, false)) {
                map.map(6, ccol);
                str = elem.getAttribute(colorResponseRole + "AttrVar");
                if (str.length() > 0) {
                    surface.addAttrVar("SURFACECOLORGRADIENT", (AttrMapper)graph.getRangeAttrVar(str));
                }
            }
        }
        if (graph.casData) {
            surface.setPresortData(true);
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, surface);
        surface.setModel(crd);
        str = elem.getAttribute("nLevels");
        if (str.length() > 0) {
            // empty if block
        }
        String contextName = graph.style.getContextName();
        surface.setContextName(contextName);
        FillAttrs fillStyle = surface.getFillStyle();
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, contextName);
        Element fillElem = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, fillStyle);
            if (colorVarID.length() > 0 && fillElem.hasAttribute("color")) {
                map.unmapRole(6);
            }
        }
        surface.setOutlineColor(fillStyle.getColor());
        str = elem.getAttribute("surfaceType");
        if (str.equalsIgnoreCase("wireFrame")) {
            surface.setFillOn(false);
            surface.setEdgeOn(true);
        } else if (str.equalsIgnoreCase("fill")) {
            surface.setEdgeOn(false);
            surface.setFillOn(true);
        } else if (str.equalsIgnoreCase("fillGrid")) {
            surface.setEdgeOn(true);
            surface.setFillOn(true);
        } else {
            surface.setEdgeOn(true);
            surface.setFillOn(true);
            if (str.length() > 0) {
                StatGraph.printOptionError("SURFACETYPE", str);
            }
        }
        if (crd.isAvailable(6) && (encoder = StatGraph.parseColorModelOpt((byte)4, graph, elem, surface, surface.getFillStyle().getTransparency())) != null) {
            surface.setOutlineColor(surface.applyDataTransparency(encoder.startColor));
            surface.setEncoder((byte)4, encoder);
        }
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[5];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("z");
        String zVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        int ycol = m.getColumn(yVarID);
        int zcol = m.getColumn(zVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            return null;
        }
        ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(xcol);
        types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 1, true)) {
            return null;
        }
        cmd = (ColumnMetadata)m.getColumnLabel(ycol);
        types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        if (!StatGraph.checkVariable("Z", m.getColumnLabel(zcol), Double.class, 1, true)) {
            return null;
        }
        cmd = (ColumnMetadata)m.getColumnLabel(zcol);
        types[2] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        return types;
    }
}

