/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.grid.StripLabel;
import com.sas.graphics.util.gtk.TextStyle;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class StripLabelParser {
    public static final int ENTRY_TEXT = 0;
    public static final int TITLE_TEXT = 1;
    public static final int FOOTNOTE_TEXT = 2;

    public static void load(StatGraph graph, Element element, JComponent component, JComponent container) {
        String str;
        GraphComponentParser.load(graph, element, component, container);
        StripLabel label = (StripLabel)component;
        label.setOpaque(true);
        StatGraph.parseBorderOpts(graph, (JComponent)label, element, null);
        Node child = element.getFirstChild();
        if (child != null) {
            str = child.getNodeValue();
            label.setText(str);
        }
        if ((str = element.getAttribute("start")).length() > 0) {
            label.setLow(Double.parseDouble(str));
        }
        if ((str = element.getAttribute("stop")).length() > 0) {
            label.setHigh(Double.parseDouble(str));
        }
        TextStyle textAttrs = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, element.getAttribute("textAttrs"), textAttrs, "LabelText");
        Element tae = StatGraph.getOptionAttrsElement(element, "TextAttrs");
        if (tae != null) {
            StatGraph.parseTextAttrs(graph, tae, textAttrs);
        }
        label.setFont(textAttrs.getFont());
        label.setForeground(textAttrs.getColor());
        FillAttrs hiliteAttrs = new FillAttrs();
        GraphStyle.setDefaultDataFillStyle(graph, element.getAttribute("intervalAttrs"), hiliteAttrs, "GraphDataStyleDefault");
        Element iae = StatGraph.getOptionAttrsElement(element, "IntervalAttrs");
        if (iae != null) {
            StatGraph.parseFillAttrs(graph, iae, hiliteAttrs);
        }
        label.setHilite(hiliteAttrs.getColor());
        label.setHorizontalAlignment(0);
    }
}

