/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DataParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public final class StatGraphApplet
extends JApplet
implements Runnable {
    private String xmlDataFile = null;
    private String xmlDataData = null;
    private String xmlFile = null;
    private String xmlData = null;
    private String backColor = null;
    private Thread load;
    private StatGraphPanel panel;
    private int maxobs = 0;

    @Override
    public void init() {
        Color bc;
        String param;
        this.xmlDataFile = param = this.getParameter("xmlDataFile");
        this.xmlDataData = param = this.getParameter("XMLDATA");
        this.xmlFile = param = this.getParameter("xmlFile");
        this.xmlData = param = this.getParameter("XML");
        this.backColor = this.getParameter("BackColor");
        param = this.getParameter("MAXOBS");
        if (param != null) {
            this.maxobs = Integer.parseInt(param);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.panel = new StatGraphPanel();
        this.panel.separateData = this.xmlDataFile != null || this.xmlDataData != null;
        this.getContentPane().add((Component)this.panel, "Center");
        if (this.backColor != null && (bc = Color.decode(this.backColor)) != null) {
            this.panel.setBackground(bc);
        }
        this.setBackground(new Color(208, 208, 208));
        this.panel.setDoubleBuffered(true);
    }

    @Override
    public void start() {
        this.load = new Thread((Runnable)this, "load");
        this.load.start();
    }

    @Override
    public void run() {
        Thread curr = Thread.currentThread();
        if (curr == this.load) {
            Document doc;
            if (this.panel == null) {
                return;
            }
            this.showStatus("Reading XML...");
            if (this.panel.separateData) {
                if (StatGraphPanel.dumpTiming) {
                    StatGraphPanel.dumpTimeStamp("start parsing data");
                }
                this.parseData();
                if (StatGraphPanel.dumpTiming) {
                    StatGraphPanel.dumpTimeStamp("end parsing data");
                }
            }
            if ((doc = this.parseXML()) == null) {
                this.repaint();
                return;
            }
            this.showStatus("Creating graph...");
            this.panel.load(doc);
            doc = null;
            this.showStatus("Drawing graph...");
            this.invalidate();
            this.validate();
            this.showStatus("");
        }
    }

    @Override
    public void stop() {
        this.load = null;
    }

    private void parseData() {
        SAXParserFactory dpf = SAXParserFactory.newInstance();
        dpf.setValidating(false);
        dpf.setNamespaceAware(false);
        DataParser handler = null;
        try {
            SAXParser parser = dpf.newSAXParser();
            ParserAdapter pa = new ParserAdapter(parser.getParser());
            handler = new DataParser(this.panel.graph);
            handler.setNOBS(this.maxobs);
            InputSource src = null;
            if (this.xmlDataFile != null) {
                URL url = new URL(this.getDocumentBase(), this.xmlDataFile);
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                connection.connect();
                InputStream stream = connection.getInputStream();
                src = new InputSource(new BufferedInputStream(stream));
            } else if (this.xmlDataData != null) {
                src = new InputSource(new BufferedReader(new StringReader(this.xmlDataData)));
            }
            pa.setContentHandler(handler);
            parser.parse(src, (DefaultHandler)handler);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        handler = null;
    }

    private Document parseXML() {
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp("start of creating DOM");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(false);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            StatGraph.printDebug("pce=" + pce);
            return null;
        }
        dbf = null;
        Document document = null;
        try {
            InputSource src = null;
            if (this.xmlFile != null) {
                URL url = new URL(this.getDocumentBase(), this.xmlFile);
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                connection.connect();
                InputStream stream = connection.getInputStream();
                src = new InputSource(new BufferedInputStream(stream));
            } else if (this.xmlData != null) {
                src = new InputSource(new BufferedReader(new StringReader(this.xmlData)));
            }
            if (src == null) {
                this.dispError("Error accessing XML source.");
                return null;
            }
            document = db.parse(src);
        }
        catch (Exception e) {
            String msg = "Internal Exception:" + e;
            if (e instanceof FileNotFoundException) {
                msg = "XML file '" + this.xmlFile + "' not found.";
            }
            StatGraph.printDebug("Internal Exception:" + e);
            e.printStackTrace();
            this.dispError(msg);
            return null;
        }
        db = null;
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp("end of creating DOM");
        }
        return document;
    }

    private void dispError(String err) {
        JLabel l = new JLabel(err);
        l.setHorizontalAlignment(0);
        l.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.getContentPane().add(l);
        this.showStatus("ERROR: " + err);
    }
}

