/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.StyledLineBorder;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendComponent;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SizeLegendParser
extends GraphComponentParser {
    public static final String RB_KEY = "LegendParser.";

    public static boolean load(StatGraph graph, Element element, JComponent component, JComponent container) {
        CompoundBorder cb;
        boolean ok = GraphComponentParser.load(graph, element, component, container);
        SizeLegendComponent sizeLegend = (SizeLegendComponent)component;
        Element gnElem = StatGraph.getOptionAttrsElement(element, "GraphNames");
        if (gnElem != null) {
            String[] names = StatGraph.parseStringValueList(gnElem, "Value");
            sizeLegend.setGraphNames(names);
            graph.addGraphReference(sizeLegend, names);
        }
        String s = "";
        s = element.getAttribute("title");
        if (s.length() > 0) {
            String type = element.getAttribute("title_type");
            if (type.length() > 0) {
                if (type.equalsIgnoreCase("KEYWORD")) {
                    if (s.equalsIgnoreCase("AUTO")) {
                        sizeLegend.setAutoTitle(true);
                    }
                } else {
                    sizeLegend.setTitle(s);
                }
            } else {
                sizeLegend.setTitle(s);
            }
        }
        s = element.getAttribute("titleBorder");
        sizeLegend.setTitleBorder(s.equalsIgnoreCase("true"));
        s = element.getAttribute("displayClipped");
        sizeLegend.setClippingAllowed(s.equalsIgnoreCase("true"));
        TextStyle valueAttrs = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, element.getAttribute("valueAttrs"), valueAttrs, "ValueText");
        TextStyle titleAttrs = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, element.getAttribute("titleAttrs"), titleAttrs, "LabelText");
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            SGAnnotationContainer ac;
            AbstractAnno text;
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            if (child.getTagName().equalsIgnoreCase("ValueAttrs")) {
                StatGraph.parseTextAttrs(graph, child, valueAttrs);
                continue;
            }
            if (child.getTagName().equalsIgnoreCase("TitleAttrs")) {
                StatGraph.parseTextAttrs(graph, child, titleAttrs);
                continue;
            }
            if (!child.getTagName().startsWith("Draw") || (text = AnnotateParser.load(graph, child, (AnnotationContainer)(ac = new SGAnnotationContainer(sizeLegend, graph.rootPanel)))) == null) continue;
            if ("back".equalsIgnoreCase(child.getAttribute("layer"))) {
                graph.annotationInBackList.add(text);
                continue;
            }
            graph.annotationInFrontList.add(text);
        }
        if (StatGraph.dataSizeScaleFactor < 1.0) {
            double scale = Math.pow(StatGraph.dataSizeScaleFactor, 4.0);
            scale = Math.pow(scale, 0.08333333333333333);
            Font fn = titleAttrs.getFont();
            fn = StatGraph.useFontManager ? FontManager.getFont((String)fn.getFamily(), (int)fn.getStyle(), (int)((int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()))) : new Font(fn.getFamily(), fn.getStyle(), (int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()));
            sizeLegend.setTitleFont(fn);
            fn = valueAttrs.getFont();
            fn = StatGraph.useFontManager ? FontManager.getFont((String)fn.getFamily(), (int)fn.getStyle(), (int)((int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()))) : new Font(fn.getFamily(), fn.getStyle(), (int)Math.max((double)fn.getSize() * scale, (double)StatGraph.getMinimumFontSize()));
            sizeLegend.setFont(fn);
        } else {
            sizeLegend.setTitleFont(titleAttrs.getFont());
            sizeLegend.setFont(valueAttrs.getFont());
        }
        sizeLegend.setTitleColor(titleAttrs.getColor());
        sizeLegend.setValueColor(valueAttrs.getColor());
        Border bd = sizeLegend.getBorder();
        if (bd != null && bd instanceof CompoundBorder && (cb = (CompoundBorder)bd).getOutsideBorder() instanceof StyledLineBorder) {
            sizeLegend.setForeground(((StyledLineBorder)cb.getOutsideBorder()).getLineStyle().getColor());
        }
        StatGraph.parseBorderOpts(graph, component, element, null);
        String orient = element.getAttribute("orient");
        if (orient.equalsIgnoreCase("horizontal")) {
            sizeLegend.setHorizontal(true);
        }
        return ok;
    }
}

