/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.EllipseParmParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.MyEditorKit;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.RotatedJTextPane;
import com.sas.graphics.applets.statgraph.ScMxCommonArgs;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.StyledLineBorder;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.event.ViewportListener;
import com.sas.graphics.applets.statgraph.sgchart.grid.GridAxisInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.GridAxis;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ScatterMatrixParser {
    public static final String RB_KEY = "LayoutOverlayParser.";

    public static TrellisPlot load(StatGraph graph, Element elem) {
        HashMap map = graph.getElementToObjectMap();
        Object object = map == null ? null : map.get(elem);
        TrellisPlot plot = object instanceof TrellisPlot ? (TrellisPlot)object : new TrellisPlot();
        return ScatterMatrixParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, TrellisPlot plot, Element elem) {
        ColumnMetadata cmd;
        int j;
        int rNo;
        int i;
        String freqVarID;
        String urlVarID;
        String[] rowVarIDs;
        int nRows;
        boolean square;
        plot.disableLayout();
        GraphComponentParser.load(graph, elem, (JComponent)plot, null);
        StatGraph.parseBorderOpts(graph, (JComponent)plot, elem, null);
        boolean reverseRows = false;
        String str = elem.getAttribute("start");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("bottomLeft")) {
                reverseRows = true;
            } else if (str.equalsIgnoreCase("topleft")) {
                reverseRows = false;
            } else {
                StatGraph.printOptionError("START", str);
            }
        }
        Element cvElem = StatGraph.getOptionAttrsElement(elem, "ColumnVars");
        String[] columnVars = StatGraph.parseStringValueList(cvElem, "Value");
        String dataName = StatGraph.getDataName(columnVars[0]);
        DataModel model = graph.getData(dataName);
        int nCols = columnVars.length;
        String[] columnVarIDs = new String[nCols];
        for (int i2 = 0; i2 < nCols; ++i2) {
            columnVarIDs[i2] = StatGraph.getVarID(columnVars[i2]);
            if (StatGraph.checkVariable("COLUMNVARS", model.getColumnLabel(model.getColumn(columnVarIDs[i2])), Double.class, 1, true)) continue;
            return false;
        }
        Element rvElem = StatGraph.getOptionAttrsElement(elem, "RowVars");
        if (rvElem != null) {
            square = false;
            String[] rowVars = StatGraph.parseStringValueList(rvElem, "Value");
            nRows = rowVars.length;
            rowVarIDs = new String[nRows];
            for (int i3 = 0; i3 < nRows; ++i3) {
                rowVarIDs[i3] = StatGraph.getVarID(rowVars[i3]);
                if (StatGraph.checkVariable("ROWVARS", model.getColumnLabel(model.getColumn(rowVarIDs[i3])), Double.class, 1, true)) continue;
                return false;
            }
        } else {
            square = true;
            nRows = nCols;
            rowVarIDs = new String[nRows];
            for (int i4 = 0; i4 < nRows; ++i4) {
                rowVarIDs[i4] = columnVarIDs[i4];
            }
        }
        Element labelElem = null;
        Element markerElem = null;
        Element wallElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("WallAttrs")) continue;
            wallElem = (Element)node;
        }
        String msgVarID = null;
        if (!(markerElem != null && markerElem.hasAttribute("symbol") || elem.hasAttribute("markerAttrs") || (str = elem.getAttribute("markerCharacter")).length() <= 0)) {
            msgVarID = StatGraph.getVarID(str);
        }
        String mcgVarID = null;
        String colorResponseRole = "colorResponse";
        if (!(markerElem != null && markerElem.hasAttribute("color") || elem.hasAttribute("markerAttrs"))) {
            str = elem.getAttribute(colorResponseRole);
            if (str.length() == 0) {
                str = elem.getAttribute("markerColorGradient");
                colorResponseRole = "markerColorGradient";
            }
            if (str.length() > 0) {
                mcgVarID = StatGraph.getVarID(str);
            }
        }
        String gVarID = null;
        if (mcgVarID == null && (str = elem.getAttribute("group")).length() > 0 && LayoutOverlayParser.hasTooManyGroups(graph, model, gVarID = StatGraph.getVarID(str), "SCATTERPLOTMATRIX")) {
            gVarID = null;
        }
        String labelVarID = null;
        str = elem.getAttribute("dataLabel");
        if (str.length() > 0) {
            labelVarID = StatGraph.getVarID(str);
        }
        Component[] diagonal = null;
        Element diaElem = StatGraph.getOptionAttrsElement(elem, "Diagonal");
        if (diaElem != null && square) {
            diagonal = new Component[nCols];
            ScatterMatrixParser.parseDiagonalComponents(graph, diaElem, diagonal);
        }
        EllipseParmOverlay[] ellipses = new EllipseParmOverlay[nCols * nRows];
        Element ellipseElem = StatGraph.getOptionAttrsElement(elem, "MatrixEllipseList");
        if (ellipseElem != null) {
            ScatterMatrixParser.parseEllipseOverlays(graph, nRows, nCols, square, ellipseElem, ellipses);
        }
        int rowGap = 3;
        int colGap = 3;
        TrellisLayout tl = new TrellisLayout(nRows, nCols, colGap, rowGap);
        plot.setLayout((LayoutManager)tl);
        tl.setCellHeadersAligned(true);
        ScMxCommonArgs commArgs = new ScMxCommonArgs();
        if (square && (str = elem.getAttribute("matrixType")).length() > 0) {
            if (str.equalsIgnoreCase("full")) {
                commArgs.display = 0;
            } else if (str.equalsIgnoreCase("uppertriangle")) {
                commArgs.display = 1;
            } else if (str.equalsIgnoreCase("lowertriangle")) {
                commArgs.display = 2;
            } else {
                StatGraph.printOptionError("MATRIXTYPE", str);
            }
        }
        if ((str = elem.getAttribute("labelStrip")).equalsIgnoreCase("true")) {
            commArgs.markerCharacterStrip = true;
        }
        if (StatGraph.isNumber(str = elem.getAttribute("dataTransparency"))) {
            commArgs.dataTransparency = Double.parseDouble(str);
        }
        if (!StatGraph.VGF && (str = elem.getAttribute("subPixel")).equalsIgnoreCase("off")) {
            commArgs.subpixelOff = true;
        }
        GraphStyle.setDefaultLineStyle(graph, null, commArgs.wallEdgeStyle, "WallFill");
        LayoutOverlayParser.parseWallColor(graph, elem, commArgs.wallFillStyle);
        if (mcgVarID != null && mcgVarID.length() > 0) {
            commArgs.mcgCol = model.getColumn(mcgVarID);
            commArgs.mcgColLabel = model.getColumnLabel(commArgs.mcgCol);
            commArgs.gradientMarkerColor = StatGraph.checkVariable(colorResponseRole.toUpperCase(), commArgs.mcgColLabel, Double.class, 1, false);
            commArgs.colorResponseRole = colorResponseRole;
            commArgs.missingGradientColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
        }
        commArgs.labelingEnabled = true;
        if (msgVarID != null && msgVarID.length() > 0) {
            commArgs.msgCol = model.getColumn(msgVarID);
            commArgs.msgColLabel = model.getColumnLabel(commArgs.msgCol);
            commArgs.labelVisible = true;
            commArgs.labelsAsMarkers = true;
        } else if (labelVarID != null && labelVarID.length() > 0) {
            commArgs.lCol = model.getColumn(labelVarID);
            commArgs.lColLabel = model.getColumnLabel(commArgs.lCol);
            commArgs.labelVisible = true;
            ColumnMetadata cmd2 = (ColumnMetadata)commArgs.lColLabel;
            int nonMissing = cmd2.getNobs() - cmd2.getMissings();
            if (nonMissing == 0) {
                commArgs.labelingEnabled = false;
                commArgs.labelVisible = false;
            } else {
                Message msg;
                commArgs.labelVisible = true;
                boolean bl = commArgs.labelingEnabled = nonMissing <= graph.labelingThreshold;
                if (!commArgs.labelingEnabled) {
                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(nonMissing))), false);
                } else if (cmd2.getNobs() > 5 * graph.labelingThreshold) {
                    commArgs.labelingEnabled = false;
                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(cmd2.getNobs()))), false);
                }
            }
        }
        if (gVarID != null && gVarID.length() > 0) {
            String indexVarID;
            commArgs.gVarID = gVarID;
            commArgs.gCol = model.getColumn(gVarID);
            commArgs.gColLabel = model.getColumnLabel(commArgs.gCol);
            commArgs.groupValid = true;
            str = elem.getAttribute("index");
            if (str.length() > 0 && (indexVarID = StatGraph.getVarID(str)) != null && indexVarID.length() > 0) {
                commArgs.iCol = model.getColumn(indexVarID);
                commArgs.iColLabel = model.getColumnLabel(commArgs.iCol);
                boolean bl = commArgs.indexValid = StatGraph.checkVariable("INDEX", commArgs.iColLabel, Double.class, 2, true, false) && ScatterParser.checkIndexColumn(model, commArgs.iCol, "INDEX", indexVarID);
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                commArgs.includeMissingGroup = false;
            }
            if (graph.isCASData()) {
                commArgs.groupOrder = 1;
                commArgs.drawByGroupOrder = true;
            }
        }
        if ((str = elem.getAttribute("url")).length() > 0 && (urlVarID = StatGraph.getVarID(str)) != null && urlVarID.length() > 0) {
            commArgs.urlCol = model.getColumn(urlVarID);
            commArgs.urlColLabel = model.getColumnLabel(commArgs.urlCol);
            commArgs.urlValid = true;
        }
        commArgs.userSetSymbol = StatGraph.isBundleAttributeFixed(elem, "markerAttrs", "symbol");
        commArgs.userSetColor = !commArgs.gradientMarkerColor && commArgs.labelsAsMarkers ? StatGraph.isBundleAttributeFixed(elem, "markerCharacterAttrs", "color") : StatGraph.isBundleAttributeFixed(elem, "markerAttrs", "color");
        str = elem.getAttribute("freq");
        if (str.length() > 0 && (freqVarID = StatGraph.getVarID(str)) != null && freqVarID.length() > 0) {
            commArgs.freqCol = model.getColumn(freqVarID);
            commArgs.freqColLabel = model.getColumnLabel(commArgs.freqCol);
            commArgs.freqValid = StatGraph.checkVariable("FREQ", commArgs.freqColLabel, Double.class, false);
        }
        commArgs.numRows = nRows;
        commArgs.numCols = nCols;
        commArgs.reverseRows = reverseRows;
        commArgs.iArgs = LayoutDataLatticeParser.InsetArgs.parseInsetVarsAndOpts(graph, elem);
        Element markerAttrsElem = StatGraph.getOptionAttrsElement(elem, "MarkerAttrs");
        if (markerAttrsElem != null && markerAttrsElem.hasAttribute("transparency")) {
            commArgs.markerTransparency = Double.parseDouble(markerAttrsElem.getAttribute("transparency"));
        }
        for (i = 0; i < nRows; ++i) {
            rNo = reverseRows ? nRows - 1 - i : i;
            block10: for (int j2 = 0; j2 < nCols; ++j2) {
                if (square && rNo == j2) {
                    if (diagonal != null && diagonal[rNo] != null) {
                        plot.addCellItem(i, j2, diagonal[rNo]);
                        continue;
                    }
                    ColumnMetadata cmd3 = (ColumnMetadata)model.getColumnLabel(model.getColumn(columnVarIDs[j2]));
                    ScatterMatrixParser.addEntry(graph, plot, i, j2, cmd3.getLabel());
                    continue;
                }
                switch (commArgs.display) {
                    case 0: {
                        ScatterMatrixParser.addPlot(graph, plot, i, j2, model, columnVarIDs[j2], rowVarIDs[rNo], commArgs, elem, ellipses[j2 * nRows + rNo]);
                        continue block10;
                    }
                    case 1: {
                        if ((!reverseRows || rNo <= j2) && (reverseRows || rNo >= j2)) continue block10;
                        ScatterMatrixParser.addPlot(graph, plot, i, j2, model, columnVarIDs[j2], rowVarIDs[rNo], commArgs, elem, ellipses[j2 * nRows + rNo]);
                        continue block10;
                    }
                    case 2: {
                        if ((!reverseRows || rNo >= j2) && (reverseRows || rNo <= j2)) continue block10;
                        ScatterMatrixParser.addPlot(graph, plot, i, j2, model, columnVarIDs[j2], rowVarIDs[rNo], commArgs, elem, ellipses[j2 * nRows + rNo]);
                    }
                }
            }
        }
        for (i = 0; i < nRows; ++i) {
            ScatterMatrixParser.addRowColAxis(graph, plot, i, true, reverseRows, commArgs.display, diagonal != null);
        }
        for (j = 0; j < nCols; ++j) {
            ScatterMatrixParser.addRowColAxis(graph, plot, j, false, reverseRows, commArgs.display, diagonal != null);
        }
        LayoutLatticeParser.decideRowColumnAxisTypes(plot);
        if (!square) {
            for (i = 0; i < nRows; ++i) {
                rNo = reverseRows ? nRows - 1 - i : i;
                cmd = (ColumnMetadata)model.getColumnLabel(model.getColumn(rowVarIDs[rNo]));
                ScatterMatrixParser.addRowColHeader(graph, plot, i, cmd.getLabel(), true, commArgs.display, commArgs.reverseRows);
            }
            for (j = 0; j < nCols; ++j) {
                ColumnMetadata cmd4 = (ColumnMetadata)model.getColumnLabel(model.getColumn(columnVarIDs[j]));
                ScatterMatrixParser.addRowColHeader(graph, plot, j, cmd4.getLabel(), false, commArgs.display, commArgs.reverseRows);
            }
        } else if (diaElem != null) {
            for (i = 0; i < nRows; ++i) {
                rNo = reverseRows ? nRows - 1 - i : i;
                cmd = (ColumnMetadata)model.getColumnLabel(model.getColumn(rowVarIDs[rNo]));
                ScatterMatrixParser.addRowColHeader(graph, plot, i, cmd.getLabel(), true, commArgs.display, commArgs.reverseRows);
            }
            for (j = 0; j < nCols; ++j) {
                ColumnMetadata cmd5 = (ColumnMetadata)model.getColumnLabel(model.getColumn(columnVarIDs[j]));
                ScatterMatrixParser.addRowColHeader(graph, plot, j, cmd5.getLabel(), false, commArgs.display, commArgs.reverseRows);
            }
        }
        commArgs = null;
        str = elem.getAttribute("name");
        if (str.length() > 0) {
            OverlayContainer oc = null;
            if (!square) {
                oc = (OverlayContainer)plot.getCellItem(0, 0);
            } else if (reverseRows) {
                if (nCols > 1) {
                    oc = (OverlayContainer)plot.getCellItem(0, 0);
                }
            } else if (nCols > 1) {
                oc = (OverlayContainer)plot.getCellItem(0, 1);
            } else if (nRows > 1) {
                oc = (OverlayContainer)plot.getCellItem(1, 0);
            }
            if (oc != null) {
                ArrayList ovs = oc.getComposite().getOverlays();
                for (int i5 = 0; i5 < ovs.size(); ++i5) {
                    Overlay ov = (Overlay)ovs.get(i5);
                    if (!(ov instanceof ScatterOverlay)) continue;
                    graph.addNamedGraph(str, ov);
                    break;
                }
            }
        }
        ScatterMatrixParser.parseMarkerAttributes(graph, elem, markerElem, plot, square, reverseRows);
        ScatterMatrixParser.parseLabelAttributes(graph, elem, labelElem, plot, square, reverseRows);
        ScatterMatrixParser.parseWallAttributes(graph, elem, wallElem, plot, square);
        boolean vSync = diagonal == null;
        boolean hSync = true;
        if (hSync) {
            plot.installColumnRangeListeners();
        }
        if (vSync) {
            plot.installRowRangeListeners();
        }
        plot.installMarginListeners();
        plot.enableLayout();
        if (!graph.server) {
            ScatterMatrixParser.registerViewportListener(plot, hSync, vSync);
        }
        return true;
    }

    private static void parseMarkerAttributes(StatGraph graph, Element elem, Element markerElem, TrellisPlot plot, boolean square, boolean reverseRows) {
        MarkerAttrs ms = new MarkerAttrs();
        GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("markerAttrs"), ms, "GraphDataStyleDefault");
        if (markerElem != null) {
            StatGraph.parseMarkerAttrs(graph, markerElem, ms);
        }
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        Element markerCharacterElem = StatGraph.getOptionAttrsElement(elem, "MarkerCharacterAttrs");
        boolean useMarkerTransparency = StatGraph.isTransparencyFixed(elem, markerElem);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Component comp;
                int rNo;
                int n = rNo = reverseRows ? rows - 1 - i : i;
                if (square && rNo == j || !((comp = plot.getCellItem(i, j)) instanceof OverlayContainer)) continue;
                OverlayContainer oc = (OverlayContainer)comp;
                ArrayList ov = oc.getComposite().getOverlays();
                for (int o = 0; o < ov.size(); ++o) {
                    if (!(ov.get(o) instanceof ScatterOverlay)) continue;
                    ScatterOverlay scat = (ScatterOverlay)ov.get(o);
                    scat.setInScatterMatrix(true);
                    if (scat.isLabelsAsMarkers()) {
                        scat.setDefaultMarkerShape((short)-1);
                        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("markerCharacterAttrs"), scat.getMarkerCharacterStyle(), "DataText");
                        scat.getMarkerCharacterStyle().setColor(ms.getColor());
                        if (markerCharacterElem != null) {
                            StatGraph.parseTextAttrs(graph, markerCharacterElem, scat.getMarkerCharacterStyle());
                        }
                    } else {
                        scat.setDefaultMarkerColor(ms.getColor());
                        scat.setMarkerTransparency(ms.getTransparency());
                        scat.setUseMarkerTransparency(useMarkerTransparency);
                        scat.setDefaultMarkerShape((short)ms.getShape());
                        scat.setDefaultMarkerWeight(ms.getWeight());
                        scat.setMinMarkerSize(ms.getSize());
                        scat.setMaxMarkerSize(ms.getSize());
                        scat.setDefaultMarkerScale(0.0);
                    }
                    StatGraph.parseDataSkinOpt(graph, elem, scat);
                }
            }
        }
    }

    private static void parseLabelAttributes(StatGraph graph, Element elem, Element labelElem, TrellisPlot plot, boolean square, boolean reverseRows) {
        String str = elem.getAttribute("showPointLabels");
        int showLabels = 0;
        if (str.equalsIgnoreCase("NONE")) {
            showLabels = 2;
        } else if (str.equalsIgnoreCase("ALL")) {
            showLabels = 1;
        } else if (str.equalsIgnoreCase("CUSTOM")) {
            showLabels = 3;
        }
        TextStyle ts = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), ts, "DataText");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, ts);
        }
        SASFormat format = null;
        str = elem.getAttribute("dataLabelFormat");
        if (str.length() > 0) {
            format = SASFormat.getInstance((String)str);
        }
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Component comp;
                int rNo;
                int n = rNo = reverseRows ? rows - 1 - i : i;
                if (square && rNo == j || !((comp = plot.getCellItem(i, j)) instanceof OverlayContainer)) continue;
                OverlayContainer oc = (OverlayContainer)comp;
                oc.getComposite().setShowPointLabels(showLabels);
                ArrayList ov = oc.getComposite().getOverlays();
                for (int o = 0; o < ov.size(); ++o) {
                    ScatterOverlay scat;
                    if (!(ov.get(o) instanceof ScatterOverlay) || (scat = (ScatterOverlay)ov.get(o)).isLabelsAsMarkers()) continue;
                    if (scat.getGroupValues() == null && !scat.isGradientMarkerColor() || StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color")) {
                        scat.setUseLabelColor(true);
                    }
                    scat.setLabelStyle(ts);
                    if (format != null) {
                        scat.setLabelFormat(format);
                    }
                    if (showLabels != 3) continue;
                    ScatterMatrixParser.parseInvisibleDataLabels(elem, scat);
                }
            }
        }
    }

    private static void parseInvisibleDataLabels(Element elem, ScatterOverlay plot) {
        String elemTag = "";
        String x = plot.getModel().getColumnName((short)10);
        String y = plot.getModel().getColumnName((short)11);
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element invisibles;
            String str;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("InvisiblePointLabels") || !(str = (invisibles = (Element)node).getAttribute("x")).equalsIgnoreCase(x) || !(str = invisibles.getAttribute("y")).equalsIgnoreCase(y)) continue;
            str = invisibles.getAttribute("obs");
            if (str.length() <= 0) break;
            int[] hiden = StatGraph.parseList2Int(str);
            plot.setInitialHideLabelObs(hiden);
            break;
        }
    }

    private static void parseWallAttributes(StatGraph graph, Element elem, Element wallElem, TrellisPlot plot, boolean square) {
        boolean edgeOn;
        boolean fillOn;
        String str = elem.getAttribute("wallDisplay");
        if (str.length() == 0 || str.equalsIgnoreCase("STANDARD")) {
            fillOn = true;
            edgeOn = true;
        } else if (str.equalsIgnoreCase("NONE")) {
            fillOn = false;
            edgeOn = false;
        } else if (str.equalsIgnoreCase("ALL")) {
            fillOn = true;
            edgeOn = true;
        } else {
            fillOn = (str = str.toUpperCase()).indexOf("FILL") != -1;
            edgeOn = str.indexOf("OUTLINE") != -1;
        }
        Color wc = Color.white;
        if (fillOn) {
            FillAttrs fs = new FillAttrs();
            LayoutOverlayParser.parseWallColor(graph, elem, fs);
            wc = fs.getColor();
        }
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Component comp = plot.getCellItem(i, j);
                if (comp instanceof OverlayContainer) {
                    OverlayContainer oc = (OverlayContainer)comp;
                    Wall w = oc.getComposite().getWall();
                    if (w == null) continue;
                    w.setFillOn(fillOn);
                    w.setEdgeOn(edgeOn);
                    if (!fillOn) continue;
                    w.getFillStyle().setColor(wc);
                    continue;
                }
                if (comp instanceof Entry) {
                    if (!edgeOn) {
                        ((Entry)comp).setBorder(null);
                    }
                    if (!fillOn) continue;
                    ((Entry)comp).setOpaque(true);
                    ((Entry)comp).setBackground(wc);
                    continue;
                }
                if (!(comp instanceof RotatedJTextPane)) continue;
                if (!edgeOn) {
                    ((RotatedJTextPane)comp).setBorder(null);
                }
                if (!fillOn) continue;
                ((RotatedJTextPane)comp).setOpaque(true);
                ((RotatedJTextPane)comp).setBackground(wc);
            }
        }
    }

    private static void addPlot(StatGraph graph, TrellisPlot plot, int row, int col, DataModel model, String xVarID, String yVarID, ScMxCommonArgs commArgs, Element elem, Overlay overlay) {
        Message msg;
        boolean yok;
        ColumnMetadata ycmd;
        graph.addSupportedGraph();
        graph.style.resetCounters();
        boolean view2D = true;
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        Simple2DOverlayComposite soc = null;
        ScatterOverlay scat = null;
        if (oc == null) {
            oc = new OverlayContainer(view2D, false, !graph.server);
            soc = new Simple2DOverlayComposite();
            oc.setComposite(soc);
            scat = new ScatterOverlay(0);
        } else {
            soc = oc.getComposite();
            ArrayList plots = oc.getComposite().getOverlays();
            if (plots.size() > 0 && plots.get(0) instanceof ScatterOverlay) {
                scat = (ScatterOverlay)plots.get(0);
                plots.remove(0);
            } else {
                scat = new ScatterOverlay(0);
            }
        }
        soc.setLabelVerbose(graph.isLabelVerbose());
        soc.setLabelDisplaceable(graph.isLabelDisplaceable());
        soc.setSALabeling(graph.isSALabeling());
        soc.setSAWeightMap(graph.getSAWeightMap());
        soc.setSAMaxIterations(graph.getSAMaxIterations());
        soc.setSASeed(graph.getSASeed());
        scat.setStmt("scatterplot");
        scat.setDataTransparency(commArgs.dataTransparency);
        scat.setSubpixelOff(commArgs.subpixelOff);
        Wall w = new Wall(view2D);
        w.setEdgeStyle(commArgs.wallEdgeStyle);
        w.setFillStyle(commArgs.wallFillStyle);
        soc.setWall(w);
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis yAxis = new VRectAxis(2, false);
        scat.setComponentSize(graph.size.width, graph.size.height);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        map.map(10, xcol);
        map.map(11, ycol);
        scat.addRole("X", model.getColumnLabel(xcol));
        scat.addRole("Y", model.getColumnLabel(ycol));
        if (commArgs.gradientMarkerColor) {
            map.map(45, commArgs.mcgCol);
            scat.addRole(commArgs.colorResponseRole.toUpperCase(), commArgs.mcgColLabel);
            String str = elem.getAttribute(commArgs.colorResponseRole + "AttrVar");
            if (str.length() > 0) {
                scat.addAttrVar("MARKERCOLORGRADIENT", (AttrMapper)graph.getRangeAttrVar(str));
            }
        }
        scat.setGradientMarkerColor(commArgs.gradientMarkerColor);
        scat.setMissingGradientColor(commArgs.missingGradientColor);
        if (commArgs.labelsAsMarkers) {
            map.map(5, commArgs.msgCol);
            scat.addRole("MARKERCHARACTER", commArgs.msgColLabel);
        } else if (commArgs.labelVisible) {
            map.map(5, commArgs.lCol);
            scat.addRole("DATALABEL", commArgs.lColLabel);
        }
        int position = ScatterParser.parseDataLabelPosition(elem);
        if (position != -1) {
            commArgs.labelingEnabled = false;
            scat.setFixedDataLabelPosition(position);
            ScatterParser.parseDataLabelSplitting(scat, elem);
        }
        scat.setStripMarkerCharacter(commArgs.markerCharacterStrip);
        scat.setLabelVisible(commArgs.labelVisible);
        scat.setLabelsAsMarkers(commArgs.labelsAsMarkers);
        if (commArgs.labelsAsMarkers) {
            scat.setLabelCollisionAvoidance(false);
            scat.setDataLabelSplit(false);
            scat.setFixedDataLabelPosition(ScatterParser.parseMarkerCharacterPosition(elem));
        } else {
            scat.setLabelCollisionAvoidance(commArgs.labelingEnabled);
        }
        if (commArgs.groupValid) {
            String str;
            if (!commArgs.gradientMarkerColor && !commArgs.userSetColor) {
                map.map(45, commArgs.gCol);
            }
            if (!commArgs.labelsAsMarkers && !commArgs.userSetSymbol) {
                map.map(8, commArgs.gCol);
            }
            map.map(3, commArgs.gCol);
            scat.addRole("GROUP", commArgs.gColLabel);
            if (commArgs.indexValid) {
                if (!commArgs.gradientMarkerColor) {
                    map.map(41, commArgs.iCol);
                }
                if (!commArgs.labelsAsMarkers) {
                    map.map(42, commArgs.iCol);
                }
                scat.addRole("INDEX", commArgs.iColLabel);
            }
            if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                scat.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                DAMDatasetParser.addInternalAttrVar(graph, scat, "GROUP", commArgs.gVarID);
            }
        }
        if (commArgs.urlValid) {
            map.map(52, commArgs.urlCol);
            scat.addRole("URL", commArgs.urlColLabel);
        }
        if (commArgs.freqValid) {
            map.map(51, commArgs.freqCol);
            scat.addRole("FREQ", commArgs.freqColLabel);
        }
        String xFormat = null;
        String yFormat = null;
        String xLabel = null;
        String yLabel = null;
        boolean xTime = false;
        boolean yTime = false;
        ColumnMetadata xcmd = scat.getRoleMetadata("X");
        if (xcmd != null) {
            if (xcmd.getFormat() != null) {
                xFormat = xcmd.getFormat().getName();
            }
            xLabel = xcmd.getLabel();
            SASFormat fmt = xcmd.getFormat();
            if (fmt != null) {
                boolean bl = xTime = fmt.isDateFormat() || fmt.isDateTimeFormat() || fmt.isTimeFormat();
            }
        }
        if ((ycmd = scat.getRoleMetadata("Y")) != null) {
            if (ycmd.getFormat() != null) {
                yFormat = ycmd.getFormat().getName();
            }
            yLabel = ycmd.getLabel();
            SASFormat fmt = ycmd.getFormat();
            if (fmt != null) {
                yTime = fmt.isDateFormat() || fmt.isDateTimeFormat() || fmt.isTimeFormat();
            }
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, model, map, scat);
        if (xcmd != null) {
            xcmd.setFormat(xFormat);
            xcmd.setLabel(xLabel);
        }
        if (ycmd != null) {
            ycmd.setFormat(yFormat);
            ycmd.setLabel(yLabel);
        }
        scat.setMissingGroupOn(commArgs.includeMissingGroup);
        scat.setGroupOrder(commArgs.groupOrder);
        CRD crd = new CRD();
        crd.setSrcModel(model);
        crd.setSrcMap(map);
        scat.setModel(crd);
        if (commArgs.gradientMarkerColor) {
            ColorEncoder encoder = StatGraph.parseColorModelOpt((byte)16, graph, elem, scat, commArgs.markerTransparency);
            if (encoder != null) {
                scat.setEncoder((byte)16, encoder);
            }
        } else if (crd.isAvailable(45)) {
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)scat, (byte)16, commArgs.markerTransparency);
        }
        if (crd.isAvailable(8)) {
            LayoutOverlayParser.setDiscreteEncoder(graph, scat, (byte)6);
        }
        if (commArgs.iArgs != null && commArgs.iArgs.numEntryColumns > 0) {
            int effectiveRow = commArgs.reverseRows ? commArgs.numRows - row - 1 : row;
            int obsIndex = col + commArgs.numCols * effectiveRow;
            commArgs.iArgs.addInset(graph, obsIndex, (JComponent)oc, true, null);
        }
        if (xTime) {
            xAxis.setType(5);
        }
        if (yTime) {
            yAxis.setType(5);
        }
        if (overlay != null) {
            boolean xok = soc.connect(overlay, (AbstractAxis)xAxis, (byte)1);
            yok = soc.connect(overlay, (AbstractAxis)yAxis, (byte)2);
            if (!xok || !yok) {
                msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)overlay.getStmt()));
                soc.removeOverlay(overlay);
            }
        }
        boolean xok = soc.connect(scat, (AbstractAxis)xAxis, (byte)1);
        yok = soc.connect(scat, (AbstractAxis)yAxis, (byte)2);
        if (!xok || !yok) {
            msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)scat.getStmt()));
            soc.removeOverlay(scat);
            return;
        }
        soc.dataDisplayAntialiased = graph.dataAntialiased;
        soc.axisDisplayAntialiased = graph.axisAntialiased;
        soc.subpixelRendering = graph.subpixelRendering;
        graph.addSubpixelRenderer(soc);
        if (graph.dataAntialiased && !scat.isDisableAA()) {
            scat.setDisableAA(!graph.updateAAMax(scat.getRendererComplexity()));
        }
        if (graph.imagemapEnabled && scat.isTooltipEnabled()) {
            scat.setTooltipEnabled(graph.updateTipMax(scat.getNumOfTooltips()));
        }
        oc.setViewportEnabled(0, !graph.server && graph.xAxisViewportEnabled);
        oc.setViewportEnabled(1, !graph.server && graph.xAxisViewportEnabled);
        oc.setViewportEnabled(2, !graph.server && graph.yAxisViewportEnabled);
        oc.setViewportEnabled(3, !graph.server && graph.yAxisViewportEnabled);
        if (!graph.server) {
            if (graph.chartPopupMenu == null) {
                graph.chartPopupMenu = OverlayContainer.createChartPopupMenu();
            }
            oc.setChartPopupMenu(graph.chartPopupMenu);
        }
        if (graph.selectionListener != null) {
            oc.addSelectionListener(graph.selectionListener);
        }
        plot.addCellItem(row, col, (Component)oc);
        commArgs = null;
    }

    private static void addRowColHeader(StatGraph graph, TrellisPlot plot, int idx, String text, boolean row, int display, boolean reverseRows) {
        Entry entry = new Entry();
        entry.setText(text);
        TextAttrs ts = new TextAttrs();
        GraphStyle.setDefaultTextStyle(graph, null, ts, "LabelText");
        entry.setFont(ts.getFont());
        entry.setForeground(ts.getColor());
        entry.setTextAntiAliased(graph.axisAntialiased);
        if (row) {
            boolean primary;
            switch (display) {
                case 1: {
                    primary = reverseRows;
                    break;
                }
                case 2: {
                    primary = !reverseRows;
                    break;
                }
                default: {
                    primary = true;
                }
            }
            if (primary) {
                plot.addRowHeader(idx, (Component)entry);
                entry.setTheta(90.0);
                entry.setBorder(new EmptyBorder(0, 0, 0, (int)Math.ceil(10.0 * StatGraph.getGapScaleFactor())));
            } else {
                plot.addRowHeader2(idx, (Component)entry);
                entry.setTheta(90.0);
                entry.setBorder(new EmptyBorder(0, (int)Math.ceil(10.0 * StatGraph.getGapScaleFactor()), 0, 0));
            }
        } else {
            boolean primary;
            boolean bl = primary = display != 2;
            if (primary) {
                plot.addColumnHeader(idx, (Component)entry);
                entry.setBorder(new EmptyBorder(0, 0, (int)Math.ceil(5.0 * StatGraph.getGapScaleFactor()), 0));
            } else {
                plot.addColumnHeader2(idx, (Component)entry);
                entry.setBorder(new EmptyBorder((int)Math.ceil(5.0 * StatGraph.getGapScaleFactor()), 0, 0, 0));
            }
        }
    }

    private static void addEntry(StatGraph graph, TrellisPlot plot, int row, int col, String text) {
        RotatedJTextPane entry = new RotatedJTextPane();
        entry.setEditorKit(new MyEditorKit());
        entry.setOpaque(false);
        entry.setUnderOutmostLayout(true);
        entry.setAntialiased(graph.axisAntialiased);
        LineAttrs ls = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, null, ls, "WallFill");
        StyledLineBorder lineBorder = new StyledLineBorder(ls.getColor(), ls.getLinePattern(), ls.getWidth());
        entry.setBorder(lineBorder);
        TextStyle ts = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, null, ts, "LabelText");
        Document doc = entry.getDocument();
        SimpleAttributeSet set = EntryConcatParser.createAttributeSet(ts, null, false, false, false, false);
        try {
            doc.insertString(doc.getLength(), text, set);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        StyleConstants.setAlignment(set, 1);
        entry.setParagraphAttributes(set, false);
        plot.addCellItem(row, col, (Component)entry);
    }

    private static void addRowColAxis(StatGraph graph, TrellisPlot plot, int idx, boolean row, boolean reverseRows, int display, boolean diagonal) {
        byte dim = row ? (byte)2 : 1;
        GridAxis ga = new GridAxis(dim);
        LayoutOverlayParser.initAxis(graph, ga.getAxis());
        ga.setAntiAliased(graph.axisAntialiased);
        ga.setSubpixelRendering(graph.subpixelRendering);
        graph.addSubpixelRenderer(ga);
        ga.getAxis().getAxisStyle().setTitleOn(false);
        ga.getAxis().getAxisStyle().setAxisLineOn(false);
        ga.getAxis().setType(-1);
        ga.getAxis().getRectAxisParams().setSplitTickValue(false);
        boolean enabled = ga.getDimension() == 1 ? graph.xAxisViewportEnabled : graph.yAxisViewportEnabled;
        ga.setViewportEnabled(!graph.server && enabled);
        GridAxis ga2 = new GridAxis(dim);
        LayoutOverlayParser.initAxis(graph, ga2.getAxis());
        ga2.setAntiAliased(graph.axisAntialiased);
        ga2.setSubpixelRendering(graph.subpixelRendering);
        graph.addSubpixelRenderer(ga2);
        ga2.getAxis().setPrimary(false);
        ga2.getAxis().getAxisStyle().setTitleOn(false);
        ga2.getAxis().getAxisStyle().setAxisLineOn(false);
        ga2.getAxis().setType(-1);
        ga2.getAxis().getRectAxisParams().setSplitTickValue(false);
        if (!row && diagonal) {
            ga.getAxis().setVisible(false);
            ga2.getAxis().setVisible(false);
        }
        if (display == 0) {
            boolean valueOn;
            if (reverseRows) {
                int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
                valueOn = row ? (rows - 1 - idx) % 2 != 0 : idx % 2 != 0;
            } else {
                valueOn = row ? idx % 2 != 0 : idx % 2 == 0;
            }
            ga.getAxis().getAxisStyle().setLabelsOn(valueOn);
            ga2.getAxis().getAxisStyle().setLabelsOn(!valueOn);
        }
        ga2.setMirror(true);
        enabled = ga2.getDimension() == 1 ? graph.xAxisViewportEnabled : graph.yAxisViewportEnabled;
        ga2.setViewportEnabled(!graph.server && enabled);
        switch (display) {
            case 0: {
                if (row) {
                    plot.addRowAxis(idx, (Component)ga, true);
                    plot.addRowAxis(idx, (Component)ga2, false);
                    break;
                }
                plot.addColumnAxis(idx, (Component)ga, true);
                plot.addColumnAxis(idx, (Component)ga2, false);
                break;
            }
            case 1: {
                if (row) {
                    if (reverseRows) {
                        plot.addRowAxis(idx, (Component)ga, true);
                        break;
                    }
                    plot.addRowAxis(idx, (Component)ga2, false);
                    break;
                }
                plot.addColumnAxis(idx, (Component)ga2, false);
                break;
            }
            case 2: {
                if (row) {
                    if (reverseRows) {
                        plot.addRowAxis(idx, (Component)ga2, false);
                        break;
                    }
                    plot.addRowAxis(idx, (Component)ga, true);
                    break;
                }
                plot.addColumnAxis(idx, (Component)ga, true);
            }
        }
    }

    private static void parseDiagonalComponents(StatGraph graph, Element elem, Component[] comp) {
        String tag = "";
        int i = 0;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(tag = ((Element)node).getTagName()).equals("LayoutOverlay")) continue;
            comp[i] = LayoutOverlayParser.load(graph, (Element)node);
            ((BaseOverlayContainer)comp[i]).setAxesVisible(false);
            ++i;
        }
    }

    private static void parseEllipseOverlays(StatGraph graph, int nRows, int nCols, boolean square, Element EllipseElem, EllipseParmOverlay[] ellipses) {
        for (Node node = EllipseElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String str;
            int cellID;
            String tag;
            if (!(node instanceof Element) || !(tag = ((Element)node).getTagName()).equals("MatrixEllipseParm") || (cellID = (str = ((Element)node).getAttribute("cellNumber")).length() > 0 ? Integer.parseInt(str) - 1 : -1) < 0 || square && cellID / nCols == cellID % nCols) continue;
            ellipses[cellID] = EllipseParmParser.load(graph, (Element)node);
        }
    }

    private static void registerViewportListener(TrellisPlot plot, boolean hSync, boolean vSync) {
        int c;
        int i;
        int jj;
        Component comp;
        GridAxisInterface axis2;
        GridAxisInterface axis;
        int r;
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        boolean unionAllX = plot.isUniformXRange();
        boolean unionAllY = plot.isUniformYRange();
        if (unionAllY) {
            for (r = 0; r < rows; ++r) {
                axis = (GridAxisInterface)plot.getRowAxis(r, true);
                axis2 = (GridAxisInterface)plot.getRowAxis(r, false);
                for (int j = 0; j < rows; ++j) {
                    for (int i2 = 0; i2 < cols; ++i2) {
                        comp = plot.getCellItem(j, i2);
                        if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                            ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                        }
                        if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                            ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                        }
                        if (comp instanceof OverlayContainer) {
                            if (axis != null && axis instanceof ViewportListener) {
                                ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis);
                                ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis);
                            }
                            if (axis2 != null && axis2 instanceof ViewportListener) {
                                ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis2);
                                ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis2);
                            }
                        }
                        if (!(comp instanceof OverlayContainer)) continue;
                        OverlayContainer oc = (OverlayContainer)comp;
                        for (int jj2 = 0; jj2 < rows; ++jj2) {
                            for (int ii = 0; ii < cols; ++ii) {
                                if (jj2 == j && ii == i2 || !(plot.getCellItem(jj2, ii) instanceof ViewportListener)) continue;
                                oc.addViewportListener(2, (ViewportListener)((Object)plot.getCellItem(jj2, ii)));
                                oc.addViewportListener(3, (ViewportListener)((Object)plot.getCellItem(jj2, ii)));
                            }
                        }
                    }
                }
                if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                    ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                }
                if (axis != null && axis instanceof GridAxis && axis2 instanceof ViewportListener) {
                    ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
                }
                for (jj = 0; jj < rows; ++jj) {
                    GridAxisInterface raxis = (GridAxisInterface)plot.getRowAxis(jj, true);
                    GridAxisInterface raxis2 = (GridAxisInterface)plot.getRowAxis(jj, false);
                    if (jj == r) continue;
                    if (raxis != null && raxis instanceof GridAxis) {
                        if (axis instanceof ViewportListener) {
                            ((GridAxis)raxis).addViewportListener((ViewportListener)axis);
                        }
                        if (axis2 instanceof ViewportListener) {
                            ((GridAxis)raxis).addViewportListener((ViewportListener)axis2);
                        }
                    }
                    if (raxis2 == null || !(raxis2 instanceof GridAxis)) continue;
                    if (axis instanceof ViewportListener) {
                        ((GridAxis)raxis2).addViewportListener((ViewportListener)axis);
                    }
                    if (!(axis2 instanceof ViewportListener)) continue;
                    ((GridAxis)raxis2).addViewportListener((ViewportListener)axis2);
                }
            }
        } else {
            for (r = 0; r < rows; ++r) {
                axis = (GridAxisInterface)plot.getRowAxis(r, true);
                axis2 = (GridAxisInterface)plot.getRowAxis(r, false);
                for (i = 0; i < cols; ++i) {
                    comp = plot.getCellItem(r, i);
                    if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                        ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                    }
                    if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                        ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                    }
                    if (comp instanceof OverlayContainer) {
                        if (axis != null && axis instanceof ViewportListener) {
                            ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis);
                            ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis);
                        }
                        if (axis2 != null && axis2 instanceof ViewportListener) {
                            ((OverlayContainer)comp).addViewportListener(2, (ViewportListener)axis2);
                            ((OverlayContainer)comp).addViewportListener(3, (ViewportListener)axis2);
                        }
                    }
                    if (!(comp instanceof OverlayContainer) || !vSync) continue;
                    OverlayContainer oc = (OverlayContainer)comp;
                    for (int j = 0; j < cols; ++j) {
                        if (j == i || !(plot.getCellItem(r, j) instanceof ViewportListener)) continue;
                        oc.addViewportListener(2, (ViewportListener)((Object)plot.getCellItem(r, j)));
                        oc.addViewportListener(3, (ViewportListener)((Object)plot.getCellItem(r, j)));
                    }
                }
                if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                    ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                }
                if (axis == null || !(axis instanceof GridAxis) || !(axis2 instanceof ViewportListener)) continue;
                ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
            }
        }
        if (unionAllX) {
            for (c = 0; c < cols; ++c) {
                axis = (GridAxisInterface)plot.getColumnAxis(c, true);
                axis2 = (GridAxisInterface)plot.getColumnAxis(c, false);
                for (i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        comp = plot.getCellItem(i, j);
                        if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                            ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                        }
                        if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                            ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                        }
                        if (comp instanceof OverlayContainer) {
                            if (axis != null && axis instanceof ViewportListener) {
                                ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis);
                                ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis);
                            }
                            if (axis2 != null && axis2 instanceof ViewportListener) {
                                ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis2);
                                ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis2);
                            }
                        }
                        if (!(comp instanceof OverlayContainer)) continue;
                        OverlayContainer oc = (OverlayContainer)comp;
                        for (int ii = 0; ii < rows; ++ii) {
                            for (int jj3 = 0; jj3 < cols; ++jj3) {
                                if (ii == i && jj3 == j || !(plot.getCellItem(ii, jj3) instanceof ViewportListener)) continue;
                                oc.addViewportListener(0, (ViewportListener)((Object)plot.getCellItem(ii, jj3)));
                                oc.addViewportListener(1, (ViewportListener)((Object)plot.getCellItem(ii, jj3)));
                            }
                        }
                    }
                }
                if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                    ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                }
                if (axis != null && axis instanceof GridAxis && axis2 instanceof ViewportListener) {
                    ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
                }
                for (jj = 0; jj < cols; ++jj) {
                    GridAxisInterface caxis = (GridAxisInterface)plot.getColumnAxis(jj, true);
                    GridAxisInterface caxis2 = (GridAxisInterface)plot.getColumnAxis(jj, false);
                    if (jj == c) continue;
                    if (caxis != null && caxis instanceof GridAxis) {
                        if (axis instanceof ViewportListener) {
                            ((GridAxis)caxis).addViewportListener((ViewportListener)axis);
                        }
                        if (axis2 instanceof ViewportListener) {
                            ((GridAxis)caxis).addViewportListener((ViewportListener)axis2);
                        }
                    }
                    if (caxis2 == null || !(caxis2 instanceof GridAxis)) continue;
                    if (axis instanceof ViewportListener) {
                        ((GridAxis)caxis2).addViewportListener((ViewportListener)axis);
                    }
                    if (!(axis2 instanceof ViewportListener)) continue;
                    ((GridAxis)caxis2).addViewportListener((ViewportListener)axis2);
                }
            }
        } else {
            for (c = 0; c < cols; ++c) {
                axis = (GridAxisInterface)plot.getColumnAxis(c, true);
                axis2 = (GridAxisInterface)plot.getColumnAxis(c, false);
                for (i = 0; i < rows; ++i) {
                    comp = plot.getCellItem(i, c);
                    if (axis != null && axis instanceof GridAxis && comp instanceof ViewportListener) {
                        ((GridAxis)axis).addViewportListener((ViewportListener)((Object)comp));
                    }
                    if (axis2 != null && axis2 instanceof GridAxis && comp instanceof ViewportListener) {
                        ((GridAxis)axis2).addViewportListener((ViewportListener)((Object)comp));
                    }
                    if (comp instanceof OverlayContainer) {
                        if (axis != null && axis instanceof ViewportListener) {
                            ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis);
                            ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis);
                        }
                        if (axis2 != null && axis2 instanceof ViewportListener) {
                            ((OverlayContainer)comp).addViewportListener(0, (ViewportListener)axis2);
                            ((OverlayContainer)comp).addViewportListener(1, (ViewportListener)axis2);
                        }
                    }
                    if (!(comp instanceof OverlayContainer) || !hSync) continue;
                    OverlayContainer oc = (OverlayContainer)comp;
                    for (int j = 0; j < rows; ++j) {
                        if (j == i || !(plot.getCellItem(j, c) instanceof ViewportListener)) continue;
                        oc.addViewportListener(0, (ViewportListener)((Object)plot.getCellItem(j, c)));
                        oc.addViewportListener(1, (ViewportListener)((Object)plot.getCellItem(j, c)));
                    }
                }
                if (axis2 != null && axis2 instanceof GridAxis && axis instanceof ViewportListener) {
                    ((GridAxis)axis2).addViewportListener((ViewportListener)axis);
                }
                if (axis == null || !(axis instanceof GridAxis) || !(axis2 instanceof ViewportListener)) continue;
                ((GridAxis)axis).addViewportListener((ViewportListener)axis2);
            }
        }
    }
}

