/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RangeAttrMapViewOverlay;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RangeAttrMapViewParser {
    public static final String RB_KEY = "RangeAttrMapViewParser.";

    public static RangeAttrMapViewOverlay load(StatGraph graph, Element elem) {
        RangeAttrMapViewOverlay view = (RangeAttrMapViewOverlay)graph.getObjectFromElement(elem);
        if (view == null) {
            view = new RangeAttrMapViewOverlay();
        }
        return RangeAttrMapViewParser.load(graph, view, elem) ? view : null;
    }

    public static boolean load(StatGraph graph, RangeAttrMapViewOverlay view, Element elem) {
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, view);
        String str = elem.getAttribute("x");
        if (str.length() > 0 && graph.getRangeAttrMap(str) != null) {
            view.setXRangeAttributeMap(graph.getRangeAttrMap(str));
        }
        if ((str = elem.getAttribute("y")).length() > 0 && graph.getRangeAttrMap(str) != null) {
            view.setYRangeAttributeMap(graph.getRangeAttrMap(str));
        }
        if (view.getXRangeAttributeMap() == null && view.getYRangeAttributeMap() == null) {
            graph.removeNamedGraph(view);
            return false;
        }
        str = elem.getAttribute("primaryRangeAttrMap");
        if (str.length() > 0 && str.equalsIgnoreCase("y")) {
            view.setPrimaryRangeAttributeMap((byte)2);
        }
        if ((str = elem.getAttribute("clip")).length() > 0 && str.equalsIgnoreCase("true")) {
            view.setClipping(true);
        }
        if ((str = elem.getAttribute("extend")).length() > 0 && str.equalsIgnoreCase("false")) {
            view.setExtend(false);
        }
        if ((str = elem.getAttribute("display")).length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                view.setLineOn(true);
                view.setFillOn(true);
            } else {
                view.setLineOn(false);
                view.setFillOn(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("line")) {
                        view.setLineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        view.setFillOn(true);
                        continue;
                    }
                    view.setLineOn(false);
                    view.setFillOn(true);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            view.setLineOn(false);
            view.setFillOn(true);
        }
        String contextName = graph.style.isCycleAttrs() ? graph.style.getContextName() : "GraphDataStyleDefault";
        view.setContextName(contextName);
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), view.getLineStyle(), contextName);
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), view.getFillStyle(), contextName);
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs") && view.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, view.getFillStyle());
                if (!((Element)node).hasAttribute("color")) continue;
                view.setUseFillColor(true);
                continue;
            }
            if (!elemTag.equals("LineAttrs") || !view.isLineOn()) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, view.getLineStyle());
            if (!((Element)node).hasAttribute("color")) continue;
            view.setUseLineColor(true);
        }
        view.setStyle(graph.style.getGraphStyle());
        return true;
    }
}

