/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PolygonOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PolygonParser {
    public static final String RB_KEY = "PolygonParser.";

    public static PolygonOverlay load(StatGraph graph, Element elem) {
        if (graph.isCASData()) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "casdata.txt"));
            return null;
        }
        PolygonOverlay poly = (PolygonOverlay)graph.getObjectFromElement(elem);
        if (poly == null) {
            poly = new PolygonOverlay();
        }
        return PolygonParser.load(graph, poly, elem) ? poly : null;
    }

    public static boolean load(StatGraph graph, PolygonOverlay poly, Element elem) {
        int maxVertices;
        int i;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        DataModel model = graph.getData(dataName);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        if (!StatGraph.checkVariable("X", model.getColumnLabel(xcol), null, 1, true)) {
            return false;
        }
        if (!StatGraph.checkVariable("Y", model.getColumnLabel(ycol), null, 1, true)) {
            return false;
        }
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol);
        int numX = cmd.getNobs() - cmd.getMissings();
        cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        int numY = cmd.getNobs() - cmd.getMissings();
        if (numX < 3 || numY < 3) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "lessdata.txt"));
            return false;
        }
        map.map(10, xcol);
        map.map(11, ycol);
        boolean gotID = false;
        str = elem.getAttribute("id");
        if (str.length() > 0) {
            String idVarID = StatGraph.getVarID(str);
            int idcol = model.getColumn(idVarID);
            map.map(23, idcol);
            poly.addRole("ID", model.getColumnLabel(idcol));
            gotID = true;
        }
        if ((str = elem.getAttribute("label")).length() > 0 && gotID) {
            String labelVarID = StatGraph.getVarID(str);
            int lcol = model.getColumn(labelVarID);
            map.map(5, lcol);
            poly.addRole("LABEL", model.getColumnLabel(lcol));
        }
        if ((str = elem.getAttribute("xOffset")).length() > 0) {
            String xoffVarID;
            int xocol;
            if (StatGraph.isNumber(str)) {
                double offset = Double.parseDouble(str);
                if (offset >= -0.5 && offset <= 0.5) {
                    poly.setXDiscreteOffset(offset);
                } else {
                    StatGraph.printOptionError("XOFFSET", str);
                }
            } else if (gotID && StatGraph.checkVariable("XOFFSET", cmd = (ColumnMetadata)model.getColumnLabel(xocol = model.getColumn(xoffVarID = StatGraph.getVarID(str))), Double.class, 1, true)) {
                if (cmd.getMin() < -0.5 || cmd.getMax() > 0.5) {
                    StatGraph.printOptionError("XOFFSET", cmd.getName());
                } else {
                    map.map(37, xocol);
                }
            }
        }
        if ((str = elem.getAttribute("yOffset")).length() > 0) {
            String yoffVarID;
            int yocol;
            if (StatGraph.isNumber(str)) {
                double offset = Double.parseDouble(str);
                if (offset >= -0.5 && offset <= 0.5) {
                    poly.setYDiscreteOffset(offset);
                } else {
                    StatGraph.printOptionError("YOFFSET", str);
                }
            } else if (gotID && StatGraph.checkVariable("YOFFSET", cmd = (ColumnMetadata)model.getColumnLabel(yocol = model.getColumn(yoffVarID = StatGraph.getVarID(str))), Double.class, 1, true)) {
                if (cmd.getMin() < -0.5 || cmd.getMax() > 0.5) {
                    StatGraph.printOptionError("YOFFSET", cmd.getName());
                } else {
                    map.map(38, yocol);
                }
            }
        }
        if ((str = elem.getAttribute("rotate")).length() > 0) {
            String rotVarID;
            int rotcol;
            if (StatGraph.isNumber(str)) {
                double rotate = Double.parseDouble(str);
                poly.setRotate(rotate);
                if (rotate != 0.0) {
                    poly.setRotatedPolygon(true);
                }
            } else if (gotID && StatGraph.checkVariable("ROTATE", cmd = (ColumnMetadata)model.getColumnLabel(rotcol = model.getColumn(rotVarID = StatGraph.getVarID(str))), Double.class, 1, true)) {
                map.map(118, rotcol);
                poly.setRotatedPolygon(true);
            }
        }
        str = elem.getAttribute("primary");
        poly.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, poly);
        if (poly.getXAxis().equalsIgnoreCase("x2")) {
            poly.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            poly.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (poly.getYAxis().equalsIgnoreCase("y2")) {
            poly.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            poly.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        poly.setFillOn(false);
        poly.setOutlineOn(false);
        poly.setFillPatternOn(false);
        str = elem.getAttribute("display");
        if (str.length() == 0 && (str = graph.style.getStyleAttribute("Polygon", "displayOpts")) == null) {
            str = "";
        }
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                poly.setFillOn(true);
                poly.setOutlineOn(true);
                poly.setFillPatternOn(true);
            } else {
                String[] opts = StatGraph.parseList2String(str);
                for (i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        poly.setOutlineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        poly.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        poly.setFillPatternOn(true);
                        continue;
                    }
                    poly.setFillOn(false);
                    poly.setOutlineOn(true);
                    poly.setFillPatternOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        if (!(poly.isOutlineOn() || poly.isFillOn() || poly.isFillPatternOn())) {
            poly.setOutlineOn(true);
            poly.setFillOn(false);
            poly.setFillPatternOn(false);
        }
        StatGraph.parseDataSkinOpt(graph, elem, poly);
        str = elem.getAttribute("labelSplit");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            poly.setDataLabelSplit(true);
        }
        if ((str = elem.getAttribute("labelSplitChar")).length() > 0) {
            char[] schars = new char[str.length()];
            for (i = 0; i < str.length(); ++i) {
                schars[i] = str.charAt(i);
            }
            poly.setDataLabelSplitChar(schars);
        }
        if ((str = elem.getAttribute("labelSplitCharDrop")).length() > 0 && str.equalsIgnoreCase("false")) {
            poly.setDataLabelSplitCharDrop(false);
        }
        if ((str = elem.getAttribute("labelSplitJustify")).length() > 0) {
            if (str.equalsIgnoreCase("left")) {
                poly.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_LEFT);
            } else if (str.equalsIgnoreCase("right")) {
                poly.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_RIGHT);
            } else if (str.equalsIgnoreCase("center")) {
                poly.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_CENTER);
            } else if (str.equalsIgnoreCase("auto")) {
                poly.setDataLabelSplitJustify(ScatterOverlay.SPLIT_JUSTIFY_AUTO);
            } else {
                StatGraph.printOptionError("LABELSPLITJUSTIFY", str);
            }
        }
        if (!poly.isRotatedPolygon()) {
            str = elem.getAttribute("labelLocation");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("OUTSIDEBBOX")) {
                    poly.setLabelLocation(1);
                } else if (str.equalsIgnoreCase("OUTSIDE")) {
                    if (BandParser.isUnderLatticeLayout(elem)) {
                        poly.setLabelLocation(0);
                        StatGraph.printNote(RB.getStringResource(RB_KEY, "outsidelabel.txt"));
                    } else {
                        poly.setLabelLocation(2);
                    }
                } else if (str.equalsIgnoreCase("INSIDEBBOX")) {
                    poly.setLabelLocation(0);
                } else {
                    StatGraph.printOptionError("LABELLOCATION", str);
                }
            }
            int lp = poly.getLabelLocation() == 0 ? 0 : 5;
            poly.setLabelPosition(lp);
            str = elem.getAttribute("labelPosition");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("XMIN")) {
                    poly.setLabelPosition(2);
                } else if (str.equalsIgnoreCase("XMAX")) {
                    poly.setLabelPosition(3);
                } else if (str.equalsIgnoreCase("YMIN")) {
                    poly.setLabelPosition(4);
                } else if (str.equalsIgnoreCase("YMAX")) {
                    poly.setLabelPosition(5);
                } else if (poly.getLabelLocation() == 0) {
                    if (str.equalsIgnoreCase("CENTROID")) {
                        poly.setLabelPosition(1);
                    } else if (str.equalsIgnoreCase("CENTER")) {
                        poly.setLabelPosition(0);
                    } else {
                        StatGraph.printOptionError("LABELPOSITION", str);
                    }
                } else {
                    StatGraph.printOptionError("LABELPOSITION", str);
                }
            }
        }
        if ((str = elem.getAttribute("rotateLabel")).length() > 0) {
            if (poly.isRotatedPolygon()) {
                if (str.equalsIgnoreCase("none")) {
                    poly.setLabelRotate(1);
                } else if (!str.equalsIgnoreCase("auto")) {
                    StatGraph.printOptionError("ROTATELABEL", str);
                }
            } else if (str.equalsIgnoreCase("vertical")) {
                poly.setLabelRotate(2);
            } else if (str.equalsIgnoreCase("auto") || str.equalsIgnoreCase("none")) {
                poly.setLabelRotate(1);
            } else {
                StatGraph.printOptionError("ROTATELABEL", str);
            }
        }
        Element fillElem = null;
        Element outlineElem = null;
        Element labelElem = null;
        Element fillPatternElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs")) {
                fillElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OutlineAttrs")) {
                outlineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("LabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("FillPatternAttrs")) continue;
            fillPatternElem = (Element)node;
        }
        String contextName = graph.style.getContextName();
        poly.setContextName(contextName);
        FillAttrs fillStyle = poly.getFillStyle();
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, contextName);
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, fillStyle);
        }
        poly.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        LineAttrs outlineStyle = poly.getOutlineStyle();
        if (graph.style.isCycleAttrs()) {
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), outlineStyle, contextName);
        } else {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), outlineStyle, "Outlines");
        }
        if (outlineElem != null) {
            StatGraph.parseLineAttrs(graph, outlineElem, outlineStyle);
        }
        poly.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        TextAttrs labelStyle = poly.getLabelStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), labelStyle, "DataText");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, labelStyle);
        }
        FillPatternAttrs fillPatternStyle = poly.getFillPatternStyle();
        GraphStyle.setDefaultFillPatternStyle(graph, elem.getAttribute("fillPatternAttrs"), fillPatternStyle, contextName);
        if (fillPatternElem != null) {
            StatGraph.parseFillPatternAttrs(graph, fillPatternElem, fillPatternStyle);
        }
        boolean gradientColor = false;
        str = elem.getAttribute("colorResponse");
        if (str.length() > 0 && gotID) {
            String crVarID = StatGraph.getVarID(str);
            int crcol = model.getColumn(crVarID);
            if (StatGraph.checkVariable("COLORRESPONSE", model.getColumnLabel(crcol), Double.class, 1, false)) {
                map.map(108, crcol);
                poly.addRole("COLORRESPONSE", model.getColumnLabel(crcol));
                gradientColor = true;
            }
            if ((str = elem.getAttribute("colorResponseAttrVar")).length() > 0) {
                poly.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
            }
        }
        if ((str = elem.getAttribute("group")).length() > 0 && gotID) {
            String groupVarID = StatGraph.getVarID(str);
            if (LayoutOverlayParser.hasTooManyGroups(graph, model, groupVarID, poly.getStmt())) {
                groupVarID = "";
            }
            if (groupVarID.length() > 0) {
                boolean lineMapped;
                int gcol = model.getColumn(groupVarID);
                map.map(3, gcol);
                poly.addRole("GROUP", model.getColumnLabel(gcol));
                boolean fillColorMapped = false;
                boolean outlineColorMapped = false;
                boolean fillPatternMapped = false;
                boolean fillPatternColorMapped = false;
                if (poly.isFillOn()) {
                    boolean bl = fillColorMapped = elem.hasAttribute("fillAttrs") || fillElem != null && fillElem.hasAttribute("color");
                }
                if (poly.isOutlineOn()) {
                    boolean bl = outlineColorMapped = elem.hasAttribute("outlineAttrs") || outlineElem != null && outlineElem.hasAttribute("color");
                }
                if (!(gradientColor || fillColorMapped && outlineColorMapped)) {
                    if (!fillColorMapped) {
                        map.map(6, gcol);
                    }
                    if (!outlineColorMapped) {
                        map.map(46, gcol);
                    }
                }
                boolean bl = lineMapped = elem.hasAttribute("outlineAttrs") || outlineElem != null && outlineElem.hasAttribute("pattern");
                if (!(lineMapped || poly.isFillOn() || poly.isFillPatternOn())) {
                    map.map(36, gcol);
                }
                if (poly.isFillPatternOn()) {
                    fillPatternMapped = elem.hasAttribute("fillPatternAttrs") || fillPatternElem != null && fillPatternElem.hasAttribute("pattern");
                    boolean bl2 = fillPatternColorMapped = elem.hasAttribute("fillPatternAttrs") || fillPatternElem != null && fillPatternElem.hasAttribute("color");
                    if (!fillPatternMapped) {
                        map.map(111, gcol);
                    }
                    if (!gradientColor && !fillPatternColorMapped) {
                        map.map(112, gcol);
                    }
                }
                if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                    poly.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, poly, "GROUP", groupVarID);
                }
                str = elem.getAttribute("includeMissingGroup");
                if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                    poly.setMissingGroupOn(false);
                }
            }
        }
        StatGraph.parseURLOpt(elem, model, map, poly);
        LayoutOverlayParser.parseRoleTipStuff(elem, model, map, poly);
        CRD crd = new CRD();
        crd.setSrcModel(model);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, poly);
        poly.setModel(crd);
        boolean useLabelColor = false;
        if (!crd.isAvailable(3) && !crd.isAvailable(108)) {
            useLabelColor = true;
        } else if (elem.hasAttribute("labelAttrs") || labelElem != null && labelElem.hasAttribute("color")) {
            useLabelColor = true;
        }
        poly.setUseLabelColor(useLabelColor);
        str = elem.getAttribute("backlight");
        if (StatGraph.isNumber(str)) {
            double d = Double.parseDouble(str);
            if (d >= 0.0 && d <= 1.0) {
                poly.setLabelBacklight(d);
            }
        } else if (str.equalsIgnoreCase("auto")) {
            if (useLabelColor) {
                poly.setLabelBacklight(0.5);
            } else {
                poly.setLabelBacklight(0.75);
            }
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(108)) {
            Color missingGradientColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
            poly.setMissingGradientColor(missingGradientColor);
            double tr = poly.isFillOn() ? poly.getFillStyle().getTransparency() : -1.0;
            byte dd = poly.isFillOn() ? (byte)4 : 17;
            ColorEncoder encoder = StatGraph.parseColorModelOpt(dd, graph, elem, poly, tr);
            if (encoder != null) {
                poly.setEncoder(dd, encoder);
                if (!poly.isFillOn() && poly.isFillPatternOn()) {
                    poly.setEncoder((byte)22, encoder);
                }
            }
        }
        if (crd.isAvailable(3)) {
            graph.style.setContextCount(contextCount);
            if (poly.isFillOn() && crd.isAvailable(6)) {
                LayoutOverlayParser.setDiscreteEncoder(graph, poly, (byte)4, (short)3, poly.getFillStyle().getTransparency(), true);
            }
            if (poly.isOutlineOn() && crd.isAvailable(36)) {
                LayoutOverlayParser.setDiscreteEncoder(graph, poly, (byte)15, (short)3, -1.0, true);
            }
            int contrastColorCnt = graph.style.getContrastColorCount();
            if (poly.isOutlineOn() && crd.isAvailable(46)) {
                LayoutOverlayParser.setDiscreteEncoder(graph, poly, (byte)17, (short)3, -1.0, true);
                if (!useLabelColor) {
                    poly.setEncoder((byte)25, poly.getEncoder((byte)17));
                }
            } else if (!useLabelColor) {
                LayoutOverlayParser.setDiscreteEncoder(graph, poly, (byte)25, (short)3, -1.0, true);
            }
            graph.style.setContrastColorCount(contrastColorCnt);
            if (poly.isFillPatternOn() && crd.isAvailable(112)) {
                LayoutOverlayParser.setDiscreteEncoder(graph, poly, (byte)22, (short)3, -1.0, true);
            }
            if (poly.isFillPatternOn() && crd.isAvailable(111)) {
                LayoutOverlayParser.setDiscreteEncoder(graph, poly, (byte)21, (short)3, -1.0, true);
            }
        }
        graph.style.resetToCurrentCounters();
        if (!StatGraph.suppressWarningMsg && poly.isFillPatternOn() && (maxVertices = poly.getMaxVerticesPerPolygon(graph.fillPatternOBSMax)) > graph.fillPatternOBSMax) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "fillpatternmax.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)elem.getAttribute("_stmt").toUpperCase()), false);
        }
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        DataModel model = graph.getData(dataName);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol);
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
                return null;
            }
            types[0] = 2;
        } else {
            types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                return null;
            }
            types[1] = 2;
        } else {
            types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        types[2] = 0;
        return types;
    }
}

