/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.regions.PieRegion;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.pie.Pie;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.text.Message;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PieParser2 {
    public static final String RB_KEY = "PieParser2.";

    public static PieRegion load(StatGraph graph, Element elem) {
        PieRegion pie = (PieRegion)graph.getObjectFromElement(elem);
        if (pie == null) {
            pie = new PieRegion();
        }
        return PieParser2.load(graph, pie, elem) ? pie : null;
    }

    public static boolean load(StatGraph graph, PieRegion pie, Element elem) {
        TextAttrs glta;
        Element invElem;
        graph.addSupportedGraph();
        String dataName = null;
        DataModel m = null;
        RoleColumnMap map = new RoleColumnMap();
        String str = elem.getAttribute("category");
        dataName = StatGraph.getDataName(str);
        String categoryVarID = StatGraph.getVarID(str);
        boolean olap = false;
        m = graph.getOLAPModel(dataName);
        if (m == null) {
            m = graph.getData(dataName);
        } else {
            olap = true;
        }
        if (olap) {
            pie.setCategoryVariable(categoryVarID);
            map.map(1, categoryVarID);
        } else {
            int ccol = m.getColumn(categoryVarID);
            if (!StatGraph.checkVariable("CATEGORY", m.getColumnLabel(ccol), null, 1, true)) {
                return false;
            }
            pie.setCategoryVariable(categoryVarID);
            map.map(1, ccol);
            pie.addRole("CATEGORY", m.getColumnLabel(ccol));
        }
        if (graph.isCASData()) {
            pie.setCategoryOrder(1);
        }
        boolean hasResponse = false;
        boolean hasMultipleResponse = false;
        Element rVarsElem = StatGraph.getOptionAttrsElement(elem, "ResponseVars");
        if (rVarsElem != null) {
            String[] responseVars = StatGraph.parseStringValueList(rVarsElem, "Value");
            if (responseVars != null && responseVars.length > 0) {
                int nCols = responseVars.length;
                String[] responseVarIds = new String[nCols];
                Vector<String> rv = new Vector<String>();
                int cnt = 0;
                for (int i = 0; i < nCols; ++i) {
                    responseVarIds[i] = StatGraph.getVarID(responseVars[i]);
                    if (olap) {
                        rv.add(responseVarIds[i]);
                        map.map(610 + cnt, responseVarIds[i]);
                    } else if (StatGraph.checkVariable("RESPONSE", m.getColumnLabel(m.getColumn(responseVarIds[i])), Double.class, 1, true)) {
                        rv.add(responseVarIds[i]);
                    }
                    ++cnt;
                }
                if (rv.size() <= 0) {
                    return false;
                }
                hasResponse = true;
                String[] resV = rv.toArray(new String[rv.size()]);
                pie.setResponseVariables(resV);
                hasMultipleResponse = rv.size() > 1;
            }
        } else {
            str = elem.getAttribute("response");
            if (str.length() > 0) {
                String responseVarID = StatGraph.getVarID(str);
                if (olap) {
                    pie.setResponseVariables(new String[]{responseVarID});
                    map.map(2, responseVarID);
                    hasResponse = true;
                } else {
                    int tcol = m.getColumn(responseVarID);
                    if (StatGraph.checkVariable("RESPONSE", m.getColumnLabel(tcol), Double.class, 1, true)) {
                        pie.setResponseVariables(new String[]{responseVarID});
                        map.map(2, tcol);
                        pie.addRole("RESPONSE", m.getColumnLabel(tcol));
                        hasResponse = true;
                    } else {
                        return false;
                    }
                }
            }
        }
        LayoutRegionParser.parseGraphOpts(graph, elem, pie);
        StatGraph.parseURLOpt(elem, m, map, pie);
        boolean hasGroup = false;
        str = elem.getAttribute("group");
        if (str.length() > 0) {
            if (hasMultipleResponse) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "ConflictingOption.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"GROUP", (Object)"RESPONSE"));
            } else {
                hasGroup = true;
                String groupVarID = StatGraph.getVarID(str);
                if (olap) {
                    pie.setGroupVariable(groupVarID);
                    map.map(3, groupVarID);
                } else {
                    pie.setGroupVariable(groupVarID);
                    int gCol = m.getColumn(groupVarID);
                    map.map(3, gCol);
                    pie.addRole("GROUP", m.getColumnLabel(gCol));
                }
                if (graph.isCASData()) {
                    pie.setGroupOrder(1);
                }
            }
        }
        if (elem.hasAttribute("includeMissingGroup") && "false".equalsIgnoreCase(str = elem.getAttribute("includeMissingGroup"))) {
            pie.setIncludeMissingGroup(false);
        }
        if ((str = elem.getAttribute("categoryIndex")).length() > 0) {
            String indexVarID = StatGraph.getVarID(str);
            if (olap) {
                pie.setIndexVariable(indexVarID);
                map.map(41, indexVarID);
            } else {
                int icol = m.getColumn(indexVarID);
                if (StatGraph.checkVariable("CATEGORYINDEX", m.getColumnLabel(icol), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, icol, "CATEGORYINDEX", indexVarID)) {
                    pie.setIndexVariable(indexVarID);
                }
            }
        }
        str = elem.getAttribute("stat").toUpperCase();
        if (hasResponse) {
            pie.setStatistic(6);
            if (str.equals("MEAN")) {
                pie.setStatistic(1);
            } else if (str.equals("SUM")) {
                pie.setStatistic(6);
            } else if (str.equals("MIN")) {
                pie.setStatistic(10);
            } else if (str.equals("MAX")) {
                pie.setStatistic(11);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("STAT", str);
            }
        } else {
            pie.setStatistic(2);
            if (str.equals("FREQ")) {
                pie.setStatistic(2);
            } else if (str.equals("PCT")) {
                pie.setStatistic(3);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("STAT", str);
            }
        }
        Element groupLabelOptsElement = StatGraph.getOptionAttrsElement(elem, "GroupLabelOpts");
        if (groupLabelOptsElement != null) {
            str = groupLabelOptsElement.getAttribute("label");
            if (str.equalsIgnoreCase("AUTO")) {
                pie.setGroupLabel(null);
            } else if (str.equalsIgnoreCase("NONE")) {
                pie.setGroupLabel("");
            } else if (str.length() > 0) {
                pie.setGroupLabel(str);
            }
        }
        Color[] cls = graph.style.fillColorList;
        pie.setColorList(cls);
        LayoutRegionParser.parseRoleTipStuff(elem, m, pie);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutRegionParser.parseWhere(graph, crd, pie);
        pie.setCRD(crd);
        pie.setDataModel(m);
        Pie pieObj = pie.getPieObj();
        if (graph.dataAntialiased) {
            int slices = pie.getNumSlices();
            boolean aa = graph.updateAAMax(slices);
            pieObj.setAntialiasedGraphics(aa);
            pieObj.setAntialiasedText(aa);
        } else {
            pieObj.setAntialiasedGraphics(false);
            pieObj.setAntialiasedText(false);
        }
        if (graph.imagemapEnabled && pie.isTooltipEnabled()) {
            int slices = pie.getNumSlices();
            boolean im = graph.updateTipMax(slices);
            pie.setTooltipEnabled(im);
        } else {
            pie.setTooltipEnabled(false);
        }
        str = elem.getAttribute("type");
        if (str.length() > 0) {
            if ("Extruded".equalsIgnoreCase(str)) {
                pieObj.set3D(true);
            }
            if ("sector".equalsIgnoreCase(str) && !hasMultipleResponse) {
                pieObj.getModel().setSectorPie(true);
                str = "";
                Color[] colArray = graph.style.getRampColors(str, "TwoColorAltRamp");
                if (colArray.length > 2) {
                    pieObj.getModel().setTwoColorAltRampColors(colArray[0], colArray[2]);
                }
            }
        }
        if ((str = elem.getAttribute("groupDisplay")).length() > 0) {
            if (hasGroup) {
                if ("STACK".equalsIgnoreCase(str)) {
                    pieObj.getModel().setSubgroupStacked(true);
                } else if ("CLUSTER".equalsIgnoreCase(str)) {
                    pieObj.getModel().setSubgroupStacked(false);
                } else {
                    pieObj.getModel().setSubgroupStacked(true);
                }
            } else if (hasMultipleResponse) {
                if ("STACK".equalsIgnoreCase(str)) {
                    pieObj.getModel().setSubgroupStacked(false);
                } else if ("CLUSTER".equalsIgnoreCase(str)) {
                    pieObj.getModel().setSubgroupStacked(true);
                } else {
                    pieObj.getModel().setSubgroupStacked(false);
                }
            }
        } else {
            boolean flag = !hasMultipleResponse;
            pieObj.getModel().setSubgroupStacked(flag);
        }
        Element exElem = StatGraph.getOptionAttrsElement(elem, "ExplodedSlices");
        if (exElem != null) {
            if (pie.getGroupVar() != null) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "ConflictingOption.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"EXPLODEDSLICES", (Object)"GROUP"));
            } else if (hasMultipleResponse) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "ConflictingOption.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)"EXPLODEDSLICES", (Object)"RESPONSE"));
            } else {
                ArrayList<String> values = new ArrayList<String>();
                String elemTag = "";
                for (Node node = exElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("Value")) continue;
                    boolean keyword = false;
                    if ("keyword".equalsIgnoreCase(((Element)node).getAttribute("type")) && "OTHER".equalsIgnoreCase(((Element)node).getTextContent())) {
                        keyword = true;
                    }
                    if (keyword) {
                        pieObj.setExplodeOtherSlice(true);
                        continue;
                    }
                    values.add(((Element)node).getTextContent());
                }
                String[] vs = new String[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    vs[i] = (String)values.get(i);
                }
                pieObj.setExplodedCategories(vs);
            }
        }
        if ((invElem = StatGraph.getOptionAttrsElement(elem, "InvisibleSlices")) != null) {
            ArrayList<String> values = new ArrayList<String>();
            String elemTag = "";
            for (Node node = invElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("Value")) continue;
                boolean keyword = false;
                if ("keyword".equalsIgnoreCase(((Element)node).getAttribute("type")) && "OTHER".equalsIgnoreCase(((Element)node).getTextContent())) {
                    keyword = true;
                }
                if (keyword) {
                    pieObj.setVisibleOtherSlice(false);
                    continue;
                }
                values.add(((Element)node).getTextContent());
            }
            String[] vs = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                vs[i] = (String)values.get(i);
            }
            pieObj.setInvisibleCategories(vs);
        }
        FillAttrs ofa = new FillAttrs();
        GraphStyle.setDefaultDataFillStyle(graph, null, ofa, "Other");
        str = elem.getAttribute("otherSlice");
        if (str.equalsIgnoreCase("false")) {
            pieObj.setShowOtherSlice(false);
        } else {
            Element oe = StatGraph.getOptionAttrsElement(elem, "OtherSliceOpts");
            if (oe != null) {
                str = oe.getAttribute("type");
                if (str.equalsIgnoreCase("MAXSLICES")) {
                    pieObj.setOtherThresholdType(Pie.OtherSliceType.MAXSLICE);
                } else if (str.equalsIgnoreCase("PERCENT")) {
                    pieObj.setOtherThresholdType(Pie.OtherSliceType.PERCENT);
                } else if (str.length() > 0) {
                    StatGraph.printOptionError("TYPE", str);
                }
                str = oe.getAttribute("maxSlices");
                if (StatGraph.isNumber(str)) {
                    double ms = Double.parseDouble(str);
                    if (ms > 0.0 && ms == (double)((int)ms)) {
                        pieObj.setOtherMaxSlices((int)ms);
                    } else {
                        StatGraph.printOptionError("MAXSLICES", str);
                    }
                } else if (str.length() > 0) {
                    StatGraph.printOptionError("MAXSLICES", str);
                }
                str = oe.getAttribute("percent");
                if (StatGraph.isNumber(str)) {
                    double p = Double.parseDouble(str);
                    if (p >= 0.0) {
                        pieObj.setOtherPercent(p);
                    } else {
                        StatGraph.printOptionError("PERCENT", str);
                    }
                } else if (str.length() > 0) {
                    StatGraph.printOptionError("PERCENT", str);
                }
                str = oe.getAttribute("label");
                if (str.trim().length() > 0) {
                    pieObj.setOtherLabel(str);
                }
                String fillAttrs = oe.getAttribute("fillAttrs");
                Element fe = StatGraph.getOptionAttrsElement(oe, "FillAttrs");
                GraphStyle.setDefaultDataFillStyle(graph, fillAttrs, ofa, "Other");
                if (fe != null) {
                    StatGraph.parseFillAttrs(graph, fe, ofa);
                }
            }
        }
        pieObj.setOtherFillAttrs(ofa);
        if (groupLabelOptsElement != null) {
            str = groupLabelOptsElement.getAttribute("location");
            if (str.equalsIgnoreCase("LEFT")) {
                pieObj.setGroupLabelPlacement(RendererUtil.DataLabel.WEST);
            } else if (str.equalsIgnoreCase("RIGHT")) {
                pieObj.setGroupLabelPlacement(RendererUtil.DataLabel.EAST);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("LOCATION", str);
            }
            glta = new TextAttrs();
            GraphStyle.setDefaultTextStyle(graph, groupLabelOptsElement.getAttribute("labelAttrs"), glta, "LabelText");
            Element labelAttrs = StatGraph.getOptionAttrsElement(groupLabelOptsElement, "LabelAttrs");
            if (labelAttrs != null) {
                StatGraph.parseTextAttrs(graph, labelAttrs, glta);
            }
            pieObj.setGroupLabelTextAttrs(glta);
            TextAttrs gvta = new TextAttrs();
            GraphStyle.setDefaultTextStyle(graph, groupLabelOptsElement.getAttribute("valueAttrs"), gvta, "ValueText");
            Element valueAttrs = StatGraph.getOptionAttrsElement(groupLabelOptsElement, "ValueAttrs");
            if (valueAttrs != null) {
                StatGraph.parseTextAttrs(graph, valueAttrs, gvta);
            }
            pieObj.setGroupValueTextAttrs(gvta);
        } else {
            glta = new TextAttrs();
            GraphStyle.setDefaultTextStyle(graph, null, glta, "LabelText");
            pieObj.setGroupLabelTextAttrs(glta);
            TextAttrs gvta = new TextAttrs();
            GraphStyle.setDefaultTextStyle(graph, null, gvta, "ValueText");
            pieObj.setGroupValueTextAttrs(gvta);
        }
        str = graph.style.getStyleAttribute("Skins", "dataSkin");
        if (str != null && str.length() > 0) {
            if (str.equalsIgnoreCase("crisp")) {
                pieObj.setSkin(RendererUtil.Skin.CRISP);
            } else if (str.equalsIgnoreCase("gloss")) {
                pieObj.setSkin(RendererUtil.Skin.GLOSS);
            } else if (str.equalsIgnoreCase("matte")) {
                pieObj.setSkin(RendererUtil.Skin.MATTE);
            } else if (str.equalsIgnoreCase("pressed")) {
                pieObj.setSkin(RendererUtil.Skin.PRESSED);
            } else if (str.equalsIgnoreCase("sheen")) {
                pieObj.setSkin(RendererUtil.Skin.SHEEN);
            } else if (str.equalsIgnoreCase("none")) {
                pieObj.setSkin(RendererUtil.Skin.NONE);
            }
        }
        if ((str = elem.getAttribute("dataSkin")).length() > 0) {
            if (str.equalsIgnoreCase("crisp")) {
                pieObj.setSkin(RendererUtil.Skin.CRISP);
            } else if (str.equalsIgnoreCase("gloss")) {
                pieObj.setSkin(RendererUtil.Skin.GLOSS);
            } else if (str.equalsIgnoreCase("matte")) {
                pieObj.setSkin(RendererUtil.Skin.MATTE);
            } else if (str.equalsIgnoreCase("pressed")) {
                pieObj.setSkin(RendererUtil.Skin.PRESSED);
            } else if (str.equalsIgnoreCase("sheen")) {
                pieObj.setSkin(RendererUtil.Skin.SHEEN);
            } else if (str.equalsIgnoreCase("none")) {
                pieObj.setSkin(RendererUtil.Skin.NONE);
            } else {
                StatGraph.printOptionError("DATASKIN", str);
            }
        }
        if (StatGraph.isNumber(str = elem.getAttribute("groupGap"))) {
            double gap = Double.parseDouble(str);
            if (gap >= 0.0) {
                pieObj.setRingGap(gap);
            } else {
                StatGraph.printOptionError("GROUPGAP", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("GROUPGAP", str);
        }
        str = elem.getAttribute("categoryDirection");
        if (str.equalsIgnoreCase("CLOCKWISE")) {
            pieObj.setClockwiseDirection(true);
        } else if (str.equalsIgnoreCase("COUNTERCLOCKWISE")) {
            pieObj.setClockwiseDirection(false);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("CATEGORYDIRECTION", str);
        }
        str = elem.getAttribute("start");
        if (StatGraph.isNumber(str)) {
            pieObj.setStartAngle(Double.parseDouble(str));
        } else if (str.length() > 0) {
            StatGraph.printOptionError("START", str);
        }
        str = elem.getAttribute("centerFirstSlice");
        if ("true".equalsIgnoreCase(str)) {
            pieObj.setCenterFirstSlice(true);
        }
        if ((str = elem.getAttribute("display")).equalsIgnoreCase("STANDARD")) {
            pieObj.setFillOn(true);
            pieObj.setOutlineOn(true);
        } else if (str.length() > 0) {
            String[] display = StatGraph.parseList2String(str);
            boolean fill = false;
            boolean outline = false;
            for (int i = 0; i < display.length; ++i) {
                if (display[i].equalsIgnoreCase("FILL")) {
                    fill = true;
                    continue;
                }
                if (display[i].equalsIgnoreCase("OUTLINE")) {
                    outline = true;
                    continue;
                }
                StatGraph.printOptionError("DISPLAY", display[i]);
                fill = true;
                outline = true;
                break;
            }
            pieObj.setFillOn(fill);
            pieObj.setOutlineOn(outline);
        }
        str = elem.getAttribute("dataLabelContent");
        if (str.equalsIgnoreCase("ALL")) {
            pieObj.setDataLabelContent(RendererUtil.DataLabel.CATEGORY_RESPONSE_PERCENT);
        } else if (str.equalsIgnoreCase("STANDARD")) {
            pieObj.setDataLabelContent(RendererUtil.DataLabel.CATEGORY_RESPONSE);
        } else if (str.equalsIgnoreCase("NONE")) {
            pieObj.setDataLabelContent(RendererUtil.DataLabel.NONE);
        } else if (str.length() > 0) {
            String[] contents = StatGraph.parseList2String(str);
            boolean category = false;
            boolean percent = false;
            boolean response = false;
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].equalsIgnoreCase("CATEGORY")) {
                    category = true;
                    continue;
                }
                if (contents[i].equalsIgnoreCase("PERCENT")) {
                    percent = true;
                    continue;
                }
                if (contents[i].equalsIgnoreCase("RESPONSE")) {
                    response = true;
                    continue;
                }
                StatGraph.printOptionError("DATALABELCONTENT", contents[i]);
                category = true;
                percent = true;
                response = true;
                break;
            }
            RendererUtil.DataLabel c = RendererUtil.DataLabel.NONE;
            c = category ? (percent ? (response ? RendererUtil.DataLabel.CATEGORY_RESPONSE_PERCENT : RendererUtil.DataLabel.CATEGORY_PERCENT) : (response ? RendererUtil.DataLabel.CATEGORY_RESPONSE : RendererUtil.DataLabel.CATEGORY)) : (percent ? (response ? RendererUtil.DataLabel.RESPONSE_PERCENT : RendererUtil.DataLabel.PERCENT) : (response ? RendererUtil.DataLabel.RESPONSE : RendererUtil.DataLabel.NONE));
            pieObj.setDataLabelContent(c);
        } else if (!hasResponse && pie.getStatistic() == 3) {
            pieObj.setDataLabelContent(RendererUtil.DataLabel.CATEGORY_PERCENT);
        } else {
            pieObj.setDataLabelContent(RendererUtil.DataLabel.CATEGORY_RESPONSE);
        }
        String labelFitPolicy = elem.getAttribute("labelFitPolicy");
        pieObj.setDataLabelPlacement(Pie.LabelPlacement.AUTO);
        str = elem.getAttribute("dataLabelLocation");
        if (str.equalsIgnoreCase("AUTO")) {
            pieObj.setDataLabelPlacement(Pie.LabelPlacement.AUTO);
        } else if (str.equalsIgnoreCase("INSIDE")) {
            if (labelFitPolicy != null && labelFitPolicy.equalsIgnoreCase("DROP")) {
                pieObj.setDataLabelPlacement(Pie.LabelPlacement.INSIDE_IF_FIT);
            } else {
                pieObj.setDataLabelPlacement(Pie.LabelPlacement.INSIDE);
            }
        } else if (str.equalsIgnoreCase("OUTSIDE")) {
            pieObj.setDataLabelPlacement(Pie.LabelPlacement.OUTSIDE);
        } else if (str.equalsIgnoreCase("CALLOUT")) {
            pieObj.setDataLabelPlacement(Pie.LabelPlacement.ARROW);
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DATALABELLOCATION", str);
        }
        TextAttrs ta = new TextAttrs();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), ta, "ValueText");
        Element dtAttrs = StatGraph.getOptionAttrsElement(elem, "DataLabelAttrs");
        if (dtAttrs != null) {
            StatGraph.parseTextAttrs(graph, dtAttrs, ta);
        }
        pieObj.setSliceLabelTextAttrs(ta);
        String fillAttrs = elem.getAttribute("fillAttrs");
        Element fe = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        FillAttrs fs = new FillAttrs();
        GraphStyle.setDefaultDataFillStyle(graph, fillAttrs, fs, "GraphDataStyleDefault");
        if (fillAttrs.length() == 0) {
            fs.setColor(null);
        }
        if (fe != null) {
            StatGraph.parseFillAttrs(graph, fe, fs);
        }
        FillAttrs fa = new FillAttrs();
        fa.setColor(fs.getColor());
        fa.setTransparency(fs.getTransparency());
        pieObj.setFillAttrs(fa);
        pie.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        LineAttrs ls = new LineAttrs();
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), ls, "Outlines");
        Element ole = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
        if (ole != null) {
            StatGraph.parseLineAttrs(graph, ole, ls);
        }
        LineAttrs la = new LineAttrs();
        la.setColor(ls.getColor());
        la.setLinePattern(ls.getLinePattern());
        la.setWidth(ls.getWidth());
        pieObj.setOutLineAttrs(la);
        str = elem.getAttribute("categoryAttrVar");
        if (str.length() > 0) {
            DiscreteAttributeMap attrMap;
            DiscreteAttrMapper attrMapper = graph.getDiscreteAttrVar(str);
            if (attrMapper != null && (attrMap = attrMapper.getAttrMap()) != null) {
                pieObj.setCategoryAttributeMap(attrMap);
            }
        } else {
            String originalCategory;
            String string = originalCategory = elem.hasAttribute("_originalCategory") ? elem.getAttribute("_originalCategory") : categoryVarID;
            if (DAMDatasetParser.hasInternalDAttrVar(graph, originalCategory)) {
                pieObj.setCategoryAttributeMap(DAMDatasetParser.getInternalDAttrMapper(graph, originalCategory).getAttrMap());
            }
        }
        pieObj.setStyle(graph.style.getGraphStyle());
        DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
        if (missingElem == null) {
            missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault");
        }
        pieObj.setMissingStyleElement(missingElem);
        return true;
    }
}

