/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PieOverlay;
import com.sas.graphics.util.gtk.TextStyle;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PieParser {
    public static PieOverlay load(StatGraph graph, Element elem) {
        PieOverlay pie = (PieOverlay)graph.getObjectFromElement(elem);
        if (pie == null) {
            pie = new PieOverlay();
        }
        return PieParser.load(graph, pie, elem) ? pie : null;
    }

    public static boolean load(StatGraph graph, PieOverlay pie, Element elem) {
        Color otherColor;
        graph.addSupportedGraph();
        String str = elem.getAttribute("category");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("response");
        String yVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        map.map(1, xcol);
        map.map(6, xcol);
        map.map(46, xcol);
        pie.addRole("CATEGORY", m.getColumnLabel(xcol));
        if (yVarID.length() > 0) {
            int ycol = m.getColumn(yVarID);
            if (!StatGraph.checkVariable("RESPONSE", m.getColumnLabel(ycol), Double.class, 0, false, true)) {
                return false;
            }
            map.map(2, ycol);
            pie.addRole("RESPONSE", m.getColumnLabel(ycol));
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, pie);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, pie);
        pie.setModel(crd);
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("all") && !str.equalsIgnoreCase("standard")) {
            pie.setEdgeOn(false);
            pie.setFillOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    pie.setEdgeOn(true);
                    continue;
                }
                if (!opts[i].equalsIgnoreCase("fill")) continue;
                pie.setFillOn(true);
            }
        } else {
            pie.setEdgeOn(true);
            pie.setFillOn(true);
        }
        int startContrastColorIndex = graph.style.contrastColorCnt;
        LayoutOverlayParser.setDiscreteEncoder(graph, pie, (byte)4);
        graph.style.contrastColorCnt = startContrastColorIndex;
        LayoutOverlayParser.setDiscreteEncoder(graph, pie, (byte)17);
        if (pie.isEdgeOn()) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), pie.getEdgeStyle(), "Outlines");
        }
        str = elem.getAttribute("dataLabelContent");
        pie.setLabelContent(str);
        TextStyle ts = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), ts, "DataText");
        pie.setLabelStyle(ts);
        double angle = 0.0;
        str = elem.getAttribute("start");
        if (StatGraph.isNumber(str)) {
            angle = Double.parseDouble(str) * Math.PI / 180.0;
        }
        pie.setStart(angle);
        str = elem.getAttribute("order");
        pie.setOrder(str);
        str = elem.getAttribute("direction");
        pie.setDirection(str);
        str = elem.getAttribute("otherThreshold");
        if (StatGraph.isNumber(str)) {
            pie.setOtherThreshold(Double.parseDouble(str));
        }
        if ((otherColor = StatGraph.parseAttrColor("otherColor", graph, elem)) != null) {
            pie.setOtherColor(otherColor);
        }
        if ((str = elem.getAttribute("otherLabel")).length() > 0) {
            pie.setOtherLabel(str);
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                StatGraph.parseTextAttrs(graph, (Element)node, pie.getLabelStyle());
                continue;
            }
            if (elemTag.equals("OutlineAttrs") && pie.isEdgeOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, pie.getEdgeStyle());
                if (!((Element)node).hasAttribute("color")) continue;
                pie.setUseEdgeColor(true);
                continue;
            }
            if (!elemTag.equals("FillAttrs") || !pie.isFillOn() || !((Element)node).hasAttribute("color")) continue;
            FillAttrs fs = new FillAttrs();
            StatGraph.parseFillAttrs(graph, (Element)node, fs);
            pie.setFillColor(fs.getColor());
        }
        LayoutOverlayParser.parseGraphOpts(graph, elem, pie);
        return true;
    }
}

