/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NeedleParser {
    public static final String RB_KEY = "NeedleParser.";

    public static ScatterOverlay load(StatGraph graph, Element elem) {
        ScatterOverlay plot = (ScatterOverlay)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new ScatterOverlay(2);
        }
        return NeedleParser.load(graph, plot, elem) ? plot : null;
    }

    public static boolean load(StatGraph graph, ScatterOverlay plot, Element elem) {
        Element ba;
        String indexVarID;
        int ii;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = ScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        String str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        if (plot.getXAxis().equalsIgnoreCase("x2")) {
            plot.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            plot.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        str = elem.getAttribute("group");
        String groupVarID = StatGraph.getVarID(str);
        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID, plot.getStmt())) {
            groupVarID = "";
        }
        Element labelElem = null;
        Element lineElem = null;
        Element markerElem = null;
        Element markerFillElem = null;
        Element markerOutlineElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("LineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerFillAttrs")) {
                markerFillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("MarkerOutlineAttrs")) continue;
            markerOutlineElem = (Element)node;
        }
        String lineAttr = elem.getAttribute("lineAttrs");
        String mrkAttr = elem.getAttribute("markerAttrs");
        String mrkFillAttr = elem.getAttribute("markerFillAttrs");
        String mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
        if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("size")) {
            plot.setUseMarkerSize(true);
        }
        if (markerElem != null && markerElem.hasAttribute("weight")) {
            plot.setUseMarkerWeight(true);
        }
        if (!map.isRoleMapped(119) && (lineAttr.length() > 0 || lineElem != null && lineElem.hasAttribute("thickness"))) {
            plot.setUseLineThickness(true);
        } else {
            plot.setUseLineThickness(false);
        }
        plot.setUseMarkerTransparency(StatGraph.isTransparencyFixed(elem, markerElem));
        boolean hasMarkers = StatGraph.parseDisplayMarkers(elem);
        boolean filledOutlinedMarker = false;
        str = elem.getAttribute("filledOutlinedMarkers");
        if (str.equalsIgnoreCase("true")) {
            plot.setFilledOutlinedMarker(true);
            filledOutlinedMarker = true;
            if (mrkAttr.length() > 0 || markerElem != null && markerElem.hasAttribute("color")) {
                plot.setUseMarkerAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("color")) {
                plot.setUseMarkerOutlineAttrsColor(true);
            }
            if (mrkOutlineAttr.length() > 0 || markerOutlineElem != null && markerOutlineElem.hasAttribute("thickness")) {
                plot.setUseMarkerOutlineAttrsThickness(true);
            }
        }
        if (groupVarID.length() > 0) {
            int gcol = m.getColumn(groupVarID);
            boolean groupMapped = false;
            if (!(lineElem != null && lineElem.hasAttribute("color") || lineAttr.length() != 0)) {
                map.map(46, gcol);
                groupMapped = true;
            }
            if (!(lineElem != null && lineElem.hasAttribute("pattern") || lineAttr.length() != 0)) {
                map.map(36, gcol);
                groupMapped = true;
            }
            if (hasMarkers) {
                groupMapped = StatGraph.mapMarkerRoles(graph, elem, map, markerElem, mrkAttr, gcol, groupMapped, m, plot);
                if (filledOutlinedMarker) {
                    if (!map.isRoleMapped(45) && map.isRoleMapped(46)) {
                        map.map(45, gcol);
                    }
                    if (!(map.isRoleMapped(69) || mrkFillAttr.length() != 0 || markerFillElem != null && markerFillElem.hasAttribute("color"))) {
                        map.map(69, gcol);
                    }
                }
            }
            map.map(3, gcol);
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            if (groupMapped) {
                str = elem.getAttribute("groupAttrVar");
                if (str.length() > 0) {
                    plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, plot, "GROUP", groupVarID);
                }
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            if (map.isRoleMapped(46) || map.isRoleMapped(45)) {
                map.map(41, ii);
            }
            if (map.isRoleMapped(36)) {
                map.map(43, ii);
            }
            if (map.isRoleMapped(8)) {
                map.map(42, ii);
            }
            plot.addRole("INDEX", m.getColumnLabel(ii));
        }
        if (groupVarID.length() > 0) {
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else if (str.equalsIgnoreCase("ReverseData")) {
                    plot.setGroupOrder(3);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError("GROUPORDER", str);
                }
            } else if (graph.isCASData()) {
                plot.setGroupOrder(1);
            }
            if (graph.isCASData()) {
                plot.setDrawByGroupOrder(true);
            }
            if (StatGraph.isNumber(str = elem.getAttribute("clusterWidth"))) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
        }
        StatGraph.parseURLOpt(elem, m, map, plot);
        str = elem.getAttribute("dataLabel");
        String labelVarID = StatGraph.getVarID(str);
        boolean labelVisible = false;
        boolean labelingEnabled = false;
        if (labelVarID.length() > 0) {
            int lcol = m.getColumn(labelVarID);
            map.map(5, lcol);
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(lcol);
            int nms = cmd.getNobs() - cmd.getMissings();
            if (nms == 0) {
                labelVisible = false;
                labelingEnabled = false;
            } else {
                Message msg;
                labelVisible = true;
                boolean bl = labelingEnabled = nms <= graph.labelingThreshold;
                if (!labelingEnabled) {
                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(nms))), false);
                } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                    labelingEnabled = false;
                    msg = new Message(RB.getStringResource("StatGraph.", "labeling.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(cmd.getNobs()))), false);
                }
            }
            plot.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, plot);
        str = elem.getAttribute("dataSelectable");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        if ((str = elem.getAttribute("displayBaseline")).length() > 0) {
            if (str.equalsIgnoreCase("on")) {
                plot.setBaselineOn(true);
            } else if (str.equalsIgnoreCase("off")) {
                plot.setBaselineOn(false);
            } else if (str.equalsIgnoreCase("auto")) {
                plot.setAutoBaseline(true);
            } else {
                plot.setBaselineOn(true);
                StatGraph.printOptionError("DISPLAYBASELINE", str);
            }
        }
        if ((str = elem.getAttribute("baselineIntercept")).length() > 0) {
            if (str.equalsIgnoreCase("RELATIVE")) {
                plot.setRelativeNeedle(true);
            } else if (StatGraph.isNumber(str)) {
                plot.setNeedleBase(Double.parseDouble(str));
            } else {
                StatGraph.printOptionError("BASELINEINTERCEPT", str);
            }
        }
        if ((ba = StatGraph.getOptionAttrsElement(elem, "BaselineAttrs")) != null || elem.hasAttribute("baselineAttrs")) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("baselineAttrs"), plot.getBaselineStyle(), "AxisLines");
            if (ba != null) {
                StatGraph.parseLineAttrs(graph, ba, plot.getBaselineStyle());
            }
        } else {
            plot.setBaselineStyle(null);
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !NeedleParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
        } else if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        StatGraph.parseDataSkinOpt(graph, elem, plot);
        if (plot.isTooltipEnabled()) {
            plot.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        plot.setModel(crd);
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        if (hasMarkers) {
            MarkerAttrs ms = new MarkerAttrs();
            GraphStyle.setDefaultMarkerStyle(graph, mrkAttr, ms, contextName);
            if (markerElem != null) {
                StatGraph.parseMarkerAttrs(graph, markerElem, ms);
            }
            plot.setDefaultMarkerColor(ms.getColor());
            plot.setMarkerTransparency(ms.getTransparency());
            plot.setDefaultMarkerShape((short)ms.getShape());
            plot.setMinMarkerSize(ms.getSize());
            plot.setMaxMarkerSize(ms.getSize());
            plot.setDefaultMarkerScale(0.0);
            if (filledOutlinedMarker) {
                mrkFillAttr = elem.getAttribute("markerFillAttrs");
                GraphStyle.setDefaultFillStyle(graph, mrkFillAttr, plot.getMarkerFillStyle(), contextName);
                if (markerFillElem != null) {
                    StatGraph.parseFillAttrs(graph, markerFillElem, plot.getMarkerFillStyle());
                }
                mrkOutlineAttr = elem.getAttribute("markerOutlineAttrs");
                GraphStyle.setDefaultLineStyle(graph, mrkOutlineAttr, plot.getMarkerOutlineStyle(), "Outlines");
                if (markerOutlineElem != null) {
                    StatGraph.parseLineAttrs(graph, markerOutlineElem, plot.getMarkerOutlineStyle());
                }
            }
        } else {
            plot.setDefaultMarkerShape((short)-1);
        }
        GraphStyle.setDefaultDataLineStyle(graph, lineAttr, plot.getLineStyle(), contextName);
        if (lineElem != null) {
            StatGraph.parseLineAttrs(graph, lineElem, plot.getLineStyle());
            if (groupVarID.length() > 0 && lineElem.hasAttribute("color") && (markerElem == null || !markerElem.hasAttribute("color"))) {
                plot.setDefaultMarkerColor(plot.getLineStyle().getColor());
            }
        }
        plot.setNeedleVisible(true);
        if (labelVisible) {
            int position = ScatterParser.parseDataLabelPosition(elem);
            if (position != -1) {
                labelingEnabled = false;
                plot.setFixedDataLabelPosition(position);
                ScatterParser.parseDataLabelSplitting(plot, elem);
            }
            plot.setLabelVisible(true);
            plot.setLabelCollisionAvoidance(labelingEnabled);
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), plot.getLabelStyle(), "DataText");
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(plot.getLineStyle().getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs(graph, labelElem, plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if (graph.isSALabeling()) {
            plot.setProtectedNeedle(SALabeling.getWeight(graph.getSAWeightMap(), "OBSTACLE") > 0.0);
        } else {
            plot.setProtectedNeedle(false);
        }
        ScatterParser.parseSelectionColor(plot, graph);
        ScatterParser.parseLabelVisibles(plot, elem);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            startContrastColorIndex = graph.style.contrastColorCnt;
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)17);
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)15);
        }
        if (crd.isAvailable(45)) {
            graph.style.setContextCount(contextCount);
            if (startContrastColorIndex >= 0) {
                graph.style.contrastColorCnt = startContrastColorIndex;
            }
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)16, plot.getMarkerTransparency());
        }
        if (crd.isAvailable(69)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)24, plot.getMarkerTransparency());
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)6);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    static boolean isDiscreteOffsetSupported(ScatterOverlay plot) {
        return plot.isDiscreteX();
    }
}

