/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class MyEditorKit
extends StyledEditorKit {
    MyEditorKit() {
    }

    @Override
    public ViewFactory getViewFactory() {
        return new StyledViewFactory();
    }

    static class CenteredBoxView
    extends BoxView {
        public CenteredBoxView(Element elem, int axis) {
            super(elem, axis);
        }

        @Override
        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int i;
            super.layoutMajorAxis(targetSpan, axis, offsets, spans);
            int textBlockHeight = 0;
            int offset = 0;
            for (i = 0; i < spans.length; ++i) {
                textBlockHeight = spans[i];
            }
            offset = (targetSpan - textBlockHeight) / 2;
            if (offset < 0) {
                return;
            }
            i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + offset;
            }
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new LabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new CenteredBoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

