/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.AbstractMapProvider;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.ESRIGeometryService;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.EmbeddedGeometryProvider;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.MapGeometryProvider;
import com.sas.graphics.applets.statgraph.sgchart.mapProvider.OLAPMapGeometryProvider;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ESRIMapRegionLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.gtk.render.map.MapObject;
import com.sas.text.Message;
import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import org.w3c.dom.Element;

public final class MapRegionLayerParser {
    public static final String RB_KEY = "MapRegionLayer.";

    public static Overlay load(StatGraph graph, Element elem) {
        graph.addSupportedGraph();
        AbstractMapProvider mapProvider = null;
        String mapProviderName = null;
        mapProviderName = elem.getAttribute("mapProvider");
        mapProvider = graph.getMapProvider(mapProviderName);
        if (mapProvider instanceof ESRIGeometryService || mapProvider instanceof OLAPMapGeometryProvider) {
            ESRIMapRegionLayerOverlay map = null;
            map = new ESRIMapRegionLayerOverlay();
            map.setMapProvider((MapGeometryProvider)mapProvider);
            map.setProxy(graph.getProxy());
            return MapRegionLayerParser.loadESRI(graph, map, elem) ? map : null;
        }
        if (mapProvider instanceof EmbeddedGeometryProvider) {
            MapOverlay mapOverlay = new MapOverlay();
            return MapRegionLayerParser.load(graph, mapOverlay, elem, (EmbeddedGeometryProvider)mapProvider) ? mapOverlay : null;
        }
        StatGraph.printError(RB.getStringResource(RB_KEY, "NoMapData.txt"));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean load(StatGraph graph, MapOverlay mapOverlay, Element elem, EmbeddedGeometryProvider mapProvider) {
        String str;
        String idVarID;
        String mapIdStr = elem.getAttribute("mapID");
        String idStr = elem.getAttribute("ID");
        String colorResponseStr = elem.getAttribute("colorResponse");
        String colorGroupStr = elem.getAttribute("colorGroup");
        boolean emptyEdgeOn = idStr == null || idStr == "";
        String responseVarID = StatGraph.getVarID(colorResponseStr);
        String cgVarID = StatGraph.getVarID(colorGroupStr);
        boolean colorSet = colorResponseStr != "" || colorGroupStr != "";
        boolean includeMissing = false;
        DataModel mapData = mapProvider.getDataModel();
        String dataName = null;
        if (idStr == null || idStr == "") {
            idVarID = "ID";
            if (colorResponseStr != "") {
                dataName = StatGraph.getDataName(colorResponseStr);
            } else if (colorGroupStr != "") {
                dataName = StatGraph.getDataName(colorGroupStr);
            }
        } else {
            idVarID = StatGraph.getVarID(idStr);
            dataName = StatGraph.getDataName(idStr);
        }
        if (mapIdStr == null || mapIdStr == "") {
            StatGraph.printNote(RB.getStringResource(RB_KEY, "NoID.txt"));
            mapIdStr = "ID";
        }
        if (!mapData.hasColumn(mapIdStr)) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "IDNotFound.txt"));
            StatGraph.printError(msg.toString((Object)mapIdStr));
            return false;
        }
        if (!mapData.hasColumn("X") || !mapData.hasColumn("Y")) {
            StatGraph.printError(RB.getStringResource(RB_KEY, "XYNotFound.txt"));
            return false;
        }
        int xcol = mapData.getColumn("X");
        if (!StatGraph.checkVariable("X", mapData.getColumnLabel(xcol), Double.class, 1, true)) {
            return false;
        }
        int ycol = mapData.getColumn("Y");
        if (!StatGraph.checkVariable("Y", mapData.getColumnLabel(ycol), Double.class, 1, true)) {
            return false;
        }
        DataModel m = null;
        RoleColumnMap rcmap = null;
        if (dataName != null) {
            m = graph.getData(dataName);
        }
        if (m != null) {
            String str2;
            rcmap = new RoleColumnMap();
            int varcol = m.getColumn(idVarID);
            if (!StatGraph.checkVariable("ID", m.getColumnLabel(varcol), null, 1, true)) {
                return false;
            }
            rcmap.map(600, varcol);
            if (responseVarID.length() > 0) {
                int rcol = m.getColumn(responseVarID);
                if (!StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(rcol), Double.class, 1, true)) return false;
                rcmap.map(2, rcol);
                mapOverlay.addRole("COLORRESPONSE", m.getColumnLabel(rcol));
                str2 = elem.getAttribute("colorResponseAttrVar");
                if (str2.length() > 0) {
                    mapOverlay.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str2));
                }
            } else if (cgVarID.length() > 0) {
                int cgcol = m.getColumn(cgVarID);
                rcmap.map(107, cgcol);
                mapOverlay.addRole("COLORGROUP", m.getColumnLabel(cgcol));
                str2 = elem.getAttribute("colorGroupAttrVar");
                if (str2.length() > 0) {
                    mapOverlay.addAttrVar("COLORGROUP", (AttrMapper)graph.getDiscreteAttrVar(str2));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, mapOverlay, "COLORGROUP", cgVarID);
                }
            }
        }
        if ((str = elem.getAttribute("stat")).length() > 0) {
            if (str.equalsIgnoreCase("SUM")) {
                mapOverlay.setStatistic(6);
            } else if (str.equalsIgnoreCase("MEAN")) {
                mapOverlay.setStatistic(1);
            } else if (str.equalsIgnoreCase("FREQ")) {
                mapOverlay.setStatistic(2);
            } else if (str.equalsIgnoreCase("FIRST")) {
                mapOverlay.setStatistic(12);
            } else if (str.equalsIgnoreCase("LAST")) {
                mapOverlay.setStatistic(0);
            } else if (str.equalsIgnoreCase("MIN")) {
                mapOverlay.setStatistic(10);
            } else if (str.equalsIgnoreCase("MAX")) {
                mapOverlay.setStatistic(11);
            } else if (str.equalsIgnoreCase("PCT")) {
                mapOverlay.setStatistic(3);
            } else if (str.equalsIgnoreCase("PCTSUM")) {
                mapOverlay.setStatistic(7);
            } else {
                mapOverlay.setStatistic(12);
                StatGraph.printOptionError("STAT", str);
            }
        }
        mapOverlay.setMapIDVars(new String[]{mapIdStr});
        mapOverlay.setMapXVar("X");
        mapOverlay.setMapYVar("Y");
        if (mapData.hasColumn("SEGMENT")) {
            mapOverlay.setMapSegmentVar("SEGMENT");
        }
        if (elem != null) {
            LayoutOverlayParser.parseGraphOpts(graph, elem, mapOverlay);
        }
        mapOverlay.setMapDataModel(mapData);
        if (m != null) {
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(rcmap);
            mapOverlay.setModel(crd);
            ColorEncoder encoder = MapRegionLayerParser.parseColorModelOpt(graph, elem, mapOverlay);
            if (encoder != null) {
                mapOverlay.setEncoder((byte)4, encoder);
            }
        }
        MapObject mapObject = mapOverlay.getMapObject();
        MapRegionLayerParser.parseDisplayOptions(mapObject, graph, mapOverlay, elem, colorSet);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean loadESRI(StatGraph graph, ESRIMapRegionLayerOverlay mapOverlay, Element elem) {
        String idVarID;
        String mapIdStr = elem.getAttribute("mapID");
        String idStr = elem.getAttribute("ID");
        String colorResponseStr = elem.getAttribute("colorResponse");
        String colorGroupStr = elem.getAttribute("colorGroup");
        boolean colorSet = colorResponseStr != "" || colorGroupStr != "";
        String responseVarID = StatGraph.getVarID(colorResponseStr);
        String cgVarID = StatGraph.getVarID(colorGroupStr);
        String dataName = null;
        if (idStr == null || idStr == "") {
            idVarID = "ID";
            if (colorResponseStr != "") {
                dataName = StatGraph.getDataName(colorResponseStr);
            } else if (colorGroupStr != "") {
                dataName = StatGraph.getDataName(colorGroupStr);
            }
        } else {
            idVarID = StatGraph.getVarID(idStr);
            dataName = StatGraph.getDataName(idStr);
        }
        if (mapIdStr == null || mapIdStr == "") {
            mapIdStr = "ID";
        }
        RoleColumnMap rcmap = null;
        boolean olap = false;
        DataModel m = graph.getOLAPModel(dataName);
        if (m == null) {
            m = graph.getData(dataName);
        } else {
            olap = true;
        }
        if (m != null) {
            String str;
            rcmap = new RoleColumnMap();
            if (olap) {
                rcmap.map(600, idVarID);
            } else {
                int varcol = m.getColumn(idVarID);
                if (!StatGraph.checkVariable("ID", m.getColumnLabel(varcol), null, 1, true)) {
                    return false;
                }
                rcmap.map(600, varcol);
            }
            if (responseVarID.length() > 0) {
                if (olap) {
                    rcmap.map(2, responseVarID);
                } else {
                    int rcol = m.getColumn(responseVarID);
                    if (!StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(rcol), Double.class, 1, true)) return false;
                    rcmap.map(2, rcol);
                    mapOverlay.addRole("COLORRESPONSE", m.getColumnLabel(rcol));
                    str = elem.getAttribute("colorResponseAttrVar");
                    if (str.length() > 0) {
                        mapOverlay.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
                    }
                }
            } else if (cgVarID.length() > 0) {
                if (olap) {
                    rcmap.map(107, cgVarID);
                    String str2 = elem.getAttribute("colorGroupAttrVar");
                    if (str2.length() > 0) {
                        mapOverlay.addAttrVar("COLORGROUP", (AttrMapper)graph.getCategorizationAttrVar(str2));
                    }
                } else {
                    int cgcol = m.getColumn(cgVarID);
                    rcmap.map(107, cgcol);
                    mapOverlay.addRole("COLORGROUP", m.getColumnLabel(cgcol));
                    str = elem.getAttribute("colorGroupAttrVar");
                    if (str.length() > 0) {
                        mapOverlay.addAttrVar("COLORGROUP", (AttrMapper)graph.getCategorizationAttrVar(str));
                    }
                }
            }
        }
        if (elem != null) {
            LayoutOverlayParser.parseGraphOpts(graph, elem, mapOverlay);
        }
        if (m != null) {
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(rcmap);
            mapOverlay.setModel(crd);
            ColorEncoder encoder = MapRegionLayerParser.parseColorModelOpt(graph, elem, mapOverlay);
            if (encoder != null) {
                mapOverlay.setEncoder((byte)4, encoder);
            }
        }
        MapObject mapObject = mapOverlay.getMapObject();
        MapRegionLayerParser.parseDisplayOptions(mapObject, graph, mapOverlay, elem, colorSet);
        return true;
    }

    protected static void parseDisplayOptions(MapObject mapObject, StatGraph graph, Overlay mapOverlay, Element elem, boolean colorSet) {
        FillAttrs fa;
        LineAttrs la;
        boolean fillOn = colorSet;
        boolean edgeOn = true;
        boolean emptyFillOn = false;
        boolean emptyEdgeOn = !colorSet;
        boolean includeMissing = false;
        String str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                emptyEdgeOn = true;
                emptyFillOn = true;
            } else {
                emptyEdgeOn = false;
                edgeOn = false;
                fillOn = false;
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        edgeOn = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        fillOn = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("emptyOutline")) {
                        emptyEdgeOn = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("emptyFill")) {
                        emptyFillOn = true;
                        continue;
                    }
                    fillOn = true;
                    edgeOn = true;
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        if (!edgeOn) {
            mapObject.setEdgesOn(false);
        } else {
            la = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), la, "Outlines");
            Element lineElem = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, la);
            }
            mapObject.setEdgeColor(mapOverlay.applyDataTransparency(la.getColor()));
            mapObject.setEdgePattern(la.getLinePattern());
            mapObject.setEdgeThickness(la.getWidth());
        }
        if (!emptyEdgeOn) {
            mapObject.setEmptyEdgesOn(false);
        } else {
            la = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("emptyOutlineAttrs"), la, "Outlines");
            Element lineElem = StatGraph.getOptionAttrsElement(elem, "EmptyOutlineAttrs");
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, la);
            }
            mapObject.setEmptyEdgeColor(mapOverlay.applyDataTransparency(la.getColor()));
            mapObject.setEmptyEdgePattern(la.getLinePattern());
            mapObject.setEmptyEdgeThickness(la.getWidth());
        }
        if (!emptyFillOn) {
            Color empty = new Color(0, 0, 0, 0);
            mapObject.setEmptyColor(empty);
        } else {
            fa = new FillAttrs();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("emptyFillAttrs"), fa, "GraphDataStyleDefault");
            Element fillElem = StatGraph.getOptionAttrsElement(elem, "EmptyFillAttrs");
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, fa);
            }
            mapObject.setEmptyColor(mapOverlay.applyDataTransparency((ColorAttr)fa));
        }
        if (!fillOn) {
            mapObject.setFillColor(mapObject.getEmptyColor());
        } else {
            fa = new FillAttrs();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("missingFillAttrs"), fa, "Missing");
            Element fillElem = StatGraph.getOptionAttrsElement(elem, "MissingFillAttrs");
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, fa);
            }
            mapObject.setFillColor(mapOverlay.applyDataTransparency((ColorAttr)fa));
        }
        if (elem.hasAttribute("includeMissingColor")) {
            str = elem.getAttribute("includeMissingColor");
            includeMissing = "true".equalsIgnoreCase(str);
        }
        mapObject.setMissingAsEmpty(!includeMissing || !colorSet);
    }

    public static ColorEncoder parseColorModelOpt(StatGraph graph, Element elem, Overlay overlay) {
        DataRange range = overlay.getDataRange((byte)4);
        ColorEncoder encoder = null;
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            String str = elem.getAttribute("colorModel");
            Color[] ramp = graph.style.getRampColors(str, "TwoColorRamp");
            str = elem.getAttribute("reverseColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            encoder = reverse ? new ColorEncoder(cr, overlay.applyDataTransparency(ramp[2]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[0])) : new ColorEncoder(cr, overlay.applyDataTransparency(ramp[0]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[2]));
        } else if (range instanceof DiscreteRange) {
            DiscreteRange dr = (DiscreteRange)range;
            HashMap table = new HashMap();
            Enumeration e = ((DiscreteRange)range).getEnumeration();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) continue;
                Color color = graph.style.getNextFillColor();
            }
            encoder = new ColorEncoder(dr, table);
            encoder.colorArray = graph.style.fillColorList;
            String str = elem.getAttribute("colorModel");
            Color[] ramp = graph.style.getRampColors(str, "TwoColorRamp");
            encoder.startColor = ramp[0];
            encoder.mediumColor = ramp[1];
            encoder.endColor = ramp[2];
        }
        return encoder;
    }
}

