/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapOverlay;
import com.sas.graphics.util.gtk.render.map.MapObject;
import org.w3c.dom.Element;

public final class MapParser {
    public static MapOverlay load(StatGraph graph, Element elem, DataModel mapData, String[] id) {
        MapOverlay map = (MapOverlay)graph.getObjectFromElement(elem);
        if (map == null) {
            map = new MapOverlay();
        }
        return MapParser.load(graph, map, elem, mapData, id) ? map : null;
    }

    public static boolean load(StatGraph graph, MapOverlay mapOverlay, Element elem, DataModel mapData, String[] id) {
        graph.addSupportedGraph();
        if (id == null || id.length == 0) {
            return false;
        }
        if (!mapData.hasColumn("X") || !mapData.hasColumn("Y")) {
            return false;
        }
        int idcol = mapData.getColumn(id[0]);
        int xcol = mapData.getColumn("X");
        if (!StatGraph.checkVariable("X", mapData.getColumnLabel(xcol), Double.class, 1, true)) {
            return false;
        }
        int ycol = mapData.getColumn("Y");
        if (!StatGraph.checkVariable("Y", mapData.getColumnLabel(ycol), Double.class, 1, true)) {
            return false;
        }
        mapOverlay.setMapIDVars(id);
        mapOverlay.setMapXVar("X");
        mapOverlay.setMapYVar("Y");
        if (mapData.hasColumn("SEGMENT")) {
            mapOverlay.setMapSegmentVar("SEGMENT");
        }
        if (elem != null) {
            LayoutOverlayParser.parseGraphOpts(graph, elem, mapOverlay);
        }
        mapOverlay.setMapDataModel(mapData);
        mapOverlay.setModel(new CRD());
        if (elem == null) {
            return true;
        }
        MapObject mapObject = mapOverlay.getMapObject();
        boolean fillOn = true;
        boolean edgeOn = true;
        String str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("all") && !str.equalsIgnoreCase("standard")) {
            fillOn = false;
            edgeOn = false;
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    edgeOn = true;
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    fillOn = true;
                    continue;
                }
                fillOn = true;
                edgeOn = true;
                StatGraph.printOptionError("DISPLAY", opts[i]);
                break;
            }
        }
        if (!edgeOn) {
            mapObject.setEmptyEdgesOn(false);
        } else {
            LineAttrs la = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), la, "Outlines");
            Element lineElem = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, la);
            }
            mapObject.setEmptyEdgeColor(mapOverlay.applyDataTransparency(la.getColor()));
            mapObject.setEmptyEdgePattern(la.getLinePattern());
            mapObject.setEmptyEdgeThickness(la.getWidth());
        }
        if (!fillOn) {
            mapObject.setEmptyColor(null);
        } else {
            FillAttrs fa = new FillAttrs();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fa, "GraphDataStyleDefault");
            Element fillElem = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, fa);
            }
            mapObject.setEmptyColor(mapOverlay.applyDataTransparency((ColorAttr)fa));
        }
        return true;
    }
}

