/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.EntryItemParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.entry.LegendTextItemList;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.legend.LegendItem;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LegendItemParser {
    public static final String RB_KEY = "LegendItemParser.";
    public static int MAX_ITEMS = 100;

    public static LegendItem load(StatGraph graph, Element elem) {
        MarkerAttrs ma;
        DefaultStyledDocument doc;
        String str = elem.getAttribute("type");
        if (str.length() == 0) {
            return null;
        }
        int type = -1;
        if (str.equalsIgnoreCase("MARKER")) {
            type = 1;
        } else if (str.equalsIgnoreCase("FILL")) {
            type = 3;
        } else if (str.equalsIgnoreCase("LINE")) {
            type = 2;
        } else if (str.equalsIgnoreCase("MARKERLINE")) {
            type = 4;
        } else if (str.equalsIgnoreCase("TEXT")) {
            type = 5;
        } else {
            return null;
        }
        boolean filledOutlinedMarker = false;
        if ((type == 1 || type == 4) && (str = elem.getAttribute("filledOutlinedMarker")).equalsIgnoreCase("true")) {
            filledOutlinedMarker = true;
        }
        if ((str = elem.getAttribute("name")).length() == 0) {
            return null;
        }
        LegendItem entry = new LegendItem(type);
        graph.addLegendItem(str, entry);
        if (type == 5) {
            if (elem.hasAttribute("text")) {
                str = elem.getAttribute("text");
                entry.setSymbolText(str);
            } else {
                doc = LegendItemParser.parseSymbolText(graph, elem, "Text");
                if (doc != null) {
                    entry.setSymbolDocument(doc);
                } else {
                    entry.setSymbolText("");
                }
            }
        }
        if (type == 3) {
            str = elem.getAttribute("fillType");
            if (str.equalsIgnoreCase("CIRCLE")) {
                entry.setFillType(2);
            }
            if (!(str = elem.getAttribute("fillDisplay")).equalsIgnoreCase("STANDARD") && str.length() != 0 && !str.equalsIgnoreCase("ALL")) {
                entry.setFillOutline(false);
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        entry.setFillOutline(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) continue;
                    entry.setFillOutline(true);
                    StatGraph.printOptionError("FILLDISPLAY", opts[i]);
                    break;
                }
            }
        }
        if (elem.hasAttribute("label")) {
            str = elem.getAttribute("label");
            entry.setLabel(str);
        } else {
            doc = LegendItemParser.parseSymbolText(graph, elem, "Label");
            if (doc != null) {
                entry.setLabelDocument(doc);
            } else if (graph.isQCGlobalLegend()) {
                entry.setLabel("");
            } else {
                entry.setLabel(null);
            }
        }
        if (type == 4) {
            GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("markerAttrs"), (MarkerAttrs)entry.getSymbolAttrs(), "GraphDataStyleDefault");
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("lineAttrs"), (LineAttrs)entry.getSecondarySymbolAttrs(), "GraphDataStyleDefault");
        } else if (type == 2) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("lineAttrs"), (LineAttrs)entry.getSymbolAttrs(), "GraphDataStyleDefault");
        } else if (type == 1) {
            GraphStyle.setDefaultMarkerStyle(graph, elem.getAttribute("markerAttrs"), (MarkerAttrs)entry.getSymbolAttrs(), "GraphDataStyleDefault");
        } else if (type == 3) {
            GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("fillAttrs"), (FillAttrs)entry.getSymbolAttrs(), "GraphDataStyleDefault");
            if (entry.isFillOutline()) {
                LineAttrs outlineAttrs = (LineAttrs)entry.getSecondarySymbolAttrs();
                if (outlineAttrs == null) {
                    outlineAttrs = new LineAttrs();
                    entry.setSecondarySymbolAttrs((ColorAttr)outlineAttrs);
                }
                GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), (LineAttrs)entry.getSecondarySymbolAttrs(), "Outlines");
            }
        } else if (type == 5) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("textAttrs"), (TextAttrs)entry.getSymbolAttrs(), "ValueText");
        }
        TextAttrs labelAttrs = new TextAttrs();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), labelAttrs, "ValueText");
        boolean hasLabelAttrsOverride = elem.hasAttribute("labelAttrs");
        FillAttrs fillAttrs = null;
        LineAttrs outlineAttrs = null;
        if (filledOutlinedMarker) {
            fillAttrs = new FillAttrs();
            outlineAttrs = new LineAttrs();
            GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("fillAttrs"), fillAttrs, "GraphDataStyleDefault");
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), outlineAttrs, "Outlines");
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("LabelAttrs")) {
                StatGraph.parseTextAttrs(graph, (Element)node, labelAttrs);
                if (!hasLabelAttrsOverride) {
                    String attributes = "";
                    if (((Element)node).hasAttribute("color")) {
                        attributes = attributes + "color,";
                    }
                    if (((Element)node).hasAttribute("family")) {
                        attributes = attributes + "family,";
                    }
                    if (((Element)node).hasAttribute("size")) {
                        attributes = attributes + "size,";
                    }
                    if (((Element)node).hasAttribute("style") || ((Element)node).hasAttribute("weight")) {
                        attributes = attributes + "style,";
                    }
                    entry.setUserLabelAttributes(attributes);
                    hasLabelAttrsOverride = true;
                }
            } else if (elemTag.equals("MarkerAttrs") && (type == 1 || type == 4)) {
                ma = (MarkerAttrs)entry.getSymbolAttrs();
                StatGraph.parseMarkerAttrs(graph, (Element)node, ma);
                if (ma.getTransparency() > 0.0) {
                    ma.setColor(Overlay.applyTransparency(ma.getColor(), ma.getTransparency()));
                }
            } else if (elemTag.equals("FillAttrs") && type == 3) {
                FillAttrs fa = (FillAttrs)entry.getSymbolAttrs();
                StatGraph.parseFillAttrs(graph, (Element)node, fa);
                if (fa.getTransparency() > 0.0) {
                    fa.setColor(Overlay.applyTransparency(fa.getColor(), fa.getTransparency()));
                }
            } else if (elemTag.equals("LineAttrs") && (type == 2 || type == 4)) {
                if (type == 2) {
                    StatGraph.parseLineAttrs(graph, (Element)node, (LineAttrs)entry.getSymbolAttrs());
                } else {
                    StatGraph.parseLineAttrs(graph, (Element)node, (LineAttrs)entry.getSecondarySymbolAttrs());
                }
            } else if (elemTag.equals("TextAttrs") && type == 5) {
                StatGraph.parseTextAttrs(graph, (Element)node, (TextAttrs)entry.getSymbolAttrs());
            } else if (elemTag.equals("OutlineAttrs") && type == 3) {
                StatGraph.parseLineAttrs(graph, (Element)node, (LineAttrs)entry.getSecondarySymbolAttrs());
            }
            if (!filledOutlinedMarker) continue;
            if (elemTag.equals("FillAttrs")) {
                StatGraph.parseFillAttrs(graph, (Element)node, fillAttrs);
                continue;
            }
            if (!elemTag.equals("OutlineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, outlineAttrs);
        }
        if (hasLabelAttrsOverride) {
            entry.setLabelAttrs(labelAttrs);
        }
        if (filledOutlinedMarker && Markers.isFilled((int)(ma = (MarkerAttrs)entry.getSymbolAttrs()).getShape())) {
            if (ma.getTransparency() > 0.0) {
                ma.setColor(Overlay.applyTransparency(fillAttrs.getColor(), ma.getTransparency()));
            } else {
                ma.setColor(fillAttrs.getColor());
            }
            entry.setMarkerOutlineAttrs(outlineAttrs);
        }
        return entry;
    }

    private static DefaultStyledDocument parseSymbolText(StatGraph graph, Element elem, String tagName) {
        Element tae;
        Node node;
        String elemTag = "";
        Element theElem = null;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals(tagName)) continue;
            theElem = (Element)node;
            break;
        }
        if (theElem == null) {
            return null;
        }
        DefaultStyledDocument doc = new DefaultStyledDocument();
        TextStyle textAttrs = new TextStyle();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("textAttrs"), textAttrs, "ValueText");
        Element element = tae = tagName.equals("Text") ? StatGraph.getOptionAttrsElement(elem, "TextAttrs") : StatGraph.getOptionAttrsElement(elem, "LabelAttrs");
        if (tae != null) {
            StatGraph.parseTextAttrs(graph, tae, textAttrs);
        }
        TextStyle defaultTextAttrs = new TextStyle(textAttrs);
        for (node = theElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("EntryItem") && !elemTag.equals("Sup") && !elemTag.equals("Sub")) continue;
            Element eiElem = (Element)node;
            Entry entryItem = new Entry();
            tae = StatGraph.getOptionAttrsElement(eiElem, "TextAttrs");
            textAttrs = tae != null ? EntryItemParser.load(graph, eiElem, (JComponent)entryItem, null, defaultTextAttrs, elemTag) : EntryItemParser.load(graph, eiElem, (JComponent)entryItem, null, textAttrs, elemTag);
            boolean superscript = elemTag.equals("Sup");
            boolean subscript = elemTag.equals("Sub");
            boolean underline = ((Element)node).getAttribute("underline").equalsIgnoreCase("true");
            boolean strikeThrough = ((Element)node).getAttribute("strikeThrough").equalsIgnoreCase("true");
            SimpleAttributeSet set = EntryConcatParser.createAttributeSet(textAttrs, null, superscript, subscript, underline, strikeThrough);
            try {
                doc.insertString(doc.getLength(), entryItem.getText(), set);
                continue;
            }
            catch (BadLocationException ex) {
                StatGraph.printDebug(ex.getMessage());
            }
        }
        return doc;
    }

    public static LegendTextItemList loadTextLegendItemList(StatGraph graph, Element elem) {
        ColumnMetadata cmd;
        int col;
        String varName;
        String str = elem.getAttribute("name");
        if (str.length() == 0) {
            return null;
        }
        String name = str;
        String dataName = null;
        String[] textValues = null;
        String[] labelValues = null;
        double[] sortDValues = null;
        DataModel m = null;
        int maxNonMissings = -1;
        str = elem.getAttribute("text");
        if (str.length() > 0) {
            dataName = StatGraph.getDataName(str);
            m = graph.getData(dataName);
            varName = StatGraph.getVarID(str);
            col = m.getColumn(varName);
            textValues = m.getColumnAsClassColumn(col, false);
            cmd = (ColumnMetadata)m.getColumnLabel(col);
            maxNonMissings = Math.max(maxNonMissings, m.getRowCount() - cmd.getMissings());
            if (m.getColumnClass(col) == Double.class) {
                sortDValues = m.getDoubleColumn(col);
            }
        }
        if ((str = elem.getAttribute("label")).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
                m = graph.getData(dataName);
            }
            varName = StatGraph.getVarID(str);
            col = m.getColumn(varName);
            labelValues = m.getColumnAsClassColumn(col, false);
            cmd = (ColumnMetadata)m.getColumnLabel(col);
            maxNonMissings = Math.max(maxNonMissings, m.getRowCount() - cmd.getMissings());
            if (sortDValues == null && m.getColumnClass(col) == Double.class) {
                sortDValues = m.getDoubleColumn(col);
            }
        }
        if (textValues == null && labelValues == null) {
            return null;
        }
        if (maxNonMissings > MAX_ITEMS) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "textitems.txt"));
            return null;
        }
        LegendTextItemList list = new LegendTextItemList();
        graph.addLegendTextItemList(name, list);
        if (graph.isCASData()) {
            String[] firstValues = textValues != null ? textValues : labelValues;
            String[] secondValues = textValues != null ? labelValues : null;
            for (int i = 0; i < firstValues.length; ++i) {
                for (int j = 0; j < firstValues.length - 1 - i; ++j) {
                    boolean swapping;
                    if (sortDValues != null && Double.isNaN(sortDValues[j]) || sortDValues == null && firstValues[j] == null) continue;
                    if (sortDValues != null) {
                        swapping = Double.isNaN(sortDValues[j + 1]) || sortDValues[j + 1] < sortDValues[j];
                    } else {
                        boolean bl = swapping = firstValues[j + 1] == null || firstValues[j].compareTo(firstValues[j + 1]) > 0;
                    }
                    if (!swapping) continue;
                    String swapString = firstValues[j];
                    firstValues[j] = firstValues[j + 1];
                    firstValues[j + 1] = swapString;
                    if (secondValues != null) {
                        swapString = secondValues[j];
                        secondValues[j] = secondValues[j + 1];
                        secondValues[j + 1] = swapString;
                    }
                    if (sortDValues == null) continue;
                    double swapDouble = sortDValues[j];
                    sortDValues[j] = sortDValues[j + 1];
                    sortDValues[j + 1] = swapDouble;
                }
            }
        }
        int rows = textValues != null ? textValues.length : labelValues.length;
        for (int i = 0; i < rows; ++i) {
            boolean labelMissing;
            boolean textMissing = textValues == null || textValues[i] == null;
            boolean bl = labelMissing = labelValues == null || labelValues[i] == null;
            if (textMissing && labelMissing) continue;
            list.addItem(textMissing ? "" : textValues[i], labelMissing ? "" : labelValues[i]);
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("textAttrs"), list.getTextAttrs(), "ValueText");
        Element textElem = StatGraph.getOptionAttrsElement(elem, "TextAttrs");
        if (textElem != null) {
            StatGraph.parseTextAttrs(graph, textElem, list.getTextAttrs());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), list.getLabelAttrs(), "ValueText");
        Element labelElem = StatGraph.getOptionAttrsElement(elem, "LabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, list.getLabelAttrs());
        }
        return list;
    }
}

