/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.DecisionTreeParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GridPanelParser;
import com.sas.graphics.applets.statgraph.KPIParser;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlay3DParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapTempParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.MosaicParser;
import com.sas.graphics.applets.statgraph.PathDiagramParser;
import com.sas.graphics.applets.statgraph.PieParser2;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.SizeLegendParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.TileParser;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.legend.SizeLegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.regions.DecisionTreeRegion;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Component;
import java.awt.Container;
import java.text.Format;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LayoutRegionParser {
    public static final String RB_KEY = "LayoutRegionParser.";

    public static void parseGraphOpts(StatGraph graph, Element elem, Region region) {
        String str = elem.getAttribute("name");
        if (str.length() > 0) {
            graph.addNamedRegion(str, region);
            region.setName(str);
        }
        if ((str = elem.getAttribute("legendLabel")).length() > 0) {
            region.setLegendLabel(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("dataTransparency"))) {
            region.setDataTransparency(Double.parseDouble(str));
        }
        if ((str = elem.getAttribute("_stmt")).length() > 0) {
            region.setStmt(str.toUpperCase());
        }
    }

    public static void parseRoleNames(Element elem, DataModel model, Region region) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Role")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String name = child.getNodeValue();
            String varID = StatGraph.getVarID(name);
            int col = model.getColumn(varID);
            if (!model.hasColumn(varID)) continue;
            region.addRole(role.toUpperCase(), model.getColumnLabel(col));
        }
    }

    public static void parseTipFormats(Element elem, Region region) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipFormat")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String format = child.getNodeValue();
            ColumnMetadata cmd = region.getRoleMetadata(role.toUpperCase());
            if (cmd == null) continue;
            cmd.setFormat(format);
        }
    }

    public static void parseTipLabels(Element elem, Region region) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipLabel")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String label = child.getNodeValue();
            ColumnMetadata cmd = region.getRoleMetadata(role.toUpperCase());
            if (cmd == null) continue;
            cmd.setLabel(label);
        }
    }

    public static void parseRoleTipStuff(Element elem, DataModel model, Region region) {
        LayoutRegionParser.parseRoleTipStuff(elem, model, region, false);
    }

    public static void parseRoleTipStuff(Element elem, DataModel model, Region region, boolean useFormattedValues) {
        String str;
        Element labelElem;
        Element formatElem;
        Element roleElem = StatGraph.getOptionAttrsElement(elem, "Roles");
        if (roleElem != null) {
            LayoutRegionParser.parseRoleNames(roleElem, model, region);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement(elem, "TipFormats")) != null) {
            LayoutRegionParser.parseTipFormats(formatElem, region);
        }
        if ((labelElem = StatGraph.getOptionAttrsElement(elem, "TipLabels")) != null) {
            LayoutRegionParser.parseTipLabels(labelElem, region);
        }
        if ((str = elem.getAttribute("tip")).length() > 0) {
            if (str.equalsIgnoreCase("NONE")) {
                region.setTooltipEnabled(false);
            }
            String[] tipRoles = StatGraph.parseList2String(str);
            LinkedHashMap<String, StringVectorVariable> tipVars = new LinkedHashMap<String, StringVectorVariable>();
            for (int i = 0; i < tipRoles.length; ++i) {
                ColumnMetadata cmd = region.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null || tipVars.containsKey(cmd.getName())) continue;
                String tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                SASFormat fmt = cmd.getFormat();
                StringVectorVariable var = null;
                if (useFormattedValues) {
                    var = new StringVectorVariable();
                    var.connectFrom(model.getColumnAsClassColumn(tipcol));
                } else if (cmd.getType() == 1) {
                    NumericVectorVariable nvv = new NumericVectorVariable();
                    nvv.connectFrom(model.getDoubleColumn(tipcol));
                    var = nvv;
                    if (fmt == null) {
                        fmt = DataModel.defaultFormat;
                    }
                } else {
                    StringVectorVariable tVar = new StringVectorVariable();
                    tVar.connectFrom(model.getColumnAsClassColumn(tipcol));
                    var = tVar;
                }
                var.setName(tipVarID);
                var.setLabel(cmd.getLabel());
                var.setFormat(new GTKFormat((Format)fmt));
                tipVars.put(tipVarID, var);
            }
            if (!tipVars.isEmpty()) {
                Object[] values = tipVars.values().toArray();
                Variable[] vars = new Variable[values.length];
                for (int i = 0; i < values.length; ++i) {
                    vars[i] = (Variable)values[i];
                }
                region.setDataTipVars(vars);
            }
        }
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        RegionContainer rc = (RegionContainer)graph.getObjectFromElement(elem);
        if (rc == null) {
            rc = new RegionContainer();
        }
        GraphComponentParser.load(graph, elem, rc, null);
        StatGraph.parseBorderOpts(graph, rc, elem, null);
        LayoutRegionParser.initRegion(graph, elem, rc);
        ArrayList plots = new ArrayList();
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            SGAnnotationContainer ac;
            AbstractAnno text;
            OverlayContainer oc;
            AbstractSGComponent jc;
            AbstractSGComponent legend;
            String loc;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = false;
            Region plot = null;
            if (elemTag.equals("PieChartParm") || elemTag.equals("PieParm") || elemTag.equals("PieChart")) {
                plot = PieParser2.load(graph, (Element)node);
                ok |= LayoutRegionParser.addPlotToList(plots, plot, "PIECHART");
            } else if (elemTag.equals("PathDiagram")) {
                plot = PathDiagramParser.load(graph, (Element)node);
                ok |= LayoutRegionParser.addPlotToList(plots, plot, "PATHDIAGRAM");
            } else if (elemTag.equals("DecisionTree")) {
                RegionContainer ov;
                Element overviewElem;
                plot = DecisionTreeParser.load(graph, (Element)node);
                if ((ok |= LayoutRegionParser.addPlotToList(plots, plot, "DECISIONTREE")) && (overviewElem = StatGraph.getOptionAttrsElement(elem, "Overview")) != null && (ov = DecisionTreeParser.parseOverviewRegion(graph, overviewElem, (DecisionTreeRegion)plot)) != null) {
                    rc.add((Component)ov, 0, "Inset");
                }
            } else if (elemTag.equalsIgnoreCase("TreeMap")) {
                plot = TileParser.load(graph, (Element)node);
                ok |= LayoutRegionParser.addPlotToList(plots, plot, "TREEMAP");
            } else if (elemTag.equalsIgnoreCase("MosaicPlotParm")) {
                plot = MosaicParser.load(graph, (Element)node);
                ok |= LayoutRegionParser.addPlotToList(plots, plot, "MOSAICPLOTPARM");
            } else if (elemTag.equals("KPIParm") || elemTag.equals("KPIChart")) {
                plot = KPIParser.load(graph, (Element)node);
                ok |= LayoutRegionParser.addPlotToList(plots, plot, "KPICHART");
            } else {
                graph.hasForeignObject = true;
            }
            if (ok) {
                rc.add(plot);
            }
            int insetCmps = 0;
            if (elemTag.equals("Entry")) {
                JComponent entry = (JComponent)graph.getObjectFromElement((Element)node);
                if (entry == null) {
                    entry = new EntryComposite();
                }
                EntryConcatParser.load(graph, (Element)node, entry, rc, 0);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                        entry.setAlignmentY(0.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, entry);
                    rc.addSidebar(entry);
                    continue;
                }
                rc.add((Component)entry, 0, "Inset");
                continue;
            }
            if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                legend = (Legend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new Legend();
                }
                LegendParser.load(graph, (Element)node, legend, rc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    rc.add((Component)legend, 0, "Inset");
                    continue;
                }
                if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                    legend.setAlignmentY(1.0f);
                }
                StatGraph.addDefaultOuterPad((Element)node, legend);
                rc.addLegend(legend);
                continue;
            }
            if (elemTag.equals("ContinuousLegend")) {
                legend = (LegendComponent)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new LegendComponent();
                }
                LegendParser.load(graph, (Element)node, legend, rc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    rc.add((Component)legend, 0, "Inset");
                    continue;
                }
                if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                    legend.setAlignmentX(1.0f);
                }
                if (legend.getAlignmentY() == 0.0f || legend.getAlignmentY() == 1.0f) {
                    ((LegendComponent)legend).setHorizontal(true);
                }
                StatGraph.addDefaultOuterPad((Element)node, legend);
                rc.addLegend(legend);
                continue;
            }
            if (elemTag.equals("SizeLegend")) {
                legend = (SizeLegendComponent)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new SizeLegendComponent();
                }
                SizeLegendParser.load(graph, (Element)node, legend, rc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    rc.add((Component)legend, 0, "Inset");
                    continue;
                }
                if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                    legend.setAlignmentX(1.0f);
                }
                if (legend.getAlignmentY() == 0.0f || legend.getAlignmentY() == 1.0f) {
                    legend.setHorizontal(true);
                }
                StatGraph.addDefaultOuterPad((Element)node, legend);
                rc.addLegend(legend);
                continue;
            }
            if (elemTag.equals("LayoutRegion")) {
                RegionContainer r = null;
                jc = LayoutRegionParser.load(graph, (Element)node);
                if (jc instanceof RegionContainer) {
                    r = (RegionContainer)jc;
                }
                if (r == null) continue;
                rc.add((Component)r, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutOverlay")) {
                oc = null;
                jc = LayoutOverlayParser.load(graph, (Element)node);
                if (jc instanceof OverlayContainer) {
                    oc = (OverlayContainer)jc;
                }
                if (oc == null) continue;
                rc.add((Component)oc, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutOverlayEquated")) {
                oc = null;
                jc = LayoutOverlayEquatedParser.load(graph, (Element)node);
                if (jc instanceof OverlayContainer) {
                    oc = (OverlayContainer)jc;
                }
                if (oc == null) continue;
                rc.add((Component)oc, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutOverlay3D")) {
                oc = null;
                jc = LayoutOverlay3DParser.load(graph, (Element)node);
                if (jc instanceof OverlayContainer) {
                    oc = (OverlayContainer)jc;
                }
                if (oc == null) continue;
                rc.add((Component)oc, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutOverlayMapTemp")) {
                oc = null;
                jc = LayoutOverlayMapTempParser.load(graph, (Element)node);
                if (jc instanceof OverlayContainer) {
                    oc = (OverlayContainer)jc;
                }
                if (oc == null) continue;
                rc.add((Component)oc, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutOverlayMap")) {
                oc = null;
                jc = LayoutOverlayMapParser.load(graph, (Element)node);
                if (jc instanceof OverlayContainer) {
                    oc = (OverlayContainer)jc;
                }
                if (oc == null) continue;
                rc.add((Component)oc, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutQCOverlay")) {
                JComponent overlayContainer = StatGraph.parseThirdPartyComponent(graph, (Element)node);
                if (overlayContainer == null) continue;
                rc.add((Component)overlayContainer, insetCmps, "Inset");
                ++insetCmps;
                continue;
            }
            if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = (GridPanel)graph.getObjectFromElement((Element)node);
                if (grid == null) {
                    grid = new GridPanel();
                }
                GridPanelParser.load(graph, (Element)node, grid, rc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (grid.getAlignmentX() == 0.5f && grid.getAlignmentY() == 0.5f) {
                        grid.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, grid);
                    rc.addSidebar(grid);
                    continue;
                }
                rc.add((Component)grid, 0, "Inset");
                continue;
            }
            if (elemTag.equals("LayoutLattice")) {
                rc.add((Component)LayoutLatticeParser.load(graph, (Element)node), 0, "Inset");
                continue;
            }
            if (!elemTag.startsWith("Draw") || (text = AnnotateParser.load(graph, (Element)node, (AnnotationContainer)(ac = new SGAnnotationContainer(rc, graph.rootPanel)))) == null) continue;
            if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                graph.annotationInBackList.add(text);
                continue;
            }
            graph.annotationInFrontList.add(text);
        }
        return rc;
    }

    private static boolean addPlotToList(ArrayList plots, JComponent plot, String plotName) {
        if (plot == null) {
            return false;
        }
        if (plots.size() > 0) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "MultiplePlots.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)plotName));
            return false;
        }
        plots.add(plot);
        return true;
    }

    private static void initRegion(StatGraph graph, Element elem, RegionContainer rc) {
        float vanchor;
        float hanchor;
        if (elem.hasAttribute("hanchor") && !Float.isNaN(hanchor = LayoutRegionParser.getAlignment(elem.getAttribute("hanchor")))) {
            rc.setHAnchor(hanchor);
        }
        if (elem.hasAttribute("vanchor") && !Float.isNaN(vanchor = LayoutRegionParser.getAlignment(elem.getAttribute("vanchor")))) {
            rc.setVAnchor(vanchor);
        }
    }

    private static float getAlignment(String str) {
        if (str != null && str.length() > 0) {
            if (str.equals("left")) {
                return 0.0f;
            }
            if (str.equals("center")) {
                return 0.5f;
            }
            if (str.equals("right")) {
                return 1.0f;
            }
        }
        return Float.NaN;
    }

    public static void parseWhere(StatGraph graph, CRD crd, Region plot) {
        if (graph.whereExpression == null) {
            return;
        }
        if (crd.getSrcModel().name == null || graph.whereDataModelName != null && !crd.getSrcModel().name.equalsIgnoreCase(graph.whereDataModelName)) {
            return;
        }
        if (!LayoutDataLatticeParser.isSupportedInsideDataLattice(plot)) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "dpdl.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)plot.getStmt()));
            return;
        }
        crd.whereVars = graph.whereVars;
        crd.whereVarsOnSeparateModel = graph.whereVarsOnSeparateModel;
        crd.whereIncludeMissingClass = graph.whereIncludeMissingClass;
        crd.whereExpression = graph.whereExpression;
        crd.allWhereExpressions = graph.allWhereExpressions;
    }

    public static void resolveReferences(Container container, Component oldComponent, Component[] newComponents) {
        RegionContainer rc = null;
        String name = null;
        if (container instanceof RegionContainer) {
            rc = (RegionContainer)container;
        }
        Component[] components = container.getComponents();
        int index = -1;
        for (int i = 0; index < 0 && i < components.length; ++i) {
            if (!components[i].equals(oldComponent)) continue;
            index = i;
            if (rc == null) continue;
            name = rc.getLayoutComponentName(oldComponent);
        }
        container.remove(oldComponent);
        if (name != null) {
            rc.add(newComponents[newComponents.length - 1], index, name);
        } else {
            container.add(newComponents[newComponents.length - 1], index);
        }
    }
}

