/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.AxisLegendParser;
import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.BlockParser;
import com.sas.graphics.applets.statgraph.BubbleParser;
import com.sas.graphics.applets.statgraph.ContourParser;
import com.sas.graphics.applets.statgraph.DropLineParser;
import com.sas.graphics.applets.statgraph.EllipseParmParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.FringeParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GridPanelParser;
import com.sas.graphics.applets.statgraph.HeatMapParmParser;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlay3DParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapTempParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.LineParmParser;
import com.sas.graphics.applets.statgraph.MapLayerParser;
import com.sas.graphics.applets.statgraph.MapRegionLayerParser;
import com.sas.graphics.applets.statgraph.NeedleParser;
import com.sas.graphics.applets.statgraph.PolygonParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.RangeAttrMapViewParser;
import com.sas.graphics.applets.statgraph.ReferenceLineParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.SeriesParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StepParser;
import com.sas.graphics.applets.statgraph.TableParser;
import com.sas.graphics.applets.statgraph.TextPlotParser;
import com.sas.graphics.applets.statgraph.VectorParser;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.entry.AxisLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.entry.Table;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.CarpetOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ESRIMapLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ESRIMapRegionLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapLayerOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RangeAttrMapViewOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.text.Message;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LayoutOverlayEquatedParser {
    public static final String RB_KEY = "LayoutOverlayParser.";

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        return LayoutOverlayEquatedParser.load(graph, elem, false);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost) {
        return LayoutOverlayEquatedParser.load(graph, elem, outmost, false);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost, boolean map) {
        graph.style.resetCounters();
        String str = elem.getAttribute("cycleAttrs");
        String spatialReference = null;
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            graph.style.setCycleAttrs(true);
        } else {
            graph.style.setCycleAttrs(false);
        }
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = LayoutOverlayParser.initComposite(graph, elem);
        }
        GraphComponentParser.load(graph, elem, oc, null);
        StatGraph.parseBorderOpts(graph, oc, elem, null);
        if (!elem.getAttribute("opaque").equalsIgnoreCase("true")) {
            oc.getBaseComponent().setTransparentBackground(graph.isTransparentBackground());
        }
        Simple2DOverlayComposite soc = oc.getComposite();
        str = elem.getAttribute("equateType");
        if (str.equalsIgnoreCase("fit")) {
            soc.setSquareFormat(Simple2DOverlayComposite.EQUATED_MAXAREA);
        } else if (str.equalsIgnoreCase("square")) {
            soc.setSquareFormat(Simple2DOverlayComposite.EQUATED_SQUARE);
        } else if (str.equalsIgnoreCase("equate")) {
            soc.setSquareFormat(Simple2DOverlayComposite.EQUATED_CENTER);
        } else if (str.equalsIgnoreCase("squaredata")) {
            soc.setSquareFormat(Simple2DOverlayComposite.EQUATED_SQUAREDATA);
        } else {
            soc.setSquareFormat(Simple2DOverlayComposite.EQUATED_MAXAREA);
            if (str.length() > 0) {
                StatGraph.printOptionError("EQUATETYPE", str);
            }
        }
        str = elem.getAttribute("equateAxes");
        if (str.equalsIgnoreCase("xy")) {
            soc.setSquareFormatPrimary(true);
        } else if (str.equalsIgnoreCase("xy2")) {
            soc.setSquareFormatPrimary(false);
        }
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        LayoutOverlayParser.initAxis(graph, xAxis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, x2Axis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, yAxis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.initAxis(graph, y2Axis, graph.axisLineOffsetCoverage);
        LayoutOverlayParser.decideAxesType(graph, elem, null, null);
        ArrayList<Overlay> mapOverlays = new ArrayList<Overlay>();
        ArrayList plots = new ArrayList();
        boolean firstMapAdded = false;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            JComponent overlayContainer;
            String loc;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = true;
            if (elemTag.equals("ScatterPlot")) {
                LayoutOverlayParser.addPlotToList(plots, ScatterParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("TextPlot")) {
                LayoutOverlayParser.addPlotToList(plots, TextPlotParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("SeriesPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                LayoutOverlayParser.addPlotToList(plots, SeriesParser.load(graph, (Element)node, curveLabelPosition), graph, !outmost);
            } else if (elemTag.equals("StepPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                LayoutOverlayParser.addPlotToList(plots, StepParser.load(graph, (Element)node, curveLabelPosition), graph, !outmost);
            } else if (elemTag.equals("NeedlePlot")) {
                LayoutOverlayParser.addPlotToList(plots, NeedleParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("VectorPlot")) {
                LayoutOverlayParser.addPlotToList(plots, VectorParser.load(graph, (Element)node));
            } else if (elemTag.equals("BandPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                LayoutOverlayParser.addPlotToList(plots, BandParser.load(graph, (Element)node, curveLabelPosition));
            } else if (elemTag.equals("BubblePlot")) {
                LayoutOverlayParser.addPlotToList(plots, BubbleParser.load(graph, (Element)node));
            } else if (elemTag.equals("HeatmapParm")) {
                LayoutOverlayParser.addPlotToList(plots, HeatMapParmParser.load(graph, (Element)node));
            } else if (elemTag.equals("LineParm")) {
                LayoutOverlayParser.addPlotToList(plots, LineParmParser.load(graph, (Element)node));
            } else if (elemTag.equals("ReferenceLine")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                LayoutOverlayParser.addPlotToList(plots, ReferenceLineParser.load(graph, (Element)node, curveLabelPosition));
            } else if (elemTag.equals("DropLine")) {
                LayoutOverlayParser.addPlotToList(plots, DropLineParser.load(graph, (Element)node));
            } else if (elemTag.equals("EllipseParm")) {
                LayoutOverlayParser.addPlotToList(plots, EllipseParmParser.load(graph, (Element)node));
            } else if (elemTag.equals("RangeAttrMapView")) {
                LayoutOverlayParser.addPlotToList(plots, RangeAttrMapViewParser.load(graph, (Element)node));
            } else if (elemTag.equals("ContourPlotParm")) {
                LayoutOverlayParser.addPlotToList(plots, ContourParser.load(graph, (Element)node));
            } else if (elemTag.equals("FringePlot")) {
                LayoutOverlayParser.addPlotToList(plots, FringeParser.load(graph, (Element)node));
            } else if (elemTag.equals("BlockPlot")) {
                BlockOverlay block = BlockParser.load(graph, (Element)node);
                String s = ((Element)node).getAttribute("display");
                if (s.length() == 0 || s.equalsIgnoreCase("STANDARD")) {
                    block.setValueOn(false);
                    block.setLabelOn(false);
                }
                LayoutOverlayParser.addPlotToList(plots, block);
            } else if (elemTag.equals("MapLayer")) {
                MapLayerOverlay mapOverlay = MapLayerParser.load(graph, (Element)node);
                LayoutOverlayParser.addPlotToList(plots, mapOverlay);
                if (mapOverlay instanceof ESRIMapLayerOverlay) {
                    spatialReference = ((ESRIMapLayerOverlay)mapOverlay).getSpatialReference();
                }
            } else if (elemTag.equals("MapRegionLayer")) {
                Overlay mapOverlay = MapRegionLayerParser.load(graph, (Element)node);
                if (mapOverlay instanceof ESRIMapRegionLayerOverlay) {
                    map = false;
                    ((ESRIMapRegionLayerOverlay)mapOverlay).setSpatialReference(spatialReference);
                } else {
                    map = true;
                }
                LayoutOverlayParser.addPlotToList(mapOverlays, mapOverlay);
                LayoutOverlayParser.addPlotToList(plots, mapOverlay);
            } else if (elemTag.equals("PolygonPlot")) {
                LayoutOverlayParser.addPlotToList(plots, PolygonParser.load(graph, (Element)node), graph, !outmost);
            } else if (elemTag.equals("Entry")) {
                JComponent entry = (JComponent)graph.getObjectFromElement((Element)node);
                if (entry == null) {
                    entry = new EntryComposite();
                }
                EntryConcatParser.load(graph, (Element)node, entry, oc, 0);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                        entry.setAlignmentY(0.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, entry);
                    oc.addSidebar(entry);
                } else {
                    oc.add((Component)entry, 0);
                }
            } else if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend") || elemTag.equals("AutoLegend")) {
                Legend legend = (Legend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new Legend();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, legend);
                    oc.addLegend(legend);
                }
            } else if (elemTag.equals("ContinuousLegend")) {
                LegendComponent legend = (LegendComponent)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new LegendComponent();
                }
                LegendParser.load(graph, (Element)node, legend, oc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentX(1.0f);
                    }
                    if (legend.getAlignmentY() == 0.0f || legend.getAlignmentY() == 1.0f) {
                        legend.setHorizontal(true);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, legend);
                    oc.addLegend(legend);
                }
            } else if (elemTag.equals("AxisLegend")) {
                AxisLegend legend = (AxisLegend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new AxisLegend();
                }
                AxisLegendParser.load(graph, (Element)node, legend, oc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, legend);
                    oc.addLegend(legend);
                }
            } else if (elemTag.equals("GTable")) {
                Table table = (Table)graph.getObjectFromElement((Element)node);
                if (table == null) {
                    table = new Table();
                }
                TableParser.load(graph, (Element)node, table, oc);
                oc.add((Component)table, 0);
            } else if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = (GridPanel)graph.getObjectFromElement((Element)node);
                if (grid == null) {
                    grid = new GridPanel();
                }
                GridPanelParser.load(graph, (Element)node, grid, oc);
                loc = ((Element)node).getAttribute("location");
                LayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (grid.getAlignmentX() == 0.5f && grid.getAlignmentY() == 0.5f) {
                        grid.setAlignmentY(1.0f);
                    }
                    StatGraph.addDefaultOuterPad((Element)node, grid);
                    oc.addSidebar(grid);
                } else {
                    oc.add((Component)grid, 0);
                }
            } else if (elemTag.equals("LayoutOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayEquated")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayEquatedParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMapTemp")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayMapTempParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMap")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayMapParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutQCOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = StatGraph.parseThirdPartyComponent(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlay3D")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlay3DParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(((BaseOverlayContainer)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutLattice")) {
                oc.add((Component)LayoutLatticeParser.load(graph, (Element)node), 0);
            } else if (elemTag.equals("LayoutDataLattice")) {
                oc.add((Component)LayoutDataLatticeParser.load(graph, (Element)node), 0);
            } else if (elemTag.equals("LayoutDataPanel")) {
                oc.add((Component)LayoutDataLatticeParser.load(graph, (Element)node, true), 0);
            } else if (elemTag.startsWith("Draw")) {
                AbstractAnno text = AnnotateParser.load(graph, (Element)node, oc);
                if (text != null) {
                    if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                        graph.annotationInBackList.add(text);
                    } else {
                        graph.annotationInFrontList.add(text);
                    }
                }
            } else {
                graph.hasForeignObject = true;
            }
            if (ok) continue;
            oc.removeAll();
            return oc;
        }
        if (plots.size() == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "equated.txt"));
            oc.removeAll();
            return oc;
        }
        graph.equatedPlots = new ArrayList();
        for (int i = 0; i < plots.size(); ++i) {
            graph.equatedPlots.add(plots.get(i));
        }
        LayoutOverlayParser.xAxisType = 0;
        LayoutOverlayParser.x2AxisType = 0;
        LayoutOverlayParser.yAxisType = 0;
        LayoutOverlayParser.y2AxisType = 0;
        if (map) {
            LayoutOverlayEquatedParser.parseViewportOpts(graph, elem, mapOverlays, xAxis, yAxis);
        }
        LayoutOverlayEquatedParser.parseEquateAxisOptsList(graph, soc, elem, xAxis, x2Axis, yAxis, y2Axis, null);
        LayoutOverlayParser.parsePointLabelOpts(graph, soc, elem);
        int xyPlotCnt = 0;
        boolean parmPlotCnt = false;
        for (int i = 0; i < plots.size(); ++i) {
            Overlay plot = (Overlay)plots.get(i);
            if (LayoutOverlayEquatedParser.isLinearOverlay(plot)) {
                plot.setXAxis("x");
                plot.setYAxis("y");
                LayoutOverlayParser.addOverlay(plot, soc, xAxis, x2Axis, yAxis, y2Axis, null);
                if (!LayoutOverlayEquatedParser.isXYPlot(plot)) continue;
                ++xyPlotCnt;
                continue;
            }
            Message msg = new Message(RB.getStringResource(RB_KEY, "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)plot.getStmt()));
        }
        if (xyPlotCnt == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "equated.txt"));
            oc.removeAll();
            return oc;
        }
        str = graph.style.getStyleAttribute("GridLines", "displayOpts");
        if (str != null && str.equalsIgnoreCase("on")) {
            if (StatGraph.getOptionAttrsElement(elem, "XAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, xAxis, soc);
                LayoutOverlayParser.addAutoGridLine(graph, x2Axis, soc);
            }
            if (StatGraph.getOptionAttrsElement(elem, "YAxisOpts") == null) {
                LayoutOverlayParser.addAutoGridLine(graph, yAxis, soc);
                LayoutOverlayParser.addAutoGridLine(graph, y2Axis, soc);
            }
        }
        ArrayList overlays = soc.getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay o = (Overlay)overlays.get(i);
            if (xAxis.isVisible()) {
                soc.connect(o, (AbstractAxis)xAxis, (byte)1);
            }
            if (x2Axis.isVisible()) {
                soc.connect(o, (AbstractAxis)x2Axis, (byte)1);
            }
            if (yAxis.isVisible()) {
                soc.connect(o, (AbstractAxis)yAxis, (byte)2);
            }
            if (!y2Axis.isVisible()) continue;
            soc.connect(o, (AbstractAxis)y2Axis, (byte)2);
        }
        if (!(xAxis.isVisible() || x2Axis.isVisible() || yAxis.isVisible() || y2Axis.isVisible())) {
            soc.setAxesVisible(false);
        }
        return oc;
    }

    static boolean isLinearOverlay(Overlay overlay) {
        int xType = LayoutOverlayParser.getAxisType(overlay.getDataRange((byte)1));
        int yType = LayoutOverlayParser.getAxisType(overlay.getDataRange((byte)2));
        return (xType < 0 || xType == 0) && (yType < 0 || yType == 0);
    }

    static boolean isXYPlot(Overlay overlay) {
        return !(overlay instanceof ReferenceLineOverlay) && !(overlay instanceof DropLineOverlay) && !(overlay instanceof BlockOverlay) && !(overlay instanceof CarpetOverlay) && !(overlay instanceof LineParmOverlay) && (!(overlay instanceof EllipseParmOverlay) || !overlay.getStmt().equalsIgnoreCase("EllipseParm")) && !(overlay instanceof RangeAttrMapViewOverlay) && !(overlay instanceof AxisTable);
    }

    static void parseEquateAxisOptsList(StatGraph graph, Simple2DOverlayComposite soc, Element elem, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        String elemTag = "";
        VRectAxis stubAxis = null;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = true;
            if (elemTag.equals("CommonAxisOpts")) {
                stubAxis = new VRectAxis(1, false);
                LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, stubAxis);
                continue;
            }
            if (elemTag.equals("XAxisOpts")) {
                xa.setVisible(true);
                x2a.setVisible(true);
                LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, xa);
                LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node, xa, soc);
                if (soc.getSquareFormat() != Simple2DOverlayComposite.EQUATED_CENTER) {
                    xa.setViewportMin(Double.NaN);
                    xa.setViewportMax(Double.NaN);
                }
                LayoutOverlayParser.copyAxisOptions(xa, x2a);
                LayoutOverlayEquatedParser.parseAxisDisplay2Opts(((Element)node).getAttribute("displaySecondary"), x2a);
                x2a.setSecondary(true);
                xa.setMirrorAxis(x2a);
                continue;
            }
            if (!elemTag.equals("YAxisOpts")) continue;
            ya.setVisible(true);
            y2a.setVisible(true);
            LayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, ya);
            LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node, ya, soc);
            if (soc.getSquareFormat() != Simple2DOverlayComposite.EQUATED_CENTER) {
                ya.setViewportMin(Double.NaN);
                ya.setViewportMax(Double.NaN);
            }
            LayoutOverlayParser.copyAxisOptions(ya, y2a);
            LayoutOverlayEquatedParser.parseAxisDisplay2Opts(((Element)node).getAttribute("displaySecondary"), y2a);
            y2a.setSecondary(true);
            ya.setMirrorAxis(y2a);
        }
        if (stubAxis != null) {
            boolean integerAxis = stubAxis.isIntegerTicks();
            xa.setIntegerTicks(integerAxis);
            x2a.setIntegerTicks(integerAxis);
            ya.setIntegerTicks(integerAxis);
            y2a.setIntegerTicks(integerAxis);
            int tickStyle = stubAxis.getAxisStyle().getMajorTickStyle().getTickMarkJustification();
            xa.getAxisStyle().getMajorTickStyle().setTickMarkJustification(tickStyle);
            x2a.getAxisStyle().getMajorTickStyle().setTickMarkJustification(tickStyle);
            ya.getAxisStyle().getMajorTickStyle().setTickMarkJustification(tickStyle);
            y2a.getAxisStyle().getMajorTickStyle().setTickMarkJustification(tickStyle);
            double[] ticks = stubAxis.getTicks();
            xa.setTicks(ticks);
            x2a.setTicks(ticks);
            ya.setTicks(ticks);
            y2a.setTicks(ticks);
            if (soc.getSquareFormat() == Simple2DOverlayComposite.EQUATED_SQUARE) {
                double viewMin = stubAxis.getViewportMin();
                xa.setViewportMin(viewMin);
                x2a.setViewportMin(viewMin);
                ya.setViewportMin(viewMin);
                y2a.setViewportMin(viewMin);
                double viewMax = stubAxis.getViewportMax();
                xa.setViewportMax(viewMax);
                x2a.setViewportMax(viewMax);
                ya.setViewportMax(viewMax);
                y2a.setViewportMax(viewMax);
                boolean priority = stubAxis.getTickValuePriority();
                xa.setTickValuePriority(priority);
                x2a.setTickValuePriority(priority);
                ya.setTickValuePriority(priority);
                y2a.setTickValuePriority(priority);
            }
        }
    }

    public static void parseAxisDisplay2Opts(String str, VRectAxis axis) {
        if (str == null || str.length() == 0 || str.equalsIgnoreCase("none")) {
            axis.setVisible(false);
            return;
        }
        AxisStyle as = axis.getAxisStyle();
        if (str.equalsIgnoreCase("STANDARD") || str.equalsIgnoreCase("ALL")) {
            as.setAxisLineOn(true);
            as.setMajorTickMarksOn(true);
            as.setTitleOn(true);
            as.setLabelsOn(true);
        } else {
            as.setAxisLineOn(false);
            as.setMajorTickMarksOn(false);
            as.setTitleOn(false);
            as.setLabelsOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("LINE")) {
                    as.setAxisLineOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("TICKS")) {
                    as.setMajorTickMarksOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("LABEL")) {
                    as.setTitleOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("TICKVALUES")) {
                    as.setLabelsOn(true);
                    continue;
                }
                axis.setVisible(false);
                StatGraph.printOptionError("DISPLAYSECONDARY", opts[i]);
                break;
            }
        }
        axis.setMajorTicksOn(as.isMajorTickMarksOn());
    }

    public static void parseViewportOpts(StatGraph graph, Element elem, ArrayList<Overlay> mapOverlays, VRectAxis xAxis, VRectAxis yAxis) {
        int i;
        if (mapOverlays.size() == 0) {
            return;
        }
        MapOverlay mapOverlay = (MapOverlay)mapOverlays.get(0);
        double xmin = mapOverlay.getMapXMin();
        double xmax = mapOverlay.getMapXMax();
        double ymin = mapOverlay.getMapYMin();
        double ymax = mapOverlay.getMapYMax();
        for (i = 1; i < mapOverlays.size(); ++i) {
            mapOverlay = (MapOverlay)mapOverlays.get(i);
            if (xmin > mapOverlay.getMapXMin()) {
                xmin = mapOverlay.getMapXMin();
            }
            if (xmax < mapOverlay.getMapXMax()) {
                xmax = mapOverlay.getMapXMax();
            }
            if (ymin > mapOverlay.getMapYMin()) {
                ymin = mapOverlay.getMapYMin();
            }
            if (!(ymax < mapOverlay.getMapYMax())) continue;
            ymax = mapOverlay.getMapYMax();
        }
        Element vpOpts = StatGraph.getOptionAttrsElement(elem, "ViewportOpts");
        if (vpOpts != null) {
            Element plotsElem = StatGraph.getOptionAttrsElement(vpOpts, "ViewportPlotList");
            if (plotsElem != null) {
                String[] plots = StatGraph.parseStringValueList(plotsElem, "Value");
                double txmin = Double.MAX_VALUE;
                double txmax = -1.7976931348623157E308;
                double tymin = Double.MAX_VALUE;
                double tymax = -1.7976931348623157E308;
                boolean found = false;
                for (i = 0; i < plots.length; ++i) {
                    DataRange yRange;
                    Object plot = graph.graphNamesTable.get(plots[i]);
                    if (plot == null) continue;
                    Overlay o = (Overlay)plot;
                    DataRange xRange = o.getDataRange((byte)1);
                    if (xRange != null && xRange instanceof ContinuousRange) {
                        txmin = Math.min(txmin, ((ContinuousRange)xRange).getMin());
                        txmax = Math.max(txmax, ((ContinuousRange)xRange).getMax());
                    }
                    if ((yRange = o.getDataRange((byte)2)) != null && yRange instanceof ContinuousRange) {
                        tymin = Math.min(tymin, ((ContinuousRange)yRange).getMin());
                        tymax = Math.max(tymax, ((ContinuousRange)yRange).getMax());
                    }
                    found = true;
                }
                if (found) {
                    xmin = txmin;
                    xmax = txmax;
                    ymin = tymin;
                    ymax = tymax;
                }
            } else {
                String str = vpOpts.getAttribute("xMin");
                if (StatGraph.isNumber(str)) {
                    xmin = Double.parseDouble(str);
                }
                if (StatGraph.isNumber(str = vpOpts.getAttribute("xMax"))) {
                    xmax = Double.parseDouble(str);
                }
                if (StatGraph.isNumber(str = vpOpts.getAttribute("yMin"))) {
                    ymin = Double.parseDouble(str);
                }
                if (StatGraph.isNumber(str = vpOpts.getAttribute("yMax"))) {
                    ymax = Double.parseDouble(str);
                }
            }
        }
        xAxis.setViewportMin(xmin);
        xAxis.setViewportMax(xmax);
        yAxis.setViewportMin(ymin);
        yAxis.setViewportMax(ymax);
        xAxis.setStartCoverage(0.0);
        xAxis.setEndCoverage(0.0);
        xAxis.setUserStartOffset(0.0);
        xAxis.setUserEndOffset(0.0);
        yAxis.setStartCoverage(0.0);
        yAxis.setEndCoverage(0.0);
        yAxis.setUserStartOffset(0.0);
        yAxis.setUserEndOffset(0.0);
    }
}

