/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.RotatedJTextPane;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.RectAxisParams;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.StyledLineBorder;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridLabelEntry;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.grid.ExtrudedTrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.StripLabel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.BaseGridAxis;
import com.sas.graphics.applets.statgraph.sgchart.grid.gtk.GridAxis;
import com.sas.graphics.applets.statgraph.sgchart.overlays.AxisTable;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BandOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BarOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BiVarHistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BubbleOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.CarpetOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ContourOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DendrogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HeatBoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HeatMapParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HighLowOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineChartOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PieOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PolygonOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.RangeAttrMapViewOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SurfaceOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.TimeSeriesOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.WaterfallChartOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.regions.PieRegion;
import com.sas.graphics.applets.statgraph.sgchart.regions.Region;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.Sort;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.datatree.DataTreeGroupNode;
import com.sas.graphics.util.gtk.datatree.DataTreeInfo;
import com.sas.graphics.util.gtk.datatree.DataTreeUtil;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayoutDataLatticeParser {
    public static final String RB_KEY = "LayoutDataLatticeParser.";
    public static final int AUTO = -1;
    public static final int DATA = 0;
    public static final int ASCENDING_FORMATTED = 1;
    public static final int DESCENDING_FORMATTED = 2;
    public static final int CAS_ASCENDING = 3;
    static final int PROPORTIONAL_WEIGHT = 0;
    static final int EQUAL_WEIGHT = 1;
    static final String EXCLUDED_CLASS_VALUE = "__ALL__";

    public static TrellisPlot load(StatGraph graph, Element elem) {
        return LayoutDataLatticeParser.load(graph, elem, false);
    }

    public static TrellisPlot load(StatGraph graph, Element elem, boolean dataPanelLayout) {
        graph.pushFontsShrinkage(elem);
        TrellisPlot plot = (TrellisPlot)graph.getObjectFromElement(elem);
        if (plot == null) {
            plot = new TrellisPlot();
        }
        LayoutDataLatticeParser.load(graph, elem, plot, dataPanelLayout);
        graph.popFontsShrinkage(elem);
        return plot;
    }

    public static void load(StatGraph graph, Element elem, TrellisPlot plot, boolean dataPanelLayout) {
        ArrayList axes;
        int totalCells;
        double percent;
        plot.disableLayout();
        GraphComponentParser.load(graph, elem, (JComponent)plot, null);
        StatGraph.parseBorderOpts(graph, (JComponent)plot, elem, null);
        DataLatticeProperties pp = new DataLatticeProperties();
        pp.isDataPanel = dataPanelLayout;
        pp.multiDataModel = elem.getAttribute("multiDataModels").equalsIgnoreCase("true");
        String str = elem.getAttribute("includeMissingClass");
        if (str.equalsIgnoreCase("false")) {
            pp.includeMissing = false;
        }
        StringVariable[] clsvv = null;
        StringVariable[] rvv = null;
        StringVariable[] cvv = null;
        DataModel model = null;
        int page = 0;
        String dataName = null;
        int numRows = 1;
        int numCols = 1;
        pp.maxNumCols = 1;
        pp.maxNumRows = 1;
        pp.startCol = 0;
        pp.startRow = 0;
        Element incElem = StatGraph.getOptionAttrsElement(elem, "Include");
        pp.inLookup = new HashMap();
        HashMap sortOrderMap = null;
        int[] cellIndexMap = null;
        if (pp.isDataPanel) {
            Message msg;
            int maxPages;
            Element vElem = StatGraph.getOptionAttrsElement(elem, "ClassVars");
            if (vElem == null) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "class.txt"));
                return;
            }
            String[] vars = StatGraph.parseStringValueList(vElem, "Value");
            dataName = StatGraph.getDataName(vars[0]);
            HashMap<String, String> roleMap = new HashMap<String, String>();
            roleMap.put("CLASSVAR0", vars[0]);
            for (int i = 1; i < vars.length; ++i) {
                String dn = StatGraph.getDataName(vars[i]);
                if (!dn.equals(dataName)) {
                    StatGraph.printWarning(RB.getStringResource(RB_KEY, "data.txt"));
                    return;
                }
                roleMap.put("CLASSVAR" + i, vars[i]);
            }
            sortOrderMap = LayoutDataLatticeParser.parseSortOrder(graph, elem, vars, roleMap);
            model = graph.getData(dataName);
            clsvv = new StringVariable[vars.length];
            int numLevels = 1;
            for (int i = 0; i < vars.length; ++i) {
                String[] classValues;
                String varID = StatGraph.getVarID(vars[vars.length - i - 1]);
                if (varID.length() <= 0) continue;
                int vcol = model.getColumn(varID);
                ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(vcol);
                StringVectorVariable classVar = new StringVectorVariable();
                if (pp.multiDataModel) {
                    classVar.setName(cmd.getName());
                }
                classVar.setLabel(cmd.getLabel());
                if (pp.includeMissing) {
                    classValues = model.getColumnAsClassColumn(vcol, true);
                    classVar.setBlankMissing(false);
                } else {
                    if (!StatGraph.checkVariable("CLASS", cmd, null, 1, true)) {
                        return;
                    }
                    classValues = model.getColumnAsClassColumn(vcol, false);
                }
                classVar.connectFrom(classValues);
                clsvv[i] = classVar;
                String[] cls = null;
                int sortOrder = -1;
                if (sortOrderMap != null && sortOrderMap.get(vars[vars.length - i - 1]) != null) {
                    sortOrder = (Integer)sortOrderMap.get(vars[vars.length - i - 1]);
                }
                cls = sortOrder == -1 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, vcol, pp) : LayoutDataLatticeParser.getIncludedClasses(incElem, varID, classValues, model.getColumnClass(vcol), pp)) : (sortOrder == 3 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, vcol, pp) : LayoutDataLatticeParser.getSortedClasses(model, vcol, pp, cmd.getType(), 1)) : LayoutDataLatticeParser.getSortedClasses(model, vcol, pp, cmd.getType(), sortOrder));
                if (cls != null) {
                    pp.inLookup.put(classVar, cls);
                }
                numLevels *= LayoutDataLatticeParser.getNumLevels((StringVariable)classVar, pp);
            }
            if (numLevels > graph.totalCellMax) {
                Message msg2 = new Message(RB.getStringResource(RB_KEY, "totalcellmax.fmt.txt"));
                StatGraph.printWarning(msg2.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(numLevels))));
                graph.setNumPages(1);
                return;
            }
            int rows = -1;
            int cols = -1;
            str = elem.getAttribute("rows");
            if (str.length() > 0) {
                rows = Integer.parseInt(str);
            }
            if ((str = elem.getAttribute("columns")).length() > 0) {
                cols = Integer.parseInt(str);
            }
            boolean sparse = false;
            str = elem.getAttribute("sparse");
            if (str.length() > 0 && str.equalsIgnoreCase("true")) {
                sparse = true;
            }
            if (sparse || pp.multiDataModel && model.getRowCount() == numLevels) {
                cellIndexMap = new int[numLevels];
                for (int i = 0; i < numLevels; ++i) {
                    cellIndexMap[i] = i;
                }
            } else {
                cellIndexMap = LayoutDataLatticeParser.compressDataPanel(graph, model, pp, clsvv);
                numLevels = cellIndexMap.length;
            }
            if (rows < 0 && cols < 0) {
                numCols = 1;
                numRows = numLevels;
            } else if (rows < 0 && cols > 0) {
                numCols = cols;
                numRows = (int)Math.ceil((double)numLevels / (double)cols);
            } else if (rows > 0 && cols < 0) {
                numCols = (int)Math.ceil((double)numLevels / (double)rows);
                numRows = rows;
            } else if (rows > 0 && cols > 0) {
                numCols = cols;
                numRows = rows;
            }
            if (rows > 0 && cols > 0 && (str = elem.getAttribute("panelNumber")).length() > 0) {
                page = Integer.parseInt(str) - 1;
            }
            pp.maxNumPages = maxPages = (int)Math.ceil((double)numLevels / (double)(numRows * numCols));
            if (!elem.hasAttribute("panelNumber")) {
                graph.setNumPages(maxPages);
            }
            if (page < 0) {
                msg = new Message(RB.getStringResource(RB_KEY, "page.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1)));
                return;
            }
            if (page >= maxPages) {
                msg = new Message(RB.getStringResource(RB_KEY, "page2.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1), (Object)Integer.toString(maxPages)));
                page = maxPages - 1;
            }
            if ((str = elem.getAttribute("order")).equalsIgnoreCase("COLUMNMAJOR")) {
                pp.rowMajor = false;
            } else if (str.equalsIgnoreCase("ROWMAJOR")) {
                pp.rowMajor = true;
            } else if (str.equalsIgnoreCase("PACKED")) {
                pp.packed = true;
            } else if (str.length() > 0) {
                pp.rowMajor = true;
                StatGraph.printOptionError("ORDER", str);
            }
        } else {
            Message msg;
            int maxPages;
            String[] cls;
            int sortOrder;
            String[] classValues;
            ColumnMetadata cmd;
            String[] rowVars = null;
            str = elem.getAttribute("rowVar");
            if (str.length() == 0) {
                Element rElem = StatGraph.getOptionAttrsElement(elem, "RowVars");
                if (rElem != null) {
                    rowVars = StatGraph.parseStringValueList(rElem, "Value");
                }
            } else {
                rowVars = new String[]{str};
            }
            if (rowVars != null) {
                dataName = StatGraph.getDataName(rowVars[0]);
            }
            String[] colVars = null;
            str = elem.getAttribute("columnVar");
            if (str.length() == 0) {
                Element cElem = StatGraph.getOptionAttrsElement(elem, "ColumnVars");
                if (cElem != null) {
                    colVars = StatGraph.parseStringValueList(cElem, "Value");
                }
            } else {
                colVars = new String[]{str};
            }
            String dn = null;
            if (colVars != null) {
                dn = StatGraph.getDataName(colVars[0]);
            }
            if (dataName == null || dataName.length() == 0) {
                dataName = dn;
            } else if (dn != null && dn.length() > 0 && !dn.equals(dataName)) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "data2.txt"));
                return;
            }
            if (dataName == null) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "data3.txt"));
                return;
            }
            if (rowVars != null && rowVars.length > 1) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "mdrow.txt"));
            }
            if (colVars != null && colVars.length > 1) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "mdcol.txt"));
            }
            HashMap<String, String> roleMap = new HashMap<String, String>();
            int cnt = 0;
            if (rowVars != null) {
                cnt += rowVars.length;
            }
            if (colVars != null) {
                cnt += colVars.length;
            }
            String[] vars = new String[cnt];
            if (rowVars != null) {
                for (int i = 0; i < rowVars.length; ++i) {
                    vars[i] = rowVars[i];
                    roleMap.put("ROWVAR", rowVars[i]);
                }
            }
            if (colVars != null) {
                int offset = rowVars == null ? 0 : rowVars.length;
                for (int i = 0; i < colVars.length; ++i) {
                    vars[i + offset] = colVars[i];
                    roleMap.put("COLUMNVAR", colVars[i]);
                }
            }
            sortOrderMap = LayoutDataLatticeParser.parseSortOrder(graph, elem, vars, roleMap);
            model = graph.getData(dataName);
            OLAPVariableFactory fac = null;
            ArrayList<String> rowDimNames = null;
            ArrayList<String> colDimNames = null;
            if (model == null) {
                model = graph.getOLAPModel(dataName);
                if (model == null) {
                    pp.degenerated = true;
                } else {
                    fac = model.getOLAPVarFactory();
                }
            }
            pp.dataModel = model;
            if (rowVars != null) {
                rvv = new StringVariable[rowVars.length];
                int numLevels = 1;
                if (StatGraph.isOLAP()) {
                    rowDimNames = new ArrayList<String>();
                }
                for (int i = 0; i < rowVars.length; ++i) {
                    String rowVarID = StatGraph.getVarID(rowVars[i]);
                    StringVariable rowClassVar = null;
                    if (StatGraph.isOLAP()) {
                        rowDimNames.add(rowVarID);
                        rowClassVar = StatGraph.getOLAPLevelVar(fac, rowVarID);
                        rowClassVar.getUniqueValueCount();
                        rvv[rvv.length - 1 - i] = rowClassVar;
                        continue;
                    }
                    int rowcol = model.getColumn(rowVarID);
                    cmd = (ColumnMetadata)model.getColumnLabel(rowcol);
                    rowClassVar = new StringVectorVariable();
                    if (pp.multiDataModel) {
                        rowClassVar.setName(cmd.getName());
                    }
                    rowClassVar.setLabel(cmd.getLabel());
                    if (pp.includeMissing) {
                        classValues = model.getColumnAsClassColumn(rowcol, true);
                        ((StringVectorVariable)rowClassVar).setBlankMissing(false);
                    } else {
                        if (!StatGraph.checkVariable("ROWVAR", cmd, null, 1, true)) {
                            return;
                        }
                        classValues = model.getColumnAsClassColumn(rowcol, false);
                    }
                    ((StringVectorVariable)rowClassVar).connectFrom(classValues);
                    sortOrder = -1;
                    if (sortOrderMap != null && sortOrderMap.get(rowVars[i]) != null) {
                        sortOrder = (Integer)sortOrderMap.get(rowVars[i]);
                    }
                    cls = sortOrder == -1 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, rowcol, pp) : LayoutDataLatticeParser.getIncludedClasses(incElem, rowVarID, classValues, model.getColumnClass(rowcol), pp)) : (sortOrder == 3 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, rowcol, pp) : LayoutDataLatticeParser.getSortedClasses(model, rowcol, pp, cmd.getType(), 1)) : LayoutDataLatticeParser.getSortedClasses(model, rowcol, pp, cmd.getType(), sortOrder));
                    if (cls != null) {
                        pp.inLookup.put(rowClassVar, cls);
                    }
                    numLevels *= LayoutDataLatticeParser.getNumLevels(rowClassVar, pp);
                    rvv[rvv.length - 1 - i] = rowClassVar;
                }
                if (StatGraph.isOLAP()) {
                    numLevels = LayoutDataLatticeParser.getNumLevels(fac, rowDimNames);
                }
                pp.maxNumRows = numRows = numLevels;
            }
            if (colVars != null) {
                cvv = new StringVariable[colVars.length];
                StringVariable columnClassVar = null;
                int numLevels = 1;
                if (StatGraph.isOLAP()) {
                    colDimNames = new ArrayList<String>();
                }
                for (int i = 0; i < colVars.length; ++i) {
                    String columnVarID = StatGraph.getVarID(colVars[i]);
                    if (StatGraph.isOLAP()) {
                        colDimNames.add(columnVarID);
                        columnClassVar = StatGraph.getOLAPLevelVar(fac, columnVarID);
                        columnClassVar.getUniqueValueCount();
                        cvv[cvv.length - 1 - i] = columnClassVar;
                        continue;
                    }
                    int columncol = model.getColumn(columnVarID);
                    cmd = (ColumnMetadata)model.getColumnLabel(columncol);
                    columnClassVar = new StringVectorVariable();
                    if (pp.multiDataModel) {
                        columnClassVar.setName(cmd.getName());
                    }
                    columnClassVar.setLabel(cmd.getLabel());
                    if (pp.includeMissing) {
                        classValues = model.getColumnAsClassColumn(columncol, true);
                        ((StringVectorVariable)columnClassVar).setBlankMissing(false);
                    } else {
                        if (!StatGraph.checkVariable("COLUMNVAR", cmd, null, 1, true)) {
                            return;
                        }
                        classValues = model.getColumnAsClassColumn(columncol, false);
                    }
                    ((StringVectorVariable)columnClassVar).connectFrom(classValues);
                    sortOrder = -1;
                    if (sortOrderMap != null && sortOrderMap.get(colVars[i]) != null) {
                        sortOrder = (Integer)sortOrderMap.get(colVars[i]);
                    }
                    cls = sortOrder == -1 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, columncol, pp) : LayoutDataLatticeParser.getIncludedClasses(incElem, columnVarID, classValues, model.getColumnClass(columncol), pp)) : (sortOrder == 3 ? (cmd.getType() == 1 ? LayoutDataLatticeParser.getOrdinalClasses(model, columncol, pp) : LayoutDataLatticeParser.getSortedClasses(model, columncol, pp, cmd.getType(), 1)) : LayoutDataLatticeParser.getSortedClasses(model, columncol, pp, cmd.getType(), sortOrder));
                    if (cls != null) {
                        pp.inLookup.put(columnClassVar, cls);
                    }
                    numLevels *= LayoutDataLatticeParser.getNumLevels(columnClassVar, pp);
                    cvv[cvv.length - 1 - i] = columnClassVar;
                }
                if (StatGraph.isOLAP()) {
                    numLevels = LayoutDataLatticeParser.getNumLevels(fac, colDimNames);
                }
                pp.maxNumCols = numCols = numLevels;
            }
            if (numRows * numCols > graph.totalCellMax) {
                Message msg3 = new Message(RB.getStringResource(RB_KEY, "totalcellmax.fmt.txt"));
                StatGraph.printWarning(msg3.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(numRows * numCols))));
                graph.setNumPages(1);
                return;
            }
            int rows = -1;
            int cols = -1;
            str = elem.getAttribute("rows");
            if (str.length() > 0) {
                if (LayoutDataLatticeParser.isMDDataLattice(rvv, cvv)) {
                    Message msg4 = new Message(RB.getStringResource(RB_KEY, "mdoption.fmt.txt"));
                    StatGraph.printNote(msg4.toString((Object)"ROWS", (Object)str));
                } else {
                    numRows = rows = Integer.parseInt(str);
                }
            }
            if ((str = elem.getAttribute("columns")).length() > 0) {
                if (LayoutDataLatticeParser.isMDDataLattice(rvv, cvv)) {
                    Message msg5 = new Message(RB.getStringResource(RB_KEY, "mdoption.fmt.txt"));
                    StatGraph.printNote(msg5.toString((Object)"COLUMNS", (Object)str));
                } else {
                    numCols = cols = Integer.parseInt(str);
                }
            }
            if ((rows > 0 || cols > 0) && (str = elem.getAttribute("panelNumber")).length() > 0) {
                page = Integer.parseInt(str) - 1;
            }
            pp.maxNumPages = maxPages = (int)(Math.ceil((double)pp.maxNumRows / (double)numRows) * Math.ceil((double)pp.maxNumCols / (double)numCols));
            if (!elem.hasAttribute("panelNumber")) {
                graph.setNumPages(maxPages);
            }
            if (page < 0) {
                msg = new Message(RB.getStringResource(RB_KEY, "page.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1)));
                return;
            }
            if (page >= maxPages) {
                msg = new Message(RB.getStringResource(RB_KEY, "page2.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)Integer.toString(page + 1), (Object)Integer.toString(maxPages)));
                page = maxPages - 1;
            }
            int askedTotalCols = (pp.maxNumCols + numCols - 1) / numCols * numCols;
            pp.startRow = numCols * page / askedTotalCols * numRows;
            pp.startCol = numCols * page % askedTotalCols;
            str = elem.getAttribute("headerLabelLocation");
            if (str.equalsIgnoreCase("inside")) {
                pp.insideHeader = true;
            } else if (str.equalsIgnoreCase("outside")) {
                pp.insideHeader = false;
            } else if (str.length() > 0) {
                pp.insideHeader = false;
                StatGraph.printOptionError("HEADERLABELLOCATION", str);
            }
            if (!pp.insideHeader) {
                str = elem.getAttribute("rowHeaders");
                if (str.equalsIgnoreCase("left")) {
                    pp.rowHeaders = 1;
                } else if (str.equalsIgnoreCase("both")) {
                    pp.rowHeaders = 0;
                } else if (str.equalsIgnoreCase("right")) {
                    pp.rowHeaders = 2;
                } else if (str.length() > 0) {
                    pp.rowHeaders = 2;
                    StatGraph.printOptionError("ROWHEADERS", str);
                }
                str = elem.getAttribute("verticalRowHeaders");
                pp.verticalRowHeaders = !str.equalsIgnoreCase("false");
                str = elem.getAttribute("columnHeaders");
                if (str.equalsIgnoreCase("bottom")) {
                    pp.columnHeaders = 4;
                } else if (str.equalsIgnoreCase("both")) {
                    pp.columnHeaders = 0;
                } else if (str.equalsIgnoreCase("top")) {
                    pp.columnHeaders = 3;
                } else if (str.length() > 0) {
                    pp.columnHeaders = 3;
                    StatGraph.printOptionError("COLUMNHEADERS", str);
                }
            }
        }
        pp.sharedAxes = StatGraph.getOptionAttrsElement(elem, "LayoutPrototype3D") == null;
        str = elem.getAttribute("start");
        if (str.equalsIgnoreCase("bottomleft")) {
            pp.startAtTop = false;
        } else if (str.equalsIgnoreCase("topleft")) {
            pp.startAtTop = true;
        } else if (str.length() > 0) {
            pp.startAtTop = true;
            StatGraph.printOptionError("START", str);
        }
        str = elem.getAttribute("rowGutter");
        int rowGap = 0;
        if (StatGraph.isLineThickness(str)) {
            rowGap = graph.unit2GapThickness(str);
        }
        str = elem.getAttribute("columnGutter");
        int colGap = 0;
        if (StatGraph.isLineThickness(str)) {
            colGap = graph.unit2GapThickness(str);
        }
        boolean rowWeight = true;
        str = elem.getAttribute("rowWeight");
        if (!str.equalsIgnoreCase("EQUAL")) {
            if (str.equalsIgnoreCase("PROPORTIONAL")) {
                rowWeight = false;
            } else if (str.length() > 0) {
                StatGraph.printOptionError("ROWWEIGHT", str);
            }
        }
        boolean columnWeight = true;
        str = elem.getAttribute("columnWeight");
        if (!str.equalsIgnoreCase("EQUAL")) {
            if (str.equalsIgnoreCase("PROPORTIONAL")) {
                columnWeight = false;
            } else if (str.length() > 0) {
                StatGraph.printOptionError("COLUMNWEIGHT", str);
            }
        }
        if ((str = elem.getAttribute("headerLabelDisplay")).equalsIgnoreCase("VALUE")) {
            pp.includeNameInHeader = false;
        } else if (str.equalsIgnoreCase("NAMEVALUE")) {
            pp.includeNameInHeader = true;
        } else if (str.equalsIgnoreCase("EXTRACT") && !pp.insideHeader) {
            pp.includeNameInHeader = false;
            pp.extractHeaderName = true;
        } else if (str.equalsIgnoreCase("NONE")) {
            pp.displayHeader = false;
        } else if (str.length() > 0) {
            pp.includeNameInHeader = true;
            StatGraph.printOptionError("HEADERLABELDISPLAY", str);
        }
        str = elem.getAttribute("headerBorder");
        if (str.equalsIgnoreCase("false")) {
            pp.headerBorder = false;
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("headerBorderAttrs"), pp.headerBorderStyle, "BorderLines");
        Element ba = StatGraph.getOptionAttrsElement(elem, "HeaderBorderAttrs");
        if (ba != null) {
            StatGraph.parseLineAttrs(graph, ba, pp.headerBorderStyle);
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("headerLabelAttrs"), pp.headerLabelStyle, "ValueText");
        Element la = StatGraph.getOptionAttrsElement(elem, "HeaderLabelAttrs");
        if (la != null) {
            StatGraph.parseTextAttrs(graph, la, pp.headerLabelStyle);
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("extractedHeaderNameAttrs"), pp.headerExtractedLabelStyle, "LabelText");
        la = StatGraph.getOptionAttrsElement(elem, "ExtractedHeaderNameAttrs");
        if (la != null) {
            StatGraph.parseTextAttrs(graph, la, pp.headerExtractedLabelStyle);
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("extractedHeaderLevelNameAttrs"), pp.headerExtractedLevelLabelStyle, "Label2Text");
        la = StatGraph.getOptionAttrsElement(elem, "ExtractedHeaderLevelNameAttrs");
        if (la != null) {
            StatGraph.parseTextAttrs(graph, la, pp.headerExtractedLevelLabelStyle);
        }
        EntryConcatParser.defaultTextStyle = pp.headerLabelStyle;
        GraphStyle.setDefaultFillStyle(graph, "", pp.wallFillStyle, "WallFill");
        GraphStyle.setDefaultFillStyle(graph, "", pp.headerFillStyle, "HeaderFill");
        Color bgColor = StatGraph.parseAttrColor("headerBackgroundColor", graph, elem);
        if (bgColor != null) {
            pp.headerFillStyle.setColor(bgColor);
        }
        if ((str = elem.getAttribute("headerOpaque")).equalsIgnoreCase("false")) {
            pp.headerFillStyle.setTransparency(1.0);
        }
        str = elem.getAttribute("cellWidthMin");
        int minCellWidth = 100;
        if (StatGraph.isLineThickness(str)) {
            minCellWidth = graph.unit2LineThickness(str);
        }
        str = elem.getAttribute("cellHeightMin");
        int minCellHeight = 100;
        if (StatGraph.isLineThickness(str)) {
            minCellHeight = graph.unit2LineThickness(str);
        }
        if (numRows == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "row.txt"));
            return;
        }
        if (numCols == 0) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "column.txt"));
            return;
        }
        boolean extruded = StatGraph.getOptionAttrsElement(elem, "LayoutPrototypeExtruded") != null;
        ExtrudedTrellisLayout tl = extruded ? new ExtrudedTrellisLayout(numRows, numCols, colGap, rowGap) : new TrellisLayout(numRows, numCols, colGap, rowGap);
        tl.setMinCellSize(new Dimension(minCellWidth, minCellHeight));
        plot.setLayout((LayoutManager)tl);
        str = elem.getAttribute("leftAxisWidthMax");
        if (StatGraph.isNumber(str) && (percent = Double.parseDouble(str)) >= 0.0) {
            plot.setRowAxisWidthPercentage(percent);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("rightAxisWidthMax")) && (percent = Double.parseDouble(str)) >= 0.0) {
            plot.setRow2AxisWidthPercentage(percent);
        }
        tl.setGridAttrs(pp.headerBorderStyle);
        if (pp.extractHeaderName) {
            str = elem.getAttribute("rowExtractedHeaderNamePosition");
            if (str.equalsIgnoreCase("top")) {
                plot.setRowHeaderLabelPosition(1);
            } else if (str.equalsIgnoreCase("bottom")) {
                plot.setRowHeaderLabelPosition(3);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("ROWEXTRACTEDHEADERNAMEPOSITION", str);
            }
            str = elem.getAttribute("columnExtractedHeaderNamePosition");
            if (str.equalsIgnoreCase("left")) {
                plot.setColumnHeaderLabelPosition(2);
            } else if (str.equalsIgnoreCase("right")) {
                plot.setColumnHeaderLabelPosition(4);
            } else if (str.length() > 0) {
                StatGraph.printOptionError("COLUMNEXTRACTEDHEADERNAMEPOSITION", str);
            }
        }
        if (pp.isDataPanel) {
            str = elem.getAttribute("headerExtend");
            if (str.equalsIgnoreCase("false")) {
                tl.setCellHeadersAligned(false);
            } else {
                tl.setCellHeadersAligned(true);
            }
        }
        str = elem.getAttribute("headerPack");
        pp.headerCollapse = str.equalsIgnoreCase("true");
        if (pp.headerCollapse) {
            str = elem.getAttribute("headerSplitCount");
            if (StatGraph.isNumber(str)) {
                int splitCnt = (int)Double.parseDouble(str);
                if (pp.isDataPanel) {
                    if (splitCnt < 1 || splitCnt > clsvv.length) {
                        StatGraph.printOptionError("HEADERSPLITCOUNT", str);
                    }
                } else if (rvv != null && cvv != null && (splitCnt < 1 || splitCnt > 2)) {
                    StatGraph.printOptionError("HEADERSPLITCOUNT", str);
                }
                pp.headerSplitCount = splitCnt;
            }
            if ((str = elem.getAttribute("headerSeparator")).length() > 0) {
                pp.headerSeparator = str;
            }
        }
        boolean[] sortBy = LayoutDataLatticeParser.isSortByPlot(elem);
        boolean colSort = sortBy[0];
        boolean rowSort = sortBy[1];
        boolean autoRowDataRange = false;
        boolean autoRow2DataRange = false;
        boolean autoColumnDataRange = false;
        boolean autoColumn2DataRange = false;
        str = elem.getAttribute("rowDataRange");
        if (str.equalsIgnoreCase("UNION")) {
            graph.yUnionAllPages = false;
        } else if (str.equalsIgnoreCase("UNIONALL")) {
            plot.setUniformYRange(true);
            graph.yUnionAllPages = true;
        } else {
            plot.setUniformYRange(true);
            graph.yUnionAllPages = true;
            boolean bl = autoRowDataRange = !rowWeight;
            if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError("ROWDATARANGE", str);
            }
        }
        str = elem.getAttribute("columnDataRange");
        if (str.equalsIgnoreCase("UNION")) {
            graph.xUnionAllPages = false;
        } else if (str.equalsIgnoreCase("UNIONALL")) {
            plot.setUniformXRange(true);
            graph.xUnionAllPages = true;
        } else {
            plot.setUniformXRange(true);
            graph.xUnionAllPages = true;
            boolean bl = autoColumnDataRange = !columnWeight;
            if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError("COLUMNDATARANGE", str);
            }
        }
        str = elem.getAttribute("row2DataRange");
        if (str.equalsIgnoreCase("UNION")) {
            graph.y2UnionAllPages = false;
        } else if (str.equalsIgnoreCase("UNIONALL")) {
            plot.setUniformY2Range(true);
            graph.y2UnionAllPages = true;
        } else {
            plot.setUniformY2Range(true);
            graph.y2UnionAllPages = true;
            boolean bl = autoRow2DataRange = !rowWeight;
            if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError("ROW2DATARANGE", str);
            }
        }
        str = elem.getAttribute("column2DataRange");
        if (str.equalsIgnoreCase("UNION")) {
            graph.x2UnionAllPages = false;
        } else if (str.equalsIgnoreCase("UNIONALL")) {
            plot.setUniformX2Range(true);
            graph.x2UnionAllPages = true;
        } else {
            plot.setUniformX2Range(true);
            graph.x2UnionAllPages = true;
            boolean bl = autoColumn2DataRange = !columnWeight;
            if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError("COLUMN2DATARANGE", str);
            }
        }
        if (rowSort) {
            graph.yUnionAllPages = false;
            plot.setUniformYRange(false);
            graph.y2UnionAllPages = false;
            plot.setUniformY2Range(false);
        }
        if (colSort) {
            graph.xUnionAllPages = false;
            plot.setUniformXRange(false);
            graph.x2UnionAllPages = false;
            plot.setUniformX2Range(false);
        }
        if ((str = elem.getAttribute("skipEmptyCells")).equalsIgnoreCase("true")) {
            pp.showEmptyCells = false;
        }
        if (!pp.showEmptyCells) {
            tl.setEmptyCellsSkipped(true);
        }
        int n = totalCells = pp.isDataPanel ? cellIndexMap.length : pp.maxNumRows * pp.maxNumCols;
        if (LayoutDataLatticeParser.getPanelCellCount(pp, numRows, numCols, page, totalCells) > graph.panelCellMax) {
            graph.setNumPages(0);
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "cellmax.txt"));
            return;
        }
        VRectAxis rowAxis = new VRectAxis(2);
        LayoutOverlayParser.initAxis(graph, rowAxis);
        rowAxis.setType(-1);
        rowAxis.setMinOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        rowAxis.setMaxOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        rowAxis.setTitlePositionedAtMax(true);
        VRectAxis columnAxis = new VRectAxis(1);
        LayoutOverlayParser.initAxis(graph, columnAxis);
        columnAxis.setType(-1);
        columnAxis.setMinOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        columnAxis.setMaxOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        columnAxis.setTitlePositionedAtMax(true);
        VRectAxis row2Axis = new VRectAxis(2);
        LayoutOverlayParser.initAxis(graph, row2Axis);
        row2Axis.setType(-1);
        row2Axis.setMinOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        row2Axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        row2Axis.setTitlePositionedAtMax(true);
        VRectAxis column2Axis = new VRectAxis(1);
        LayoutOverlayParser.initAxis(graph, column2Axis);
        column2Axis.setType(-1);
        column2Axis.setMinOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        column2Axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        column2Axis.setTitlePositionedAtMax(true);
        graph.whereDataModelName = pp.multiDataModel ? null : dataName;
        graph.whereVarsOnSeparateModel = pp.multiDataModel;
        graph.whereIncludeMissingClass = pp.includeMissing;
        pp.iArgs = InsetArgs.parseInsetVarsAndOpts(graph, elem);
        pp.sArgs = StripArgs.parse(graph, elem, pp);
        if (autoColumnDataRange || autoColumn2DataRange || autoRowDataRange || autoRow2DataRange) {
            LayoutDataLatticeParser.decideAutoUnionTypes(graph, elem, plot, autoColumnDataRange, autoColumn2DataRange, autoRowDataRange, autoRow2DataRange);
        }
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String dispStr;
            if (!(node instanceof Element)) continue;
            Element nodeElem = (Element)node;
            String elemTag = nodeElem.getTagName();
            if (elemTag.equals("SideBar")) {
                LayoutLatticeParser.loadSideBar(graph, nodeElem, plot);
                continue;
            }
            if (elemTag.startsWith("Draw")) {
                SGAnnotationContainer ac = new SGAnnotationContainer((Container)plot, graph.rootPanel);
                AbstractAnno text = AnnotateParser.load(graph, nodeElem, (AnnotationContainer)ac);
                if (text == null) continue;
                if ("back".equalsIgnoreCase(nodeElem.getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                    continue;
                }
                graph.annotationInFrontList.add(text);
                continue;
            }
            if (elemTag.equals("RowAxisOpts")) {
                if (pp.degenerated && !StatGraph.isOLAP()) {
                    LayoutDataLatticeParser.cloneAxisOptsElement(elem, nodeElem, "YAxisOpts");
                    continue;
                }
                LayoutOverlayParser.parseAxisCompOpts(graph, null, nodeElem, rowAxis);
                if (!nodeElem.hasAttribute("type") || nodeElem.getAttribute("type").equalsIgnoreCase("auto")) {
                    rowAxis.setType(-1);
                }
                dispStr = nodeElem.getAttribute("display");
                str = nodeElem.getAttribute("displaySecondary");
                if (str.length() > 0) {
                    pp.rowAxisDisplay2 = str;
                }
                if ((str = nodeElem.getAttribute("altDisplay")).length() > 0) {
                    pp.rowAxisAltDisplay = str;
                } else if (dispStr.length() > 0) {
                    pp.rowAxisAltDisplay = dispStr;
                }
                str = nodeElem.getAttribute("altDisplaySecondary");
                pp.rowAxisAltDisplay2 = str.length() > 0 ? str : pp.rowAxisDisplay2;
                if (!Double.isNaN(rowAxis.getViewportMin()) && !Double.isNaN(rowAxis.getViewportMax())) {
                    graph.yUnionAllPages = false;
                }
                if (rowAxis.getLabelPosition() == 0) {
                    plot.setRowAxisLabelPosition(3);
                }
                if (rowAxis.getLabelPosition() != 2) continue;
                plot.setRowAxisLabelPosition(1);
                continue;
            }
            if (elemTag.equals("ColumnAxisOpts")) {
                if (pp.degenerated && !StatGraph.isOLAP()) {
                    LayoutDataLatticeParser.cloneAxisOptsElement(elem, nodeElem, "XAxisOpts");
                    continue;
                }
                LayoutOverlayParser.parseAxisCompOpts(graph, null, (Element)node, columnAxis);
                if (!nodeElem.hasAttribute("type") || nodeElem.getAttribute("type").equalsIgnoreCase("auto")) {
                    columnAxis.setType(-1);
                }
                dispStr = nodeElem.getAttribute("display");
                str = nodeElem.getAttribute("displaySecondary");
                if (str.length() > 0) {
                    pp.colAxisDisplay2 = str;
                }
                if ((str = nodeElem.getAttribute("altDisplay")).length() > 0) {
                    pp.colAxisAltDisplay = str;
                } else if (dispStr.length() > 0) {
                    pp.colAxisAltDisplay = dispStr;
                }
                str = nodeElem.getAttribute("altDisplaySecondary");
                pp.colAxisAltDisplay2 = str.length() > 0 ? str : pp.colAxisDisplay2;
                if (!Double.isNaN(columnAxis.getViewportMin()) && !Double.isNaN(columnAxis.getViewportMax())) {
                    graph.xUnionAllPages = false;
                }
                if (columnAxis.getLabelPosition() == 0) {
                    plot.setColumnAxisLabelPosition(2);
                }
                if (columnAxis.getLabelPosition() != 2) continue;
                plot.setColumnAxisLabelPosition(4);
                continue;
            }
            if (elemTag.equals("Row2AxisOpts")) {
                if (pp.degenerated && !StatGraph.isOLAP()) {
                    LayoutDataLatticeParser.cloneAxisOptsElement(elem, nodeElem, "Y2AxisOpts");
                    continue;
                }
                LayoutOverlayParser.parseAxisCompOpts(graph, null, nodeElem, row2Axis);
                if (!nodeElem.hasAttribute("type") || nodeElem.getAttribute("type").equalsIgnoreCase("auto")) {
                    row2Axis.setType(-1);
                }
                dispStr = nodeElem.getAttribute("display");
                str = nodeElem.getAttribute("displaySecondary");
                if (str.length() > 0) {
                    pp.row2AxisDisplay2 = str;
                }
                if ((str = nodeElem.getAttribute("altDisplay")).length() > 0) {
                    pp.row2AxisAltDisplay = str;
                } else if (dispStr.length() > 0) {
                    pp.row2AxisAltDisplay = dispStr;
                }
                str = nodeElem.getAttribute("altDisplaySecondary");
                pp.row2AxisAltDisplay2 = str.length() > 0 ? str : pp.row2AxisDisplay2;
                if (!Double.isNaN(row2Axis.getViewportMin()) && !Double.isNaN(row2Axis.getViewportMax())) {
                    graph.yUnionAllPages = false;
                }
                if (row2Axis.getLabelPosition() == 0) {
                    plot.setRow2AxisLabelPosition(3);
                }
                if (row2Axis.getLabelPosition() != 2) continue;
                plot.setRow2AxisLabelPosition(1);
                continue;
            }
            if (elemTag.equals("Column2AxisOpts")) {
                if (pp.degenerated && !StatGraph.isOLAP()) {
                    LayoutDataLatticeParser.cloneAxisOptsElement(elem, nodeElem, "X2AxisOpts");
                    continue;
                }
                LayoutOverlayParser.parseAxisCompOpts(graph, null, (Element)node, column2Axis);
                if (!nodeElem.hasAttribute("type") || nodeElem.getAttribute("type").equalsIgnoreCase("auto")) {
                    column2Axis.setType(-1);
                }
                dispStr = nodeElem.getAttribute("display");
                str = nodeElem.getAttribute("displaySecondary");
                if (str.length() > 0) {
                    pp.col2AxisDisplay2 = str;
                }
                if ((str = nodeElem.getAttribute("altDisplay")).length() > 0) {
                    pp.col2AxisAltDisplay = str;
                } else if (dispStr.length() > 0) {
                    pp.col2AxisAltDisplay = dispStr;
                }
                str = nodeElem.getAttribute("altDisplaySecondary");
                pp.col2AxisAltDisplay2 = str.length() > 0 ? str : pp.col2AxisDisplay2;
                if (!Double.isNaN(column2Axis.getViewportMin()) && !Double.isNaN(column2Axis.getViewportMax())) {
                    graph.xUnionAllPages = false;
                }
                if (column2Axis.getLabelPosition() == 0) {
                    plot.setColumn2AxisLabelPosition(2);
                }
                if (column2Axis.getLabelPosition() != 2) continue;
                plot.setColumn2AxisLabelPosition(4);
                continue;
            }
            if (!LayoutDataLatticeParser.isValidStamp(elemTag, pp.isDataPanel)) continue;
            if (pp.degenerated) {
                BaseOverlayContainer oc = (BaseOverlayContainer)LayoutOverlayParser.load(graph, nodeElem);
                plot.addCellItem(0, 0, (Component)oc);
                if (StatGraph.isOLAP()) {
                    DataTreeGroupNode tree;
                    Entry e;
                    String lab;
                    DataModel m = (DataModel)graph.olapData.get(0);
                    OLAPVariableFactory fac = m.getOLAPVarFactory();
                    plot.createRowOLAPHeader();
                    plot.createColumnOLAPHeader();
                    ArrayList<String> list = new ArrayList<String>();
                    if (m.yCategoryVar != null) {
                        list.add(m.yCategoryVar);
                        rowAxis.getAxisStyle().setMajorTickMarksOn(false);
                        rowAxis.getAxisStyle().setLabelsOn(false);
                        rowAxis.getAxisStyle().setTitleOn(false);
                        pp.rowAxisAltDisplay = "none";
                        lab = fac.getHierachyLabel(m.yCategoryVar);
                        e = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + lab.trim() + " ", 90.0);
                        plot.addRowOLAPHeaderTitle((Component)e, true);
                        tree = fac.createSubTree(list);
                        double theta = pp.verticalRowHeaders ? 90.0 : 0.0;
                        LayoutDataLatticeParser.createSimpleEntries(graph, plot, pp, tree, theta, plot.getRowOLAPHeaderLevels(true), rowAxis);
                        plot.setRowOLAPHeaderTree(tree, true);
                        plot.setRowOLAPHeaderBackground(pp.headerFillStyle.getColor());
                    } else if (m.xCategoryVar != null) {
                        list.add(m.xCategoryVar);
                        columnAxis.getAxisStyle().setMajorTickMarksOn(false);
                        columnAxis.getAxisStyle().setLabelsOn(false);
                        columnAxis.getAxisStyle().setTitleOn(false);
                        pp.colAxisAltDisplay = "none";
                        lab = fac.getHierachyLabel(m.xCategoryVar);
                        e = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + lab.trim() + " ", 0.0);
                        plot.addColumnOLAPHeaderTitle((Component)e, true);
                        tree = fac.createSubTree(list);
                        WaterfallChartOverlay.addFinalCategoryToTree(tree, null, oc);
                        LayoutDataLatticeParser.createSimpleEntries(graph, plot, pp, tree, 0.0, plot.getColumnOLAPHeaderLevels(true), columnAxis);
                        plot.setColumnOLAPHeaderTree(tree, true);
                        plot.setColumnOLAPHeaderBackground(pp.headerFillStyle.getColor());
                    }
                    LayoutDataLatticeParser.setupGridAxes(graph, pp, plot, 1, 1);
                    String[] xAxisLabel = LayoutDataLatticeParser.getAxisLabel(oc, (byte)1, true);
                    String[] yAxisLabel = LayoutDataLatticeParser.getAxisLabel(oc, (byte)2, true, rowAxis.isDisplayStackedLabels());
                    String[] xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(oc, (byte)1, false);
                    String[] yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(oc, (byte)2, false, row2Axis.isDisplayStackedLabels());
                    LayoutDataLatticeParser.setupAxisLabelSideBars(graph, plot, pp, rowAxis, columnAxis, row2Axis, column2Axis, numRows, numCols, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
                    continue;
                }
                oc.getComposite().getWall().setEdgeOn(true);
                oc.getComposite().getWall().setEdgeStyle(pp.headerBorderStyle);
                continue;
            }
            str = nodeElem.getAttribute("aspectRatio");
            if (StatGraph.isNumber(str)) {
                tl.setCellAspectRatio(Double.parseDouble(str));
            } else {
                tl.setCellAspectRatio(-1.0);
            }
            int[] types = LayoutDataLatticeParser.getUserDefinedAxisTypes(elem, true);
            int[] types2 = LayoutDataLatticeParser.getUserDefinedAxisTypes(elem, false);
            if (pp.isDataPanel) {
                LayoutDataLatticeParser.repeatCellStamps(graph, nodeElem, pp, clsvv, rowAxis, columnAxis, row2Axis, column2Axis, plot, page, types, types2, cellIndexMap, model);
                continue;
            }
            if (StatGraph.isOLAP()) {
                LayoutDataLatticeParser.repeatOLAPRowColumnStamps(graph, nodeElem, pp, rvv, cvv, rowAxis, columnAxis, row2Axis, column2Axis, plot, types, types2, model);
                continue;
            }
            if (rvv != null && rvv.length > 1) {
                plot.createRowCompoundHeader();
            }
            if (cvv != null && cvv.length > 1) {
                plot.createColumnCompoundHeader();
            }
            if (plot.isCompoundHeaders()) {
                LayoutDataLatticeParser.repeatRowColumnStamps(graph, nodeElem, pp, rvv, cvv, rowAxis, columnAxis, row2Axis, column2Axis, plot, types, types2, model);
                continue;
            }
            StringVariable rv = rvv == null ? null : rvv[0];
            StringVariable cv = cvv == null ? null : cvv[0];
            LayoutDataLatticeParser.repeatRowColumnStamps(graph, nodeElem, pp, rv, cv, rowAxis, columnAxis, row2Axis, column2Axis, plot, types, types2, model);
        }
        if (graph.isNamedAxis(columnAxis)) {
            if (graph.xUnionAllPages) {
                axes = LayoutDataLatticeParser.getColumnAxes(plot, true);
                graph.replaceNamedAxis(graph.getAxisName(columnAxis), axes);
            } else {
                graph.removeNamedAxis(columnAxis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "colaxislegend.txt"));
            }
        }
        if (graph.isNamedAxis(column2Axis)) {
            if (graph.x2UnionAllPages) {
                axes = LayoutDataLatticeParser.getColumnAxes(plot, false);
                graph.replaceNamedAxis(graph.getAxisName(column2Axis), axes);
            } else {
                graph.removeNamedAxis(column2Axis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "col2axislegend.txt"));
            }
        }
        if (graph.isNamedAxis(rowAxis)) {
            if (graph.yUnionAllPages) {
                axes = LayoutDataLatticeParser.getRowAxes(plot, true);
                graph.replaceNamedAxis(graph.getAxisName(rowAxis), axes);
            } else {
                graph.removeNamedAxis(rowAxis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "rowaxislegend.txt"));
            }
        }
        if (graph.isNamedAxis(row2Axis)) {
            if (graph.y2UnionAllPages) {
                axes = LayoutDataLatticeParser.getRowAxes(plot, false);
                graph.replaceNamedAxis(graph.getAxisName(row2Axis), axes);
            } else {
                graph.removeNamedAxis(row2Axis);
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "row2axislegend.txt"));
            }
        }
        boolean columnUnion = !graph.xUnionAllPages;
        boolean column2Union = !graph.x2UnionAllPages;
        boolean rowUnion = !graph.yUnionAllPages;
        boolean row2Union = !graph.y2UnionAllPages;
        graph.whereVarsOnSeparateModel = false;
        graph.whereIncludeMissingClass = true;
        graph.whereDataModelName = null;
        graph.xUnionAllPages = false;
        graph.x2UnionAllPages = false;
        graph.yUnionAllPages = false;
        graph.y2UnionAllPages = false;
        LayoutDataLatticeParser.updateAxisOpts(plot, graph, elem, rowAxis, columnAxis, row2Axis, column2Axis);
        LayoutDataLatticeParser.applyAxisOptions(plot, rowAxis, columnAxis, row2Axis, column2Axis, pp);
        LayoutLatticeParser.decideRowColumnAxisTypes(plot);
        if (!rowSort && !colSort) {
            LayoutLatticeParser.setupInternalAxes(plot, true, true, true, true, false);
            LayoutLatticeParser.turnOffEquateOption(plot);
            if (plot.isUniformXRange() || plot.isUniformYRange() || plot.isUniformX2Range() || plot.isUniformY2Range()) {
                LayoutLatticeParser.unifyViewport(plot);
            }
            plot.installColumnRangeListeners(true, true, true);
            plot.installRowRangeListeners(true, true, true);
            if (!columnWeight && (columnUnion || column2Union)) {
                LayoutDataLatticeParser.weightingByCategories(plot, true, false);
            }
            if (!rowWeight && (rowUnion || row2Union)) {
                LayoutDataLatticeParser.weightingByCategories(plot, false, false);
            }
        } else {
            LayoutLatticeParser.setupInternalAxes(plot, !colSort, !rowSort, !colSort, !rowSort, false, true);
            if (colSort) {
                tl.setRowHeadersAligned(false);
                if (!columnWeight) {
                    LayoutDataLatticeParser.weightingByCategories(plot, true, true);
                }
            } else {
                tl.setColumnHeadersAligned(false);
                if (!rowWeight) {
                    LayoutDataLatticeParser.weightingByCategories(plot, false, true);
                }
            }
            if (plot.isUniformXRange() || plot.isUniformYRange() || plot.isUniformX2Range() || plot.isUniformY2Range()) {
                LayoutLatticeParser.unifyViewport(plot);
            }
            if (colSort) {
                plot.installRowRangeListeners(true, true, true);
            } else {
                plot.installColumnRangeListeners(true, true, true);
            }
        }
        plot.installMarginListeners();
        plot.enableLayout();
        if (!graph.server) {
            LayoutLatticeParser.registerViewportListener(plot, true, true);
        }
    }

    private static void updateAxisOpts(TrellisPlot plot, StatGraph graph, Element elem, VRectAxis rowAxis, VRectAxis columnAxis, VRectAxis row2Axis, VRectAxis column2Axis) {
        int cols;
        int i;
        boolean logToLinear;
        int type;
        int rows;
        GridAxis ga;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        if (rowAxis.getType() < 0) {
            ga = (GridAxis)plot.getRowAxis(0, true);
            if (ga != null) {
                if (ga.isMirror()) {
                    rowAxis.setType(LayoutLatticeParser.getAxisType(plot, 0, 2, false));
                } else {
                    rowAxis.setType(LayoutLatticeParser.getAxisType(plot, 0, 2, true));
                }
            }
        } else if (rowAxis.getType() == 1) {
            rows = tl.getGridRows();
            type = 1;
            logToLinear = false;
            for (i = 0; i < rows; ++i) {
                ga = (GridAxis)plot.getRowAxis(i, true);
                if (ga == null || !(logToLinear = ga.isMirror() ? LayoutLatticeParser.isLogToLinearAxis(plot, i, 2, false) : LayoutLatticeParser.isLogToLinearAxis(plot, i, 2, true))) continue;
                type = 0;
                break;
            }
            rowAxis.setType(type);
        }
        if (row2Axis.getType() < 0) {
            ga = (GridAxis)plot.getRowAxis(0, false);
            if (ga != null) {
                if (ga.isMirror()) {
                    row2Axis.setType(LayoutLatticeParser.getAxisType(plot, 0, 2, true));
                } else {
                    row2Axis.setType(LayoutLatticeParser.getAxisType(plot, 0, 2, false));
                }
            }
        } else if (row2Axis.getType() == 1) {
            rows = tl.getGridRows();
            type = 1;
            logToLinear = false;
            for (i = 0; i < rows; ++i) {
                ga = (GridAxis)plot.getRowAxis(i, false);
                if (ga == null || !(logToLinear = ga.isMirror() ? LayoutLatticeParser.isLogToLinearAxis(plot, i, 2, true) : LayoutLatticeParser.isLogToLinearAxis(plot, i, 2, false))) continue;
                type = 0;
                break;
            }
            row2Axis.setType(type);
        }
        if (columnAxis.getType() < 0) {
            ga = (GridAxis)plot.getColumnAxis(0, true);
            if (ga != null) {
                if (ga.isMirror()) {
                    columnAxis.setType(LayoutLatticeParser.getAxisType(plot, 0, 1, false));
                } else {
                    columnAxis.setType(LayoutLatticeParser.getAxisType(plot, 0, 1, true));
                }
            }
        } else if (columnAxis.getType() == 1) {
            cols = tl.getGridColumns();
            type = 1;
            logToLinear = false;
            for (i = 0; i < cols; ++i) {
                ga = (GridAxis)plot.getColumnAxis(i, true);
                if (ga == null || !(logToLinear = ga.isMirror() ? LayoutLatticeParser.isLogToLinearAxis(plot, i, 1, false) : LayoutLatticeParser.isLogToLinearAxis(plot, i, 1, true))) continue;
                type = 0;
                break;
            }
            columnAxis.setType(type);
        }
        if (column2Axis.getType() < 0) {
            ga = (GridAxis)plot.getColumnAxis(0, false);
            if (ga != null) {
                if (ga.isMirror()) {
                    column2Axis.setType(LayoutLatticeParser.getAxisType(plot, 0, 1, true));
                } else {
                    column2Axis.setType(LayoutLatticeParser.getAxisType(plot, 0, 1, false));
                }
            }
        } else if (column2Axis.getType() == 1) {
            cols = tl.getGridColumns();
            type = 1;
            logToLinear = false;
            for (i = 0; i < cols; ++i) {
                ga = (GridAxis)plot.getColumnAxis(i, false);
                if (ga == null || !(logToLinear = ga.isMirror() ? LayoutLatticeParser.isLogToLinearAxis(plot, i, 1, true) : LayoutLatticeParser.isLogToLinearAxis(plot, i, 1, false))) continue;
                type = 0;
                break;
            }
            column2Axis.setType(type);
        }
        VRectAxis masterAxis = new VRectAxis(1);
        LayoutOverlayParser.resetAxisOpts(columnAxis, masterAxis);
        masterAxis.setRectAxisParams(new RectAxisParams());
        LayoutOverlayParser.resetAxisOpts(column2Axis, masterAxis);
        masterAxis = new VRectAxis(2);
        LayoutOverlayParser.resetAxisOpts(rowAxis, masterAxis);
        masterAxis.setRectAxisParams(new RectAxisParams());
        LayoutOverlayParser.resetAxisOpts(row2Axis, masterAxis);
        block4: for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node node2;
            if (!(node instanceof Element)) continue;
            Element nodeElem = (Element)node;
            String elemTag = nodeElem.getTagName();
            if (elemTag.equals("RowAxisOpts")) {
                for (node2 = nodeElem.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element)) continue;
                    elemTag = ((Element)node2).getTagName();
                    if (rowAxis.getType() == 0 && elemTag.equals("LinearOpts")) {
                        LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node2, rowAxis, null);
                        continue block4;
                    }
                    if (rowAxis.getType() == 6 && elemTag.equals("DiscreteOpts")) {
                        LayoutOverlayParser.parseDiscreteAxisOpts(graph, (Element)node2, rowAxis);
                        continue block4;
                    }
                    if (rowAxis.getType() == 1 && elemTag.equals("LogOpts")) {
                        LayoutOverlayParser.parseLogarithmicAxisOpts(graph, (Element)node2, rowAxis);
                        continue block4;
                    }
                    if (rowAxis.getType() != 5 || !elemTag.equals("TimeOpts")) continue;
                    LayoutOverlayParser.parseTimeAxisOpts(graph, (Element)node2, rowAxis, null);
                    continue block4;
                }
                continue;
            }
            if (elemTag.equals("Row2AxisOpts")) {
                for (node2 = nodeElem.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element)) continue;
                    elemTag = ((Element)node2).getTagName();
                    if (row2Axis.getType() == 0 && elemTag.equals("LinearOpts")) {
                        LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node2, row2Axis, null);
                        continue block4;
                    }
                    if (row2Axis.getType() == 6 && elemTag.equals("DiscreteOpts")) {
                        LayoutOverlayParser.parseDiscreteAxisOpts(graph, (Element)node2, row2Axis);
                        continue block4;
                    }
                    if (row2Axis.getType() == 1 && elemTag.equals("LogOpts")) {
                        LayoutOverlayParser.parseLogarithmicAxisOpts(graph, (Element)node2, row2Axis);
                        continue block4;
                    }
                    if (row2Axis.getType() != 5 || !elemTag.equals("TimeOpts")) continue;
                    LayoutOverlayParser.parseTimeAxisOpts(graph, (Element)node2, row2Axis, null);
                    continue block4;
                }
                continue;
            }
            if (elemTag.equals("ColumnAxisOpts")) {
                for (node2 = nodeElem.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element)) continue;
                    elemTag = ((Element)node2).getTagName();
                    if (columnAxis.getType() == 0 && elemTag.equals("LinearOpts")) {
                        LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node2, columnAxis, null);
                        continue block4;
                    }
                    if (columnAxis.getType() == 6 && elemTag.equals("DiscreteOpts")) {
                        LayoutOverlayParser.parseDiscreteAxisOpts(graph, (Element)node2, columnAxis);
                        continue block4;
                    }
                    if (columnAxis.getType() == 1 && elemTag.equals("LogOpts")) {
                        LayoutOverlayParser.parseLogarithmicAxisOpts(graph, (Element)node2, columnAxis);
                        continue block4;
                    }
                    if (columnAxis.getType() != 5 || !elemTag.equals("TimeOpts")) continue;
                    LayoutOverlayParser.parseTimeAxisOpts(graph, (Element)node2, columnAxis, null);
                    continue block4;
                }
                continue;
            }
            if (!elemTag.equals("Column2AxisOpts")) continue;
            for (node2 = nodeElem.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof Element)) continue;
                elemTag = ((Element)node2).getTagName();
                if (column2Axis.getType() == 0 && elemTag.equals("LinearOpts")) {
                    LayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node2, column2Axis, null);
                    continue block4;
                }
                if (column2Axis.getType() == 6 && elemTag.equals("DiscreteOpts")) {
                    LayoutOverlayParser.parseDiscreteAxisOpts(graph, (Element)node2, column2Axis);
                    continue block4;
                }
                if (column2Axis.getType() == 1 && elemTag.equals("LogOpts")) {
                    LayoutOverlayParser.parseLogarithmicAxisOpts(graph, (Element)node2, column2Axis);
                    continue block4;
                }
                if (column2Axis.getType() != 5 || !elemTag.equals("TimeOpts")) continue;
                LayoutOverlayParser.parseTimeAxisOpts(graph, (Element)node2, column2Axis, null);
                continue block4;
            }
        }
    }

    public static HashMap parseSortOrder(StatGraph graph, Element elem, String[] classVars, HashMap roleMap) {
        Element sortElem;
        if (classVars.length == 0) {
            return null;
        }
        Element roleElem = StatGraph.getOptionAttrsElement(elem, "Roles");
        if (roleElem != null) {
            roleMap = new HashMap<String, String>();
            String elemTag = "";
            block0: for (Node node = roleElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Role")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String name = child.getNodeValue();
                for (int i = 0; i < classVars.length; ++i) {
                    if (!name.equalsIgnoreCase(classVars[i])) continue;
                    roleMap.put(role.toUpperCase(), name);
                    continue block0;
                }
            }
        }
        if (roleMap == null) {
            return null;
        }
        HashMap<String, Integer> sortMap = null;
        if (graph.isCASData()) {
            sortMap = new HashMap<String, Integer>();
            for (int i = 0; i < classVars.length; ++i) {
                sortMap.put(classVars[i], new Integer(3));
            }
        }
        if ((sortElem = StatGraph.getOptionAttrsElement(elem, "SortOrders")) != null) {
            if (sortMap == null) {
                sortMap = new HashMap();
            }
            String elemTag = "";
            for (Node node = sortElem.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element thisElem;
                if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("SortOrder")) continue;
                String role = thisElem.getAttribute("name");
                Node child = thisElem.getFirstChild();
                if (child == null) continue;
                String sort = child.getNodeValue();
                Object var = roleMap.get(role.toUpperCase());
                if (var == null) continue;
                if (sort.equalsIgnoreCase("DATA")) {
                    sortMap.put((String)var, new Integer(0));
                    continue;
                }
                if (sort.equalsIgnoreCase("ASCENDINGFORMATTED")) {
                    sortMap.put((String)var, new Integer(1));
                    continue;
                }
                if (!sort.equalsIgnoreCase("DESCENDINGFORMATTED")) continue;
                sortMap.put((String)var, new Integer(2));
            }
        }
        return sortMap;
    }

    private static boolean isMDDataLattice(StringVariable[] rvv, StringVariable[] cvv) {
        if (rvv != null && rvv.length > 1) {
            return true;
        }
        return cvv != null && cvv.length > 1;
    }

    public static ArrayList getColumnAxes(TrellisPlot trellis, boolean primary) {
        ArrayList<VRectAxis> axes = new ArrayList<VRectAxis>();
        TrellisLayout layout = (TrellisLayout)trellis.getLayout();
        for (int i = 0; i < layout.getGridColumns(); ++i) {
            VRectAxis a = ((BaseGridAxis)trellis.getColumnAxis(i, primary)).getAxis();
            axes.add(a);
        }
        return axes;
    }

    public static ArrayList getRowAxes(TrellisPlot trellis, boolean primary) {
        ArrayList<VRectAxis> axes = new ArrayList<VRectAxis>();
        TrellisLayout layout = (TrellisLayout)trellis.getLayout();
        for (int i = 0; i < layout.getGridRows(); ++i) {
            VRectAxis a = ((BaseGridAxis)trellis.getRowAxis(i, primary)).getAxis();
            axes.add(a);
        }
        return axes;
    }

    public static int getNumLevels(StringVariable classVar, DataLatticeProperties pp) {
        if (pp.inLookup.containsKey(classVar)) {
            String[] cls = (String[])pp.inLookup.get(classVar);
            return cls.length;
        }
        int numLevels = classVar.getUniqueValueCount();
        if (EXCLUDED_CLASS_VALUE != null || !pp.includeMissing) {
            for (int j = 0; j < classVar.getUniqueValueCount(); ++j) {
                try {
                    String val = classVar.uniqueValue.getValue(j);
                    if (EXCLUDED_CLASS_VALUE == null || val == null || !val.equals(EXCLUDED_CLASS_VALUE)) continue;
                    --numLevels;
                    continue;
                }
                catch (MissingValueException mve) {
                    if (pp.includeMissing) continue;
                    --numLevels;
                }
            }
        }
        return numLevels;
    }

    public static int getNumLevels(OLAPVariableFactory fac, List dimensions) {
        DataTreeGroupNode tn = fac.createSubTree(dimensions);
        DefaultMutableTreeNode[] leafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)tn);
        return leafs.length;
    }

    public static int getPanelCellCount(DataLatticeProperties pp, int panelRows, int panelCols, int page, int totalCells) {
        return panelRows * panelCols;
    }

    public static void repeatRowColumnStamps(StatGraph graph, Element elem, DataLatticeProperties pp, StringVariable rcv, StringVariable ccv, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis, TrellisPlot plot, int[] axisType, int[] axis2Type, DataModel model) {
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int rows = tl.getGridRows();
        int cols = tl.getGridColumns();
        if (pp.displayHeader && !pp.insideHeader) {
            if (pp.extractHeaderName) {
                if (rcv != null) {
                    String labelText = pp.verticalRowHeaders ? " " + rcv.getLabel() + " " : rcv.getLabel();
                    double angle = pp.verticalRowHeaders ? 90.0 : 0.0;
                    switch (pp.rowHeaders) {
                        case 1: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, angle);
                            plot.addRowHeaderLabel((Component)label);
                            break;
                        }
                        case 2: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, angle);
                            plot.addRow2HeaderLabel((Component)label);
                            break;
                        }
                        case 0: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, angle);
                            plot.addRowHeaderLabel((Component)label);
                            label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, angle);
                            plot.addRow2HeaderLabel((Component)label);
                        }
                    }
                }
                if (ccv != null) {
                    String labelText = " " + ccv.getLabel() + " ";
                    switch (pp.columnHeaders) {
                        case 3: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addColumnHeaderLabel((Component)label);
                            break;
                        }
                        case 4: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addColumn2HeaderLabel((Component)label);
                            break;
                        }
                        case 0: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addColumnHeaderLabel((Component)label);
                            label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addColumn2HeaderLabel((Component)label);
                        }
                    }
                }
            }
            for (int row = 0; row < rows && rcv != null; ++row) {
                Entry entry;
                double angle;
                boolean isEmptyRow;
                boolean bl = isEmptyRow = row + pp.startRow >= pp.maxNumRows;
                if (!pp.showEmptyCells && isEmptyRow) continue;
                int theRow = pp.startAtTop ? row : rows - 1 - row;
                String header = isEmptyRow ? " " : LayoutDataLatticeParser.buildHeaderLabel(rcv, row + pp.startRow, pp);
                String headerText = pp.verticalRowHeaders ? header : " " + header + " ";
                double d = angle = pp.verticalRowHeaders ? 90.0 : 0.0;
                if (pp.rowHeaders == 1 || pp.rowHeaders == 0) {
                    entry = LayoutDataLatticeParser.createSimpleEntry(graph, pp, headerText, angle);
                    plot.addRowHeader(theRow, (Component)entry);
                }
                if (pp.rowHeaders != 0 && pp.rowHeaders != 2) continue;
                entry = LayoutDataLatticeParser.createSimpleEntry(graph, pp, headerText, angle);
                plot.addRowHeader2(theRow, (Component)entry);
            }
            for (int col = 0; col < cols && ccv != null; ++col) {
                JComponent entry;
                String header;
                boolean isEmptyCol;
                boolean bl = isEmptyCol = col + pp.startCol >= pp.maxNumCols;
                if (!pp.showEmptyCells && isEmptyCol) continue;
                String string = header = isEmptyCol ? " " : LayoutDataLatticeParser.buildHeaderLabel(ccv, col + pp.startCol, pp);
                if (pp.columnHeaders == 3 || pp.columnHeaders == 0) {
                    entry = LayoutDataLatticeParser.createEntry(graph, header, pp);
                    plot.addColumnHeader(col, (Component)entry);
                }
                if (pp.columnHeaders != 0 && pp.columnHeaders != 4) continue;
                entry = LayoutDataLatticeParser.createEntry(graph, header, pp);
                plot.addColumnHeader2(col, (Component)entry);
            }
        }
        LayoutDataLatticeParser.setupGridAxes(graph, pp, plot, rows, cols);
        JComponent comp = null;
        graph.whereVars = new StringVariable[]{rcv, ccv};
        int askedTotalCols = (pp.maxNumCols + cols - 1) / cols * cols;
        graph.allWhereExpressions = new String[pp.maxNumPages * rows * cols];
        for (int pg = 0; pg < pp.maxNumPages; ++pg) {
            int startRow = cols * pg / askedTotalCols * rows;
            int startCol = cols * pg % askedTotalCols;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    boolean isEmptyCell;
                    boolean bl = isEmptyCell = row + startRow >= pp.maxNumRows || col + startCol >= pp.maxNumCols;
                    if (isEmptyCell) continue;
                    int idx = rows * cols * pg;
                    graph.allWhereExpressions[idx += pp.rowMajor ? row * cols + col : col * rows + row] = LayoutDataLatticeParser.buildWhereExpression(rcv, ccv, row + startRow, col + startCol, pp);
                }
            }
        }
        if (!pp.multiDataModel) {
            model.minMaxComputed = false;
        } else {
            StringVariable[] classVars = new StringVariable[]{rcv, ccv};
            LayoutDataLatticeParser.setMinMaxComputed(graph, classVars, false);
        }
        model.maxNumJitteredPoints = -1;
        String[] xAxisLabel = null;
        String[] yAxisLabel = null;
        String[] xAxisLabel2 = null;
        String[] yAxisLabel2 = null;
        for (int row = 0; row < rows; ++row) {
            int theRow = pp.startAtTop ? row : rows - 1 - row;
            for (int col = 0; col < cols; ++col) {
                boolean isEmptyCell;
                boolean bl = isEmptyCell = row + pp.startRow >= pp.maxNumRows || col + pp.startCol >= pp.maxNumCols;
                if (pp.displayHeader && pp.insideHeader) {
                    int colHeaderIdx;
                    int n = colHeaderIdx = rcv != null && ccv != null ? 1 : 0;
                    if (!pp.showEmptyCells && isEmptyCell) continue;
                    if (pp.headerCollapse) {
                        String[] headers = rcv != null && ccv != null ? new String[2] : new String[1];
                        if (rcv != null) {
                            String string = headers[0] = isEmptyCell ? " " : LayoutDataLatticeParser.buildHeaderLabel(rcv, row + pp.startRow, pp);
                        }
                        if (ccv != null) {
                            String s;
                            String string = s = isEmptyCell ? " " : LayoutDataLatticeParser.buildHeaderLabel(ccv, col + pp.startCol, pp);
                            if (headers.length == 2) {
                                headers[1] = s;
                            } else {
                                headers[0] = s;
                            }
                        }
                        plot.addCellHeader(theRow, col, 0, LayoutDataLatticeParser.buildCollapsedHeader(graph, headers, pp));
                    } else {
                        JComponent entry;
                        String header;
                        if (rcv != null) {
                            header = isEmptyCell ? " " : LayoutDataLatticeParser.buildHeaderLabel(rcv, row + pp.startRow, pp);
                            entry = LayoutDataLatticeParser.createEntry(graph, header, pp);
                            plot.addCellHeader(theRow, col, 0, entry);
                        }
                        if (ccv != null) {
                            header = isEmptyCell ? " " : LayoutDataLatticeParser.buildHeaderLabel(ccv, col + pp.startCol, pp);
                            entry = LayoutDataLatticeParser.createEntry(graph, header, pp);
                            plot.addCellHeader(theRow, col, colHeaderIdx, entry);
                        }
                    }
                }
                if (!isEmptyCell) {
                    int obsIndex;
                    graph.whereExpression = LayoutDataLatticeParser.buildWhereExpression(rcv, ccv, row + pp.startRow, col + pp.startCol, pp);
                    comp = StatGraph.parseComponent(graph, elem, (JComponent)plot, axisType, axis2Type);
                    if (!pp.multiDataModel) {
                        model.minMaxComputed = true;
                    } else {
                        StringVariable[] classVars = new StringVariable[]{rcv, ccv};
                        LayoutDataLatticeParser.setMinMaxComputed(graph, classVars, true);
                    }
                    if (xAxisLabel == null) {
                        xAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, true);
                    }
                    if (yAxisLabel == null) {
                        yAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, true, rowAxis.isDisplayStackedLabels());
                    }
                    if (xAxisLabel2 == null) {
                        xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, false);
                    }
                    if (yAxisLabel2 == null) {
                        yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, false, row2Axis.isDisplayStackedLabels());
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, true)) {
                        colAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, false)) {
                        col2Axis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, true)) {
                        rowAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, false)) {
                        row2Axis.setSecondary(true);
                    }
                    if (pp.iArgs != null && pp.iArgs.numEntryColumns > 0) {
                        if (pp.iArgs.matchMerged) {
                            StringVariable[] cv = null;
                            cv = rcv != null && ccv != null ? new StringVariable[]{rcv, ccv} : (rcv != null ? new StringVariable[]{rcv} : new StringVariable[]{ccv});
                            String[] entries = LayoutDataLatticeParser.getFirstEntriesAt(cv, graph.whereExpression, pp.iArgs);
                            pp.iArgs.addInset(graph, entries, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                        } else {
                            obsIndex = col + pp.startCol + pp.maxNumCols * (row + pp.startRow);
                            pp.iArgs.addInset(graph, obsIndex, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                        }
                    }
                    graph.whereExpression = null;
                    if (pp.sArgs != null) {
                        obsIndex = col + pp.startCol + pp.maxNumCols * (row + pp.startRow);
                        StripLabel sl = pp.sArgs.createStripLabel(obsIndex);
                        plot.addCellHeader(theRow, col, 0, (JComponent)sl);
                    }
                    plot.addCellItem(theRow, col, (Component)comp);
                    continue;
                }
                if (!pp.showEmptyCells) continue;
                Entry stubCell = new Entry();
                stubCell.setBorder(new StyledLineBorder(pp.headerBorderStyle.getColor()));
                plot.addCellItem(theRow, col, (Component)stubCell);
            }
        }
        int numRows = pp.showEmptyCells ? rows : Math.min(pp.maxNumRows - pp.startRow, rows);
        int numCols = pp.showEmptyCells ? cols : Math.min(pp.maxNumCols - pp.startCol, cols);
        LayoutDataLatticeParser.setupAxisLabelSideBars(graph, plot, pp, rowAxis, colAxis, row2Axis, col2Axis, numRows, numCols, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
        LayoutDataLatticeParser.setupGridLabelEntry(graph, plot, rowAxis, colAxis, row2Axis, col2Axis);
        graph.whereVars = null;
        graph.allWhereExpressions = null;
        pp.iArgs = null;
    }

    public static void repeatRowColumnStamps(StatGraph graph, Element elem, DataLatticeProperties pp, StringVariable[] rowVars, StringVariable[] colVars, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis, TrellisPlot plot, int[] axisType, int[] axis2Type, DataModel model) {
        int i;
        int lastLevels;
        int i2;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int rows = tl.getGridRows();
        int cols = tl.getGridColumns();
        LayoutDataLatticeParser.setupGridAxes(graph, pp, plot, rows, cols);
        JComponent comp = null;
        int rvLen = rowVars == null ? 0 : rowVars.length;
        int cvLen = colVars == null ? 0 : colVars.length;
        graph.whereVars = new StringVectorVariable[rvLen + cvLen];
        for (i2 = 0; i2 < rvLen; ++i2) {
            graph.whereVars[i2] = rowVars[i2];
        }
        for (i2 = 0; i2 < cvLen; ++i2) {
            graph.whereVars[i2 + rvLen] = colVars[i2];
        }
        int askedTotalCols = (pp.maxNumCols + cols - 1) / cols * cols;
        graph.allWhereExpressions = new String[pp.maxNumPages * rows * cols];
        for (int pg = 0; pg < pp.maxNumPages; ++pg) {
            int startRow = cols * pg / askedTotalCols * rows;
            int startCol = cols * pg % askedTotalCols;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    boolean isEmptyCell;
                    boolean bl = isEmptyCell = row + startRow >= pp.maxNumRows || col + startCol >= pp.maxNumCols;
                    if (isEmptyCell) continue;
                    int idx = rows * cols * pg;
                    graph.allWhereExpressions[idx += pp.rowMajor ? row * cols + col : col * rows + row] = LayoutDataLatticeParser.buildWhereExpression(rowVars, colVars, row + startRow, col + startCol, pp);
                }
            }
        }
        model.minMaxComputed = false;
        model.maxNumJitteredPoints = -1;
        String[] xAxisLabel = null;
        String[] yAxisLabel = null;
        String[] xAxisLabel2 = null;
        String[] yAxisLabel2 = null;
        for (int row = 0; row < rows; ++row) {
            int theRow = pp.startAtTop ? row : rows - 1 - row;
            for (int col = 0; col < cols; ++col) {
                boolean isEmptyCell;
                boolean bl = isEmptyCell = row + pp.startRow >= pp.maxNumRows || col + pp.startCol >= pp.maxNumCols;
                if (!isEmptyCell) {
                    graph.whereExpression = LayoutDataLatticeParser.buildWhereExpression(rowVars, colVars, row + pp.startRow, col + pp.startCol, pp);
                    comp = StatGraph.parseComponent(graph, elem, (JComponent)plot, axisType, axis2Type);
                    if (comp instanceof BaseOverlayContainer) {
                        BaseOverlayContainer oc = (BaseOverlayContainer)comp;
                        oc.getComposite().getWall().setEdgeOn(false);
                    }
                    model.minMaxComputed = true;
                    graph.whereExpression = null;
                    if (xAxisLabel == null) {
                        xAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, true);
                    }
                    if (yAxisLabel == null) {
                        yAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, true, rowAxis.isDisplayStackedLabels());
                    }
                    if (xAxisLabel2 == null) {
                        xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, false);
                    }
                    if (yAxisLabel2 == null) {
                        yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, false, row2Axis.isDisplayStackedLabels());
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, true)) {
                        colAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, false)) {
                        col2Axis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, true)) {
                        rowAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, false)) {
                        row2Axis.setSecondary(true);
                    }
                    if (pp.iArgs != null && pp.iArgs.numEntryColumns > 0) {
                        int obsIndex = col + pp.startCol + pp.maxNumCols * (row + pp.startRow);
                        pp.iArgs.addInset(graph, obsIndex, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                    }
                    if (pp.sArgs != null) {
                        int obsIndex = col + pp.startCol + pp.maxNumCols * (row + pp.startRow);
                        StripLabel sl = pp.sArgs.createStripLabel(obsIndex);
                        plot.addCellHeader(theRow, col, 0, (JComponent)sl);
                    }
                    LayoutDataLatticeParser.hideCurveLabels(comp, row == 0, row == rows - 1, col == 0, col == cols - 1);
                    plot.addCellItem(theRow, col, (Component)comp);
                    continue;
                }
                if (!pp.showEmptyCells) continue;
                Entry stubCell = new Entry();
                stubCell.setBorder(new StyledLineBorder(pp.headerBorderStyle.getColor()));
                plot.addCellItem(theRow, col, (Component)stubCell);
            }
        }
        if (rowVars != null) {
            plot.createRowCompoundHeader();
            int[] rspan = new int[rowVars.length];
            rspan[0] = 1;
            lastLevels = LayoutDataLatticeParser.getNumLevels(rowVars[0], pp);
            for (i = 1; i < rspan.length; ++i) {
                rspan[i] = lastLevels;
                lastLevels *= LayoutDataLatticeParser.getNumLevels(rowVars[i], pp);
            }
            plot.getRowCompoundHeader().setSpans(rspan);
            plot.getRowCompoundHeader().setBackground(pp.headerFillStyle.getColor());
        }
        if (colVars != null) {
            plot.createColumnCompoundHeader();
            int[] cspan = new int[colVars.length];
            cspan[0] = 1;
            lastLevels = LayoutDataLatticeParser.getNumLevels(colVars[0], pp);
            for (i = 1; i < cspan.length; ++i) {
                cspan[i] = lastLevels;
                lastLevels *= LayoutDataLatticeParser.getNumLevels(colVars[i], pp);
            }
            plot.getColumnCompoundHeader().setSpans(cspan);
            plot.getColumnCompoundHeader().setBackground(pp.headerFillStyle.getColor());
        }
        if (rowVars != null) {
            if (pp.extractHeaderName) {
                block19: for (int i3 = 0; i3 < rowVars.length; ++i3) {
                    String labelText = " " + rowVars[i3].getLabel() + " ";
                    switch (pp.rowHeaders) {
                        case 1: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addRowCompoundHeaderLabel(i3, (Component)label);
                            continue block19;
                        }
                        case 2: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addRow2CompoundHeaderLabel(i3, (Component)label);
                            continue block19;
                        }
                        case 0: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addRowCompoundHeaderLabel(i3, (Component)label);
                            label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, labelText, 0.0);
                            plot.addRow2CompoundHeaderLabel(i3, (Component)label);
                        }
                    }
                }
            }
            for (int row = 0; row < rows; ++row) {
                boolean isEmptyRow;
                boolean bl = isEmptyRow = row + pp.startRow >= pp.maxNumRows;
                if (!pp.showEmptyCells && isEmptyRow) continue;
                int theRow = pp.startAtTop ? row : rows - 1 - row;
                for (int j = 0; j < rowVars.length; ++j) {
                    Entry entry;
                    String headerText;
                    int span = plot.getRowCompoundHeader().getHeader(j).getSpan();
                    if (theRow % span != 0) continue;
                    int idx = LayoutDataLatticeParser.getIndex(rowVars, j, theRow, pp);
                    String header = isEmptyRow ? " " : LayoutDataLatticeParser.buildHeaderLabel(rowVars[j], idx, pp);
                    double angle = pp.verticalRowHeaders ? 90.0 : 0.0;
                    String string = headerText = pp.verticalRowHeaders ? header : " " + header + " ";
                    if (pp.rowHeaders == 1 || pp.rowHeaders == 0) {
                        entry = LayoutDataLatticeParser.createSimpleEntry(graph, pp, headerText, angle);
                        plot.addRowCompoundHeader(j, (Component)entry);
                    }
                    if (pp.rowHeaders != 0 && pp.rowHeaders != 2) continue;
                    entry = LayoutDataLatticeParser.createSimpleEntry(graph, pp, headerText, angle);
                    plot.addRow2CompoundHeader(j, (Component)entry);
                }
            }
        }
        if (colVars != null) {
            if (pp.extractHeaderName) {
                block22: for (int i4 = 0; i4 < colVars.length; ++i4) {
                    switch (pp.columnHeaders) {
                        case 3: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + colVars[i4].getLabel() + " ", 0.0);
                            plot.addColumnCompoundHeaderLabel(i4, (Component)label);
                            continue block22;
                        }
                        case 4: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + colVars[i4].getLabel() + " ", 0.0);
                            plot.addColumn2CompoundHeaderLabel(i4, (Component)label);
                            continue block22;
                        }
                        case 0: {
                            Entry label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + colVars[i4].getLabel() + " ", 0.0);
                            plot.addColumnCompoundHeaderLabel(i4, (Component)label);
                            label = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + colVars[i4].getLabel() + " ", 0.0);
                            plot.addColumn2CompoundHeaderLabel(i4, (Component)label);
                        }
                    }
                }
            }
            for (int col = 0; col < cols; ++col) {
                boolean isEmptyCol;
                boolean bl = isEmptyCol = col + pp.startCol >= pp.maxNumCols;
                if (!pp.showEmptyCells && isEmptyCol) continue;
                for (int j = 0; j < colVars.length; ++j) {
                    JComponent entry;
                    String header;
                    int span = plot.getColumnCompoundHeader().getHeader(j).getSpan();
                    if (col % span != 0) continue;
                    int idx = LayoutDataLatticeParser.getIndex(colVars, j, col, pp);
                    String string = header = isEmptyCol ? " " : LayoutDataLatticeParser.buildHeaderLabel(colVars[j], idx, pp);
                    if (pp.columnHeaders == 3 || pp.columnHeaders == 0) {
                        entry = LayoutDataLatticeParser.createEntry(graph, header, pp);
                        plot.addColumnCompoundHeader(j, (Component)entry);
                    }
                    if (pp.columnHeaders != 0 && pp.columnHeaders != 4) continue;
                    entry = LayoutDataLatticeParser.createEntry(graph, header, pp);
                    plot.addColumn2CompoundHeader(j, (Component)entry);
                }
            }
        }
        int numRows = pp.showEmptyCells ? rows : Math.min(pp.maxNumRows - pp.startRow, rows);
        int numCols = pp.showEmptyCells ? cols : Math.min(pp.maxNumCols - pp.startCol, cols);
        LayoutDataLatticeParser.setupAxisLabelSideBars(graph, plot, pp, rowAxis, colAxis, row2Axis, col2Axis, numRows, numCols, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
        graph.whereVars = null;
        graph.allWhereExpressions = null;
        pp.iArgs = null;
    }

    public static void repeatOLAPRowColumnStamps(StatGraph graph, Element elem, DataLatticeProperties pp, StringVariable[] rowVars, StringVariable[] colVars, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis, TrellisPlot plot, int[] axisType, int[] axis2Type, DataModel model) {
        int i;
        int i2;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int rows = tl.getGridRows();
        int cols = tl.getGridColumns();
        OLAPVariableFactory fac = model.getOLAPVarFactory();
        ArrayList<String> rowDimNames = null;
        ArrayList<String> colDimNames = null;
        if (rowVars != null) {
            rowDimNames = new ArrayList<String>();
            for (i2 = 0; i2 < rowVars.length; ++i2) {
                rowDimNames.add(rowVars[i2].getColumnName());
            }
        }
        if (colVars != null) {
            colDimNames = new ArrayList<String>();
            for (i2 = 0; i2 < colVars.length; ++i2) {
                colDimNames.add(colVars[i2].getColumnName());
            }
        }
        LayoutDataLatticeParser.setupGridAxes(graph, pp, plot, rows, cols);
        JComponent comp = null;
        int rvLen = rowVars == null ? 0 : rowVars.length;
        int cvLen = colVars == null ? 0 : colVars.length;
        graph.whereVars = new StringVariable[rvLen + cvLen];
        for (i = 0; i < rvLen; ++i) {
            graph.whereVars[i] = rowVars[i];
        }
        for (i = 0; i < cvLen; ++i) {
            graph.whereVars[i + rvLen] = colVars[i];
        }
        DefaultMutableTreeNode[] rl = null;
        DefaultMutableTreeNode[] cl = null;
        if (rowDimNames != null) {
            rl = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)fac.createSubTree(rowDimNames));
        }
        if (colDimNames != null) {
            cl = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)fac.createSubTree(colDimNames));
        }
        int askedTotalCols = (pp.maxNumCols + cols - 1) / cols * cols;
        graph.allWhereExpressions = new String[pp.maxNumPages * rows * cols];
        for (int pg = 0; pg < pp.maxNumPages; ++pg) {
            int startRow = cols * pg / askedTotalCols * rows;
            int startCol = cols * pg % askedTotalCols;
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    boolean isEmptyCell;
                    boolean bl = isEmptyCell = row + startRow >= pp.maxNumRows || col + startCol >= pp.maxNumCols;
                    if (isEmptyCell) continue;
                    int idx = rows * cols * pg;
                    graph.allWhereExpressions[idx += pp.rowMajor ? row * cols + col : col * rows + row] = LayoutDataLatticeParser.buildWhereExpression(rl, cl, row + startRow, col + startCol, pp);
                }
            }
        }
        JComponent theCellItem = null;
        model.minMaxComputed = false;
        model.maxNumJitteredPoints = -1;
        String[] xAxisLabel = null;
        String[] yAxisLabel = null;
        String[] xAxisLabel2 = null;
        String[] yAxisLabel2 = null;
        for (int row = 0; row < rows; ++row) {
            int theRow = pp.startAtTop ? row : rows - 1 - row;
            for (int col = 0; col < cols; ++col) {
                boolean isEmptyCell;
                boolean bl = isEmptyCell = row + pp.startRow >= pp.maxNumRows || col + pp.startCol >= pp.maxNumCols;
                if (!isEmptyCell) {
                    graph.whereExpression = LayoutDataLatticeParser.buildWhereExpression(rl, cl, row + pp.startRow, col + pp.startCol, pp);
                    comp = StatGraph.parseComponent(graph, elem, (JComponent)plot, axisType, axis2Type);
                    if (comp instanceof BaseOverlayContainer) {
                        BaseOverlayContainer oc = (BaseOverlayContainer)comp;
                        oc.getComposite().getWall().setEdgeOn(false);
                    }
                    model.minMaxComputed = true;
                    graph.whereExpression = null;
                    if (xAxisLabel == null) {
                        xAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, true);
                    }
                    if (yAxisLabel == null) {
                        yAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, true, rowAxis.isDisplayStackedLabels());
                    }
                    if (xAxisLabel2 == null) {
                        xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, false);
                    }
                    if (yAxisLabel2 == null) {
                        yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, false, row2Axis.isDisplayStackedLabels());
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, true)) {
                        colAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, false)) {
                        col2Axis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, true)) {
                        rowAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, false)) {
                        row2Axis.setSecondary(true);
                    }
                    if (pp.iArgs != null && pp.iArgs.numEntryColumns > 0) {
                        int obsIndex = col + pp.startCol + pp.maxNumCols * (row + pp.startRow);
                        pp.iArgs.addInset(graph, obsIndex, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                    }
                    if (pp.sArgs != null) {
                        int obsIndex = col + pp.startCol + pp.maxNumCols * (row + pp.startRow);
                        StripLabel sl = pp.sArgs.createStripLabel(obsIndex);
                        plot.addCellHeader(theRow, col, 0, (JComponent)sl);
                    }
                    LayoutDataLatticeParser.hideCurveLabels(comp, row == 0, row == rows - 1, col == 0, col == cols - 1);
                    plot.addCellItem(theRow, col, (Component)comp);
                    theCellItem = comp;
                    continue;
                }
                if (!pp.showEmptyCells) continue;
                Entry stubCell = new Entry();
                stubCell.setBorder(new StyledLineBorder(pp.headerBorderStyle.getColor()));
                plot.addCellItem(theRow, col, (Component)stubCell);
            }
        }
        DataModel olapModel = (DataModel)graph.olapData.get(0);
        plot.createRowOLAPHeader();
        plot.createColumnOLAPHeader();
        if (rowVars != null || olapModel.yCategoryVar != null) {
            if (rowDimNames != null) {
                DataTreeGroupNode tree = fac.createSubTree(rowDimNames);
                DefaultMutableTreeNode[] leafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)tree);
                int lev = ((DataTreeInfo)tree.getValue()).getGroupVariableCount();
                plot.setRowOLAPHeaderLevels(lev, true);
                plot.setRowOLAPHeaderLeafs(leafs, true);
            }
            if (olapModel.yCategoryVar != null) {
                if (rowDimNames == null) {
                    rowDimNames = new ArrayList();
                }
                rowDimNames.add(olapModel.yCategoryVar);
                rowAxis.getAxisStyle().setMajorTickMarksOn(false);
                rowAxis.getAxisStyle().setLabelsOn(false);
                rowAxis.getAxisStyle().setTitleOn(false);
                pp.rowAxisAltDisplay = "none";
            }
            StringBuffer sb = new StringBuffer();
            for (int i3 = 0; i3 < rowDimNames.size(); ++i3) {
                String lab = fac.getHierachyLabel((String)rowDimNames.get(i3));
                sb = sb.append(lab);
                if (i3 >= rowDimNames.size() - 1) continue;
                sb = sb.append(" / ");
            }
            if (sb.length() > 0) {
                Entry e = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + sb.toString() + " ", 90.0);
                plot.addRowOLAPHeaderTitle((Component)e, true);
            }
            DataTreeGroupNode tree = fac.createSubTree(rowDimNames);
            double theta = pp.verticalRowHeaders ? 90.0 : 0.0;
            LayoutDataLatticeParser.createSimpleEntries(graph, plot, pp, tree, theta, plot.getRowOLAPHeaderLevels(true), rowAxis);
            plot.setRowOLAPHeaderTree(tree, true);
            plot.setRowOLAPHeaderBackground(pp.headerFillStyle.getColor());
        }
        if (colVars != null || olapModel.xCategoryVar != null) {
            DefaultMutableTreeNode[] headerLeafs = null;
            if (colDimNames != null) {
                DataTreeGroupNode tree = fac.createSubTree(colDimNames);
                headerLeafs = DataTreeUtil.createLeafNodeArray((DefaultMutableTreeNode)tree);
                plot.setColumnOLAPHeaderLeafs(headerLeafs, true);
                int lev = ((DataTreeInfo)tree.getValue()).getGroupVariableCount();
                plot.setColumnOLAPHeaderLevels(lev, true);
            }
            if (olapModel.xCategoryVar != null) {
                if (colDimNames == null) {
                    colDimNames = new ArrayList();
                }
                colDimNames.add(olapModel.xCategoryVar);
                colAxis.getAxisStyle().setMajorTickMarksOn(false);
                colAxis.getAxisStyle().setLabelsOn(false);
                colAxis.getAxisStyle().setTitleOn(false);
                pp.colAxisAltDisplay = "none";
            }
            StringBuffer sb = new StringBuffer();
            for (int i4 = 0; i4 < colDimNames.size(); ++i4) {
                String lab = fac.getHierachyLabel((String)colDimNames.get(i4));
                sb = sb.append(lab);
                if (i4 >= colDimNames.size() - 1) continue;
                sb = sb.append(" / ");
            }
            if (sb.length() > 0) {
                Entry e = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + sb.toString() + " ", 0.0);
                plot.addColumnOLAPHeaderTitle((Component)e, true);
            }
            DataTreeGroupNode tree = fac.createSubTree(colDimNames);
            if (theCellItem != null && theCellItem instanceof BaseOverlayContainer) {
                WaterfallChartOverlay.addFinalCategoryToTree(tree, headerLeafs, (BaseOverlayContainer)theCellItem);
            }
            LayoutDataLatticeParser.createSimpleEntries(graph, plot, pp, tree, 0.0, plot.getColumnOLAPHeaderLevels(true), colAxis);
            plot.setColumnOLAPHeaderTree(tree, true);
            plot.setColumnOLAPHeaderBackground(pp.headerFillStyle.getColor());
        }
        int numRows = pp.showEmptyCells ? rows : Math.min(pp.maxNumRows - pp.startRow, rows);
        int numCols = pp.showEmptyCells ? cols : Math.min(pp.maxNumCols - pp.startCol, cols);
        LayoutDataLatticeParser.setupAxisLabelSideBars(graph, plot, pp, rowAxis, colAxis, row2Axis, col2Axis, numRows, numCols, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
        graph.whereVars = null;
        graph.allWhereExpressions = null;
        pp.iArgs = null;
    }

    static JComponent buildCollapsedHeader(StatGraph graph, String[] headers, DataLatticeProperties pp) {
        int breakCount = pp.headerSplitCount;
        if (breakCount < 1 || breakCount > headers.length) {
            breakCount = headers.length;
        }
        JPanel grid = new JPanel();
        grid.setLayout(new BoxLayout(grid, 1));
        if (pp.headerFillStyle.getTransparency() < 1.0) {
            grid.setOpaque(true);
            grid.setBackground(pp.headerFillStyle.getColor());
        } else {
            grid.setOpaque(false);
        }
        if (pp.headerBorder) {
            Color bc = pp.headerBorderStyle.getColor();
            int bp = pp.headerBorderStyle.getLinePattern();
            int bt = pp.headerBorderStyle.getWidth();
            grid.setBorder(new StyledLineBorder(bc, bp, bt));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i <= headers.length; ++i) {
            if (!pp.includeMissing && headers[i - 1].length() == 0) continue;
            sb = sb.append(headers[i - 1]);
            if (i % breakCount == 0 || i == headers.length) {
                Entry e = new Entry(sb.toString());
                e.setForeground(pp.headerLabelStyle.getColor());
                e.setFont(pp.headerLabelStyle.getFont());
                e.setTextAntiAliased(graph.axisAntialiased);
                grid.add(e);
                sb.setLength(0);
                continue;
            }
            if (i >= headers.length) continue;
            sb = sb.append(pp.headerSeparator);
        }
        return grid;
    }

    static void repeatCellStamps(StatGraph graph, Element elem, DataLatticeProperties pp, StringVariable[] classVars, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis, TrellisPlot plot, int page, int[] axisType, int[] axis2Type, int[] cellIndexMap, DataModel model) {
        int numCols;
        int numRows;
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        int rows = tl.getGridRows();
        int cols = tl.getGridColumns();
        int totalLevels = 1;
        int[] levels = new int[classVars.length];
        for (int i = 0; i < classVars.length; ++i) {
            levels[i] = LayoutDataLatticeParser.getNumLevels(classVars[i], pp);
            totalLevels *= levels[i];
        }
        totalLevels = cellIndexMap.length;
        if (pp.sharedAxes) {
            LayoutDataLatticeParser.setupGridAxes(graph, pp, plot, rows, cols);
        }
        JComponent comp = null;
        graph.whereVars = classVars;
        graph.allWhereExpressions = new String[totalLevels];
        for (int pg = 0; pg < pp.maxNumPages; ++pg) {
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    int idx = rows * cols * pg;
                    if ((idx += pp.rowMajor ? row * cols + col : col * rows + row) >= totalLevels) continue;
                    graph.allWhereExpressions[idx] = LayoutDataLatticeParser.buildWhereExpression(classVars, levels, cellIndexMap[idx], pp);
                }
            }
        }
        int numPlots = totalLevels - rows * cols * page;
        String[] xAxisLabel = null;
        String[] yAxisLabel = null;
        String[] xAxisLabel2 = null;
        String[] yAxisLabel2 = null;
        if (!pp.multiDataModel) {
            model.minMaxComputed = false;
        } else {
            LayoutDataLatticeParser.setMinMaxComputed(graph, classVars, false);
        }
        model.maxNumJitteredPoints = -1;
        if (numPlots < rows * cols && pp.packed) {
            int row;
            int[] cellsPerRow = new int[rows];
            for (int i = 0; i < rows; ++i) {
                cellsPerRow[i] = cols;
            }
            int neededRows = (int)Math.ceil((double)numPlots / (double)cols);
            int emptyCells = cols - numPlots % cols;
            if (emptyCells >= cols) {
                emptyCells = 0;
            }
            int r = 0;
            for (int i = 0; i < emptyCells; ++i) {
                int n = r++;
                cellsPerRow[n] = cellsPerRow[n] - 1;
                if (r < neededRows) continue;
                r = 0;
            }
            int idx = rows * cols * page;
            for (row = 0; row < neededRows; ++row) {
                int col;
                int theRow = pp.startAtTop ? row : rows - 1 - row;
                for (col = 0; col < cellsPerRow[row]; ++col) {
                    if (pp.displayHeader) {
                        String[] headers = LayoutDataLatticeParser.buildHeaderLabel(classVars, levels, cellIndexMap[idx], pp);
                        if (pp.headerCollapse) {
                            plot.addCellHeader(theRow, col, 0, LayoutDataLatticeParser.buildCollapsedHeader(graph, headers, pp));
                        } else {
                            int cnt = 0;
                            for (int k = 0; k < headers.length; ++k) {
                                if (!pp.includeMissing && headers[k].length() == 0) continue;
                                JComponent entry = LayoutDataLatticeParser.createEntry(graph, headers[k], pp);
                                plot.addCellHeader(theRow, col, cnt++, entry);
                            }
                        }
                    }
                    graph.whereExpression = LayoutDataLatticeParser.buildWhereExpression(classVars, levels, cellIndexMap[idx], pp);
                    comp = StatGraph.parseComponent(graph, elem, (JComponent)plot, axisType, axis2Type);
                    if (!pp.multiDataModel) {
                        model.minMaxComputed = true;
                    } else {
                        LayoutDataLatticeParser.setMinMaxComputed(graph, classVars, true);
                    }
                    if (xAxisLabel == null) {
                        xAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, true);
                    }
                    if (yAxisLabel == null) {
                        yAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, true, rowAxis.isDisplayStackedLabels());
                    }
                    if (xAxisLabel2 == null) {
                        xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, false);
                    }
                    if (yAxisLabel2 == null) {
                        yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, false, row2Axis.isDisplayStackedLabels());
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, true)) {
                        colAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, false)) {
                        col2Axis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, true)) {
                        rowAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, false)) {
                        row2Axis.setSecondary(true);
                    }
                    if (pp.iArgs != null && pp.iArgs.numEntryColumns > 0) {
                        if (pp.iArgs.matchMerged) {
                            String[] entries = LayoutDataLatticeParser.getFirstEntriesAt(classVars, graph.whereExpression, pp.iArgs);
                            pp.iArgs.addInset(graph, entries, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                        } else {
                            pp.iArgs.addInset(graph, idx, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                        }
                    }
                    graph.whereExpression = null;
                    plot.addCellItem(theRow, col, (Component)comp);
                    ++idx;
                }
                if (!pp.showEmptyCells || !pp.sharedAxes) continue;
                for (col = cellsPerRow[row]; col < cols; ++col) {
                    LayoutDataLatticeParser.addEmptyCell(plot, theRow, col, classVars.length, pp);
                }
            }
            if (pp.showEmptyCells && pp.sharedAxes) {
                for (row = neededRows; row < rows; ++row) {
                    int theRow = pp.startAtTop ? row : rows - 1 - row;
                    for (int col = 0; col < cols; ++col) {
                        LayoutDataLatticeParser.addEmptyCell(plot, theRow, col, classVars.length, pp);
                    }
                }
            }
            numRows = pp.showEmptyCells ? rows : neededRows;
            numCols = pp.showEmptyCells ? cols : (int)Math.ceil((double)numPlots / (double)neededRows);
        } else {
            for (int row = 0; row < rows; ++row) {
                int theRow = pp.startAtTop ? row : rows - 1 - row;
                for (int col = 0; col < cols; ++col) {
                    int idx = rows * cols * page;
                    if ((idx += pp.rowMajor ? row * cols + col : col * rows + row) >= totalLevels) {
                        if (!pp.showEmptyCells || !pp.sharedAxes) continue;
                        LayoutDataLatticeParser.addEmptyCell(plot, theRow, col, classVars.length, pp);
                        continue;
                    }
                    if (pp.displayHeader) {
                        String[] headers = LayoutDataLatticeParser.buildHeaderLabel(classVars, levels, cellIndexMap[idx], pp);
                        if (pp.headerCollapse) {
                            plot.addCellHeader(theRow, col, 0, LayoutDataLatticeParser.buildCollapsedHeader(graph, headers, pp));
                        } else {
                            int cnt = 0;
                            for (int k = 0; k < headers.length; ++k) {
                                if (!pp.includeMissing && headers[k].length() == 0) continue;
                                JComponent entry = LayoutDataLatticeParser.createEntry(graph, headers[k], pp);
                                plot.addCellHeader(theRow, col, cnt++, entry);
                            }
                        }
                    }
                    graph.whereExpression = LayoutDataLatticeParser.buildWhereExpression(classVars, levels, cellIndexMap[idx], pp);
                    comp = StatGraph.parseComponent(graph, elem, (JComponent)plot, axisType, axis2Type);
                    if (!pp.multiDataModel) {
                        model.minMaxComputed = true;
                    } else {
                        LayoutDataLatticeParser.setMinMaxComputed(graph, classVars, true);
                    }
                    if (xAxisLabel == null) {
                        xAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, true);
                    }
                    if (yAxisLabel == null) {
                        yAxisLabel = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, true, rowAxis.isDisplayStackedLabels());
                    }
                    if (xAxisLabel2 == null) {
                        xAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)1, false);
                    }
                    if (yAxisLabel2 == null) {
                        yAxisLabel2 = LayoutDataLatticeParser.getAxisLabel(comp, (byte)2, false, row2Axis.isDisplayStackedLabels());
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, true)) {
                        colAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)1, false)) {
                        col2Axis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, true)) {
                        rowAxis.setSecondary(true);
                    }
                    if (!LayoutDataLatticeParser.hasOverlayOnAxis(comp, (byte)2, false)) {
                        row2Axis.setSecondary(true);
                    }
                    if (pp.iArgs != null && pp.iArgs.numEntryColumns > 0) {
                        if (pp.iArgs.matchMerged) {
                            String[] entries = LayoutDataLatticeParser.getFirstEntriesAt(classVars, graph.whereExpression, pp.iArgs);
                            pp.iArgs.addInset(graph, entries, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                        } else {
                            pp.iArgs.addInset(graph, idx, comp, pp.iArgs.showLabels, pp.iArgs.separator);
                        }
                    }
                    graph.whereExpression = null;
                    plot.addCellItem(theRow, col, (Component)comp);
                }
            }
            if (pp.showEmptyCells) {
                numRows = rows;
                numCols = cols;
            } else if (pp.rowMajor) {
                numRows = (int)Math.ceil((double)numPlots / (double)cols);
                numCols = numRows > 1 ? cols : numPlots;
            } else {
                numCols = (int)Math.ceil((double)numPlots / (double)rows);
                numRows = numCols > 1 ? rows : numPlots;
            }
        }
        LayoutDataLatticeParser.setupAxisLabelSideBars(graph, plot, pp, rowAxis, colAxis, row2Axis, col2Axis, numRows, numCols, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
        LayoutDataLatticeParser.setupGridLabelEntry(graph, plot, rowAxis, colAxis, row2Axis, col2Axis);
        LayoutDataLatticeParser.hideRowColumnAxes(plot);
        graph.whereVars = null;
        graph.allWhereExpressions = null;
        pp.iArgs = null;
    }

    public static void addEmptyCell(TrellisPlot plot, int row, int col, int n, DataLatticeProperties pp) {
        Color bc = pp.headerBorderStyle.getColor();
        if (pp.displayHeader) {
            int bp = pp.headerBorderStyle.getLinePattern();
            int bt = pp.headerBorderStyle.getWidth();
            if (pp.headerCollapse) {
                n = 1;
            }
            for (int k = 0; k < n; ++k) {
                Entry entry = new Entry();
                if (pp.headerFillStyle.getTransparency() < 1.0) {
                    entry.setOpaque(true);
                    entry.setBackground(pp.headerFillStyle.getColor());
                } else {
                    entry.setOpaque(false);
                }
                entry.setForeground(pp.headerLabelStyle.getColor());
                entry.setFont(pp.headerLabelStyle.getFont());
                entry.setBorder(new StyledLineBorder(bc, bp, bt));
                plot.addCellHeader(row, col, k, (JComponent)entry);
            }
        }
        Entry stubCell = new Entry();
        stubCell.setBorder(new StyledLineBorder(bc));
        plot.addCellItem(row, col, (Component)stubCell);
    }

    public static String buildWhereExpression(StringVariable rcv, StringVariable ccv, int row, int col, DataLatticeProperties pp) {
        StringBuffer where = new StringBuffer();
        if (rcv != null) {
            where = where.append(rcv.getColumnName() + " = \"" + LayoutDataLatticeParser.getNextNonMissingLevel(rcv, row, pp) + "\"");
        }
        if (ccv != null) {
            if (where.length() > 0) {
                where = where.append(" & ");
            }
            where = where.append(ccv.getColumnName() + " = \"" + LayoutDataLatticeParser.getNextNonMissingLevel(ccv, col, pp) + "\"");
        }
        return where.toString();
    }

    public static String buildWhereExpression(StringVariable[] rcv, StringVariable[] ccv, int row, int col, DataLatticeProperties pp) {
        int idx;
        int i;
        StringBuffer where = new StringBuffer();
        if (rcv != null) {
            for (i = 0; i < rcv.length; ++i) {
                if (i > 0) {
                    where = where.append(" & ");
                }
                idx = LayoutDataLatticeParser.getIndex(rcv, i, row, pp);
                where = where.append(rcv[i].getColumnName() + " = \"" + LayoutDataLatticeParser.getNextNonMissingLevel(rcv[i], idx, pp) + "\"");
            }
        }
        if (ccv != null) {
            if (where.length() > 0) {
                where = where.append(" & ");
            }
            for (i = 0; i < ccv.length; ++i) {
                if (i > 0) {
                    where = where.append(" & ");
                }
                idx = LayoutDataLatticeParser.getIndex(ccv, i, col, pp);
                where = where.append(ccv[i].getColumnName() + " = \"" + LayoutDataLatticeParser.getNextNonMissingLevel(ccv[i], idx, pp) + "\"");
            }
        }
        return where.toString();
    }

    public static String buildWhereExpression(DefaultMutableTreeNode[] rowLeafs, DefaultMutableTreeNode[] colLeafs, int row, int col, DataLatticeProperties pp) {
        StringBuffer where = new StringBuffer();
        if (rowLeafs != null) {
            where = where.append(DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)rowLeafs[row])));
        }
        if (colLeafs != null) {
            if (where.length() > 0) {
                where = where.append(" & ");
            }
            where = where.append(DataTreeUtil.getPathWhereExpression((DataTreeGroupNode)((DataTreeGroupNode)colLeafs[col])));
        }
        return where.toString();
    }

    public static int getIndex(StringVariable[] svv, int level, int rOrC, DataLatticeProperties pp) {
        int span = 1;
        for (int i = 0; i < svv.length; ++i) {
            int num = LayoutDataLatticeParser.getNumLevels(svv[i], pp);
            if (i == level) {
                return rOrC / span % num;
            }
            span *= LayoutDataLatticeParser.getNumLevels(svv[i], pp);
        }
        return 0;
    }

    static int locate(int[] levels, int n, int idx) {
        if (n == 0) {
            return idx % levels[n];
        }
        int period = 1;
        for (int i = 0; i < n; ++i) {
            period *= levels[i];
        }
        return idx / period % levels[n];
    }

    static String getNextNonMissingLevel(StringVariable var, int n, DataLatticeProperties pp) {
        String str = null;
        if (pp.inLookup.containsKey(var)) {
            String[] cls = (String[])pp.inLookup.get(var);
            return cls[n];
        }
        if (!pp.includeMissing) {
            boolean missing = false;
            for (int i = 0; i <= n; ++i) {
                try {
                    str = var.uniqueValue.getValue(i);
                    continue;
                }
                catch (MissingValueException mve) {
                    missing = true;
                    break;
                }
            }
            if (missing) {
                ++n;
            }
        }
        try {
            str = var.uniqueValue.getValue(n);
            if (EXCLUDED_CLASS_VALUE != null && str.equals(EXCLUDED_CLASS_VALUE)) {
                str = var.uniqueValue.getValue(n + 1);
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return str;
    }

    public static String buildWhereExpression(StringVariable[] vars, String[] values) {
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            if (where.length() > 0) {
                where = where.append(" & ");
            }
            if (EXCLUDED_CLASS_VALUE != null) {
                where = where.append("( ");
            }
            String colName = vars[i].getColumnName() != null ? vars[i].getColumnName() : vars[i].getName();
            where = where.append(colName + " = \"" + values[i] + "\"");
            if (EXCLUDED_CLASS_VALUE == null) continue;
            where = where.append(" | " + colName + " = \"" + EXCLUDED_CLASS_VALUE + "\" )");
        }
        return where.toString();
    }

    public static String buildWhereExpression(StringVariable[] vars, int[] levels, int idx, DataLatticeProperties pp) {
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            if (where.length() > 0) {
                where = where.append(" & ");
            }
            if (EXCLUDED_CLASS_VALUE != null) {
                where = where.append("( ");
            }
            String colName = vars[i].getColumnName() != null ? vars[i].getColumnName() : vars[i].getName();
            where = where.append(colName + " = \"" + LayoutDataLatticeParser.getNextNonMissingLevel(vars[i], LayoutDataLatticeParser.locate(levels, i, idx), pp) + "\"");
            if (EXCLUDED_CLASS_VALUE == null) continue;
            where = where.append(" | " + colName + " = \"" + EXCLUDED_CLASS_VALUE + "\" )");
        }
        return where.toString();
    }

    public static String[] buildHeaderLabel(StringVariable[] vars, int[] levels, int idx, DataLatticeProperties pp) {
        String[] headers = new String[vars.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            sb.setLength(0);
            String val = LayoutDataLatticeParser.getNextNonMissingLevel(vars[i], LayoutDataLatticeParser.locate(levels, i, idx), pp).trim();
            sb = pp.includeNameInHeader ? sb.append(vars[i].getLabel() + " = " + val) : sb.append(val);
            headers[vars.length - i - 1] = sb.toString();
        }
        return headers;
    }

    public static String buildHeaderLabel(StringVariable v, int idx, DataLatticeProperties pp) {
        StringBuffer header = new StringBuffer();
        if (v != null) {
            String str = LayoutDataLatticeParser.getNextNonMissingLevel(v, idx, pp).trim();
            header = pp.includeNameInHeader ? header.append(v.getLabel() + " = " + str) : header.append(str);
        }
        return header.toString();
    }

    public static Entry createSimpleEntry(StatGraph graph, DataLatticeProperties pp, String header, double theta) {
        Entry entry = new Entry(header);
        entry.setTheta(theta);
        if (pp.headerFillStyle.getTransparency() < 1.0) {
            entry.setOpaque(true);
            entry.setBackground(pp.headerFillStyle.getColor());
        } else {
            entry.setOpaque(false);
        }
        entry.setForeground(pp.headerLabelStyle.getColor());
        entry.setFont(pp.headerLabelStyle.getFont());
        if (pp.headerBorder) {
            Color bc = pp.headerBorderStyle.getColor();
            int bp = pp.headerBorderStyle.getLinePattern();
            int bt = pp.headerBorderStyle.getWidth();
            entry.setBorder(new StyledLineBorder(bc, bp, bt));
        }
        entry.setTextAntiAliased(graph.axisAntialiased);
        return entry;
    }

    public static Entry createExtractedHeaderLabel(StatGraph graph, DataLatticeProperties pp, String header, double theta) {
        Entry entry = new Entry(header);
        entry.setTheta(theta);
        entry.setBackground(pp.headerFillStyle.getColor());
        entry.setOpaque(false);
        entry.setForeground(pp.headerExtractedLabelStyle.getColor());
        entry.setFont(pp.headerExtractedLabelStyle.getFont());
        entry.setShortText(header);
        entry.setTextAntiAliased(graph.axisAntialiased);
        return entry;
    }

    public static Entry createExtractedHeaderLevelLabel(StatGraph graph, DataLatticeProperties pp, String label) {
        Entry entry = new Entry(label);
        entry.setBackground(pp.headerFillStyle.getColor());
        entry.setOpaque(false);
        entry.setForeground(pp.headerExtractedLevelLabelStyle.getColor());
        entry.setFont(pp.headerExtractedLevelLabelStyle.getFont());
        entry.setShortText(label);
        entry.setTextAntiAliased(graph.axisAntialiased);
        return entry;
    }

    public static void createSimpleEntries(StatGraph graph, TrellisPlot trellis, DataLatticeProperties pp, DataTreeGroupNode tree, double theta, int headerLevels, VRectAxis axis) {
        Enumeration eu = tree.depthFirstEnumeration();
        boolean cnt = false;
        while (eu.hasMoreElements()) {
            DataTreeGroupNode tn = (DataTreeGroupNode)eu.nextElement();
            if (tn.toString() == null) continue;
            Entry entry = LayoutDataLatticeParser.createSimpleEntry(graph, pp, " " + tn.toString() + " ", theta);
            if (tn.getLevelIndex() >= headerLevels) {
                entry.setForeground(axis.getAxisStyle().getLabelStyle().getColor());
                entry.setFont(axis.getAxisStyle().getLabelStyle().getFont());
                entry.setOpaque(false);
            }
            if (theta != 0.0) {
                entry.setAlignmentX(0.5f);
                entry.setAlignmentY(0.0f);
            } else {
                entry.setAlignmentY(1.0f);
            }
            tn.setUserObject((Object)entry);
            trellis.add((Component)entry);
        }
        DataTreeGroupNode root = (DataTreeGroupNode)tree.getRoot();
        DataTreeInfo info = (DataTreeInfo)tree.getValue();
        Entry[] labels = new Entry[info.getGroupVariableCount()];
        for (int i = 0; i < labels.length; ++i) {
            Entry entry;
            if (StatGraph.isOLAP()) {
                entry = LayoutDataLatticeParser.createExtractedHeaderLevelLabel(graph, pp, " " + info.getGroupVariableAt(i).getLabel() + " ");
                if (i >= headerLevels) {
                    entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
                    entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
                }
            } else {
                entry = LayoutDataLatticeParser.createExtractedHeaderLabel(graph, pp, " " + info.getGroupVariableAt(i).getLabel() + " ", 0.0);
            }
            labels[i] = entry;
            trellis.add((Component)entry);
        }
        root.setUserObject((Object)labels);
    }

    public static JComponent createEntry(StatGraph graph, String text, DataLatticeProperties pp) {
        RotatedJTextPane entry = new RotatedJTextPane();
        entry.setShortenPolicy(2);
        entry.setAntialiased(graph.axisAntialiased);
        Document doc = entry.getDocument();
        SimpleAttributeSet set = EntryConcatParser.createAttributeSet(pp.headerLabelStyle, null, false, false, false, false);
        try {
            doc.insertString(doc.getLength(), text, set);
        }
        catch (BadLocationException ex) {
            StatGraph.printDebug(ex.getMessage());
        }
        set = new SimpleAttributeSet();
        StyleConstants.setAlignment(set, 1);
        entry.setParagraphAttributes(set, false);
        if (pp.headerFillStyle.getTransparency() < 1.0) {
            entry.setOpaque(true);
            entry.setBackground(pp.headerFillStyle.getColor());
        } else {
            entry.setOpaque(false);
        }
        if (pp.headerBorder) {
            Color bc = pp.headerBorderStyle.getColor();
            int bp = pp.headerBorderStyle.getLinePattern();
            int bt = pp.headerBorderStyle.getWidth();
            entry.setBorder(new StyledLineBorder(bc, bp, bt));
        }
        return entry;
    }

    private static int[] compressMultiModelDataPanel(StatGraph graph, DataModel model, DataLatticeProperties pp, StringVariable[] classVars) {
        int totalLevels = 1;
        int[] levels = new int[classVars.length];
        for (int i = 0; i < classVars.length; ++i) {
            levels[i] = LayoutDataLatticeParser.getNumLevels(classVars[i], pp);
            totalLevels *= levels[i];
        }
        boolean[] skipCells = new boolean[totalLevels];
        String[] whereValues = new String[classVars.length];
        for (int i = 0; i < totalLevels; ++i) {
            for (int j = 0; j < classVars.length; ++j) {
                String classValue = "";
                if (pp.inLookup.containsKey(classVars[j])) {
                    int ii = LayoutDataLatticeParser.locate(levels, j, i);
                    classValue = ((String[])pp.inLookup.get(classVars[j]))[ii];
                } else {
                    try {
                        classValue = classVars[j].value.getValue(i);
                    }
                    catch (MissingValueException ii) {
                        // empty catch block
                    }
                }
                whereValues[j] = classValue;
            }
            StringVectorVariable[] whereVars = new StringVectorVariable[classVars.length];
            VariableProcessor vp = new VariableProcessor();
            for (int j = 0; j < whereVars.length; ++j) {
                int col = model.getColumn(classVars[j].getName());
                StringVectorVariable sv = new StringVectorVariable();
                sv.setName(classVars[j].getName());
                sv.connectFrom(model.getColumnAsClassColumn(col, pp.includeMissing));
                whereVars[j] = sv;
                vp.addVariable((Variable)sv);
            }
            String where = LayoutDataLatticeParser.buildWhereExpression((StringVariable[])whereVars, whereValues);
            vp.setWhereExpression(where);
            skipCells[i] = whereVars[0].getValueCount() == 0;
        }
        int[] cellIndexMap = new int[model.getRowCount()];
        int idx = 0;
        for (int i = 0; i < totalLevels; ++i) {
            if (skipCells[i]) continue;
            cellIndexMap[idx++] = i;
        }
        return cellIndexMap;
    }

    private static int[] compressDataPanel(StatGraph graph, DataModel model, DataLatticeProperties pp, StringVariable[] classVars) {
        if (pp.multiDataModel) {
            return LayoutDataLatticeParser.compressMultiModelDataPanel(graph, model, pp, classVars);
        }
        int[] levels = new int[classVars.length];
        int totalLevels = 1;
        VariableProcessor vp = new VariableProcessor();
        StringVariable[] sv = new StringVariable[classVars.length];
        for (int i = 0; i < classVars.length; ++i) {
            levels[i] = LayoutDataLatticeParser.getNumLevels(classVars[i], pp);
            totalLevels *= levels[i];
            sv[i] = new StringVariable();
            sv[i].connectFrom(classVars[i]);
            vp.addVariable((Variable)sv[i]);
        }
        int newLevels = 0;
        boolean[] skipCells = new boolean[totalLevels];
        for (int i = 0; i < totalLevels; ++i) {
            String where = LayoutDataLatticeParser.buildWhereExpression(classVars, levels, i, pp);
            vp.setWhereExpression(where);
            if (sv[0].getValueCount() == 0) {
                skipCells[i] = true;
                continue;
            }
            skipCells[i] = false;
            ++newLevels;
        }
        int[] cellIndexMap = new int[newLevels];
        int idx = 0;
        for (int i = 0; i < totalLevels; ++i) {
            if (skipCells[i]) continue;
            cellIndexMap[idx++] = i;
        }
        return cellIndexMap;
    }

    public static void setupGridAxes(StatGraph graph, DataLatticeProperties pp, TrellisPlot plot, int rows, int cols) {
        GridAxis ga2;
        GridAxis ga;
        for (int row = 0; row < rows; ++row) {
            int theRow = pp.startAtTop ? row : rows - 1 - row;
            ga = new GridAxis(2);
            plot.addRowAxis(theRow, (Component)ga, true);
            ga2 = new GridAxis(2);
            ga2.getAxis().setPrimary(false);
            plot.addRowAxis(theRow, (Component)ga2, false);
            if (!pp.isDataPanel && row + pp.startRow >= pp.maxNumRows) {
                ga.setVisible(false);
                ga2.setVisible(false);
            }
            ga.setViewportEnabled(!graph.server && graph.yAxisViewportEnabled);
            ga.setLayoutNeeded(true);
            ga2.setViewportEnabled(!graph.server && graph.yAxisViewportEnabled);
            ga2.setLayoutNeeded(true);
            ga.setAntiAliased(graph.axisAntialiased);
            ga2.setAntiAliased(graph.axisAntialiased);
            ga.setSubpixelRendering(graph.subpixelRendering);
            ga2.setSubpixelRendering(graph.subpixelRendering);
            graph.addSubpixelRenderer(ga);
            graph.addSubpixelRenderer(ga2);
        }
        for (int col = 0; col < cols; ++col) {
            ga = new GridAxis(1);
            plot.addColumnAxis(col, (Component)ga, true);
            ga2 = new GridAxis(1);
            ga2.getAxis().setPrimary(false);
            plot.addColumnAxis(col, (Component)ga2, false);
            if (!pp.isDataPanel && col + pp.startCol >= pp.maxNumCols) {
                ga.setVisible(false);
                ga2.setVisible(false);
            }
            ga.setViewportEnabled(!graph.server && graph.xAxisViewportEnabled);
            ga.setLayoutNeeded(true);
            ga2.setViewportEnabled(!graph.server && graph.xAxisViewportEnabled);
            ga2.setLayoutNeeded(true);
            ga.setAntiAliased(graph.axisAntialiased);
            ga2.setAntiAliased(graph.axisAntialiased);
            ga.setSubpixelRendering(graph.subpixelRendering);
            ga2.setSubpixelRendering(graph.subpixelRendering);
            graph.addSubpixelRenderer(ga);
            graph.addSubpixelRenderer(ga2);
        }
    }

    public static void setupAxisLabelSideBars(StatGraph graph, TrellisPlot plot, DataLatticeProperties pp, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis, int numRows, int numCols, String[] xAxisLabel, String[] yAxisLabel, String[] xAxisLabel2, String[] yAxisLabel2) {
        if (numRows > 1) {
            if (rowAxis.isSecondary()) {
                pp.rowAxisSideBar = LayoutDataLatticeParser.isAxisLabelOn(pp.row2AxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.row2AxisAltDisplay2);
            } else {
                boolean bl = pp.rowAxisSideBar = rowAxis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.rowAxisAltDisplay);
            }
            pp.rowAxis2SideBar = row2Axis.isSecondary() ? LayoutDataLatticeParser.isAxisLabelOn(pp.rowAxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.rowAxisAltDisplay2) : row2Axis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.row2AxisAltDisplay);
        } else {
            if (rowAxis.isSecondary()) {
                pp.rowAxisSideBar = (LayoutDataLatticeParser.isAxisLabelOn(pp.row2AxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.row2AxisAltDisplay2)) && row2Axis.getLabelPosition() != 1;
            } else {
                boolean bl = pp.rowAxisSideBar = (rowAxis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.rowAxisAltDisplay)) && rowAxis.getLabelPosition() != 1;
            }
            pp.rowAxis2SideBar = row2Axis.isSecondary() ? (LayoutDataLatticeParser.isAxisLabelOn(pp.rowAxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.rowAxisAltDisplay2)) && rowAxis.getLabelPosition() != 1 : (row2Axis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.row2AxisAltDisplay)) && row2Axis.getLabelPosition() != 1;
        }
        pp.rowAxisSideBar = pp.rowAxisSideBar && rowAxis.getLabelPosition() != 3;
        boolean bl = pp.rowAxis2SideBar = pp.rowAxis2SideBar && row2Axis.getLabelPosition() != 3;
        if (numCols > 1) {
            if (colAxis.isSecondary()) {
                pp.colAxisSideBar = LayoutDataLatticeParser.isAxisLabelOn(pp.col2AxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.col2AxisAltDisplay2);
            } else {
                boolean bl2 = pp.colAxisSideBar = colAxis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.colAxisAltDisplay);
            }
            pp.colAxis2SideBar = col2Axis.isSecondary() ? LayoutDataLatticeParser.isAxisLabelOn(pp.colAxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.colAxisAltDisplay2) : col2Axis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.col2AxisAltDisplay);
        } else {
            if (colAxis.isSecondary()) {
                pp.colAxisSideBar = (LayoutDataLatticeParser.isAxisLabelOn(pp.col2AxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.col2AxisAltDisplay2)) && col2Axis.getLabelPosition() != 1;
            } else {
                boolean bl3 = pp.colAxisSideBar = (colAxis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.colAxisAltDisplay)) && colAxis.getLabelPosition() != 1;
            }
            pp.colAxis2SideBar = col2Axis.isSecondary() ? LayoutDataLatticeParser.isAxisLabelOn(pp.colAxisDisplay2) || LayoutDataLatticeParser.isAxisLabelOn(pp.colAxisAltDisplay2) && colAxis.getLabelPosition() != 1 : (col2Axis.getAxisStyle().isTitleOn() || LayoutDataLatticeParser.isAxisLabelOn(pp.col2AxisAltDisplay)) && col2Axis.getLabelPosition() != 1;
        }
        pp.colAxisSideBar = pp.colAxisSideBar && colAxis.getLabelPosition() != 3;
        pp.colAxis2SideBar = pp.colAxis2SideBar && col2Axis.getLabelPosition() != 3;
        LayoutDataLatticeParser.addAxisLabelSideBars(graph, plot, rowAxis, colAxis, row2Axis, col2Axis, pp, xAxisLabel, yAxisLabel, xAxisLabel2, yAxisLabel2);
    }

    private static void hideRowColumnAxes(TrellisPlot plot) {
        GridAxis ga2;
        boolean empty;
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        for (int i = 0; i < rows; ++i) {
            empty = true;
            for (int j = 0; j < cols; ++j) {
                if (plot.getCellItem(i, j) instanceof Entry) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            GridAxis ga = (GridAxis)plot.getRowAxis(i, true);
            ga2 = (GridAxis)plot.getRowAxis(i, false);
            ga.setVisible(false);
            ga2.setVisible(false);
        }
        for (int j = 0; j < cols; ++j) {
            empty = true;
            for (int i = 0; i < rows; ++i) {
                if (plot.getCellItem(i, j) instanceof Entry) continue;
                empty = false;
                break;
            }
            if (!empty) continue;
            GridAxis ga = (GridAxis)plot.getColumnAxis(j, true);
            ga2 = (GridAxis)plot.getColumnAxis(j, false);
            ga.setVisible(false);
            ga2.setVisible(false);
        }
    }

    private static void setupGridLabelEntry(StatGraph graph, TrellisPlot plot, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis) {
        boolean reverse;
        AxisTable at;
        ArrayList overlays;
        Simple2DOverlayComposite soc;
        Component comp;
        boolean added;
        int cols = ((TrellisLayout)plot.getLayout()).getGridColumns();
        int rows = ((TrellisLayout)plot.getLayout()).getGridRows();
        boolean reverseCol = colAxis.isReverse();
        boolean reverseCol2 = col2Axis.isReverse();
        boolean reverseRow = rowAxis.isReverse();
        boolean reverseRow2 = row2Axis.isReverse();
        for (int c = 0; c < cols; ++c) {
            boolean addBottom = false;
            boolean addTop = false;
            added = false;
            for (int r = 0; r < rows; ++r) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof BaseOverlayContainer) || (soc = ((BaseOverlayContainer)comp).getComposite()) == null) continue;
                overlays = soc.getOverlays();
                for (int i = 0; i < overlays.size(); ++i) {
                    if (!(overlays.get(i) instanceof AxisTable)) continue;
                    at = (AxisTable)overlays.get(i);
                    at.setUniformPlotSize(true);
                    if (!at.isShowLabel() && at.getHeaderLabel() == null || !at.isShowLabel()) continue;
                    at.setLabelToGridLabel(true);
                    if (at.getAxis() != 3 && at.getAxis() != 4) continue;
                    boolean bl = reverse = at.getAxis() == 3 ? reverseRow : reverseRow2;
                    if (at.getLabelPosition() == 2 && !reverse || at.getLabelPosition() == 1 && reverse) {
                        if (!added) {
                            at.setDisplayGridLabel(true);
                            addTop = true;
                        } else {
                            at.setShowLabel(false);
                            at.setShowHeader(false);
                        }
                    } else if (at.getLabelPosition() == 1 && !reverse || at.getLabelPosition() == 2 && reverse) {
                        if (!added) {
                            at.setDisplayGridLabel(true);
                            addBottom = true;
                        } else {
                            at.setShowLabel(false);
                            at.setShowHeader(false);
                        }
                    }
                    if (at.getHeaderLabel() == null || added) continue;
                    at.setDisplayGridLabel(true);
                    addTop = true;
                }
                if (addTop) {
                    GridLabelEntry gridLabel = new GridLabelEntry(0);
                    gridLabel.setTextAntiAliased(graph.axisAntialiased);
                    plot.addColumnGridLabel(c, (Component)gridLabel, false);
                    added = true;
                    addTop = false;
                }
                if (!addBottom) continue;
                GridLabelEntry gridLabel = new GridLabelEntry(2);
                gridLabel.setTextAntiAliased(graph.axisAntialiased);
                plot.addColumnGridLabel(c, (Component)gridLabel, true);
                added = true;
                addBottom = false;
            }
        }
        for (int r = 0; r < rows; ++r) {
            boolean addLeft = false;
            boolean addRight = false;
            added = false;
            for (int c = 0; c < cols; ++c) {
                comp = plot.getCellItem(r, c);
                if (!(comp instanceof BaseOverlayContainer) || (soc = ((BaseOverlayContainer)comp).getComposite()) == null) continue;
                overlays = soc.getOverlays();
                for (int i = 0; i < overlays.size(); ++i) {
                    if (overlays.get(i) instanceof AxisTable) {
                        at = (AxisTable)overlays.get(i);
                        at.setUniformPlotSize(true);
                        if (!at.isShowLabel() && at.getHeaderLabel() == null || !at.isShowLabel()) continue;
                        at.setLabelToGridLabel(true);
                        if (at.getAxis() != 1 && at.getAxis() != 2) continue;
                        boolean bl = reverse = at.getAxis() == 1 ? reverseCol : reverseCol2;
                        if (at.getLabelPosition() == 1 && !reverse || at.getLabelPosition() == 2 && reverse) {
                            if (!added) {
                                at.setDisplayGridLabel(true);
                                addLeft = true;
                                continue;
                            }
                            at.setShowLabel(false);
                            at.setShowHeader(false);
                            continue;
                        }
                        if ((at.getLabelPosition() != 2 || reverse) && (at.getLabelPosition() != 1 || !reverse)) continue;
                        if (!added) {
                            at.setDisplayGridLabel(true);
                            addRight = true;
                            continue;
                        }
                        at.setShowLabel(false);
                        at.setShowHeader(false);
                        continue;
                    }
                    if (!(overlays.get(i) instanceof BlockOverlay)) continue;
                    BlockOverlay block = (BlockOverlay)overlays.get(i);
                    if ((block.isUniformPlotSize() || block.isInnerMarginOverlay()) && (block.getValueFitStrategy() == 2 || block.getValueFitStrategy() == 3)) {
                        block.setValueFitStrategy(0);
                    }
                    if (!block.isLabelOn()) continue;
                    block.setLabelToGridLabel(true);
                    if (block.getLabelPosition() == 2) {
                        if (!added) {
                            block.setDisplayGridLabel(true);
                            addLeft = true;
                            continue;
                        }
                        block.setLabelOn(false);
                        continue;
                    }
                    if (block.getLabelPosition() != 3) continue;
                    if (!added) {
                        block.setDisplayGridLabel(true);
                        addRight = true;
                        continue;
                    }
                    block.setLabelOn(false);
                }
                if (addLeft) {
                    GridLabelEntry gridLabel = new GridLabelEntry(1);
                    gridLabel.setTextAntiAliased(graph.axisAntialiased);
                    plot.addRowGridLabel(r, (Component)gridLabel, true);
                    added = true;
                    addLeft = false;
                }
                if (!addRight) continue;
                GridLabelEntry gridLabel = new GridLabelEntry(3);
                gridLabel.setTextAntiAliased(graph.axisAntialiased);
                plot.addRowGridLabel(r, (Component)gridLabel, false);
                added = true;
                addRight = false;
            }
        }
    }

    public static void applyAxisOptions(TrellisPlot plot, VRectAxis rowAxis, VRectAxis columnAxis, VRectAxis row2Axis, VRectAxis column2Axis, DataLatticeProperties pp) {
        VRectAxis a;
        boolean major;
        String rowFit = rowAxis.getFitPolicy();
        if (rowFit == null) {
            rowAxis.setFitPolicy("thin");
        }
        if ((rowFit = row2Axis.getFitPolicy()) == null) {
            row2Axis.setFitPolicy("thin");
        }
        TrellisLayout tl = (TrellisLayout)plot.getLayout();
        for (int i = 0; i < tl.getGridRows(); ++i) {
            major = pp.startAtTop ? i % 2 == 0 : (tl.getGridRows() - i - 1) % 2 == 0;
            Component ra = plot.getRowAxis(i, true);
            if (ra != null && LayoutLatticeParser.hasOverlayOnAxis(plot, 2, true, i)) {
                a = ((GridAxis)ra).getAxis();
                LayoutOverlayParser.copyAxisOptions(rowAxis, a);
                if (!major) {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.rowAxisAltDisplay, a);
                }
                if (pp.rowAxisSideBar) {
                    a.getAxisStyle().setTitleOn(false);
                }
            }
            if ((ra = plot.getRowAxis(i, false)) != null && LayoutLatticeParser.hasOverlayOnAxis(plot, 2, false, i)) {
                a = ((GridAxis)ra).getAxis();
                LayoutOverlayParser.copyAxisOptions(row2Axis, a);
                if (!major) {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.row2AxisAltDisplay, a);
                }
                if (pp.rowAxis2SideBar) {
                    a.getAxisStyle().setTitleOn(false);
                }
            }
            if ((ra = plot.getRowAxis(i, true)) != null && !LayoutLatticeParser.hasOverlayOnAxis(plot, 2, true, i)) {
                ((GridAxis)ra).setMirror(true);
                a = ((GridAxis)ra).getAxis();
                LayoutOverlayParser.copyAxisOptions(row2Axis, a);
                if (major) {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.row2AxisDisplay2, a);
                } else {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.row2AxisAltDisplay2, a);
                }
                if (pp.rowAxisSideBar) {
                    a.getAxisStyle().setTitleOn(false);
                }
                plot.setRowAxisLabelPosition(plot.getRow2AxisLabelPosition());
            }
            if ((ra = plot.getRowAxis(i, false)) == null || LayoutLatticeParser.hasOverlayOnAxis(plot, 2, false, i)) continue;
            ((GridAxis)ra).setMirror(true);
            a = ((GridAxis)ra).getAxis();
            LayoutOverlayParser.copyAxisOptions(rowAxis, a);
            if (major) {
                LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.rowAxisDisplay2, a);
            } else {
                LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.rowAxisAltDisplay2, a);
            }
            if (pp.rowAxis2SideBar) {
                a.getAxisStyle().setTitleOn(false);
            }
            plot.setRow2AxisLabelPosition(plot.getRowAxisLabelPosition());
        }
        for (int j = 0; j < tl.getGridColumns(); ++j) {
            major = j % 2 == 0;
            Component ca = plot.getColumnAxis(j, true);
            if (ca != null && LayoutLatticeParser.hasOverlayOnAxis(plot, 1, true, j)) {
                a = ((GridAxis)ca).getAxis();
                LayoutOverlayParser.copyAxisOptions(columnAxis, a);
                if (!major) {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.colAxisAltDisplay, a);
                }
                if (pp.colAxisSideBar) {
                    a.getAxisStyle().setTitleOn(false);
                }
            }
            if ((ca = plot.getColumnAxis(j, false)) != null && LayoutLatticeParser.hasOverlayOnAxis(plot, 1, false, j)) {
                a = ((GridAxis)ca).getAxis();
                LayoutOverlayParser.copyAxisOptions(column2Axis, a);
                if (!major) {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.col2AxisAltDisplay, a);
                }
                if (pp.colAxis2SideBar) {
                    a.getAxisStyle().setTitleOn(false);
                }
            }
            if ((ca = plot.getColumnAxis(j, true)) != null && !LayoutLatticeParser.hasOverlayOnAxis(plot, 1, true, j)) {
                ((GridAxis)ca).setMirror(true);
                a = ((GridAxis)ca).getAxis();
                LayoutOverlayParser.copyAxisOptions(column2Axis, a);
                if (major) {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.col2AxisDisplay2, a);
                } else {
                    LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.col2AxisAltDisplay2, a);
                }
                if (pp.colAxisSideBar) {
                    a.getAxisStyle().setTitleOn(false);
                }
                plot.setColumnAxisLabelPosition(plot.getColumn2AxisLabelPosition());
            }
            if ((ca = plot.getColumnAxis(j, false)) == null || LayoutLatticeParser.hasOverlayOnAxis(plot, 1, false, j)) continue;
            ((GridAxis)ca).setMirror(true);
            a = ((GridAxis)ca).getAxis();
            LayoutOverlayParser.copyAxisOptions(columnAxis, a);
            if (major) {
                LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.colAxisDisplay2, a);
            } else {
                LayoutOverlayEquatedParser.parseAxisDisplay2Opts(pp.colAxisAltDisplay2, a);
            }
            if (pp.colAxis2SideBar) {
                a.getAxisStyle().setTitleOn(false);
            }
            plot.setColumn2AxisLabelPosition(plot.getColumnAxisLabelPosition());
        }
    }

    static boolean isValidStamp(String str, boolean dataPanelLayout) {
        if (str.equals("LayoutPrototype") || str.equals("LayoutPrototypeExtruded")) {
            return true;
        }
        if (str.equals("LayoutPrototype3D")) {
            return dataPanelLayout;
        }
        return str.equals("LayoutPrototypeRegion");
    }

    static boolean isSupportedInsideDataLattice(Overlay plot) {
        return plot instanceof ScatterOverlay || plot instanceof BandOverlay || plot instanceof BarOverlay || plot instanceof BiVarHistogramOverlay || plot instanceof BlockOverlay || plot instanceof BoxOverlay || plot instanceof CarpetOverlay || plot instanceof ContourOverlay || plot instanceof DropLineOverlay || plot instanceof EllipseParmOverlay || plot instanceof HistogramOverlay || plot instanceof LineParmOverlay || plot instanceof ReferenceLineOverlay || plot instanceof SurfaceOverlay || plot instanceof PieOverlay || plot instanceof BubbleOverlay || plot instanceof DendrogramOverlay || plot instanceof WaterfallChartOverlay || plot instanceof HeatMapParmOverlay || plot instanceof HighLowOverlay || plot instanceof HeatBoxOverlay || plot instanceof LineChartOverlay || plot instanceof RangeAttrMapViewOverlay || plot instanceof TimeSeriesOverlay || plot instanceof PolygonOverlay || plot instanceof AxisTable;
    }

    static boolean isSupportedInsideDataLattice(Region plot) {
        return plot instanceof PieRegion;
    }

    static String[] getOrdinalClasses(DataModel model, int col, DataLatticeProperties pp) {
        double[] values = model.getDoubleColumn(col);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(col);
        SASFormat fmt = cmd.getFormat();
        if (fmt == null) {
            fmt = DataModel.defaultFormat;
        }
        ArrayList<Double> a = new ArrayList<Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            if (!pp.includeMissing && values[i] != values[i]) continue;
            if (values[i] != values[i]) {
                a.add(new Double(-1.7976931348623157E308));
                continue;
            }
            a.add(new Double(values[i]));
        }
        Collections.sort(a);
        double[] v = new double[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            v[i] = (Double)a.get(i);
        }
        String formattedMiss = fmt.format((Object)new Double(Double.NaN)).trim();
        if (formattedMiss == null || formattedMiss.equals(".")) {
            formattedMiss = StatGraph.missingOption;
        }
        String[] classes = new String[v.length];
        for (int i = 0; i < v.length; ++i) {
            classes[i] = v[i] == -1.7976931348623157E308 ? formattedMiss : fmt.format((Object)new Double(v[i])).trim();
        }
        StringVectorVariable svv = new StringVectorVariable();
        svv.setBlankMissing(false);
        svv.connectFrom(classes);
        int cnt = svv.getUniqueValueCount();
        String[] ordinalClasses = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            try {
                ordinalClasses[i] = svv.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return ordinalClasses;
    }

    static String[] getSortedClasses(DataModel model, int col, DataLatticeProperties pp, int classType, int sortType) {
        String[] classes;
        String[] values;
        String[] stringArray = values = classType == 1 ? model.getDoubleAsClassColumn(col, pp.includeMissing) : model.getStringAsClassColumn(col, pp.includeMissing);
        if (sortType == 0) {
            classes = values;
        } else {
            int i;
            ArrayList<String> a = new ArrayList<String>(values.length);
            for (i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                a.add(values[i]);
            }
            Collections.sort(a, new Sort.StringComparator(1, Locale.getDefault(), StatGraph.collation));
            classes = new String[a.size()];
            if (sortType == 1) {
                for (i = 0; i < a.size(); ++i) {
                    classes[i] = (String)a.get(i);
                }
            } else {
                int n = 0;
                for (int i2 = a.size() - 1; i2 >= 0; --i2) {
                    classes[n++] = (String)a.get(i2);
                }
            }
        }
        StringVectorVariable svv = new StringVectorVariable();
        svv.setBlankMissing(false);
        svv.connectFrom(classes);
        int cnt = svv.getUniqueValueCount();
        String[] stringClasses = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            try {
                stringClasses[i] = svv.uniqueValue.getValue(i);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return stringClasses;
    }

    static String[] getIncludedClasses(Element incElem, String varID, String[] classValues, Class cls, DataLatticeProperties pp) {
        if (incElem == null) {
            return null;
        }
        for (Node node = incElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String str;
            String elemTag;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("ClassVar") || !StatGraph.getVarID(str = ((Element)node).getAttribute("name")).equalsIgnoreCase(varID)) continue;
            String[] vals = StatGraph.parseStringValueList((Element)node, "Value", true);
            ArrayList<String> v = new ArrayList<String>();
            for (int i = 0; i < vals.length; ++i) {
                if (cls == String.class && vals[i].trim().length() == 0) {
                    if (!pp.includeMissing) continue;
                    v.add(StatGraph.missingCharacter);
                    continue;
                }
                if (cls == Double.class && vals[i].equalsIgnoreCase(".")) {
                    if (!pp.includeMissing) continue;
                    v.add(StatGraph.missingOption);
                    continue;
                }
                boolean valid = false;
                for (int j = 0; j < classValues.length; ++j) {
                    if (!vals[i].equals(classValues[j])) continue;
                    valid = true;
                    break;
                }
                if (valid) {
                    v.add(vals[i]);
                    continue;
                }
                Message msg = new Message(RB.getStringResource(RB_KEY, "include.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)vals[i]));
            }
            String[] newVals = new String[v.size()];
            for (int i = 0; i < newVals.length; ++i) {
                newVals[i] = (String)v.get(i);
            }
            return newVals;
        }
        return null;
    }

    private static boolean isAxisLabelOn(String opt) {
        return opt.equalsIgnoreCase("STANDARD") || opt.equalsIgnoreCase("ALL") || opt.toUpperCase().indexOf("LABEL") >= 0;
    }

    private static boolean hasOverlayOnAxis(Component comp, byte dim, boolean primary) {
        OverlayContainer oc;
        if (comp instanceof OverlayContainer && (oc = (OverlayContainer)comp).getComposite() != null) {
            ArrayList ov = oc.getComposite().getOverlays();
            for (int o = 0; o < ov.size(); ++o) {
                if (dim == 1) {
                    String xaxis = ((Overlay)ov.get(o)).getXAxis();
                    if (primary && xaxis.equalsIgnoreCase("x")) {
                        return true;
                    }
                    if (primary || !xaxis.equalsIgnoreCase("x2")) continue;
                    return true;
                }
                String yaxis = ((Overlay)ov.get(o)).getYAxis();
                if (primary && yaxis.equalsIgnoreCase("y")) {
                    return true;
                }
                if (primary || !yaxis.equalsIgnoreCase("y2")) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] getAxisLabel(Component comp, byte dim, boolean primary) {
        if (comp instanceof OverlayContainer) {
            Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
            for (int i = 0; i < axes.length; ++i) {
                AbstractAxis a = (AbstractAxis)axes[i];
                if (a.getDimension() != dim || ((VRectAxis)a).getPrimary() != primary) continue;
                if (a.getDataRange(dim).getLabel() == null) {
                    return null;
                }
                return new String[]{a.getDataRange(dim).getLabel()};
            }
        }
        return null;
    }

    public static String[] getAxisLabel(Component comp, byte dim, boolean primary, boolean stackedLabels) {
        if (!stackedLabels) {
            return LayoutDataLatticeParser.getAxisLabel(comp, dim, primary);
        }
        if (comp instanceof OverlayContainer) {
            Object[] axes = ((OverlayContainer)comp).getComposite().getAxes();
            for (int i = 0; i < axes.length; ++i) {
                AbstractAxis a = (AbstractAxis)axes[i];
                if (a.getDimension() != dim || ((VRectAxis)a).getPrimary() != primary) continue;
                String[] labels = null;
                Overlay[] overlays = ((OverlayContainer)comp).getComposite().getConnectedOverlays(a);
                if (overlays != null && overlays.length > 0) {
                    ArrayList<String> llist = new ArrayList<String>();
                    for (int j = 0; j < overlays.length; ++j) {
                        String[] lab = overlays[j].getLabels(dim);
                        if (lab == null) continue;
                        for (int l = 0; l < lab.length; ++l) {
                            llist.add(lab[l]);
                        }
                    }
                    labels = new String[llist.size()];
                    for (int l = 0; l < llist.size(); ++l) {
                        labels[l] = (String)llist.get(l);
                    }
                }
                return labels;
            }
        }
        return null;
    }

    public static void addAxisLabelSideBars(StatGraph graph, TrellisPlot plot, VRectAxis rowAxis, VRectAxis colAxis, VRectAxis row2Axis, VRectAxis col2Axis, DataLatticeProperties pp, String[] xAxisLabel, String[] yAxisLabel, String[] xAxisLabel2, String[] yAxisLabel2) {
        ArrayList sideBars;
        int i;
        ArrayList sideBars2;
        Component[] entryList;
        Entry entry;
        VRectAxis axis;
        String rowAxisLabel = rowAxis.getUseTitle();
        String colAxisLabel = colAxis.getUseTitle();
        String row2AxisLabel = row2Axis.getUseTitle();
        String col2AxisLabel = col2Axis.getUseTitle();
        String[] stackedRowAxisLabels = null;
        String[] stackedRow2AxisLabels = null;
        if (colAxisLabel == null || colAxisLabel.equals("")) {
            String string = colAxisLabel = xAxisLabel == null ? null : xAxisLabel[0];
        }
        if (rowAxisLabel == null || rowAxisLabel.equals("")) {
            rowAxisLabel = yAxisLabel == null ? null : yAxisLabel[0];
            stackedRowAxisLabels = yAxisLabel;
        }
        if (col2AxisLabel == null || col2AxisLabel.equals("")) {
            String string = col2AxisLabel = xAxisLabel2 == null ? null : xAxisLabel2[0];
        }
        if (row2AxisLabel == null || row2AxisLabel.equals("")) {
            row2AxisLabel = yAxisLabel2 == null ? null : yAxisLabel2[0];
            stackedRow2AxisLabels = yAxisLabel2;
        }
        if (rowAxis.isSecondary()) {
            rowAxisLabel = row2AxisLabel;
            stackedRowAxisLabels = stackedRow2AxisLabels;
        }
        if (row2Axis.isSecondary()) {
            row2AxisLabel = rowAxisLabel;
            stackedRow2AxisLabels = stackedRowAxisLabels;
        }
        if (colAxis.isSecondary()) {
            colAxisLabel = col2AxisLabel;
        }
        if (col2Axis.isSecondary()) {
            col2AxisLabel = colAxisLabel;
        }
        if (pp.rowAxisSideBar) {
            axis = rowAxis.isSecondary() ? row2Axis : rowAxis;
            entry = new Entry(rowAxisLabel);
            entry.setTextAntiAliased(graph.axisAntialiased);
            entry.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, StatGraph.getExtraPadding()));
            entry.setAlignmentY(0.0f);
            entry.setShortText(axis.getShortTitle());
            entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
            entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
            entryList = new Component[]{entry};
            if (axis.getLabelPosition() == 1) {
                entry.setTheta(90.0);
                sideBars2 = plot.getGridBorderAnnotation(2);
                if (sideBars2 != null) {
                    plot.removeGridBorderAnnotation(2);
                }
                plot.addGridBorderAnnotation((Component)entry, 2);
                if (sideBars2 != null) {
                    for (i = 0; i < sideBars2.size(); ++i) {
                        plot.addGridBorderAnnotation((Component)sideBars2.get(i), 2);
                    }
                }
                if (axis.getTitleFitPolicy() == 1 || axis.getTitleFitPolicy() == 2) {
                    entry.setTextFitPolicy(Entry.TEXT_FIT_SPLITALWAYS);
                    entry.setTextSplitChar(axis.getTitleSplitChar());
                    entry.setTextSplitCharDrop(axis.isTitleSplitCharDrop());
                    entry.setTextSplitJustify(LayoutDataLatticeParser.getAxisLabelSplitJustify(axis));
                    entry.setHotelText(axis.isHotelText());
                }
            } else {
                if (axis.getLabelPosition() == 0) {
                    entry.setAlignmentY(0.0f);
                } else {
                    entry.setAlignmentY(1.0f);
                    if (stackedRowAxisLabels != null && stackedRowAxisLabels.length > 1) {
                        entryList = new Component[stackedRowAxisLabels.length];
                        entryList[0] = entry;
                        for (int i2 = 1; i2 < stackedRowAxisLabels.length; ++i2) {
                            entry = new Entry(stackedRowAxisLabels[i2]);
                            entry.setTextAntiAliased(graph.axisAntialiased);
                            entry.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, StatGraph.getExtraPadding()));
                            entry.setAlignmentY(0.0f);
                            entry.setShortText(axis.getShortTitle());
                            entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
                            entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
                            entryList[i2] = entry;
                            entry.setAlignmentY(1.0f);
                        }
                    }
                }
                plot.addRowAxisLabel(entryList);
            }
        }
        if (pp.rowAxis2SideBar) {
            axis = row2Axis.isSecondary() ? rowAxis : row2Axis;
            entry = new Entry(row2AxisLabel);
            entry.setTextAntiAliased(graph.axisAntialiased);
            entry.setBorder(BorderFactory.createEmptyBorder(0, StatGraph.getExtraPadding(), 0, 0));
            entry.setAlignmentY(1.0f);
            entry.setShortText(axis.getShortTitle());
            entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
            entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
            entryList = new Component[]{entry};
            if (axis.getLabelPosition() == 1) {
                entry.setTheta(90.0);
                sideBars2 = plot.getGridBorderAnnotation(4);
                if (sideBars2 != null) {
                    plot.removeGridBorderAnnotation(4);
                }
                plot.addGridBorderAnnotation((Component)entry, 4);
                if (sideBars2 != null) {
                    for (i = 0; i < sideBars2.size(); ++i) {
                        plot.addGridBorderAnnotation((Component)sideBars2.get(i), 4);
                    }
                }
                if (axis.getTitleFitPolicy() == 1 || axis.getTitleFitPolicy() == 2) {
                    entry.setTextFitPolicy(Entry.TEXT_FIT_SPLITALWAYS);
                    entry.setTextSplitChar(axis.getTitleSplitChar());
                    entry.setTextSplitCharDrop(axis.isTitleSplitCharDrop());
                    entry.setTextSplitJustify(LayoutDataLatticeParser.getAxisLabelSplitJustify(axis));
                    entry.setHotelText(axis.isHotelText());
                }
            } else {
                if (axis.getLabelPosition() == 0) {
                    entry.setAlignmentY(0.0f);
                } else {
                    entry.setAlignmentY(1.0f);
                    if (stackedRow2AxisLabels != null && stackedRow2AxisLabels.length > 1) {
                        entryList = new Component[stackedRow2AxisLabels.length];
                        entryList[0] = entry;
                        for (int i3 = 1; i3 < stackedRow2AxisLabels.length; ++i3) {
                            entry = new Entry(stackedRow2AxisLabels[i3]);
                            entry.setTextAntiAliased(graph.axisAntialiased);
                            entry.setBorder(BorderFactory.createEmptyBorder(0, StatGraph.getExtraPadding(), 0, 0));
                            entry.setAlignmentY(1.0f);
                            entry.setShortText(axis.getShortTitle());
                            entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
                            entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
                            entryList[i3] = entry;
                            entry.setAlignmentY(1.0f);
                        }
                    }
                }
                plot.addRow2AxisLabel(entryList);
            }
        }
        if (pp.colAxisSideBar) {
            axis = colAxis.isSecondary() ? col2Axis : colAxis;
            entry = new Entry(colAxisLabel);
            entry.setTextAntiAliased(graph.axisAntialiased);
            entry.setBorder(BorderFactory.createEmptyBorder(StatGraph.getExtraPadding(), 0, 0, 0));
            entry.setShortText(axis.getShortTitle());
            entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
            entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
            if (axis.getLabelPosition() == 1) {
                sideBars = plot.getGridBorderAnnotation(3);
                if (sideBars != null) {
                    plot.removeGridBorderAnnotation(3);
                }
                plot.addGridBorderAnnotation((Component)entry, 3);
                if (sideBars != null) {
                    for (int i4 = 0; i4 < sideBars.size(); ++i4) {
                        plot.addGridBorderAnnotation((Component)sideBars.get(i4), 3);
                    }
                }
                if (axis.getTitleFitPolicy() == 1 || axis.getTitleFitPolicy() == 2) {
                    entry.setTextFitPolicy(Entry.TEXT_FIT_SPLITALWAYS);
                    entry.setTextSplitChar(axis.getTitleSplitChar());
                    entry.setTextSplitCharDrop(axis.isTitleSplitCharDrop());
                    entry.setTextSplitJustify(LayoutDataLatticeParser.getAxisLabelSplitJustify(axis));
                }
            } else {
                entry.setAlignmentY(1.0f);
                if (axis.getLabelPosition() == 0) {
                    entry.setAlignmentX(1.0f);
                } else {
                    entry.setAlignmentX(0.0f);
                }
                plot.addColumnAxisLabel((Component)entry);
            }
        }
        if (pp.colAxis2SideBar) {
            axis = col2Axis.isSecondary() ? colAxis : col2Axis;
            entry = new Entry(col2AxisLabel);
            entry.setTextAntiAliased(graph.axisAntialiased);
            entry.setBorder(BorderFactory.createEmptyBorder(0, 0, StatGraph.getExtraPadding(), 0));
            entry.setShortText(axis.getShortTitle());
            entry.setForeground(axis.getAxisStyle().getTitleStyle().getColor());
            entry.setFont(axis.getAxisStyle().getTitleStyle().getFont());
            if (axis.getLabelPosition() == 1) {
                sideBars = plot.getGridBorderAnnotation(1);
                if (sideBars != null) {
                    plot.removeGridBorderAnnotation(1);
                }
                plot.addGridBorderAnnotation((Component)entry, 1);
                if (sideBars != null) {
                    for (int i5 = 0; i5 < sideBars.size(); ++i5) {
                        plot.addGridBorderAnnotation((Component)sideBars.get(i5), 1);
                    }
                }
                if (axis.getTitleFitPolicy() == 1 || axis.getTitleFitPolicy() == 2) {
                    entry.setTextFitPolicy(Entry.TEXT_FIT_SPLITALWAYS);
                    entry.setTextSplitChar(axis.getTitleSplitChar());
                    entry.setTextSplitCharDrop(axis.isTitleSplitCharDrop());
                    entry.setTextSplitJustify(LayoutDataLatticeParser.getAxisLabelSplitJustify(axis));
                }
            } else {
                entry.setAlignmentY(0.0f);
                if (axis.getLabelPosition() == 0) {
                    entry.setAlignmentX(1.0f);
                } else {
                    entry.setAlignmentX(0.0f);
                }
                plot.addColumn2AxisLabel((Component)entry);
            }
        }
    }

    private static float getAxisLabelSplitJustify(VRectAxis axis) {
        int just = axis.getMultilineTitleJustification();
        if (axis.getDimension() == 1) {
            if (just == 0) {
                return 0.0f;
            }
            if (just == 2) {
                return 1.0f;
            }
        } else {
            if (just == 3) {
                return 0.0f;
            }
            if (just == 0) {
                return 1.0f;
            }
        }
        return 0.5f;
    }

    public static int[] getUserDefinedAxisTypes(Element elem, boolean primary) {
        int[] types = new int[2];
        types[1] = -1;
        types[0] = -1;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String str;
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (primary && elemTag.equals("RowAxisOpts") || !primary && elemTag.equals("Row2AxisOpts")) {
                str = ((Element)node).getAttribute("type");
                if (str.equalsIgnoreCase("LINEAR")) {
                    types[0] = 0;
                    continue;
                }
                if (str.equalsIgnoreCase("TIME")) {
                    types[0] = 1;
                    continue;
                }
                if (str.equalsIgnoreCase("DISCRETE")) {
                    types[0] = 2;
                    continue;
                }
                if (!str.equalsIgnoreCase("LOG")) continue;
                types[0] = 3;
                continue;
            }
            if ((!primary || !elemTag.equals("ColumnAxisOpts")) && (primary || !elemTag.equals("Column2AxisOpts"))) continue;
            str = ((Element)node).getAttribute("type");
            if (str.equalsIgnoreCase("LINEAR")) {
                types[1] = 0;
                continue;
            }
            if (str.equalsIgnoreCase("TIME")) {
                types[1] = 1;
                continue;
            }
            if (str.equalsIgnoreCase("DISCRETE")) {
                types[1] = 2;
                continue;
            }
            if (!str.equalsIgnoreCase("LOG")) continue;
            types[1] = 3;
        }
        return types;
    }

    static boolean[] isSortByPlot(Element elem) {
        Element e;
        String str;
        Node node;
        NodeList nl = elem.getElementsByTagName("BarChartParm");
        if (nl.getLength() == 0) {
            return new boolean[]{false, false};
        }
        Element[] primaryPlots = new Element[4];
        Element protoElem = StatGraph.getOptionAttrsElement(elem, "LayoutPrototypeOverlay2D");
        if (protoElem == null) {
            protoElem = StatGraph.getOptionAttrsElement(elem, "LayoutPrototype");
        }
        for (node = protoElem.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Element) || !(str = (e = (Element)node).getAttribute("primary")).equalsIgnoreCase("true")) continue;
            str = e.getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                primaryPlots[1] = e;
            } else {
                primaryPlots[0] = e;
            }
            str = e.getAttribute("yAxis");
            if (str.equalsIgnoreCase("Y2")) {
                primaryPlots[3] = e;
                continue;
            }
            primaryPlots[2] = e;
        }
        for (node = protoElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !LayoutOverlayParser.isPrimaryPlot(e = (Element)node)) continue;
            str = e.getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (primaryPlots[1] == null) {
                    primaryPlots[1] = e;
                }
            } else if (primaryPlots[0] == null) {
                primaryPlots[0] = e;
            }
            if ((str = e.getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (primaryPlots[3] != null) continue;
                primaryPlots[3] = e;
                continue;
            }
            if (primaryPlots[2] != null) continue;
            primaryPlots[2] = e;
        }
        String[] axisOpts = new String[]{"ColumnAxisOpts", "Column2AxisOpts", "RowAxisOpts", "Row2AxisOpts"};
        for (int i = 0; i < 4; ++i) {
            if (primaryPlots[i] == null) {
                axisOpts[i] = null;
                continue;
            }
            if (!primaryPlots[i].getNodeName().equalsIgnoreCase("BarChartParm")) {
                axisOpts[i] = null;
                continue;
            }
            str = primaryPlots[i].getAttribute("categoryOrderRole");
            if (!str.equalsIgnoreCase("RESPONSE") && !str.equalsIgnoreCase("Y")) {
                axisOpts[i] = null;
                continue;
            }
            if (i < 2) {
                if (!primaryPlots[i].getAttribute("orient").equalsIgnoreCase("horizontal")) continue;
                axisOpts[i] = null;
                continue;
            }
            if (primaryPlots[i].getAttribute("orient").equalsIgnoreCase("horizontal")) continue;
            axisOpts[i] = null;
        }
        boolean[] sortBy = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            if (axisOpts[i] == null) continue;
            Element axisOptsElem = StatGraph.getOptionAttrsElement(elem, axisOpts[i]);
            if (axisOptsElem != null) {
                Element e2 = StatGraph.getOptionAttrsElement(axisOptsElem, "DiscreteOpts");
                if (e2 != null) {
                    str = e2.getAttribute("sortOrder");
                    if (str.length() != 0 && !str.equalsIgnoreCase("AUTO") && !str.equalsIgnoreCase("ASCENDINGUNFORMATTED") && !str.equalsIgnoreCase("DESCENDINGUNFORMATTED")) continue;
                    sortBy[i] = true;
                    continue;
                }
                sortBy[i] = true;
                continue;
            }
            sortBy[i] = true;
        }
        return new boolean[]{sortBy[0] || sortBy[1], sortBy[2] || sortBy[3]};
    }

    private static boolean isDiscreteAxis(VRectAxis ra, byte dim) {
        return ra.getType() == 6 && ra.getDataRange(dim) instanceof DiscreteRange;
    }

    static void weightingByCategories(TrellisPlot trellis, boolean vertical, boolean sortByPlot) {
        TrellisLayout tl = (TrellisLayout)trellis.getLayout();
        if (vertical) {
            OverlayContainer oc;
            int j;
            int[] mpcs = new int[tl.getGridColumns()];
            double[] colWeights = new double[tl.getGridColumns()];
            for (int j2 = 0; j2 < tl.getGridColumns(); ++j2) {
                VRectAxis axis;
                int k;
                Object[] axes;
                OverlayContainer oc2;
                Simple2DOverlayComposite soc;
                int i;
                double offset;
                DiscreteRange dr;
                VRectAxis a;
                if (sortByPlot) {
                    mpcs[j2] = 0;
                    for (int i2 = 0; i2 < tl.getGridRows(); ++i2) {
                        OverlayContainer oc3;
                        Simple2DOverlayComposite soc2;
                        if (!(tl.getCell(i2, j2).getItem() instanceof OverlayContainer) || (soc2 = (oc3 = (OverlayContainer)tl.getCell(i2, j2).getItem()).getComposite()) == null) continue;
                        Object[] axes2 = soc2.getAxes();
                        for (int k2 = 0; k2 < axes2.length; ++k2) {
                            VRectAxis a2 = (VRectAxis)axes2[k2];
                            if (a2.getDimension() != 1) continue;
                            a2.getAxisStyle().setTitleOn(false);
                            DiscreteRange dr2 = (DiscreteRange)a2.getDataRange((byte)1);
                            mpcs[j2] = Math.max(mpcs[j2], LayoutDataLatticeParser.getNumberOfDisplayCategory(dr2, a2));
                        }
                    }
                    continue;
                }
                GridAxis ga = (GridAxis)trellis.getColumnAxis(j2, true);
                GridAxis ga2 = (GridAxis)trellis.getColumnAxis(j2, false);
                if (ga != null) {
                    a = ga.getAxis();
                    if (!LayoutDataLatticeParser.isDiscreteAxis(a, (byte)1)) continue;
                    ga.setWeightedByCategories(true);
                    if (ga2 != null && ga2.isMirror()) {
                        ga2.setWeightedByCategories(true);
                    }
                    dr = (DiscreteRange)a.getDataRange((byte)1);
                    mpcs[j2] = LayoutDataLatticeParser.getNumberOfDisplayCategory(dr, a);
                    if (mpcs[j2] < 1) continue;
                    a.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                    a.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                    offset = mpcs[j2] > 1 ? 0.5 / (double)mpcs[j2] : 0.0;
                    a.setUserStartOffset(offset);
                    a.setUserEndOffset(offset);
                    for (i = 0; i < tl.getGridRows(); ++i) {
                        if (!(tl.getCell(i, j2).getItem() instanceof OverlayContainer) || (soc = (oc2 = (OverlayContainer)tl.getCell(i, j2).getItem()).getComposite()) == null) continue;
                        axes = soc.getAxes();
                        for (k = 0; k < axes.length; ++k) {
                            if (!(axes[k] instanceof AbstractAxis) || (axis = (VRectAxis)axes[k]).getDimension() != a.getDimension() || axis.getPrimary() != a.getPrimary()) continue;
                            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                            axis.setUserStartOffset(offset);
                            axis.setUserEndOffset(offset);
                        }
                    }
                    continue;
                }
                if (ga2 == null || !LayoutDataLatticeParser.isDiscreteAxis(a = ga2.getAxis(), (byte)1)) continue;
                ga2.setWeightedByCategories(true);
                dr = (DiscreteRange)a.getDataRange((byte)1);
                mpcs[j2] = LayoutDataLatticeParser.getNumberOfDisplayCategory(dr, a);
                if (mpcs[j2] < 1) continue;
                a.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                a.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                offset = mpcs[j2] > 1 ? 0.5 / (double)mpcs[j2] : 0.0;
                a.setUserStartOffset(offset);
                a.setUserEndOffset(offset);
                for (i = 0; i < tl.getGridRows(); ++i) {
                    if (!(tl.getCell(i, j2).getItem() instanceof OverlayContainer) || (soc = (oc2 = (OverlayContainer)tl.getCell(i, j2).getItem()).getComposite()) == null) continue;
                    axes = soc.getAxes();
                    for (k = 0; k < axes.length; ++k) {
                        if (!(axes[k] instanceof AbstractAxis) || (axis = (VRectAxis)axes[k]).getDimension() != a.getDimension() || axis.getPrimary() != a.getPrimary()) continue;
                        axis.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                        axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                        axis.setUserStartOffset(offset);
                        axis.setUserEndOffset(offset);
                    }
                }
            }
            double totalWeights = 0.0;
            for (j = 0; j < tl.getGridColumns(); ++j) {
                totalWeights += (double)mpcs[j];
                if (!sortByPlot) continue;
                for (int i = 0; i < tl.getGridRows(); ++i) {
                    Simple2DOverlayComposite soc;
                    if (!(tl.getCell(i, j).getItem() instanceof OverlayContainer) || (soc = (oc = (OverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    Object[] axes = soc.getAxes();
                    for (int k = 0; k < axes.length; ++k) {
                        VRectAxis a = (VRectAxis)axes[k];
                        if (a.getDimension() != 1) continue;
                        a.setMPC(mpcs[j]);
                    }
                }
            }
            if (totalWeights > 0.0) {
                for (j = 0; j < tl.getGridColumns(); ++j) {
                    colWeights[j] = (double)mpcs[j] / totalWeights;
                }
                tl.setColumnWeights(colWeights);
            }
            for (j = 0; j < tl.getGridColumns(); ++j) {
                for (int i = 0; i < tl.getGridRows(); ++i) {
                    Simple2DOverlayComposite soc;
                    if (!(tl.getCell(i, j).getItem() instanceof OverlayContainer) || (soc = (oc = (OverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    ArrayList overlays = soc.getOverlays();
                    for (int k = 0; k < overlays.size(); ++k) {
                        BarOverlay bar;
                        Overlay o = (Overlay)overlays.get(k);
                        if (!(o instanceof BarOverlay) || (bar = (BarOverlay)o).getOrientation() != 0) continue;
                        bar.setWeightedByCategories(true);
                    }
                }
            }
        } else {
            OverlayContainer oc;
            int i;
            int[] mpcs = new int[tl.getGridRows()];
            double[] rowWeights = new double[tl.getGridRows()];
            for (int i3 = 0; i3 < tl.getGridRows(); ++i3) {
                VRectAxis axis;
                int k;
                Object[] axes;
                OverlayContainer oc4;
                Simple2DOverlayComposite soc;
                int j;
                double offset;
                DiscreteRange dr;
                VRectAxis a;
                if (sortByPlot) {
                    mpcs[i3] = 0;
                    for (int j3 = 0; j3 < tl.getGridColumns(); ++j3) {
                        OverlayContainer oc5;
                        Simple2DOverlayComposite soc3;
                        if (!(tl.getCell(i3, j3).getItem() instanceof OverlayContainer) || (soc3 = (oc5 = (OverlayContainer)tl.getCell(i3, j3).getItem()).getComposite()) == null) continue;
                        Object[] axes3 = soc3.getAxes();
                        for (int k3 = 0; k3 < axes3.length; ++k3) {
                            VRectAxis a3 = (VRectAxis)axes3[k3];
                            if (a3.getDimension() != 2) continue;
                            a3.getAxisStyle().setTitleOn(false);
                            DiscreteRange dr3 = (DiscreteRange)a3.getDataRange((byte)2);
                            mpcs[i3] = Math.max(mpcs[i3], LayoutDataLatticeParser.getNumberOfDisplayCategory(dr3, a3));
                        }
                    }
                    continue;
                }
                GridAxis ga = (GridAxis)trellis.getRowAxis(i3, true);
                GridAxis ga2 = (GridAxis)trellis.getRowAxis(i3, false);
                if (ga != null) {
                    a = ga.getAxis();
                    if (!LayoutDataLatticeParser.isDiscreteAxis(a, (byte)2)) continue;
                    ga.setWeightedByCategories(true);
                    if (ga2 != null && ga2.isMirror()) {
                        ga2.setWeightedByCategories(true);
                    }
                    dr = (DiscreteRange)a.getDataRange((byte)2);
                    mpcs[i3] = LayoutDataLatticeParser.getNumberOfDisplayCategory(dr, a);
                    if (mpcs[i3] < 1) continue;
                    a.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                    a.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                    offset = mpcs[i3] > 1 ? 0.5 / (double)mpcs[i3] : 0.0;
                    a.setUserStartOffset(offset);
                    a.setUserEndOffset(offset);
                    for (j = 0; j < tl.getGridColumns(); ++j) {
                        if (!(tl.getCell(i3, j).getItem() instanceof OverlayContainer) || (soc = (oc4 = (OverlayContainer)tl.getCell(i3, j).getItem()).getComposite()) == null) continue;
                        axes = soc.getAxes();
                        for (k = 0; k < axes.length; ++k) {
                            if (!(axes[k] instanceof AbstractAxis) || (axis = (VRectAxis)axes[k]).getDimension() != a.getDimension() || axis.getPrimary() != a.getPrimary()) continue;
                            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                            axis.setUserStartOffset(offset);
                            axis.setUserEndOffset(offset);
                        }
                    }
                    continue;
                }
                if (ga2 == null || !LayoutDataLatticeParser.isDiscreteAxis(a = ga2.getAxis(), (byte)2)) continue;
                ga2.setWeightedByCategories(true);
                dr = (DiscreteRange)a.getDataRange((byte)2);
                mpcs[i3] = LayoutDataLatticeParser.getNumberOfDisplayCategory(dr, a);
                if (mpcs[i3] < 1) continue;
                a.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                a.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                offset = mpcs[i3] > 1 ? 0.5 / (double)mpcs[i3] : 0.0;
                a.setUserStartOffset(offset);
                a.setUserEndOffset(offset);
                for (j = 0; j < tl.getGridColumns(); ++j) {
                    if (!(tl.getCell(i3, j).getItem() instanceof OverlayContainer) || (soc = (oc4 = (OverlayContainer)tl.getCell(i3, j).getItem()).getComposite()) == null) continue;
                    axes = soc.getAxes();
                    for (k = 0; k < axes.length; ++k) {
                        if (!(axes[k] instanceof AbstractAxis) || (axis = (VRectAxis)axes[k]).getDimension() != a.getDimension() || axis.getPrimary() != a.getPrimary()) continue;
                        axis.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                        axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
                        axis.setUserStartOffset(offset);
                        axis.setUserEndOffset(offset);
                    }
                }
            }
            double totalWeights = 0.0;
            for (i = 0; i < tl.getGridRows(); ++i) {
                totalWeights += (double)mpcs[i];
                if (!sortByPlot) continue;
                for (int j = 0; j < tl.getGridColumns(); ++j) {
                    Simple2DOverlayComposite soc;
                    if (!(tl.getCell(i, j).getItem() instanceof OverlayContainer) || (soc = (oc = (OverlayContainer)tl.getCell(i, j).getItem()).getComposite()) == null) continue;
                    Object[] axes = soc.getAxes();
                    for (int k = 0; k < axes.length; ++k) {
                        VRectAxis a = (VRectAxis)axes[k];
                        if (a.getDimension() != 2) continue;
                        a.setMPC(mpcs[i]);
                    }
                }
            }
            if (totalWeights > 0.0) {
                for (i = 0; i < tl.getGridRows(); ++i) {
                    rowWeights[i] = (double)mpcs[i] / totalWeights;
                }
                tl.setRowWeights(rowWeights);
            }
            for (int j = 0; j < tl.getGridColumns(); ++j) {
                for (int i4 = 0; i4 < tl.getGridRows(); ++i4) {
                    Simple2DOverlayComposite soc;
                    if (!(tl.getCell(i4, j).getItem() instanceof OverlayContainer) || (soc = (oc = (OverlayContainer)tl.getCell(i4, j).getItem()).getComposite()) == null) continue;
                    ArrayList overlays = soc.getOverlays();
                    for (int k = 0; k < overlays.size(); ++k) {
                        BarOverlay bar;
                        Overlay o = (Overlay)overlays.get(k);
                        if (!(o instanceof BarOverlay) || (bar = (BarOverlay)o).getOrientation() != 1) continue;
                        bar.setWeightedByCategories(true);
                    }
                }
            }
        }
    }

    public static void cloneAxisOptsElement(Element latticeElem, Node optsElem, String newAxisOpts) {
        Element newElem = (Element)optsElem.cloneNode(true);
        NodeList nl = latticeElem.getElementsByTagName("LayoutPrototype");
        nl.item(0).appendChild(newElem);
        latticeElem.getOwnerDocument().renameNode(newElem, null, newAxisOpts);
    }

    static void hideOutsideLabels(JComponent comp, boolean firstRow, boolean lastRow, boolean firstColumn, boolean lastColumn, boolean reverseRow, boolean reverseRow2, boolean reverseCol, boolean reverseCol2) {
        if (!(comp instanceof BaseOverlayContainer)) {
            return;
        }
        Simple2DOverlayComposite soc = ((BaseOverlayContainer)comp).getComposite();
        if (soc == null) {
            return;
        }
        ArrayList overlays = soc.getOverlays();
        for (int i = 0; i < overlays.size(); ++i) {
            if (overlays.get(i) instanceof AxisTable) {
                AxisTable at = (AxisTable)overlays.get(i);
                at.setUniformPlotSize(true);
                if (!at.isShowLabel() && at.getHeaderLabel() == null) continue;
                if (at.isShowLabel()) {
                    boolean reverse;
                    at.setLabelToGridLabel(true);
                    if (at.getAxis() == 1 || at.getAxis() == 2) {
                        boolean bl = reverse = at.getAxis() == 1 ? reverseCol : reverseCol2;
                        if (at.getLabelPosition() == 1 && !reverse || at.getLabelPosition() == 2 && reverse) {
                            if (firstColumn) {
                                at.setDisplayGridLabel(true);
                            } else {
                                at.setShowLabel(false);
                            }
                        } else if (at.getLabelPosition() == 2 && !reverse || at.getLabelPosition() == 1 && reverse) {
                            if (lastColumn) {
                                at.setDisplayGridLabel(true);
                            } else {
                                at.setShowLabel(false);
                            }
                        }
                    } else {
                        boolean bl = reverse = at.getAxis() == 3 ? reverseRow : reverseRow2;
                        if (at.getLabelPosition() == 2 && !reverse || at.getLabelPosition() == 1 && reverse) {
                            if (firstRow) {
                                at.setDisplayGridLabel(true);
                            } else {
                                at.setShowLabel(false);
                            }
                        } else if (at.getLabelPosition() == 1 && !reverse || at.getLabelPosition() == 2 && reverse) {
                            if (lastRow) {
                                at.setDisplayGridLabel(true);
                            } else {
                                at.setShowLabel(false);
                            }
                        }
                    }
                }
                if (at.getHeaderLabel() == null) continue;
                if (at.getAxis() == 1 || at.getAxis() == 2) {
                    if (firstColumn) continue;
                    at.setShowHeader(false);
                    continue;
                }
                if (firstRow) {
                    at.setDisplayGridLabel(true);
                    continue;
                }
                at.setShowHeader(false);
                continue;
            }
            if (!(overlays.get(i) instanceof BlockOverlay)) continue;
            BlockOverlay block = (BlockOverlay)overlays.get(i);
            if ((block.isUniformPlotSize() || block.isInnerMarginOverlay()) && (block.getValueFitStrategy() == 2 || block.getValueFitStrategy() == 3)) {
                block.setValueFitStrategy(0);
            }
            if (!block.isLabelOn()) continue;
            block.setLabelToGridLabel(true);
            if (block.getLabelPosition() == 2) {
                if (firstColumn) {
                    block.setDisplayGridLabel(true);
                    continue;
                }
                block.setLabelOn(false);
                continue;
            }
            if (block.getLabelPosition() != 3) continue;
            if (lastColumn) {
                block.setDisplayGridLabel(true);
                continue;
            }
            block.setLabelOn(false);
        }
    }

    static void hideCurveLabels(JComponent comp, boolean firstRow, boolean lastRow, boolean firstColumn, boolean lastColumn) {
        if (!(comp instanceof BaseOverlayContainer)) {
            return;
        }
        Simple2DOverlayComposite soc = ((BaseOverlayContainer)comp).getComposite();
        if (soc == null) {
            return;
        }
        ArrayList overlays = soc.getOverlays();
        block8: for (int i = 0; i < overlays.size(); ++i) {
            ReferenceLineOverlay ref;
            if (!(overlays.get(i) instanceof ReferenceLineOverlay) || (ref = (ReferenceLineOverlay)overlays.get(i)).getCurveLabelString() == null) continue;
            if (ref.isHorizontal()) {
                switch (ref.getCurveLabelPosition()) {
                    case 1: {
                        if (lastColumn) break;
                        ref.setCurveLabelString(null);
                        break;
                    }
                    case 0: {
                        if (firstColumn) break;
                        ref.setCurveLabelString(null);
                    }
                }
                continue;
            }
            switch (ref.getCurveLabelPosition()) {
                case 1: {
                    if (firstRow) continue block8;
                    ref.setCurveLabelString(null);
                    continue block8;
                }
                case 0: {
                    if (lastRow) continue block8;
                    ref.setCurveLabelString(null);
                }
            }
        }
    }

    static int getNumberOfDisplayCategory(DiscreteRange dr, VRectAxis a) {
        String[] ticks = a.getDiscreteTicks();
        if (ticks != null && dr.getValuesSize() != 0) {
            SASFormat fmt = dr.getColumnFormat();
            if (fmt == null && dr instanceof OrdinalRange) {
                fmt = DataModel.defaultFormat;
            }
            String[] formattedTicks = ticks;
            if (fmt != null) {
                String formattedMiss = StatGraph.missingOption;
                if (dr instanceof OrdinalRange) {
                    formattedMiss = fmt.format((Object)new Double(Double.NaN)).trim();
                    if (formattedMiss == null || formattedMiss.equals(".")) {
                        formattedMiss = StatGraph.missingOption;
                    }
                } else {
                    formattedMiss = fmt.format((Object)" ").trim();
                    if (formattedMiss == null || formattedMiss.length() == 0) {
                        formattedMiss = StatGraph.missingCharacter;
                    }
                }
                formattedTicks = new String[ticks.length];
                for (int j = 0; j < ticks.length; ++j) {
                    if (dr instanceof OrdinalRange) {
                        if (ticks[j].equals(".")) {
                            formattedTicks[j] = formattedMiss;
                            continue;
                        }
                        if (StatGraph.isNumber(ticks[j])) {
                            Double dv = new Double(ticks[j]);
                            formattedTicks[j] = fmt.format((Object)dv).trim();
                            continue;
                        }
                        formattedTicks[j] = ticks[j];
                        continue;
                    }
                    formattedTicks[j] = ticks[j].trim().length() == 0 ? formattedMiss : fmt.format((Object)ticks[j]);
                }
            }
            dr = (DiscreteRange)Simple2DOverlayComposite.getModifiedDataRange((DataRange)dr, formattedTicks, a.getTickValueListPolicy());
        }
        return dr.getValuesSize();
    }

    static String[] getFirstEntriesAt(StringVariable[] classVars, String where, InsetArgs iArgs) {
        VariableProcessor vp = new VariableProcessor();
        StringVectorVariable[] entryVars = new StringVectorVariable[iArgs.numEntryColumns];
        for (int i = 0; i < iArgs.numEntryColumns; ++i) {
            entryVars[i] = new StringVectorVariable();
            entryVars[i].setBlankMissing(false);
            entryVars[i].connectFrom(iArgs.entryColumnValuesArray[i]);
            vp.addVariable((Variable)entryVars[i]);
        }
        StringVectorVariable[] clonedClassVars = new StringVectorVariable[classVars.length];
        for (int i = 0; i < classVars.length; ++i) {
            clonedClassVars[i] = new StringVectorVariable();
            clonedClassVars[i].setName(classVars[i].getColumnName());
            clonedClassVars[i].connectFrom(classVars[i].value);
            vp.addVariable((Variable)clonedClassVars[i]);
        }
        vp.setWhereExpression(where);
        String[] entries = new String[iArgs.numEntryColumns];
        for (int i = 0; i < iArgs.numEntryColumns; ++i) {
            try {
                if (entryVars[i].getValueCount() <= 0) continue;
                entries[i] = entryVars[i].value.getValue(0);
                continue;
            }
            catch (MissingValueException mve) {
                entries[i] = null;
            }
        }
        return entries;
    }

    private static void decideAutoUnionTypes(StatGraph graph, Element elem, TrellisPlot plot, boolean autoColumnDataRange, boolean autoColumn2DataRange, boolean autoRowDataRange, boolean autoRow2DataRange) {
        Node node;
        boolean userSetXType = false;
        boolean userSetX2Type = false;
        boolean userSetYType = false;
        boolean userSetY2Type = false;
        String elemTag = "";
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("ColumnAxisOpts")) {
                userSetXType = LayoutOverlayParser.isUserSetAxisType((Element)node, "X");
                continue;
            }
            if (elemTag.equals("Column2AxisOpts")) {
                userSetX2Type = LayoutOverlayParser.isUserSetAxisType((Element)node, "X2");
                continue;
            }
            if (elemTag.equals("RowAxisOpts")) {
                userSetYType = LayoutOverlayParser.isUserSetAxisType((Element)node, "Y");
                continue;
            }
            if (!elemTag.equals("Row2AxisOpts")) continue;
            userSetY2Type = LayoutOverlayParser.isUserSetAxisType((Element)node, "Y2");
        }
        if (userSetXType && userSetX2Type && userSetYType && userSetY2Type) {
            return;
        }
        boolean[] defined = new boolean[]{userSetXType, userSetX2Type, userSetYType, userSetY2Type};
        Element protoElem = StatGraph.getOptionAttrsElement(elem, "LayoutPrototype");
        for (node = protoElem.getLastChild(); node != null; node = node.getPreviousSibling()) {
            String str;
            if (!(node instanceof Element) || !LayoutOverlayParser.isPrimaryPlot((Element)node) || !(str = ((Element)node).getAttribute("primary")).equalsIgnoreCase("true")) continue;
            boolean x = false;
            boolean x2 = false;
            boolean y = false;
            boolean y2 = false;
            str = ((Element)node).getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!userSetX2Type) {
                    x2 = true;
                }
            } else if (!userSetXType) {
                x = true;
            }
            if ((str = ((Element)node).getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (!userSetY2Type) {
                    y2 = true;
                }
            } else if (!userSetYType) {
                y = true;
            }
            LayoutOverlayParser.requiredAxesTypeByPlot(graph, (Element)node, x, x2, y, y2, false, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type) continue;
            return;
        }
        for (node = protoElem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !LayoutOverlayParser.isPrimaryPlot((Element)node)) continue;
            boolean x = false;
            boolean x2 = false;
            boolean y = false;
            boolean y2 = false;
            String str = ((Element)node).getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!userSetX2Type) {
                    x2 = true;
                }
            } else if (!userSetXType) {
                x = true;
            }
            if ((str = ((Element)node).getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (!userSetY2Type) {
                    y2 = true;
                }
            } else if (!userSetYType) {
                y = true;
            }
            LayoutOverlayParser.requiredAxesTypeByPlot(graph, (Element)node, x, x2, y, y2, false, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type) continue;
            return;
        }
        if (autoColumnDataRange && LayoutOverlayParser.xAxisType == 2) {
            plot.setUniformXRange(false);
            graph.xUnionAllPages = false;
        }
        if (autoRowDataRange && LayoutOverlayParser.yAxisType == 2) {
            plot.setUniformYRange(false);
            graph.yUnionAllPages = false;
        }
        if (autoColumn2DataRange && LayoutOverlayParser.x2AxisType == 2) {
            plot.setUniformX2Range(false);
            graph.x2UnionAllPages = false;
        }
        if (autoRow2DataRange && LayoutOverlayParser.y2AxisType == 2) {
            plot.setUniformY2Range(false);
            graph.y2UnionAllPages = false;
        }
        LayoutOverlayParser.xAxisType = 0;
        LayoutOverlayParser.x2AxisType = 0;
        LayoutOverlayParser.yAxisType = 0;
        LayoutOverlayParser.y2AxisType = 0;
        LayoutOverlayParser.logBaseX = 10.0;
        LayoutOverlayParser.logBaseX2 = 10.0;
        LayoutOverlayParser.logBaseY = 10.0;
        LayoutOverlayParser.logBaseY2 = 10.0;
    }

    static boolean isClassVarsContained(DataModel m, StringVariable[] classVars) {
        boolean defined = true;
        for (int i = 0; i < classVars.length; ++i) {
            if (classVars[i] == null || m.hasColumn(classVars[i].getName())) continue;
            defined = false;
            break;
        }
        return defined;
    }

    static void setMinMaxComputed(StatGraph graph, StringVariable[] classVars, boolean computed) {
        for (int i = 0; i < graph.dataModelList.size(); ++i) {
            DataModel m = (DataModel)graph.dataModelList.get(i);
            if (!LayoutDataLatticeParser.isClassVarsContained(m, classVars)) continue;
            m.minMaxComputed = computed;
        }
    }

    static class StripArgs {
        LineAttrs outlineStyle = new LineAttrs();
        TextStyle stripLabelStyle = new TextStyle();
        FillAttrs stripFillStyle = new FillAttrs();
        FillAttrs fillStyle = new FillAttrs();
        double[] stripStart;
        double[] stripEnd;
        String[] stripText;
        boolean numericStripLabel = false;

        StripArgs() {
        }

        StripLabel createStripLabel(int cellIndex) {
            String text;
            double end;
            double start;
            int len;
            int n = len = this.stripStart != null ? this.stripStart.length : this.stripEnd.length;
            if (cellIndex >= len) {
                start = 0.0;
                end = 0.0;
                text = " ";
            } else {
                double d = start = this.stripStart != null ? this.stripStart[cellIndex] : 0.0;
                if (Double.isNaN(start)) {
                    start = 0.0;
                }
                double d2 = end = this.stripEnd != null ? this.stripEnd[cellIndex] : 1.0;
                if (Double.isNaN(end) || end > 1.0) {
                    end = 1.0;
                }
                if (start > end) {
                    start = end;
                }
                String string = text = this.stripText != null && this.stripText[cellIndex] != null ? this.stripText[cellIndex] : " ";
                if (text.equals("")) {
                    text = " ";
                }
            }
            StripLabel sl = new StripLabel(text, start, end);
            sl.setHorizontalAlignment(0);
            if (this.fillStyle.getTransparency() == 1.0) {
                sl.setOpaque(false);
            } else {
                sl.setOpaque(true);
                sl.setBackground(this.fillStyle.getColor());
            }
            double tr = this.stripFillStyle.getTransparency();
            if (tr >= 0.0) {
                sl.setHilite(Overlay.applyTransparency(this.stripFillStyle.getColor(), tr));
            } else {
                sl.setHilite(this.stripFillStyle.getColor());
            }
            sl.setHiliteOutline(this.outlineStyle.getColor());
            sl.setForeground(this.stripLabelStyle.getColor());
            sl.setFont(this.stripLabelStyle.getFont());
            sl.setBorder((Border)new StyledLineBorder(this.outlineStyle.getColor()));
            if (this.numericStripLabel) {
                sl.setFitPolicy(1);
            }
            return sl;
        }

        static StripArgs parse(StatGraph graph, Element elem, DataLatticeProperties pp) {
            String varID;
            int idx;
            String str;
            String start = elem.getAttribute("stripLabelStart");
            String end = elem.getAttribute("stripLabelEnd");
            String text = elem.getAttribute("stripLabelText");
            if (start.length() == 0 && end.length() == 0 && text.length() == 0) {
                return null;
            }
            StripArgs sa = new StripArgs();
            String string = str = start.length() != 0 ? start : end;
            if (str.length() == 0) {
                str = text;
            }
            String stripDataName = StatGraph.getDataName(str);
            DataModel stripDataModel = graph.getData(stripDataName);
            if (start.length() != 0 && StatGraph.checkVariable("STRIPLABELSTART", stripDataModel.getColumnLabel(idx = stripDataModel.getColumn(varID = StatGraph.getVarID(start))), Double.class, 0, false, false)) {
                sa.stripStart = stripDataModel.getDoubleColumn(idx);
            }
            if (end.length() != 0 && StatGraph.checkVariable("STRIPLABELEND", stripDataModel.getColumnLabel(idx = stripDataModel.getColumn(varID = StatGraph.getVarID(end))), Double.class, 0, false, false)) {
                sa.stripEnd = stripDataModel.getDoubleColumn(idx);
            }
            if (text.length() != 0) {
                varID = StatGraph.getVarID(text);
                idx = stripDataModel.getColumn(varID);
                ColumnMetadata cmd = (ColumnMetadata)stripDataModel.getColumnLabel(idx);
                sa.numericStripLabel = cmd.getType() == 1;
                sa.stripText = stripDataModel.getColumnAsClassColumn(idx);
            }
            if (sa.stripStart == null && sa.stripEnd == null && sa.stripText == null) {
                return null;
            }
            sa.outlineStyle = pp.headerBorderStyle;
            sa.stripLabelStyle = pp.headerLabelStyle;
            sa.fillStyle = pp.headerFillStyle;
            GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("stripLabelFillAttrs"), sa.stripFillStyle, "GraphDataStyleDefault");
            Element fs = StatGraph.getOptionAttrsElement(elem, "StripLabelFillAttrs");
            if (fs != null) {
                StatGraph.parseFillAttrs(graph, fs, sa.stripFillStyle);
            }
            return sa;
        }
    }

    static class InsetArgs {
        String header;
        int numEntryColumns;
        String[] entryLabels;
        String[][] entryColumnValuesArray;
        Element insetOptsElem;
        TextStyle insetHeaderStyle = new TextStyle();
        TextStyle insetTextStyle = new TextStyle();
        GridBagConstraints insetConstr = new GridBagConstraints();
        boolean matchMerged = false;
        boolean showLabels = true;
        String separator = null;

        InsetArgs() {
            this.insetConstr.fill = 2;
            this.insetConstr.weightx = 1.0;
            this.insetConstr.weighty = 0.0;
        }

        InsetArgs(StatGraph graph, Element elem, Element varsElem) {
            this();
            String[] insetVars = StatGraph.parseStringValueList(varsElem, "Value");
            String insetVarsDataName = StatGraph.getDataName(insetVars[0]);
            DataModel entryDataModel = graph.getData(insetVarsDataName);
            this.numEntryColumns = insetVars.length;
            this.entryLabels = new String[this.numEntryColumns];
            this.entryColumnValuesArray = new String[this.numEntryColumns][];
            for (int i = 0; i < this.numEntryColumns; ++i) {
                String varID = StatGraph.getVarID(insetVars[i]);
                if (varID.length() <= 0) continue;
                int colIdx = entryDataModel.getColumn(varID);
                ColumnMetadata cmd = (ColumnMetadata)entryDataModel.getColumnLabel(colIdx);
                this.entryLabels[i] = cmd.getLabel();
                String sMissing = StatGraph.missingCharacter;
                String nMissing = StatGraph.missingOption;
                StatGraph.missingCharacter = "";
                StatGraph.missingOption = "";
                this.entryColumnValuesArray[i] = entryDataModel.getColumnAsClassColumn(colIdx, true);
                StatGraph.missingCharacter = sMissing;
                StatGraph.missingOption = nMissing;
            }
            this.insetOptsElem = StatGraph.getOptionAttrsElement(elem, "InsetOpts");
            String tAttrsStyleRef = null;
            Element textAttrElem = null;
            String hAttrsStyleRef = null;
            Element headerAttrElem = null;
            if (graph.isCASData()) {
                this.matchMerged = true;
            }
            if (this.insetOptsElem != null) {
                String str = this.insetOptsElem.getAttribute("title");
                if (str.length() > 0) {
                    this.header = " " + str + " ";
                } else {
                    this.insetOptsElem.setAttribute("pad", Integer.toString(StatGraph.SCMX_INSET_GUTTER / 2));
                }
                str = this.insetOptsElem.getAttribute("dataScheme");
                if (str.equalsIgnoreCase("matched")) {
                    this.matchMerged = true;
                } else if (str.equalsIgnoreCase("list")) {
                    this.matchMerged = false;
                } else if (str.length() > 0) {
                    StatGraph.printOptionError("DATASCHEME", str);
                }
                str = this.insetOptsElem.getAttribute("contentDisplay");
                if (str.equalsIgnoreCase("value")) {
                    this.showLabels = false;
                }
                if ((str = this.insetOptsElem.getAttribute("separator")).length() > 0) {
                    this.separator = str;
                }
                tAttrsStyleRef = this.insetOptsElem.getAttribute("textAttrs");
                textAttrElem = StatGraph.getOptionAttrsElement(this.insetOptsElem, "TextAttrs");
                hAttrsStyleRef = this.insetOptsElem.getAttribute("titleAttrs");
                headerAttrElem = StatGraph.getOptionAttrsElement(this.insetOptsElem, "TitleAttrs");
            }
            GraphStyle.setDefaultTextStyle(graph, tAttrsStyleRef, this.insetTextStyle, "DataText");
            if (textAttrElem != null) {
                StatGraph.parseTextAttrs(graph, textAttrElem, this.insetTextStyle);
            }
            GraphStyle.setDefaultTextStyle(graph, hAttrsStyleRef, this.insetHeaderStyle, "ValueText");
            if (headerAttrElem != null) {
                StatGraph.parseTextAttrs(graph, headerAttrElem, this.insetHeaderStyle);
            }
            tAttrsStyleRef = null;
            textAttrElem = null;
            hAttrsStyleRef = null;
            headerAttrElem = null;
        }

        public static InsetArgs parseInsetVarsAndOpts(StatGraph graph, Element elem) {
            Element insetVarsElem = StatGraph.getOptionAttrsElement(elem, "InsetVars");
            if (insetVarsElem == null) {
                return null;
            }
            return new InsetArgs(graph, elem, insetVarsElem);
        }

        void addInset(StatGraph graph, int obsIndex, JComponent comp, boolean labelsVisible, String separator) {
            if (!(comp instanceof OverlayContainer)) {
                StatGraph.printDebug("addInset() Parent not an OverlayContainer");
                return;
            }
            OverlayContainer oc = (OverlayContainer)comp;
            GridPanel entryContainer = new GridPanel();
            GridPanel headerContainer = null;
            if (this.header != null) {
                headerContainer = new GridPanel();
            }
            int cols = 1;
            if (labelsVisible) {
                ++cols;
                if (separator != null) {
                    ++cols;
                }
            }
            entryContainer.setColumns(cols);
            entryContainer.setAlignmentX(0.0f);
            entryContainer.setAlignmentY(0.0f);
            if (this.insetOptsElem != null) {
                if (this.header == null) {
                    GraphComponentParser.load(graph, this.insetOptsElem, entryContainer, oc, 0.0f, 0.0f);
                    StatGraph.parseBorderOpts(graph, entryContainer, this.insetOptsElem, null);
                } else {
                    GraphComponentParser.load(graph, this.insetOptsElem, headerContainer, oc, 0.0f, 0.0f);
                    this.insetOptsElem.setAttribute("pad", Integer.toString(StatGraph.SCMX_INSET_GUTTER / 2));
                    String savedBorder = this.insetOptsElem.getAttribute("border");
                    this.insetOptsElem.setAttribute("border", "false");
                    StatGraph.parseBorderOpts(graph, entryContainer, this.insetOptsElem, null);
                    this.insetOptsElem.removeAttribute("pad");
                    this.insetOptsElem.setAttribute("border", savedBorder);
                    StatGraph.parseBorderOpts(graph, headerContainer, this.insetOptsElem, null);
                }
            }
            int numInsets = 0;
            Font iFont = this.insetTextStyle.getFont();
            Color iColor = this.insetTextStyle.getColor();
            for (int i = 0; i < this.numEntryColumns; ++i) {
                String rhsValue;
                try {
                    rhsValue = this.entryColumnValuesArray[i][obsIndex];
                    if (rhsValue.length() == 0) {
                        continue;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    break;
                }
                ++numInsets;
                Entry rhsEntry = new Entry(rhsValue);
                if (!labelsVisible) {
                    if (this.header == null) {
                        rhsEntry.setAlignmentX(entryContainer.getAlignmentX());
                    } else {
                        rhsEntry.setAlignmentX(headerContainer.getAlignmentX());
                    }
                } else {
                    rhsEntry.setAlignmentX(1.0f);
                }
                rhsEntry.setFont(iFont);
                rhsEntry.setForeground(iColor);
                rhsEntry.setTextAntiAliased(graph.axisAntialiased);
                if (labelsVisible) {
                    Entry lhsEntry = new Entry(this.entryLabels[i]);
                    lhsEntry.setAlignmentX(0.0f);
                    lhsEntry.setFont(iFont);
                    lhsEntry.setForeground(iColor);
                    lhsEntry.setTextAntiAliased(graph.axisAntialiased);
                    entryContainer.add((Component)lhsEntry, this.insetConstr);
                    if (separator != null) {
                        Entry sepEntry = new Entry(separator);
                        sepEntry.setAlignmentX(0.0f);
                        sepEntry.setFont(iFont);
                        sepEntry.setForeground(iColor);
                        sepEntry.setTextAntiAliased(graph.axisAntialiased);
                        entryContainer.add((Component)sepEntry, this.insetConstr);
                    }
                }
                entryContainer.add((Component)rhsEntry, this.insetConstr);
            }
            if (numInsets > 0) {
                entryContainer.setColumnGutters(StatGraph.SCMX_INSET_GUTTER);
                if (this.header != null) {
                    Entry title = new Entry(this.header);
                    Font hFont = this.insetHeaderStyle.getFont();
                    Color hColor = this.insetHeaderStyle.getColor();
                    title.setFont(hFont);
                    title.setForeground(hColor);
                    title.setTextAntiAliased(graph.axisAntialiased);
                    headerContainer.add((Component)title, this.insetConstr);
                    headerContainer.add((Component)entryContainer, this.insetConstr);
                    if (this.insetOptsElem.getAttribute("border").equalsIgnoreCase("true")) {
                        LineAttrs borderStyle = new LineAttrs();
                        GraphStyle.setDefaultLineStyle(graph, "", borderStyle, "BorderLines");
                        headerContainer.setForeground(borderStyle.getColor());
                        headerContainer.setRowGrid(1, graph.scaleLineThickness(1));
                    }
                    oc.add(headerContainer);
                } else {
                    oc.add(entryContainer);
                }
            }
        }

        void addInset(StatGraph graph, String[] entries, JComponent comp, boolean labelsVisible, String separator) {
            if (!(comp instanceof OverlayContainer)) {
                StatGraph.printDebug("addInset() Parent not an OverlayContainer");
                return;
            }
            OverlayContainer oc = (OverlayContainer)comp;
            GridPanel entryContainer = new GridPanel();
            GridPanel headerContainer = null;
            if (this.header != null) {
                headerContainer = new GridPanel();
            }
            int cols = 1;
            if (labelsVisible) {
                ++cols;
                if (separator != null) {
                    ++cols;
                }
            }
            entryContainer.setColumns(cols);
            entryContainer.setAlignmentX(0.0f);
            entryContainer.setAlignmentY(0.0f);
            if (this.insetOptsElem != null) {
                if (this.header == null) {
                    GraphComponentParser.load(graph, this.insetOptsElem, entryContainer, oc, 0.0f, 0.0f);
                    StatGraph.parseBorderOpts(graph, entryContainer, this.insetOptsElem, null);
                } else {
                    GraphComponentParser.load(graph, this.insetOptsElem, headerContainer, oc, 0.0f, 0.0f);
                    this.insetOptsElem.setAttribute("pad", Integer.toString(StatGraph.SCMX_INSET_GUTTER / 2));
                    String savedBorder = this.insetOptsElem.getAttribute("border");
                    this.insetOptsElem.setAttribute("border", "false");
                    StatGraph.parseBorderOpts(graph, entryContainer, this.insetOptsElem, null);
                    this.insetOptsElem.removeAttribute("pad");
                    this.insetOptsElem.setAttribute("border", savedBorder);
                    StatGraph.parseBorderOpts(graph, headerContainer, this.insetOptsElem, null);
                }
            }
            int numInsets = 0;
            Font iFont = this.insetTextStyle.getFont();
            Color iColor = this.insetTextStyle.getColor();
            for (int i = 0; i < this.numEntryColumns; ++i) {
                if (entries[i] == null || entries[i].length() == 0) continue;
                ++numInsets;
                String rhsValue = entries[i];
                Entry rhsEntry = new Entry(rhsValue);
                if (!labelsVisible) {
                    if (this.header == null) {
                        rhsEntry.setAlignmentX(entryContainer.getAlignmentX());
                    } else {
                        rhsEntry.setAlignmentX(headerContainer.getAlignmentX());
                    }
                } else {
                    rhsEntry.setAlignmentX(1.0f);
                }
                rhsEntry.setFont(iFont);
                rhsEntry.setForeground(iColor);
                rhsEntry.setTextAntiAliased(graph.axisAntialiased);
                if (labelsVisible) {
                    Entry lhsEntry = new Entry(this.entryLabels[i]);
                    lhsEntry.setAlignmentX(0.0f);
                    lhsEntry.setFont(iFont);
                    lhsEntry.setForeground(iColor);
                    lhsEntry.setTextAntiAliased(graph.axisAntialiased);
                    entryContainer.add((Component)lhsEntry, this.insetConstr);
                    if (separator != null) {
                        Entry sepEntry = new Entry(separator);
                        sepEntry.setAlignmentX(0.0f);
                        sepEntry.setFont(iFont);
                        sepEntry.setForeground(iColor);
                        sepEntry.setTextAntiAliased(graph.axisAntialiased);
                        entryContainer.add((Component)sepEntry, this.insetConstr);
                    }
                }
                entryContainer.add((Component)rhsEntry, this.insetConstr);
            }
            if (numInsets == 0) {
                return;
            }
            entryContainer.setColumnGutters(StatGraph.SCMX_INSET_GUTTER);
            if (this.header != null) {
                Entry title = new Entry(this.header);
                Font hFont = this.insetHeaderStyle.getFont();
                Color hColor = this.insetHeaderStyle.getColor();
                title.setFont(hFont);
                title.setForeground(hColor);
                title.setTextAntiAliased(graph.axisAntialiased);
                headerContainer.add((Component)title, this.insetConstr);
                headerContainer.add((Component)entryContainer, this.insetConstr);
                if (this.insetOptsElem.getAttribute("border").equalsIgnoreCase("true")) {
                    LineAttrs borderStyle = new LineAttrs();
                    GraphStyle.setDefaultLineStyle(graph, "", borderStyle, "BorderLines");
                    headerContainer.setForeground(borderStyle.getColor());
                    headerContainer.setRowGrid(1, graph.scaleLineThickness(1));
                }
                oc.add(headerContainer);
            } else {
                oc.add(entryContainer);
            }
        }
    }

    public static class DataLatticeProperties {
        public static final int BOTH = 0;
        public static final int LEFT = 1;
        public static final int RIGHT = 2;
        public static final int TOP = 3;
        public static final int BOTTOM = 4;
        public boolean multiDataModel = false;
        public boolean isDataPanel;
        public boolean degenerated = false;
        public int startCol;
        public int startRow;
        public int maxNumCols;
        public int maxNumRows;
        public int maxNumPages;
        public boolean displayHeader = true;
        public boolean insideHeader = false;
        public boolean includeNameInHeader = true;
        public boolean extractHeaderName = false;
        public TextStyle headerLabelStyle = new TextStyle();
        public TextStyle headerExtractedLabelStyle = new TextStyle();
        public TextStyle headerExtractedLevelLabelStyle = new TextStyle();
        public boolean headerBorder = true;
        public LineAttrs headerBorderStyle = new LineAttrs();
        public FillAttrs headerFillStyle = new FillAttrs();
        public FillAttrs wallFillStyle = new FillAttrs();
        public boolean rowMajor = true;
        public boolean packed = false;
        public boolean sharedAxes = true;
        public boolean startAtTop = true;
        public boolean includeMissing = true;
        public int rowHeaders = 2;
        public int columnHeaders = 3;
        public boolean showEmptyCells = true;
        public String rowAxisAltDisplay = "ALL";
        public String rowAxisDisplay2 = "NONE";
        public String rowAxisAltDisplay2 = "NONE";
        public String colAxisAltDisplay = "ALL";
        public String colAxisDisplay2 = "NONE";
        public String colAxisAltDisplay2 = "NONE";
        public String row2AxisAltDisplay = "ALL";
        public String row2AxisDisplay2 = "NONE";
        public String row2AxisAltDisplay2 = "NONE";
        public String col2AxisAltDisplay = "ALL";
        public String col2AxisDisplay2 = "NONE";
        public String col2AxisAltDisplay2 = "NONE";
        public boolean rowAxisSideBar = false;
        public boolean rowAxis2SideBar = false;
        public boolean colAxisSideBar = false;
        public boolean colAxis2SideBar = false;
        public boolean verticalRowHeaders = true;
        public HashMap inLookup = null;
        public InsetArgs iArgs;
        public StripArgs sArgs;
        public DataModel dataModel = null;
        public boolean headerCollapse = false;
        public int headerSplitCount = -1;
        public String headerSeparator = ", ";
    }
}

