/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HistogramOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.SpecLimitsOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.Message;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HistoParser {
    public static final String RB_KEY = "HistoParser.";

    public static HistogramOverlay load(StatGraph graph, Element elem) {
        HistogramOverlay hist = (HistogramOverlay)graph.getObjectFromElement(elem);
        if (hist == null) {
            hist = new HistogramOverlay();
        }
        return HistoParser.load(graph, hist, elem) ? hist : null;
    }

    public static boolean load(StatGraph graph, HistogramOverlay hist, Element elem) {
        Color c;
        String[] opts;
        int nBinsMax;
        Message msg;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, hist);
        String str = elem.getAttribute("primary");
        hist.setPrimary(str.equalsIgnoreCase("true"));
        str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        int xcol = m.getColumn(xVarID);
        int ycol = m.getColumn(yVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            graph.removeNamedGraph(hist);
            return false;
        }
        if (!StatGraph.checkVariable("Y", m.getColumnLabel(ycol), Double.class, 0, false, 1, true)) {
            graph.removeNamedGraph(hist);
            return false;
        }
        RoleColumnMap map = new RoleColumnMap();
        map.map(13, xcol);
        map.map(2, ycol);
        hist.addRole("X", m.getColumnLabel(xcol));
        hist.addRole("Y", m.getColumnLabel(ycol));
        str = elem.getAttribute("dataLabel");
        String labelVarID = StatGraph.getVarID(str);
        if (labelVarID.length() > 0) {
            int lcol = m.getColumn(labelVarID);
            map.map(5, lcol);
            hist.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        str = elem.getAttribute("group");
        String gVarID = StatGraph.getVarID(str);
        boolean grouped = false;
        int numGroups = 0;
        if (gVarID.length() > 0) {
            int gcol = m.getColumn(gVarID);
            String[] values = m.getColumnAsClassColumn(gcol, true);
            StringVectorVariable var = new StringVectorVariable();
            var.connectFrom(values);
            numGroups = var.getUniqueValueCount();
            if (numGroups > graph.groupMax) {
                msg = new Message(RB.getStringResource("LayoutOverlayParser.", "group.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)gVarID));
                numGroups = 0;
            }
            if (numGroups > 0) {
                grouped = true;
                map.map(3, gcol);
                if (!StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color")) {
                    map.map(6, gcol);
                }
                if (!StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color")) {
                    map.map(46, gcol);
                }
                if (!StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "pattern")) {
                    map.map(36, gcol);
                }
                if (!StatGraph.isBundleAttributeFixed(elem, "fillPatternAttrs", "pattern")) {
                    map.map(111, gcol);
                }
                if (!StatGraph.isBundleAttributeFixed(elem, "fillPatternAttrs", "color")) {
                    map.map(112, gcol);
                }
                if (!StatGraph.isBundleAttributeFixed(elem, "dataLabelAttrs", "color")) {
                    map.map(107, gcol);
                }
                hist.addRole("GROUP", m.getColumnLabel(gcol));
                str = elem.getAttribute("includeMissingGroup");
                if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                    hist.setMissingGroupOn(false);
                }
                if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                    hist.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    String originalGroup = elem.hasAttribute("_originalGroup") ? elem.getAttribute("_originalGroup") : gVarID;
                    DAMDatasetParser.addInternalAttrVar(graph, hist, "GROUP", originalGroup);
                }
                if (graph.isCASData()) {
                    hist.setGroupOrder(1);
                    hist.setDrawByGroupOrder(true);
                }
            }
        }
        if (graph.isCASData()) {
            hist.setSortXValues(true);
        }
        int n = nBinsMax = grouped ? numGroups * graph.nBinsMax : graph.nBinsMax;
        if (hist.getStmt() != null && hist.getStmt().equalsIgnoreCase("HistogramParm")) {
            ColumnMetadata xcmd = (ColumnMetadata)m.getColumnLabel(xcol);
            int nBins = m.getRowCount() - xcmd.getMissings();
            if (nBins > nBinsMax) {
                graph.removeNamedGraph(hist);
                msg = new Message(RB.getStringResource(RB_KEY, "nbins.fmt.txt"));
                StatGraph.printWarning(msg.toString((Object)hist.getStmt(), (Object)nBins), false);
                return false;
            }
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, hist);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, hist);
        HistoParser.parseSpecLimits(graph, elem, hist, m, map);
        str = elem.getAttribute("xValues");
        if (str.equalsIgnoreCase("LEFTPOINTS")) {
            hist.setXValues((byte)1);
        } else if (str.equalsIgnoreCase("RIGHTPOINTS")) {
            hist.setXValues((byte)2);
        } else if (str.equalsIgnoreCase("MIDPOINTS")) {
            hist.setXValues((byte)0);
        } else {
            hist.setXValues((byte)0);
            if (str.length() > 0) {
                StatGraph.printOptionError("XVALUES", str);
            }
        }
        str = elem.getAttribute("endLabels");
        if (str.equalsIgnoreCase("true")) {
            hist.setEndLabels(true);
        }
        if ((str = elem.getAttribute("orient")).equalsIgnoreCase("Horizontal")) {
            hist.setOrientation((byte)1);
        } else if (str.equalsIgnoreCase("Vertical")) {
            hist.setOrientation((byte)0);
        } else {
            hist.setOrientation((byte)0);
            if (str.length() > 0) {
                StatGraph.printOptionError("ORIENT", str);
            }
        }
        str = elem.getAttribute("binAxis");
        if (str.equalsIgnoreCase("false")) {
            hist.setBinAxis(false);
        }
        if (hist.isTooltipEnabled()) {
            hist.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        hist.setModel(crd);
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                hist.setEdgeOn(true);
                hist.setFillOn(true);
                hist.setFillPatternOn(true);
            } else {
                hist.setEdgeOn(false);
                hist.setFillOn(false);
                hist.setFillPatternOn(false);
                opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        hist.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        hist.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        hist.setFillPatternOn(true);
                        continue;
                    }
                    hist.setEdgeOn(true);
                    hist.setFillOn(true);
                    hist.setFillPatternOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Histogram", "displayOpts");
            if (str != null) {
                hist.setEdgeOn(false);
                hist.setFillOn(false);
                hist.setFillPatternOn(false);
                opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        hist.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        hist.setFillOn(true);
                        continue;
                    }
                    if (!opts[i].equalsIgnoreCase("fillPattern")) continue;
                    hist.setFillPatternOn(true);
                }
                if (!(hist.isEdgeOn() || hist.isFillOn() || hist.isFillPatternOn())) {
                    hist.setEdgeOn(true);
                    hist.setFillOn(true);
                    hist.setFillPatternOn(false);
                }
            } else {
                hist.setEdgeOn(true);
                hist.setFillOn(true);
                hist.setFillPatternOn(false);
            }
        }
        StatGraph.parseDataSkinOpt(graph, elem, hist);
        if (hist.isFillOn()) {
            str = elem.getAttribute("fillType");
            if (str.equalsIgnoreCase("gradient") || str.equalsIgnoreCase("colorGradient")) {
                hist.setFillType(HistogramOverlay.FILL_GRADIENT);
                if (hist.getSkinType() == 4) {
                    hist.setSkinType(0);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "gradientskin.txt"));
                }
            } else if (str.equalsIgnoreCase("alphagradient")) {
                hist.setFillType(HistogramOverlay.FILL_ALPHAGRADIENT);
                if (hist.getSkinType() == 4) {
                    hist.setSkinType(0);
                    StatGraph.printNote(RB.getStringResource(RB_KEY, "gradientskin.txt"));
                }
            } else if (str.length() > 0 && !str.equalsIgnoreCase("solid")) {
                StatGraph.printOptionError("FILLTYPE", str);
            }
        }
        if (elem.hasAttribute("fillEndColor") && (c = StatGraph.parseAttrColor("fillEndColor", graph, elem)) != null) {
            hist.setGradientEndColor(c);
        }
        FillAttrs fillStyle = null;
        String contextName = graph.style.getContextName();
        hist.setContextName(contextName);
        if (hist.isFillOn()) {
            fillStyle = hist.getFillStyle();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, contextName);
        }
        if (hist.isEdgeOn()) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), hist.getEdgeStyle(), "Outlines");
        }
        if (hist.isFillPatternOn()) {
            GraphStyle.setDefaultFillPatternStyle(graph, elem.getAttribute("fillPatternAttrs"), hist.getFillPatternStyle(), contextName);
        }
        if (labelVarID.length() > 0) {
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), hist.getLabelStyle(), "DataText");
            str = elem.getAttribute("dataLabelFitPolicy");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("none")) {
                    hist.setDataLabelFitPolicy(HistogramOverlay.DATALABEL_FIT_NONE);
                } else if (str.equalsIgnoreCase("auto")) {
                    hist.setDataLabelFitPolicy(HistogramOverlay.DATALABEL_FIT_AUTO);
                } else if (str.equalsIgnoreCase("split")) {
                    hist.setDataLabelFitPolicy(HistogramOverlay.DATALABEL_FIT_SPLIT);
                } else if (str.equalsIgnoreCase("splitalways")) {
                    hist.setDataLabelFitPolicy(HistogramOverlay.DATALABEL_FIT_SPLITALWAYS);
                } else if (str.equalsIgnoreCase("rotate")) {
                    hist.setDataLabelFitPolicy(HistogramOverlay.DATALABEL_FIT_ROTATE);
                } else {
                    StatGraph.printOptionError("DATALABELFITPOLICY", str);
                }
            } else {
                hist.setDataLabelFitPolicy(HistogramOverlay.DATALABEL_FIT_AUTO);
            }
            ScatterParser.parseDataLabelSplitting(hist, elem);
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs") && hist.isFillOn()) {
                StatGraph.parseFillAttrs(graph, (Element)node, fillStyle);
            } else if (elemTag.equals("OutlineAttrs") && hist.isEdgeOn()) {
                StatGraph.parseLineAttrs(graph, (Element)node, hist.getEdgeStyle());
            } else if (elemTag.equals("FillPatternAttrs") && hist.isFillPatternOn()) {
                StatGraph.parseFillPatternAttrs(graph, (Element)node, hist.getFillPatternStyle());
            }
            if (!elemTag.equals("DataLabelAttrs") || labelVarID.length() <= 0) continue;
            StatGraph.parseTextAttrs(graph, (Element)node, hist.getLabelStyle());
        }
        hist.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        hist.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)hist, (byte)4, hist.getFillStyle().getTransparency());
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, hist, (byte)15);
        }
        int contrastColorCnt = graph.style.getContrastColorCount();
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, hist, (byte)17);
        }
        if (crd.isAvailable(111)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, hist, (byte)21);
        }
        graph.style.setContrastColorCount(contrastColorCnt);
        if (crd.isAvailable(112)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)hist, (byte)22, hist.getFillPatternStyle().getTransparency());
        }
        graph.style.setContrastColorCount(contrastColorCnt);
        if (crd.isAvailable(107)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)hist, (byte)25, (short)107);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    public static void parseSpecLimits(StatGraph graph, Element elem, SpecLimitsOverlay plot, DataModel model, RoleColumnMap map) {
        int col;
        String varID;
        String str = elem.getAttribute("specLimitLower");
        boolean slDefined = false;
        if (StatGraph.isNumber(str)) {
            plot.setLowerSpecLimit(Double.parseDouble(str));
            slDefined = true;
        } else if (StatGraph.isValidVar(str)) {
            varID = StatGraph.getVarID(str);
            col = model.getColumn(varID);
            map.map(53, col);
            slDefined = true;
        }
        if (slDefined) {
            GraphStyle.setDefaultDataFillStyle(graph, "", plot.getLowerFillStyle(), "GraphDataStyle1");
            Element lowElem = StatGraph.getOptionAttrsElement(elem, "SpecLimitLowerOpts");
            if (lowElem != null) {
                GraphStyle.setDefaultDataFillStyle(graph, lowElem.getAttribute("fillAttrs"), plot.getLowerFillStyle(), "GraphDataStyle1");
                Element fillElem = StatGraph.getOptionAttrsElement(lowElem, "FillAttrs");
                StatGraph.parseFillAttrs(graph, fillElem, plot.getLowerFillStyle());
                str = lowElem.getAttribute("legendLabel");
                if (str.length() > 0) {
                    plot.setLowerLegendLabel(str);
                }
            }
        }
        slDefined = false;
        str = elem.getAttribute("specLimitUpper");
        if (StatGraph.isNumber(str)) {
            plot.setUpperSpecLimit(Double.parseDouble(str));
            slDefined = true;
        } else if (StatGraph.isValidVar(str)) {
            varID = StatGraph.getVarID(str);
            col = model.getColumn(varID);
            map.map(54, col);
            slDefined = true;
        }
        if (slDefined) {
            GraphStyle.setDefaultDataFillStyle(graph, "", plot.getUpperFillStyle(), "GraphDataStyle2");
            Element highElem = StatGraph.getOptionAttrsElement(elem, "SpecLimitUpperOpts");
            if (highElem != null) {
                GraphStyle.setDefaultDataFillStyle(graph, highElem.getAttribute("fillAttrs"), plot.getUpperFillStyle(), "GraphDataStyle2");
                Element fillElem = StatGraph.getOptionAttrsElement(highElem, "FillAttrs");
                StatGraph.parseFillAttrs(graph, fillElem, plot.getUpperFillStyle());
                str = highElem.getAttribute("legendLabel");
                if (str.length() > 0) {
                    plot.setUpperLegendLabel(str);
                }
            }
        }
    }
}

