/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HighLowOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HighLowParser {
    public static final String RB_KEY = "HighLowParser.";

    public static HighLowOverlay load(StatGraph graph, Element elem) {
        HighLowOverlay highLow = (HighLowOverlay)graph.getObjectFromElement(elem);
        if (highLow == null) {
            highLow = new HighLowOverlay();
        }
        return HighLowParser.load(graph, highLow, elem) ? highLow : null;
    }

    public static boolean load(StatGraph graph, HighLowOverlay highLow, Element elem) {
        int labelcol;
        int capcol;
        String indexVarID;
        int ii;
        int crcol;
        String closeVarID;
        int closecol;
        String openVarID;
        int opencol;
        int lowcol;
        int highcol;
        String roleName;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, highLow);
        String str = elem.getAttribute("primary");
        highLow.setPrimary(str.equalsIgnoreCase("true"));
        boolean bar = false;
        str = elem.getAttribute("type");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("BAR")) {
                highLow.setType(HighLowOverlay.BAR);
                bar = true;
            } else if (str.equalsIgnoreCase("LINE")) {
                highLow.setType(HighLowOverlay.LINE);
            }
        }
        Element fillElem = null;
        Element lineElem = null;
        Element labelElem = null;
        Element fillPatternElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("FillAttrs")) {
                fillElem = (Element)node;
                continue;
            }
            if (bar && elemTag.equals("OutlineAttrs") || !bar && elemTag.equals("LineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("LabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("FillPatternAttrs")) continue;
            fillPatternElem = (Element)node;
        }
        String fillAttr = elem.getAttribute("fillAttrs");
        String lineAttr = bar ? elem.getAttribute("outlineAttrs") : elem.getAttribute("lineAttrs");
        String labelAttr = elem.getAttribute("labelAttrs");
        String fillPatternAttr = elem.getAttribute("fillPatternAttrs");
        if (highLow.getXAxis().equalsIgnoreCase("x2")) {
            highLow.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            highLow.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (highLow.getYAxis().equalsIgnoreCase("y2")) {
            highLow.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            highLow.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        boolean vertical = true;
        str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            vertical = false;
            str = elem.getAttribute("y");
            dataName = StatGraph.getDataName(str);
            if (dataName.length() == 0) {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
                graph.removeNamedGraph(highLow);
                return false;
            }
        }
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        String varID = StatGraph.getVarID(str);
        int varcol = m.getColumn(varID);
        String string = roleName = vertical ? "X" : "Y";
        if (!StatGraph.checkVariable(roleName, m.getColumnLabel(varcol), null, 1, true)) {
            graph.removeNamedGraph(highLow);
            return false;
        }
        int varRole = vertical ? 10 : 11;
        map.map(varRole, varcol);
        highLow.addRole(roleName, m.getColumnLabel(varcol));
        str = elem.getAttribute("high");
        if (StatGraph.getDataName(str).length() > 0) {
            String highVarID = StatGraph.getVarID(str);
            highcol = m.getColumn(highVarID);
            if (!StatGraph.checkVariable("HIGH", m.getColumnLabel(highcol), Double.class, 1, true)) {
                graph.removeNamedGraph(highLow);
                return false;
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "highlow.txt"));
            graph.removeNamedGraph(highLow);
            return false;
        }
        map.map(60, highcol);
        highLow.addRole("HIGH", m.getColumnLabel(highcol));
        str = elem.getAttribute("low");
        if (StatGraph.getDataName(str).length() > 0) {
            String lowVarID = StatGraph.getVarID(str);
            lowcol = m.getColumn(lowVarID);
            if (!StatGraph.checkVariable("LOW", m.getColumnLabel(lowcol), Double.class, 1, true)) {
                graph.removeNamedGraph(highLow);
                return false;
            }
        } else {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "highlow.txt"));
            graph.removeNamedGraph(highLow);
            return false;
        }
        map.map(61, lowcol);
        highLow.addRole("LOW", m.getColumnLabel(lowcol));
        str = elem.getAttribute("open");
        if (StatGraph.getDataName(str).length() > 0 && StatGraph.checkVariable("OPEN", m.getColumnLabel(opencol = m.getColumn(openVarID = StatGraph.getVarID(str))), Double.class, 1, true)) {
            map.map(62, opencol);
            highLow.addRole("OPEN", m.getColumnLabel(opencol));
        }
        if (StatGraph.getDataName(str = elem.getAttribute("close")).length() > 0 && StatGraph.checkVariable("CLOSE", m.getColumnLabel(closecol = m.getColumn(closeVarID = StatGraph.getVarID(str))), Double.class, 1, true)) {
            map.map(63, closecol);
            highLow.addRole("CLOSE", m.getColumnLabel(closecol));
        }
        highLow.setEdgeOn(false);
        highLow.setFillOn(false);
        highLow.setFillPatternOn(false);
        str = elem.getAttribute("display");
        if (str.length() == 0 && (str = graph.style.getStyleAttribute("HighLow", "displayOpts")) == null) {
            str = "";
        }
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                highLow.setEdgeOn(true);
                highLow.setFillOn(true);
                highLow.setFillPatternOn(true);
            } else {
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        highLow.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        highLow.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        highLow.setFillPatternOn(true);
                        continue;
                    }
                    highLow.setEdgeOn(true);
                    highLow.setFillOn(true);
                    highLow.setFillPatternOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        if (!(highLow.isEdgeOn() || highLow.isFillOn() || highLow.isFillPatternOn())) {
            highLow.setEdgeOn(true);
            highLow.setFillOn(true);
            highLow.setFillPatternOn(false);
        }
        boolean gradientColor = false;
        boolean fixedColor = false;
        fixedColor = highLow.getType() == HighLowOverlay.BAR ? highLow.isFillOn() && StatGraph.isBundleAttributeFixed(elem, "fillAttrs", "color") || !highLow.isFillOn() && StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "color") : StatGraph.isBundleAttributeFixed(elem, "lineAttrs", "color");
        str = elem.getAttribute("colorResponse");
        String crVarID = StatGraph.getVarID(str);
        if (crVarID.length() > 0 && StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
            gradientColor = true;
            if (highLow.getType() == HighLowOverlay.BAR && highLow.isFillOn()) {
                map.map(6, crcol);
            } else {
                map.map(46, crcol);
            }
            highLow.addRole("COLORRESPONSE", m.getColumnLabel(crcol));
            str = elem.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                highLow.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
            }
        }
        highLow.setGradientColor(gradientColor);
        boolean groupOn = false;
        str = elem.getAttribute("group");
        if (str.length() > 0) {
            String gVarID = StatGraph.getVarID(str);
            if (!LayoutOverlayParser.hasTooManyGroups(graph, m, StatGraph.getVarID(str), highLow.getStmt())) {
                groupOn = true;
                int gcol = m.getColumn(gVarID);
                map.map(3, gcol);
                if (!(gradientColor || !bar || fillElem != null && fillElem.hasAttribute("color") || fillAttr.length() != 0)) {
                    map.map(6, gcol);
                }
                if (!(gradientColor || lineElem != null && lineElem.hasAttribute("color") || lineAttr.length() != 0)) {
                    map.map(46, gcol);
                }
                if (!(lineElem != null && lineElem.hasAttribute("pattern") || lineAttr.length() != 0)) {
                    map.map(36, gcol);
                }
                if (bar && (fillPatternElem == null || !fillPatternElem.hasAttribute("pattern")) && fillPatternAttr.length() == 0) {
                    map.map(111, gcol);
                }
                if (!(gradientColor || !bar || fillPatternElem != null && fillPatternElem.hasAttribute("color") || fillPatternAttr.length() != 0)) {
                    map.map(112, gcol);
                }
                if (!(gradientColor || map.isRoleMapped(46) || labelElem != null && labelElem.hasAttribute("color") || labelAttr.length() != 0)) {
                    map.map(46, gcol);
                    highLow.setUseLineColor(true);
                }
                highLow.addRole("GROUP", m.getColumnLabel(gcol));
                str = elem.getAttribute("includeMissingGroup");
                if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                    highLow.setMissingGroupOn(false);
                }
                if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                    highLow.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, highLow, "GROUP", gVarID);
                }
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            map.map(44, ii);
            highLow.addRole("INDEX", m.getColumnLabel(ii));
        }
        if ((str = elem.getAttribute("highCap")).length() > 0) {
            if (elem.getAttribute("highCap_type").equalsIgnoreCase("VARIABLE") && StatGraph.isValidVar(str)) {
                String capVarID = StatGraph.getVarID(str);
                capcol = m.getColumn(capVarID);
                map.map(64, capcol);
                highLow.addRole("HIGHCAP", m.getColumnLabel(capcol));
            } else {
                int cap = HighLowOverlay.getCapType(str);
                if (cap >= 0 && cap != 5) {
                    highLow.setHighCap(cap);
                } else {
                    StatGraph.printOptionError("HIGHCAP", str);
                }
            }
        }
        if ((str = elem.getAttribute("lowCap")).length() > 0) {
            if (elem.getAttribute("lowCap_type").equalsIgnoreCase("VARIABLE") && StatGraph.isValidVar(str)) {
                String capVarID = StatGraph.getVarID(str);
                capcol = m.getColumn(capVarID);
                map.map(65, capcol);
                highLow.addRole("LOWCAP", m.getColumnLabel(capcol));
            } else {
                int cap = HighLowOverlay.getCapType(str);
                if (cap >= 0 && cap != 5) {
                    highLow.setLowCap(cap);
                } else {
                    StatGraph.printOptionError("LOWCAP", str);
                }
            }
        }
        if ((str = elem.getAttribute("clipCap")).length() > 0 && str.equalsIgnoreCase("true")) {
            highLow.setClipCap(true);
        }
        if (highLow.isClipCap() && (str = elem.getAttribute("clipCapShape")).length() > 0 && !str.equalsIgnoreCase("default")) {
            int cap = HighLowOverlay.getCapType(str);
            if (cap > 0) {
                highLow.setClipCapShape(cap);
            } else {
                StatGraph.printOptionError("CLIPCAPSHAPE", str);
            }
        }
        if ((str = elem.getAttribute("highLabel")).length() > 0 && StatGraph.isValidVar(str)) {
            String labelVarID = StatGraph.getVarID(str);
            labelcol = m.getColumn(labelVarID);
            map.map(66, labelcol);
            highLow.addRole("HIGHLABEL", m.getColumnLabel(labelcol));
        }
        if ((str = elem.getAttribute("lowLabel")).length() > 0 && StatGraph.isValidVar(str)) {
            String labelVarID = StatGraph.getVarID(str);
            labelcol = m.getColumn(labelVarID);
            map.map(67, labelcol);
            highLow.addRole("LOWLABEL", m.getColumnLabel(labelcol));
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, highLow);
        StatGraph.parseURLOpt(elem, m, map, highLow);
        str = elem.getAttribute("groupDisplay");
        if (str.equalsIgnoreCase("Cluster")) {
            highLow.setGroupDisplay(0);
        } else {
            highLow.setGroupDisplay(1);
        }
        str = elem.getAttribute("groupOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("Ascending")) {
                highLow.setGroupOrder(1);
            } else if (str.equalsIgnoreCase("Descending")) {
                highLow.setGroupOrder(2);
            } else if (str.equalsIgnoreCase("Data")) {
                highLow.setGroupOrder(0);
            } else if (str.equalsIgnoreCase("ReverseData")) {
                highLow.setGroupOrder(3);
            } else {
                highLow.setGroupOrder(0);
                StatGraph.printOptionError("GROUPORDER", str);
            }
        } else if (graph.isCASData()) {
            highLow.setGroupOrder(1);
        }
        if (graph.isCASData()) {
            highLow.setDrawByGroupOrder(true);
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !HighLowParser.isDiscreteOffsetSupported(highLow)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
        } else if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                highLow.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, highLow);
        if (highLow.isTooltipEnabled()) {
            highLow.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        if (highLow.getType() == HighLowOverlay.BAR && (highLow.isFillOn() || highLow.isFillPatternOn()) && map.isRoleMapped(36)) {
            map.unmapRole(36);
        }
        highLow.setModel(crd);
        str = elem.getAttribute("skin");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("modern")) {
                highLow.setSkinType(1);
            } else if (str.equalsIgnoreCase("satin")) {
                highLow.setSkinType(2);
            } else if (!str.equalsIgnoreCase("none")) {
                StatGraph.printOptionError("SKIN", str);
            }
        }
        StatGraph.parseDataSkinOpt(graph, elem, highLow);
        if (highLow.getSkinType() == 3 && highLow.getType() == HighLowOverlay.LINE) {
            highLow.setSkinType(0);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("clusterWidth"))) {
            double width = Double.parseDouble(str);
            highLow.setClusterWidth(width);
        }
        if (!groupOn || groupOn && highLow.getGroupDisplay() == 1) {
            highLow.setClusterWidth(1.0);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("barWidth"))) {
            double width = Double.parseDouble(str);
            highLow.setBarWidth(width);
        } else if (groupOn && highLow.getGroupDisplay() == 0) {
            highLow.setBarWidth(1.0);
        }
        str = elem.getAttribute("intervalBarWidth");
        if (StatGraph.isInteger(str)) {
            int width = Integer.parseInt(str);
            highLow.setIntervalBarWidth(width);
        }
        if ((str = elem.getAttribute("endCapDisplayPolicy")).length() > 0) {
            if (highLow.getType() == HighLowOverlay.LINE) {
                if (str.equalsIgnoreCase("always")) {
                    highLow.setCapDisplayPolicy(HighLowOverlay.CAP_DISPLAY_ALWAYS);
                } else if (str.equalsIgnoreCase("auto")) {
                    highLow.setCapDisplayPolicy(HighLowOverlay.CAP_DISPLAY_AUTO);
                } else {
                    StatGraph.printOptionError("ENDCAPDISPLAYPOLICY", str);
                }
            } else {
                StatGraph.printWarning(RB.getStringResource(RB_KEY, "capdisplay.txt"));
            }
        }
        String contextName = graph.style.getContextName();
        highLow.setContextName(contextName);
        if (bar) {
            if (graph.style.isCycleAttrs()) {
                GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), highLow.getLineStyle(), contextName);
            } else {
                GraphStyle.setDefaultLineStyle(graph, lineAttr, highLow.getLineStyle(), "Outlines");
            }
        } else {
            GraphStyle.setDefaultDataLineStyle(graph, lineAttr, highLow.getLineStyle(), contextName);
        }
        if (lineElem != null) {
            StatGraph.parseLineAttrs(graph, lineElem, highLow.getLineStyle());
        }
        if (bar && highLow.isFillOn()) {
            GraphStyle.setDefaultDataFillStyle(graph, fillAttr, highLow.getFillStyle(), contextName);
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, highLow.getFillStyle());
            }
        }
        if (bar && highLow.isFillPatternOn()) {
            GraphStyle.setDefaultFillPatternStyle(graph, fillPatternAttr, highLow.getFillPatternStyle(), contextName);
            if (fillPatternElem != null) {
                StatGraph.parseFillPatternAttrs(graph, fillPatternElem, highLow.getFillPatternStyle());
            }
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), highLow.getLabelStyle(), "DataText");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, highLow.getLabelStyle());
            if (labelElem.hasAttribute("color")) {
                highLow.setUseLabelColor(true);
            }
        }
        highLow.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        highLow.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, bar ? "outlineAttrs" : "lineAttrs", "thickness"));
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (gradientColor) {
            Color missingColor = null;
            ColorEncoder encoder = bar && highLow.getFillStyle() != null && highLow.getFillStyle().getTransparency() >= 0.0 ? StatGraph.parseColorModelOpt((byte)4, graph, elem, highLow, highLow.getFillStyle().getTransparency()) : StatGraph.parseColorModelOpt((byte)4, graph, elem, highLow);
            if (encoder != null) {
                highLow.setEncoder((byte)4, encoder);
                missingColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getFillColor();
            }
            if ((encoder = StatGraph.parseColorModelOpt((byte)17, graph, elem, highLow)) != null) {
                highLow.setEncoder((byte)17, encoder);
                missingColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
            }
            if (bar && highLow.getFillStyle() != null && highLow.getFillStyle().getTransparency() >= 0.0) {
                highLow.setMissingColorResponseColor(HighLowOverlay.applyTransparency(missingColor, highLow.getFillStyle().getTransparency()));
            } else {
                highLow.setMissingColorResponseColor(highLow.applyDataTransparency(missingColor));
            }
        } else {
            if (crd.isAvailable(6)) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)highLow, (byte)4, highLow.getFillStyle().getTransparency());
            }
            int contrastColorCnt = graph.style.getContrastColorCount();
            if (crd.isAvailable(46)) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, highLow, (byte)17);
            }
            graph.style.setContrastColorCount(contrastColorCnt);
            if (crd.isAvailable(112)) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, highLow, (byte)22);
            }
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, highLow, (byte)15);
        }
        if (crd.isAvailable(111)) {
            graph.style.setContextCount(contextCount);
            LayoutOverlayParser.setDiscreteEncoder(graph, highLow, (byte)21);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    private static boolean isDiscreteOffsetSupported(HighLowOverlay plot) {
        return plot.isDiscreteX() || plot.isDiscreteY();
    }

    public static boolean isUnderLatticeLayout(Element elem) {
        Node parentNode = elem.getParentNode();
        String name = parentNode.getNodeName();
        if (name.equalsIgnoreCase("LayoutPrototype") || name.equalsIgnoreCase("LayoutPrototypeOverlay2D")) {
            return true;
        }
        if (name.equalsIgnoreCase("LayoutLattice")) {
            return true;
        }
        return name.equalsIgnoreCase("LayoutOverlay") && (name = (parentNode = parentNode.getParentNode()).getNodeName()).equalsIgnoreCase("LayoutLattice");
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = "";
        str = elem.getAttribute("high");
        String dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            return null;
        }
        DataModel model = graph.getData(dataName);
        String highVarID = StatGraph.getVarID(str);
        int highCol = model.getColumn(highVarID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(highCol);
        int depType = 0;
        if (cmd.getType() == 2) {
            return null;
        }
        depType = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        str = elem.getAttribute("x");
        dataName = StatGraph.getDataName(str);
        if (dataName.length() == 0) {
            str = elem.getAttribute("y");
            String yVarID = StatGraph.getVarID(str);
            int ycol = model.getColumn(yVarID);
            cmd = (ColumnMetadata)model.getColumnLabel(ycol);
            if (cmd.getType() == 2) {
                if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                    return null;
                }
                types[1] = 2;
            } else {
                types[1] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            }
            types[0] = depType;
        } else {
            String xVarID = StatGraph.getVarID(str);
            int xcol = model.getColumn(xVarID);
            cmd = (ColumnMetadata)model.getColumnLabel(xcol);
            if (cmd.getType() == 2) {
                if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
                    return null;
                }
                types[0] = 2;
            } else {
                types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
            }
            types[1] = depType;
        }
        types[2] = 0;
        return types;
    }
}

