/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.HeatMapParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import java.util.Collections;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HeatMapParmParser {
    public static final String RB_KEY = "HeatMapParmParser.";

    public static HeatMapParmOverlay load(StatGraph graph, Element elem) {
        HeatMapParmOverlay heatmap = (HeatMapParmOverlay)graph.getObjectFromElement(elem);
        if (heatmap == null) {
            heatmap = new HeatMapParmOverlay();
        }
        return HeatMapParmParser.load(graph, heatmap, elem) ? heatmap : null;
    }

    public static boolean load(StatGraph graph, HeatMapParmOverlay heatmap, Element elem) {
        int nBins;
        double[] yBoundaries;
        double[] xBoundaries;
        boolean discreteAxis;
        graph.addSupportedGraph();
        RoleColumnMap map = new RoleColumnMap();
        DataModel model = HeatMapParmParser.parseXYVariables(heatmap, graph, elem, map);
        if (model == null) {
            graph.removeNamedGraph(heatmap);
            return false;
        }
        String str = elem.getAttribute("primary");
        heatmap.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, heatmap);
        boolean discreteX = false;
        discreteX = model.getColumnClass(map.getColumn(10)) == Double.class ? elem.getAttribute("discreteX").equalsIgnoreCase("true") : true;
        boolean discreteY = false;
        discreteY = model.getColumnClass(map.getColumn(11)) == Double.class ? elem.getAttribute("discreteY").equalsIgnoreCase("true") : true;
        if (heatmap.getXAxis().equalsIgnoreCase("x2")) {
            discreteAxis = LayoutOverlayParser.x2AxisType == 2;
        } else {
            boolean bl = discreteAxis = LayoutOverlayParser.xAxisType == 2;
        }
        if (discreteX != discreteAxis) {
            graph.removeNamedGraph(heatmap);
            Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)heatmap.getStmt()));
            return false;
        }
        heatmap.setDiscreteX(discreteAxis);
        if (heatmap.getYAxis().equalsIgnoreCase("y2")) {
            discreteAxis = LayoutOverlayParser.y2AxisType == 2;
        } else {
            boolean bl = discreteAxis = LayoutOverlayParser.yAxisType == 2;
        }
        if (discreteY != discreteAxis) {
            graph.removeNamedGraph(heatmap);
            Message msg = new Message(RB.getStringResource("LayoutOverlayParser.", "axis.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)heatmap.getStmt()));
            return false;
        }
        heatmap.setDiscreteY(discreteAxis);
        boolean colorGroup = false;
        boolean colorResponse = false;
        if (elem.hasAttribute("colorResponse")) {
            str = elem.getAttribute("colorResponse");
            String colorResponseVarID = StatGraph.getVarID(str);
            int colorResponseCol = model.getColumn(colorResponseVarID);
            if (!StatGraph.checkVariable("colorResponse", model.getColumnLabel(colorResponseCol), Double.class, 1, true)) {
                graph.removeNamedGraph(heatmap);
                return false;
            }
            map.map(108, colorResponseCol);
            heatmap.addRole("COLORRESPONSE", model.getColumnLabel(colorResponseCol));
            str = elem.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                heatmap.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
            }
            colorResponse = true;
        } else if (elem.hasAttribute("colorGroup")) {
            str = elem.getAttribute("colorGroup");
            String colorGroupVarID = StatGraph.getVarID(str);
            int colorGroupCol = model.getColumn(colorGroupVarID);
            if (!StatGraph.checkVariable("colorGroup", model.getColumnLabel(colorGroupCol), null, 1, true)) {
                graph.removeNamedGraph(heatmap);
                return false;
            }
            if (LayoutOverlayParser.hasTooManyUniqueValues(graph, model, colorGroupVarID, "COLORGROUP", heatmap.getStmt())) {
                graph.removeNamedGraph(heatmap);
                return false;
            }
            map.map(107, colorGroupCol);
            heatmap.addRole("COLORGROUP", model.getColumnLabel(colorGroupCol));
            str = elem.getAttribute("colorGroupAttrVar");
            if (str.length() > 0) {
                heatmap.addAttrVar("COLORGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                DAMDatasetParser.addInternalAttrVar(graph, heatmap, "COLORGROUP", colorGroupVarID);
            }
            if (graph.isCASData()) {
                heatmap.setGroupOrder(1);
            }
            colorGroup = true;
        }
        if (!colorResponse && !colorGroup) {
            graph.removeNamedGraph(heatmap);
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "required.txt"));
            return false;
        }
        if (elem.hasAttribute("includeMissingColor") && "false".equalsIgnoreCase(str = elem.getAttribute("includeMissingColor"))) {
            heatmap.setIncludeMissingColor(false);
        }
        FillAttrs fillAttrs = heatmap.getFillAttrs();
        HeatMapParmParser.parseFillAttrs(graph, elem, "fillAttrs", "FillAttrs", graph.style.getContextName(), fillAttrs);
        LineAttrs outlineAttrs = heatmap.getOutlineAttrs();
        HeatMapParmParser.parseLineAttrs(graph, elem, "outlineAttrs", "OutlineAttrs", "Outlines", outlineAttrs);
        heatmap.setOutlineAttrs(outlineAttrs);
        heatmap.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, "FillAttrs"));
        heatmap.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        if (elem.hasAttribute("xValues")) {
            str = elem.getAttribute("xValues");
            if (str.equalsIgnoreCase("LEFTPOINTS")) {
                heatmap.setXValues(333662);
            } else if (str.equalsIgnoreCase("RIGHTPOINTS")) {
                heatmap.setXValues(333663);
            } else if (str.equalsIgnoreCase("MIDPOINTS")) {
                heatmap.setXValues(333661);
            } else {
                heatmap.setXValues(333661);
                if (str.length() > 0) {
                    StatGraph.printOptionError("XVALUES", str);
                }
            }
        }
        if (elem.hasAttribute("xBinAxis")) {
            str = elem.getAttribute("xBinAxis");
            heatmap.setXBinAxis(str.equalsIgnoreCase("true"));
        }
        if (elem.hasAttribute("xEndLabels")) {
            str = elem.getAttribute("xEndLabels");
            heatmap.setXEndLabels(str.equalsIgnoreCase("true"));
        }
        if (elem.hasAttribute("xBinSize")) {
            str = elem.getAttribute("xBinSize");
            heatmap.setXBinSize(Double.parseDouble(str));
        }
        if (elem.hasAttribute("xGap")) {
            heatmap.setXGap(Double.parseDouble(elem.getAttribute("xGap")));
        }
        if ((xBoundaries = HeatMapParmParser.parseBoundaries(elem, "XBoundaryValues", "XBOUNDARIES", heatmap, model, "X")) != null) {
            heatmap.setXBoundaries(xBoundaries);
        }
        if (elem.hasAttribute("yValues")) {
            str = elem.getAttribute("yValues");
            if (str.equalsIgnoreCase("LEFTPOINTS")) {
                heatmap.setYValues(333662);
            } else if (str.equalsIgnoreCase("RIGHTPOINTS")) {
                heatmap.setYValues(333663);
            } else if (str.equalsIgnoreCase("MIDPOINTS")) {
                heatmap.setYValues(333661);
            } else {
                heatmap.setYValues(333661);
                if (str.length() > 0) {
                    StatGraph.printOptionError("YVALUES", str);
                }
            }
        }
        if (elem.hasAttribute("yBinAxis")) {
            str = elem.getAttribute("yBinAxis");
            heatmap.setYBinAxis(str.equalsIgnoreCase("true"));
        }
        if (elem.hasAttribute("yEndLabels")) {
            str = elem.getAttribute("yEndLabels");
            heatmap.setYEndLabels(str.equalsIgnoreCase("true"));
        }
        if (elem.hasAttribute("yBinSize")) {
            str = elem.getAttribute("yBinSize");
            heatmap.setYBinSize(Double.parseDouble(str));
        }
        if (elem.hasAttribute("yGap")) {
            heatmap.setYGap(Double.parseDouble(elem.getAttribute("yGap")));
        }
        if ((yBoundaries = HeatMapParmParser.parseBoundaries(elem, "YBoundaryValues", "YBOUNDARIES", heatmap, model, "Y")) != null) {
            heatmap.setYBoundaries(yBoundaries);
        }
        heatmap.setMissingColor(graph.style.getGraphStyle().getFillStyleElement("Missing").getFillColor());
        if (elem.hasAttribute("display")) {
            heatmap.setDisplayMode(elem.getAttribute("display"));
        }
        StatGraph.parseURLOpt(elem, model, map, heatmap);
        LayoutOverlayParser.parseRoleTipStuff(elem, model, map, heatmap);
        CRD crd = new CRD();
        crd.setSrcModel(model);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, heatmap);
        str = elem.getAttribute("dataSelectable");
        if (str.equalsIgnoreCase("true")) {
            heatmap.setDataSelectable(true);
        }
        if (heatmap.isTooltipEnabled()) {
            heatmap.setTooltipEnabled(graph.updateTipMax(model.getRowCount()));
        }
        heatmap.setModel(crd);
        if (heatmap.getStmt() != null && heatmap.getStmt().equalsIgnoreCase("HeatMapParm") && (nBins = heatmap.getNBinsExceedingMax(graph.nXYBinsMax)) > 0) {
            graph.removeNamedGraph(heatmap);
            Message msg = new Message(RB.getStringResource(RB_KEY, "nbins.fmt.txt"));
            StatGraph.printWarning(msg.toString((Object)heatmap.getStmt(), (Object)nBins), false);
            return false;
        }
        graph.style.recordCurrentCounters();
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(graph.style.getContextCount());
        }
        if (crd.isAvailable(108)) {
            ColorEncoder encoder = null;
            encoder = fillAttrs != null && fillAttrs.getTransparency() > 0.0 ? StatGraph.parseColorModelOpt((byte)4, graph, elem, heatmap, fillAttrs.getTransparency()) : StatGraph.parseColorModelOpt((byte)4, graph, elem, heatmap);
            if (encoder != null) {
                heatmap.setEncoder((byte)4, encoder);
            }
        } else if (crd.isAvailable(107)) {
            if (fillAttrs != null && fillAttrs.getTransparency() > 0.0) {
                LayoutOverlayParser.setDiscreteEncoder(graph, heatmap, (byte)4, (short)107, fillAttrs.getTransparency(), false);
            } else {
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)heatmap, (byte)4, (short)107, false);
            }
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    private static double[] parseBoundaries(Element elem, String tagName, String optionName, HeatMapParmOverlay heatmap, DataModel model, String role) {
        ColumnMetadata cmd = heatmap.getRoleMetadata(role);
        if ((cmd = (ColumnMetadata)model.getColumnLabel(model.getColumn(cmd.getName()))).getType() == 2) {
            return null;
        }
        double[] boundaries = null;
        NodeList nodeList = elem.getElementsByTagName(tagName);
        if (nodeList != null && nodeList.getLength() > 0) {
            Element boundaryValues = (Element)nodeList.item(0);
            NodeList valuesList = boundaryValues.getElementsByTagName("Value");
            int nl = valuesList.getLength();
            if (nl > 0) {
                int i;
                Vector<Double> v = new Vector<Double>();
                for (i = 0; i < nl; ++i) {
                    Node nd = valuesList.item(i);
                    if ("MIN".equalsIgnoreCase(nd.getTextContent())) {
                        v.add(cmd.getMin());
                        continue;
                    }
                    if ("MAX".equalsIgnoreCase(nd.getTextContent())) {
                        v.add(cmd.getMax());
                        continue;
                    }
                    try {
                        double d = Double.parseDouble(nd.getTextContent());
                        v.add(d);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "NonNumericValue.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)optionName));
                        break;
                    }
                }
                if (v.size() > 1) {
                    Collections.sort(v);
                    boundaries = new double[v.size()];
                    for (i = 0; i < v.size(); ++i) {
                        boundaries[i] = (Double)v.get(i);
                    }
                } else {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "InsufficientLength.fmt.txt"));
                    StatGraph.printNote(msg.toString((Object)optionName));
                }
            } else {
                Message msg = new Message(RB.getStringResource(RB_KEY, "EmptyBoundaryList.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)optionName));
            }
        }
        return boundaries;
    }

    public static DataModel parseXYVariables(HeatMapParmOverlay heatmap, StatGraph graph, Element elem, RoleColumnMap map) {
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        DataModel model = graph.getData(dataName);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        if (!StatGraph.checkVariable("X", model.getColumnLabel(xcol), null, 1, true) || !StatGraph.checkVariable("Y", model.getColumnLabel(ycol), null, 1, true)) {
            return null;
        }
        map.map(10, xcol);
        map.map(11, ycol);
        heatmap.addRole("X", model.getColumnLabel(xcol));
        heatmap.addRole("Y", model.getColumnLabel(ycol));
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        DataModel model = graph.getData(dataName);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol);
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
                return null;
            }
            types[0] = 2;
        } else {
            types[0] = elem.getAttribute("discreteX").equalsIgnoreCase("true") ? 2 : (cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0);
        }
        cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                return null;
            }
            types[1] = 2;
        } else {
            types[1] = elem.getAttribute("discreteY").equalsIgnoreCase("true") ? 2 : (cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0);
        }
        types[2] = 0;
        return types;
    }

    private static FillAttrs parseFillAttrs(StatGraph graph, Element elem, String attrName, String attrElemName, String defaultStyleElem, FillAttrs fa) {
        if (fa == null) {
            fa = new FillAttrs();
        }
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute(attrName), fa, defaultStyleElem);
        Element fe = StatGraph.getOptionAttrsElement(elem, attrElemName);
        if (fe != null) {
            StatGraph.parseFillAttrs(graph, fe, fa);
        }
        return fa;
    }

    private static LineAttrs parseLineAttrs(StatGraph graph, Element elem, String attrName, String attrElem, String defaultStyleElem, LineAttrs la) {
        if (la == null) {
            la = new LineAttrs();
        }
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute(attrName), la, defaultStyleElem);
        Element le = StatGraph.getOptionAttrsElement(elem, attrElem);
        if (le != null) {
            StatGraph.parseLineAttrs(graph, le, la);
        }
        return la;
    }
}

