/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.SGAnnotationContainer;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.entry.Entry;
import com.sas.graphics.applets.statgraph.sgchart.entry.EntryStub;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.entry.Table;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class GridPanelParser
extends GraphComponentParser {
    public static final String RB_KEY = "GridPanelParser.";

    public static boolean load(StatGraph graph, Element element, JComponent component, JComponent container) {
        Color clr;
        graph.pushFontsShrinkage(element);
        boolean ok = GraphComponentParser.load(graph, element, component, container);
        int rowGutter = 0;
        int columnGutter = 0;
        StatGraph.parseBorderOpts(graph, component, element, null);
        GridPanel panel = (GridPanel)component;
        String s = element.getAttribute("rows");
        if (!s.equals("")) {
            panel.setRows(Integer.parseInt(s));
        }
        if (!(s = element.getAttribute("columns")).equals("")) {
            panel.setColumns(Integer.parseInt(s));
        }
        if ((s = element.getAttribute("order")).equalsIgnoreCase("rowMajor")) {
            panel.setOrder(0);
        } else if (s.equalsIgnoreCase("columnMajor")) {
            panel.setOrder(1);
        } else if (s.length() > 0) {
            StatGraph.printOptionError("ORDER", s);
        }
        s = element.getAttribute("rowGutter");
        if (s.length() > 0) {
            rowGutter = Integer.parseInt(s);
        }
        if ((s = element.getAttribute("columnGutter")).length() > 0) {
            columnGutter = Integer.parseInt(s);
        }
        if ((clr = StatGraph.parseAttrColor("gridColor", graph, element)) != null) {
            panel.setForeground(clr);
        }
        if (!(s = element.getAttribute("cellBackground")).equals("")) {
            panel.setCellBackground(StatGraph.parseList2Color(s));
        }
        GridBagConstraints c = new GridBagConstraints();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element ee = (Element)node;
            String tag = ee.getTagName();
            if (tag.startsWith("Draw")) {
                SGAnnotationContainer ac = new SGAnnotationContainer(panel, graph.rootPanel);
                AbstractAnno text = AnnotateParser.load(graph, ee, (AnnotationContainer)ac);
                if (text == null) continue;
                if ("back".equalsIgnoreCase(ee.getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                    continue;
                }
                graph.annotationInFrontList.add(text);
                continue;
            }
            JComponent comp = StatGraph.parseComponent(graph, (Element)node, panel);
            if (comp == null) continue;
            int fill = c.fill = GridPanelParser.getFill(comp);
            c.weighty = 0.0;
            c.weightx = 0.0;
            if (fill == 2 || fill == 1) {
                c.weightx = 1.0;
            }
            if (fill == 3 || fill == 1) {
                c.weighty = 1.0;
            }
            c.anchor = GridPanelParser.getAnchor(comp);
            panel.add((Component)comp, c);
        }
        if (rowGutter > 0) {
            panel.setRowGutters(rowGutter);
        }
        if (columnGutter > 0) {
            panel.setColumnGutters(columnGutter);
        }
        graph.popFontsShrinkage(element);
        return ok;
    }

    public static int getFill(Component component) {
        int fill = 1;
        if (component instanceof Entry || component instanceof EntryStub || component instanceof Legend) {
            fill = 0;
        } else if (GridPanelParser.isEntryConcat(component)) {
            fill = 2;
        } else if (component instanceof LegendComponent) {
            fill = ((LegendComponent)component).isHorizontal() ? 2 : 3;
        } else if (component instanceof GridPanel || component instanceof OverlayContainer || component instanceof TrellisPlot || component instanceof Table) {
            int maxFill = 1;
            Component[] components = ((Container)component).getComponents();
            if (component instanceof AbstractSGComponent && ((AbstractSGComponent)component).getUserHeight() >= 0 && ((AbstractSGComponent)component).getUserWidth() >= 0) {
                maxFill = 0;
            } else if (component instanceof AbstractSGComponent && ((AbstractSGComponent)component).getUserHeight() >= 0) {
                maxFill = 2;
            } else if (component instanceof AbstractSGComponent && ((AbstractSGComponent)component).getUserWidth() >= 0) {
                maxFill = 3;
            }
            fill = 0;
            for (int i = 0; i < components.length; ++i) {
                int myFill = GridPanelParser.getFill(components[i]);
                if (fill == myFill || fill != 0 && myFill != 1) continue;
                fill = maxFill == 1 ? myFill : maxFill;
            }
        }
        return fill;
    }

    public static boolean isEntryConcat(Component component) {
        return component instanceof EntryComposite;
    }

    private static boolean isSingleEntry(Component component) {
        if (component instanceof EntryComposite) {
            EntryComposite ec = (EntryComposite)component;
            Component[] components = ec.getComponents();
            return components.length == 1 && components[0] instanceof JTextPane;
        }
        return false;
    }

    public static int getAnchor(Component comp) {
        int anchor = 10;
        anchor = (double)comp.getAlignmentX() == 0.0 ? ((double)comp.getAlignmentY() == 0.0 ? 18 : ((double)comp.getAlignmentY() == 1.0 ? 16 : 17)) : ((double)comp.getAlignmentX() == 1.0 ? ((double)comp.getAlignmentY() == 0.0 ? 12 : ((double)comp.getAlignmentY() == 1.0 ? 14 : 13)) : ((double)comp.getAlignmentY() == 0.0 ? 11 : ((double)comp.getAlignmentY() == 1.0 ? 15 : 10)));
        return anchor;
    }

    public static void resolveReferences(Container container, Component oldComponent, Component[] newComponents) {
        int i;
        Component[] components = container.getComponents();
        GridBagConstraints[] constraints = new GridBagConstraints[components.length];
        GridBagLayout l = (GridBagLayout)container.getLayout();
        for (int i2 = 0; i2 < components.length; ++i2) {
            constraints[i2] = l.getConstraints(components[i2]);
        }
        int index = -1;
        for (int i3 = 0; index < 0 && i3 < components.length; ++i3) {
            if (!components[i3].equals(oldComponent)) continue;
            index = i3;
        }
        container.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        for (i = 0; i < index; ++i) {
            c.fill = constraints[i].fill;
            c.weightx = constraints[i].weightx;
            c.weighty = constraints[i].weighty;
            c.anchor = constraints[i].anchor;
            container.add(components[i], c);
        }
        for (int j = 0; j < newComponents.length; ++j) {
            if (newComponents[j] instanceof LegendComponent) {
                c.fill = constraints[i].fill;
                c.weightx = constraints[i].weightx;
                c.weighty = constraints[i].weighty;
            } else {
                c.fill = 0;
                c.weightx = 0.0;
                c.weighty = 0.0;
            }
            c.anchor = GridPanelParser.getAnchor(newComponents[j]);
            container.add(newComponents[j], c);
        }
        for (i = index + 1; i < components.length; ++i) {
            c.fill = constraints[i].fill;
            c.weightx = constraints[i].weightx;
            c.weighty = constraints[i].weighty;
            c.anchor = constraints[i].anchor;
            container.add(components[i], c);
        }
    }
}

