/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.CarpetOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import org.w3c.dom.Element;

public final class FringeParser {
    public static CarpetOverlay load(StatGraph graph, Element elem) {
        CarpetOverlay carpet = (CarpetOverlay)graph.getObjectFromElement(elem);
        if (carpet == null) {
            carpet = new CarpetOverlay();
        }
        return FringeParser.load(graph, carpet, elem) ? carpet : null;
    }

    public static boolean load(StatGraph graph, CarpetOverlay carpet, Element elem) {
        String indexVarID;
        int ii;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, carpet);
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), Double.class, 1, true)) {
            graph.removeNamedGraph(carpet);
            return false;
        }
        if (carpet.isTooltipEnabled()) {
            carpet.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
        }
        map.map(10, xcol);
        carpet.addRole("X", m.getColumnLabel(xcol));
        Element lineElem = StatGraph.getOptionAttrsElement(elem, "LineAttrs");
        String lineAttrs = elem.getAttribute("lineAttrs");
        str = elem.getAttribute("group");
        String groupVarID = StatGraph.getVarID(str);
        if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID, carpet.getStmt())) {
            groupVarID = "";
        }
        if (groupVarID.length() > 0) {
            int gcol = m.getColumn(groupVarID);
            boolean groupMapped = false;
            if (!(lineElem != null && lineElem.hasAttribute("color") || lineAttrs.length() != 0)) {
                map.map(46, gcol);
                map.map(3, gcol);
                carpet.addRole("GROUP", m.getColumnLabel(gcol));
                groupMapped = true;
            }
            if (groupMapped) {
                str = elem.getAttribute("groupAttrVar");
                if (str.length() > 0) {
                    carpet.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, carpet, "GROUP", groupVarID);
                }
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                carpet.setMissingGroupOn(false);
            }
            if (graph.isCASData()) {
                carpet.setGroupOrder(1);
                carpet.setDrawByGroupOrder(true);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            if (map.isRoleMapped(46)) {
                map.map(41, ii);
            }
            carpet.addRole("INDEX", m.getColumnLabel(ii));
        }
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, carpet);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, carpet);
        carpet.setModel(crd);
        String contextName = graph.style.getContextName();
        carpet.setContextName(contextName);
        LineAttrs ls = new LineAttrs();
        GraphStyle.setDefaultDataLineStyle(graph, lineAttrs, ls, contextName);
        if (lineElem != null) {
            StatGraph.parseLineAttrs(graph, lineElem, ls);
        }
        carpet.setXLineStyle(ls);
        carpet.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "lineAttrs", "thickness"));
        str = elem.getAttribute("fringeHeight");
        if (StatGraph.isNumber(str)) {
            carpet.setLineLength(Integer.parseInt(str));
        }
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            startContrastColorIndex = graph.style.contrastColorCnt;
            LayoutOverlayParser.setDiscreteEncoder(graph, carpet, (byte)17);
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }
}

