/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.styles.DataStyleElement;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EllipseParmParser {
    public static final String RB_KEY = "EllipseParmParser.";

    public static EllipseParmOverlay load(StatGraph graph, Element elem) {
        EllipseParmOverlay ellipse = (EllipseParmOverlay)graph.getObjectFromElement(elem);
        if (ellipse == null) {
            ellipse = new EllipseParmOverlay();
        }
        return EllipseParmParser.load(graph, ellipse, elem) ? ellipse : null;
    }

    public static boolean load(StatGraph graph, EllipseParmOverlay ellipse, Element elem) {
        String[] opts;
        graph.addSupportedGraph();
        boolean grouped = false;
        LayoutOverlayParser.parseGraphOpts(graph, elem, ellipse);
        Element lineElem = null;
        Element fillElem = null;
        Element fillPatternElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("OutlineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("FillAttrs")) {
                fillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("FillPatternAttrs")) continue;
            fillPatternElem = (Element)node;
        }
        String dataName = null;
        String majorVarID = null;
        String minorVarID = null;
        String slopeVarID = null;
        String xVarID = null;
        String yVarID = null;
        String groupVarID = null;
        double xRadius = Double.NaN;
        double yRadius = Double.NaN;
        double xOrigin = Double.NaN;
        double yOrigin = Double.NaN;
        double slope = Double.NaN;
        String stmt = elem.getAttribute("_stmt");
        String str = elem.getAttribute("semiMajor");
        if (StatGraph.isNumber(str)) {
            xRadius = Double.parseDouble(str);
            if (xRadius <= 0.0) {
                graph.removeNamedGraph(ellipse);
                return false;
            }
            ellipse.setConstantXRadius(xRadius);
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            dataName = StatGraph.getDataName(str);
            majorVarID = StatGraph.getVarID(str);
        } else {
            graph.removeNamedGraph(ellipse);
            return false;
        }
        str = elem.getAttribute("semiMinor");
        if (StatGraph.isNumber(str)) {
            yRadius = Double.parseDouble(str);
            if (yRadius <= 0.0) {
                graph.removeNamedGraph(ellipse);
                return false;
            }
            ellipse.setConstantYRadius(yRadius);
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
            }
            minorVarID = StatGraph.getVarID(str);
        } else {
            graph.removeNamedGraph(ellipse);
            return false;
        }
        str = elem.getAttribute("slope");
        if (StatGraph.isNumber(str)) {
            slope = Double.parseDouble(str);
            ellipse.setConstantSlope(slope);
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
            }
            slopeVarID = StatGraph.getVarID(str);
        } else if (!str.equalsIgnoreCase(".")) {
            graph.removeNamedGraph(ellipse);
            return false;
        }
        str = elem.getAttribute("xOrigin");
        if (StatGraph.isNumber(str)) {
            xOrigin = Double.parseDouble(str);
            ellipse.setConstantXOrigin(xOrigin);
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
            }
            xVarID = StatGraph.getVarID(str);
        } else {
            graph.removeNamedGraph(ellipse);
            return false;
        }
        str = elem.getAttribute("yOrigin");
        if (StatGraph.isNumber(str)) {
            yOrigin = Double.parseDouble(str);
            ellipse.setConstantYOrigin(yOrigin);
        } else if (str.length() > 0 && StatGraph.getDataName(str).length() > 0) {
            if (dataName == null) {
                dataName = StatGraph.getDataName(str);
            }
            yVarID = StatGraph.getVarID(str);
        } else {
            graph.removeNamedGraph(ellipse);
            return false;
        }
        str = elem.getAttribute("group");
        if (str.length() > 0) {
            groupVarID = StatGraph.getVarID(str);
            grouped = str.length() > 0;
        }
        String contextName = graph.style.getContextName();
        ellipse.setContextName(contextName);
        int contextCount = graph.style.getContextCount();
        if (dataName != null && dataName.length() > 0) {
            String indexVarID;
            int ii;
            Color[] clist;
            Color[] clist2;
            LineAttrs[] lsl;
            Color[] clist3;
            DataModel m = graph.getData(dataName);
            RoleColumnMap map = new RoleColumnMap();
            if (groupVarID != null) {
                if (LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID, ellipse.getStmt())) {
                    grouped = false;
                } else {
                    int gcol = m.getColumn(groupVarID);
                    map.map(3, gcol);
                    str = elem.getAttribute("includeMissingGroup");
                    if (str.length() > 0 && str.equalsIgnoreCase("false")) {
                        ellipse.setMissingGroupOn(false);
                    }
                    if ((str = elem.getAttribute("groupAttrVar")).length() > 0) {
                        ellipse.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                    } else if (stmt.equalsIgnoreCase("ellipse")) {
                        String originalGroup = elem.hasAttribute("_originalGroup") ? elem.getAttribute("_originalGroup") : groupVarID;
                        DAMDatasetParser.addInternalAttrVar(graph, ellipse, "GROUP", originalGroup);
                    } else {
                        DAMDatasetParser.addInternalAttrVar(graph, ellipse, "GROUP", groupVarID);
                    }
                    if (graph.isCASData()) {
                        ellipse.setGroupOrder(1);
                        ellipse.setDrawByGroupOrder(true);
                    }
                }
            }
            if (slopeVarID != null) {
                int scol = m.getColumn(slopeVarID);
                if (!StatGraph.checkVariable("SLOPE", m.getColumnLabel(scol), Double.class, true)) {
                    graph.removeNamedGraph(ellipse);
                    return false;
                }
                map.map(30, scol);
            }
            if (majorVarID != null) {
                int acol = m.getColumn(majorVarID);
                if (!StatGraph.checkVariable("SEMIMAJOR", m.getColumnLabel(acol), Double.class, 1, false, 1, true)) {
                    graph.removeNamedGraph(ellipse);
                    return false;
                }
                map.map(39, acol);
            }
            if (minorVarID != null) {
                int bcol = m.getColumn(minorVarID);
                if (!StatGraph.checkVariable("SEMIMINOR", m.getColumnLabel(bcol), Double.class, 1, false, 1, true)) {
                    graph.removeNamedGraph(ellipse);
                    return false;
                }
                map.map(40, bcol);
            }
            if (xVarID != null) {
                int xcol = m.getColumn(xVarID);
                if (!StatGraph.checkVariable("XORIGIN", m.getColumnLabel(xcol), Double.class, 1, true)) {
                    graph.removeNamedGraph(ellipse);
                    return false;
                }
                map.map(37, xcol);
            }
            if (yVarID != null) {
                int ycol = m.getColumn(yVarID);
                if (!StatGraph.checkVariable("YORIGIN", m.getColumnLabel(ycol), Double.class, 1, true)) {
                    graph.removeNamedGraph(ellipse);
                    return false;
                }
                map.map(38, ycol);
            }
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(map);
            LayoutOverlayParser.parseWhere(graph, crd, ellipse);
            DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
            if (missingElem == null) {
                missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault");
            }
            Color missingColor = missingElem.getDefaultColor();
            Color missingContrastColor = missingElem.getContrastColor();
            LineAttrs missingLineAttrs = ellipse.getMissingLineAttrs();
            missingLineAttrs.setColor(missingContrastColor);
            missingLineAttrs.setLinePattern(missingElem.getLineStyle());
            FillAttrs missingFillAttrs = ellipse.getMissingFillAttrs();
            missingFillAttrs.setColor(missingColor);
            FillPatternAttrs missingFillPatternAttrs = ellipse.getMissingFillPatternAttrs();
            int pattern = FillPatternAttrs.getPattern((String)missingElem.getFillPattern());
            if (pattern < 0) {
                pattern = FillPatternAttrs.getPattern((String)"E");
            }
            missingFillPatternAttrs.setPattern(pattern);
            missingFillPatternAttrs.setColor(missingContrastColor);
            ellipse.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
            ellipse.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
            boolean cCount = false;
            boolean lCount = false;
            boolean fCount = false;
            boolean fpcCount = false;
            boolean fpCount = false;
            int contrastColorCnt = graph.style.getContrastColorCount();
            LineAttrs ls = new LineAttrs();
            String outlineAttr = elem.getAttribute("outlineAttrs");
            GraphStyle.setDefaultDataLineStyle(graph, outlineAttr, ls, contextName);
            ellipse.setDefaultLineAttrs(ls);
            if (outlineAttr.equals("")) {
                ellipse.setLineWidths(ls.getWidth());
            }
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, ls);
                if (!grouped || outlineAttr.length() > 0 || lineElem.hasAttribute("color")) {
                    clist3 = new Color[]{ls.getColor()};
                    ellipse.setLineColors(0, clist3);
                    ellipse.setFixedOutlineColor(lineElem.hasAttribute("color"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        ellipse.setLineColors(contextCount, graph.style.contrastColorList);
                    } else {
                        ellipse.setLineColors(graph.style.contrastColorCnt, graph.style.contrastColorList);
                    }
                    cCount = true;
                }
                if (!grouped || outlineAttr.length() > 0 || lineElem.hasAttribute("pattern")) {
                    LineAttrs[] lsl2 = new LineAttrs[]{ls};
                    ellipse.setLineStyles(0, lsl2);
                    ellipse.setFixedOutlinePattern(lineElem.hasAttribute("pattern"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        ellipse.setLineStyles(contextCount, graph.style.lineStyleList);
                    } else {
                        ellipse.setLineStyles(graph.style.lineStyleCnt, graph.style.lineStyleList);
                    }
                    lCount = true;
                }
            } else if (grouped) {
                if (outlineAttr.length() > 0) {
                    clist3 = new Color[]{ls.getColor()};
                    ellipse.setLineColors(0, clist3);
                    lsl = new LineAttrs[]{ls};
                    ellipse.setLineStyles(0, lsl);
                    ellipse.setFixedOutlineColor(true);
                    ellipse.setFixedOutlinePattern(true);
                } else if (graph.style.isCycleAttrs()) {
                    ellipse.setLineColors(contextCount, graph.style.contrastColorList);
                    ellipse.setLineStyles(contextCount, graph.style.lineStyleList);
                } else {
                    ellipse.setLineColors(graph.style.contrastColorCnt, graph.style.contrastColorList);
                    ellipse.setLineStyles(graph.style.lineStyleCnt, graph.style.lineStyleList);
                }
                cCount = true;
                lCount = true;
            } else {
                clist3 = new Color[]{ls.getColor()};
                ellipse.setLineColors(0, clist3);
                lsl = new LineAttrs[]{ls};
                ellipse.setLineStyles(0, lsl);
            }
            FillAttrs fs = new FillAttrs();
            String fillAttr = elem.getAttribute("fillAttrs");
            GraphStyle.setDefaultDataFillStyle(graph, fillAttr, fs, contextName);
            ellipse.setDefaultFillAttrs(fs);
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, fs);
                if (!grouped || fillElem.hasAttribute("color")) {
                    clist2 = new Color[]{fs.getColor()};
                    ellipse.setFillColors(0, clist2);
                    ellipse.setFixedFillColor(fillElem.hasAttribute("color"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        ellipse.setFillColors(contextCount, graph.style.fillColorList);
                    } else {
                        ellipse.setFillColors(graph.style.fillColorCnt, graph.style.fillColorList);
                    }
                    fCount = true;
                }
            } else if (grouped) {
                if (fillAttr.length() > 0) {
                    clist2 = new Color[]{fs.getColor()};
                    ellipse.setFillColors(0, clist2);
                    ellipse.setFixedFillColor(true);
                } else if (graph.style.isCycleAttrs()) {
                    ellipse.setFillColors(contextCount, graph.style.fillColorList);
                } else {
                    ellipse.setFillColors(graph.style.fillColorCnt, graph.style.fillColorList);
                }
                fCount = true;
            } else {
                Color[] flist = new Color[]{fs.getColor()};
                ellipse.setFillColors(0, flist);
            }
            ellipse.setFillTransparency(fs.getTransparency());
            graph.style.setContrastColorCount(contrastColorCnt);
            FillPatternAttrs fps = new FillPatternAttrs();
            String fillPatternAttr = elem.getAttribute("fillPatternAttrs");
            GraphStyle.setDefaultFillPatternStyle(graph, fillPatternAttr, fps, contextName);
            ellipse.setDefaultFillPatternAttrs(fps);
            if (fillPatternElem != null) {
                StatGraph.parseFillPatternAttrs(graph, fillPatternElem, fps);
                if (!grouped || fillPatternAttr.length() > 0 || fillPatternElem.hasAttribute("color")) {
                    clist = new Color[]{fps.getColor()};
                    ellipse.setFillPatternColors(0, clist);
                    ellipse.setFixedFillPatternColor(fillPatternElem.hasAttribute("color"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        ellipse.setFillPatternColors(contextCount, graph.style.contrastColorList);
                    } else {
                        ellipse.setFillPatternColors(graph.style.contrastColorCnt, graph.style.contrastColorList);
                    }
                    fpcCount = true;
                }
                if (!grouped || fillPatternAttr.length() > 0 || fillPatternElem.hasAttribute("pattern")) {
                    int[] plist = new int[]{fps.getPattern()};
                    ellipse.setFillPatterns(0, plist);
                    ellipse.setFixedFillPattern(fillPatternElem.hasAttribute("pattern"));
                } else {
                    if (graph.style.isCycleAttrs()) {
                        ellipse.setFillPatterns(contextCount, graph.style.fillPatternList);
                    } else {
                        ellipse.setFillPatterns(graph.style.fillPatternCnt, graph.style.fillPatternList);
                    }
                    fpCount = true;
                }
            } else if (grouped) {
                if (fillPatternAttr.length() > 0) {
                    clist = new Color[]{fps.getColor()};
                    ellipse.setFillPatternColors(0, clist);
                    int[] fp = new int[]{fps.getPattern()};
                    ellipse.setFillPatterns(0, fp);
                    ellipse.setFixedFillPatternColor(true);
                    ellipse.setFixedFillPattern(true);
                } else if (graph.style.isCycleAttrs()) {
                    ellipse.setFillPatternColors(contextCount, graph.style.contrastColorList);
                    ellipse.setFillPatterns(contextCount, graph.style.fillPatternList);
                } else {
                    ellipse.setFillPatternColors(graph.style.contrastColorCnt, graph.style.contrastColorList);
                    ellipse.setFillPatterns(graph.style.fillPatternCnt, graph.style.fillPatternList);
                }
                fpcCount = true;
                fpCount = true;
            } else {
                clist = new Color[]{fps.getColor()};
                ellipse.setFillPatternColors(0, clist);
                int[] flist = new int[]{fps.getPattern()};
                ellipse.setFillPatterns(0, flist);
            }
            str = elem.getAttribute("index");
            if (str.length() > 0 && StatGraph.checkVariable("INDEX", m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
                ellipse.colorIndex = m.getDoubleColumn(ii);
                ellipse.styleIndex = ellipse.colorIndex;
                ellipse.fillColorIndex = ellipse.colorIndex;
                ellipse.fillPatternColorIndex = ellipse.colorIndex;
                ellipse.fillPatternIndex = ellipse.colorIndex;
                if (cCount) {
                    ellipse.setLineColors(0, graph.style.contrastColorList);
                }
                if (fCount) {
                    ellipse.setFillColors(0, graph.style.fillColorList);
                }
                if (lCount) {
                    ellipse.setLineStyles(0, graph.style.lineStyleList);
                }
                if (fpcCount) {
                    ellipse.setFillPatternColors(0, graph.style.contrastColorList);
                }
                if (fpCount) {
                    ellipse.setFillPatterns(0, graph.style.fillPatternList);
                }
            }
            ellipse.setStyleColorCount(graph.style.getColorCount());
            ellipse.setColorPriority(graph.style.getAttrPriority() == 1);
            ellipse.setModel(crd);
            if (ellipse.isUseLineThickness() || !ellipse.hasAttrVar("GROUP")) {
                ellipse.setLineWidths(ls.getWidth());
            }
            if (ellipse.colorIndex == null) {
                graph.style.setContextCount(contextCount + ellipse.getNumberOfGroups());
            } else {
                graph.style.setContextCount(contextCount);
            }
        } else {
            Color[] clist = new Color[1];
            Color[] flist = new Color[1];
            LineAttrs[] llist = new LineAttrs[1];
            Color[] fpclist = new Color[1];
            int[] fplist = new int[1];
            llist[0] = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), llist[0], contextName);
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, llist[0]);
            }
            clist[0] = llist[0].getColor();
            ellipse.setLineColors(0, clist);
            ellipse.setLineStyles(0, llist);
            FillAttrs fillStyle = new FillAttrs();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillStyle, contextName);
            if (fillElem != null) {
                StatGraph.parseFillAttrs(graph, fillElem, fillStyle);
            }
            flist[0] = fillStyle.getColor();
            ellipse.setFillColors(0, flist);
            ellipse.setFillTransparency(fillStyle.getTransparency());
            FillPatternAttrs fillPatternStyle = new FillPatternAttrs();
            GraphStyle.setDefaultFillPatternStyle(graph, elem.getAttribute("fillPatternAttrs"), fillPatternStyle, contextName);
            if (fillPatternElem != null) {
                StatGraph.parseFillPatternAttrs(graph, fillPatternElem, fillPatternStyle);
            }
            fpclist[0] = fillPatternStyle.getColor();
            ellipse.setFillPatternColors(0, fpclist);
            fplist[0] = fillPatternStyle.getPattern();
            ellipse.setFillPatterns(0, fplist);
            ellipse.setModel(null);
            str = elem.getAttribute("semiMajor");
            if (StatGraph.isNumber(str)) {
                ellipse.setXRadius(Double.parseDouble(str));
            }
            if (StatGraph.isNumber(str = elem.getAttribute("semiMinor"))) {
                ellipse.setYRadius(Double.parseDouble(str));
            }
            if (StatGraph.isNumber(str = elem.getAttribute("slope"))) {
                ellipse.setSlope(Double.parseDouble(str));
            }
            if (StatGraph.isNumber(str = elem.getAttribute("xOrigin"))) {
                ellipse.setXOrigin(Double.parseDouble(str));
            } else {
                ellipse.setXOrigin(0.0);
            }
            str = elem.getAttribute("yOrigin");
            if (StatGraph.isNumber(str)) {
                ellipse.setYOrigin(Double.parseDouble(str));
            } else {
                ellipse.setYOrigin(0.0);
            }
        }
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                ellipse.setEdgeOn(true);
                ellipse.setFillOn(true);
                ellipse.setFillPatternOn(true);
            } else {
                ellipse.setEdgeOn(false);
                ellipse.setFillOn(false);
                ellipse.setFillPatternOn(false);
                opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        ellipse.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        ellipse.setFillOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fillPattern")) {
                        ellipse.setFillPatternOn(true);
                        continue;
                    }
                    ellipse.setEdgeOn(true);
                    ellipse.setFillOn(false);
                    ellipse.setFillPatternOn(false);
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        } else {
            str = graph.style.getStyleAttribute("Ellipse", "displayOpts");
            if (str != null) {
                ellipse.setEdgeOn(false);
                ellipse.setFillOn(false);
                ellipse.setFillPatternOn(false);
                opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        ellipse.setEdgeOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        ellipse.setFillOn(true);
                        continue;
                    }
                    if (!opts[i].equalsIgnoreCase("fillPattern")) continue;
                    ellipse.setFillPatternOn(true);
                }
                if (!(ellipse.isEdgeOn() || ellipse.isFillOn() || ellipse.isFillPatternOn())) {
                    ellipse.setEdgeOn(true);
                    ellipse.setFillOn(false);
                    ellipse.setFillPatternOn(false);
                }
            } else {
                ellipse.setEdgeOn(true);
                ellipse.setFillOn(false);
                ellipse.setFillPatternOn(false);
            }
        }
        str = elem.getAttribute("maxPoints");
        if (str.length() > 0) {
            ellipse.setMaxPoints(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("clip")).length() > 0 && str.equalsIgnoreCase("true")) {
            ellipse.setClipping(true);
        }
        if ((str = elem.getAttribute("dataLabelProtected")).equalsIgnoreCase("true")) {
            ellipse.setProtectedLine(true);
        } else {
            ellipse.setProtectedLine(false);
        }
        return true;
    }
}

