/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ReferenceLineParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.labeling.SALabeling;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DropLineParser {
    public static final String RB_KEY = "DropLineParser.";

    public static DropLineOverlay load(StatGraph graph, Element elem) {
        DropLineOverlay line = (DropLineOverlay)graph.getObjectFromElement(elem);
        if (line == null) {
            line = new DropLineOverlay();
        }
        return DropLineParser.load(graph, line, elem) ? line : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean load(StatGraph graph, DropLineOverlay line, Element elem) {
        boolean labeled;
        String str;
        block73: {
            int type;
            String yVarID;
            String xVarID;
            String dataName;
            block78: {
                block72: {
                    block77: {
                        block71: {
                            block76: {
                                graph.addSupportedGraph();
                                LayoutOverlayParser.parseGraphOpts(graph, elem, line);
                                if (line.getXAxis().equalsIgnoreCase("x2")) {
                                    line.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
                                } else {
                                    line.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
                                }
                                if (line.getYAxis().equalsIgnoreCase("y2")) {
                                    line.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
                                } else {
                                    line.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
                                }
                                dataName = null;
                                xVarID = null;
                                yVarID = null;
                                str = elem.getAttribute("y");
                                type = StatGraph.getAttributeType(elem, "y");
                                if (type >= 0) break block76;
                                if (StatGraph.isNumber(str)) {
                                    line.setYValue(new Double(str));
                                    break block71;
                                } else {
                                    if (str.length() <= 0) {
                                        StatGraph.printWarning(RB.getStringResource(RB_KEY, "y.txt"));
                                        graph.removeNamedGraph(line);
                                        return false;
                                    }
                                    if (StatGraph.getDataName(str).length() > 0) {
                                        if (dataName == null) {
                                            dataName = StatGraph.getDataName(str);
                                        }
                                        yVarID = StatGraph.getVarID(str);
                                        break block71;
                                    } else {
                                        line.setYValue(ReferenceLineParser.trimMissing(str));
                                    }
                                }
                                break block71;
                            }
                            if (type == 0) {
                                if (dataName == null) {
                                    dataName = StatGraph.getDataName(str);
                                }
                                yVarID = StatGraph.getVarID(str);
                            } else if (type == 1) {
                                if (!line.isDiscreteY()) {
                                    Message msg = new Message(RB.getStringResource(RB_KEY, "y.fmt.txt"));
                                    StatGraph.printWarning(msg.toString((Object)("'" + str + "'")));
                                    graph.removeNamedGraph(line);
                                    return false;
                                }
                                line.setYValue(ReferenceLineParser.trimMissing(str));
                            } else if (!line.isDiscreteY()) {
                                if (!StatGraph.isNumber(str)) return false;
                                line.setYValue(new Double(str));
                            } else {
                                line.setYValue(ReferenceLineParser.trimMissing(str));
                            }
                        }
                        str = elem.getAttribute("x");
                        type = StatGraph.getAttributeType(elem, "x");
                        if (type >= 0) break block77;
                        if (StatGraph.isNumber(str)) {
                            line.setXValue(new Double(str));
                            break block72;
                        } else {
                            if (str.length() <= 0) {
                                StatGraph.printWarning(RB.getStringResource(RB_KEY, "x.txt"));
                                graph.removeNamedGraph(line);
                                return false;
                            }
                            if (StatGraph.getDataName(str).length() > 0) {
                                if (dataName == null) {
                                    dataName = StatGraph.getDataName(str);
                                }
                                xVarID = StatGraph.getVarID(str);
                                break block72;
                            } else {
                                line.setXValue(ReferenceLineParser.trimMissing(str));
                            }
                        }
                        break block72;
                    }
                    if (type == 0) {
                        if (dataName == null) {
                            dataName = StatGraph.getDataName(str);
                        }
                        xVarID = StatGraph.getVarID(str);
                    } else if (type == 1) {
                        if (!line.isDiscreteX()) {
                            Message msg = new Message(RB.getStringResource(RB_KEY, "x.fmt.txt"));
                            StatGraph.printWarning(msg.toString((Object)("'" + str + "'")));
                            graph.removeNamedGraph(line);
                            return false;
                        }
                        line.setXValue(ReferenceLineParser.trimMissing(str));
                    } else if (!line.isDiscreteX()) {
                        if (!StatGraph.isNumber(str)) return false;
                        line.setXValue(new Double(str));
                    } else {
                        line.setXValue(ReferenceLineParser.trimMissing(str));
                    }
                }
                labeled = false;
                if (dataName != null && dataName.length() > 0) break block78;
                str = elem.getAttribute("label");
                if (str.length() > 0) {
                    type = StatGraph.getAttributeType(elem, "label");
                    if (type < 0) {
                        line.setLabelString(str);
                        labeled = true;
                        break block73;
                    } else if (type != 0) {
                        line.setLabelString(str);
                        labeled = true;
                        break block73;
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "label2.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)StatGraph.getVarID(str)));
                    }
                }
                break block73;
            }
            DataModel m = graph.getData(dataName);
            RoleColumnMap map = new RoleColumnMap();
            if (yVarID != null) {
                int ycol = m.getColumn(yVarID);
                if (!line.isDiscreteY() && !StatGraph.checkVariable("y", m.getColumnLabel(ycol), Double.class, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(11, ycol);
                line.addRole("Y", m.getColumnLabel(ycol));
            }
            if (xVarID != null) {
                int xcol = m.getColumn(xVarID);
                if (!line.isDiscreteX() && !StatGraph.checkVariable("x", m.getColumnLabel(xcol), Double.class, true)) {
                    graph.removeNamedGraph(line);
                    return false;
                }
                map.map(10, xcol);
                line.addRole("X", m.getColumnLabel(xcol));
            }
            if ((str = elem.getAttribute("label")).length() > 0) {
                type = StatGraph.getAttributeType(elem, "label");
                if (type < 0) {
                    String curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(5, clcol);
                        labeled = true;
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)str));
                    }
                } else if (type == 0) {
                    String curveLabelVarID = StatGraph.getVarID(str);
                    if (m.hasColumn(curveLabelVarID)) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(5, clcol);
                        labeled = true;
                    } else {
                        Message msg = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                        StatGraph.printNote(msg.toString((Object)str));
                    }
                } else {
                    Message msg = new Message(RB.getStringResource(RB_KEY, "label.fmt.txt"));
                    String val = type == 2 ? str : "'" + str + "'";
                    StatGraph.printNote(msg.toString((Object)val));
                }
            }
            CRD crd = new CRD();
            crd.setSrcModel(m);
            crd.setSrcMap(map);
            LayoutOverlayParser.parseWhere(graph, crd, line);
            if (line.isTooltipEnabled()) {
                line.setTooltipEnabled(graph.updateTipMax(m.getRowCount()));
            }
            line.setModel(crd);
        }
        StatGraph.parseDataSkinOpt(graph, elem, line);
        LineAttrs ls = line.getLineStyle();
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("lineAttrs"), ls, "Reference");
        TextStyle labelStyle = null;
        if (labeled) {
            labelStyle = new TextStyle();
            GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), labelStyle, "ValueText");
            line.setLabelStyle(labelStyle);
            str = elem.getAttribute("labelFormat");
            if (str.length() > 0) {
                SASFormat lf = SASFormat.getInstance((String)str);
                line.setLabelFormat(lf);
            }
        }
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("LabelAttrs") && labelStyle != null) {
                StatGraph.parseTextAttrs(graph, (Element)node, labelStyle);
                continue;
            }
            if (!elemTag.equals("LineAttrs")) continue;
            StatGraph.parseLineAttrs(graph, (Element)node, ls);
        }
        str = elem.getAttribute("clip");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            line.setClipping(true);
        }
        if ((str = elem.getAttribute("dropTo")).equalsIgnoreCase("x")) {
            line.setDropType(0);
        } else if (str.equalsIgnoreCase("y")) {
            line.setDropType(1);
        } else if (str.equalsIgnoreCase("both")) {
            line.setDropType(2);
        } else {
            line.setDropType(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("DROPTO", str);
            }
        }
        str = elem.getAttribute("discreteOffset");
        if (str.length() > 0 && !DropLineParser.isDiscreteOffsetSupported(line)) {
            Message msg = new Message(RB.getStringResource("StatGraph.", "doffset.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)str));
        } else if (StatGraph.isNumber(str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                line.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError("DISCRETEOFFSET", str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError("DISCRETEOFFSET", str);
        }
        if (!graph.isSALabeling()) {
            line.setProtectedLine(false);
            return true;
        }
        line.setProtectedLine(SALabeling.getWeight(graph.getSAWeightMap(), "OBSTACLE") > 0.0);
        return true;
    }

    static boolean isDiscreteOffsetSupported(DropLineOverlay line) {
        return line.isDiscreteX() || line.isDiscreteY();
    }
}

