/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.composite.RegionContainer;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.regions.DecisionTreeRegion;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.Message;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Element;

public class DecisionTreeParser {
    public static final String RB_KEY = "DecisionTreeParser.";

    public static DecisionTreeRegion load(StatGraph graph, Element elem) {
        DecisionTreeRegion decisionTree = (DecisionTreeRegion)graph.getObjectFromElement(elem);
        if (decisionTree == null) {
            decisionTree = new DecisionTreeRegion();
        }
        return DecisionTreeParser.load(graph, decisionTree, elem) ? decisionTree : null;
    }

    public static boolean load(StatGraph graph, DecisionTreeRegion decisionTree, Element elem) {
        Color[] nodeColors;
        Color clr;
        int i;
        int cnt;
        Element tipLabelElem;
        Element formatElem;
        Element roleElem;
        int crcol;
        String varID;
        int tcol;
        int col;
        graph.style.resetCounters();
        graph.addSupportedGraph();
        decisionTree.setGraphSize(graph.size);
        String dataName = null;
        DataModel m = null;
        RoleColumnMap map = new RoleColumnMap();
        String str = elem.getAttribute("nodeID");
        String var = null;
        dataName = StatGraph.getDataName(str);
        m = graph.getData(dataName);
        var = StatGraph.getVarID(str);
        int nodeCol = col = m.getColumn(var);
        if (!StatGraph.checkVariable("nodeID", m.getColumnLabel(col), null, -1, false, 1, true)) {
            return false;
        }
        decisionTree.setNodeID(var);
        decisionTree.addRole("NODEID", m.getColumnLabel(col));
        map.map(2001, col);
        str = elem.getAttribute("nodeDetailLevel");
        if (str.equalsIgnoreCase("LOW")) {
            if (m.getRowCount() > graph.nodeMax) {
                Message msg = new Message(RB.getStringResource(RB_KEY, "nodemax.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(m.getRowCount()))), false);
                return false;
            }
            decisionTree.setNodeDetailThreshold(Double.MAX_VALUE);
        } else if (str.equalsIgnoreCase("HIGH")) {
            decisionTree.setNodeDetailThreshold(0.0);
        } else if (str.length() == 0 || str.equalsIgnoreCase("AUTO")) {
            str = elem.getAttribute("nodeDetailThreshold");
            if (StatGraph.isNumber(str)) {
                double thres = Double.parseDouble(str);
                decisionTree.setNodeDetailThreshold(thres);
            }
        } else {
            StatGraph.printOptionError("NODELEVELDETAIL", str);
        }
        str = elem.getAttribute("parentID");
        var = StatGraph.getVarID(str);
        col = m.getColumn(var);
        if (StatGraph.checkVariable("parentID", m.getColumnLabel(col), m.getColumnClass(nodeCol), true)) {
            if (!DecisionTreeParser.checkNodes(m, nodeCol, col)) {
                return false;
            }
        } else {
            return false;
        }
        decisionTree.setNodeID(var);
        decisionTree.addRole("PARENTID", m.getColumnLabel(col));
        map.map(2002, col);
        str = elem.getAttribute("nodeTitle");
        if (str.length() > 0 && StatGraph.checkVariable("nodeTitle", m.getColumnLabel(tcol = m.getColumn(var = StatGraph.getVarID(str))), null, false)) {
            decisionTree.setNodeTitle(var);
            decisionTree.addRole("NODETITLE", m.getColumnLabel(tcol));
            map.map(2003, tcol);
        }
        if ((str = elem.getAttribute("nodeInputLabel")).length() > 0) {
            var = StatGraph.getVarID(str);
            col = m.getColumn(var);
            if (StatGraph.checkVariable("nodeInputLabel", m.getColumnLabel(col), null, false)) {
                decisionTree.setNodeInputLabelList(new String[]{var});
                decisionTree.addRole("NODEINPUTLABEL", m.getColumnLabel(col));
                map.map(2080, col);
            }
        } else {
            Element varElem = StatGraph.getOptionAttrsElement(elem, "NodeInputLabel");
            if (varElem != null) {
                String[] vars = StatGraph.parseStringValueList(varElem, "Value");
                String[] varNames = new String[vars.length];
                for (int i2 = 0; i2 < vars.length; ++i2) {
                    var = StatGraph.getVarID(vars[i2]);
                    col = m.getColumn(var);
                    varNames[i2] = var;
                    if (!StatGraph.checkVariable("nodeInputLabel", m.getColumnLabel(col), null, false)) continue;
                    if (i2 > 0) {
                        map.map(2080 + i2, col);
                        decisionTree.addRole("NODEINPUTLABEL" + i2, m.getColumnLabel(col));
                        continue;
                    }
                    map.map(2080, col);
                    decisionTree.addRole("NODEINPUTLABEL", m.getColumnLabel(col));
                }
                decisionTree.setNodeInputLabelList(varNames);
            }
        }
        if ((str = elem.getAttribute("nodeOutputLabel")).length() > 0 && StatGraph.checkVariable("nodeOutputLabel", m.getColumnLabel(col = m.getColumn(var = StatGraph.getVarID(str))), null, false)) {
            decisionTree.setNodeOutputLabel(var);
            decisionTree.addRole("NODEOUTPUTLABEL", m.getColumnLabel(col));
            map.map(2005, col);
        }
        if ((str = elem.getAttribute("linkWidthResponse")).length() > 0 && StatGraph.checkVariable("linkWidthResponse", m.getColumnLabel(col = m.getColumn(varID = StatGraph.getVarID(str))), Double.class, 0, false, 1, false)) {
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(col);
            if (cmd.getMax() > 0.0) {
                decisionTree.setLinkWidthResponse(varID);
                decisionTree.addRole("LINKWIDTHRESPONSE", m.getColumnLabel(col));
                map.map(2007, col);
            } else {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "sizeresponse.txt"));
            }
        }
        str = elem.getAttribute("nodeColorResponse");
        boolean gradientColor = false;
        String crVarID = StatGraph.getVarID(str);
        if (crVarID.length() > 0 && StatGraph.checkVariable("nodeColorResponse", m.getColumnLabel(crcol = m.getColumn(crVarID)), Double.class, 1, false)) {
            decisionTree.setNodeColorResponse(crVarID);
            decisionTree.addRole("NODECOLORRESPONSE", m.getColumnLabel(crcol));
            map.map(2009, crcol);
            gradientColor = true;
            str = elem.getAttribute("nodeColorResponseAttrVar");
            if (str.length() > 0) {
                decisionTree.setColorRAM(graph.getRangeAttrVar(str));
            }
        }
        str = elem.getAttribute("nodeColorGroup");
        if (!gradientColor && str.length() > 0) {
            String groupVarID = StatGraph.getVarID(str);
            int groupCol = m.getColumn(groupVarID);
            if (StatGraph.checkVariable("NodeColorGroup", m.getColumnLabel(groupCol), null, false)) {
                decisionTree.setNodeColorGroup(groupVarID);
                decisionTree.addRole("NODECOLORGROUP", m.getColumnLabel(groupCol));
                map.map(2008, groupCol);
            }
            if ((str = elem.getAttribute("nodeColorGroupAttrVar")).length() > 0) {
                decisionTree.setColorDAM(graph.getDiscreteAttrVar(str));
            } else if (DAMDatasetParser.hasInternalDAttrVar(graph, groupVarID)) {
                decisionTree.setColorDAM(DAMDatasetParser.getInternalDAttrMapper(graph, groupVarID));
            }
        }
        if (!gradientColor && !map.isRoleMapped(2008)) {
            int i3;
            Element varElem;
            String[] vars = null;
            int numColors = 0;
            if (decisionTree.getNodeColorGroup() == null) {
                varElem = StatGraph.getOptionAttrsElement(elem, "ThresholdNodeColorGroup");
                if (varElem != null) {
                    vars = StatGraph.parseStringValueList(varElem, "Value");
                }
                if (vars != null) {
                    String[] tv = new String[vars.length];
                    for (i3 = 0; i3 < tv.length; ++i3) {
                        tv[i3] = StatGraph.getVarID(vars[i3]);
                        col = m.getColumn(tv[i3]);
                        if (!StatGraph.checkVariable("ThresholdNodeColorGroup", m.getColumnLabel(col), null, false)) continue;
                        map.map(2050 + numColors, col);
                        ++numColors;
                    }
                    decisionTree.setOverviewNodeColorGroup(tv);
                    vars = null;
                }
            }
            if ((varElem = StatGraph.getOptionAttrsElement(elem, "ThresholdNodeFillRatio")) != null) {
                vars = StatGraph.parseStringValueList(varElem, "Value");
            }
            int numRatios = 0;
            if (vars != null) {
                String[] tv = new String[vars.length];
                for (int i4 = 0; i4 < tv.length; ++i4) {
                    tv[i4] = StatGraph.getVarID(vars[i4]);
                    col = m.getColumn(tv[i4]);
                    if (!StatGraph.checkVariable("ThresholdNodeFillRatio", m.getColumnLabel(col), Double.class, 1, false)) continue;
                    map.map(2060 + numRatios, col);
                    ++numRatios;
                }
                decisionTree.setOverviewNodeFillRatio(tv);
                vars = null;
            }
            if (numColors != numRatios) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "overviewnode.txt"));
                for (i3 = 0; i3 < numColors; ++i3) {
                    map.unmapRole(2050 + i3);
                }
                decisionTree.setOverviewNodeColorGroup(null);
                for (i3 = 0; i3 < numRatios; ++i3) {
                    map.unmapRole(2060 + i3);
                }
                decisionTree.setOverviewNodeFillRatio(null);
            }
        }
        if ((roleElem = StatGraph.getOptionAttrsElement(elem, "Roles")) != null) {
            LayoutRegionParser.parseRoleNames(roleElem, m, decisionTree);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement(elem, "TipFormats")) != null) {
            LayoutRegionParser.parseTipFormats(formatElem, decisionTree);
        }
        if ((tipLabelElem = StatGraph.getOptionAttrsElement(elem, "TipLabels")) != null) {
            LayoutRegionParser.parseTipLabels(tipLabelElem, decisionTree);
        }
        if ((str = elem.getAttribute("nodeTip")).length() > 0) {
            if (str.equalsIgnoreCase("NONE")) {
                decisionTree.setTooltipEnabled(false);
            }
            String[] roles = StatGraph.parseList2String(str);
            ArrayList<String> rv = new ArrayList<String>();
            ArrayList<String> tv = new ArrayList<String>();
            int cnt2 = 0;
            for (int i5 = 0; i5 < roles.length; ++i5) {
                ColumnMetadata cmd = decisionTree.getRoleMetadata(roles[i5].toUpperCase());
                if (cmd == null) continue;
                rv.add(roles[i5].toUpperCase());
                tv.add(cmd.getName());
                col = m.getColumn(cmd.getName());
                map.map(2030 + cnt2, col);
                ++cnt2;
            }
            decisionTree.setNodeTip(tv.toArray());
            decisionTree.setNodeTipRoles(rv.toArray());
        }
        if ((str = elem.getAttribute("linkTip")).length() > 0) {
            String[] roles = StatGraph.parseList2String(str);
            ArrayList<String> tv = new ArrayList<String>();
            cnt = 0;
            for (i = 0; i < roles.length; ++i) {
                ColumnMetadata cmd = decisionTree.getRoleMetadata(roles[i].toUpperCase());
                if (cmd == null) continue;
                tv.add(cmd.getName());
                col = m.getColumn(cmd.getName());
                map.map(2040 + cnt, col);
                ++cnt;
            }
            decisionTree.setLinkTip(tv.toArray());
        }
        if ((str = elem.getAttribute("thresholdNodeLabel")).length() > 0) {
            String[] roles = StatGraph.parseList2String(str);
            ArrayList<String> tv = new ArrayList<String>();
            cnt = 0;
            for (i = 0; i < roles.length; ++i) {
                ColumnMetadata cmd = decisionTree.getRoleMetadata(roles[i].toUpperCase());
                if (cmd == null) continue;
                tv.add(cmd.getName());
                col = m.getColumn(cmd.getName());
                map.map(2070 + cnt, col);
                ++cnt;
            }
            decisionTree.setOverviewNodeLabel(tv.toArray());
        }
        Element nodeDetailNamesElem = StatGraph.getOptionAttrsElement(elem, "NodeDetailNames");
        Element nodeDetailValuesElem = StatGraph.getOptionAttrsElement(elem, "NodeDetailValues");
        if (nodeDetailNamesElem != null && nodeDetailValuesElem != null) {
            String[] names = StatGraph.parseStringValueList(nodeDetailNamesElem, "Value");
            String[] values = StatGraph.parseStringValueList(nodeDetailValuesElem, "Value");
            if (names != null && values != null && names.length == values.length) {
                int cnt3 = 0;
                Object[] tnv = new String[names.length];
                String[] tvv = new String[values.length];
                for (int i6 = 0; i6 < tnv.length; ++i6) {
                    tnv[i6] = StatGraph.getVarID(names[i6]);
                    tvv[i6] = StatGraph.getVarID(values[i6]);
                    int ncol = m.getColumn((String)tnv[i6]);
                    int vcol = m.getColumn(tvv[i6]);
                    if (!StatGraph.checkVariable("NodeDetailNames", m.getColumnLabel(ncol), null, false) || !StatGraph.checkVariable("NodeDetailValues", m.getColumnLabel(vcol), null, false)) continue;
                    map.map(2020 + cnt3, vcol);
                    map.map(2090 + cnt3, ncol);
                    decisionTree.addRole("NODEDETAILVALUES" + i6, m.getColumnLabel(vcol));
                    decisionTree.addRole("NODEDETAILNAMES" + i6, m.getColumnLabel(ncol));
                    ++cnt3;
                }
                decisionTree.setNodeDetails(tnv);
                decisionTree.setNodeDetailsLabels(tnv);
            }
        } else {
            str = elem.getAttribute("nodeDetails");
            if (str.length() > 0) {
                String[] roles = StatGraph.parseList2String(str);
                ArrayList<String> tv = new ArrayList<String>();
                ArrayList<String> rv = new ArrayList<String>();
                int cnt4 = 0;
                for (int i7 = 0; i7 < roles.length; ++i7) {
                    ColumnMetadata cmd = decisionTree.getRoleMetadata(roles[i7].toUpperCase());
                    if (cmd == null) continue;
                    rv.add(roles[i7].toUpperCase());
                    tv.add(cmd.getName());
                    col = m.getColumn(cmd.getName());
                    map.map(2020 + cnt4, col);
                    ++cnt4;
                }
                decisionTree.setNodeDetails(tv.toArray());
                decisionTree.setNodeDetailRoles(rv.toArray());
            }
        }
        str = elem.getAttribute("nodeDetailsJustify");
        if (str.equalsIgnoreCase("FULL")) {
            decisionTree.setNodeDetailsJustify(1);
        }
        if ((str = elem.getAttribute("displayRoot")).length() > 0) {
            decisionTree.setDisplayRoot(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("displayDepth"))) {
            int depth = (int)Double.parseDouble(str);
            decisionTree.setDisplayDepth(depth);
        }
        if ((str = elem.getAttribute("linkType")).equalsIgnoreCase("ORTHOGONAL")) {
            decisionTree.setLinkType(1);
        } else if (str.equalsIgnoreCase("DIRECT")) {
            decisionTree.setLinkType(0);
        } else if (str.equalsIgnoreCase("SPLINE")) {
            decisionTree.setLinkType(3);
        } else if (!str.equalsIgnoreCase("CURVED") && str.length() > 0) {
            StatGraph.printOptionError("LINKTYPE", str);
        }
        str = elem.getAttribute("fit");
        if (str.equalsIgnoreCase("none")) {
            decisionTree.setScaleToFit(false);
        }
        if ((str = elem.getAttribute("scaleNodeDetails")).equalsIgnoreCase("true")) {
            decisionTree.setScaleNodeDetails(true);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("nodeDetailSeparator"))) {
            int separator = (int)Double.parseDouble(str);
            if (decisionTree.getNodeDetails() != null && decisionTree.getNodeDetails().length > separator) {
                decisionTree.setNodeDetailsLineSeparator(separator);
            }
        }
        if (graph.isCASData()) {
            decisionTree.setSortIDValues(true);
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        decisionTree.setCRD(crd);
        LayoutRegionParser.parseGraphOpts(graph, elem, decisionTree);
        FillAttrs nfa = decisionTree.getNodeFillStyle();
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("nodeFillAttrs"), nfa, "GraphDataNodeDefault");
        Element fillElem = StatGraph.getOptionAttrsElement(elem, "NodeFillAttrs");
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, nfa);
        }
        decisionTree.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        FillAttrs lfa = decisionTree.getLinkFillStyle();
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("linkFillAttrs"), lfa, "NodeLink");
        fillElem = StatGraph.getOptionAttrsElement(elem, "LinkFillAttrs");
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, lfa);
        }
        decisionTree.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillElem));
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("linkAttrs"), decisionTree.getLinkLineStyle(), "NodeLink");
        Element linkElem = StatGraph.getOptionAttrsElement(elem, "LinkAttrs");
        if (linkElem != null) {
            StatGraph.parseLineAttrs(graph, linkElem, decisionTree.getLinkLineStyle());
        }
        LineAttrs ls = decisionTree.getNodeOutlineStyle();
        GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("nodeOutlineAttrs"), ls, "GraphDataNodeDefault");
        Element lineElem = StatGraph.getOptionAttrsElement(elem, "NodeOutlineAttrs");
        if (lineElem != null) {
            StatGraph.parseLineAttrs(graph, lineElem, ls);
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("nodeTitleAttrs"), decisionTree.getNodeTitleStyle(), "NodeTitle");
        Element labelElem = StatGraph.getOptionAttrsElement(elem, "NodeTitleAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, decisionTree.getNodeTitleStyle());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("nodeInputLabelAttrs"), decisionTree.getNodeInputLabelStyle(), "NodeInputLabel");
        labelElem = StatGraph.getOptionAttrsElement(elem, "NodeInputLabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, decisionTree.getNodeInputLabelStyle());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("nodeOutputLabelAttrs"), decisionTree.getNodeOutputLabelStyle(), "NodeLabel");
        labelElem = StatGraph.getOptionAttrsElement(elem, "NodeOutputLabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, decisionTree.getNodeOutputLabelStyle());
        }
        decisionTree.setOverviewNodeLabelStyle(decisionTree.getNodeOutputLabelStyle());
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("nodeDetailsAttrs"), decisionTree.getNodeDetailsStyle(), "NodeDetails");
        labelElem = StatGraph.getOptionAttrsElement(elem, "NodeDetailsAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, decisionTree.getNodeDetailsStyle());
        }
        if ((clr = StatGraph.parseAttrColor("wallColor", graph, elem)) != null) {
            decisionTree.setWallColor(clr);
        }
        Color missingColor = graph.style.getGraphStyle().getDataStyleElement("Missing").getFillColor();
        decisionTree.setMissingFillColor(missingColor);
        if (decisionTree.getNodeColorGroup() != null) {
            nodeColors = graph.style.getGraphStyle().getDataNodeFillColors();
            int ccol = m.getColumn(decisionTree.getNodeColorGroup());
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(ccol);
            boolean numeric = cmd.getType() == 1;
            HashMap<String, Color> stcm = new HashMap<String, Color>();
            StringVectorVariable cgVar = decisionTree.getNodeColorGroupVar();
            if (graph.isCASData()) {
                cgVar.setUniqueValueSort(1);
            }
            for (int i8 = 0; i8 < cgVar.getUniqueValueCount(); ++i8) {
                try {
                    String cat = cgVar.uniqueValue.getValue(i8);
                    Color c = LayoutOverlayParser.isMissing(cat, numeric) ? missingColor : nodeColors[i8 % nodeColors.length];
                    stcm.put(cat, decisionTree.applyDataTransparency(c, decisionTree.getNodeFillStyle()));
                    continue;
                }
                catch (MissingValueException cat) {
                    // empty catch block
                }
            }
            decisionTree.setColorTable(stcm);
        } else if (decisionTree.getNodeColorResponse() != null) {
            decisionTree.setColorMapper((ColorMapper)DecisionTreeParser.createGTKColorMapper(elem, graph, decisionTree, str, nfa, missingColor));
        } else if (decisionTree.getOverviewNodeColorGroup() != null) {
            nodeColors = graph.style.getGraphStyle().getDataNodeFillColors();
            StringVectorVariable[] oncg = decisionTree.getOverviewNodeColorGroupVars();
            HashSet<String> uniqueValues = new HashSet<String>();
            HashMap<String, Color> stcm = new HashMap<String, Color>();
            for (int j = 0; j < oncg.length; ++j) {
                if (graph.isCASData()) {
                    oncg[j].setUniqueValueSort(1);
                }
                for (int i9 = 0; i9 < oncg[j].getUniqueValueCount(); ++i9) {
                    try {
                        String cat = oncg[j].uniqueValue.getValue(i9);
                        if (uniqueValues.contains(cat)) continue;
                        Color c = LayoutOverlayParser.isMissing(cat, false) ? missingColor : nodeColors[uniqueValues.size() % nodeColors.length];
                        stcm.put(cat, decisionTree.applyDataTransparency(c, decisionTree.getNodeFillStyle()));
                        uniqueValues.add(cat);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
            }
            decisionTree.setOverviewColorTable(stcm);
        }
        str = elem.getAttribute("colorBranchNodes");
        if (str.length() > 0 && str.equalsIgnoreCase("false")) {
            decisionTree.setColorBranchNodes(false);
        }
        if ((str = elem.getAttribute("thresholdNodeLabelDelimiter")).length() > 0) {
            decisionTree.setOverviewNodeLabelDelimiter(str);
        }
        if (StatGraph.isNumber(str = elem.getAttribute("backlight"))) {
            double d = Double.parseDouble(str);
            if (d >= 0.0 && d <= 1.0) {
                decisionTree.setLabelBacklight(d);
            }
        } else if (str.equalsIgnoreCase("auto")) {
            decisionTree.setLabelBacklight(0.5);
        }
        if (graph.dataAntialiased) {
            decisionTree.setAntialiased(graph.updateAAMax(m.getRowCount()));
        } else {
            decisionTree.setAntialiased(false);
        }
        str = elem.getAttribute("thresholdNodeStyle");
        if (str.equalsIgnoreCase("type2")) {
            decisionTree.setNodeOverviewPCT100(false);
        }
        return true;
    }

    private static final ContinuousRangeToColorMapper createGTKColorMapper(Element elem, StatGraph graph, DecisionTreeRegion decisionTree, String str, FillAttrs fa, Color missingColor) {
        Color[] colors;
        str = elem.getAttribute("nodeColorModel");
        Color[] cl = graph.style.getRampColors(str, "TwoColorRamp");
        Element cmElem = StatGraph.getOptionAttrsElement(elem, "NodeColorModel");
        if (cmElem != null && (colors = StatGraph.parseColorValueList(graph, cmElem, "Value")) != null && colors.length > 0) {
            cl = colors.length > 1 ? colors : new Color[]{colors[0], colors[0]};
        }
        str = elem.getAttribute("reverseNodeColorModel");
        boolean reverse = str.equalsIgnoreCase("true");
        Color[] rampColors = new Color[cl.length];
        for (int i = 0; i < cl.length; ++i) {
            int idx = reverse ? cl.length - 1 - i : i;
            rampColors[i] = decisionTree.applyDataTransparency(cl[idx], fa);
        }
        ContinuousRangeToColorMapper colorMapper = new ContinuousRangeToColorMapper();
        double[] values = new double[]{0.0, 0.5, 1.0};
        colorMapper.setColorSpectrumColors(rampColors);
        colorMapper.setColorSpectrumValues(values);
        colorMapper.setReplaceMissingValues(true);
        colorMapper.setMissingReplacement(missingColor);
        return colorMapper;
    }

    static boolean checkNodes(DataModel m, int nodeCol, int parentCol) {
        boolean numericID = m.getColumnClass(nodeCol) == Double.class;
        String[] nodes = m.getColumnAsClassColumn(nodeCol, true);
        ArrayList<String> nodeIDs = new ArrayList<String>();
        for (int i = 0; i < nodes.length; ++i) {
            if (LayoutOverlayParser.isMissing(nodes[i], numericID) || nodeIDs.contains(nodes[i])) continue;
            nodeIDs.add(nodes[i]);
        }
        String[] parents = m.getColumnAsClassColumn(parentCol, true);
        boolean numeric = m.getColumnClass(parentCol) == Double.class;
        int nMissings = 0;
        for (int i = 0; i < nodes.length; ++i) {
            if (LayoutOverlayParser.isMissing(nodes[i], numericID) || nodeIDs.contains(parents[i]) && !LayoutOverlayParser.isMissing(parents[i], numeric) || ++nMissings <= 1) continue;
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "parentnode.txt"));
            return false;
        }
        if (nMissings != 1) {
            StatGraph.printWarning(RB.getStringResource(RB_KEY, "parentnode.txt"));
            return false;
        }
        return true;
    }

    public static RegionContainer parseOverviewRegion(StatGraph graph, Element overviewElem, DecisionTreeRegion decision) {
        if (decision.getCRD().getRowCount() > graph.nodeMax) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "nodemax2.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds(decision.getCRD().getRowCount()))), false);
            return null;
        }
        RegionContainer rc = new RegionContainer();
        DecisionTreeRegion overviewRegion = new DecisionTreeRegion();
        overviewRegion.setOverviewMode(true);
        overviewRegion.setMasterDTree(new WeakReference<DecisionTreeRegion>(decision));
        overviewRegion.setCRD(decision.getCRD());
        if (!overviewElem.hasAttribute("hAlign")) {
            overviewElem.setAttribute("hAlign", "left");
        }
        if (!overviewElem.hasAttribute("vAlign")) {
            overviewElem.setAttribute("vAlign", "top");
        }
        if (!overviewElem.hasAttribute("border")) {
            overviewElem.setAttribute("border", "true");
        }
        GraphComponentParser.load(graph, overviewElem, rc, null);
        if (rc.getUserWidth() < 0 && rc.getUserHeight() < 0 && rc.getAlignmentX() == 0.0f && rc.getAlignmentY() == 0.0f) {
            decision.setOverviewDTree(new WeakReference<DecisionTreeRegion>(overviewRegion));
            String str = overviewElem.getAttribute("overviewAutoSizeScale");
            if (StatGraph.isNumber(str)) {
                decision.setAutoOverviewSizeScale(Double.parseDouble(str));
            }
        }
        if (!overviewElem.hasAttribute("borderAttrs")) {
            overviewElem.setAttribute("borderAttrs", "OverviewBorderLines");
        }
        StatGraph.parseBorderOpts(graph, rc, overviewElem, null);
        FillAttrs fillStyle = new FillAttrs();
        GraphStyle.setDefaultFillStyle(graph, overviewElem.getAttribute("backgroundAttrs"), fillStyle, "OverviewFill");
        fillStyle.setTransparency(1.0);
        Element bgAttrs = StatGraph.getOptionAttrsElement(overviewElem, "BackgroundAttrs");
        if (bgAttrs != null) {
            StatGraph.parseFillAttrs(graph, bgAttrs, fillStyle);
        }
        if (fillStyle.getTransparency() == 1.0) {
            rc.setOpaque(false);
        } else {
            rc.setOpaque(true);
        }
        Color bg = fillStyle.getTransparency() > 0.0 ? Overlay.applyTransparency(fillStyle.getColor(), fillStyle.getTransparency()) : fillStyle.getColor();
        rc.setBackground(bg);
        overviewRegion.setOpaque(false);
        overviewRegion.setNodeFillStyle(decision.getNodeFillStyle());
        overviewRegion.setLinkFillStyle(decision.getLinkFillStyle());
        overviewRegion.setLinkLineStyle(decision.getLinkLineStyle());
        overviewRegion.setNodeOutlineStyle(decision.getNodeOutlineStyle());
        overviewRegion.setLinkType(decision.getLinkType());
        overviewRegion.setNodeColorResponse(decision.getNodeColorResponse());
        overviewRegion.setNodeColorGroup(decision.getNodeColorGroup());
        overviewRegion.setOverviewNodeColorGroup(decision.getOverviewNodeColorGroup());
        overviewRegion.setLinkWidthResponse(decision.getLinkWidthResponse());
        overviewRegion.setDataTransparency(decision.getDataTransparency());
        rc.add(overviewRegion);
        return rc;
    }
}

