/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.AnnoDatasetParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DAMDatasetParser {
    public static final String RB_KEY = "DAttrMapDatasetParser.";
    private static final String DATTRVAR_COLUMN_VARNAME = "VARNAME";
    private static final String DATTRVAR_COLUMN_ATTRID = "ID";
    private static final String INTERNAL_DATTRVAR_PREFIX = "INTERNAL DATTRBVAR: ";

    public static void load(StatGraph graph, Element elem) {
        DataModel m = graph.getData(elem.getAttribute("dAttrMap"));
        if (m == null) {
            return;
        }
        m.setSpecializedData(true);
        DAMDatasetParser.generateDAttrMapStatements(elem, m);
    }

    private static void generateDAttrMapStatements(Element elem, DataModel m) {
        NodeList discreteAttrMapList = elem.getElementsByTagName("DiscreteAttrMap");
        ArrayList<String> existingAttrMap = new ArrayList<String>();
        for (int i = 0; i < discreteAttrMapList.getLength(); ++i) {
            Element da = (Element)discreteAttrMapList.item(i);
            String name = da.getAttribute("name");
            if (existingAttrMap.contains(name)) continue;
            existingAttrMap.add(name);
        }
        Document doc = elem.getOwnerDocument();
        HashMap<String, Element> attrMapID = new HashMap<String, Element>();
        for (int i = 0; i < m.getRowCount(); ++i) {
            Element attrValueElem;
            String policy;
            Element attrMapElem;
            String id = AnnoDatasetParser.getStringValue(m, DATTRVAR_COLUMN_ATTRID, i);
            if (id == null || id.trim().length() == 0 || existingAttrMap.contains(id)) continue;
            if (attrMapID.containsKey(id)) {
                attrMapElem = (Element)attrMapID.get(id);
            } else {
                attrMapElem = doc.createElement("DiscreteAttrMap");
                attrMapID.put(id, attrMapElem);
            }
            attrMapElem.setAttribute("name", id);
            String ignoreCase = AnnoDatasetParser.getStringValue(m, "NOCASE", i);
            if (ignoreCase != null && ignoreCase.trim().length() > 0) {
                attrMapElem.setAttribute("ignoreCase", ignoreCase.trim());
            }
            if ((policy = AnnoDatasetParser.getStringValue(m, "SHOW", i)) != null && policy.trim().length() > 0) {
                attrMapElem.setAttribute("discreteLegendEntryPolicy", policy.trim());
            }
            if ((attrValueElem = DAMDatasetParser.createAttrValueElem(doc, m, i)) == null) continue;
            attrMapElem.appendChild(attrValueElem);
        }
        for (Element attrMapElem : attrMapID.values()) {
            elem.appendChild(attrMapElem);
        }
    }

    private static Element createAttrValueElem(Document doc, DataModel m, int obs) {
        Element attrValueElem = doc.createElement("AttrValue");
        attrValueElem.setAttribute("_stmt", "value");
        String value = AnnoDatasetParser.getStringValue(m, "VALUE", obs);
        if (value != null && value.equalsIgnoreCase("_OTHER_")) {
            attrValueElem.setAttribute("valueType", "keyword");
            attrValueElem.setAttribute("value", "other");
        } else {
            attrValueElem.setAttribute("valueType", "value");
            Element valsElem = doc.createElement("Values");
            Element valElem = doc.createElement("Value");
            if (value != null) {
                valElem.setTextContent(value);
            }
            valsElem.appendChild(valElem);
            attrValueElem.appendChild(valsElem);
        }
        String msElement = "MARKERSTYLEELEMENT";
        if (m.hasColumn("MARKERSTYLE") && !m.hasColumn("MARKERSTYLEELEMENT")) {
            msElement = "MARKERSTYLE";
        }
        AnnoDatasetParser.setStrAttr(attrValueElem, m, obs, msElement, "markerAttrs");
        String lsElement = "LINESTYLEELEMENT";
        if (m.hasColumn("LINESTYLE") && !m.hasColumn("LINESTYLEELEMENT")) {
            lsElement = "LINESTYLE";
        }
        AnnoDatasetParser.setStrAttr(attrValueElem, m, obs, lsElement, "lineAttrs");
        String fsElement = "FILLSTYLEELEMENT";
        if (m.hasColumn("FILLSTYLE") && !m.hasColumn("FILLSTYLEELEMENT")) {
            fsElement = "FILLSTYLE";
        }
        AnnoDatasetParser.setStrAttr(attrValueElem, m, obs, fsElement, "fillAttrs");
        AnnoDatasetParser.setStrAttr(attrValueElem, m, obs, "TEXTSTYLEELEMENT", "textAttrs");
        AnnoDatasetParser.addAttrBundle(doc, attrValueElem, "MarkerAttrs", new String[]{"MARKERCOLOR", "MARKERSYMBOL", "MARKERSIZE", "MARKERWEIGHT", "MARKERTRANSPARENCY"}, new String[]{"color", "symbol", "size", "weight", "transparency"}, m, obs);
        AnnoDatasetParser.addAttrBundle(doc, attrValueElem, "LineAttrs", new String[]{"LINECOLOR", "LINEPATTERN", "LINETHICKNESS"}, new String[]{"color", "pattern", "thickness"}, m, obs);
        AnnoDatasetParser.addAttrBundle(doc, attrValueElem, "FillAttrs", new String[]{"FILLCOLOR", "FILLTRANSPARENCY"}, new String[]{"color", "transparency"}, m, obs);
        AnnoDatasetParser.addAttrBundle(doc, attrValueElem, "TextAttrs", new String[]{"TEXTCOLOR", "TEXTFONT", "TEXTSIZE", "TEXTSTYLE", "TEXTWEIGHT"}, new String[]{"color", "family", "size", "style", "weight"}, m, obs);
        return attrValueElem;
    }

    private static String toInternalDAttrVar(String varID) {
        return INTERNAL_DATTRVAR_PREFIX + varID;
    }

    public static boolean hasInternalDAttrVar(StatGraph graph, String varID) {
        return graph.hasDiscreteAttrVar(DAMDatasetParser.toInternalDAttrVar(varID));
    }

    public static DiscreteAttrMapper getInternalDAttrMapper(StatGraph graph, String varID) {
        return graph.getDiscreteAttrVar(DAMDatasetParser.toInternalDAttrVar(varID));
    }

    public static void createInternalDAttrVars(StatGraph graph, Element elem) {
        DataModel m = graph.getData(elem.getAttribute("dAttrVars"));
        if (m == null) {
            return;
        }
        for (int i = 0; i < m.getRowCount(); ++i) {
            String attrMapID;
            String varID = AnnoDatasetParser.getStringValue(m, DATTRVAR_COLUMN_VARNAME, i);
            if (varID == null || varID.trim().length() == 0 || DAMDatasetParser.hasInternalDAttrVar(graph, varID) || (attrMapID = AnnoDatasetParser.getStringValue(m, DATTRVAR_COLUMN_ATTRID, i)) == null || attrMapID.trim().length() == 0) continue;
            graph.addDiscreteAttrVar(DAMDatasetParser.toInternalDAttrVar(varID), attrMapID);
        }
    }

    public static void addInternalAttrVar(StatGraph graph, Overlay overlay, String role, String groupingVarID) {
        if (!DAMDatasetParser.hasInternalDAttrVar(graph, groupingVarID)) {
            return;
        }
        overlay.addAttrVar(role, (AttrMapper)DAMDatasetParser.getInternalDAttrMapper(graph, groupingVarID));
    }
}

