/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.MapOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.gtk.render.map.MapObject;
import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import org.w3c.dom.Element;

public final class ChoroMapParser {
    public static MapOverlay load(StatGraph graph, Element elem, MapOverlay layoutMap) {
        MapOverlay map = (MapOverlay)graph.getObjectFromElement(elem);
        if (map == null) {
            map = new MapOverlay();
        }
        return ChoroMapParser.load(graph, map, elem, layoutMap) ? map : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean load(StatGraph graph, MapOverlay mapOverlay, Element elem, MapOverlay layoutMap) {
        Element lineElem;
        graph.addSupportedGraph();
        if (layoutMap == null) {
            return false;
        }
        Element idElem = StatGraph.getOptionAttrsElement(elem, "IDList");
        if (idElem == null) {
            return false;
        }
        String[] mapIDs = StatGraph.parseStringValueList(idElem, "Value");
        String dataName = StatGraph.getDataName(mapIDs[0]);
        DataModel m = graph.getData(dataName);
        RoleColumnMap rcmap = new RoleColumnMap();
        for (int i = 0; i < mapIDs.length; ++i) {
            String varID = StatGraph.getVarID(mapIDs[i]);
            int varcol = m.getColumn(varID);
            if (!StatGraph.checkVariable("ID", m.getColumnLabel(varcol), null, 1, true)) {
                return false;
            }
            rcmap.map(600 + i, varcol);
        }
        String str = elem.getAttribute("colorResponse");
        String responseVarID = StatGraph.getVarID(str);
        if (responseVarID.length() > 0) {
            int rcol = m.getColumn(responseVarID);
            if (!StatGraph.checkVariable("COLORRESPONSE", m.getColumnLabel(rcol), Double.class, 1, true)) return false;
            rcmap.map(2, rcol);
            mapOverlay.addRole("COLORRESPONSE", m.getColumnLabel(rcol));
            str = elem.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                mapOverlay.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
            }
        } else {
            str = elem.getAttribute("colorGroup");
            String cgVarID = StatGraph.getVarID(str);
            if (cgVarID.length() <= 0) return false;
            int cgcol = m.getColumn(cgVarID);
            rcmap.map(107, cgcol);
            mapOverlay.addRole("COLORGROUP", m.getColumnLabel(cgcol));
            str = elem.getAttribute("colorGroupAttrVar");
            if (str.length() > 0) {
                mapOverlay.addAttrVar("COLORGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            } else {
                DAMDatasetParser.addInternalAttrVar(graph, mapOverlay, "COLORGROUP", cgVarID);
            }
        }
        LayoutOverlayParser.parseGraphOpts(graph, elem, mapOverlay);
        LayoutOverlayParser.parseRoleTipStuff(elem, m, rcmap, mapOverlay);
        mapOverlay.setMapDataModel(layoutMap.getMapDataModel());
        mapOverlay.setMapIDVars(layoutMap.getMapIDVars());
        mapOverlay.setMapXVar(layoutMap.getMapXVar());
        mapOverlay.setMapYVar(layoutMap.getMapYVar());
        mapOverlay.setMapSegmentVar(layoutMap.getMapSegmentVar());
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(rcmap);
        mapOverlay.setModel(crd);
        ColorEncoder encoder = ChoroMapParser.parseColorModelOpt(graph, elem, mapOverlay);
        if (encoder != null) {
            mapOverlay.setEncoder((byte)4, encoder);
        }
        MapObject mapObject = mapOverlay.getMapObject();
        boolean fillOn = true;
        boolean edgeOn = true;
        boolean emptyFillOn = false;
        boolean emptyEdgeOn = false;
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                emptyFillOn = true;
                emptyEdgeOn = true;
            } else {
                fillOn = false;
                edgeOn = false;
                emptyFillOn = false;
                emptyEdgeOn = false;
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline")) {
                        edgeOn = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        fillOn = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("emptyoutline")) {
                        emptyEdgeOn = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("emptyfill")) {
                        emptyFillOn = true;
                        continue;
                    }
                    fillOn = true;
                    edgeOn = true;
                    emptyFillOn = false;
                    emptyEdgeOn = false;
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    break;
                }
            }
        }
        FillAttrs fa = new FillAttrs();
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fa, "GraphDataStyleDefault");
        Element fillElem = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        if (fillElem != null) {
            StatGraph.parseFillAttrs(graph, fillElem, fa);
        }
        mapObject.setFillColor(mapOverlay.applyDataTransparency((ColorAttr)fa));
        if (!edgeOn) {
            mapObject.setEdgesOn(false);
        } else {
            mapObject.setEdgesOn(true);
            LineAttrs la = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("outlineAttrs"), la, "Outlines");
            lineElem = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, la);
            }
            mapObject.setEdgeColor(mapOverlay.applyDataTransparency(la.getColor()));
            mapObject.setEdgePattern(la.getLinePattern());
            mapObject.setEdgeThickness(la.getWidth());
        }
        if (!emptyEdgeOn) {
            mapObject.setEmptyEdgesOn(false);
        } else {
            LineAttrs la = new LineAttrs();
            GraphStyle.setDefaultDataLineStyle(graph, elem.getAttribute("emptyOutlineAttrs"), la, "Missing");
            lineElem = StatGraph.getOptionAttrsElement(elem, "EmptyOutlineAttrs");
            if (lineElem != null) {
                StatGraph.parseLineAttrs(graph, lineElem, la);
            }
            mapObject.setEmptyEdgeColor(mapOverlay.applyDataTransparency(la.getColor()));
            mapObject.setEmptyEdgePattern(la.getLinePattern());
            mapObject.setEmptyEdgeThickness(la.getWidth());
        }
        if (!emptyFillOn) {
            mapObject.setEmptyColor(new Color(255, 255, 255, 0));
            return true;
        } else {
            fa = new FillAttrs();
            GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("emptyFillAttrs"), fa, "Missing");
            Element emptyFillElem = StatGraph.getOptionAttrsElement(elem, "EmptyFillAttrs");
            if (emptyFillElem != null) {
                StatGraph.parseFillAttrs(graph, emptyFillElem, fa);
            }
            mapObject.setEmptyColor(mapOverlay.applyDataTransparency((ColorAttr)fa));
        }
        return true;
    }

    public static ColorEncoder parseColorModelOpt(StatGraph graph, Element elem, Overlay overlay) {
        DataRange range = overlay.getDataRange((byte)4);
        ColorEncoder encoder = null;
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            String str = elem.getAttribute("colorModel");
            Color[] ramp = graph.style.getRampColors(str, "TwoColorRamp");
            str = elem.getAttribute("reverseColorModel");
            boolean reverse = str.equalsIgnoreCase("true");
            encoder = reverse ? new ColorEncoder(cr, overlay.applyDataTransparency(ramp[2]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[0])) : new ColorEncoder(cr, overlay.applyDataTransparency(ramp[0]), overlay.applyDataTransparency(ramp[1]), overlay.applyDataTransparency(ramp[2]));
        } else {
            DiscreteRange dr = (DiscreteRange)range;
            HashMap table = new HashMap();
            Enumeration e = ((DiscreteRange)range).getEnumeration();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) continue;
                Color color = graph.style.getNextFillColor();
            }
            encoder = new ColorEncoder(dr, table);
            encoder.colorArray = graph.style.fillColorList;
        }
        return encoder;
    }
}

