/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BubbleOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.text.SASDateTimeFormat;
import java.awt.Color;
import org.w3c.dom.Element;

public class BubbleParser {
    public static final String RB_KEY = "BubbleParser.";

    public static BubbleOverlay load(StatGraph graph, Element elem) {
        BubbleOverlay bubble = (BubbleOverlay)graph.getObjectFromElement(elem);
        if (bubble == null) {
            bubble = new BubbleOverlay();
        }
        return BubbleParser.load(graph, bubble, elem) ? bubble : null;
    }

    public static boolean load(StatGraph graph, BubbleOverlay bubble, Element elem) {
        String indexVarID;
        int indexCol;
        String dataLabelVarID;
        int dataLabelCol;
        String groupVarID;
        String colorResponseVarID;
        int colorResponseCol;
        graph.addSupportedGraph();
        String str = elem.getAttribute("relativeScale");
        if ("false".equalsIgnoreCase(str)) {
            bubble.setRelativeScale(false);
        }
        if ("radius".equalsIgnoreCase(str = elem.getAttribute("scale"))) {
            bubble.setScale(2);
        } else {
            bubble.setScale(1);
        }
        RoleColumnMap map = new RoleColumnMap();
        DataModel model = BubbleParser.parseRequiredVariables(bubble, graph, elem, map);
        if (model == null) {
            return false;
        }
        str = elem.getAttribute("primary");
        bubble.setPrimary(str.equalsIgnoreCase("true"));
        LayoutOverlayParser.parseGraphOpts(graph, elem, bubble);
        StatGraph.parseURLOpt(elem, model, map, bubble);
        str = elem.getAttribute("size");
        String sizeVarID = StatGraph.getVarID(str);
        int sizecol = model.getColumn(sizeVarID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(sizecol);
        double sizeVarMax = cmd.getMax();
        boolean scaleProportional = false;
        String string = str = elem.hasAttribute("relativeScaleType") ? elem.getAttribute("relativeScaleType") : "linear";
        if ("proportional".equalsIgnoreCase(str)) {
            if (sizeVarMax < 0.0) {
                bubble.setRelativeScaleType(1);
                StatGraph.printNote(RB.getStringResource(RB_KEY, "propBubble.txt"));
            } else {
                bubble.setRelativeScaleType(2);
                scaleProportional = true;
            }
        } else if (!"linear".equalsIgnoreCase(str)) {
            StatGraph.printOptionError("RELATIVESCALETYPE", str);
        }
        str = elem.getAttribute("sizeThresholdMax");
        if (str != null && str.length() > 0) {
            double stMax = Double.parseDouble(str);
            if (scaleProportional && (Double.isNaN(stMax) || stMax < 0.0)) {
                StatGraph.printNote(RB.getStringResource(RB_KEY, "sizeThresholdMax.txt"));
            } else {
                bubble.setSizeThresholdMax(stMax);
            }
        }
        if (bubble.getXAxis().equalsIgnoreCase("x2")) {
            bubble.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            bubble.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        if (bubble.getYAxis().equalsIgnoreCase("y2")) {
            bubble.setDiscreteY(LayoutOverlayParser.y2AxisType == 2);
        } else {
            bubble.setDiscreteY(LayoutOverlayParser.yAxisType == 2);
        }
        if (elem.hasAttribute("includeMissingGroup") && "false".equalsIgnoreCase(str = elem.getAttribute("includeMissingGroup"))) {
            bubble.setIncludeMissingGroup(false);
        }
        if (elem.hasAttribute("colorResponse") && StatGraph.checkVariable("colorResponse", model.getColumnLabel(colorResponseCol = model.getColumn(colorResponseVarID = StatGraph.getVarID(str = elem.getAttribute("colorResponse")))), Double.class, 1, false)) {
            map.map(108, colorResponseCol);
            bubble.addRole("COLORRESPONSE", model.getColumnLabel(colorResponseCol));
            str = elem.getAttribute("colorResponseAttrVar");
            if (str.length() > 0) {
                bubble.addAttrVar("COLORRESPONSE", (AttrMapper)graph.getRangeAttrVar(str));
            }
        }
        if (elem.hasAttribute("group") && !LayoutOverlayParser.hasTooManyGroups(graph, model, groupVarID = StatGraph.getVarID(str = elem.getAttribute("group")), bubble.getStmt())) {
            if (StatGraph.isOLAP()) {
                map.map(3, groupVarID);
            } else {
                int groupCol = model.getColumn(groupVarID);
                map.map(3, groupCol);
                bubble.addRole("GROUP", model.getColumnLabel(groupCol));
                str = elem.getAttribute("groupAttrVar");
                if (str.length() > 0) {
                    bubble.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                } else {
                    DAMDatasetParser.addInternalAttrVar(graph, bubble, "GROUP", groupVarID);
                }
            }
            if (graph.isCASData()) {
                bubble.setGroupOrder(1);
                bubble.setDrawByGroupOrder(true);
            }
        }
        if (elem.hasAttribute("dataLabel") && StatGraph.checkVariable("dataLabel", model.getColumnLabel(dataLabelCol = model.getColumn(dataLabelVarID = StatGraph.getVarID(str = elem.getAttribute("dataLabel")))), null, 1, false)) {
            map.map(5, dataLabelCol);
            bubble.addRole("DATALABEL", model.getColumnLabel(dataLabelCol));
        }
        if (elem.hasAttribute("index") && StatGraph.checkVariable("index", model.getColumnLabel(indexCol = model.getColumn(indexVarID = StatGraph.getVarID(str = elem.getAttribute("index")))), Double.class, 2, true, false)) {
            map.map(41, indexCol);
            bubble.addRole("COLORINDEX", model.getColumnLabel(indexCol));
            map.map(43, indexCol);
            bubble.addRole("LINEINDEX", model.getColumnLabel(indexCol));
        }
        if (elem.hasAttribute("dataLabelPosition")) {
            str = elem.getAttribute("dataLabelPosition");
            int position = bubble.getDataLabelPosition();
            if ("TOPLEFT".equalsIgnoreCase(str)) {
                position = 1;
            } else if ("TOP".equalsIgnoreCase(str)) {
                position = 2;
            } else if ("TOP_RIGHT".equalsIgnoreCase(str)) {
                position = 3;
            } else if ("LEFT".equalsIgnoreCase(str)) {
                position = 4;
            } else if ("CENTER".equalsIgnoreCase(str)) {
                position = 5;
            } else if ("RIGHT".equalsIgnoreCase(str)) {
                position = 6;
            } else if ("BOTTOMLEFT".equalsIgnoreCase(str)) {
                position = 7;
            } else if ("BOTTOM".equalsIgnoreCase(str)) {
                position = 8;
            } else if ("BOTTOMRIGHT".equalsIgnoreCase(str)) {
                position = 9;
            }
            bubble.setDataLabelPosition(position);
        }
        ScatterParser.parseDataLabelSplitting(bubble, elem);
        String contextName = graph.style.getContextName();
        bubble.setContextName(contextName);
        MarkerAttrs ma = new MarkerAttrs();
        GraphStyle.setDefaultMarkerStyle(graph, null, ma, contextName);
        double sizeMin = ma.getSize();
        double sizeMax = 3.0 * sizeMin;
        double bubbleSizeMin = sizeMin;
        double bubbleSizeMax = sizeMax;
        if (elem.hasAttribute("bubbleRadiusMin") && StatGraph.isNumber(str = elem.getAttribute("bubbleRadiusMin"))) {
            bubbleSizeMin = graph.unit2MarkerSize(str);
        }
        if (elem.hasAttribute("bubbleRadiusMax") && StatGraph.isNumber(str = elem.getAttribute("bubbleRadiusMax"))) {
            bubbleSizeMax = graph.unit2MarkerSize(str);
        }
        if (bubbleSizeMin < bubbleSizeMax) {
            bubble.setMinBubbleSize(bubbleSizeMin);
            bubble.setMaxBubbleSize(bubbleSizeMax);
        } else {
            bubble.setMinBubbleSize(sizeMin);
            bubble.setMaxBubbleSize(sizeMax);
            StatGraph.printNote(RB.getStringResource(RB_KEY, "mmbubble.txt"));
        }
        if (elem.hasAttribute("drawOrder")) {
            str = elem.getAttribute("drawOrder");
            if (str.equalsIgnoreCase("size")) {
                bubble.setDrawingOrder(0);
            } else if (str.equalsIgnoreCase("data")) {
                bubble.setDrawingOrder(1);
            } else {
                StatGraph.printOptionError("DRAWORDER", str);
            }
        }
        if (elem.hasAttribute("display")) {
            boolean error = false;
            str = elem.getAttribute("display");
            if (!str.equalsIgnoreCase("standard") && !str.equalsIgnoreCase("all")) {
                String[] opts = StatGraph.parseList2String(str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("outline") || opts[i].equalsIgnoreCase("fill") || opts[i].equalsIgnoreCase("fillpattern")) continue;
                    StatGraph.printOptionError("DISPLAY", opts[i]);
                    error = true;
                    break;
                }
            }
            if (!error) {
                bubble.setDisplayMode(elem.getAttribute("display"));
            }
        }
        FillAttrs fillAttrs = bubble.getFillAttrs();
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), fillAttrs, contextName);
        Element fe = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        if (fe != null) {
            StatGraph.parseFillAttrs(graph, fe, fillAttrs);
        }
        bubble.setFillAttrs(fillAttrs);
        if (elem.hasAttribute("fillAttrs") || fe != null && fe.hasAttribute("color")) {
            bubble.setFillColorOverride(true);
        }
        bubble.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fe));
        LineAttrs outlineAttrs = bubble.getOutlineAttrs();
        if (graph.style.isCycleAttrs()) {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), outlineAttrs, contextName);
        } else {
            GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), outlineAttrs, "Outlines");
        }
        Element le = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
        if (le != null) {
            StatGraph.parseLineAttrs(graph, le, outlineAttrs);
        }
        bubble.setOutlineAttrs(outlineAttrs);
        if (elem.hasAttribute("outlineAttrs") || le != null && le.hasAttribute("color")) {
            bubble.setOutlineColorOverride(true);
        }
        if (elem.hasAttribute("outlineAttrs") || le != null && le.hasAttribute("pattern")) {
            bubble.setOutlinePatternOverride(true);
        }
        bubble.setUseLineThickness(StatGraph.isBundleAttributeFixed(elem, "outlineAttrs", "thickness"));
        FillPatternAttrs fillPatternAttrs = bubble.getFillPatternAttrs();
        GraphStyle.setDefaultFillPatternStyle(graph, elem.getAttribute("fillPatternAttrs"), fillPatternAttrs, contextName);
        Element fpe = StatGraph.getOptionAttrsElement(elem, "FillPatternAttrs");
        if (fpe != null) {
            StatGraph.parseFillPatternAttrs(graph, fpe, fillPatternAttrs);
        }
        bubble.setFillPatternAttrs(fillPatternAttrs);
        if (elem.hasAttribute("fillPatternAttrs") || fpe != null && fpe.hasAttribute("pattern")) {
            bubble.setFillPatternOverride(true);
        }
        if (elem.hasAttribute("fillPatternAttrs") || fpe != null && fpe.hasAttribute("color")) {
            bubble.setFillPatternColorOverride(true);
        }
        TextAttrs dataLabelAttrs = bubble.getDataLabelAttrs();
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("dataLabelAttrs"), dataLabelAttrs, "DataText");
        Element labelElem = StatGraph.getOptionAttrsElement(elem, "DataLabelAttrs");
        if (labelElem != null) {
            StatGraph.parseTextAttrs(graph, labelElem, dataLabelAttrs);
        }
        if (elem.hasAttribute("dataLabelAttrs") || labelElem != null && labelElem.hasAttribute("color")) {
            bubble.setDataLabelColorOverride(true);
        }
        StatGraph.parseDataSkinOpt(graph, elem, bubble);
        LayoutOverlayParser.parseRoleTipStuff(elem, model, map, bubble);
        CRD crd = new CRD();
        crd.setSrcModel(model);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, bubble);
        str = elem.getAttribute("dataSelectable");
        if (str.equalsIgnoreCase("true")) {
            bubble.setDataSelectable(true);
        }
        if (bubble.isTooltipEnabled()) {
            bubble.setTooltipEnabled(graph.updateTipMax(model.getRowCount()));
        }
        bubble.setModel(crd);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(108)) {
            byte dim = bubble.isFilled() ? (byte)4 : 17;
            ColorEncoder encoder = null;
            encoder = bubble.isFilled() && fillAttrs != null && fillAttrs.getTransparency() >= 0.0 ? StatGraph.parseColorModelOpt(dim, graph, elem, bubble, fillAttrs.getTransparency()) : StatGraph.parseColorModelOpt(dim, graph, elem, bubble);
            if (encoder != null) {
                bubble.setEncoder(dim, encoder);
            }
            Color missingColor = bubble.isFilled() ? graph.style.getGraphStyle().getDataStyleElement("Missing").getFillColor() : graph.style.getGraphStyle().getDataStyleElement("Missing").getContrastColor();
            bubble.setMissingColorResponseColor(missingColor);
            if (crd.isAvailable(3) && bubble.isFillPatterned()) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)21, (short)3);
            }
        } else if (crd.isAvailable(3)) {
            if (bubble.isFilled()) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)4, (short)3);
                int contrastColorCnt = graph.style.getContrastColorCount();
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)17, (short)3);
                if (bubble.isFillPatterned()) {
                    graph.style.setContrastColorCount(contrastColorCnt);
                    graph.style.setContextCount(contextCount);
                    LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)22, (short)3);
                }
            } else {
                int contrastColorCnt = graph.style.getContrastColorCount();
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)17, (short)3);
                if (bubble.isFillPatterned()) {
                    graph.style.setContrastColorCount(contrastColorCnt);
                    graph.style.setContextCount(contextCount);
                    LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)22, (short)3);
                } else {
                    graph.style.setContextCount(contextCount);
                    LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)15, (short)3);
                }
            }
            if (bubble.isFillPatterned()) {
                graph.style.setContextCount(contextCount);
                LayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)bubble, (byte)21, (short)3);
            }
        }
        if (LayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    public static DataModel parseRequiredVariables(BubbleOverlay bubble, StatGraph graph, Element elem, RoleColumnMap map) {
        boolean sizeValid;
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("size");
        String sizeVarID = StatGraph.getVarID(str);
        DataModel model = graph.getOLAPModel(dataName);
        if (model != null) {
            map.map(10, xVarID);
            map.map(11, yVarID);
            map.map(7, sizeVarID);
            return model;
        }
        model = graph.getData(dataName);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        int sizecol = model.getColumn(sizeVarID);
        boolean bl = sizeValid = bubble.isRelativeScale() ? StatGraph.checkVariable("SIZE", model.getColumnLabel(sizecol), Double.class, 1, true) : StatGraph.checkVariable("SIZE", model.getColumnLabel(sizecol), Double.class, 1, false, 1, true);
        if (!(StatGraph.checkVariable("X", model.getColumnLabel(xcol), null, 1, true) && StatGraph.checkVariable("Y", model.getColumnLabel(ycol), null, 1, true) && sizeValid)) {
            return null;
        }
        map.map(10, xcol);
        map.map(11, ycol);
        map.map(7, sizecol);
        bubble.addRole("X", model.getColumnLabel(xcol));
        bubble.addRole("Y", model.getColumnLabel(ycol));
        bubble.addRole("SIZE", model.getColumnLabel(sizecol));
        return model;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int heightColumnIndex;
        ColumnMetadata cmd;
        int[] types = new int[3];
        String attributeValue = elem.getAttribute("size");
        String dataName = StatGraph.getDataName(attributeValue);
        DataModel model = graph.getData(dataName);
        if (model == null) {
            types[0] = 0;
            types[1] = 0;
            types[2] = 0;
            return types;
        }
        String sizeVarID = StatGraph.getVarID(attributeValue);
        if (sizeVarID.length() > 0 && (cmd = (ColumnMetadata)model.getColumnLabel(heightColumnIndex = model.getColumn(sizeVarID))).getType() == 2) {
            return null;
        }
        String str = elem.getAttribute("x");
        dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID(str);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        ColumnMetadata cmd2 = (ColumnMetadata)model.getColumnLabel(xcol);
        if (cmd2.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, xVarID)) {
                return null;
            }
            types[0] = 2;
        } else {
            types[0] = cmd2.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        cmd2 = (ColumnMetadata)model.getColumnLabel(ycol);
        if (cmd2.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, model, yVarID)) {
                return null;
            }
            types[1] = 2;
        } else {
            types[1] = cmd2.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        types[2] = 0;
        return types;
    }
}

