/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.DAMDatasetParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.text.SASDateTimeFormat;
import java.awt.Color;
import org.w3c.dom.Element;

public final class BlockParser {
    public static final String RB_KEY = "BlockParser.";

    public static BlockOverlay load(StatGraph graph, Element elem) {
        BlockOverlay block = (BlockOverlay)graph.getObjectFromElement(elem);
        if (block == null) {
            block = new BlockOverlay();
        }
        return BlockParser.load(graph, block, elem) ? block : null;
    }

    public static boolean load(StatGraph graph, BlockOverlay block, Element elem) {
        int i;
        String groupVarID;
        String indexVarID;
        int icol;
        graph.addSupportedGraph();
        LayoutOverlayParser.parseGraphOpts(graph, elem, block);
        if (block.getXAxis().equalsIgnoreCase("x2")) {
            block.setDiscreteX(LayoutOverlayParser.x2AxisType == 2);
        } else {
            block.setDiscreteX(LayoutOverlayParser.xAxisType == 2);
        }
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        String xVarID = StatGraph.getVarID(str);
        str = elem.getAttribute("block");
        String labelVarID = StatGraph.getVarID(str);
        DataModel m = graph.getData(dataName);
        RoleColumnMap map = new RoleColumnMap();
        int xcol = m.getColumn(xVarID);
        if (!StatGraph.checkVariable("X", m.getColumnLabel(xcol), null, 1, true)) {
            graph.removeNamedGraph(block);
            return false;
        }
        map.map(10, xcol);
        block.addRole("X", m.getColumnLabel(xcol));
        int lcol = m.getColumn(labelVarID);
        map.map(5, lcol);
        if (!StatGraph.checkVariable("BLOCK", m.getColumnLabel(lcol), null, 1, true)) {
            graph.removeNamedGraph(block);
            return false;
        }
        block.addRole("BLOCK", m.getColumnLabel(lcol));
        str = elem.getAttribute("blockAttrVar");
        if (str.length() > 0) {
            block.addAttrVar("BLOCK", (AttrMapper)graph.getDiscreteAttrVar(str));
        } else {
            DAMDatasetParser.addInternalAttrVar(graph, block, "BLOCK", labelVarID);
        }
        str = elem.getAttribute("blockIndex");
        if (str.length() > 0 && StatGraph.checkVariable("BLOCKINDEX", m.getColumnLabel(icol = m.getColumn(indexVarID = StatGraph.getVarID(str))), Double.class, 2, true, false) && ScatterParser.checkIndexColumn(m, icol, "BLOCKINDEX", indexVarID)) {
            map.map(44, icol);
            block.addRole("BLOCKINDEX", m.getColumnLabel(icol));
        }
        if ((str = elem.getAttribute("class")).length() > 0 && !LayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID = StatGraph.getVarID(str), block.getStmt())) {
            int gcol = m.getColumn(groupVarID);
            map.map(3, gcol);
            block.addRole("GROUP", m.getColumnLabel(gcol));
            if (elem.getParentNode().getNodeName().equals("LayoutPrototype")) {
                block.setUniformPlotSize(true);
            } else if (elem.getParentNode().getParentNode().getNodeName().equals("LayoutPrototype")) {
                block.setUniformPlotSize(true);
            }
            if (graph.isCASData()) {
                block.setClassOrder(1);
            }
        }
        if ((str = elem.getAttribute("blockLabel")).length() > 0) {
            String blockLabelVarID = StatGraph.getVarID(str);
            if (StatGraph.checkVariable("BLOCKLABEL", m.getColumnLabel(lcol), null, 0, false)) {
                int blcol = m.getColumn(blockLabelVarID);
                map.map(23, blcol);
                block.addRole("BLOCKLABGEL", m.getColumnLabel(blcol));
            }
        }
        if (graph.isCASData()) {
            block.setBlockOrder(1);
            block.setSortXValues(true);
        }
        StatGraph.parseURLOpt(elem, m, map, block);
        LayoutOverlayParser.parseRoleTipStuff(elem, m, map, block);
        str = elem.getAttribute("includeMissingClass");
        if (str.length() > 0 && str.equalsIgnoreCase("false")) {
            block.setMissingGroupOn(false);
        }
        if ((str = elem.getAttribute("extendBlockOnMissing")).length() > 0 && str.equalsIgnoreCase("true")) {
            block.setMissingBreak(false);
        }
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere(graph, crd, block);
        block.setModel(crd);
        str = elem.getAttribute("display");
        if (str.length() == 0 || str.equalsIgnoreCase("STANDARD") || str.equalsIgnoreCase("ALL")) {
            block.setFillOn(true);
            block.setEdgeOn(true);
            block.setValueOn(true);
            block.setLabelOn(true);
        } else {
            block.setFillOn(false);
            block.setEdgeOn(false);
            block.setValueOn(false);
            block.setLabelOn(false);
            String[] opts = StatGraph.parseList2String(str);
            for (i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    block.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    block.setFillOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("values")) {
                    block.setValueOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("label")) {
                    block.setLabelOn(true);
                    continue;
                }
                block.setFillOn(true);
                block.setEdgeOn(true);
                block.setValueOn(true);
                block.setLabelOn(true);
                StatGraph.printOptionError("DISPLAY", opts[i]);
                break;
            }
        }
        str = elem.getAttribute("valueFitPolicy");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("SHRINK")) {
                block.setValueFitStrategy(1);
            } else if (str.equalsIgnoreCase("TRUNCATE")) {
                block.setValueFitStrategy(0);
            } else if (str.equalsIgnoreCase("SPLIT")) {
                block.setValueFitStrategy(2);
            } else if (str.equalsIgnoreCase("SPLITALWAYS")) {
                block.setValueFitStrategy(3);
            } else if (str.equalsIgnoreCase("NONE")) {
                block.setValueFitStrategy(4);
            } else {
                block.setValueFitStrategy(0);
                StatGraph.printOptionError("VALUEFITPOLICY", str);
            }
        } else {
            block.setValueFitStrategy(0);
        }
        str = elem.getAttribute("valueSplitChar");
        if (str.length() > 0) {
            char[] schars = new char[str.length()];
            for (i = 0; i < str.length(); ++i) {
                schars[i] = str.charAt(i);
            }
            block.setValueSplitChar(schars);
        }
        if ((str = elem.getAttribute("valueSplitCharDrop")).length() > 0 && str.equalsIgnoreCase("false")) {
            block.setValueSplitCharDrop(false);
        }
        if ((str = elem.getAttribute("repeatedValues")).equalsIgnoreCase("true")) {
            block.setRepeatValue(true);
        }
        if ((str = elem.getAttribute("label")).length() > 0) {
            block.setLabel(str);
        }
        if ((str = elem.getAttribute("labelPosition")).equalsIgnoreCase("TOP")) {
            block.setLabelPosition(0);
        } else if (str.equalsIgnoreCase("BOTTOM")) {
            block.setLabelPosition(1);
        } else if (str.equalsIgnoreCase("LEFT")) {
            block.setLabelPosition(2);
        } else if (str.equalsIgnoreCase("RIGHT")) {
            block.setLabelPosition(3);
        } else {
            block.setLabelPosition(2);
            if (str.length() > 0) {
                StatGraph.printOptionError("LABELPOSITION", str);
            }
        }
        str = elem.getAttribute("valueHAlign");
        if (str.equalsIgnoreCase("RIGHT")) {
            block.setValueHAlign(2);
        } else if (str.equalsIgnoreCase("CENTER")) {
            block.setValueHAlign(1);
        } else if (str.equalsIgnoreCase("START")) {
            block.setValueHAlign(10);
        } else if (str.equalsIgnoreCase("LEFT")) {
            block.setValueHAlign(0);
        } else {
            block.setValueHAlign(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("VALUEHALIGN", str);
            }
        }
        str = elem.getAttribute("valueVAlign");
        if (str.equalsIgnoreCase("TOP")) {
            block.setValueVAlign(0);
        } else if (str.equalsIgnoreCase("BOTTOM")) {
            block.setValueVAlign(3);
        } else if (str.equalsIgnoreCase("CENTER")) {
            block.setValueVAlign(1);
        } else {
            block.setValueVAlign(1);
            if (str.length() > 0) {
                StatGraph.printOptionError("VALUEVALIGN", str);
            }
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("valueAttrs"), block.getValueStyle(), "ValueText");
        Element valAttrs = StatGraph.getOptionAttrsElement(elem, "ValueAttrs");
        if (valAttrs != null) {
            StatGraph.parseTextAttrs(graph, valAttrs, block.getValueStyle());
        }
        GraphStyle.setDefaultTextStyle(graph, elem.getAttribute("labelAttrs"), block.getLabelStyle(), "LabelText");
        Element varAttrs = StatGraph.getOptionAttrsElement(elem, "LabelAttrs");
        if (varAttrs != null) {
            StatGraph.parseTextAttrs(graph, varAttrs, block.getLabelStyle());
        }
        if ((str = elem.getAttribute("fillType")).equalsIgnoreCase("ALTERNATE")) {
            block.setFillType(1);
        } else if (str.equalsIgnoreCase("MULTICOLOR")) {
            block.setFillType(0);
        } else {
            block.setFillType(0);
            if (str.length() > 0) {
                StatGraph.printOptionError("FILLTYPE", str);
            }
        }
        GraphStyle.setDefaultDataFillStyle(graph, elem.getAttribute("fillAttrs"), block.getFillStyle(), "Block");
        Element fillAttrs = StatGraph.getOptionAttrsElement(elem, "FillAttrs");
        if (fillAttrs != null) {
            StatGraph.parseFillAttrs(graph, fillAttrs, block.getFillStyle());
        }
        GraphStyle.setDefaultFillStyle(graph, elem.getAttribute("altFillAttrs"), block.getAltFillStyle(), "AltBlock");
        Element altFillAttrs = StatGraph.getOptionAttrsElement(elem, "AltFillAttrs");
        if (altFillAttrs != null) {
            StatGraph.parseFillAttrs(graph, altFillAttrs, block.getAltFillStyle());
        }
        block.setUseFillTransparency(StatGraph.isTransparencyFixed(elem, fillAttrs));
        GraphStyle.setDefaultLineStyle(graph, elem.getAttribute("outlineAttrs"), block.getLineStyle(), "Outlines");
        Element outlineAttrs = StatGraph.getOptionAttrsElement(elem, "OutlineAttrs");
        if (outlineAttrs != null) {
            StatGraph.parseLineAttrs(graph, outlineAttrs, block.getLineStyle());
        }
        if (block.getFillType() == 0) {
            graph.style.recordCurrentCounters();
            String[] vals = block.getRawUniqueValues((short)5);
            if (vals != null && vals.length > 0) {
                Color[] colors = new Color[vals.length];
                for (int i2 = 0; i2 < colors.length; ++i2) {
                    colors[i2] = graph.style.getGroupNextFillColor();
                }
                block.colorList = colors;
            } else {
                block.colorList = graph.style.fillColorList;
            }
            graph.style.resetToCurrentCounters();
        } else {
            block.colorList = graph.style.fillColorList;
        }
        DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
        if (missingElem == null) {
            missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault");
        }
        block.missingColor = missingElem.getDefaultColor();
        return true;
    }

    protected static int[] getVariableTypes(StatGraph graph, Element elem) {
        int type;
        String xVarID;
        int xcol;
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName(str);
        DataModel m = graph.getData(dataName);
        ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(xcol = m.getColumn(xVarID = StatGraph.getVarID(str)));
        if (cmd.getType() == 2) {
            if (LayoutOverlayParser.hasTooManyCategories(graph, m, xVarID)) {
                return null;
            }
            type = 2;
        } else {
            type = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        types[0] = type;
        types[1] = -1;
        types[2] = 0;
        return types;
    }
}

